#include "g_local.h"

// bot's being injured, react
void bPain(edict_t *bot, edict_t *other, float kickback, int damage) 
{
	vec3_t v1, v2;
	
	if (!G_ClientInGame(other)) return;
	
	if (!other->takedamage) return;
	
	// No enemy? Attacker becomes enemy.
	if (!bot->enemy) 
	{
		bot->enemy = other;
		return; 
	}
	
	// Already have an enemy! Who is closest?
	VectorSubtract(bot->s.origin, bot->enemy->s.origin, v1);
	VectorSubtract(bot->s.origin, other->s.origin, v2);
	
	// If 'other' closer then new enemy..
	if (VectorLength(v2) < VectorLength(v1))
		bot->enemy=other;
}

void bTouch(edict_t *bot, edict_t *other, cplane_t *plane, csurface_t *surf)
{}

void Bot_Respawn(edict_t *self)
{
	if (self->movetype != MOVETYPE_NOCLIP)
		CopyToBodyQue (self);

	self->svflags &= ~SVF_NOCLIENT;
	Bot_Spawn(self);

	// add a teleportation effect
	self->s.event = EV_PLAYER_TELEPORT;

	// hold in place briefly
	self->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
	self->client->ps.pmove.pm_time = 14;

	self->client->respawn_time = level.time;

	return;
}