#include "g_local.h"

// super-fast visible function
qboolean visible2(edict_t *self, edict_t *other) 
{
	return (gi.inPVS(self->s.origin, other->s.origin)
		&& gi.trace(self->s.origin, NULL, NULL, other->s.origin, 
		NULL, MASK_OPAQUE).fraction == 1.0);
}

// bDistance, a quick VectorSubtract frontend
float bDistance(vec3_t spot1, vec3_t spot2)
{
	vec3_t result;
	float distance = 0;

	VectorSubtract(spot1, spot2, result);
	distance = VectorLength(result);

	return distance;
}

// wVisible - checks visibility between points, for waypoint visibility
qboolean wVisible (vec3_t spot1, vec3_t spot2)
{
	trace_t tr;

	tr = gi.trace (spot1, vec3_origin, vec3_origin, spot2, NULL, (MASK_OPAQUE|CONTENTS_WINDOW));

	if (tr.fraction == 1.0)
		return true;
	else
		return false;
}

//===================================================
// new gi.Xprintf functions to not print to bots
void gi_cprintf(edict_t *ent, int printlevel, char *fmt, ...) 
{
	char bigbuffer[0x10000];
	va_list argptr;
	int len;
	
	if (!ent || !ent->inuse || !ent->client)
		return;
	
	if ent_isabot
		return;

	va_start(argptr,fmt);
	len = vsprintf(bigbuffer,fmt,argptr);
	va_end(argptr);
	
	gi.cprintf(ent, printlevel, bigbuffer);
}

//===================================================
void gi_centerprintf(edict_t *ent, char *fmt, ...) 
{
	char bigbuffer[0x10000];
	va_list argptr;
	int len;
	
	if (!ent || !ent->inuse || !ent->client)
		return;

	if ent_isabot
		return;
	
	va_start(argptr,fmt);
	len = vsprintf(bigbuffer,fmt,argptr);
	va_end(argptr);
	
	gi.centerprintf(ent, bigbuffer);
}

//===================================================
void gi_bprintf(int printlevel, char *fmt, ...) 
{
	char bigbuffer[0x10000];
	int i, len;
	va_list argptr;
	edict_t *ent;
	
	va_start(argptr,fmt);
	len = vsprintf(bigbuffer,fmt,argptr);
	va_end(argptr);
	
	if (dedicated->value)
		gi_cprintf(NULL, printlevel, bigbuffer);
	
	for (i=0; i<game.maxclients; i++) 
	{
		ent=g_edicts+1+i;

		// PSY: save cpu cycles
		if ent_isabot
			continue;

		gi_cprintf(ent, printlevel, bigbuffer); 
	}
}

//======================================================
// True if Ent is valid, has client, and edict_t inuse.
//======================================================
qboolean G_EntExists(edict_t *ent) 
{
	return ((ent) && (ent->client) && (ent->inuse));
}

//======================================================
// True if ent is not DEAD or DEAD or DEAD (and BURIED!)
//======================================================
qboolean G_ClientNotDead(edict_t *ent) 
{
	qboolean buried=true;
	qboolean b1=ent->client->ps.pmove.pm_type!=PM_DEAD;
	qboolean b2=ent->deadflag != DEAD_DEAD;
	qboolean b3=ent->health > 0;
	return ((b3 || b2 || b1) && buried);
}

//======================================================
// True if ent is not DEAD and not just did a Respawn.
//======================================================
qboolean G_ClientInGame(edict_t *ent) 
{
	if (!G_EntExists(ent)) return false;
	if (!G_ClientNotDead(ent)) return false;
	return (ent->client->respawn_time + 5.0 < level.time);
}