#include "g_local.h"

// fire at the enemy, or follow him
qboolean bAttack(edict_t *bot, usercmd_t *cmd, vec3_t cmd_angles) 
{
	vec3_t v;
	float dist;
	trace_t tr;
	
	// check if he's in lava or gone
	if (!G_ClientInGame(bot->enemy)
		|| (gi.pointcontents(bot->enemy->s.origin) & (CONTENTS_LAVA|CONTENTS_SLIME))) 
	{
		// didn't attack, free the rest of the AI
		return false; 
	}

	// if he's not visible, skip all the rest of this stuff, and get the hell outta here
	if (!visible(bot, bot->enemy))
	{
		bMoveToEnemy(bot, cmd, cmd_angles);
		return true; // we did something so go true here
	}

	// if he's NOT infront then face him
	if (!infront(bot,bot->enemy))
		bFace(bot, bot->enemy, cmd_angles);
	
	if (!infront(bot, bot->enemy)) 
	{
		// STILL not infront after we faced him, go after him
		bMoveToEnemy(bot, cmd, cmd_angles);
		return true; // we did something so go true here
	}
	
	// how far away is this enemy?
	VectorSubtract(bot->enemy->s.origin, bot->s.origin, v);
	dist=VectorLength(v);
	
	// check for weapon, and add weapon timer
	if (level.time > bot->weap_delay) 
	{
		if (dist > 700)
			GetFarWeapon(bot);
		else if (dist < 160)
			GetCloseWeapon(bot);
		else
			GetBestWeapon(bot);
		bot->weap_delay = level.time + 5;
	}

	// Fire ONLY at visible enemies..
	// PSY: upgraded 2-3: do a full bbox trace here to ensure the bot doesn't look
	// like an idiot - firing where he can't reach, or firing just around a corner.
	// this is mostly a player behavior issue, a bot could fire like this, and hit his
	// target, but real players won't
	tr = gi.trace(bot->s.origin, bot->mins, bot->maxs, bot->enemy->s.origin, bot, MASK_SOLID);

	// fire if we hit him
	// PSY: upgraded 2-12: check for tr.ent here to make DAMN sure
	// PSY: un-upgraded 2-16: turns out tr.ent isn't totally reliable (?)
	if (tr.fraction == 1.0)
	{
		if (rand()%10<7)
		{
			// FIXME: implement a bot->fire_delay, check for how long that should
			// be for each weapon, so we have an actually accurate firing time
			cmd->buttons |= BUTTON_ATTACK;
			bot->attacked = true;
		}
		else if (rand()%10>9)
		{
			// PSY: fixes the "bot always trying to get up in my face" bug, so that he
			// will only run if > than 160 units away and then only 30% of the remaining
			// time
			bot->attacked = true;
		}
	}
	
	// update length
	VectorSubtract(bot->enemy->s.origin, bot->s.origin, v);
	dist=VectorLength(v);

	// only run when far away (seems not to work sometimes??) and if we havent fired
	// PSY: upgraded this distance to 300, to again prevent the bot in your face bug
	if (dist > 300 && !bot->attacked)
		if (bCanMove(bot,steplen,bFORWARD))
			return bRun(bot,cmd,bFORWARD);
	
	if (bot->attacked == true) // we attacked this frame, so return success
	{
		// clear this var
		bot->attacked = false;
		return true;
	}

	// else if not, we didn't fire, so go ahead and run other ai functions
	bot->attacked = false; // PSY: go ahead and reset this for safety
	return false;
}


// find us an enemy
edict_t *bSeekEnemy(edict_t *bot) 
{
	edict_t *ent=NULL, *best_ent=NULL;
	float this_dist=0, best_dist=99999;
	int i;
	
	// Have we already got an enemy?
	if (G_ClientInGame(bot->enemy)) // still alive?
		if (gi.inPVS(bot->s.origin, bot->enemy->s.origin) || gi.inPHS(bot->s.origin, bot->enemy->s.origin)) 
		{
			// we can either hear him or see him, so keep this enemy
			return bot->enemy;
		}
		
	for(i=0;i < game.maxclients;i++) 
	{
		ent=g_edicts+i+1;

		if (!G_ClientInGame(ent)) continue; // alive?
		if (!ent->takedamage) continue; // damageable?
		if (ent==bot) continue; // don't suicide
		if (!visible(bot,ent)) continue; // visible?
		// Ignore the poor bastards in Lava/Slime
		if (gi.pointcontents(ent->s.origin) & (CONTENTS_LAVA|CONTENTS_SLIME)) continue;

		this_dist=G_Distance(bot, ent);

		if (this_dist > 2000) // PSY: upgraded this distance to 2000
			continue;
		if (this_dist < best_dist) 
		{
			best_dist = this_dist;
			best_ent = ent; 
		}
	}
	
	return best_ent;
}
