#include "g_local.h"

qboolean bNeedItem(edict_t *bot);

// is bot on a platform?
qboolean bOnPlatform(edict_t *ent) 
{
	// simple check for groundentity use on Use_Plat
	if (ent->groundentity)
		if (ent->groundentity->use == Use_Plat)
			return true;

	return false;
}

// is bot touching a ladder?
qboolean bTouchingLadder(edict_t *bot) 
{
	vec3_t forward, end;
	trace_t tr;
	
	if (bot->maxs[2] == 4)
		return false;
	
	AngleVectors(bot->s.angles, forward, NULL, NULL);
	VectorMA(bot->s.origin, 4, forward, end);

	// throw a bbox trace forward 4 units and check for contents & CONTENTS_LADDER
	tr = gi.trace(bot->s.origin, bot->mins, bot->maxs, end, bot, MASK_SHOT);

	if (tr.contents & CONTENTS_LADDER)
		return true;

	return false;
}

// can bot stand up at present location?
qboolean bCanStand(edict_t *bot) 
{
	vec3_t point;

	// PSY: modified - remove calls to tv();
	VectorSet(point, bot->s.origin[0], bot->s.origin[1], (bot->s.origin[2] + bot->viewheight));

	// is the bot crouching now? if not, return
	if (!bot->maxs[2]==4) 
		return true;
	
	if (gi.pointcontents(point) & MASK_SOLID)
		return false;
	
	return true;
}

// is bot under deep water?
qboolean bCanDrown(edict_t *bot) 
{
	// simple check on waterlevel
	if (bot->waterlevel >= 3)
		return true;

	return false;
}

// can bot take a step of dist units in direction yaw?
qboolean bCanStep(edict_t *bot, float yaw, float dist, vec3_t cmd_angles) 
{
	vec3_t start, forward, up, end1, end2, tangle;
	vec3_t lmins;
	vec3_t lmaxs;
	vec3_t finmins;
	vec3_t finmaxs;
	vec3_t oldorg, neworg;
	trace_t tr;
	trace_t trace;
	vec3_t end, test;
	float step;
	qboolean endset = false;
	int contents;

	// change up the yaw
	bot->ideal_yaw=yaw;
	bChangeYaw(bot, cmd_angles);

	// PSY: again - get rid of calls to tv();
	VectorSet(lmins, bot->mins[0], bot->mins[1], -250);
	VectorSet(lmaxs, bot->maxs[0], bot->maxs[1], 250);
	VectorSet(finmins, -8, -8, -8);
	VectorSet(finmaxs, 8, 8, 8);

	// Ensure minimum steplentgh, and add it if it's not there add it
	step = (dist < 24) ? dist : 24;
	
	// do some math so we can add a YAW value into a regular (non-angles) vec3_t
	yaw = yaw*M_PI*2 / 360;
	
	tangle[0] = cos(yaw)*dist;
	tangle[1] = sin(yaw)*dist;
	tangle[2] = 0;
	
	// try the move	- id software's m_move.c code here (PSY: I think this is a better test)
	VectorCopy (bot->s.origin, oldorg);
	VectorAdd (bot->s.origin, tangle, neworg);

	neworg[2] += 18;
	VectorCopy (neworg, end);
	end[2] -= 36;

	trace = gi.trace (neworg, bot->mins, bot->maxs, end, bot, MASK_PLAYERSOLID);

	if (trace.allsolid)
		return false;

	if (trace.startsolid)
	{
		neworg[2] -= 18;
		trace = gi.trace (neworg, bot->mins, bot->maxs, end, bot, MASK_PLAYERSOLID);
		if (trace.allsolid || trace.startsolid)
			return false;
	}

	// don't go in to water -- PSY: temporary fix until we get a good bSwim working
	if (bot->waterlevel == 0)
	{
		test[0] = trace.endpos[0];
		test[1] = trace.endpos[1];
		test[2] = trace.endpos[2] + bot->mins[2] + 1;	
		contents = gi.pointcontents(test);

		if (contents & MASK_WATER)
			return false;
	}

	// PSY: Maj.Bitch's original code resumes here.
	// It's been modified by me, but most of the section above was added by me.
	//
	VectorCopy(bot->s.origin, start);
	
	// Which way is forward from here?
	AngleVectors(tangle, forward, NULL, up);
	
	// end1 is out "step" units.
	VectorMA(start, step, forward, end1);
	
	// use a line to ensure that we can grab items against walls, etc.
	tr=gi.trace(start, finmins, finmaxs, end1, bot, MASK_SHOT);
	
	// Hit a wall forward tracing forward?
	if (tr.fraction < 1.0) 
		return false;
	
	// anti-lava traces - objective is to go under the floor the length of the step to check for lava
	start[2] -= 250;
	end1[2] -= 250;
	tr = gi.trace(start, lmins, lmaxs, end1, bot, MASK_LAVASTOP);
	
	// lava in our box below the bot - test to see if we're going to get to it
	if (tr.fraction < 1.0)
	{
		float up;

		// first get the point right above the endpos of the trace (on the bot's
		// path)
		up = bot->s.origin[2] - end1[2];

		end[2] += 250; // set back on path
		endset = true; // don't reset twice

		tr = gi.trace(end, NULL, NULL, tr.endpos, bot, MASK_SOLID);

		if (tr.fraction == 1.0 && (tr.contents & MASK_LAVASTOP)) // clear path to the lava
			return false;
	}
	
	// reset vector if it hasn't been done
	if (!endset)
		end1[2] += 250;

	// Trace down from end1 and see what we'll eventually step onto..
	VectorMA(end1, -1000, up, end2);
	tr = gi.trace(end1, finmins, finmaxs, end2, bot, MASK_SOLID|MASK_WATER);
	
	// Step only if trace NOT hit lava/slime.
	if (tr.contents & MASK_LAVASTOP)
		return false;
	else  // we can step so return true
		return true;
}

// main ai
void bAI(edict_t *bot, usercmd_t *cmd, vec3_t cmd_angles) 
{
	qboolean itemrun = true; // PSY: added this to safeguard against bot "item tearing" behavior

	// try and stand up if crouched
	if (bot->maxs[2]==4 && bCanStand(bot))
		bot->maxs[2] = 32;
	
	// if riding platform then stop movement
	if (level.time < bot->pausetime)
		return;
	
	// swim out of water
	if (bCanDrown(bot)) 
	{
		// PSY: since we're not supposed to get into water yet (for lack of bSwim), yell if we're in
		// deep water
		gi.dprintf("bot in water somehow(!!)\n");
		bSwim(bot,cmd,cmd_angles);
		return; 
	}
	
	// dodge fire
	if (bDodgeFire(bot, cmd, cmd_angles))
		return;

	// PSY: modified - real player behavior - health search - if we have an enemy, 
	// only search if health is less than 20, otherwise search if less than 30
	// PSY: modified again later, make it 10 health while fighting, they're running away too much
	if (bot->enemy && G_ClientInGame(bot->enemy) && visible(bot, bot->enemy))
		if (bot->health <= 10)
		{
			// really low health, find more
			bot->itemwant = bSeekHealth(bot);
			if (bot->itemwant != NULL)
				if (bGetItem(bot, cmd, cmd_angles))
					return;
				else
					bot->itemwant = NULL;
		}
	else
		// no enemy, so look if health is less than 30
		if (bot->health <= 30)
		{
			// really low health, find more
			bot->itemwant = bSeekHealth(bot);
			if (bot->itemwant != NULL)
			{
				if (bGetItem(bot, cmd, cmd_angles))
					return;
				else
					bot->itemwant = NULL;
			}
		}

	// check for platform
	bot->on_platform=bOnPlatform(bot);
	if (bot->on_platform) 
	{
		bRidePlatform(bot, cmd, cmd_angles);
		return; 
	}
	
	// check for items/enemies
	bot->enemy = bSeekEnemy(bot);   // is there an enemy nearby?
	bot->itemwant = bSeekItem(bot); // is there an item nearby?
		
	// is the enemy there?
	if (!G_ClientInGame(bot->enemy))
		bot->enemy=NULL;

	// can we still get our item? (i.e. not respawning right now)
	if (bot->itemwant!=NULL)
		if ((bot->itemwant->svflags & SVF_NOCLIENT)	|| (bot->itemwant->solid == SOLID_NOT))
		{
			itemrun = false;
			bot->itemwant=NULL;
		}

	// PSY: slight modification here - he should go after enemies first
	if (bot->enemy != NULL)
	{
		// PSY: turn off itemrun if visible, but don't exclude the attack function because
		// that involves running after the enemy
		if (visible(bot, bot->enemy))
			itemrun = false;

		if (bAttack(bot, cmd, cmd_angles))
			return;
	}
	
	// PSY: WTF? we never used to call the bNeedItem function! fix that!
	if (!bNeedItem(bot))
		itemrun = false; // don't go after it, we don't need it!
	

	// PSY: modified: now check for items if we have no enemy - had to add the enemy
	// check, he was tearing between targets switching between item/enemy once per
	// frame (Bad Thing(tm))
	// PSY: modified again, added use of this itemrun variable
	if (bot->itemwant!=NULL && itemrun)
	{
		if (bGetItem(bot, cmd, cmd_angles))
			return; 
	}

	// wander to waypoint with highest priority (maybe should upgrade this to wander
	// to somewhere with no waypoints i.e. to place more?)
	bMoveToItem(bot, cmd, cmd_angles);
}

