#include "g_local.h"

qboolean Jet_AvoidGround( edict_t *ent )
{
	vec3_t                new_origin;
	trace_t       trace;
	qboolean      success;
	
	/*Check if there is enough room above us before we change origin[2]*/
	new_origin[0] = ent->s.origin[0];
	new_origin[1] = ent->s.origin[1];
	new_origin[2] = ent->s.origin[2] + 0.5;
	trace = gi.trace( ent->s.origin, ent->mins, ent->maxs, new_origin, ent, MASK_MONSTERSOLID );
	
	if ( success=(trace.plane.normal[2]==0) )     /*no ceiling?*/
		ent->s.origin[2] += 0.5;                    /*then make sure off ground*/
	
	return success;
}


/*If a player dies with activated jetpack this function will be called
and produces a little explosion*/
void Jet_BecomeExplosion( edict_t *ent, int damage )
{
	int   n;

	G_Spawn_Explosion(TE_EXPLOSION1, ent->s.origin, ent->s.origin);
		
	/*throw some debris*/
	for ( n=0; n<4; n++ )
	{
		ThrowGib (ent, "models/objects/debris1/tris.md2", damage, GIB_METALLIC);
		ThrowGib (ent, "models/objects/debris2/tris.md2", damage, GIB_METALLIC);
	}

	ThrowClientHead(ent, damage);
	ent->takedamage = DAMAGE_NO;
}

/*Now for the main movement code. The steering is a lot like in water, that
means your viewing direction is your moving direction. You have three
direction Boosters: the big Main Booster and the smaller up-down and
left-right Boosters.
There are only 2 adds to the code of the first tutorial: the Jet_next_think
and the rolling.
The other modifications results in the use of the built-in quake functions,
there is no change in moving behavior (reinventing the wheel is a lot of
"fun" and a BIG waste of time ;-))*/
void Jet_ApplyJet( edict_t *ent, usercmd_t *ucmd )
{
	float direction;
	vec3_t acc;
	vec3_t forward, right;
	int    i;
	
	/*clear gravity so we dont have to compensate it with the Boosters*/
	ent->client->ps.pmove.gravity = 0;
	
	/*calculate the direction vectors dependent on viewing direction
	(length of the vectors forward/right is always 1, the coordinates of
	the vectors are values of how much youre looking in a specific direction
	[if youre looking up to the top, the x/y values are nearly 0 the
	z value is nearly 1])*/
	AngleVectors( ent->client->v_angle, forward, right, NULL );
	
	/*Run jet only 10 times a second so movement dont depends on fps
	because ClientThink is called as often as possible
	(fps<10 still is a problem ?)*/
	if ( ent->client->engine_next_think <= level.framenum )
	{
		ent->client->engine_next_think = level.framenum + 1;
		
		/*clear acceleration-vector*/
		VectorClear( acc );
		
		/*if we are moving forward or backward add MainBooster acceleration
		(60)*/
		if ( ucmd->forwardmove )
		{
			/*are we accelerating backward or forward?*/
			direction = (ucmd->forwardmove<0) ? -1.0 : 1.0;
			
			/*add the acceleration for each direction*/
			acc[0] += direction * forward[0] * 60;
			acc[1] += direction * forward[1] * 60;
			acc[2] += direction * forward[2] * 60;
		}
		
		/*if we sidestep add Left-Right-Booster acceleration (40)*/
		if ( ucmd->sidemove )
		{
			/*are we accelerating left or right*/
			direction = (ucmd->sidemove<0) ? -1.0 : 1.0;
			
			/*add only to x and y acceleration*/
			acc[0] += right[0] * direction * 40;
			acc[1] += right[1] * direction * 40;
		}
		
		/*if we crouch or jump add Up-Down-Booster acceleration (30)*/
		if ( ucmd->upmove )
			acc[2] += ucmd->upmove > 0 ? 30 : -30;
		
			/*now apply some friction dependent on velocity (higher velocity results
			in higher friction), without acceleration this will reduce the velocity
		to 0 in a few steps*/
		ent->velocity[0] += -(ent->velocity[0]/6.0);
		ent->velocity[1] += -(ent->velocity[1]/6.0);
		ent->velocity[2] += -(ent->velocity[2]/7.0);
		
		/*then accelerate with the calculated values. If the new acceleration for
		a direction is smaller than an earlier, the friction will reduce the speed
		in that direction to the new value in a few steps, so if youre flying
		curves or around corners youre floating a little bit in the old direction*/
		VectorAdd( ent->velocity, acc, ent->velocity );
		
		/*round velocitys (is this necessary?)*/
		ent->velocity[0] = (float)((int)(ent->velocity[0]*8))/8;
		ent->velocity[1] = (float)((int)(ent->velocity[1]*8))/8;
		ent->velocity[2] = (float)((int)(ent->velocity[2]*8))/8;
		
		/*Bound velocitys so that friction and acceleration dont need to be
		synced on maxvelocitys*/
		for ( i=0 ; i<2 ; i++) /*allow z-velocity to be greater*/
		{
			if (ent->velocity[i] > 300)
				ent->velocity[i] = 300;
			else if (ent->velocity[i] < -300)
				ent->velocity[i] = -300;
		}
	}//if ( ent->client->Jet_next_think...
}