#include "defines.h"
#include "m_player.h"

static qboolean is_quad;
static byte is_silenced;

void weapon_grenade_fire(edict_t *ent, qboolean held);

//==============================================================
void ChangeWeapon(edict_t *ent) {
	int i;
	
	if (ent->client->grenade_time) {
		ent->client->grenade_time=level.time;
		ent->client->weapon_sound=0;
		weapon_grenade_fire(ent, false);
		ent->client->grenade_time=0; }
	
	ent->client->pers.lastweapon=ent->client->pers.weapon;
	ent->client->pers.weapon=ent->client->newweapon;
	ent->client->newweapon=NULL;
	ent->client->machinegun_shots=0;
	
	// set visible model
	if (ent->s.modelindex == 255) {
		i=(ent->client->pers.weapon)?((ent->client->pers.weapon->weapmodel & 0xff) << 8):0;
		ent->s.skinnum = (ent-g_edicts-1)|i;}
	
	if (ent->client->pers.weapon && ent->client->pers.weapon->ammo)
		ent->client->ammo_index=ITEM_INDEX(FindItem(ent->client->pers.weapon->ammo));
	else
		ent->client->ammo_index=0;
	
	if (!ent->client->pers.weapon) {
		// dead
		ent->client->ps.gunindex=0;
		return; }
	
	ent->client->weaponstate=WEAPON_ACTIVATING;
	ent->client->ps.gunframe=0;
	ent->client->ps.gunindex=gi.modelindex(ent->client->pers.weapon->view_model);
	
	ent->client->anim_priority=ANIM_PAIN;
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) {
		ent->s.frame=FRAME_crpain1;
		ent->client->anim_end=FRAME_crpain4; }
	else {
		ent->s.frame=FRAME_pain301;
		ent->client->anim_end=FRAME_pain304; }
}

//==============================================================
void NoAmmoWeaponChange(edict_t *ent) {
	
	if (ent->client->pers.inventory[ITEM_INDEX(item_slugs)]
		&& ent->client->pers.inventory[ITEM_INDEX(item_railgun)]) {
		ent->client->newweapon=item_railgun;
		return;}
	
	if (ent->client->pers.inventory[ITEM_INDEX(item_cells)]
		&& ent->client->pers.inventory[ITEM_INDEX(item_hyperblaster)]) {
		ent->client->newweapon=item_hyperblaster;
		return; }
	
	if (ent->client->pers.inventory[ITEM_INDEX(item_bullets)]
		&& ent->client->pers.inventory[ITEM_INDEX(item_chaingun)]) {
		ent->client->newweapon=item_chaingun;
		return; }
	
	if (ent->client->pers.inventory[ITEM_INDEX(item_bullets)]
		&& ent->client->pers.inventory[ITEM_INDEX(item_machinegun)]) {
		ent->client->newweapon=item_machinegun;
		return; }
	
	if (ent->client->pers.inventory[ITEM_INDEX(item_shells)] > 1
		&& ent->client->pers.inventory[ITEM_INDEX(item_supershotgun)]) {
		ent->client->newweapon=item_supershotgun;
		return; }
	
	if (ent->client->pers.inventory[ITEM_INDEX(item_shells)]
		&& ent->client->pers.inventory[ITEM_INDEX(item_shotgun)]) {
		ent->client->newweapon=item_shotgun;
		return; }
	
	ent->client->newweapon=item_blaster;
}

//==============================================================
void Think_Weapon(edict_t *ent) {
	
	// if just died, put the weapon away
	if (ent->health < 1) {
		ent->client->newweapon=NULL;
		ChangeWeapon(ent); }
	
	// call active weapon think routine
	if (ent->client->pers.weapon && ent->client->pers.weapon->weaponthink) {
		is_quad = (ent->client->quad_framenum > level.framenum);
		is_silenced=(ent->client->silencer_shots)?MZ_SILENCED:0;
		ent->client->pers.weapon->weaponthink(ent); }
}

//==============================================================
//==============================================================
//==============================================================

#define FRAME_FIRE_FIRST (FRAME_ACTIVATE_LAST+1)
#define FRAME_IDLE_FIRST (FRAME_FIRE_LAST+1)
#define FRAME_DEACTIVATE_FIRST (FRAME_IDLE_LAST+1)

//==============================================================
void Weapon_Generic(edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void(*fire)(edict_t *ent)) {
	int n;
	
	// VWeap animations screw up corpses
	if (ent->deadflag==DEAD_DEAD || ent->s.modelindex != 255)
		return;
	
	if (ent->client->weaponstate == WEAPON_DROPPING) {
		if (ent->client->ps.gunframe == FRAME_DEACTIVATE_LAST) {
			ChangeWeapon(ent);
			return; }
		else if ((FRAME_DEACTIVATE_LAST-ent->client->ps.gunframe) == 4) {
			ent->client->anim_priority=ANIM_REVERSE;
			if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) {
				ent->s.frame=FRAME_crpain4+1;
				ent->client->anim_end=FRAME_crpain1; }
			else {
				ent->s.frame=FRAME_pain304+1;
				ent->client->anim_end=FRAME_pain301; } }
		ent->client->ps.gunframe++;
		return; }
	
	if (ent->client->weaponstate == WEAPON_ACTIVATING) {
		if (ent->client->ps.gunframe == FRAME_ACTIVATE_LAST) {
			ent->client->weaponstate=WEAPON_READY;
			ent->client->ps.gunframe=FRAME_IDLE_FIRST;
			return; }
		ent->client->ps.gunframe++;
		return; }
	
	if ((ent->client->newweapon) && (ent->client->weaponstate != WEAPON_FIRING)) {
		ent->client->weaponstate=WEAPON_DROPPING;
		ent->client->ps.gunframe=FRAME_DEACTIVATE_FIRST;
		if ((FRAME_DEACTIVATE_LAST-FRAME_DEACTIVATE_FIRST) < 4) {
			ent->client->anim_priority=ANIM_REVERSE;
			if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) {
				ent->s.frame=FRAME_crpain4+1;
				ent->client->anim_end=FRAME_crpain1; }
			else {
				ent->s.frame=FRAME_pain304+1;
				ent->client->anim_end=FRAME_pain301; } }
		return; }
	
	if (ent->client->weaponstate == WEAPON_READY) {
		if (((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK)) {
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			if ((!ent->client->ammo_index) ||
				(ent->client->pers.inventory[ent->client->ammo_index] >= ent->client->pers.weapon->quantity)) {
				ent->client->ps.gunframe=FRAME_FIRE_FIRST;
				ent->client->weaponstate=WEAPON_FIRING;
				// start the animation
				ent->client->anim_priority=ANIM_ATTACK;
				if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) {
					ent->s.frame=FRAME_crattak1-1;
					ent->client->anim_end=FRAME_crattak9; }
				else {
					ent->s.frame=FRAME_attack1-1;
					ent->client->anim_end=FRAME_attack8; } }
			else {
				if (level.time >= ent->pain_debounce_time) {
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time=level.time+1; }
				NoAmmoWeaponChange(ent); } }
		else {
			if (ent->client->ps.gunframe == FRAME_IDLE_LAST) {
				ent->client->ps.gunframe=FRAME_IDLE_FIRST;
				return; }
			if (pause_frames)
				for (n=0; pause_frames[n]; n++)
					if (ent->client->ps.gunframe == pause_frames[n])
						if (rand()&15)
							return;
						ent->client->ps.gunframe++;
						return; } }
	
	if (ent->client->weaponstate == WEAPON_FIRING) {
		for (n=0; fire_frames[n]; n++) {
			if (ent->client->ps.gunframe == fire_frames[n]) {
				if (ent->client->quad_framenum > level.framenum)
					gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage3.wav"), 1, ATTN_NORM, 0);
				fire(ent);
				break; } }
		if (!fire_frames[n])
			ent->client->ps.gunframe++;
		if (ent->client->ps.gunframe == FRAME_IDLE_FIRST+1)
			ent->client->weaponstate=WEAPON_READY; }
}

//==============================================================
//==============================================================
//==============================================================

#define GRENADE_TIMER     3.0
#define GRENADE_MINSPEED  400
#define GRENADE_MAXSPEED  800

//==============================================================
//==============================================================
void weapon_grenade_fire(edict_t *ent, qboolean held) {
	vec3_t offset, forward, right, start;
	int speed, damage=125;
	float timer, radius;
	
	radius=damage+40;
	if (is_quad)
		damage *= 4;
	
	VectorSet(offset, 8, 8, ent->viewheight-8);
	AngleVectors(ent->client->v_angle, forward, right, NULL);
	P_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);
	
	timer=ent->client->grenade_time-level.time;
	speed=GRENADE_MINSPEED+(GRENADE_TIMER-timer)*((GRENADE_MAXSPEED-GRENADE_MINSPEED)/GRENADE_TIMER);
	fire_grenade2(ent, start, forward, damage, speed, timer, radius, held);
	
	if (!((int)dmflags->value & DF_INFINITE_AMMO))
		ent->client->pers.inventory[ent->client->ammo_index]--;
	
	ent->client->grenade_time=level.time+1.0;
	
	if (ent->deadflag==DEAD_DEAD || ent->s.modelindex != 255) // VWep animations screw up corpses
		return;
	
	if (ent->health<=0)
		return;
	
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) {
		ent->client->anim_priority=ANIM_ATTACK;
		ent->s.frame=FRAME_crattak1-1;
		ent->client->anim_end=FRAME_crattak3; }
	else {
		ent->client->anim_priority=ANIM_REVERSE;
		ent->s.frame=FRAME_wave08;
		ent->client->anim_end=FRAME_wave01; }
}

//==============================================================
void Weapon_Grenade(edict_t *ent) {
	
	if ((ent->client->newweapon) && (ent->client->weaponstate == WEAPON_READY)) {
		ChangeWeapon(ent);
		return; }
	
	if (ent->client->weaponstate == WEAPON_ACTIVATING) {
		ent->client->weaponstate=WEAPON_READY;
		ent->client->ps.gunframe=16;
		return; }
	
	if (ent->client->weaponstate == WEAPON_READY) {
		if (((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK)) {
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			if (ent->client->pers.inventory[ent->client->ammo_index]) {
				ent->client->ps.gunframe=1;
				ent->client->weaponstate=WEAPON_FIRING;
				ent->client->grenade_time=0; }
			else {
				if (level.time >= ent->pain_debounce_time) {
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time=level.time+1; }
				NoAmmoWeaponChange(ent); }
			return; }
		if ((ent->client->ps.gunframe == 29) || (ent->client->ps.gunframe == 34) || (ent->client->ps.gunframe == 39) || (ent->client->ps.gunframe == 48))
			if (rand()&15)
				return;
			if (++ent->client->ps.gunframe > 48)
				ent->client->ps.gunframe=16;
			return; }
	
	if (ent->client->weaponstate == WEAPON_FIRING) {
		if (ent->client->ps.gunframe == 5)
			gi.sound(ent, CHAN_WEAPON, gi.soundindex("weapons/hgrena1b.wav"), 1, ATTN_NORM, 0);
		if (ent->client->ps.gunframe == 11) {
			if (!ent->client->grenade_time) {
				ent->client->grenade_time=level.time+GRENADE_TIMER+0.2;
				ent->client->weapon_sound=gi.soundindex("weapons/hgrenc1b.wav");}
			// they waited too long, detonate it in their hand
			if (!ent->client->grenade_blew_up && level.time >= ent->client->grenade_time) {
				ent->client->weapon_sound=0;
				weapon_grenade_fire(ent, true);
				ent->client->grenade_blew_up=true;}
			if (ent->client->buttons & BUTTON_ATTACK)
				return;
			if (ent->client->grenade_blew_up) {
				if (level.time >= ent->client->grenade_time) {
					ent->client->ps.gunframe=15;
					ent->client->grenade_blew_up=false; }
				else
					return; } }
		
		if (ent->client->ps.gunframe == 12) {
			ent->client->weapon_sound=0;
			weapon_grenade_fire(ent, false); }
		
		if ((ent->client->ps.gunframe == 15) && (level.time < ent->client->grenade_time))
			return;
		
		ent->client->ps.gunframe++;
		
		if (ent->client->ps.gunframe == 16) {
			ent->client->grenade_time=0;
			ent->client->weaponstate=WEAPON_READY; } }
}

//==============================================================
//==============================================================
//==============================================================

//==============================================================
void weapon_grenadelauncher_fire(edict_t *ent) {
	vec3_t offset, forward, right, start;
	int damage=120;
	float radius;
	
	radius=damage+40;
	if (is_quad)
		damage *= 4;
	
	VectorSet(offset, 8, 8, ent->viewheight-8);
	AngleVectors(ent->client->v_angle, forward, right, NULL);
	P_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);
	
	VectorScale(forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0]= -1;
	
	fire_grenade(ent, start, forward, damage, 600, 2.5, radius);
	
	G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)MZ_GRENADE|is_silenced);
	
	ent->client->ps.gunframe++;
	
	PlayerNoise(ent, start, PNOISE_WEAPON);
	
	if (!((int)dmflags->value & DF_INFINITE_AMMO))
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

//==============================================================
void Weapon_GrenadeLauncher(edict_t *ent) {
	static int pause_frames[] ={34, 51, 59, 0};
	static int fire_frames[] ={6, 0};
	
	Weapon_Generic(ent, 5, 16, 59, 64, pause_frames, fire_frames, weapon_grenadelauncher_fire);
}

//==============================================================
//==============================================================
//==============================================================

//==============================================================
void Weapon_RocketLauncher_Fire(edict_t *ent) {
	vec3_t offset, start, forward, right;
	int radius_damage=120, damage, damage_radius=120;
	
	damage=100+(int)(random()*20.0);
	
	if (is_quad) {
		damage *= 4;
		radius_damage *= 4; }
	
	AngleVectors(ent->client->v_angle, forward, right, NULL);
	
	VectorScale(forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0]= -1;
	
	VectorSet(offset, 8, 8, ent->viewheight-8);
	P_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);
	fire_rocket(ent, start, forward, damage, 650, damage_radius, radius_damage);
	
	G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)MZ_ROCKET|is_silenced);
	
	ent->client->ps.gunframe++;
	
	PlayerNoise(ent, start, PNOISE_WEAPON);
	
	if (!((int)dmflags->value & DF_INFINITE_AMMO))
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

//==============================================================
void Weapon_RocketLauncher(edict_t *ent) {
	static int pause_frames[] ={25, 33, 42, 50, 0};
	static int fire_frames[] ={5, 0};
	
	Weapon_Generic(ent, 4, 12, 50, 54, pause_frames, fire_frames, Weapon_RocketLauncher_Fire);
}

//==============================================================
//==============================================================
//==============================================================

//==============================================================
void Blaster_Fire(edict_t *ent, vec3_t g_offset, int damage, qboolean hyper, int effect) {
	vec3_t forward, right, start, offset;
	
	if (is_quad)
		damage *= 4;
	
	AngleVectors(ent->client->v_angle, forward, right, NULL);
	VectorSet(offset, 24, 8, ent->viewheight-8);
	VectorAdd(offset, g_offset, offset);
	P_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);
	
	VectorScale(forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0]= -1;
	
	fire_blaster(ent, start, forward, damage, 1000, effect, hyper);
	
	// send muzzle flash
	if (hyper)
		G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)MZ_HYPERBLASTER);
	else
		G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)MZ_BLASTER|is_silenced);
	
	PlayerNoise(ent, start, PNOISE_WEAPON);
}

//==============================================================
void Weapon_Blaster_Fire(edict_t *ent) {
	Blaster_Fire(ent, zvec, (CVAR_DEATHMATCH)?15:10, false, EF_BLASTER);
	ent->client->ps.gunframe++;
}

//==============================================================
void Weapon_Blaster(edict_t *ent) {
	static int pause_frames[] ={19, 32, 0};
	static int fire_frames[] ={5, 0};
	
	Weapon_Generic(ent, 4, 8, 52, 55, pause_frames, fire_frames, Weapon_Blaster_Fire);
}

//==============================================================
void Weapon_HyperBlaster_Fire(edict_t *ent) {
	float rotation;
	vec3_t offset;
	int effect=EF_NONE, damage=20;
	
	ent->client->weapon_sound=gi.soundindex("weapons/hyprbl1a.wav");
	
	if (!(ent->client->buttons & BUTTON_ATTACK))
		ent->client->ps.gunframe++;
	else {
		if (!ent->client->pers.inventory[ent->client->ammo_index]) {
			if (level.time >= ent->pain_debounce_time) {
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
				ent->pain_debounce_time=level.time+1; }
			NoAmmoWeaponChange(ent); }
		else {
			rotation = (ent->client->ps.gunframe-5)*2*M_PI/6;
			offset[0]= -4*sin(rotation);
			offset[1]=0;
			offset[2]=4*cos(rotation);
			if ((ent->client->ps.gunframe == 6) || (ent->client->ps.gunframe == 9))
				effect=EF_HYPERBLASTER;
			if (CVAR_DEATHMATCH && !MonstersInUse)
				damage=15;
			Blaster_Fire(ent, offset, damage, true, effect);
			if (!((int)dmflags->value & DF_INFINITE_AMMO))
				ent->client->pers.inventory[ent->client->ammo_index]--;
			ent->client->anim_priority=ANIM_ATTACK;
			if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) {
				ent->s.frame=FRAME_crattak1-1;
				ent->client->anim_end=FRAME_crattak9; }
			else {
				ent->s.frame=FRAME_attack1-1;
				ent->client->anim_end=FRAME_attack8; } }
		
		ent->client->ps.gunframe++;
		if (ent->client->ps.gunframe == 12 && ent->client->pers.inventory[ent->client->ammo_index])
			ent->client->ps.gunframe=6; }
	
	if (ent->client->ps.gunframe == 12) {
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/hyprbd1a.wav"), 1, ATTN_NORM, 0);
		ent->client->weapon_sound=0; }
}

//==============================================================
void Weapon_HyperBlaster(edict_t *ent) {
	static int pause_frames[] ={0};
	static int fire_frames[] ={6, 7, 8, 9, 10, 11, 0};
	
	Weapon_Generic(ent, 5, 20, 49, 53, pause_frames, fire_frames, Weapon_HyperBlaster_Fire);
}

//==============================================================
//==============================================================
//==============================================================

//==============================================================
void Machinegun_Fire(edict_t *ent) {
	vec3_t start, forward, right, angles, offset;
	int i, damage=8, kick=2;
	
	if (!(ent->client->buttons & BUTTON_ATTACK)) {
		ent->client->machinegun_shots=0;
		ent->client->ps.gunframe++;
		return; }
	
	if (ent->client->ps.gunframe == 5)
		ent->client->ps.gunframe=4;
	else
		ent->client->ps.gunframe=5;
	
	if (ent->client->pers.inventory[ent->client->ammo_index] < 1) {
		ent->client->ps.gunframe=6;
		if (level.time >= ent->pain_debounce_time) {
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time=level.time+1; }
		NoAmmoWeaponChange(ent);
		return; }
	
	if (is_quad) {
		damage *= 4;
		kick *= 4; }
	
	for (i=1; i<3; i++) {
		ent->client->kick_origin[i]=crandom()*0.35;
		ent->client->kick_angles[i]=crandom()*0.7; }
	
	ent->client->kick_origin[0]=crandom()*0.35;
	ent->client->kick_angles[0]=ent->client->machinegun_shots*-1.5;
	
	// raise the gun as it is firing
	if (!CVAR_DEATHMATCH) {
		ent->client->machinegun_shots++;
		if (ent->client->machinegun_shots > 9)
			ent->client->machinegun_shots=9; }
	
	// get start/end positions
	VectorAdd(ent->client->v_angle, ent->client->kick_angles, angles);
	AngleVectors(angles, forward, right, NULL);
	VectorSet(offset, 0, 8, ent->viewheight-8);
	P_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);
	fire_bullet(ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_MACHINEGUN);
	
	G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)MZ_MACHINEGUN|is_silenced);
	
	PlayerNoise(ent, start, PNOISE_WEAPON);
	
	if (!((int)dmflags->value & DF_INFINITE_AMMO))
		ent->client->pers.inventory[ent->client->ammo_index]--;
	
	ent->client->anim_priority=ANIM_ATTACK;
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) {
		ent->s.frame=FRAME_crattak1 -(int)(random()+0.25);
		ent->client->anim_end=FRAME_crattak9; }
	else {
		ent->s.frame=FRAME_attack1 -(int)(random()+0.25);
		ent->client->anim_end=FRAME_attack8; }
}

//==============================================================
void Weapon_Machinegun(edict_t *ent) {
	static int pause_frames[] ={23, 45, 0};
	static int fire_frames[] ={4, 5, 0};
	
	Weapon_Generic(ent, 3, 5, 45, 49, pause_frames, fire_frames, Machinegun_Fire);
}

//==============================================================
void Chaingun_Fire(edict_t *ent) {
	vec3_t start, forward, right, up, offset;
	float r, u;
	int i, shots, damage, kick=2;
	
	damage=(CVAR_DEATHMATCH && !MonstersInUse)?6:8;
	
	if (ent->client->ps.gunframe == 5)
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/chngnu1a.wav"), 1, ATTN_IDLE, 0);
	
	if ((ent->client->ps.gunframe == 14) && !(ent->client->buttons & BUTTON_ATTACK)) {
		ent->client->ps.gunframe=32;
		ent->client->weapon_sound=0;
		return; }
	else if ((ent->client->ps.gunframe == 21) && (ent->client->buttons & BUTTON_ATTACK)
		&& ent->client->pers.inventory[ent->client->ammo_index])
		ent->client->ps.gunframe=15;
	else
		ent->client->ps.gunframe++;
	
	if (ent->client->ps.gunframe == 22) {
		ent->client->weapon_sound=0;
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/chngnd1a.wav"), 1, ATTN_IDLE, 0); }
	else
		ent->client->weapon_sound=gi.soundindex("weapons/chngnl1a.wav");
	
	ent->client->anim_priority=ANIM_ATTACK;
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) {
		ent->s.frame=FRAME_crattak1 -(ent->client->ps.gunframe & 1);
		ent->client->anim_end=FRAME_crattak9; }
	else {
		ent->s.frame=FRAME_attack1 -(ent->client->ps.gunframe & 1);
		ent->client->anim_end=FRAME_attack8; }
	
	shots=(ent->client->ps.gunframe<=9)?1:(ent->client->ps.gunframe<=14)?(ent->client->buttons & BUTTON_ATTACK)?2:1:3;
	
	if (ent->client->pers.inventory[ent->client->ammo_index] < shots)
		shots=ent->client->pers.inventory[ent->client->ammo_index];
	
	if (!shots) {
		if (level.time >= ent->pain_debounce_time) {
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time=level.time+1; }
		NoAmmoWeaponChange(ent);
		return; }
	
	if (is_quad) {
		damage *= 4;
		kick *= 4; }
	
	for (i=0; i<3; i++) {
		ent->client->kick_origin[i]=crandom()*0.35;
		ent->client->kick_angles[i]=crandom()*0.7; }
	
	for (i=0; i<shots; i++) {
		// get start/end positions
		AngleVectors(ent->client->v_angle, forward, right, up);
		r=7+crandom()*4;
		u=crandom()*4;
		VectorSet(offset, 0, r, u+ent->viewheight-8);
		P_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);
		fire_bullet(ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_CHAINGUN); }
	
	// send muzzle flash
	G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)(MZ_CHAINGUN1+shots-1)|is_silenced);
	
	PlayerNoise(ent, start, PNOISE_WEAPON);
	
	// VWeap-begin
	ent->client->anim_priority=ANIM_ATTACK;
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) {
		ent->s.frame=FRAME_crattak1-1+(ent->client->ps.gunframe%3);
		ent->client->anim_end=FRAME_crattak9; }
	else {
		ent->s.frame=FRAME_attack1-1+(ent->client->ps.gunframe%3);
		ent->client->anim_end=FRAME_attack8; }
	// VWeap-end
	
	if (!((int)dmflags->value & DF_INFINITE_AMMO))
		ent->client->pers.inventory[ent->client->ammo_index] -= shots;
}

//==============================================================
void Weapon_Chaingun(edict_t *ent) {
	static int pause_frames[] ={38, 43, 51, 61, 0};
	static int fire_frames[] ={5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 0};
	
	Weapon_Generic(ent, 4, 31, 61, 64, pause_frames, fire_frames, Chaingun_Fire);
}

//==============================================================
//==============================================================
//==============================================================

//==============================================================
void weapon_shotgun_fire(edict_t *ent) {
	vec3_t start, forward, right, offset;
	int damage=4, kick=8;
	
	if (ent->client->ps.gunframe == 9) {
		ent->client->ps.gunframe++;
		return; }
	
	AngleVectors(ent->client->v_angle, forward, right, NULL);
	
	VectorScale(forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0]= -2;
	
	VectorSet(offset, 0, 8,  ent->viewheight-8);
	P_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);
	
	if (is_quad) {
		damage *= 4;
		kick *= 4; }
	
	if (CVAR_DEATHMATCH)
		fire_shotgun(ent, start, forward, damage, kick, 500, 500, DEFAULT_DEATHMATCH_SHOTGUN_COUNT, MOD_SHOTGUN);
	else
		fire_shotgun(ent, start, forward, damage, kick, 500, 500, DEFAULT_SHOTGUN_COUNT, MOD_SHOTGUN);
	
	// send muzzle flash
	G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)MZ_SHOTGUN|is_silenced);
	
	ent->client->ps.gunframe++;
	
	PlayerNoise(ent, start, PNOISE_WEAPON);
	
	if (!((int)dmflags->value & DF_INFINITE_AMMO))
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

//==============================================================
void Weapon_Shotgun(edict_t *ent) {
	static int pause_frames[] ={22, 28, 34, 0};
	static int fire_frames[] ={8, 9, 0};
	
	Weapon_Generic(ent, 7, 18, 36, 39, pause_frames, fire_frames, weapon_shotgun_fire);
}

//==============================================================
void weapon_supershotgun_fire(edict_t *ent) {
	vec3_t start, forward, right, offset, v;
	int damage=6, kick=12;
	
	AngleVectors(ent->client->v_angle, forward, right, NULL);
	
	VectorScale(forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0]= -2;
	
	VectorSet(offset, 0, 8,  ent->viewheight-8);
	P_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);
	
	if (is_quad) {
		damage *= 4;
		kick *= 4; }
	
	VectorSet(v,ent->client->v_angle[PITCH],ent->client->v_angle[YAW]-5,ent->client->v_angle[ROLL]);
	AngleVectors(v, forward, NULL, NULL);
	fire_shotgun(ent, start, forward, damage, kick, DEFAULT_SHOTGUN_HSPREAD, DEFAULT_SHOTGUN_VSPREAD, DEFAULT_SSHOTGUN_COUNT/2, MOD_SSHOTGUN);
	v[YAW]=ent->client->v_angle[YAW]+5;
	AngleVectors(v, forward, NULL, NULL);
	fire_shotgun(ent, start, forward, damage, kick, DEFAULT_SHOTGUN_HSPREAD, DEFAULT_SHOTGUN_VSPREAD, DEFAULT_SSHOTGUN_COUNT/2, MOD_SSHOTGUN);
	
	// send muzzle flash
	G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)MZ_SSHOTGUN|is_silenced);
	
	ent->client->ps.gunframe++;
	
	PlayerNoise(ent, start, PNOISE_WEAPON);
	
	if (!((int)dmflags->value & DF_INFINITE_AMMO))
		ent->client->pers.inventory[ent->client->ammo_index] -= 2;
}

//==============================================================
void Weapon_SuperShotgun(edict_t *ent) {
	static int pause_frames[] ={29, 42, 57, 0};
	static int fire_frames[] ={7, 0};
	
	Weapon_Generic(ent, 6, 17, 57, 61, pause_frames, fire_frames, weapon_supershotgun_fire);
}

//==============================================================
//==============================================================
//==============================================================

//==============================================================
void weapon_railgun_fire(edict_t *ent) {
	vec3_t start, forward, right, offset;
	int damage=150, kick=250;
	
	// normal damage is too extreme in dm
	if (CVAR_DEATHMATCH && !MonstersInUse) {
		damage=100;
		kick=200; }
	
	if (is_quad) {
		damage *= 4;
		kick *= 4; }
	
	AngleVectors(ent->client->v_angle, forward, right, NULL);
	
	VectorScale(forward, -3, ent->client->kick_origin);
	ent->client->kick_angles[0]= -3;
	
	VectorSet(offset, 0, 7,  ent->viewheight-8);
	P_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);
	fire_rail(ent, start, forward, damage, kick);
	
	// send muzzle flash
	G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)MZ_RAILGUN|is_silenced);
	
	ent->client->ps.gunframe++;
	
	PlayerNoise(ent, start, PNOISE_WEAPON);
	
	if (!((int)dmflags->value & DF_INFINITE_AMMO))
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

//==============================================================
void Weapon_Railgun(edict_t *ent) {
	static int pause_frames[] ={56, 0};
	static int fire_frames[] ={4, 0};
	
	Weapon_Generic(ent, 3, 18, 56, 61, pause_frames, fire_frames, weapon_railgun_fire);
}

//==============================================================
//==============================================================
//==============================================================

//==============================================================
void weapon_bfg_fire(edict_t *ent) {
	vec3_t offset, start, forward, right;
	int damage;
	float damage_radius=1000;
	
	damage=(CVAR_DEATHMATCH && !MonstersInUse)?200:500;
	
	if (ent->client->ps.gunframe == 9) {
		// send muzzle flash
		G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)MZ_BFG|is_silenced);
		ent->client->ps.gunframe++;
		PlayerNoise(ent, start, PNOISE_WEAPON);
		return; }
	
	// cells can go down during windup(from power armor hits), so
	// check again and abort firing if we don't have enough now
	if (ent->client->pers.inventory[ent->client->ammo_index] < 50) {
		ent->client->ps.gunframe++;
		return; }
	
	if (is_quad)
		damage *= 4;
	
	AngleVectors(ent->client->v_angle, forward, right, NULL);
	
	VectorScale(forward, -2, ent->client->kick_origin);
	
	// make a big pitch kick with an inverse fall
	ent->client->v_dmg_pitch= -40;
	ent->client->v_dmg_roll=crandom()*8;
	ent->client->v_dmg_time=level.time+DAMAGE_TIME;
	
	VectorSet(offset, 8, 8, ent->viewheight-8);
	P_ProjectSource(ent->client, ent->s.origin, offset, forward, right, start);
	fire_bfg(ent, start, forward, damage, 400, damage_radius);
	
	ent->client->ps.gunframe++;
	
	PlayerNoise(ent, start, PNOISE_WEAPON);
	
	if (!((int)dmflags->value & DF_INFINITE_AMMO))
		ent->client->pers.inventory[ent->client->ammo_index] -= 50;
}

//==============================================================
void Weapon_BFG(edict_t *ent) {
	static int pause_frames[] ={39, 45, 50, 55, 0};
	static int fire_frames[] ={9, 17, 0};
	
	Weapon_Generic(ent, 8, 32, 55, 58, pause_frames, fire_frames, weapon_bfg_fire);
}

