#include "defines.h"

//========================================================
void MoveClientToIntermission(edict_t *ent) {
	
	if (CVAR_DEATHMATCH || CVAR_COOP)
		ent->client->showscores=true;
	
	VectorCopy(level.intermission_origin, ent->s.origin);
	ent->client->ps.pmove.origin[0]=level.intermission_origin[0]*8;
	ent->client->ps.pmove.origin[1]=level.intermission_origin[1]*8;
	ent->client->ps.pmove.origin[2]=level.intermission_origin[2]*8;
	VectorCopy(level.intermission_angle, ent->client->ps.viewangles);
	ent->client->ps.pmove.pm_type=PM_FREEZE;
	ent->client->ps.gunindex=0;
	ent->client->ps.blend[3]=0;
	ent->client->ps.rdflags &= ~RDF_UNDERWATER;
	
	// clean up powerup info
	ent->client->quad_framenum=0;
	ent->client->invincible_framenum=0;
	ent->client->breather_framenum=0;
	ent->client->enviro_framenum=0;
	ent->client->grenade_blew_up=false;
	ent->client->grenade_time=0;
	
	ent->viewheight=0;
	ent->s.modelindex=0;
	ent->s.modelindex2=0;
	ent->s.modelindex3=0;
	ent->s.modelindex=0;
	ent->s.effects=EF_NONE;
	ent->s.sound=0;
	ent->solid=SOLID_NOT;
	
	// add the layout
	
	if (CVAR_DEATHMATCH || CVAR_COOP) {
		DeathmatchScoreboardMessage(ent, NULL);
		gi.unicast(ent, true); }
}

//========================================================
void BeginIntermission(edict_t *targ) {
	int i, n;
	edict_t *ent;
	
	if (level.intermissiontime) return;
	
	ga.autosaved=false;
	
	// respawn any dead clients
	for (i=0; i<maxclients->value; i++) {
		ent=g_edicts+1+i;
		if (!G_EntExists(ent)) continue;
		if (ent->health<=0)
			respawn(ent); }
	
	level.intermissiontime=level.time;
	level.changemap=targ->map;
	
	if (strstr(level.changemap, "*")) {
		if (CVAR_COOP) {
			for (i=0; i<maxclients->value; i++) {
				ent=g_edicts+1+i;
				if (!G_EntExists(ent)) continue;
				// strip players of all keys between units
				for (n=0; n < MAX_ITEMS; n++)
					if (itemlist[n].flags & IT_KEY)
						ent->client->pers.inventory[n]=0; } } }
	else
		if (!CVAR_DEATHMATCH) {
			level.exitintermission=1;    // go immediately to the next level
			return; }
		
		level.exitintermission=0;
		
		// find an intermission spot
		ent=G_Find(NULL, FOFS(classname), "info_player_intermission");
		if (!ent) {
			// the map creator forgot to put in an intermission point...
			ent=G_Find(NULL, FOFS(classname), "info_player_start");
			if (!ent)
				ent=G_Find(NULL, FOFS(classname), "info_player_deathmatch"); }
		else {
			// chose one of four spots
			i=rand()&3;
			while (i--) {
				ent=G_Find(ent, FOFS(classname), "info_player_intermission");
				if (!ent)  // wrap around the list
					ent=G_Find(ent, FOFS(classname), "info_player_intermission"); }
		} // end else
		
		VectorCopy(ent->s.origin, level.intermission_origin);
		VectorCopy(ent->s.angles, level.intermission_angle);
		
		// move all clients to the intermission point
		for (i=0; i<maxclients->value; i++) {
			ent=g_edicts+1+i;
			if (!G_EntExists(ent)) continue;
			MoveClientToIntermission(ent); }
}

//========================================================
void DeathmatchScoreboardMessage(edict_t *ent, edict_t *killer) {
	char entrystr[1024];
	char string[1400];
	int stringlength;
	int x, y, i, j, k;
	int sorted[MAX_CLIENTS];
	int sortedscores[MAX_CLIENTS];
	int score, total=0, picnum;
	gclient_t *cl;
	edict_t *cl_ent;
	char *tag;
	
	// sort the clients by score
	for (i=0; i<ga.maxclients; i++) {
		cl_ent=g_edicts+1+i;
		if (!G_EntExists(cl_ent)) continue;
		if (ga.clients[i].resp.spectator) continue;
		score=ga.clients[i].resp.score;
		for (j=0; j<total; j++)
			if (score > sortedscores[j])
				break;
			for (k=total; k>j; k--) {
				sorted[k]=sorted[k-1];
				sortedscores[k]=sortedscores[k-1]; }
			sorted[j]=i;
			sortedscores[j]=score;
			total++; }
	
	// print level name and exit rules
	string[0]=0;
	
	stringlength=strlen(string);
	
	// add the clients in sorted order
	if (total > 12) total=12;
	
	for (i=0; i<total; i++) {
		cl=&ga.clients[sorted[i]];
		cl_ent=g_edicts+1+sorted[i];
		
		picnum=gi.imageindex("i_fixme");
		x = (i>=6) ? 160 : 0;
		y=32+32*(i%6);
		
		// add a dogtag
		tag=(cl_ent==ent)?"tag1":(cl_ent==killer)?"tag2":NULL;
		if (tag) {
			Com_sprintf(entrystr, sizeof(entrystr), "xv %i yv %i picn %s ",x+32, y, tag);
			j=strlen(entrystr);
			if (stringlength+j > 1024)
				break;
			strcpy(string+stringlength, entrystr);
			stringlength += j; }
		
		// send the layout
		Com_sprintf(entrystr, sizeof(entrystr),
			"client %i %i %i %i %i %i ",
			x, y, sorted[i], cl->resp.score, cl->ping,(level.framenum-cl->resp.enterframe)/600);
		j=strlen(entrystr);
		if (stringlength+j > 1024) break;
		strcpy(string+stringlength, entrystr);
		stringlength += j;
    } // end for
	
	G_WriteLayout(ent, string);
}

//========================================================
void DeathmatchScoreboard(edict_t *ent) {
	DeathmatchScoreboardMessage(ent, ent->enemy);
}

//========================================================
void G_SetStats(edict_t *ent) {
	gitem_t *item;
	int index, cells;
	int power_armor_type;
	
	//
	// health
	//
	ent->client->ps.stats[STAT_HEALTH_ICON]=level.pic_health;
	ent->client->ps.stats[STAT_HEALTH]=ent->health;
	
	//
	// ammo
	//
	if (!ent->client->ammo_index) {
		ent->client->ps.stats[STAT_AMMO_ICON]=0;
		ent->client->ps.stats[STAT_AMMO]=0; }
	else {
		item=&itemlist[ent->client->ammo_index];
		ent->client->ps.stats[STAT_AMMO_ICON]=gi.imageindex(item->icon);
		ent->client->ps.stats[STAT_AMMO]=ent->client->pers.inventory[ent->client->ammo_index]; }
	
	//
	// armor
	//
	power_armor_type=PowerArmorType(ent);
	if (power_armor_type) {
		cells=ent->client->pers.inventory[ITEM_INDEX(item_cells)];
		if (cells == 0) {
			// ran out of cells for power armor
			ent->flags &= ~FL_POWER_ARMOR;
			gi.sound(ent, CHAN_ITEM, gi.soundindex("misc/power2.wav"), 1, ATTN_NORM, 0);
			power_armor_type=POWER_ARMOR_NONE; } }
	
	index=ArmorIndex(ent);
	if (power_armor_type && (!index || (level.framenum & 8))) {
		// flash between power armor and other armor icon
		ent->client->ps.stats[STAT_ARMOR_ICON]=gi.imageindex("i_powershield");
		ent->client->ps.stats[STAT_ARMOR]=cells; }
	else if (index) {
		item=GetItemByIndex(index);
		ent->client->ps.stats[STAT_ARMOR_ICON]=gi.imageindex(item->icon);
		ent->client->ps.stats[STAT_ARMOR]=ent->client->pers.inventory[index]; }
	else {
		ent->client->ps.stats[STAT_ARMOR_ICON]=0;
		ent->client->ps.stats[STAT_ARMOR]=0; }
	
	//
	// pickup message
	//
	if (level.time > ent->client->pickup_msg_time) {
		ent->client->ps.stats[STAT_PICKUP_ICON]=0;
		ent->client->ps.stats[STAT_PICKUP_STRING]=0; }
	
	//
	// timers-only 1 timer running at a time!
	//
	
	// Show Flyer's Total Health..
	if (ent->flyer) {
		ent->client->ps.stats[STAT_TIMER_ICON]=gi.imageindex("k_pyramid");
		ent->client->ps.stats[STAT_TIMER] = ent->flyer->health; }
	else if (ent->client->cloak_framenum > level.framenum){
		ent->client->ps.stats[STAT_TIMER_ICON]=gi.imageindex("k_pyramid");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->cloak_framenum-level.framenum)/10;}
	else if (ent->client->quad_framenum > level.framenum) {
		ent->client->ps.stats[STAT_TIMER_ICON]=gi.imageindex("p_quad");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->quad_framenum-level.framenum)/10; }
	else if (ent->client->invincible_framenum > level.framenum) {
		ent->client->ps.stats[STAT_TIMER_ICON]=gi.imageindex("p_invulnerability");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->invincible_framenum-level.framenum)/10; }
	else if (ent->client->enviro_framenum > level.framenum) {
		ent->client->ps.stats[STAT_TIMER_ICON]=gi.imageindex("p_envirosuit");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->enviro_framenum-level.framenum)/10; }
	else if (ent->client->breather_framenum > level.framenum) {
		ent->client->ps.stats[STAT_TIMER_ICON]=gi.imageindex("p_rebreather");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->breather_framenum-level.framenum)/10; }
	else {
		ent->client->ps.stats[STAT_TIMER_ICON]=0;
		ent->client->ps.stats[STAT_TIMER]=0; }
	
	//
	// selected item
	//
	if (ent->client->pers.selected_item == -1)
		ent->client->ps.stats[STAT_SELECTED_ICON]=0;
	else
		ent->client->ps.stats[STAT_SELECTED_ICON]=gi.imageindex(itemlist[ent->client->pers.selected_item].icon);
	
	ent->client->ps.stats[STAT_SELECTED_ITEM]=ent->client->pers.selected_item;
	
	//
	// layouts
	//
	ent->client->ps.stats[STAT_LAYOUTS]=0;
	
	if (CVAR_DEATHMATCH) {
		if (ent->client->pers.health<=0 || level.intermissiontime
			|| ent->client->showscores)
			ent->client->ps.stats[STAT_LAYOUTS] |= 1;
		if (ent->client->showinventory && ent->client->pers.health > 0)
			ent->client->ps.stats[STAT_LAYOUTS] |= 2; }
	else {
		if (ent->client->showscores || ent->client->showhelp)
			ent->client->ps.stats[STAT_LAYOUTS] |= 1;
		if (ent->client->showinventory && ent->client->pers.health > 0)
			ent->client->ps.stats[STAT_LAYOUTS] |= 2; }
	
	//
	// frags
	//
	ent->client->ps.stats[STAT_FRAGS]=ent->client->resp.score;
	
	//
	// help icon/current weapon if not shown
	//
	if (ent->client->pers.helpchanged && (level.framenum&8))
		ent->client->ps.stats[STAT_HELPICON]=gi.imageindex("i_help");
	else if ((ent->client->pers.hand == CENTER_HANDED || ent->client->ps.fov > 91)
		&& ent->client->pers.weapon)
		ent->client->ps.stats[STAT_HELPICON]=gi.imageindex(ent->client->pers.weapon->icon);
	else
		ent->client->ps.stats[STAT_HELPICON]=0;
	
	//
	// Cloaking Timer
	//
	// Disable Cloaking if timer has finished..
	if (ent->client->is_cloaked)
		if (ent->client->cloak_framenum<=level.framenum) {
			ent->svflags &= ~SVF_NOCLIENT;    // remove Cloaked effect
			ent->client->is_cloaked=false;
			gi_cprintf(ent, PRINT_HIGH, "NO LONGER CLOAKED!\n"); }
		
		ent->client->ps.stats[STAT_SPECTATOR]=0;
}

//========================================================
void G_CheckChaseStats(edict_t *ent) {
	int i;
	gclient_t *cl;
	
	for (i=1; i<=maxclients->value; i++) {
		cl=g_edicts[i].client;
		if (!g_edicts[i].inuse || cl->chase_target != ent) continue;
		memcpy(cl->ps.stats, ent->client->ps.stats, sizeof(cl->ps.stats));
		G_SetSpectatorStats(g_edicts+i); }
}

//========================================================
void G_SetSpectatorStats(edict_t *ent) {
	
	if (!ent->client->chase_target)
		G_SetStats(ent);
	
	ent->client->ps.stats[STAT_SPECTATOR]=1;
	
	// layouts are independant in spectator
	ent->client->ps.stats[STAT_LAYOUTS]=0;
	if (ent->client->pers.health<=0 || level.intermissiontime || ent->client->showscores)
		ent->client->ps.stats[STAT_LAYOUTS] |= 1;
	if (ent->client->showinventory && ent->client->pers.health > 0)
		ent->client->ps.stats[STAT_LAYOUTS] |= 2;
	
	if (ent->client->chase_target && ent->client->chase_target->inuse)
		ent->client->ps.stats[STAT_CHASE]=CS_PLAYERSKINS +
		(ent->client->chase_target-g_edicts)-1;
	else
		ent->client->ps.stats[STAT_CHASE]=0;
}

