#include "defines.h"

level_locals_t level;
game_import_t  gi;
game_export_t  ge;
game_locals_t  ga,game;
spawn_temp_t   st;

int sm_meat_index;
int snd_fry;
int meansOfDeath;
qboolean MonstersInUse;

vec3_t zvec={0,0,0};

edict_t *g_edicts;

cvar_t *deathmatch;
cvar_t *coop;
cvar_t *dmflags;
cvar_t *skill;
cvar_t *fraglimit;
cvar_t *timelimit;
cvar_t *password;
cvar_t *spectator_password;
cvar_t *needpass;
cvar_t *maxclients;
cvar_t *maxspectators;
cvar_t *maxentities;
cvar_t *g_select_empty;
cvar_t *dedicated;

cvar_t *filterban;

cvar_t *sv_maxvelocity;
cvar_t *sv_gravity;
cvar_t *sv_bestplayer;

cvar_t *sv_rollspeed;
cvar_t *sv_rollangle;
cvar_t *gun_x;
cvar_t *gun_y;
cvar_t *gun_z;

cvar_t *run_pitch;
cvar_t *run_roll;
cvar_t *bob_up;
cvar_t *bob_pitch;
cvar_t *bob_roll;

cvar_t *sv_cheats;

cvar_t *flood_msgs;
cvar_t *flood_persecond;
cvar_t *flood_waitdelay;

cvar_t *sv_maplist;

//======================================================
void ShutdownGame(void) {
	gi.dprintf("==== ShutdownGame ====\n");
	gi.FreeTags(TAG_LEVEL);
	gi.FreeTags(TAG_GAME);
}

//======================================================
// Use this function to centerprint to all players.
// e.g. Com_Centerprint_All("---<<< FIGHT ! >>>---\n");
//======================================================
void Com_Centerprint_All(char *msg) {
	int i;
	edict_t *ent;
	
	for(i=0;i<ga.maxclients;i++) {
		ent=g_edicts+i+1;
		if (!G_EntExists(ent)) continue;
		gi_centerprintf(ent, msg); }
}

//============================================================
//============================================================
//============================================================

//============================================================
game_export_t *GetGameAPI(game_import_t *import) {
	
	gi=*import; // Make Global
	
	ge.apiversion=GAME_API_VERSION;
	ge.Init=InitGame;
	ge.Shutdown=ShutdownGame;
	ge.SpawnEntities=SpawnEntities;
	ge.WriteGame=WriteGame;
	ge.ReadGame=ReadGame;
	ge.WriteLevel=WriteLevel;
	ge.ReadLevel=ReadLevel;
	ge.ClientThink=ClientThink;
	ge.ClientConnect=ClientConnect;
	ge.ClientUserinfoChanged=ClientUserinfoChanged;
	ge.ClientDisconnect=ClientDisconnect;
	ge.ClientBegin=ClientBegin;
	ge.ClientCommand=ClientCommand;
	ge.RunFrame=G_RunFrame;
	ge.ServerCommand=ServerCommand;
	ge.edict_size=sizeof(edict_t);
	
	return &ge;
}

//============================================================
//============================================================
void Sys_Error(char *error, ...) {
	va_list argptr;
	char text[1024];
	
	va_start(argptr, error);
	vsprintf(text, error, argptr);
	va_end(argptr);
	
	gi.error(ERR_FATAL, "%s", text);
}

//============================================================
void Com_Printf(char *msg, ...) {
	va_list argptr;
	char text[1024];
	
	va_start(argptr, msg);
	vsprintf(text, msg, argptr);
	va_end(argptr);
	
	gi.dprintf("%s", text);
}

//============================================================
void ClientEndServerFrames(void){
	int i;
	edict_t *ent;
	
	for(i=0;i<ga.maxclients;i++) {
		ent=g_edicts+i+1;
		if (!G_EntExists(ent)) continue;
		ClientEndServerFrame(ent); }
}

//============================================================
edict_t *CreateTargetChangeLevel(char *map) {
	edict_t *ent;
	
	ent=G_Spawn();
	ent->classname="target_changelevel";
	Com_sprintf(level.nextmap, sizeof(level.nextmap), "%s", map);
	ent->map=level.nextmap;
	return ent;
}

//============================================================
void EndDMLevel(void) {
	edict_t *ent;
	char *s, *t, *f;
	static const char *seps=" ,\n\r";
	
	MonstersInUse=false;
	
	if ((int)dmflags->value & DF_SAME_LEVEL) {
		BeginIntermission(CreateTargetChangeLevel(level.mapname) );
		return; }
	
	// Clean up Linked List
	if (sv_bestplayer->value==1.0)
		G_ScrubEntList();
	
	// see if it's in the map list
	if (*sv_maplist->string) {
		s=strdup(sv_maplist->string);
		f=NULL;
		t=strtok(s, seps);
		while (t != NULL) {
			if (!Q_stricmp(t, level.mapname)) {
				// it's in the list, go to the next one
				t=strtok(NULL, seps);
				if (t == NULL) { // end of list, go to first one
					if (f == NULL) // there isn't a first one, same level
						BeginIntermission(CreateTargetChangeLevel(level.mapname) );
					else
						BeginIntermission(CreateTargetChangeLevel(f) ); }
				else
					BeginIntermission(CreateTargetChangeLevel(t) );
				free(s);
				return; }
			if (!f) f=t;
			t=strtok(NULL, seps); }
		free(s); }
	
	if (level.nextmap[0]) // go to a specific map
		BeginIntermission(CreateTargetChangeLevel(level.nextmap) );
	else {  // search for a changelevel
		ent=G_Find(NULL, FOFS(classname), "target_changelevel");
		if (!ent) {
			BeginIntermission(CreateTargetChangeLevel(level.mapname) );
			return; }
		BeginIntermission(ent); }
}

//============================================================
void CheckNeedPass(void) {
	int need;
	
	// if password or spectator_password has changed, update needpass as needed
	if (password->modified || spectator_password->modified) {
		password->modified=spectator_password->modified=false;
		need=0;
		if (*password->string && Q_stricmp(password->string, "none"))
			need |= 1;
		if (*spectator_password->string && Q_stricmp(spectator_password->string, "none"))
			need |= 2;
		gi.cvar_set("needpass", va("%d", need)); }
}

//============================================================
void CheckDMRules(void) {
	int i;
	gclient_t *cl;
	edict_t *ent;
	
	if (!CVAR_DEATHMATCH) return;
	
	if (level.intermissiontime) return;
	
	if (CVAR_TIMELIMIT)
		if (level.time >= CVAR_TIMELIMIT*60) {
			gi_bprintf(PRINT_HIGH, "Timelimit hit.\n");
			EndDMLevel();
			return; }
		
		if (CVAR_FRAGLIMIT)
			for(i=0;i<ga.maxclients;i++) {
				ent=g_edicts+i+1;
				if (!G_EntExists(ent)) continue;
				cl=ga.clients+i;
				if (cl->resp.score >= CVAR_FRAGLIMIT){
					gi_bprintf(PRINT_HIGH, "Fraglimit hit.\n");
					EndDMLevel();
					return; } }
}

//============================================================
void ExitLevel(void) {
	int i;
	edict_t *ent;
	char command[256];
	
	Com_sprintf(command, sizeof(command), "gamemap \"%s\"\n", level.changemap);
	gi.AddCommandString(command);
	level.changemap=NULL;
	level.exitintermission=0;
	level.intermissiontime=0;
	ClientEndServerFrames();
	
	// clear some things before going to next level
	for(i=0;i<ga.maxclients;i++) {
		ent=g_edicts+i+1;
		if (!G_EntExists(ent)) continue;
		if (ent->health > ent->client->pers.max_health)
			ent->health=ent->client->pers.max_health; }
}

//============================================================
void G_RunFrame(void) {
	int i;
	edict_t *ent;
	
	level.framenum++;
	level.time=level.framenum*FRAMETIME;
	
	// choose a client for monsters to target this frame
	AI_SetSightClient();
	
	// exit intermissions
	
	if (level.exitintermission) {
		ExitLevel();
		return; }
	
	//
	// treat each object in turn
	// even the world gets a chance to think
	//
	ent=&g_edicts[0];
	for (i=0; i<ge.num_edicts; i++, ent++) {
		if (!ent->inuse) continue;
		level.current_entity=ent;
		VectorCopy(ent->s.origin, ent->s.old_origin);
		// if the ground entity moved, make sure we are still on it
		if ((ent->groundentity) && (ent->groundentity->linkcount != ent->groundentity_linkcount)) {
			ent->groundentity=NULL;
			if ( !(ent->flags & (FL_SWIM|FL_FLY)) && (ent->svflags & SVF_MONSTER) )
				M_CheckGround(ent); }
		if (i > 0 && i<=maxclients->value) {
			ClientBeginServerFrame(ent);
			continue; }
		G_RunEntity(ent); }
	
	// see if it is time to end a deathmatch
	CheckDMRules();
	
	// see if needpass needs updated
	CheckNeedPass();
	
	// build the playerstate_t structures for all players
	ClientEndServerFrames();
}


