#include "defines.h"

//======================================================
//============ ARIAL LASERDRONE WEAPON =================
//======================================================

#define LAUNCH_SOUND      gi.soundindex("world/airhiss1.wav")
#define ACTIVATION_SOUND  gi.soundindex("world/boss3/W_loop.wav")
#define LASER_FIRE_SOUND  gi.soundindex("world/Gladiator/Railgun.wav")

//======================================================
void LaserDrone_Fire(edict_t *LaserDrone, edict_t *target){
	trace_t tr;
	vec3_t start,end;
	
	VectorCopy(LaserDrone->s.origin, start);
	VectorCopy(target->s.origin, end);
	
	// some minor adjustments to positioning
	start[2] += 70; end[2] += 8;
	
	// Find out what we hit at trace end point, if anything..
	tr = gi.trace(start, NULL, NULL, end, NULL, MASK_SHOT|MASK_MONSTERSOLID);
	
	// Fire the laser beam with bubbletrail from start to end..
	G_Spawn_Trails(TE_BFG_LASER, start, tr.endpos, tr.endpos);
	G_Spawn_Trails(TE_BUBBLETRAIL, start, tr.endpos, tr.endpos);
	
	// If end point entity(tr.ent) exists and can takedamage, then...
	if (G_EntExists(tr.ent) && (tr.ent->takedamage!=DAMAGE_NO)) {
		// Display a splash of blood from victim at impact point.
		G_Spawn_Sparks(TE_BLOOD, tr.endpos, tr.plane.normal, tr.endpos);
		// Apply damage to this victim..
		T_Damage(tr.ent, LaserDrone->owner, LaserDrone->owner, zvec, start, zvec, LaserDrone->dmg, 1, 0, MOD_LASERDRONE);
    } // endif
	else
		// Else, if the trace end point was NOT the sky, then ...
		if (!((tr.surface) && (tr.surface->flags & SURF_SKY))){
			// Show sparks at point of impact..
			G_Spawn_Sparks(TE_SCREEN_SPARKS, tr.endpos, tr.plane.normal, tr.endpos);
			// Do a radius damage of 100 units from sparks impact point..
			T_RadiusDamage(tr.ent, LaserDrone->owner, 100, NULL, LaserDrone->dmg, MOD_SPLASH);
		} // endif
		
		// Must play sound AFTER firing else targeting accuracy affected(??)
		gi.sound(LaserDrone, CHAN_VOICE, LASER_FIRE_SOUND, 1, ATTN_NORM, 0);
}

//======================================================
void LaserDrone_Die(edict_t *LaserDrone) {
	
	// Immediately Flag as OFF
	LaserDrone->owner->client->laserdrone=0;
	
	// Blow up the LaserDrone Unit and let debris rain down...
	G_Spawn_Explosion(TE_EXPLOSION2, LaserDrone->s.origin, LaserDrone->s.origin);
	
	// Let it rain, rain, rain...
	ThrowDebris(LaserDrone, DEBRIS3_MODEL, 3.75, LaserDrone->s.origin);
	ThrowDebris(LaserDrone, DEBRIS3_MODEL, 2.50, LaserDrone->s.origin);
	ThrowDebris(LaserDrone, DEBRIS2_MODEL, 4.60, LaserDrone->s.origin);
	ThrowDebris(LaserDrone, DEBRIS2_MODEL, 1.50, LaserDrone->s.origin);
	ThrowDebris(LaserDrone, DEBRIS3_MODEL, 2.30, LaserDrone->s.origin);
	ThrowDebris(LaserDrone, DEBRIS3_MODEL, 4.50, LaserDrone->s.origin);
	
	// Assign all frags to the LaserDrone's owner..
	T_RadiusDamage(LaserDrone, LaserDrone->owner, LaserDrone->dmg, NULL, LaserDrone->dmg_radius, MOD_SPLASH);
	
	G_FreeEdict(LaserDrone); // Free the LaserDrone entity.
}

//======================================================
// True if ent is within targeting criteria..
//======================================================
qboolean Good_Target(edict_t *LaserDrone, edict_t *player) {
	float rad;
	
	if ((player!=LaserDrone) && (player->takedamage!=DAMAGE_NO) && (visible(LaserDrone,player))) {
		// Targeting radius decreases with health of Drone.
		rad=LaserDrone->wait*(LaserDrone->health/LaserDrone->max_health);
		// Is this player within the targeting radius??
		return G_Within_Radius(LaserDrone->s.origin, player->s.origin, rad);
	} // endif
	
	return false;
}

//======================================================
// True if LaserDrone has been deactivated(exploded!).
//======================================================
qboolean DeActivated(edict_t *LaserDrone) {
	
	// Has time expired? Or, Owner since died?
	if ((LaserDrone->delay < level.time)
		||(LaserDrone->owner->client->laserdrone==OFF)) {
		LaserDrone_Die(LaserDrone);
		return true; }
	else
		return false;
}

//======================================================
// Need dummy touch because BBOX hits world surfaces..
//======================================================
void LaserDrone_Touch(edict_t *LaserDrone, edict_t *other, cplane_t *plane, csurface_t *surf)
{}

//==========================================================
// Search and Fire at all visible ents..(VERY FAST!)
//==========================================================
void LaserDrone_ThinkFast(edict_t *LaserDrone) {
	edict_t *ent=NULL;
	int i;
	
	if (DeActivated(LaserDrone)) return;  // Drone has exploded!
	
	if (deathmatch->value)
		for (i=0;i < game.maxclients;i++) {
			ent=g_edicts+i+1;
			if (!G_ClientInGame(ent)) continue;
			if (!Good_Target(LaserDrone,ent)) continue;
			LaserDrone_Fire(LaserDrone, ent); }
		else
			// Single Player Mode..
			while ((ent=findradius(ent, LaserDrone->s.origin, 1000))!= NULL) {
				if (!G_IsMonster(ent)) continue;
				if (ent==LaserDrone->owner) continue;
				LaserDrone_Fire(LaserDrone,ent); }
			
			// Initiate Re-targeting on next frame.
			LaserDrone->nextthink = level.time + 1.0;
}

//======================================================
void Activate_LaserDrone(edict_t *LaserDrone) {
	
	// Drone can take damage upon activation..
	LaserDrone->takedamage = DAMAGE_YES;
	// Start rotating the drone.
	LaserDrone->s.effects = EF_ROTATE;
	// Play Drone activation sound..
	gi.sound(LaserDrone, CHAN_VOICE, ACTIVATION_SOUND, 1, ATTN_NORM, 0);
	// Let Owner know that LaserDrone is now Active..
	gi_centerprintf(LaserDrone->owner, "LaserDrone Activated\n");
	
	LaserDrone->think = LaserDrone_ThinkFast; // Use the FAST TARGETING routine.
	LaserDrone->nextthink = level.time + 0.1; // Start thinking on next frame..
}

//======================================================
void Launch_LaserDrone(edict_t *ent) {
	edict_t *LaserDrone;
	int x=(random()>0.5?-1:1);
	int y=(random()>0.5?-1:1);
	vec3_t last_angles;
	
	VectorSet(last_angles,0,0,0);
	LaserDrone = G_Spawn();
	LaserDrone->classname = "LaserDrone";
	LaserDrone->owner = ent;
	
	VectorCopy(ent->s.origin, LaserDrone->s.origin);
	VectorCopy(ent->s.old_origin, LaserDrone->s.old_origin);
	LaserDrone->s.origin[0] += (random()*20+1)*x;
	LaserDrone->s.origin[1] += (random()*20+1)*y;
	LaserDrone->s.origin[2] += ent->viewheight+8;
	VectorCopy(ent->move_angles,last_angles);
	LaserDrone->velocity[2] = (random()*40);
	LaserDrone->velocity[1] = ((int)((random()*40)+10+last_angles[1])%60)*y;
	LaserDrone->velocity[0] = ((int)((random()*40)+20+last_angles[0])%60)*x;
	VectorCopy(LaserDrone->velocity, last_angles);
	
	LaserDrone->movetype = MOVETYPE_FLY;// Float around gently.
	LaserDrone->solid = SOLID_BBOX;     // Enable touch capability.
	LaserDrone->takedamage = DAMAGE_NO; // No Damage until Activation.
	LaserDrone->clipmask = MASK_SHOT;   // Ability to be hit by weapon's fire.
	LaserDrone->s.effects = EF_NONE;
	
	LaserDrone->s.modelindex = gi.modelindex("models/items/keys/target/tris.md2");
	
	LaserDrone->s.modelindex2 = 0; // no gun model..
	
	VectorSet(LaserDrone->mins, -20, -20, -40); // size of bbox for touch
	VectorSet(LaserDrone->maxs, 20, 20, 60);    // size of bbox for touch
	
	LaserDrone->dmg = 80;         // 80 units damaging power.
	LaserDrone->dmg_radius = 300; // 300 unit radius damage upon explosion.
	
	LaserDrone->health=200;     // titanium hull makes it tough to kill!!
	LaserDrone->max_health=200;
	LaserDrone->wait=1200;      // Used as search radius var!!
	
	if (deathmatch->value)
		LaserDrone->delay = level.time + 65.0; // This tape will self-destruct
	else                                     // in 60 secs. Good Luck Jim!
		LaserDrone->delay = level.time + 300;
	
	LaserDrone->touch=LaserDrone_Touch; // Dummy Function..
	
	LaserDrone->think = Activate_LaserDrone; // Done only once!
	
	LaserDrone->nextthink = level.time + 5.0; // 5 Sec delay before Activation..
	
	gi.linkentity(LaserDrone);
	
	ent->client->laserdrone = ON; // Flag LaserDrone as ON.
	
	gi_centerprintf(ent,"LaserDrone Launched\n\nMOVE AWAY NOW!!\n\n5 secs to Activation!\n");
	
	gi.sound(LaserDrone, CHAN_VOICE, LAUNCH_SOUND, 1, ATTN_NORM, 0);
}

//======================================================
// Pay the Piper to launch the Arial LaserDrone Unit
//======================================================
void Cmd_LaserDrone_f(edict_t *ent) {
	int index;
	
	// Don't allow dead/respawning players to launch drone!
	if (!G_ClientInGame(ent)) return;
	
	// Cost in Single-Player
	if (!deathmatch->value) {
		if (ent->health > 25)
			ent->health -= 25;
		Launch_LaserDrone(ent);
		return; }
	
	// If LaserDrone not already ON, then..
	if (ent->client->laserdrone==OFF) {
		// Check if ent has any powercells at all..
		index = ITEM_INDEX(item_cells);
		// If not enough cells or not enough frags then notify ent..
		if ((ent->client->pers.inventory[index] < 50) && (ent->client->resp.score < 5)){
			gi_centerprintf(ent, "LaserDrone requires 50 PowerCells\n\nor 5 Frags to Launch!");
			return; }
		// Try to deduct the cells first!
		if (ent->client->pers.inventory[index] >= 50) {
			// Deduct 50 cells from inventory
			ent->client->pers.inventory[index] -= 50;
			// And, activate the LaserDrone..
			Launch_LaserDrone(ent);
			return;
		} // endif
		// Otherwise, if ent has enough frags,
		if (ent->client->resp.score >= 5) {
			// Then, deduct frags from ent's Score
			ent->client->resp.score -= 5;
			// And, activate the LaserDrone..
			Launch_LaserDrone(ent);
			return;
		} // endif
    } // endif
	else
		// Turn OFF - Activate Self Destruct.
		ent->client->laserdrone=0;
}

