#include "defines.h"

//==============================================================
qboolean CanDamage(edict_t *targ, edict_t *inflictor) {
	vec3_t dest;
	trace_t tr;
	
	// bmodels need special checking because their origin is 0,0,0
	if (targ->movetype == MOVETYPE_PUSH) {
		VectorAdd(targ->absmin, targ->absmax, dest);
		VectorScale(dest, 0.5, dest);
		tr=gi.trace(inflictor->s.origin, zvec, zvec, dest, inflictor, MASK_SOLID);
		if (tr.fraction == 1.0)
			return true;
		return (tr.ent == targ); }
	
	tr=gi.trace(inflictor->s.origin, zvec, zvec, targ->s.origin, inflictor, MASK_SOLID);
	if (tr.fraction == 1.0)
		return true;
	
	VectorCopy(targ->s.origin, dest);
	dest[0] += 15.0;
	dest[1] += 15.0;
	tr=gi.trace(inflictor->s.origin, zvec, zvec, dest, inflictor, MASK_SOLID);
	if (tr.fraction == 1.0)
		return true;
	
	VectorCopy(targ->s.origin, dest);
	dest[0] += 15.0;
	dest[1] -= 15.0;
	tr=gi.trace(inflictor->s.origin, zvec, zvec, dest, inflictor, MASK_SOLID);
	if (tr.fraction == 1.0)
		return true;
	
	VectorCopy(targ->s.origin, dest);
	dest[0] -= 15.0;
	dest[1] += 15.0;
	tr=gi.trace(inflictor->s.origin, zvec, zvec, dest, inflictor, MASK_SOLID);
	if (tr.fraction == 1.0)
		return true;
	
	VectorCopy(targ->s.origin, dest);
	dest[0] -= 15.0;
	dest[1] -= 15.0;
	tr=gi.trace(inflictor->s.origin, zvec, zvec, dest, inflictor, MASK_SOLID);
	return (tr.fraction == 1.0);
}

//================================================================
// Anything to be used upon monster's death? Called from Killed()
//================================================================
void monster_death_use(edict_t *monster) {
	
	// Dead so make it drop to the ground..
	monster->flags &= ~(FL_FLY|FL_SWIM);
	
	// Make it a good guy monster (no attacking!)
	monster->monsterinfo.aiflags &= AI_GOOD_GUY;
	
	// Drop its present item, if any.
	if (monster->item) {
		Drop_Item(monster, monster->item);
		monster->item=NULL; }
	
	// Does it have a target that gets
	// activated when this monster dies?
	if (monster->deathtarget)
		monster->target=monster->deathtarget;
	
	// If so, then active it!
	if (monster->target)
		G_UseTargets(monster, monster->enemy);
}

//==============================================================
void Killed(edict_t *targ, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point) {
	
	if (attacker)
		attacker->enemy=NULL;
	
	if (targ->health < -999)
		targ->health= -999;
	
	targ->enemy=attacker;
	
	// Was this an XFlyer which just got shot down?
	if (!Q_stricmp(targ->classname, "XFlyer"))
		if (G_EntExists(attacker) && (attacker!=targ->rider)) {
			gi_centerprintf(attacker,"2 Frags for downing a Flyer!\n");
			attacker->client->resp.score += 2; }
		
		// Was this the Insane Marine which just got killed?
		if (!Q_stricmp(targ->classname, "XInsane"))
			if (G_EntExists(attacker) && (attacker!=targ->activator)) {
				gi_centerprintf(attacker,"1 Frag for killing Marine Decoy!\n");
				attacker->client->resp.score++; }
			
			// Was this a Shark which just got killed?
			if (!Q_stricmp(targ->classname, "XShark"))
				if (G_EntExists(attacker) && (attacker!=targ->activator)) {
					gi_centerprintf(attacker,"2 Frags for killing Shark!\n");
					attacker->client->resp.score += 2; }
				
				// Was this the Baton which just got killed?
				if (!Q_stricmp(targ->classname, "Baton")) {
					// Flag Baton_Think() to detonate on next frame.
					targ->owner->client->baton=OFF;
					// Give the attacker 2 frags for killing the Baton..
					if (G_EntExists(attacker) && (attacker!=targ->owner)) {
						gi_centerprintf(attacker,"2 Frags for destroying Baton!\n");
						attacker->client->resp.score += 2; }
					return; }
				
				// Was this the Chamber which just got killed?
				if (!Q_stricmp(targ->classname, "Chamber")) {
					// Flag to detonate on next frame.
					targ->owner->client->chamber=OFF;
					if (deathmatch->value)
						// Give the attacker 5 frags for killing the Chamber..
						if (G_EntExists(attacker) && (attacker!=targ->owner)) {
							gi_centerprintf(attacker,"5 Frags for destroying Chamber!\n");
							attacker->client->resp.score += 5; }
						return; }
				
				// Was this the LaserDrone which just got killed?
				if (!Q_stricmp(targ->classname, "LaserDrone")) {
					// Flag Drone Think() to detonate on next frame.
					targ->owner->client->laserdrone=OFF;
					if (deathmatch->value)
						// Give the attacker 5 frags for killing the Drone..
						if (G_EntExists(attacker) && (attacker!=targ->owner)) {
							gi_centerprintf(attacker,"5 Frags for destroying Drone!\n");
							attacker->client->resp.score += 5; }
						return; }
				
				// Was this a Monster which just got killed?
				if ((targ->svflags & SVF_MONSTER) && (targ->deadflag==DEAD_NO)) {
					// Make monster a good guy now (so he won't attack anybody)
					if (!(targ->monsterinfo.aiflags & AI_GOOD_GUY)) {
						level.killed_monsters++;
						if (CVAR_COOP && attacker->client)
							attacker->client->resp.score++;
						// medics won't heal monsters that they kill themselves
						if (!Q_stricmp(attacker->classname, "monster_medic"))
							targ->owner=attacker; } }
				
				if (targ->movetype == MOVETYPE_PUSH
					|| targ->movetype == MOVETYPE_STOP
					|| targ->movetype == MOVETYPE_NONE) {
					// doors, triggers, etc
					targ->die(targ, inflictor, attacker, damage, point);
					return; }
				
				// Does this Monster have a use function?
				if ((targ->svflags & SVF_MONSTER) && (targ->deadflag==DEAD_NO)) {
					targ->touch=NULL;
					monster_death_use(targ); }
				
				// Execute the target entity's die function.
				targ->die(targ, inflictor, attacker, damage, point);
}

//==============================================================
void SpawnDamage(int type, vec3_t origin, vec3_t normal, int damage) {
	if (damage > 255) damage=255;
	G_Spawn_Sparks(type, origin, normal, origin);
}

//==============================================================
static int CheckPowerArmor(edict_t *ent, vec3_t point, vec3_t normal, int damage, int dflags) {
	int save, power_armor_type;
	int index, damagePerCell;
	int pa_te_type, power, power_used;
	vec3_t vec, forward;
	float dot;
	
	if (!damage || dflags & DAMAGE_NO_ARMOR)
		return 0;
	
	if (ent->client) {
		power_armor_type=PowerArmorType(ent);
		if (power_armor_type != POWER_ARMOR_NONE) {
			index=ITEM_INDEX(item_cells);
			power=ent->client->pers.inventory[index]; } }
	else if (ent->svflags & SVF_MONSTER) {
		power_armor_type=ent->monsterinfo.power_armor_type;
		power=ent->monsterinfo.power_armor_power; }
	else
		return 0;
	
	if (!power || power_armor_type == POWER_ARMOR_NONE)
		return 0;
	
	// PowerScreen only works if damage point is in front
	if (power_armor_type == POWER_ARMOR_SCREEN) {
		AngleVectors(ent->s.angles, forward, NULL, NULL);
		VectorSubtract(point, ent->s.origin, vec);
		VectorNormalize(vec);
		dot=DotProduct(vec, forward);
		if (dot<=0.3) return 0;
		damagePerCell=1;
		pa_te_type=TE_SCREEN_SPARKS;
		damage=damage/3; }
	else {
		damagePerCell=2;
		pa_te_type=TE_SHIELD_SPARKS;
		damage=(2*damage)/3; }
	
	save=power*damagePerCell;
	if (!save) return 0;
	
	if (save > damage)
		save=damage;
	
	SpawnDamage(pa_te_type, point, normal, save);
	ent->powerarmor_time=level.time+0.2;
	
	power_used=save/damagePerCell;
	
	if (ent->client)
		ent->client->pers.inventory[index] -= power_used;
	else
		ent->monsterinfo.power_armor_power -= power_used;
	
	return save;
}

//==============================================================
static int CheckArmor(edict_t *ent, vec3_t point, vec3_t normal, int damage, int te_sparks, int dflags) {
	int save, index;
	gitem_t *armor;
	
	if (!damage || !ent->client) return 0;
	
	if (dflags & DAMAGE_NO_ARMOR) return 0;
	
	index=ArmorIndex(ent);
	if (!index) return 0;
	
	armor=GetItemByIndex(index);
	
	if (dflags & DAMAGE_ENERGY)
		save=ceil(((gitem_armor_t *)armor->info)->energy_protection*damage);
	else
		save=ceil(((gitem_armor_t *)armor->info)->normal_protection*damage);
	if (save >= ent->client->pers.inventory[index])
		save=ent->client->pers.inventory[index];
	
	if (!save) return 0;
	
	ent->client->pers.inventory[index] -= save;
	SpawnDamage(te_sparks, point, normal, save);
	
	return save;
}

//==============================================================
void M_ReactToDamage(edict_t *targ, edict_t *attacker) {
	
	if (!(attacker->client) && !(attacker->svflags & SVF_MONSTER))
		return;
	
	if (attacker == targ || attacker == targ->enemy)
		return;
	
	// if we are a good guy monster and our attacker is a player
	// or another good guy, do not get mad at them
	if (targ->monsterinfo.aiflags & AI_GOOD_GUY)
		if (attacker->client || (attacker->monsterinfo.aiflags & AI_GOOD_GUY))
			return;
		
		// we now know that we are not both good guys
		
		// if attacker is a client, get mad at them because he's good and we're not
		if (attacker->client) {
			targ->monsterinfo.aiflags &= ~AI_SOUND_TARGET;
			if (targ->enemy && targ->enemy->client) {
				if (visible(targ, targ->enemy)) {
					targ->oldenemy=attacker;
					return; }
				targ->oldenemy=targ->enemy; }
			targ->enemy=attacker;
			if (!(targ->monsterinfo.aiflags & AI_DUCKED))
				FoundTarget(targ);
			return; }
		
		// it's the same base(walk/swim/fly) type and a different classname and it's not a tank
		//(they spray too much), get mad at them
		if (((targ->flags & (FL_FLY|FL_SWIM)) ==(attacker->flags & (FL_FLY|FL_SWIM))) &&
			(Q_stricmp(targ->classname, attacker->classname)) &&
			(Q_stricmp(attacker->classname, "monster_tank")) &&
			(Q_stricmp(attacker->classname, "monster_supertank")) &&
			(Q_stricmp(attacker->classname, "monster_makron")) &&
			(Q_stricmp(attacker->classname, "monster_jorg"))) {
			if (targ->enemy && targ->enemy->client)
				targ->oldenemy=targ->enemy;
			targ->enemy=attacker;
			if (!(targ->monsterinfo.aiflags & AI_DUCKED))
				FoundTarget(targ); }
		// if they *meant* to shoot us, then shoot back
		else if (attacker->enemy == targ) {
			if (targ->enemy && targ->enemy->client)
				targ->oldenemy=targ->enemy;
			targ->enemy=attacker;
			if (!(targ->monsterinfo.aiflags & AI_DUCKED))
				FoundTarget(targ); }
		// otherwise get mad at whoever they are mad at unless it is us!
		else if (attacker->enemy && attacker->enemy != targ) {
			if (targ->enemy && targ->enemy->client)
				targ->oldenemy=targ->enemy;
			targ->enemy=attacker->enemy;
			if (!(targ->monsterinfo.aiflags & AI_DUCKED))
				FoundTarget(targ); }
}

//==============================================================
qboolean CheckTeamDamage(edict_t *targ, edict_t *attacker) {
	return false;
}

//============================================================
qboolean OnSameTeam(edict_t *ent1, edict_t *ent2) {
	char ent1Team[512], ent2Team[512];
	
	if (!((int)(dmflags->value) & (DF_MODELTEAMS|DF_SKINTEAMS)))
		return false;
	
	strcpy(ent1Team, ClientTeam(ent1));
	strcpy(ent2Team, ClientTeam(ent2));
	
	return (!Q_stricmp(ent1Team, ent2Team));
}

//==============================================================
#define LEG_DAMAGE (height/2)-abs(targ->mins[2])-3
#define STOMACH_DAMAGE (height/1.6)-abs(targ->mins[2])
#define CHEST_DAMAGE (height/1.4)-abs(targ->mins[2])

//==============================================================
float location_scaling(edict_t *targ, vec3_t point, float damage, int mod) {
	float z_rel, height;
	float scale=1.0;
	
	if (!targ->flags & FL_GODMODE)
		if (VectorLength(point) > 0)
			if ((mod == MOD_BLASTER) ||
				(mod == MOD_SHOTGUN) ||
				(mod == MOD_SSHOTGUN) ||
				(mod == MOD_MACHINEGUN) ||
				(mod == MOD_CHAINGUN) ||
				(mod == MOD_HYPERBLASTER) ||
				(mod == MOD_RAILGUN)) {
				height = abs(targ->mins[2]) + targ->maxs[2];
				z_rel = point[2]-targ->s.origin[2];
				if (z_rel < LEG_DAMAGE)
					scale = 0.35;  // Scale down by 2/3
				else if (z_rel < STOMACH_DAMAGE)
					scale = 0.6;   // Scale down by 1/3
				else if (z_rel < CHEST_DAMAGE)
					scale = 1.2;   // Scale up by 1/5
				else
					scale = 10;}   // Scale up by 10X
			
			return scale;
}

//==============================================================
void T_Damage(edict_t *targ, edict_t *inflictor, edict_t *attacker, vec3_t dir, vec3_t point, vec3_t normal, int damage, int knockback, int dflags, int mod) {
	int take, save, asave, psave, te_sparks;
	vec3_t kvel;
	float mass;
	
	if (targ->takedamage==DAMAGE_NO) return;
	
	// if rocket jump by owner then no damage
	if (mod==MOD_R_SPLASH)
		if ((targ==attacker) && (attacker==inflictor->owner))
			damage=0;
		
		// friendly fire avoidance
		if ((targ != attacker) && ((CVAR_DEATHMATCH && ((int)(dmflags->value) & (DF_MODELTEAMS|DF_SKINTEAMS))) || CVAR_COOP))
			if (OnSameTeam(targ, attacker))
				if ((int)(dmflags->value) & DF_NO_FRIENDLY_FIRE)
					damage=0;
				else
					mod |= MOD_FRIENDLY_FIRE;
				
				damage *= location_scaling(targ, point, damage, mod);
				
				meansOfDeath=mod;
				
				// easy mode takes half damage
				if (CVAR_SKILL == SKILL_EASY && !CVAR_DEATHMATCH && targ->client) {
					damage *= 0.5;
					if (!damage)
						damage=1; }
				
				te_sparks=(dflags & DAMAGE_BULLET)?TE_BULLET_SPARKS:TE_SPARKS;
				
				VectorNormalize(dir);
				
				// bonus damage for suprising a monster
				if (!(dflags & DAMAGE_RADIUS) && (targ->svflags & SVF_MONSTER) && (attacker->client) && (!targ->enemy) && (targ->health > 0))
					damage *= 2;
				
				if (targ->flags & FL_NO_KNOCKBACK)
					knockback=0;
				
				// figure momentum add
				if (!(dflags & DAMAGE_NO_KNOCKBACK)) {
					if ((knockback) && (targ->movetype != MOVETYPE_NONE) && (targ->movetype != MOVETYPE_BOUNCE) && (targ->movetype != MOVETYPE_PUSH) && (targ->movetype != MOVETYPE_STOP)) {
						mass=(targ->mass<50)?50:targ->mass;
						if (targ->client  && attacker == targ)
							VectorScale(dir, 1600.0*(float)knockback/mass, kvel);
						else
							VectorScale(dir, 500.0*(float)knockback/mass, kvel);
						VectorAdd(targ->velocity, kvel, targ->velocity); } }
				
				take=damage;
				save=0;
				
				// check for godmode
				if ((targ->flags & FL_GODMODE) && !(dflags & DAMAGE_NO_PROTECTION)) {
					take=0;
					save=damage;
					SpawnDamage(te_sparks, point, normal, save); }
				
				// check for invincibility
				if ((targ->client && targ->client->invincible_framenum > level.framenum) && !(dflags & DAMAGE_NO_PROTECTION)) {
					if (targ->pain_debounce_time < level.time) {
						gi.sound(targ, CHAN_ITEM, gi.soundindex("items/protect4.wav"), 1, ATTN_NORM, 0);
						targ->pain_debounce_time=level.time+2; }
					take=0;
					save=damage; }
				
				psave=CheckPowerArmor(targ, point, normal, take, dflags);
				take -= psave;
				
				asave=CheckArmor(targ, point, normal, take, te_sparks, dflags);
				take -= asave;
				
				//treat cheat/powerup savings the same as armor
				asave += save;
				
				// team damage avoidance
				if (!(dflags & DAMAGE_NO_PROTECTION) && CheckTeamDamage(targ, attacker))
					return;
				
				// do the damage
				if (take) {
					if ((targ->svflags & SVF_MONSTER) || (targ->client))
						SpawnDamage(TE_BLOOD, point, normal, take);
					else
						SpawnDamage(te_sparks, point, normal, take);
					targ->health=targ->health-take;
					if (targ->health<=0) {
						if ((targ->svflags & SVF_MONSTER) || (targ->client))
							targ->flags |= FL_NO_KNOCKBACK;
						Killed(targ, inflictor, attacker, take, point);
						return; } }
				
				if (targ->svflags & SVF_MONSTER) {
					M_ReactToDamage(targ, attacker);
					if (!(targ->monsterinfo.aiflags & AI_DUCKED) && (take)) {
						targ->pain(targ, attacker, knockback, take);
						if (CVAR_SKILL == NIGHTMARE_MODE)
							targ->pain_debounce_time=level.time+5; } }
				else if (targ->client) {
					if (!(targ->flags & FL_GODMODE) && (take))
						targ->pain(targ, attacker, knockback, take); }
				else if (take)
					if (targ->pain)
						targ->pain(targ, attacker, knockback, take);
					
					if (targ->client) {
						targ->client->damage_parmor += psave;
						targ->client->damage_armor += asave;
						targ->client->damage_blood += take;
						targ->client->damage_knockback += knockback;
						VectorCopy(point, targ->client->damage_from); }
}

//==============================================================
void T_RadiusDamage(edict_t *inflictor, edict_t *attacker, float damage, edict_t *ignore, float radius, int mod) {
	float points;
	edict_t *ent=NULL;
	vec3_t v, dir;
	
	while ((ent=findradius(ent, inflictor->s.origin, radius)) != NULL) {
		if (ent==ignore || ent->takedamage==DAMAGE_NO) continue;
		VectorAdd(ent->mins, ent->maxs, v);
		VectorMA(ent->s.origin, 0.5, v, v);
		VectorSubtract(inflictor->s.origin, v, v);
		// Use Warzone's modified radius damage calculation..
		points = damage*1-(sqrt(VectorLength(v))/sqrt(radius));
		if (ent == attacker)
			points=points*0.5;
		if (points > 0)
			if (CanDamage(ent, inflictor)) {
				VectorSubtract(ent->s.origin, inflictor->s.origin, dir);
				T_Damage(ent, inflictor, attacker, dir, inflictor->s.origin, zvec,(int)points,(int)points, DAMAGE_RADIUS, mod); } }
}
