
//=============================================
void WriteGame(char *filename, qboolean autosave);
void ReadGame(char *filename);
void WriteLevel(char *filename);
void ReadLevel(char *filename);
void InitGame(void);

// Airstrike Functions
void spawn_aircraft(edict_t *ent);
void Cmd_Airstrike_f(edict_t *ent);
qboolean Launch_Airstrike(edict_t *ent, int cmd);

void Toss_SharkBarrel(edict_t *ent);
void Spawn_DepthCharge(edict_t *ent);
//=============================================
void VectorMA(vec3_t veca, float scale, vec3_t vecb, vec3_t vecc);
char *vtos(vec3_t v);
float vectoyaw(vec3_t vec);
void vectoangles(vec3_t vec, vec3_t angles);
vec_t _DotProduct(vec3_t v1, vec3_t v2);
void _VectorSubtract(vec3_t veca, vec3_t vecb, vec3_t out);
void _VectorAdd(vec3_t veca, vec3_t vecb, vec3_t out);
void _VectorCopy(vec3_t in, vec3_t out);
void ClearBounds(vec3_t mins, vec3_t maxs);
void AddPointToBounds(vec3_t v, vec3_t mins, vec3_t maxs);
int VectorCompare(vec3_t v1, vec3_t v2);
vec_t _VectorLength(vec3_t v);
vec_t VectorLength(vec3_t v);
void CrossProduct(vec3_t v1, vec3_t v2, vec3_t cross);
vec_t VectorNormalize(vec3_t v);    // returns vector length
vec_t VectorNormalize2(vec3_t v, vec3_t out);
void VectorInverse(vec3_t v);
void VectorScale(vec3_t in, vec_t scale, vec3_t out);
int Q_log2(int val);
void R_ConcatRotations(float in1[3][3], float in2[3][3], float out[3][3]);
void R_ConcatTransforms(float in1[3][4], float in2[3][4], float out[3][4]);
void AngleVectors(vec3_t angles, vec3_t forward, vec3_t right, vec3_t up);
int BoxOnPlaneSide(vec3_t emins, vec3_t emaxs, struct cplane_s *plane);
float anglemod(float a);
float LerpAngle(float a1, float a2, float frac);
void abs_vector(vec3_t vec1, vec3_t vec2, vec3_t result);
void min_vector(vec3_t start, vec3_t end1, vec3_t end2, vec3_t result);
void ProjectPointOnPlane( vec3_t dst, const vec3_t p, const vec3_t normal );
void PerpendicularVector( vec3_t dst, const vec3_t src );
void RotatePointAroundVector( vec3_t dst, const vec3_t dir, const vec3_t point, float degrees );

//=============================================
char *COM_SkipPath(char *pathname);
void COM_StripExtension(char *in, char *out);
void COM_FileBase(char *in, char *out);
void COM_FilePath(char *in, char *out);
void COM_DefaultExtension(char *path, char *extension);
char *COM_Parse(char **data_p);
void Com_sprintf(char *dest, int size, char *fmt, ...);
void Com_PageInMemory(byte *buffer, int size);

//=============================================
int Q_stricmp(char *s1, char *s2);
int Q_strcasecmp(char *s1, char *s2);
int Q_strncasecmp(char *s1, char *s2, int n);


//=============================================
short BigShort(short l);
short LittleShort(short l);
int   BigLong(int l);
int   LittleLong(int l);
float BigFloat(float l);
float LittleFloat(float l);
void  Swap_Init(void);
char  *va(char *format, ...);

char *Info_ValueForKey(char *s, char *key);
void Info_RemoveKey(char *s, char *key);
void Info_SetValueForKey(char *s, char *key, char *value);
qboolean Info_Validate(char *s);

char  *Sys_FindFirst(char *path, unsigned musthave, unsigned canthave );
char  *Sys_FindNext( unsigned musthave, unsigned canthave );
void  Sys_FindClose(void);
// this is only here so the functions in q_shared.c and q_shwin.c can link
void Sys_Error(char *error, ...);
void Com_Printf(char *msg, ...);
int    Sys_Milliseconds(void);
void  Sys_Mkdir(char *path);
void Com_Centerprint_All(char *msg);

// large block stack allocation routines
void *Hunk_Begin(int maxsize);
void *Hunk_Alloc(int size);
void Hunk_Free(void *buf);
int Hunk_End(void);

void Weapon_Blaster(edict_t *ent);
void Weapon_Shotgun(edict_t *ent);
void Weapon_SuperShotgun(edict_t *ent);
void Weapon_Machinegun(edict_t *ent);
void Weapon_Chaingun(edict_t *ent);
void Weapon_HyperBlaster(edict_t *ent);
void Weapon_RocketLauncher(edict_t *ent);
void Weapon_Grenade(edict_t *ent);
void Weapon_GrenadeLauncher(edict_t *ent);
void Weapon_Railgun(edict_t *ent);
void Weapon_BFG(edict_t *ent);
void Hook_Touch(edict_t *hook, edict_t *other, cplane_t *plane, csurface_t *surf);
void Fire_Grapple_Hook(edict_t *ent);
void Hook_Behavior(edict_t *hook);
void DropHook(edict_t *hook);
void SP_misc_teleporter_dest(edict_t *self);

//
// g_cmds.c
//
void Cmd_Help_f(edict_t *ent);
void Cmd_Score_f(edict_t *ent);
void Cmd_Hook_f(edict_t *ent, char *s);
void Cmd_Baton_f(edict_t *ent);
void Cmd_InsaneDecoy_f(edict_t *ent);
void Cmd_BoobyTrap_f(edict_t *ent);
void Cmd_LaserSweep_f(edict_t *ent);
void Cmd_LaserFence_f(edict_t *ent);
void Spawn_LaserCorral(edict_t *ent);
void Cmd_LaserDrone_f(edict_t *ent);
void Cmd_DeathPak_f(edict_t *ent);
void Cmd_Chamber_f(edict_t *ent);
void Cmd_HangMan_f(edict_t *ent);
void Link_All_Together(edict_t *botpad);
//
// g_items.c
//
void SetRespawn(edict_t *ent, float delay);
void PrecacheItem(gitem_t *it);
void InitItems(void);
void SetItemNames(void);
gitem_t *FindItem(char *pickup_name);
gitem_t *FindItemByClassname(char *classname);
edict_t *Drop_Item(edict_t *ent, gitem_t *item);
void respawn(edict_t *ent);
void SpawnEntities(char *mapname, char *entities, char *spawnpoint);
void SelectSpawnPoint(edict_t *ent, vec3_t origin, vec3_t angles);
void spectator_respawn(edict_t *ent);
trace_t PM_trace(vec3_t start, vec3_t mins, vec3_t maxs, vec3_t end);
void ChangeWeapon(edict_t *ent);
void SpawnItem(edict_t *ent, gitem_t *item);
void Think_Weapon(edict_t *ent);
int ArmorIndex(edict_t *ent);
int PowerArmorType(edict_t *ent);
gitem_t *GetItemByIndex(int index);
qboolean Add_Ammo(edict_t *ent, gitem_t *item, int count);
void Touch_Item(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void SelectNextItem(edict_t *ent, int itflags);
void SelectPrevItem(edict_t *ent, int itflags);

//
// p.hud.c
//
void DeathmatchScoreboard(edict_t *ent);

//
// g_utils.c
//
qboolean KillBox(edict_t *ent);
void Telefrag_All(edict_t *ent);
void G_ProjectSource(vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result);
void P_ProjectSource(gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result);
void P_ProjectSource_Reverse(gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result);
edict_t *G_Find(edict_t *from, int fieldofs, char *match);
edict_t *findradius(edict_t *from, vec3_t org, float rad);
edict_t *G_PickTarget(char *targetname);
void G_UseTargets(edict_t *ent, edict_t *activator);
void G_SetMovedir(vec3_t angles, vec3_t movedir);
void G_InitEdict(edict_t *e);
void G_RunFrame(void);
qboolean G_IsDeathmatch(edict_t *self);
edict_t  *G_Spawn(void);
void G_FreeEdict(edict_t *e);
void G_TouchTriggers(edict_t *ent);
void G_TouchSolids(edict_t *ent);

//
// g_combat.c
//
qboolean OnSameTeam(edict_t *ent1, edict_t *ent2);
qboolean CanDamage(edict_t *targ, edict_t *inflictor);
void T_Damage(edict_t *targ, edict_t *inflictor, edict_t *attacker, vec3_t dir, vec3_t point, vec3_t normal, int damage, int knockback, int dflags, int mod);
void T_RadiusDamage(edict_t *inflictor, edict_t *attacker, float damage, edict_t *ignore, float radius, int mod);

//
// g_monster.c
//
void monster_fire_chaingun(edict_t *self, vec3_t start, vec3_t dir, int damage, int kick, int hspread, int vspread);
void monster_fire_bullet(edict_t *self, vec3_t start, vec3_t dir, int damage, int kick, int hspread, int vspread, int flashtype);
void monster_fire_shotgun(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int count, int flashtype);
void monster_fire_blaster(edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int flashtype, int effect);
void monster_fire_grenade(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, int flashtype);
void monster_fire_rocket(edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int flashtype);
void monster_fire_railgun(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int flashtype);
void monster_fire_bfg(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, int kick, float damage_radius, int flashtype);
void M_droptofloor(edict_t *ent);
void monster_think(edict_t *self);
void walkmonster_start(edict_t *self);
qboolean G_Spawn_Monster(edict_t *ent, vec3_t torigin, int mtype, float secs);
void flymonster_start(edict_t *self);
void monster_death_use(edict_t *self);
void M_CatagorizePosition(edict_t *ent);
qboolean M_CheckAttack(edict_t *self);
void M_FlyCheck(edict_t *self);
void M_CheckGround(edict_t *ent);
void monster_start_go(edict_t *self);
//
// g_misc.c
//
void ThrowHead(edict_t *self, char *gibname, int damage, int type);
void ThrowClientHead(edict_t *self, int damage);
void ThrowGib(edict_t *self, char *gibname, int damage, int type);
void BecomeExplosion1(edict_t *self);

//
// g_ai.c
//
void AI_SetSightClient(void);
void ai_stand(edict_t *self, float dist);
void ai_move(edict_t *self, float dist);
void ai_walk(edict_t *self, float dist);
void ai_turn(edict_t *self, float dist);
void ai_run(edict_t *self, float dist);
void ai_charge(edict_t *self, float dist);
int range(edict_t *self, edict_t *other);
void FoundTarget(edict_t *self);
qboolean infront(edict_t *self, edict_t *other);
qboolean visible(edict_t *self, edict_t *other);
qboolean FacingIdeal(edict_t *self);

//=============================================
void SP_monster_jorg(edict_t *self);
void SP_monster_boss2(edict_t *self);
void SP_monster_berserk(edict_t *self);
void SP_monster_soldier_ss(edict_t *self);
void SP_monster_soldier(edict_t *self);
void SP_monster_brain(edict_t *self);
void SP_monster_chick(edict_t *self);
void SP_monster_flipper(edict_t *self);
void SP_monster_floater(edict_t *self);
void SP_monster_flyer(edict_t *self);
void SP_monster_gladiator(edict_t *self);
void SP_monster_hover(edict_t *self);
void SP_monster_infantry(edict_t *self);
void SP_misc_insane(edict_t *self);
void SP_monster_medic(edict_t *self);
void SP_monster_mutant(edict_t *self);
void SP_monster_parasite(edict_t *self);
void SP_monster_tank(edict_t *self);
void SP_monster_makron(edict_t *self);
void SP_monster_gunner(edict_t *self);
void SP_monster_supertank(edict_t *self);
void SP_monster_soldier_light(edict_t *self);

void SP_monster_boss3_stand(edict_t *self);
void SP_monster_commander_body(edict_t *self);
void SP_turret_breach(edict_t *self);
void SP_turret_base(edict_t *self);
void SP_turret_driver(edict_t *self);

void monster_triggered_start(edict_t *monster);
qboolean monster_start(edict_t *monster);
void monster_dead(edict_t *monster);
//
// g_weapon.c
//
void ThrowDebris(edict_t *self, char *modelname, float speed, vec3_t origin);
qboolean fire_hit(edict_t *self, vec3_t aim, int damage, int kick);
void fire_bullet(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int mod);
void fire_shotgun(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int count, int mod);
void fire_blaster(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, int effect, qboolean hyper);
void fire_grenade(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
void fire_grenade2(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius, qboolean held);
void fire_rocket(edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage);
void fire_rail(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick);
void fire_bfg(edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius);

//
// g_ptrail.c
//
void PlayerTrail_Init(void);
void PlayerTrail_Add(vec3_t spot);
edict_t *PlayerTrail_PickFirst(edict_t *self);
edict_t *PlayerTrail_PickNext(edict_t *self);
edict_t *PlayerTrail_LastSpot(void);
void PlayerTrail_ShowTrail(void);

//
// p_client.c
//
void BeginIntermission(edict_t *targ);
void PutClientInServer(edict_t *ent);
void InitClientPersistant(gclient_t *client);
void InitClientResp(gclient_t *client);
void InitBodyQue(void);
void ClientBegin(edict_t *ent);
void ClientBeginServerFrame(edict_t *ent);
void ClientDisconnect(edict_t *ent);
void ClientThink(edict_t *ent, usercmd_t *cmd);
void ClientCommand(edict_t *ent);

//
// g_player.c
//
void player_die(edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
void player_pain(edict_t *self, edict_t *other, float kick, int damage);
void player_touch(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void player_use(edict_t *button, edict_t *other, edict_t *activator);
void Grenade_Touch(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void Grenade_Explode(edict_t *ent);
//
// g_svcmds.c
//
void ServerCommand(void);
qboolean SV_FilterPacket(char *from);
qboolean SV_StepDirection(edict_t *monster, float yaw, float dist);
void SV_NewChaseDir(edict_t *actor, edict_t *enemy, float dist);

//
// p_view.c
//
void ClientEndServerFrame(edict_t *ent);

//
// p_hud.c
//
void MoveClientToIntermission(edict_t *client);
void G_SetStats(edict_t *ent);
void G_SetSpectatorStats(edict_t *ent);
void G_CheckChaseStats(edict_t *ent);
void ValidateSelectedItem(edict_t *ent);
void DeathmatchScoreboardMessage(edict_t *client, edict_t *killer);

//
// g_pweapon.c
//
void PlayerNoise(edict_t *who, vec3_t where, int type);

//
// m_move.c
//
qboolean M_CheckBottom(edict_t *ent);
qboolean M_walkmove(edict_t *ent, float yaw, float dist);
void M_MoveToGoal(edict_t *ent, float dist);
void M_ChangeYaw(edict_t *ent);

//
// g_phys.c
//
void G_RunEntity(edict_t *ent);

//
// g_main.c
//
void SaveClientData(void);
void FetchClientEntData(edict_t *ent);
char *ClientTeam(edict_t *ent);
//
// g_chase.c
//
void UpdateChaseCam(edict_t *ent);
void ChaseNext(edict_t *ent);
void ChasePrev(edict_t *ent);
void GetChaseTarget(edict_t *ent);

// EntList Routines
void G_AddToEntList(edict_t *ent);
void G_RemoveFromEntList(edict_t *ent);
void G_ScrubEntList(void);
edict_t *G_GetRandomEnt(void);
edict_t *G_GetBestScoreEnt(void);
edict_t *G_GetNextEnt(void);
edict_t *BestScoreEnt(void);

// Misc functions
qboolean visible(edict_t *self, edict_t *other);
qboolean visible2(edict_t *self, edict_t *other);
qboolean infront(edict_t *self, edict_t *other);
qboolean FindTarget(edict_t *self);

qboolean G_Within_Radius(vec3_t start, vec3_t end, float rad);
qboolean G_ClientInGame(edict_t *ent);
qboolean G_EntExists(edict_t *ent);
qboolean G_ClientNotDead(edict_t *ent);
qboolean G_IsMonster(edict_t *ent);
qboolean G_ClearPath(vec3_t spot1, vec3_t spot2);
void G_Spawn_Models(int type, short rec_no, vec3_t start, vec3_t endpos, vec3_t offset, vec3_t origin );
void G_Spawn_Splash(int type, int count, int color, vec3_t start, vec3_t movdir, vec3_t origin);
void G_Spawn_Trails(int type, vec3_t start, vec3_t endpos, vec3_t origin);
void G_Spawn_Sparks(int type, vec3_t start, vec3_t movdir, vec3_t origin);
void G_Spawn_Explosion(int type, vec3_t start, vec3_t origin);
void G_Spawn_Steam(int count, vec3_t origin, vec3_t movedir, int color, int speed);
void G_MuzzleFlash(short rec_no, vec3_t start, int flashtype);
void G_MuzzleFlash2(short rec_no, vec3_t start, int flashtype);
void G_StuffText(edict_t *ent, char *str, qboolean unicast);
void G_WriteInventory(edict_t *ent);
void G_WriteLayout(edict_t *ent, char *str);

qboolean IsFemale(edict_t *ent);
void ED_CallSpawn(edict_t *ent);
int PlayerSort(void const *a, void const *b);
qboolean Pickup_Weapon(edict_t *ent, edict_t *other);
void CopyToBodyQue(edict_t *ent);
void TossClientWeapon(edict_t *self);
void NoAmmoWeaponChange(edict_t *ent);
void ClientObituary(edict_t *self, edict_t *inflictor, edict_t *attacker);
void ClientUserinfoChanged(edict_t *ent, char *userinfo);
qboolean ClientConnect(edict_t *ent, char *userinfo);
int G_GetFreeEdict(void);

// Item handling routines.
int WeapIndex(gitem_t *weapon);
int AmmoIndex(gitem_t *weapon);
qboolean AlreadyAtMaxAmmo(edict_t *ent, gitem_t *ammo);
qboolean AlreadyAtMaxArmor(edict_t *ent, gitem_t *newarmor);
qboolean HasWeaponInInventory(edict_t *self, gitem_t *weapon);
qboolean HasSpecialInInventory(edict_t *self, gitem_t *item);
qboolean HasAmmoForWeapon(edict_t *self, gitem_t *weapon);
qboolean HasWeaponForAmmo(edict_t *self, gitem_t *ammo);
qboolean IsAmmo(gitem_t *item);
qboolean IsArmor(gitem_t *item);
qboolean IsHealth(gitem_t *item);
qboolean IsWeapon(gitem_t *item);
qboolean IsPowerup(gitem_t *item);
qboolean IsKey(gitem_t *item);
qboolean CanSwitchToThisWeapon(edict_t *self, gitem_t *weapon);
void GetCloseWeapon(edict_t *self);
void GetFarWeapon(edict_t *self);
void GetBestWeapon(edict_t *self);

float G_Distance(edict_t *ent1, edict_t *ent2);
void gi_bprintf(int printlevel, char *fmt, ...);
void gi_cprintf(edict_t *ent, int printlevel, char *fmt, ...);
void gi_centerprintf(edict_t *ent, char *fmt, ...);
void Spawn_DeathPak(edict_t *ent);
void Shoot_Hook(edict_t *ent);
void Fire_Baton(edict_t *ent);
qboolean SetBoobyTrap(edict_t *ent, int index);
void Use_Plat(edict_t *ent, edict_t *other, edict_t *activator);
qboolean SV_RunThink(edict_t *ent);
void Cmd_Flyer_f(edict_t *ent);


