#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/timeb.h>

#if (defined _M_IX86 || defined __i386__) && !defined C_ONLY && !defined __sun__
  #define id386  1
#else
  #define id386  0
#endif

#if defined _M_ALPHA && !defined C_ONLY
  #define idaxp  1
#else
  #define idaxp  0
#endif

#ifdef _WIN32
  #pragma warning(disable:4244)  // MIPS
  #pragma warning(disable:4136)  // X86
  #pragma warning(disable:4051)  // ALPHA
  #pragma warning(disable:4018)  // signed/unsigned mismatch
  #pragma warning(disable:4305)  // truncation from const double to float
#endif

#ifndef NULL
  #define NULL ((void *)0)
#endif

#define GAMEVERSION "baseq2"

#define GAME_API_VERSION 3

#define world &g_edicts[0] // edict [0] is world().

//==========================================
//======== Global Maximum Settings =========
//==========================================

#define MAX_ENT_CLUSTERS   16 // max clusternums[]
#define MAX_STATS          32 // max status bar entries
#define MAX_TOUCH          32 // max touchents[]
#define MAX_QPATH          64 // max Quake2 string length
#define MAX_INFO_KEY       64 // max len of info key strings
#define MAX_INFO_VALUE     64 // max len of info value strings
#define MAX_STRING_TOKENS  80 // unused in v3.20
#define MAX_OSPATH        128 // max length of a filesystem path
#define MAX_TOKEN_CHARS   128 // max com_token[] strings
#define MAX_LIGHTSTYLES   256 // max light styles.
#define MAX_MODELS        256 // max models in precache list.
#define MAX_SOUNDS        256 // max sounds in precache list.
#define MAX_IMAGES        256 // max images in precache list.
#define MAX_ITEMS         256 // max items in inventory list.
#define MAX_CLIENTS       256 // max allowable clients
#define MAX_INFO_STRING   512 // max userinfo[] strings
#define MAX_GENERAL       512 // (2*MAX_CLIENTS)
#define MAX_STRING_CHARS 1024 // unused in v3.20
#define MAX_EDICTS       1024 // max available edict_t recs
#define MAX_WORLD_HEIGHT 8192 // max distance across world (-4096..4096)

#define ITEM_INDEX(x) ((x)-itemlist)

#define BODY_QUEUE_SIZE     8 // Reserve some space for queuing Dead Players

float Q_fabs(float f);
#define fabs(f) Q_fabs(f)

#if !defined C_ONLY && !defined __linux__ && !defined __sgi
  extern long Q_ftol(float f);
#else
  #define Q_ftol(f) (long)(f)
#endif

#define OFF 0
#define ON  1

//==========================================
//========== Grappling Hook States =========
//==========================================

#define HOOK_OFF   0  // set if hook command is active
#define HOOK_ON    1  // set if hook command is active
#define SHRINK_ON  2  // set if shrink chain is active
#define GROW_ON    4  // set if grow chain is active

//==========================================
//========== Laser Beam Colors =============
//==========================================

// Laser Beam Color Codes
#define Laser_Red         0xf2f2f0f0  // bright red
#define Laser_Green       0xd0d1d2d3  // bright green
#define Laser_Blue        0xf3f3f1f1  // bright blue
#define Laser_Yellow      0xdcdddedf  // bright yellow
#define Laser_YellowS     0xe0e1e2e3  // yellow strobe
#define Laser_DkPurple    0x80818283  // dark purple
#define Laser_LtBlue      0x70717273  // light blue
#define Laser_Green2      0x90919293  // different green
#define Laser_Purple      0xb0b1b2b3  // purple
#define Laser_Red2        0x40414243  // different red
#define Laser_Orange      0xe2e5e3e6  // orange
#define Laser_Mix         0xd0f1d3f3  // mixture
#define Laser_RedBlue     0xf2f3f0f1  // inner = red, outer = blue
#define Laser_BlueRed     0xf3f2f1f0  // inner = blue, outer = red
#define Laser_GreenY      0xdad0dcd2  // inner = green, outer = yellow
#define Laser_YellowG     0xd0dad2dc  // inner = yellow, outer = green

//==========================================
//===== Vector Manipulation Defines ========
//==========================================

#define DotProduct(x,y)       (x[0]*y[0]+x[1]*y[1]+x[2]*y[2])
#define VectorSubtract(a,b,c) (c[0]=a[0]-b[0],c[1]=a[1]-b[1],c[2]=a[2]-b[2])
#define VectorAdd(a,b,c)      (c[0]=a[0]+b[0],c[1]=a[1]+b[1],c[2]=a[2]+b[2])
#define VectorPlus(c,a)       (c[0]+=a[0],c[1]+=a[1],c[2]+=a[2])
#define VectorDivide(v,i)     (v[0]/=i,v[1]/=i,v[2]/=i)
#define VectorMultiply(v,f)   (v[0]*=f,v[1]*=f,v[2]*=f)
#define VectorCopy(a,b)       (b[0]=a[0],b[1]=a[1],b[2]=a[2])
#define VectorClear(a)        (a[0]=a[1]=a[2]=0)
#define VectorNegate(a,b)     (b[0]=-a[0],b[1]=-a[1],b[2]=-a[2])
#define VectorSet(v,x,y,z)    (v[0]=(x),v[1]=(y),v[2]=(z))

//==========================================
//========== Vector Angle Flags ============
//==========================================

#define PITCH 0  // up / down
#define YAW   1  // left / right
#define ROLL  2  // fall over

//==========================================
//========== CVAR SKILL FLAGS ==============
//==========================================

#define SKILL_EASY      0
#define SKILL_MEDIUM    1
#define SKILL_HARD      2
#define NIGHTMARE_MODE  3

//==========================================
//====== RANDOM NUMBER GENERATORS ==========
//==========================================

#define random()  ((rand()&0x7fff)/((float)0x7fff))
#define crandom()  (2.0*(random()-0.5))
#define rndnum(y,z)((random()*((z)-((y)+1)))+(y))

//==========================================
//========== SOME MATH DEFINITIONS =========
//==========================================

#define DEG2RAD(a) (a*M_PI)/180.0F

#define ANGLE2SHORT(x) ((int)((x)*65536/360)&65535)
#define SHORT2ANGLE(x) ((x)*(360.0/65536))

#define MaxOf(x,y) (x>y?x:y)
#define MinOf(x,y) (x<y?x:y)

#define nanmask (255<<23)
#define IS_NAN(x) (((*(int *)&x)&nanmask)==nanmask)

#ifndef M_PI
  #define M_PI 3.14159265358979323846  // matches value in math.h
#endif

//==========================================
//======== Console Variable Flags ==========
//==========================================

#ifndef CVAR
  #define CVAR
  #define CVAR_ARCHIVE    1 // set to be saved to vars.rc
  #define CVAR_USERINFO   2 // added to userinfo when changed
  #define CVAR_SERVERINFO 4 // added to serverinfo when changed
  #define CVAR_NOSET      8 // don't allow change from console at all,
  #define CVAR_LATCH     16 // save changes until server restart
#endif

// Some #defines for server variables.
// You can make up your own for other ones that
// I've left undefined and then do a global sub..
#define CVAR_FRAGLIMIT     fraglimit->value
#define CVAR_DEATHMATCH    deathmatch->value
#define CVAR_COOP          coop->value
#define CVAR_CHEATS        sv_cheats->value
#define CVAR_DEDICATED     dedicated->value
#define CVAR_SKILL         skill->value
#define CVAR_TIMELIMIT     timelimit->value
#define CVAR_MAXPLAYERS    maxclients->value
#define CVAR_MAXENTITIES   maxentities->value

//==========================================
//====== SOME INDEXING FUNCTIONS ===========
//==========================================

#define FOFS(x)  (int)&(((edict_t *)0)->x)
#define STOFS(x) (int)&(((spawn_temp_t *)0)->x)
#define LLOFS(x) (int)&(((level_locals_t *)0)->x)
#define CLOFS(x) (int)&(((gclient_t *)0)->x)

//==========================================
//============ MISC VALUES =================
//==========================================

#define DAMAGE_TIME  0.5
#define FALL_TIME    0.3
#define FRAMETIME    0.1

//==========================================
//====== SYSTEM MEMORY TAG FLAGS ===========
//==========================================

#define TAG_GAME  765    // clear when unloading the dll
#define TAG_LEVEL 766    // clear when loading a new level

//==========================================
//========= MONSTER AI FLAGS ===============
//==========================================

#define MELEE_DISTANCE 80

// Range for Monsters
#define RANGE_MELEE  0
#define RANGE_NEAR   1
#define RANGE_MID    2
#define RANGE_FAR    3

// AI flags for Monsters
#define AI_STAND_GROUND      0x00000001
#define AI_TEMP_STAND_GROUND 0x00000002
#define AI_SOUND_TARGET      0x00000004
#define AI_LOST_SIGHT        0x00000008
#define AI_PURSUIT_LAST_SEEN 0x00000010
#define AI_PURSUE_NEXT       0x00000020
#define AI_PURSUE_TEMP       0x00000040
#define AI_HOLD_FRAME        0x00000080
#define AI_GOOD_GUY          0x00000100
#define AI_BRUTAL            0x00000200
#define AI_NOSTEP            0x00000400
#define AI_DUCKED            0x00000800
#define AI_COMBAT_POINT      0x00001000
#define AI_MEDIC             0x00002000
#define AI_RESURRECTING      0x00004000

// Monster attack states
#define AS_STRAIGHT  1
#define AS_SLIDING   2
#define AS_MELEE     3
#define AS_MISSILE   4

//==========================================
//========= SPLASH EFFECT FLAGS ============
//==========================================

#define SPLASH_UNKNOWN      0
#define SPLASH_SPARKS       1 // Splatter spark particles
#define SPLASH_BLUE_WATER   2 // Splatter blue particles
#define SPLASH_BROWN_WATER  3 // Splatter brown particles
#define SPLASH_SLIME        4 // Splatter green particles
#define SPLASH_LAVA         5 // Splatter red particles
#define SPLASH_BLOOD        6 // Splatter red gib particles

//==========================================
//======= SOUND CHANNEL FLAGS ==============
//==========================================

#define CHAN_AUTO        0  // selects a channel automatically
#define CHAN_WEAPON      1  // Channel weapon sounds
#define CHAN_VOICE       2  // Channel entity sounds
#define CHAN_ITEM        3  // Channel item sounds
#define CHAN_BODY        4  // Channel jump and fall sounds
#define CHAN_HOOK        5  // Channel Grappling Hook sounds
#define CHAN_NO_PHS_ADD  8  // Send to all clients. (same as ATTN 0)
#define CHAN_RELIABLE   16  // Send by reliable message, not datagram

//==========================================
//====== Sound Attenuation Flags ===========
//==========================================

#define ATTN_NONE    0  // No Attenuation - Sound heard everywhere
#define ATTN_NORM    1  // Normal Sound dissipation level
#define ATTN_IDLE    2  // Keep Attenuation at present level
#define ATTN_STATIC  3  // Attenuate sound rapidly with distance

//==========================================
//=========== STATUS BAR FLAGS =============
//==========================================

// Things displayed on Player's Status Bar.
// player_state->stats[] indexes
#define STAT_HEALTH_ICON    0 // health icon image
#define STAT_HEALTH         1 // health value
#define STAT_AMMO_ICON      2 // ammo icon image
#define STAT_AMMO           3 // ammo value
#define STAT_ARMOR_ICON     4 // armour icon
#define STAT_ARMOR          5 // armour value
#define STAT_SELECTED_ICON  6 // icon image of the selected weapon
#define STAT_PICKUP_ICON    7 // icon image of a recently gotten thing
#define STAT_PICKUP_STRING  8 // configstring index for recently gotten item
#define STAT_TIMER_ICON     9 // icon image of timed object
#define STAT_TIMER         10 // timer value for a timed object (in seconds)
#define STAT_HELPICON      11 // help icon: 0 off, 1 on
#define STAT_SELECTED_ITEM 12 // item number of the selected weapon
#define STAT_LAYOUTS       13 // layout activator: 0=off, 1=help/summary screen, 2=inventory
#define STAT_FRAGS         14 // client score value
#define STAT_FLASHES       15 // flash the backgrounds behind the status numbers
#define STAT_CHASE         16
#define STAT_SPECTATOR     17
#define STAT_RANGEFINDER   18 // RangeFinder

//==========================================
//=== CVAR_DEATHMATCH SETTING FLAGS ========
//==========================================

// dmflags
#define DF_NO_HEALTH         0x00000001  //     1
#define DF_NO_ITEMS          0x00000002  //     2
#define DF_WEAPONS_STAY      0x00000004  //     4
#define DF_NO_FALLING        0x00000008  //     8
#define DF_INSTANT_ITEMS     0x00000010  //    16
#define DF_SAME_LEVEL        0x00000020  //    32
#define DF_SKINTEAMS         0x00000040  //    64
#define DF_MODELTEAMS        0x00000080  //   128
#define DF_NO_FRIENDLY_FIRE  0x00000100  //   256
#define DF_SPAWN_FARTHEST    0x00000200  //   512
#define DF_FORCE_RESPAWN     0x00000400  //  1024
#define DF_NO_ARMOR          0x00000800  //  2048
#define DF_ALLOW_EXIT        0x00001000  //  4096
#define DF_INFINITE_AMMO     0x00002000  //  8192
#define DF_QUAD_DROP         0x00004000  // 16384
#define DF_FIXED_FOV         0x00008000  // 32768
#define DF_QUADFIRE_DROP     0x00010000  // 65536
#define DF_NO_MINES          0x00020000
#define DF_NO_STACK_DOUBLE   0x00040000
#define DF_NO_NUKES          0x00080000
#define DF_NO_SPHERES        0x00100000

//==========================================
//======== COMMUNICATION FLAGS =============
//==========================================

#define SVF_NOCLIENT    0x00000001  // don't send entity to clients, even if it has effects
#define SVF_DEADMONSTER 0x00000002  // treat as CONTENTS_DEADMONSTER for collision
#define SVF_MONSTER     0x00000004  // treat as CONTENTS_MONSTER for collision

// Server network protocol unsigned char bytes
#define SVC_BAD                    0
#define svc_muzzleflash            1 // Should be all Caps but...
#define svc_muzzleflash2           2 // Id didn't use them that way.
#define svc_temp_entity            3 // Probably should do a global
#define svc_layout                 4 // search and replace to get them
#define svc_inventory              5 // all Cap letters.
#define SVC_NOP                    6
#define SVC_DISCONNECT             7
#define SVC_RECONNECT              8
#define SVC_SOUND                  9
#define SVC_PRINT                 10
#define svc_stufftext             11
#define SVC_DATA                  12
#define SVC_CONFIG_STRING         13
#define SVC_SPAWN_BASELINE        14
#define SVC_CENTER_PRINT          15
#define SVC_DOWNLOAD              16
#define SVC_PLAYER_INFO           17
#define SVC_PACKET_ENTITIES       18
#define SVC_DELTA_PACKET_ENTITIES 19
#define SVC_FRAME                 20

//====================================================
// Config strings are a general means of communication
// from the server to all connected clients. Each config
// string can be at most MAX_QPATH.
//====================================================

#define CS_NAME        0 // is the name of the level.
#define CS_CDTRACK     1 // is the audio CD track for this level.
#define CS_SKY         2 // is the sky texture.
#define CS_SKYAXIS     3 // is the sky axis in the %f %f %f format.
#define CS_SKYROTATE   4 // is the rotation speed in the format %f.
#define CS_STATUSBAR   5 // is the start of the list of display program
                         // strings for the status bar.
// unused
#define CS_AIRACCEL    29 // air acceleration control
#define CS_MAXCLIENTS  30 // Max Config Strings per Client??
#define CS_MAPCHECKSUM 31 // Config Strings Checksum??
#define CS_MODELS      32 // Max client model in precache list.

#define CS_SOUNDS (CS_MODELS+MAX_MODELS)     // (288) start of sound precache list.
#define CS_IMAGES (CS_SOUNDS+MAX_SOUNDS)     // (544) start of image precache list.
#define CS_LIGHTS (CS_IMAGES+MAX_IMAGES)     // (800) start of light styles list.
#define CS_ITEMS  (CS_LIGHTS+MAX_LIGHTSTYLES)// (1056) start of items list.
#define CS_PLAYERSKINS (CS_ITEMS+MAX_ITEMS)  // (1312) start of player skin list.
#define CS_GENERAL (CS_PLAYERSKINS+MAX_CLIENTS)

#define MAX_CONFIGSTRINGS (CS_GENERAL+MAX_GENERAL)

//==========================================
//====== TYPES OF WORLD CONTENTS ===========
//==========================================

#define LAST_VISIBLE_CONTENTS 64

#define CONTENTS_SOLID        0x00000001  // Brush for Solid Surfaces
#define CONTENTS_WINDOW       0x00000002  // Brush for Windows
#define CONTENTS_AUX          0x00000004  // not implemented?
#define CONTENTS_LAVA         0x00000008  // Brush for Lava
#define CONTENTS_SLIME        0x00000010  // Brush for Green Acid Slime
#define CONTENTS_WATER        0x00000020  // Brush for Water
#define CONTENTS_MIST         0x00000040  // not implemented
#define CONTENTS_AREAPORTAL   0x00008000
#define CONTENTS_PLAYERCLIP   0x00010000
#define CONTENTS_MONSTERCLIP  0x00020000
#define CONTENTS_CURRENT_0    0x00040000
#define CONTENTS_CURRENT_90   0x00080000
#define CONTENTS_CURRENT_180  0x00100000
#define CONTENTS_CURRENT_270  0x00200000
#define CONTENTS_CURRENT_UP   0x00400000
#define CONTENTS_CURRENT_DOWN 0x00800000
#define CONTENTS_ORIGIN       0x01000000
#define CONTENTS_MONSTER      0x02000000
#define CONTENTS_DEADMONSTER  0x04000000
#define CONTENTS_DETAIL       0x08000000
#define CONTENTS_TRANSLUCENT  0x10000000
#define CONTENTS_LADDER       0x20000000

//==========================================
// World CONTENT_* bitmask combinations.
//==========================================

#define MASK_ALL          (-1)
#define MASK_LIQUID       (CONTENTS_SLIME|CONTENTS_LAVA)
#define MASK_SOLID        (CONTENTS_SOLID|CONTENTS_WINDOW)
#define MASK_PLAYERSOLID  (CONTENTS_SOLID|CONTENTS_PLAYERCLIP|CONTENTS_WINDOW|CONTENTS_MONSTER)
#define MASK_DEADSOLID    (CONTENTS_SOLID|CONTENTS_PLAYERCLIP|CONTENTS_WINDOW)
#define MASK_MONSTERSOLID (CONTENTS_SOLID|CONTENTS_MONSTERCLIP|CONTENTS_WINDOW|CONTENTS_MONSTER)
#define MASK_LIQUID_ALL   (CONTENTS_WATER|CONTENTS_LAVA|CONTENTS_SLIME)
#define MASK_OPAQUE       (CONTENTS_SOLID|CONTENTS_SLIME|CONTENTS_LAVA)
#define MASK_SHOT         (CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_WINDOW|CONTENTS_DEADMONSTER)
#define MASK_CURRENT      (CONTENTS_CURRENT_0|CONTENTS_CURRENT_90|CONTENTS_CURRENT_180|CONTENTS_CURRENT_270|CONTENTS_CURRENT_UP|CONTENTS_CURRENT_DOWN)
#define MASK_WATER        (CONTENTS_WATER|CONTENTS_LAVA|CONTENTS_SLIME)

//==========================================
//========= WORLD AREA FLAGS ===============
//==========================================

#define AREA_SOLID     1
#define AREA_TRIGGERS  2

//==========================================
//========= WORLD SURFACE FLAGS ============
//==========================================

#define SURF_LIGHT   0x01  // value will hold the light strength
#define SURF_SLICK   0x02  // effects game physics
#define SURF_SKY     0x04  // don't draw, but add to skybox
#define SURF_WARP    0x08  // turbulent water warp
#define SURF_TRANS33 0x10
#define SURF_TRANS66 0x20
#define SURF_FLOWING 0x40 // scroll towards angle
#define SURF_NODRAW  0x80 // don't bother referencing the texture

//==========================================
//====== PLAYER MOVEMENT FLAGS =============
//==========================================

// pmove->pm_flags
#define PMF_DUCKED          0x01 // player movement is crouch
#define PMF_JUMP_HELD       0x02 // player movement is jump
#define PMF_ON_GROUND       0x04 // player movement is walk/run
#define PMF_TIME_WATERJUMP  0x08 // pm_time is waterjump
#define PMF_TIME_LAND       0x10 // pm_time is time before rejump
#define PMF_TIME_TELEPORT   0x20 // pm_time is non-moving time
#define PMF_NO_PREDICTION   0x40 // temporarily disables prediction (used for grappling hook)

//==========================================
//========== BUTTON BIT MASKS ==============
//==========================================

#define BUTTON_NONE    0 // No Button
#define BUTTON_ATTACK  1 // Button Fire (Primary)
#define BUTTON_USE     2 // Button #2 (Secondary)
#define BUTTON_ANY   128 // (128) any key whatsoever

//==========================================
//====== ENTITY STATE EFFECTS FLAGS ========
//==========================================
//
// entity_state_t->effects
// Effects are things handled on the client side (lights, particles,
// frame animations) that happen constantly on the given entity.
// An entity that has effects will be sent to the client
// even if it has a zero index model.
//
//==========================================
#define EF_NONE             0x00000000 // No effects
#define EF_ROTATE           0x00000001 // rotate (bonus items)
#define EF_GIB              0x00000002 // leave a blood trail
#define EF_BLASTER          0x00000008 // redlight + yellow trail
#define EF_ROCKET           0x00000010 // redlight + yellow trail
#define EF_GRENADE          0x00000020 // Leaves a 'smoke trail' effect
#define EF_HYPERBLASTER     0x00000040 // Hyperblaster blasts
#define EF_BFG              0x00000080 // BFG fireball
#define EF_COLOR_SHELL      0x00000100 // Color Shell
#define EF_POWERSCREEN      0x00000200 // Green Power Screen covering
#define EF_ANIM01           0x00000400 // automatically cycle between frames 0 and 1 at 2 hz
#define EF_ANIM23           0x00000800 // automatically cycle between frames 2 and 3 at 2 hz
#define EF_ANIM_ALL         0x00001000 // automatically cycle through all frames at 2hz
#define EF_ANIM_ALLFAST     0x00002000 // automatically cycle through all frames at 10hz
#define EF_FLIES            0x00004000 // little 'flies' effect
#define EF_QUAD             0x00008000 // blue 'quad' shell effect
#define EF_PENT             0x00010000 // red shell effect
#define EF_TELEPORTER       0x00020000 // particle fountain
#define EF_FLAG1            0x00040000 // red with red sparkles
#define EF_FLAG2            0x00080000 // blue with blue sparkles
#define EF_IONRIPPER        0x00100000 // not implemented..
#define EF_GREENGIB         0x00200000 // not implemented..
#define EF_PLASMA           0x01000000 // not implemented..
#define EF_TRAP             0x02000000 // not implemented..
#define EF_TRACKER          0x04000000 // not implemented..
#define EF_DOUBLE           0x08000000 // not implemented..
#define EF_SPHERETRANS      0x10000000 // not implemented..
#define EF_TAGTRAIL         0x20000000 // not implemented..
#define EF_HALF_DAMAGE      0x40000000 // not implemented..
#define EF_TRACKERTRAIL     0x80000000 // not implemented..
#define EF_BLUEHYPERBLASTER 0x00400000 // not implemented..
#define EF_SPINNINGLIGHTS   0x00800000 // not implemented..

//==========================================
//====== ENTITY STATE RENDERFX FLAGS =======
//==========================================

// entity_state_t->renderfx flags
#define RF_NONE           0x00000000 // No Effects
#define RF_MINLIGHT       0x00000001 // always have some light (viewmodel)
#define RF_VIEWERMODEL    0x00000002 // don't draw through eyes, only mirrors
#define RF_WEAPONMODEL    0x00000004 // only draw through eyes
#define RF_FULLBRIGHT     0x00000008 // always draw full intensity
#define RF_DEPTHHACK      0x00000010 // for view weapon Z crunching
#define RF_TRANSLUCENT    0x00000020
#define RF_FRAMELERP      0x00000040
#define RF_BEAM           0x00000080
#define RF_CUSTOMSKIN     0x00000100 // skin is an index in image_precache
#define RF_GLOW           0x00000200 // pulse lighting for bonus items
#define RF_SHELL_RED      0x00000400
#define RF_SHELL_GREEN    0x00000800
#define RF_SHELL_BLUE     0x00001000
#define RF_SHELL_WHITE    0x00002000
#define RF_SHELL_YELLOW   0x00004000
#define RF_IR_VISIBLE     0x00008000
#define RF_SHELL_DOUBLE   0x00010000
#define RF_SHELL_HALF_DAM 0x00020000
#define RF_USE_DISGUISE   0x00040000

//==========================================
//===== player_state_t->refdef flags =======
//==========================================

#define RDF_UNDERWATER   0x01 // warp the screen as apropriate
#define RDF_NOWORLDMODEL 0x02 // used for player configuration screen
#define RDF_IRGOGGLES    0x04
#define RDF_UVGOGGLES    0x08

//==========================================
//====== PRINTING OPTION FLAGS =============
//==========================================

#define PRINT_LOW       0 // pickup messages
#define PRINT_MEDIUM    1 // death messages
#define PRINT_HIGH      2 // critical messages
#define PRINT_CHAT      3 // chat messages

#define PRINT_ALL       0
#define PRINT_DEVELOPER 1 // only print when "set developer 1"
#define PRINT_ALERT     2

//==========================================
//====== SPAWNING OPTIONS FLAGS ============
//==========================================

// Presets!  Do Not Change!!
#define SPAWNFLAG_NOT_EASY        0x00000100
#define SPAWNFLAG_NOT_MEDIUM      0x00000200
#define SPAWNFLAG_NOT_HARD        0x00000400
#define SPAWNFLAG_NOT_DEATHMATCH  0x00000800
#define SPAWNFLAG_NOT_COOP        0x00001000

//==========================================
//====== ENTITY STATE FLAGS ================
//==========================================

#define FL_NONE           0x00000000  // no flags set = OFF
#define FL_FLY            0x00000001
#define FL_SWIM           0x00000002  // implied immunity to drowning
#define FL_IMMUNE_LASER   0x00000004
#define FL_INWATER        0x00000008
#define FL_GODMODE        0x00000010
#define FL_NOTARGET       0x00000020
#define FL_IMMUNE_SLIME   0x00000040
#define FL_IMMUNE_LAVA    0x00000080
#define FL_PARTIALGROUND  0x00000100  // not all corners are valid
#define FL_WATERJUMP      0x00000200  // player jumping out of water
#define FL_TEAMSLAVE      0x00000400  // not the first on the team
#define FL_NO_KNOCKBACK   0x00000800
#define FL_POWER_ARMOR    0x00001000  // power armor (if any) is active
#define FL_RESPAWN        0x80000000  // used for item respawning

#define FFL_SPAWNTEMP  1  // DON'T CHANGE
#define FFL_NOSPAWN    2  // DON'T CHANGE

//==========================================
//====== STATES OF DEADNESS FLAGS ==========
//==========================================

#define DEAD_NO            0  // Entity Health > 0
#define DEAD_DEAD          1  // Entity Health <= 0

//==========================================
//====== TYPES OF GIB MATERIAL =============
//==========================================

#define GIB_ORGANIC   0
#define GIB_METALLIC  1

//==========================================
//====== TYPES OF ENTITY ARMOR =============
//==========================================

// armor types
#define ARMOR_NONE    0
#define ARMOR_JACKET  1
#define ARMOR_COMBAT  2
#define ARMOR_BODY    3
#define ARMOR_SHARD   4

// power armor types
#define POWER_ARMOR_NONE    0
#define POWER_ARMOR_SCREEN  1
#define POWER_ARMOR_SHIELD  2

//==========================================
//====== TYPES OF PLAYER HANDEDNESS ========
//==========================================

#define RIGHT_HANDED   0
#define LEFT_HANDED    1
#define CENTER_HANDED  2

//==========================================
//====== TYPES OF SERVER FLAGS =============
//==========================================

// ga.serverflags values
#define SFL_CROSS_TRIGGER_1     0x00000001
#define SFL_CROSS_TRIGGER_2     0x00000002
#define SFL_CROSS_TRIGGER_3     0x00000004
#define SFL_CROSS_TRIGGER_4     0x00000008
#define SFL_CROSS_TRIGGER_5     0x00000010
#define SFL_CROSS_TRIGGER_6     0x00000020
#define SFL_CROSS_TRIGGER_7     0x00000040
#define SFL_CROSS_TRIGGER_8     0x00000080
#define SFL_CROSS_TRIGGER_MASK  0x000000ff

//==========================================
//========== PLAYER NOISE FLAGS ============
//==========================================

#define PNOISE_SELF    0
#define PNOISE_WEAPON  1
#define PNOISE_IMPACT  2

//==========================================
//========= INVENTORY ITEM FLAGS ===========
//==========================================

// gitem_t->flags
#define IT_WEAPON       0x01
#define IT_AMMO         0x02
#define IT_ARMOR        0x04
#define IT_STAY_COOP    0x08
#define IT_KEY          0x10
#define IT_POWERUP      0x20
#define IT_HEALTH       0x40 // New Item flag
#define IT_PACK         0x80 // New Item flag

// gitem_t->weapmodel
#define WEAP_BLASTER         1
#define WEAP_SHOTGUN         2
#define WEAP_SUPERSHOTGUN    3
#define WEAP_MACHINEGUN      4
#define WEAP_CHAINGUN        5
#define WEAP_GRENADES        6
#define WEAP_GRENADELAUNCHER 7
#define WEAP_ROCKETLAUNCHER  8
#define WEAP_HYPERBLASTER    9
#define WEAP_RAILGUN        10
#define WEAP_BFG            11

//==========================================
//======== CLIENT OBITUARY FLAGS ===========
//==========================================

#define MOD_UNKNOWN           0
#define MOD_BLASTER           1
#define MOD_SHOTGUN           2
#define MOD_SSHOTGUN          3
#define MOD_MACHINEGUN        4
#define MOD_CHAINGUN          5
#define MOD_GRENADE           6
#define MOD_G_SPLASH          7
#define MOD_ROCKET            8
#define MOD_R_SPLASH          9
#define MOD_HYPERBLASTER     10
#define MOD_RAILGUN          11
#define MOD_BFG_LASER        12
#define MOD_BFG_BLAST        13
#define MOD_BFG_EFFECT       14
#define MOD_HANDGRENADE      15
#define MOD_HG_SPLASH        16
#define MOD_WATER            17
#define MOD_SLIME            18
#define MOD_LAVA             19
#define MOD_CRUSH            20
#define MOD_TELEFRAG         21
#define MOD_FALLING          22
#define MOD_SUICIDE          23
#define MOD_HELD_GRENADE     24
#define MOD_EXPLOSIVE        25
#define MOD_BARREL           26
#define MOD_BOMB             27
#define MOD_EXIT             28
#define MOD_SPLASH           29
#define MOD_TARGET_LASER     30
#define MOD_TRIGGER_HURT     31
#define MOD_HIT              32
#define MOD_TARGET_BLASTER   33
#define MOD_GRAPPLE          34
#define MOD_ROCKET_BOMBS     35 // Rocket Airstrike
#define MOD_CLUSTER_BOMBS    36 // Cluster Airstrike
#define MOD_RAILSTRIKE       37 // BFG Nuke Airstrike
#define MOD_LASERSTRIKE      38 // Laser Airstrike
#define MOD_BFG_NUKE         39 // Railgun Airstrike
#define MOD_HGRENADE         40 // Homing Handgrenade
#define MOD_RAILBOMB         41 // Railbomb Grenade
#define MOD_ZYLON_GAS        42 // Zylon Gas Grenade
#define MOD_DEPTHCHARGE      43 // Depth Charge
#define MOD_BATON            44 // Baton Weapon
#define MOD_DECOY            45 // Marine Decoy Blast
#define MOD_BOOBYTRAP        46 // BoobyTrapped Armor
#define MOD_LASERSWEEP       47 // LaserSweep
#define MOD_CHAMBER          48 // Torture Chamber
#define MOD_LASERDRONE       49 // Arial LaserDrone
#define MOD_DEATHPAK         50 // MegaHealth DeathPak
#define MOD_HANGED           51 // Hangman Weapon

#define MOD_FRIENDLY_FIRE    0x80000000 // BitMask

//==========================================
//====== VARIOUS ITEM STATES ===============
//==========================================

#define ITEM_TRIGGER_SPAWN   0x00000001
#define ITEM_NO_TOUCH        0x00000002
// reserved                  0x00000004
// reserved                  0x00000008
#define DROPPED_ITEM         0x00000010
#define DROPPED_PLAYER_ITEM  0x00000020
#define ITEM_TARGETS_USED    0x00000040

//=========================================
//====== WEAPON DAMAGE FLAGS ===============
//==========================================

#define DAMAGE_RADIUS        0x00000001 // damage was indirect
#define DAMAGE_NO_ARMOR      0x00000002 // armor does not protect from damage
#define DAMAGE_ENERGY        0x00000004 // damage is from energy weapon
#define DAMAGE_NO_KNOCKBACK  0x00000008 // do not affect velocity, just view angles
#define DAMAGE_BULLET        0x00000010 // damage is from bullet (used for ricochets)
#define DAMAGE_NO_PROTECTION 0x00000020 // armor, shields, invulnerability, and godmode have no effect

// Default Bullet Counts
#define DEFAULT_DEATHMATCH_SHOTGUN_COUNT   12
#define DEFAULT_SHOTGUN_COUNT              12
#define DEFAULT_SSHOTGUN_COUNT             20

// Default Bullet Pattern Spreads
#define DEFAULT_BULLET_HSPREAD            300
#define DEFAULT_BULLET_VSPREAD            500
#define DEFAULT_SHOTGUN_VSPREAD           500
#define DEFAULT_SHOTGUN_HSPREAD          1000

//==========================================
//====== ANIMATION PRIORITY FLAGS ==========
//==========================================

#define ANIM_BASIC     0
#define ANIM_WAVE      1
#define ANIM_JUMP      2
#define ANIM_PAIN      3
#define ANIM_ATTACK    4
#define ANIM_DEATH     5
#define ANIM_REVERSE   6

//==========================================
//====== WEAPON MUZZLE FLASH FLAGS =========
//==========================================

#define MZ_BLASTER           0
#define MZ_MACHINEGUN        1
#define MZ_SHOTGUN           2
#define MZ_CHAINGUN1         3
#define MZ_CHAINGUN2         4
#define MZ_CHAINGUN3         5
#define MZ_RAILGUN           6
#define MZ_ROCKET            7
#define MZ_GRENADE           8
#define MZ_LOGIN             9
#define MZ_LOGOUT           10
#define MZ_RESPAWN          11
#define MZ_BFG              12
#define MZ_SSHOTGUN         13
#define MZ_HYPERBLASTER     14
#define MZ_ITEMRESPAWN      15
#define MZ_IONRIPPER        16
#define MZ_BLUEHYPERBLASTER 17
#define MZ_PHALANX          18
#define MZ_SILENCED        128

#define MZ_ETF_RIFLE  30
#define MZ_UNUSED     31
#define MZ_SHOTGUN2   32
#define MZ_HEATBEAM   33
#define MZ_BLASTER2   34
#define MZ_TRACKER    35
#define MZ_NUKE1      36
#define MZ_NUKE2      37
#define MZ_NUKE4      38
#define MZ_NUKE8      39

//
// monster muzzle flashes
//
#define MZ2_TANK_BLASTER_1          1
#define MZ2_TANK_BLASTER_2          2
#define MZ2_TANK_BLASTER_3          3
#define MZ2_TANK_MACHINEGUN_1       4
#define MZ2_TANK_MACHINEGUN_2       5
#define MZ2_TANK_MACHINEGUN_3       6
#define MZ2_TANK_MACHINEGUN_4       7
#define MZ2_TANK_MACHINEGUN_5       8
#define MZ2_TANK_MACHINEGUN_6       9
#define MZ2_TANK_MACHINEGUN_7      10
#define MZ2_TANK_MACHINEGUN_8      11
#define MZ2_TANK_MACHINEGUN_9      12
#define MZ2_TANK_MACHINEGUN_10     13
#define MZ2_TANK_MACHINEGUN_11     14
#define MZ2_TANK_MACHINEGUN_12     15
#define MZ2_TANK_MACHINEGUN_13     16
#define MZ2_TANK_MACHINEGUN_14     17
#define MZ2_TANK_MACHINEGUN_15     18
#define MZ2_TANK_MACHINEGUN_16     19
#define MZ2_TANK_MACHINEGUN_17     20
#define MZ2_TANK_MACHINEGUN_18     21
#define MZ2_TANK_MACHINEGUN_19     22
#define MZ2_TANK_ROCKET_1          23
#define MZ2_TANK_ROCKET_2          24
#define MZ2_TANK_ROCKET_3          25
#define MZ2_INFANTRY_MACHINEGUN_1  26
#define MZ2_INFANTRY_MACHINEGUN_2  27
#define MZ2_INFANTRY_MACHINEGUN_3  28
#define MZ2_INFANTRY_MACHINEGUN_4  29
#define MZ2_INFANTRY_MACHINEGUN_5  30
#define MZ2_INFANTRY_MACHINEGUN_6  31
#define MZ2_INFANTRY_MACHINEGUN_7  32
#define MZ2_INFANTRY_MACHINEGUN_8  33
#define MZ2_INFANTRY_MACHINEGUN_9  34
#define MZ2_INFANTRY_MACHINEGUN_10 35
#define MZ2_INFANTRY_MACHINEGUN_11 36
#define MZ2_INFANTRY_MACHINEGUN_12 37
#define MZ2_INFANTRY_MACHINEGUN_13 38
#define MZ2_SOLDIER_BLASTER_1      39
#define MZ2_SOLDIER_BLASTER_2      40
#define MZ2_SOLDIER_SHOTGUN_1      41
#define MZ2_SOLDIER_SHOTGUN_2      42
#define MZ2_SOLDIER_MACHINEGUN_1   43
#define MZ2_SOLDIER_MACHINEGUN_2   44
#define MZ2_GUNNER_MACHINEGUN_1    45
#define MZ2_GUNNER_MACHINEGUN_2    46
#define MZ2_GUNNER_MACHINEGUN_3    47
#define MZ2_GUNNER_MACHINEGUN_4    48
#define MZ2_GUNNER_MACHINEGUN_5    49
#define MZ2_GUNNER_MACHINEGUN_6    50
#define MZ2_GUNNER_MACHINEGUN_7    51
#define MZ2_GUNNER_MACHINEGUN_8    52
#define MZ2_GUNNER_GRENADE_1       53
#define MZ2_GUNNER_GRENADE_2       54
#define MZ2_GUNNER_GRENADE_3       55
#define MZ2_GUNNER_GRENADE_4       56
#define MZ2_CHICK_ROCKET_1         57
#define MZ2_FLYER_BLASTER_1        58
#define MZ2_FLYER_BLASTER_2        59
#define MZ2_MEDIC_BLASTER_1        60
#define MZ2_GLADIATOR_RAILGUN_1    61
#define MZ2_HOVER_BLASTER_1        62
#define MZ2_ACTOR_MACHINEGUN_1     63
#define MZ2_SUPERTANK_MACHINEGUN_1 64
#define MZ2_SUPERTANK_MACHINEGUN_2 65
#define MZ2_SUPERTANK_MACHINEGUN_3 66
#define MZ2_SUPERTANK_MACHINEGUN_4 67
#define MZ2_SUPERTANK_MACHINEGUN_5 68
#define MZ2_SUPERTANK_MACHINEGUN_6 69
#define MZ2_SUPERTANK_ROCKET_1     70
#define MZ2_SUPERTANK_ROCKET_2     71
#define MZ2_SUPERTANK_ROCKET_3     72
#define MZ2_BOSS2_MACHINEGUN_L1    73
#define MZ2_BOSS2_MACHINEGUN_L2    74
#define MZ2_BOSS2_MACHINEGUN_L3    75
#define MZ2_BOSS2_MACHINEGUN_L4    76
#define MZ2_BOSS2_MACHINEGUN_L5    77
#define MZ2_BOSS2_ROCKET_1         78
#define MZ2_BOSS2_ROCKET_2         79
#define MZ2_BOSS2_ROCKET_3         80
#define MZ2_BOSS2_ROCKET_4         81
#define MZ2_FLOAT_BLASTER_1        82
#define MZ2_SOLDIER_BLASTER_3      83
#define MZ2_SOLDIER_SHOTGUN_3      84
#define MZ2_SOLDIER_MACHINEGUN_3   85
#define MZ2_SOLDIER_BLASTER_4      86
#define MZ2_SOLDIER_SHOTGUN_4      87
#define MZ2_SOLDIER_MACHINEGUN_4   88
#define MZ2_SOLDIER_BLASTER_5      89
#define MZ2_SOLDIER_SHOTGUN_5      90
#define MZ2_SOLDIER_MACHINEGUN_5   91
#define MZ2_SOLDIER_BLASTER_6      92
#define MZ2_SOLDIER_SHOTGUN_6      93
#define MZ2_SOLDIER_MACHINEGUN_6   94
#define MZ2_SOLDIER_BLASTER_7      95
#define MZ2_SOLDIER_SHOTGUN_7      96
#define MZ2_SOLDIER_MACHINEGUN_7   97
#define MZ2_SOLDIER_BLASTER_8      98
#define MZ2_SOLDIER_SHOTGUN_8      99
#define MZ2_SOLDIER_MACHINEGUN_8  100
#define MZ2_MAKRON_BFG            101
#define MZ2_MAKRON_BLASTER_1      102
#define MZ2_MAKRON_BLASTER_2      103
#define MZ2_MAKRON_BLASTER_3      104
#define MZ2_MAKRON_BLASTER_4      105
#define MZ2_MAKRON_BLASTER_5      106
#define MZ2_MAKRON_BLASTER_6      107
#define MZ2_MAKRON_BLASTER_7      108
#define MZ2_MAKRON_BLASTER_8      109
#define MZ2_MAKRON_BLASTER_9      110
#define MZ2_MAKRON_BLASTER_10     111
#define MZ2_MAKRON_BLASTER_11     112
#define MZ2_MAKRON_BLASTER_12     113
#define MZ2_MAKRON_BLASTER_13     114
#define MZ2_MAKRON_BLASTER_14     115
#define MZ2_MAKRON_BLASTER_15     116
#define MZ2_MAKRON_BLASTER_16     117
#define MZ2_MAKRON_BLASTER_17     118
#define MZ2_MAKRON_RAILGUN_1      119
#define MZ2_JORG_MACHINEGUN_L1    120
#define MZ2_JORG_MACHINEGUN_L2    121
#define MZ2_JORG_MACHINEGUN_L3    122
#define MZ2_JORG_MACHINEGUN_L4    123
#define MZ2_JORG_MACHINEGUN_L5    124
#define MZ2_JORG_MACHINEGUN_L6    125
#define MZ2_JORG_MACHINEGUN_R1    126
#define MZ2_JORG_MACHINEGUN_R2    127
#define MZ2_JORG_MACHINEGUN_R3    128
#define MZ2_JORG_MACHINEGUN_R4    129
#define MZ2_JORG_MACHINEGUN_R5    130
#define MZ2_JORG_MACHINEGUN_R6    131
#define MZ2_JORG_BFG_1            132
#define MZ2_BOSS2_MACHINEGUN_R1   133
#define MZ2_BOSS2_MACHINEGUN_R2   134
#define MZ2_BOSS2_MACHINEGUN_R3   135
#define MZ2_BOSS2_MACHINEGUN_R4   136
#define MZ2_BOSS2_MACHINEGUN_R5   137
#define MZ2_CARRIER_MACHINEGUN_L1 138
#define MZ2_CARRIER_MACHINEGUN_R1 139
#define MZ2_CARRIER_GRENADE       140
#define MZ2_TURRET_MACHINEGUN     141
#define MZ2_TURRET_ROCKET         142
#define MZ2_TURRET_BLASTER        143
#define MZ2_STALKER_BLASTER       144
#define MZ2_DAEDALUS_BLASTER      145
#define MZ2_MEDIC_BLASTER_2       146
#define MZ2_CARRIER_RAILGUN       147
#define MZ2_WIDOW_DISRUPTOR       148
#define MZ2_WIDOW_BLASTER         149
#define MZ2_WIDOW_RAIL            150
#define MZ2_WIDOW_PLASMABEAM      151
#define MZ2_CARRIER_MACHINEGUN_L2 152
#define MZ2_CARRIER_MACHINEGUN_R2 153
#define MZ2_WIDOW_RAIL_LEFT       154
#define MZ2_WIDOW_RAIL_RIGHT      155
#define MZ2_WIDOW_BLASTER_SWEEP1  156
#define MZ2_WIDOW_BLASTER_SWEEP2  157
#define MZ2_WIDOW_BLASTER_SWEEP3  158
#define MZ2_WIDOW_BLASTER_SWEEP4  159
#define MZ2_WIDOW_BLASTER_SWEEP5  160
#define MZ2_WIDOW_BLASTER_SWEEP6  161
#define MZ2_WIDOW_BLASTER_SWEEP7  162
#define MZ2_WIDOW_BLASTER_SWEEP8  163
#define MZ2_WIDOW_BLASTER_SWEEP9  164
#define MZ2_WIDOW_BLASTER_100     165
#define MZ2_WIDOW_BLASTER_90      166
#define MZ2_WIDOW_BLASTER_80      167
#define MZ2_WIDOW_BLASTER_70      168
#define MZ2_WIDOW_BLASTER_60      169
#define MZ2_WIDOW_BLASTER_50      170
#define MZ2_WIDOW_BLASTER_40      171
#define MZ2_WIDOW_BLASTER_30      172
#define MZ2_WIDOW_BLASTER_20      173
#define MZ2_WIDOW_BLASTER_10      174
#define MZ2_WIDOW_BLASTER_0       175
#define MZ2_WIDOW_BLASTER_10L     176
#define MZ2_WIDOW_BLASTER_20L     177
#define MZ2_WIDOW_BLASTER_30L     178
#define MZ2_WIDOW_BLASTER_40L     179
#define MZ2_WIDOW_BLASTER_50L     180
#define MZ2_WIDOW_BLASTER_60L     181
#define MZ2_WIDOW_BLASTER_70L     182
#define MZ2_WIDOW_RUN_1           183
#define MZ2_WIDOW_RUN_2           184
#define MZ2_WIDOW_RUN_3           185
#define MZ2_WIDOW_RUN_4           186
#define MZ2_WIDOW_RUN_5           187
#define MZ2_WIDOW_RUN_6           188
#define MZ2_WIDOW_RUN_7           189
#define MZ2_WIDOW_RUN_8           190
#define MZ2_CARRIER_ROCKET_1      191
#define MZ2_CARRIER_ROCKET_2      192
#define MZ2_CARRIER_ROCKET_3      193
#define MZ2_CARRIER_ROCKET_4      194
#define MZ2_WIDOW2_BEAMER_1       195
#define MZ2_WIDOW2_BEAMER_2       196
#define MZ2_WIDOW2_BEAMER_3       197
#define MZ2_WIDOW2_BEAMER_4       198
#define MZ2_WIDOW2_BEAMER_5       199
#define MZ2_WIDOW2_BEAM_SWEEP_1   200
#define MZ2_WIDOW2_BEAM_SWEEP_2   201
#define MZ2_WIDOW2_BEAM_SWEEP_3   202
#define MZ2_WIDOW2_BEAM_SWEEP_4   203
#define MZ2_WIDOW2_BEAM_SWEEP_5   204
#define MZ2_WIDOW2_BEAM_SWEEP_6   205
#define MZ2_WIDOW2_BEAM_SWEEP_7   206
#define MZ2_WIDOW2_BEAM_SWEEP_8   207
#define MZ2_WIDOW2_BEAM_SWEEP_9   208
#define MZ2_WIDOW2_BEAM_SWEEP_10  209
#define MZ2_WIDOW2_BEAM_SWEEP_11  210

//=======================================================
//============ SYSTEM ERROR MESSAGE FLAGES ==============
//=======================================================

#define ERR_FATAL      0 // exit the entire game
#define ERR_DROP       1 // print to console and disconnect
#define ERR_DISCONNECT 2 // print and disconnect (but don't kill server)

//==========================================
//========= TYPES OF MONSTERS ==============
//==========================================

//  TYPE OF MONSTER ----  HEALTH
#define M_SOLDIERLT  0 //   20
#define M_SOLDIER    1 //   30
#define M_SOLDIERSS  2 //   40
#define M_FLIPPER    3 //   50
#define M_FLYER      4 //   50
#define M_INFANTRY   5 //  100
#define M_INSANE     6 //  100 - Crazy Marine
#define M_GUNNER     7 //  175
#define M_CHICK      8 //  175
#define M_PARASITE   9 //  175
#define M_FLOATER   10 //  200
#define M_HOVER     11 //  240 - Icarus
#define M_BERSERK   12 //  240
#define M_MEDIC     13 //  300
#define M_MUTANT    14 //  300
#define M_BRAIN     15 //  300
#define M_GLADIATOR 16 //  400
#define M_TANK      17 //  750
#define M_SUPERTANK 18 // 1500
#define M_BOSS2     19 // 2000
#define M_JORG      20 // 3000
#define M_MAKRON    21 // 3000

//==========================================
//======= GLOBAL MODEL/SOUND DEFINES =======
//==========================================

// Gibs Models.
#define GIB_SM_MEAT_MODEL "models/objects/gibs/sm_meat/tris.md2"
#define GIB_ARM_MODEL     "models/objects/gibs/arm/tris.md2"
#define GIB_LEG_MODEL     "models/objects/gibs/leg/tris.md2"
#define GIB_BONE_MODEL    "models/objects/gibs/bone/tris.md2"
#define GIB_BONE2_MODEL   "models/objects/gibs/bone2/tris.md2"
#define GIB_CHEST_MODEL   "models/objects/gibs/chest/tris.md2"
#define GIB_SKULL_MODEL   "models/objects/gibs/skull/tris.md2"
#define GIB_HEAD_MODEL    "models/objects/gibs/head/tris.md2"
#define GIB_HEAD2_MODEL   "models/objects/gibs/head2/tris.md2"

// Debris Models
#define DEBRIS1_MODEL "models/objects/debris1/tris.md2"
#define DEBRIS2_MODEL "models/objects/debris2/tris.md2"
#define DEBRIS3_MODEL "models/objects/debris3/tris.md2"

// Misc Models
#define BOMB_MODEL        "models/objects/bomb/tris.md2"
#define ROCKET_MODEL      "models/objects/rocket/tris.md2"
#define GRENADE_MODEL     "models/objects/grenade/tris.md2"
#define STROGG_SHIP_MODEL "models/ships/viper/tris.md2"

// Misc Sound Indexes
#define POWER1_SOUND gi.soundindex("misc/power1.wav")
#define PILOT1_SOUND gi.soundindex("world/pilot1.wav")
#define PILOT2_SOUND gi.soundindex("world/pilot2.wav")
#define FLYBY1_SOUND gi.soundindex("world/flyby1.wav")
#define ROCKET_FLY_SOUND gi.soundindex("weapons/rockfly.wav")
#define BFG_LAUNCH_SOUND gi.soundindex("weapons/bfg__l1a.wav")
#define BFG_EXPLODE_SOUND gi.soundindex("weapons/bfg__x1b.wav")

#define HOOK_HIT_SOUND     gi.soundindex("misc/menu1.wav")
#define HOOK_SMACK_SOUND   gi.soundindex("misc/menu3.wav")
#define HOOK_MOTOR1_SOUND  gi.soundindex("misc/am_pkup.wav")
#define HOOK_MOTOR2_SOUND  gi.soundindex("rotate/h_rot1.wav")
#define HOOK_MOTOR3_SOUND  gi.soundindex("plats/pt1_strt.wav")
#define HOOK_RETRACT_SOUND gi.soundindex("items/respawn1.wav")
#define HOOK_LAUNCH_SOUND  gi.soundindex("items/respawn1.wav")

//=======================================================
//====== INCORPORATE ALL OTHER INCLUDES HERE ============
//=======================================================

#include "enum.h"
#include "structs.h"
#include "files.h"

