#include "defines.h"
#include "m_player.h"

//======================================================
void print_cheats_msg(edict_t *ent) {
    gi_cprintf(ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
}

//============================================================
char *ClientTeam(edict_t *ent) {
char *p;
static char value[512];

  value[0]=0;

  if (!G_EntExists(ent)) return value;

  strcpy(value, Info_ValueForKey(ent->client->pers.userinfo, "skin"));
  p=strchr(value, '/');
  if (!p) return value;

  if ((int)(dmflags->value) & DF_MODELTEAMS) {
  *p=0; return value; }

  return ++p;
}
//========================================================
void HelpComputer(edict_t *ent) {
char *sk, string[1024];

  if (CVAR_SKILL == 0)
    sk="easy";
  else if (CVAR_SKILL == 1)
    sk="medium";
  else if (CVAR_SKILL == 2)
    sk="hard";
  else
    sk="hard+";

  // send the layout
  Com_sprintf(string, sizeof(string),
    "xv 32 yv 8 picn help "          // background
    "xv 202 yv 12 string2 \"%s\" "   // skill
    "xv 0 yv 24 cstring2 \"%s\" "    // level name
    "xv 0 yv 54 cstring2 \"%s\" "    // help 1
    "xv 0 yv 110 cstring2 \"%s\" "   // help 2
    "xv 50 yv 164 string2 \" kills     goals    secrets\" "
    "xv 50 yv 172 string2 \"%3i/%3i     %i/%i       %i/%i\" ",
    sk,
    level.level_name,
    ga.helpmessage1,
    ga.helpmessage2,
    level.killed_monsters, level.total_monsters,
    level.found_goals, level.total_goals,
    level.found_secrets, level.total_secrets);

  G_WriteLayout(ent, string);
}

//======================================================
// Check out other player's stats..
//======================================================
void Cmd_CheckStats_f(edict_t *ent) {
int i, j;
edict_t *player;
char stats[500];
vec3_t v={0,0,0};
float len;

  if (!CVAR_DEATHMATCH) return;

  j=sprintf(stats,"     Player      Health Range\n-----------------------------\n");
  for (i=0;i<ga.maxclients;i++) {
    player=g_edicts+1+i;
    if (player==ent) continue; // Don't display stats for yourself..
    if (!G_EntExists(player)) continue;
    VectorSubtract(ent->s.origin, player->s.origin, v);
    len = VectorLength(v);
    j += sprintf(stats+j, "%16s %6d %5.0f\n", player->client->pers.netname, player->health, len);
    if (j > 450) break;
    } // end for

  gi_centerprintf(ent, "%s", stats);
}

//========================================================
void Cmd_Score_f(edict_t *ent) {

  ent->client->showinventory=false;
  ent->client->showhelp=false;

  if (!CVAR_DEATHMATCH && !CVAR_COOP)
    return;

  if (ent->client->showscores) {
    ent->client->showscores=false;
    return; }

  ent->client->showscores=true;
  DeathmatchScoreboard(ent);
}

//========================================================
void Cmd_Help_f(edict_t *ent) {

  if (CVAR_DEATHMATCH) {
    Cmd_Score_f(ent);
    return; }

  ent->client->showinventory=false;
  ent->client->showscores=false;

  if (ent->client->showhelp && (ent->client->pers.game_helpchanged == ga.helpchanged)) {
    ent->client->showhelp=false;
    return; }

  ent->client->showhelp=true;
  ent->client->pers.helpchanged=0;
  HelpComputer(ent);
}

//============================================================
void Cmd_Give_f(edict_t *ent) {
char *name;
gitem_t *it;
int index, i;
qboolean give_all;
edict_t *it_ent;
gitem_armor_t *info;

  if (CVAR_DEATHMATCH && !CVAR_CHEATS) {
    print_cheats_msg(ent);
    return; }

  name=gi.args();

  if (!Q_stricmp(name, "all"))
    give_all=true;
  else
    give_all=false;

  if (give_all || !Q_stricmp(gi.argv(1), "health")) {
    if (gi.argc() == 3)
      ent->health=atoi(gi.argv(2));
    else
      ent->health=ent->max_health;
    if (!give_all)
      return; }

  if (give_all || !Q_stricmp(name, "weapons")) {
    for (i=0; i<ga.num_items; i++) {
      it=itemlist+i;
      if (!it->pickup) continue;
      if (!(it->flags & IT_WEAPON)) continue;
      ent->client->pers.inventory[i]++; }
    if (!give_all) return; }

  if (give_all || !Q_stricmp(name, "ammo")) {
    for (i=0; i<ga.num_items; i++) {
      it=itemlist+i;
      if (!it->pickup) continue;
      if (!(it->flags & IT_AMMO)) continue;
      Add_Ammo(ent, it, 1000); }
    if (!give_all)
      return; }

  if (give_all || !Q_stricmp(name, "armor")) {
    it=item_jacketarmor;
    ent->client->pers.inventory[ITEM_INDEX(it)]=0;
    it=item_combatarmor;
    ent->client->pers.inventory[ITEM_INDEX(it)]=0;
    it=item_bodyarmor;
    info =(gitem_armor_t *)it->info;
    ent->client->pers.inventory[ITEM_INDEX(it)]=info->max_count;
    if (!give_all)
      return; }

  if (give_all || !Q_stricmp(name, "Power Shield")) {
    it=item_powershield;
    it_ent=G_Spawn();
    it_ent->classname=it->classname;
    SpawnItem(it_ent, it);
    Touch_Item(it_ent, ent, NULL, NULL);
    if (it_ent->inuse)
      G_FreeEdict(it_ent);
    if (!give_all)
      return; }

  if (give_all) {
    for (i=0; i<ga.num_items; i++) {
      it=itemlist+i;
      if (!it->pickup) continue;
      if (it->flags & (IT_ARMOR|IT_WEAPON|IT_AMMO)) continue;
      ent->client->pers.inventory[i]=1; }
    return; }

  it=FindItem(name);
  if (!it) {
    name=gi.argv(1);
    it=FindItem(name);
    if (!it) {
      gi_cprintf(ent, PRINT_HIGH, "unknown item\n");
      return; } }

  if (!it->pickup) {
    gi_cprintf(ent, PRINT_HIGH, "non-pickup item\n");
    return; }

  index=ITEM_INDEX(it);

  if (it->flags & IT_AMMO) {
    if (gi.argc() == 3)
      ent->client->pers.inventory[index]=atoi(gi.argv(2));
    else
      ent->client->pers.inventory[index] += it->quantity; }
  else {
    it_ent=G_Spawn();
    it_ent->classname=it->classname;
    SpawnItem(it_ent, it);
    Touch_Item(it_ent, ent, NULL, NULL);
    if (it_ent->inuse)
      G_FreeEdict(it_ent); }
}

//======================================================
// Pay the Piper for the Shark Barrel
//======================================================
void Cmd_SharkBarrel_f(edict_t *ent) {
int index;

  // Not available to dead or respawning players!
  if (!G_ClientInGame(ent)) return;

  index = ITEM_INDEX(item_grenades);
  if (ent->client->pers.inventory[index] < 10){
    gi_centerprintf(ent, "Shark Barrel costs 10 grenades!\n");
    return; }
  else {
    ent->client->pers.inventory[index] -= 10;
    Toss_SharkBarrel(ent); }
}

//============================================================
void Cmd_God_f(edict_t *ent) {
char *msg;

  if (CVAR_DEATHMATCH && !CVAR_CHEATS) {
    print_cheats_msg(ent);
    return; }

  ent->flags ^= FL_GODMODE;
  if (!(ent->flags & FL_GODMODE))
    msg="godmode OFF\n";
  else
    msg="godmode ON\n";

  gi_cprintf(ent, PRINT_HIGH, msg);
}

//============================================================
void Cmd_Notarget_f(edict_t *ent) {
char *msg;

  if (CVAR_DEATHMATCH && !CVAR_CHEATS) {
    print_cheats_msg(ent);
    return; }

  ent->flags ^= FL_NOTARGET;
  if (!(ent->flags & FL_NOTARGET))
    msg="notarget OFF\n";
  else
    msg="notarget ON\n";

  gi_cprintf(ent, PRINT_HIGH, msg);
}

//======================================================
// Initiate Nuclear Self Destruct mechanism.. BOOM!!
//======================================================
void Cmd_SelfDestruct_f(edict_t *ent) {
edict_t *player=NULL;
vec3_t forward,backward,right,left,up;
int i;

  // Not available to dead or respawning players!
  if (!G_ClientInGame(ent)) return;

  if (ent->health > 10) {
    gi_centerprintf(ent, "Cannot Activate Nuclear Device!\n");
    return; }

  // For some reason, must use VectorSet()..
  VectorSet(forward,0,1,0);
  VectorSet(right,1,0,0);
  VectorSet(backward,0,-1,0);
  VectorSet(left,-1,0,0);

  // Fire BFG fireball with dmg=200; speed=400; radius=1000
  // in direction of each N,S,E,W compass points.
  fire_bfg(ent, ent->s.origin, forward,  200, 400, 1000);
  fire_bfg(ent, ent->s.origin, right,    200, 400, 1000);
  fire_bfg(ent, ent->s.origin, backward, 200, 400, 1000);
  fire_bfg(ent, ent->s.origin, left,     200, 400, 1000);

  // Blow backward any players in 1000 units radius.
  for(i=0;i < ga.maxclients;i++) {
    player=g_edicts+i+1;
    if (!G_ClientInGame(player)) continue;
    if (ent==player) continue;
    if (!G_Within_Radius(player->s.origin, ent->s.origin, 1000)) continue;
    AngleVectors(player->s.angles, forward, right, up);
    VectorMA(player->velocity, 200, forward, player->velocity);
    VectorMA(player->velocity, 2000, up, player->velocity);
    } // end for
}

//======================================================
// Self Catapult in the direction you are facing in..
//======================================================
void Cmd_Catapult_f(edict_t *ent) {
int index;
vec3_t forward,up;

  // Not available to dead or respawning players!
  if (!G_ClientInGame(ent)) return;

  // Is ent currently airborne?
  if (!ent->groundentity) return;

  index = ITEM_INDEX(item_cells);
  if (ent->client->pers.inventory[index] < 20){
    gi_centerprintf(ent, "Self Catapult costs 20 cells!\n");
    return; }
  else {
    // Deduct the 20 cells... and then
    ent->client->pers.inventory[index] -= 20;
    // Physically throw the player up and forward!
    AngleVectors(ent->s.angles, forward, NULL, up);
    VectorCopy(forward, ent->movedir);
    VectorClear(ent->velocity);
    VectorMA(ent->velocity, 1000, forward, ent->velocity);
    VectorMA(ent->velocity,  700, up, ent->velocity);
    } // end else
}

//============================================================
void Cmd_Noclip_f(edict_t *ent) {
char *msg;

  if (CVAR_DEATHMATCH && !CVAR_CHEATS) {
    print_cheats_msg(ent);
    return; }

  if (ent->movetype == MOVETYPE_NOCLIP) {
    ent->movetype=MOVETYPE_WALK;
    msg="noclip OFF\n"; }
  else {
    ent->movetype=MOVETYPE_NOCLIP;
    msg="noclip ON\n"; }

  gi_cprintf(ent, PRINT_HIGH, msg);
}

//============================================================
void Cmd_Use_f(edict_t *ent) {
int index;
gitem_t *it;
char *s;

  s=gi.args();
  it=FindItem(s);
  if (!it) {
    gi_cprintf(ent, PRINT_HIGH, "unknown item: %s\n", s);
    return; }

  if (!it->use) {
    gi_cprintf(ent, PRINT_HIGH, "Item is not usable.\n");
    return; }

  index=ITEM_INDEX(it);
  if (!ent->client->pers.inventory[index]) {
    gi_cprintf(ent, PRINT_HIGH, "Out of item: %s\n", s);
    return; }

  it->use(ent, it);
}

//============================================================
void Cmd_Drop_f(edict_t *ent) {
int index;
gitem_t *it;
char *s;

  s=gi.args();
  it=FindItem(s);
  if (!it) {
    gi_cprintf(ent, PRINT_HIGH, "unknown item: %s\n", s);
    return; }
  if (!it->drop) {
    gi_cprintf(ent, PRINT_HIGH, "Item is not dropable.\n");
    return; }
  index=ITEM_INDEX(it);
  if (!ent->client->pers.inventory[index]) {
    gi_cprintf(ent, PRINT_HIGH, "Out of item: %s\n", s);
    return; }

  it->drop(ent, it);
}

//============================================================
void Cmd_Inven_f(edict_t *ent) {

  ent->client->showscores=false;
  ent->client->showhelp=false;

  if (ent->client->showinventory) {
    ent->client->showinventory=false;
    return; }

  ent->client->showinventory=true;

  G_WriteInventory(ent);
}

//============================================================
void Cmd_InvUse_f(edict_t *ent) {
gitem_t *it;

  ValidateSelectedItem(ent);

  if (ent->client->pers.selected_item == -1) {
    gi_cprintf(ent, PRINT_HIGH, "No item to use.\n");
    return; }

  it=&itemlist[ent->client->pers.selected_item];
  if (!it->use) {
    gi_cprintf(ent, PRINT_HIGH, "Item is not usable.\n");
    return; }

  it->use(ent, it);
}

//============================================================
void Cmd_WeapPrev_f(edict_t *ent) {
int i, index;
gitem_t *it;
int selected_weapon;

  if (!ent->client->pers.weapon)
    return;

  selected_weapon=ITEM_INDEX(ent->client->pers.weapon);

  // scan  for the next valid one
  for (i=1; i<=MAX_ITEMS; i++) {
    index =(selected_weapon+i)%MAX_ITEMS;
    if (!ent->client->pers.inventory[index]) continue;
    it=&itemlist[index];
    if (!it->use) continue;
    if (!(it->flags & IT_WEAPON)) continue;
    it->use(ent, it);
    if (ent->client->pers.weapon == it)
      return; } // successful
}

//============================================================
void Cmd_WeapNext_f(edict_t *ent) {
int i, index;
gitem_t *it;
int selected_weapon;

  if (!ent->client->pers.weapon)
    return;

  selected_weapon=ITEM_INDEX(ent->client->pers.weapon);

  // scan  for the next valid one
  for (i=1; i<=MAX_ITEMS; i++) {
    index =(selected_weapon+MAX_ITEMS-i)%MAX_ITEMS;
    if (!ent->client->pers.inventory[index]) continue;
    it=&itemlist[index];
    if (!it->use) continue;
    if (!(it->flags & IT_WEAPON)) continue;
    it->use(ent, it);
    if (ent->client->pers.weapon == it)
      return; } // successful
}

//============================================================
void Cmd_WeapLast_f(edict_t *ent) {
int index;
gitem_t *it;

  if (!ent->client->pers.weapon || !ent->client->pers.lastweapon)
    return;
  index=ITEM_INDEX(ent->client->pers.lastweapon);
  if (!ent->client->pers.inventory[index])
    return;
  it=&itemlist[index];
  if (!it->use)
    return;
  if (!(it->flags & IT_WEAPON))
    return;
  it->use(ent, it);
}

//============================================================
void Cmd_InvDrop_f(edict_t *ent) {
gitem_t *it;

  // Not available to dead or respawning players!
  if (!G_ClientInGame(ent)) return;

  ValidateSelectedItem(ent);

  if (ent->client->pers.selected_item == -1) {
    gi_cprintf(ent, PRINT_HIGH, "No item to drop.\n");
    return; }

  it=&itemlist[ent->client->pers.selected_item];
  if (!it->drop) {
    gi_cprintf(ent, PRINT_HIGH, "Item is not dropable.\n");
    return; }
  it->drop(ent, it);
}

//============================================================
void Cmd_Kill_f(edict_t *ent) {

  // Not available to dead or respawning players!
  if (!G_ClientInGame(ent)) return;

  if ((level.time-ent->client->respawn_time) < 5)  return;

  ent->flags &= ~FL_GODMODE;
  ent->health=-30;
  meansOfDeath=MOD_SUICIDE;
  player_die(ent, ent, ent, 100000, zvec);
}
//======================================================
// Pay the Piper for the DeathPak
//======================================================
void Cmd_DeathPak_f(edict_t *ent) {

  // Don't allow dead/respawning players to spawn DeathPaks!
  if (!G_ClientInGame(ent)) return;

  if (ent->health <= 25) {
    gi_centerprintf(ent, "DeathPak costs 25 health to spawn!\n");
    return; }

  ent->health -= 25;
  Spawn_DeathPak(ent);
}

//======================================================
// Pay the Piper to launch the Baton
//======================================================
void Cmd_Baton_f(edict_t *ent) {

  // Don't allow dead/respawning players to launch Baton!
  if (!G_ClientInGame(ent)) return;

  // If not enough frags then notify ent..
  if (ent->client->resp.score < 1)
    gi_centerprintf(ent, "Each Baton costs 1 frag!");
  else {
    // Deduct frags from ent's Score
    ent->client->resp.score--;
    // And, fire off the Baton..
    Fire_Baton(ent); }
}

//======================================================
void Cmd_BoobyTrap_f(edict_t *ent) {
int index;

  // Don't allow dead/respawning players to set BoobyTraps!
  if (!G_ClientInGame(ent)) return;

  // Find out which armor the Player has (if any)
  index=ITEM_INDEX(item_jacketarmor);
  if (!ent->client->pers.inventory[index]) {
   index=ITEM_INDEX(item_combatarmor);
   if (!ent->client->pers.inventory[index]) {
     index=ITEM_INDEX(item_bodyarmor);
     if (!ent->client->pers.inventory[index]) {
       gi_centerprintf(ent,"NO ARMOR TO BOOBYTRAP\n");
       return; } } }

  ent->client->pers.inventory[index]=0;

  if (SetBoobyTrap(ent,index))
    gi_centerprintf(ent,"MOVE AWAY NOW!\n");
}

//========================================================
void Cmd_HangMan_f(edict_t *ent) {
int index;

  // if ent has shells then...
  index=ITEM_INDEX(item_shells);
  if ((ent->client->pers.inventory[index] > 10)
   && (ent->client->pers.weapon==FindItem("super shotgun"))) {
    ent->client->pers.inventory[index] -= 10;
    Shoot_Hook(ent); }
  else
    gi_centerprintf(ent, "HangMan requires SShotgun + 10 shells\n");
}

//============================================================
void Cmd_PutAway_f(edict_t *ent) {
  ent->client->showscores=false;
  ent->client->showhelp=false;
  ent->client->showinventory=false;
}


//======================================================
// Pay the Piper for the Depth Charge
//======================================================
void Cmd_DepthCharge_f(edict_t *ent) {
int index;

  // Not available to dead or respawning players!
  if (!G_ClientInGame(ent)) return;

  // Cost in Single-Player
  if (!CVAR_DEATHMATCH) {
    if (ent->health > 10)
      ent->health -= 10;
      Spawn_DepthCharge(ent);
      return; }

  index = ITEM_INDEX(item_grenades);
  if (ent->client->pers.inventory[index] < 5){
    gi_centerprintf(ent, "Depth Charge costs 5 grenades!\n");
    return; }
  else {
    ent->client->pers.inventory[index] -= 5;
    Spawn_DepthCharge(ent); }
}

//============================================================
void Cmd_Players_f(edict_t *ent) {
int i, count=0;
char small[64];
char large[1280];
int index[256];
edict_t *cl_ent;

  for (i=0;i<ga.maxclients;i++) {
    cl_ent=g_edicts+i+1;
    if (!G_EntExists(cl_ent)) continue;
    if (ga.clients[i].pers.connected) {
      index[count]=i;
      count++; } }

  // sort by frags
  qsort(index, count, sizeof(index[0]), PlayerSort);

  // print information
  large[0]=0;

  for (i=0; i < count; i++) {
    Com_sprintf(small, sizeof(small), "%3i %s\n",
      ga.clients[index[i]].ps.stats[STAT_FRAGS],
      ga.clients[index[i]].pers.netname);
    if (strlen(small)+strlen(large) > sizeof(large)-100) {
      // can't print all of them in one packet
      strcat(large, "...\n");
      break; }
    strcat(large, small); }

  gi_cprintf(ent, PRINT_HIGH, "%s\n%i players\n", large, count);
}

//============================================================
void Cmd_Wave_f(edict_t *ent) {
int i;

  // Not available to dead or respawning players!
  if (!G_ClientInGame(ent)) return;

  i=atoi(gi.argv(1));

  // can't wave when ducked
  if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
    return;

  if (ent->client->anim_priority > ANIM_WAVE)
    return;

  ent->client->anim_priority=ANIM_WAVE;

  switch (i) {
    case 0: gi_cprintf(ent, PRINT_HIGH, "flipoff\n");
            ent->s.frame=FRAME_flip01-1;
            ent->client->anim_end=FRAME_flip12;
            break;
    case 1: gi_cprintf(ent, PRINT_HIGH, "salute\n");
            ent->s.frame=FRAME_salute01-1;
            ent->client->anim_end=FRAME_salute11;
            break;
    case 2: gi_cprintf(ent, PRINT_HIGH, "taunt\n");
            ent->s.frame=FRAME_taunt01-1;
            ent->client->anim_end=FRAME_taunt17;
            break;
    case 3: gi_cprintf(ent, PRINT_HIGH, "wave\n");
            ent->s.frame=FRAME_wave01-1;
            ent->client->anim_end=FRAME_wave11;
            break;
    case 4:
    default:gi_cprintf(ent, PRINT_HIGH, "point\n");
            ent->s.frame=FRAME_point01-1;
            ent->client->anim_end=FRAME_point12;
    } // end switch
}

//============================================================
void Cmd_Say_f(edict_t *ent, qboolean team, qboolean arg0) {
int i;
edict_t *other;
char *p, text[2048];

  if (gi.argc() < 2 && !arg0)
    return;

  if (!((int)(dmflags->value) & (DF_MODELTEAMS|DF_SKINTEAMS)))
    team=false;

  if (team)
    Com_sprintf(text, sizeof(text), "(%s): ", ent->client->pers.netname);
  else
    Com_sprintf(text, sizeof(text), "%s: ", ent->client->pers.netname);

  if (arg0) {
    strcat(text, gi.argv(0));
    strcat(text, " ");
    strcat(text, gi.args()); }
  else {
    p=gi.args();
    if (*p == '"') {
      p++;
      p[strlen(p)-1]=0; }
    strcat(text, p); }

  // don't let text be too long for malicious reasons
  if (strlen(text) > 150)
    text[150]=0;

  strcat(text, "\n");

  if (flood_msgs->value) {
    if (level.time < ent->client->flood_locktill) {
      gi_cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n", (int)(ent->client->flood_locktill-level.time));
      return; }
    i=ent->client->flood_whenhead-flood_msgs->value+1;
    if (i < 0)
      i =(sizeof(ent->client->flood_when)/sizeof(ent->client->flood_when[0]))+i;
    if (ent->client->flood_when[i] && level.time-ent->client->flood_when[i] < flood_persecond->value) {
      ent->client->flood_locktill=level.time+flood_waitdelay->value;
      gi_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n", (int)flood_waitdelay->value);
      return; }
    ent->client->flood_whenhead =(ent->client->flood_whenhead+1)%(sizeof(ent->client->flood_when)/sizeof(ent->client->flood_when[0]));
    ent->client->flood_when[ent->client->flood_whenhead]=level.time; }

  if (CVAR_DEDICATED)
    gi_cprintf(NULL, PRINT_CHAT, "%s", text);

  for (i=0;i<ga.maxclients;i++) {
    other=&g_edicts[i];
    if (!G_EntExists(other)) continue;
    if ((team) && (!OnSameTeam(ent, other))) continue;
    gi_cprintf(other, PRINT_CHAT, "%s", text); }
}

//======================================================
// Auto Self-Teleport to random respawning location.
//======================================================
void Cmd_Teleport_f(edict_t *ent) {
vec3_t spawn_origin={0,0,0};
vec3_t spawn_angles={0,0,0};

  // Large particle effect at player's old spot
  G_Spawn_Splash(TE_LASER_SPARKS, 24, 0xe2e5e3e6, ent->s.origin, zvec, ent->s.origin);

  // Ent has a Ride and wants to jump on?
  if (ent->flyer && !ent->is_riding) {
    VectorCopy(ent->flyer->s.origin, ent->s.origin);
    VectorCopy(ent->flyer->s.angles, ent->s.angles);
    ent->is_riding=true; }
  else {
    ent->is_riding=false;
    SelectSpawnPoint(ent, spawn_origin, spawn_angles);
    ent->client->ps.pmove.origin[0] = spawn_origin[0]*8;
    ent->client->ps.pmove.origin[1] = spawn_origin[1]*8;
    ent->client->ps.pmove.origin[2] = spawn_origin[2]*8;
    VectorCopy(spawn_origin, ent->s.origin); }

  // Teleport particle effect at ent's new origin.
  ent->s.event = EV_PLAYER_TELEPORT;

  // play teleport sound effects.
  gi.sound(ent, CHAN_VOICE, gi.soundindex("misc/tele1.wav"), 1, ATTN_NORM, 0);
}

//============================================================
void Cmd_PlayerList_f(edict_t *ent) {
int i;
char st[80], text[1400];
edict_t *e2;

  // connect time, ping, score, name
 *text=0;
  for (i=0, e2=g_edicts+1; i < maxclients->value; i++, e2++) {
    if (!e2->inuse) continue;
    Com_sprintf(st, sizeof(st), "%02d:%02d %4d %3d %s%s\n",
     (level.framenum-e2->client->resp.enterframe)/600,
     ((level.framenum-e2->client->resp.enterframe)%600)/10,
      e2->client->ping,
      e2->client->resp.score,
      e2->client->pers.netname,
      e2->client->resp.spectator ? "(spectator)" : "");
    if (strlen(text)+strlen(st) > sizeof(text)-50) {
      sprintf(text+strlen(text), "And more...\n");
      gi_cprintf(ent, PRINT_HIGH, "%s", text);
      return; }
    strcat(text, st); }

  gi_cprintf(ent, PRINT_HIGH, "%s", text);
}

//======================================================
// Add a 20 seconds cloaking time for 20 powercells
//======================================================
void Cmd_Cloak_f(edict_t *ent) {
int index;

  // Not available to Dead or Respawning players!
  if (!G_ClientInGame(ent)) return;

  index = ITEM_INDEX(item_cells);
  if (ent->client->pers.inventory[index] >= 20) // Add 20 Seconds Cloaking
    ent->client->pers.inventory[index] -= 20;
  else {
    if (ent->client->cloak_framenum > level.framenum)
      gi_cprintf(ent, PRINT_HIGH, "More Time costs 20 PowerCells!!\n");
    else
      gi_cprintf(ent, PRINT_HIGH, "Cloaking requires 20 PowerCells!!\n");
    return; }

  // Add 20 seconds to Ent's Cloaking Timer
  if (ent->client->cloak_framenum > level.framenum)
    ent->client->cloak_framenum += 200;
  else
    ent->client->cloak_framenum = level.framenum + 200;

  if (!ent->client->is_cloaked) {
    gi_centerprintf(ent, "Cloaking ON!\n");
    ent->s.event = EV_PLAYER_TELEPORT; // Add Teleport effect
    ent->svflags |= SVF_NOCLIENT; }

  ent->client->is_cloaked=true;
}

//============================================================
void ClientCommand(edict_t *ent) {
char *cmd=gi.argv(0);

  if (!G_EntExists(ent)) return;

  if (!Q_stricmp(cmd, "players")) {
    Cmd_Players_f(ent);
    return; }

  if (!Q_stricmp(cmd, "say")) {
    Cmd_Say_f(ent, false, false);
    return; }

  if (!Q_stricmp(cmd, "say_team")) {
    Cmd_Say_f(ent, true, false);
    return; }

  if (!Q_stricmp(cmd, "score")) {
    Cmd_Score_f(ent);
    return; }

  if (!Q_stricmp(cmd, "help")) {
    Cmd_Help_f(ent);
    return; }

  if (level.intermissiontime)
    return;

  if (!Q_stricmp(cmd, "use"))
    Cmd_Use_f(ent);
  else if (!Q_stricmp(cmd, "drop"))
    Cmd_Drop_f(ent);
  else if (!Q_stricmp(cmd, "give"))
    Cmd_Give_f(ent);
  else if (!Q_stricmp(cmd, "god"))
    Cmd_God_f(ent);
  else if (!Q_stricmp(cmd, "notarget"))
    Cmd_Notarget_f(ent);
  else if (!Q_stricmp(cmd, "noclip"))
    Cmd_Noclip_f(ent);
  else if (!Q_stricmp(cmd, "inven"))
    Cmd_Inven_f(ent);
  else if (!Q_stricmp(cmd, "invnext"))
    SelectNextItem(ent, -1);
  else if (!Q_stricmp(cmd, "invprev"))
    SelectPrevItem(ent, -1);
  else if (!Q_stricmp(cmd, "invnextw"))
    SelectNextItem(ent, IT_WEAPON);
  else if (!Q_stricmp(cmd, "invprevw"))
    SelectPrevItem(ent, IT_WEAPON);
  else if (!Q_stricmp(cmd, "invnextp"))
    SelectNextItem(ent, IT_POWERUP);
  else if (!Q_stricmp(cmd, "invprevp"))
    SelectPrevItem(ent, IT_POWERUP);
  else if (!Q_stricmp(cmd, "invuse"))
    Cmd_InvUse_f(ent);
  else if (!Q_stricmp(cmd, "invdrop"))
    Cmd_InvDrop_f(ent);
  else if (!Q_stricmp(cmd, "weapprev"))
    Cmd_WeapPrev_f(ent);
  else if (!Q_stricmp(cmd, "weapnext"))
    Cmd_WeapNext_f(ent);
  else if (!Q_stricmp(cmd, "weaplast"))
    Cmd_WeapLast_f(ent);
  else if (!Q_stricmp(cmd, "bestweap")) {
    GetBestWeapon(ent);
    gi_cprintf(ent, PRINT_HIGH, "Best Weapon\n"); }
  else if (!Q_stricmp(cmd, "farweap")) {
    GetFarWeapon(ent);
    gi_cprintf(ent, PRINT_HIGH, "Far Weapon\n"); }
  else if (!Q_stricmp(cmd, "closeweap")) {
    GetCloseWeapon(ent);
    gi_cprintf(ent, PRINT_HIGH, "Close Weapon\n"); }
  else if (!Q_stricmp(cmd, "kill"))
    Cmd_Kill_f(ent);
  else if (!Q_stricmp(cmd, "putaway"))
    Cmd_PutAway_f(ent);
  else if (!Q_stricmp(cmd, "wave"))
    Cmd_Wave_f(ent);
  else if (!Q_stricmp(cmd, "selfdestruct"))
    Cmd_SelfDestruct_f(ent);
  else if (!Q_stricmp(cmd, "playerlist"))
    Cmd_PlayerList_f(ent);
  else if (!Q_stricmp(cmd, "teleport"))
    Cmd_Teleport_f(ent);
  else if (!Q_stricmp(cmd, "catapult"))
    Cmd_Catapult_f(ent);
  else if (!Q_stricmp(cmd, "cloak"))
    Cmd_Cloak_f(ent);
  else if (!Q_stricmp(cmd, "hook"))
    Cmd_Hook_f(ent,cmd);
  else if (!Q_stricmp(cmd, "checkstats"))
    Cmd_CheckStats_f(ent);
  else if (!Q_stricmp(cmd, "id_on")) {
    ent->client->id_on=abs(ent->client->id_on-1);
    ent->touch_debounce_time = level.time + 5.0;
    gi_centerprintf(ent,"PLAYER ID %s!\n",ent->client->id_on<1?"OFF":"ON");}
  else if (!Q_stricmp(cmd, "railbomb")) {
    ent->client->railbomb=abs(ent->client->railbomb-1);
    gi_centerprintf(ent,"RAILBOMBS %s!\n",ent->client->railbomb<1?"DISABLED":"ENABLED");}
  else if (!Q_stricmp(cmd, "hgrenade")) {
    ent->client->hgrenade=abs(ent->client->hgrenade-1);
    gi_centerprintf(ent,"HOMING GRENADES %s!\n",ent->client->hgrenade<1?"DISABLED":"ENABLED");}
  else if (!Q_stricmp(cmd, "tgrenade")) {
    ent->client->Tgrenade=abs(ent->client->Tgrenade-1);
    gi_centerprintf(ent,"TELEPORT GRENADES %s!\n",ent->client->Tgrenade<1?"DISABLED":"ENABLED");}
  else if (!Q_stricmp(cmd, "airstrike1")) {
    ent->airstrike_type=1;
    Cmd_Airstrike_f(ent); }
  else if (!Q_stricmp(cmd, "airstrike2")) {
    ent->airstrike_type=2;
    Cmd_Airstrike_f(ent); }
  else if (!Q_stricmp(cmd, "airstrike3")) {
    ent->airstrike_type=3;
    Cmd_Airstrike_f(ent); }
  else if (!Q_stricmp(cmd, "airstrike4")) {
    ent->airstrike_type=4;
    Cmd_Airstrike_f(ent); }
  else if (!Q_stricmp(cmd, "airstrike5")) {
    ent->airstrike_type=5;
    Cmd_Airstrike_f(ent); }
  else if (!Q_stricmp(cmd, "shark"))
    Cmd_SharkBarrel_f(ent);
  else if (!Q_stricmp(cmd, "depthcharge"))
    Cmd_DepthCharge_f(ent);
  else if (!Q_stricmp(cmd, "baton") )
    Cmd_Baton_f(ent);
  else if (!Q_stricmp(cmd, "insane"))
    Cmd_InsaneDecoy_f(ent);
  else if (!Q_stricmp(cmd, "booby") )
    Cmd_BoobyTrap_f(ent);
  else if (!Q_stricmp(cmd, "lasersweep"))
    Cmd_LaserSweep_f(ent);
  else if (!Q_stricmp(cmd, "laserfence"))
    Cmd_LaserFence_f(ent);
  else if (!Q_stricmp(cmd, "lasercorral"))
    Spawn_LaserCorral(ent);
  else if (!Q_stricmp(cmd, "chamber"))
    Cmd_Chamber_f(ent);
  else if (!Q_stricmp(cmd, "drone"))
    Cmd_LaserDrone_f(ent);
  else if (Q_stricmp(cmd, "deathpak") == 0)
    Cmd_DeathPak_f(ent);
  else if (Q_stricmp(cmd, "hangman") == 0)
    Cmd_HangMan_f(ent);
  else if (Q_stricmp(cmd, "flyer") == 0 )
    Cmd_Flyer_f(ent);
  else if (Q_stricmp(cmd, "tflyer") == 0)
    ent->target_my_enemy=abs(ent->target_my_enemy-1) && ent->is_riding;
  else
    Cmd_Say_f(ent, false, true);
}
