// Enumerated types are assigned an incremental hex char value
// based on their order in the enum type definition during compile
// (see qboolean below) and are considered unsigned chars for purposes
// of comparison or assignment.  They can easily be recasted though.

//==============================================
//==============================================
// qboolean TRUE/FALSE Type Enumeration
//==============================================
//==============================================
typedef enum {
  false,      // 0x00 == 0
  true        // 0x01 == 1
} qboolean;

//==============================================
//==============================================
// Enumerated Destination classes for gi.multicast()
//==============================================
//==============================================
typedef enum {
  MULTICAST_ALL,    // Broadcast message to all
  MULTICAST_PHS,    // Broadcast to Player if in Potentially Hearable Set
  MULTICAST_PVS,    // Broadcast to Player if in Potentially Visible Set
  MULTICAST_ALL_R,  // Broadcast to All Players everywhere in game
  MULTICAST_PHS_R,  // Broadcast to All in Potentially Hearable Set
  MULTICAST_PVS_R   // Broadcast to All in Potentially Visible Set
} multicast_t;

//==============================================
//==============================================
//   Player's Current Movement State Types
//==============================================
//==============================================
typedef enum {
  PM_NORMAL,    // Entity is normal (can accelerate and turn)
  PM_SPECTATOR, // Entity is view only (no acceleration or turning)
  PM_DEAD,      // Entity is Dead
  PM_GIB,       // Entity is Gib matter (different bounding box)
  PM_FREEZE     // Entity is alive but cannot move (Frozen in place)
} pmtype_t;

//==============================================
//==============================================
// Entity Events are for effects that take place
// reletive to an existing entity's origin.
// Very network efficient.
//==============================================
//==============================================
typedef enum {
  EV_NONE,            // No Special Environment Effects
  EV_ITEM_RESPAWN,    // Item respawning Special Effects
  EV_FOOTSTEP,        // Player Footsteps
  EV_FALLSHORT,       // Player jumps from low height
  EV_FALL,            // Player jumps from normal height
  EV_FALLFAR,         // Player jumps from extreme height
  EV_PLAYER_TELEPORT, // Player Teleporting Special Effects
  EV_OTHER_TELEPORT
} entity_event_t;

//==============================================
//==============================================
//     Types of World Solids
//==============================================
//==============================================
typedef enum {
  SOLID_NOT,      // no interaction with other objects
  SOLID_TRIGGER,  // only touch when inside, after moving
  SOLID_BBOX,     // touch on edge
  SOLID_BSP       // bsp clip, touch on edge
} solid_t;

//==============================================
//==============================================
//    Entity's Current Damage Flags
//==============================================
//==============================================
typedef enum {
  DAMAGE_NO,    // Entity cannot be damaged
  DAMAGE_YES,   // Entity can be damaged
  DAMAGE_AIM    // unused??
} damage_t;

//==============================================
//==============================================
//      Weapon Animation flags
//==============================================
//==============================================
typedef enum {
  WEAPON_READY,      // Animate weapon being held
  WEAPON_ACTIVATING, // Animate weapon being activated (BFG, etc.)
  WEAPON_DROPPING,   // Animate weapon being dropped
  WEAPON_FIRING      // Animate weapon being fired.
} weaponstate_t;

//==============================================
//==============================================
//     Various Ammo Entity Types
//==============================================
//==============================================
typedef enum {
  AMMO_BULLETS,  // Show box of Bullets
  AMMO_SHELLS,   // Show box of Shotgun Shells
  AMMO_ROCKETS,  // Show canister of Rockets
  AMMO_GRENADES, // Show Grenades
  AMMO_CELLS,    // Show PowerCell
  AMMO_SLUGS     // Show box of Railgun Slugs
} ammo_t;

//==============================================
//==============================================
//     Allowable Entity Movement Types
//==============================================
//==============================================
typedef enum {
  MOVETYPE_NONE,      // Entity doesn't move! (no movement type)
  MOVETYPE_NOCLIP,    // Entity ignores walls, entities, etc.
  MOVETYPE_PUSH,      // Entity has no clip to world, (push button in)
  MOVETYPE_STOP,      // Entity has no clip to world, (push button out)
  MOVETYPE_WALK,      // Entity is walking
  MOVETYPE_STEP,      // Entity takes single-step (special edge handling)
  MOVETYPE_FLY,       // Entity is floats in the air.
  MOVETYPE_TOSS,      // Entity is being tossed, (hits ground and stops)
  MOVETYPE_FLYMISSILE,// Entity has missile-type movement
  MOVETYPE_BOUNCE     // Entity is tossed but bounces (for grenades,etc)
} movetype_t;

//==============================================
// for spawning and saving/loading games
//==============================================

typedef enum {
  F_INT,
  F_FLOAT,
  F_LSTRING,      // string on disk, pointer in memory, TAG_LEVEL
  F_GSTRING,      // string on disk, pointer in memory, TAG_GAME
  F_VECTOR,
  F_ANGLEHACK,
  F_EDICT,      // index on disk, pointer in memory
  F_ITEM,        // index on disk, pointer in memory
  F_CLIENT,      // index on disk, pointer in memory
  F_FUNCTION,
  F_MMOVE,
  F_IGNORE
} fieldtype_t;

//==============================================
// Temp Entity 'Special Effects'Types
//==============================================
typedef enum
{
  TE_GUNSHOT,
  TE_BLOOD,
  TE_BLASTER,
  TE_RAILTRAIL,
  TE_SHOTGUN,
  TE_EXPLOSION1,
  TE_EXPLOSION2,
  TE_ROCKET_EXPLOSION,
  TE_GRENADE_EXPLOSION,
  TE_SPARKS,
  TE_SPLASH,
  TE_BUBBLETRAIL,
  TE_SCREEN_SPARKS,
  TE_SHIELD_SPARKS,
  TE_BULLET_SPARKS,
  TE_LASER_SPARKS,
  TE_PARASITE_ATTACK,
  TE_ROCKET_EXPLOSION_WATER,
  TE_GRENADE_EXPLOSION_WATER,
  TE_MEDIC_CABLE_ATTACK,
  TE_BFG_EXPLOSION,
  TE_BFG_BIGEXPLOSION,
  TE_BOSSTPORT,      // used as '22' in a map, so DON'T RENUMBER!!!
  TE_BFG_LASER,
  TE_GRAPPLE_CABLE,
  TE_WELDING_SPARKS,
  TE_GREENBLOOD,
  TE_BLUEHYPERBLASTER,
  TE_PLASMA_EXPLOSION,
  TE_TUNNEL_SPARKS,
  TE_BLASTER2,
  TE_RAILTRAIL2,
  TE_FLAME,
  TE_LIGHTNING,
  TE_DEBUGTRAIL,
  TE_PLAIN_EXPLOSION,
  TE_FLASHLIGHT,
  TE_FORCEWALL,
  TE_HEATBEAM,
  TE_MONSTER_HEATBEAM,
  TE_STEAM,
  TE_BUBBLETRAIL2,
  TE_MOREBLOOD,
  TE_HEATBEAM_SPARKS,
  TE_HEATBEAM_STEAM,
  TE_CHAINFIST_SMOKE,
  TE_ELECTRIC_SPARKS,
  TE_TRACKER_EXPLOSION,
  TE_TELEPORT_EFFECT,
  TE_DBALL_GOAL,
  TE_WIDOWBEAMOUT,
  TE_NUKEBLAST,
  TE_WIDOWSPLASH,
  TE_EXPLOSION1_BIG,
  TE_EXPLOSION1_NP,
  TE_FLECHETTE
} temp_event_t;


