#include "defines.h"
#include "m_hover.h"

static int sound_pain1;
static int sound_pain2;
static int sound_death1;
static int sound_death2;
static int sound_sight;
static int sound_search1;
static int sound_search2;


//======================================================
void hover_sight(edict_t *hover, edict_t *other) {
  gi.sound(hover, CHAN_VOICE, sound_sight, 1, ATTN_NORM, 0);
}

//======================================================
void hover_search(edict_t *hover) {
  if (random() < 0.5)
    gi.sound(hover, CHAN_VOICE, sound_search1, 1, ATTN_NORM, 0);
  else
    gi.sound(hover, CHAN_VOICE, sound_search2, 1, ATTN_NORM, 0);
}

//======================================================
//======================================================
void hover_run(edict_t *hover);
void hover_stand(edict_t *hover);
void hover_attack(edict_t *hover);
void hover_reattack(edict_t *hover);
void hover_fire_blaster(edict_t *hover);
void hover_die(edict_t *hover, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
//======================================================
//======================================================

//======================================================
void hover_deadthink(edict_t *hover) {
  if (!hover->groundentity && level.time < hover->timestamp) {
    hover->nextthink=level.time+FRAMETIME;
    return; }
  BecomeExplosion1(hover);
}

//======================================================
void hover_dead(edict_t *hover) {
  VectorSet(hover->mins, -16, -16, -24);
  VectorSet(hover->maxs, 16, 16, -8);
  hover->movetype=MOVETYPE_TOSS;
  hover->think=hover_deadthink;
  hover->nextthink=level.time+FRAMETIME;
  hover->timestamp=level.time+15;
  gi.linkentity(hover);
}

//======================================================
//======================================================
//======================================================

mframe_t hover_frames_stand [] =
{
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL,
  ai_stand, 0, NULL
};
mmove_t hover_move_stand={FRAME_stand01, FRAME_stand30, hover_frames_stand, NULL};

mframe_t hover_frames_stop1 [] =
{
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL
};
mmove_t hover_move_stop1={FRAME_stop101, FRAME_stop109, hover_frames_stop1, NULL};

mframe_t hover_frames_stop2 [] =
{
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL
};
mmove_t hover_move_stop2={FRAME_stop201, FRAME_stop208, hover_frames_stop2, NULL};

mframe_t hover_frames_takeoff [] =
{
  ai_move,  0,  NULL,
  ai_move,  -2,  NULL,
  ai_move,  5,  NULL,
  ai_move,  -1,  NULL,
  ai_move,  1,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  -1,  NULL,
  ai_move,  -1,  NULL,
  ai_move,  -1,  NULL,
  ai_move,  0,  NULL,
  ai_move,  2,  NULL,
  ai_move,  2,  NULL,
  ai_move,  1,  NULL,
  ai_move,  1,  NULL,
  ai_move,  -6,  NULL,
  ai_move,  -9,  NULL,
  ai_move,  1,  NULL,
  ai_move,  0,  NULL,
  ai_move,  2,  NULL,
  ai_move,  2,  NULL,
  ai_move,  1,  NULL,
  ai_move,  1,  NULL,
  ai_move,  1,  NULL,
  ai_move,  2,  NULL,
  ai_move,  0,  NULL,
  ai_move,  2,  NULL,
  ai_move,  3,  NULL,
  ai_move,  2,  NULL,
  ai_move,  0,  NULL
};
mmove_t hover_move_takeoff={FRAME_takeof01, FRAME_takeof30, hover_frames_takeoff, NULL};

mframe_t hover_frames_pain3 [] =
{
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL
};
mmove_t hover_move_pain3={FRAME_pain301, FRAME_pain309, hover_frames_pain3, hover_run};

mframe_t hover_frames_pain2 [] =
{
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL
};
mmove_t hover_move_pain2={FRAME_pain201, FRAME_pain212, hover_frames_pain2, hover_run};

mframe_t hover_frames_pain1 [] =
{
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  2,  NULL,
  ai_move,  -8,  NULL,
  ai_move,  -4,  NULL,
  ai_move,  -6,  NULL,
  ai_move,  -4,  NULL,
  ai_move,  -3,  NULL,
  ai_move,  1,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  3,  NULL,
  ai_move,  1,  NULL,
  ai_move,  0,  NULL,
  ai_move,  2,  NULL,
  ai_move,  3,  NULL,
  ai_move,  2,  NULL,
  ai_move,  7,  NULL,
  ai_move,  1,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  2,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  5,  NULL,
  ai_move,  3,  NULL,
  ai_move,  4,  NULL
};
mmove_t hover_move_pain1={FRAME_pain101, FRAME_pain128, hover_frames_pain1, hover_run};

mframe_t hover_frames_land [] =
{
  ai_move,  0,  NULL
};
mmove_t hover_move_land={FRAME_land01, FRAME_land01, hover_frames_land, NULL};

mframe_t hover_frames_forward [] =
{
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL
};
mmove_t hover_move_forward={FRAME_forwrd01, FRAME_forwrd35, hover_frames_forward, NULL};

mframe_t hover_frames_walk [] =
{
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL,
  ai_walk,  4,  NULL
};
mmove_t hover_move_walk={FRAME_forwrd01, FRAME_forwrd35, hover_frames_walk, NULL};

mframe_t hover_frames_run [] =
{
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL,
  ai_run,  10,  NULL
};
mmove_t hover_move_run={FRAME_forwrd01, FRAME_forwrd35, hover_frames_run, NULL};

mframe_t hover_frames_death1 [] =
{
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  -10,NULL,
  ai_move,  3,  NULL,
  ai_move,  5,  NULL,
  ai_move,  4,  NULL,
  ai_move,  7,  NULL
};
mmove_t hover_move_death1={FRAME_death101, FRAME_death111, hover_frames_death1, hover_dead};

mframe_t hover_frames_backward [] =
{
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL,
  ai_move,  0,  NULL
};
mmove_t hover_move_backward={FRAME_backwd01, FRAME_backwd24, hover_frames_backward, NULL};

mframe_t hover_frames_start_attack [] =
{
  ai_charge,  1,  NULL,
  ai_charge,  1,  NULL,
  ai_charge,  1,  NULL
};
mmove_t hover_move_start_attack={FRAME_attak101, FRAME_attak103, hover_frames_start_attack, hover_attack};

mframe_t hover_frames_attack1 [] =
{
  ai_charge,  -10,  hover_fire_blaster,
  ai_charge,  -10,  hover_fire_blaster,
  ai_charge,  0,    hover_reattack,
};
mmove_t hover_move_attack1={FRAME_attak104, FRAME_attak106, hover_frames_attack1, NULL};


mframe_t hover_frames_end_attack [] =
{
  ai_charge,  1,  NULL,
  ai_charge,  1,  NULL
};
mmove_t hover_move_end_attack={FRAME_attak107, FRAME_attak108, hover_frames_end_attack, hover_run};

//======================================================
void hover_reattack(edict_t *hover) {

  if (hover->enemy->health > 0)
    if (visible(hover, hover->enemy))
      if (random()<=0.6) {
        hover->monsterinfo.currentmove=&hover_move_attack1;
        return; }
  hover->monsterinfo.currentmove=&hover_move_end_attack;
}

//======================================================
void hover_fire_blaster(edict_t *hover) {
vec3_t start, end, dir, forward, right;
int effect=EF_NONE;

  if (hover->s.frame == FRAME_attak104)
    effect=EF_HYPERBLASTER;

  AngleVectors(hover->s.angles, forward, right, NULL);
  G_ProjectSource(hover->s.origin, monster_flash_offset[MZ2_HOVER_BLASTER_1], forward, right, start);

  VectorCopy(hover->enemy->s.origin, end);
  end[2] += hover->enemy->viewheight;
  VectorSubtract(end, start, dir);

  monster_fire_blaster(hover, start, dir, 1, 1000, MZ2_HOVER_BLASTER_1, effect);
}

//======================================================
void hover_stand(edict_t *hover) {
    hover->monsterinfo.currentmove=&hover_move_stand;
}

//======================================================
void hover_run(edict_t *hover) {
  if (hover->monsterinfo.aiflags & AI_STAND_GROUND)
    hover->monsterinfo.currentmove=&hover_move_stand;
  else
    hover->monsterinfo.currentmove=&hover_move_run;
}

//======================================================
void hover_walk(edict_t *hover) {
  hover->monsterinfo.currentmove=&hover_move_walk;
}

//======================================================
void hover_start_attack(edict_t *hover) {
  hover->monsterinfo.currentmove=&hover_move_start_attack;
}

//======================================================
void hover_attack(edict_t *hover) {
  hover->monsterinfo.currentmove=&hover_move_attack1;
}

//======================================================
void hover_pain(edict_t *hover, edict_t *other, float kick, int damage) {

  if (hover->health <(hover->max_health/2))
    hover->s.skinnum=1;

  if (level.time < hover->pain_debounce_time)
    return;

  hover->pain_debounce_time=level.time+3;

  if (CVAR_SKILL == NIGHTMARE_MODE)
    return;    // no pain anims in NIGHTMARE_MODE

  if (damage<=25) {
    if (random() < 0.5) {
      gi.sound(hover, CHAN_VOICE, sound_pain1, 1, ATTN_NORM, 0);
      hover->monsterinfo.currentmove=&hover_move_pain3; }
    else {
      gi.sound(hover, CHAN_VOICE, sound_pain2, 1, ATTN_NORM, 0);
      hover->monsterinfo.currentmove=&hover_move_pain2; } }
  else {
    gi.sound(hover, CHAN_VOICE, sound_pain1, 1, ATTN_NORM, 0);
    hover->monsterinfo.currentmove=&hover_move_pain1; }
}

//======================================================
// XIcarus used by Viper Airstrike routines..
//======================================================
void Hover_Frags(edict_t *attacker) {

  // No Frag assignments in single-player mode
  if (!CVAR_DEATHMATCH) return;

  if (G_EntExists(attacker)) {
    gi_centerprintf(attacker,"1 Frag for killing Icarus!\n");
    attacker->client->resp.score++; }
}

//======================================================
void hover_die(edict_t *hover, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point) {
int n;

  // Airstrike stuff..
  Hover_Frags(attacker);

  // check for gib
  if (hover->health<=hover->gib_health) {
    gi.sound(hover, CHAN_VOICE, gi.soundindex("misc/udeath.wav"), 1, ATTN_NORM, 0);
    for (n= 0; n < 2; n++)
      ThrowGib(hover, "models/objects/gibs/bone/tris.md2", damage, GIB_ORGANIC);
    for (n= 0; n < 2; n++)
      ThrowGib(hover, "models/objects/gibs/sm_meat/tris.md2", damage, GIB_ORGANIC);
    ThrowHead(hover, "models/objects/gibs/sm_meat/tris.md2", damage, GIB_ORGANIC);
    hover->deadflag=DEAD_DEAD;
    return; }

  if (hover->deadflag==DEAD_DEAD) return;

  // regular death
  if (random() < 0.5)
    gi.sound(hover, CHAN_VOICE, sound_death1, 1, ATTN_NORM, 0);
  else
    gi.sound(hover, CHAN_VOICE, sound_death2, 1, ATTN_NORM, 0);
  hover->deadflag=DEAD_DEAD;
  hover->takedamage=DAMAGE_YES;
  hover->monsterinfo.currentmove=&hover_move_death1;
}

//======================================================
void SP_monster_hover(edict_t *hover) {

  if (G_IsDeathmatch(hover)) return;

  sound_pain1=gi.soundindex("hover/hovpain1.wav");
  sound_pain2=gi.soundindex("hover/hovpain2.wav");
  sound_death1=gi.soundindex("hover/hovdeth1.wav");
  sound_death2=gi.soundindex("hover/hovdeth2.wav");
  sound_sight=gi.soundindex("hover/hovsght1.wav");
  sound_search1=gi.soundindex("hover/hovsrch1.wav");
  sound_search2=gi.soundindex("hover/hovsrch2.wav");

  gi.soundindex("hover/hovatck1.wav");

  hover->s.sound=gi.soundindex("hover/hovidle1.wav");

  hover->movetype=MOVETYPE_STEP;
  hover->solid=SOLID_BBOX;
  hover->s.modelindex=gi.modelindex("models/monsters/hover/tris.md2");
  VectorSet(hover->mins, -24, -24, -24);
  VectorSet(hover->maxs, 24, 24, 32);

  hover->health=240;
  hover->gib_health= -100;
  hover->mass=150;

  hover->pain=hover_pain;
  hover->die=hover_die;

  hover->monsterinfo.stand=hover_stand;
  hover->monsterinfo.walk=hover_walk;
  hover->monsterinfo.run=hover_run;
//  hover->monsterinfo.dodge=hover_dodge;
  hover->monsterinfo.attack=hover_start_attack;
  hover->monsterinfo.sight=hover_sight;
  hover->monsterinfo.search=hover_search;

  gi.linkentity(hover);

  hover->monsterinfo.currentmove=&hover_move_stand;
  hover->monsterinfo.scale=MODEL_SCALE;

  flymonster_start(hover);
}
