#include "defines.h"
#include "m_flipper.h"

static int sound_chomp;
static int sound_attack;
static int sound_pain1;
static int sound_pain2;
static int sound_death;
static int sound_idle;
static int sound_search;
static int sound_sight;

void flipper_stand(edict_t *self);

mframe_t flipper_frames_stand [] =
{
  ai_stand, 0, NULL
};

mmove_t  flipper_move_stand={FRAME_flphor01, FRAME_flphor01, flipper_frames_stand, NULL};

void flipper_stand(edict_t *self)
{
    self->monsterinfo.currentmove=&flipper_move_stand;
}

#define FLIPPER_RUN_SPEED  24

mframe_t flipper_frames_run [] =
{
  ai_run, FLIPPER_RUN_SPEED, NULL,  // 6
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,  // 10

  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,  // 20

  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL,
  ai_run, FLIPPER_RUN_SPEED, NULL    // 29
};
mmove_t flipper_move_run_loop={FRAME_flpver06, FRAME_flpver29, flipper_frames_run, NULL};

void flipper_run_loop(edict_t *self)
{
  self->monsterinfo.currentmove=&flipper_move_run_loop;
}

mframe_t flipper_frames_run_start [] =
{
  ai_run, 8, NULL,
  ai_run, 8, NULL,
  ai_run, 8, NULL,
  ai_run, 8, NULL,
  ai_run, 8, NULL,
  ai_run, 8, NULL
};
mmove_t flipper_move_run_start={FRAME_flpver01, FRAME_flpver06, flipper_frames_run_start, flipper_run_loop};

void flipper_run(edict_t *self)
{
  self->monsterinfo.currentmove=&flipper_move_run_start;
}

/* Standard Swimming */
mframe_t flipper_frames_walk [] =
{
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL,
  ai_walk, 4, NULL
};
mmove_t flipper_move_walk={FRAME_flphor01, FRAME_flphor24, flipper_frames_walk, NULL};

void flipper_walk(edict_t *self)
{
  self->monsterinfo.currentmove=&flipper_move_walk;
}

mframe_t flipper_frames_start_run [] =
{
  ai_run, 8, NULL,
  ai_run, 8, NULL,
  ai_run, 8, NULL,
  ai_run, 8, NULL,
  ai_run, 8, flipper_run
};
mmove_t flipper_move_start_run={FRAME_flphor01, FRAME_flphor05, flipper_frames_start_run, NULL};

void flipper_start_run(edict_t *self)
{
  self->monsterinfo.currentmove=&flipper_move_start_run;
}

mframe_t flipper_frames_pain2 [] =
{
  ai_move, 0, NULL,
  ai_move, 0, NULL,
  ai_move, 0,  NULL,
  ai_move, 0,  NULL,
  ai_move, 0, NULL
};
mmove_t flipper_move_pain2={FRAME_flppn101, FRAME_flppn105, flipper_frames_pain2, flipper_run};

mframe_t flipper_frames_pain1 [] =
{
  ai_move, 0, NULL,
  ai_move, 0, NULL,
  ai_move, 0,  NULL,
  ai_move, 0,  NULL,
  ai_move, 0, NULL
};
mmove_t flipper_move_pain1={FRAME_flppn201, FRAME_flppn205, flipper_frames_pain1, flipper_run};

void flipper_bite(edict_t *self)
{
  vec3_t aim;

  VectorSet(aim, MELEE_DISTANCE, 0, 0);
  fire_hit(self, aim, 5, 0);
}

void flipper_preattack(edict_t *self)
{
  gi.sound(self, CHAN_WEAPON, sound_chomp, 1, ATTN_NORM, 0);
}

mframe_t flipper_frames_attack [] =
{
  ai_charge, 0,  flipper_preattack,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  flipper_bite,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  NULL,
  ai_charge, 0,  flipper_bite,
  ai_charge, 0,  NULL
};
mmove_t flipper_move_attack={FRAME_flpbit01, FRAME_flpbit20, flipper_frames_attack, flipper_run};

void flipper_melee(edict_t *self)
{
  self->monsterinfo.currentmove=&flipper_move_attack;
}

void flipper_pain(edict_t *self, edict_t *other, float kick, int damage)
{
  int n;

  if (self->health <(self->max_health/2))
    self->s.skinnum=1;

  if (level.time < self->pain_debounce_time)
    return;

  self->pain_debounce_time=level.time+3;

  if (CVAR_SKILL == NIGHTMARE_MODE)
    return;    // no pain anims in NIGHTMARE_MODE

  n = (rand()+1)%2;
  if (n == 0)
  {
    gi.sound(self, CHAN_VOICE, sound_pain1, 1, ATTN_NORM, 0);
    self->monsterinfo.currentmove=&flipper_move_pain1;
  }
  else
  {
    gi.sound(self, CHAN_VOICE, sound_pain2, 1, ATTN_NORM, 0);
    self->monsterinfo.currentmove=&flipper_move_pain2;
  }
}

void flipper_dead(edict_t *self)
{
  VectorSet(self->mins, -16, -16, -24);
  VectorSet(self->maxs, 16, 16, -8);
  self->movetype=MOVETYPE_TOSS;
  self->svflags |= SVF_DEADMONSTER;
  self->nextthink=0;
  gi.linkentity(self);
}

mframe_t flipper_frames_death [] =
{
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,

  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,

  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,

  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,

  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,

  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL,
  ai_move, 0,   NULL
};
mmove_t flipper_move_death={FRAME_flpdth01, FRAME_flpdth56, flipper_frames_death, flipper_dead};

void flipper_sight(edict_t *self, edict_t *other)
{
  gi.sound(self, CHAN_VOICE, sound_sight, 1, ATTN_NORM, 0);
}

void flipper_die(edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
  int n;

// check for gib
  if (self->health<=self->gib_health)
  {
    gi.sound(self, CHAN_VOICE, gi.soundindex("misc/udeath.wav"), 1, ATTN_NORM, 0);
    for (n= 0; n < 2; n++)
      ThrowGib(self, "models/objects/gibs/bone/tris.md2", damage, GIB_ORGANIC);
    for (n= 0; n < 2; n++)
      ThrowGib(self, "models/objects/gibs/sm_meat/tris.md2", damage, GIB_ORGANIC);
    ThrowHead(self, "models/objects/gibs/sm_meat/tris.md2", damage, GIB_ORGANIC);
    self->deadflag=DEAD_DEAD;
    return;
  }

  if (self->deadflag==DEAD_DEAD)
    return;

// regular death
  gi.sound(self, CHAN_VOICE, sound_death, 1, ATTN_NORM, 0);
  self->deadflag=DEAD_DEAD;
  self->takedamage=DAMAGE_YES;
  self->monsterinfo.currentmove=&flipper_move_death;
}

//============================================================
void swimmonster_start_go(edict_t *self) {
  if (!self->yaw_speed)
    self->yaw_speed=10;
  self->viewheight=10;

  monster_start_go(self);

  if (self->spawnflags & 2)
    monster_triggered_start(self);
}

//============================================================
void swimmonster_start(edict_t *self) {
  self->flags |= FL_SWIM;
  self->think=swimmonster_start_go;
  monster_start(self);
}

/*QUAKED monster_flipper(1 .5 0)(-16 -16 -24)(16 16 32) Ambush Trigger_Spawn Sight
*/
void SP_monster_flipper(edict_t *self)
{
  if (G_IsDeathmatch(self)) return;

  sound_pain1   =gi.soundindex("flipper/flppain1.wav");
  sound_pain2   =gi.soundindex("flipper/flppain2.wav");
  sound_death   =gi.soundindex("flipper/flpdeth1.wav");
  sound_chomp   =gi.soundindex("flipper/flpatck1.wav");
  sound_attack =gi.soundindex("flipper/flpatck2.wav");
  sound_idle   =gi.soundindex("flipper/flpidle1.wav");
  sound_search =gi.soundindex("flipper/flpsrch1.wav");
  sound_sight   =gi.soundindex("flipper/flpsght1.wav");

  self->movetype=MOVETYPE_STEP;
  self->solid=SOLID_BBOX;
  self->s.modelindex=gi.modelindex("models/monsters/flipper/tris.md2");
  VectorSet(self->mins, -16, -16, 0);
  VectorSet(self->maxs, 16, 16, 32);

  self->health=50;
  self->gib_health= -30;
  self->mass=100;

  self->pain=flipper_pain;
  self->die=flipper_die;

  self->monsterinfo.stand=flipper_stand;
  self->monsterinfo.walk=flipper_walk;
  self->monsterinfo.run=flipper_start_run;
  self->monsterinfo.melee=flipper_melee;
  self->monsterinfo.sight=flipper_sight;

  gi.linkentity(self);

  self->monsterinfo.currentmove=&flipper_move_stand;
  self->monsterinfo.scale=MODEL_SCALE;

  swimmonster_start(self);
}

//======================================================
//=========== BARREL OF SHARK ROUTINES =================
//======================================================

//======================================================
// timer->owner      => ent;
// timer->activator  => shark;
//======================================================
void Shark_Explode(edict_t *timer) {

  // Have Shark died already?
  if (!timer->activator) {
    G_FreeEdict(timer);
    return; }

  // Maximally damage the Shark entity...
  T_Damage(timer->activator, timer->owner, timer->owner, zvec, timer->activator->s.origin, NULL, 1000, 1, 0, MOD_SPLASH);
  // Spawn an explosion fireball..
  G_Spawn_Explosion(TE_EXPLOSION2, timer->activator->s.origin, timer->activator->s.origin);
  // Do grenade-type radius damage to anybody nearby
  T_RadiusDamage(timer->activator, timer->owner, 40, NULL, 300, MOD_SPLASH);

  // Free timer entity.
  G_FreeEdict(timer);
}

//=========================================================
void Spawn_Shark(edict_t *barrel) {
  G_Spawn_Monster(barrel->activator, barrel->s.origin, M_FLIPPER, 120);
  G_FreeEdict(barrel);
}

//======================================================
void SharkBarrel_Touch(edict_t *a, edict_t *b, cplane_t *c, csurface_t *d)
{}

//======================================================
void SharkBarrel_Explode(edict_t *barrel) {

  // Not touchable until stopped moving.
  if ((VectorLength(barrel->velocity) > 1)
   || (level.time < barrel->delay)) {
     barrel->nextthink = level.time + 5.0;
     return; }

  // If Barrel in water then explode.
  if (gi.pointcontents(barrel->s.origin) & CONTENTS_WATER) {
    G_Spawn_Explosion(TE_EXPLOSION2, barrel->s.origin, barrel->s.origin);
    barrel->think=Spawn_Shark;
    // Shark appears after fireball finishes..
    barrel->nextthink = level.time + 2.0; }
  else {
    // Barrel self destructs if NOT in water!!
    G_Spawn_Explosion(TE_EXPLOSION2, barrel->s.origin, barrel->s.origin);
    // Toss around some Shark guts!
    ThrowGib(barrel, "models/objects/gibs/sm_meat/tris.md2", 20, GIB_ORGANIC);
    ThrowGib(barrel, "models/objects/gibs/bone/tris.md2", 30, GIB_ORGANIC);
    ThrowGib(barrel, "models/objects/gibs/sm_meat/tris.md2", 50, GIB_ORGANIC);
    // Make barrel go away..
    G_FreeEdict(barrel); }
}

//======================================================
void Toss_SharkBarrel(edict_t *ent) {
edict_t *barrel=NULL;
vec3_t torigin;
vec3_t forward, right, up;

    // Toss barrel in forwar direction
    VectorCopy(ent->s.origin,torigin);
    AngleVectors(ent->client->v_angle, forward, right, up);
    VectorMA(torigin, 50, forward, torigin);
    if (gi.pointcontents(torigin) & MASK_SHOT) {
      gi_cprintf(ent,PRINT_HIGH,"Cannot project into Solid!\n");
      return; }

    barrel = G_Spawn();
    barrel->owner=NULL;    // Owner can be attacked too!
    barrel->activator=ent; // Link back to owner.
    barrel->movetype=MOVETYPE_BOUNCE;
    barrel->solid = SOLID_BBOX;
    barrel->s.renderfx = RF_NONE;
    VectorCopy(up, barrel->s.angles);
    barrel->s.effects = EF_NONE;

    VectorSet(barrel->mins, -10, -10, 0);
    VectorSet(barrel->maxs, 10, 20, 30);
    VectorClear(barrel->velocity);
    VectorScale(forward, 600, barrel->velocity);
    VectorMA(barrel->velocity, 200+crandom()*10.0, up, barrel->velocity);
    VectorMA(barrel->velocity, crandom()*10.0, right, barrel->velocity);
    VectorClear(barrel->avelocity);
    VectorCopy(torigin,barrel->s.origin);
    barrel->model = "models/objects/barrels/tris.md2";
    gi.setmodel(barrel, barrel->model);
    barrel->delay=5.0;
    barrel->touch=SharkBarrel_Touch;
    barrel->think=SharkBarrel_Explode;
    barrel->nextthink = level.time + 1.0;

    gi.linkentity(barrel);
}

