#include "defines.h"


//==========================================================
//=============== GRAPPLE HANGMAN'S WEAPON = (NECKSTRETCHER)=
//==========================================================

//==========================================================
void G_StartVector(edict_t *ent, vec3_t start) {
vec3_t offset, forward, right;

  AngleVectors(ent->owner->client->v_angle, forward, right, NULL);
  VectorSet(offset, 8, 8, ent->owner->viewheight-8);
  VectorAdd(offset, zvec, offset);
  P_ProjectSource_Reverse(ent->owner->client, ent->owner->s.origin, offset, forward, right, start);
}

//=========================================================
void Release_Hook_Cable(edict_t *hook2) {
  G_FreeEdict(hook2->activator); // Free Cable entity first.
  G_FreeEdict(hook2);            // Free Hook entity.
}

//===========================================================
// Every 1 second, jerk the cable and stretch out their neck!
//===========================================================
void Hang_The_Bastard(edict_t *hook2) {
vec3_t start, cablevec, velpart;
float cablelen, f1=0, f2, dprod;

  // Has player died? Then exit..
  if (hook2->goalentity->health <= 0) {
    gi.sound(hook2->goalentity, CHAN_HOOK, HOOK_RETRACT_SOUND, 1, ATTN_IDLE, 0);
    Release_Hook_Cable(hook2);
    return; }

  VectorSet(cablevec,0,0,0);
  VectorSet(velpart,0,0,0);

  // Make cable sounds
  gi.sound(hook2->owner, CHAN_HOOK, HOOK_MOTOR3_SOUND, 1, ATTN_IDLE, 0);

  // Get cable start vector..
  G_StartVector(hook2, start);
  VectorSubtract(hook2->s.origin, start, cablevec);
  cablelen = VectorLength(cablevec);

  // Hang the bastard by the neck!
  if (cablelen > 0) {
    dprod=DotProduct(hook2->goalentity->velocity, cablevec)/DotProduct(cablevec, cablevec);
    VectorScale(cablevec, dprod, velpart);
    f2=cablelen;
    if (DotProduct(hook2->goalentity->velocity, cablevec) < 0) {
      if (cablelen > 25)
        VectorSubtract(hook2->goalentity->velocity, velpart, hook2->goalentity->velocity);
      f1=f2; }
    else
      if (VectorLength(velpart) < f2)
        f1=f2-VectorLength(velpart);
    } // end if

  // Jerking motion to snap their neck!!
  VectorNormalize(cablevec);
  VectorMA(hook2->goalentity->velocity, f1, cablevec, hook2->goalentity->velocity);

  hook2->enemy = hook2->goalentity;

  // Damage this player in decrements of 10 units per cycle.
  T_Damage(hook2->goalentity, hook2, hook2->owner, zvec, hook2->s.origin, NULL, 10, 0, 0, MOD_SPLASH);

  hook2->nextthink = level.time + 1.0; // Jerk'em every 1 second!!
}

//======================================================
// Second Hook fired straight up!  What did it hit?
//======================================================
void Hook2_Touch(edict_t *hook2, edict_t *other, cplane_t *plane, csurface_t *surf) {
vec3_t start, cablevec;
float  cablelen;

  // Hit another player? Damage and exit.
  if (other->takedamage!=DAMAGE_NO) {
    T_Damage(other, hook2, hook2->owner, zvec, hook2->s.origin, NULL, 100, 100, 0, MOD_HANGED);
    Release_Hook_Cable(hook2);
    return; }

  //
  // Otherwise, hit ceiling or sky..
  //

  // Stop hook's spinning and forward motions.
  VectorClear(hook2->avelocity);
  VectorClear(hook2->velocity);

  // Figure out cable's length
  G_StartVector(hook2, start);
  VectorSubtract(hook2->s.origin, start, cablevec);
  cablelen = VectorLength(cablevec);

  // Not enough height to hang the player
  if (cablelen < 300) {
    Release_Hook_Cable(hook2);
    return; }

  // Hang'em!!
  hook2->touch = NULL;
  hook2->think = Hang_The_Bastard;
  hook2->nextthink = level.time + 0.1;
}

//=============================================================
// Make continuous cable appear between start and end vectors.
//=============================================================
void Cable_Think(edict_t *cable) {

  G_Spawn_Trails(TE_BFG_LASER, cable->owner->goalentity->s.origin, cable->owner->s.origin, cable->owner->s.origin);

  cable->nextthink = level.time + 0.1; // Must redraw every frame!!
}

//=============================================================
// In-Flight Think() so that cable appears after grapple fired!
//=============================================================
void Hook1_Think(edict_t *hook) {

  if (1) return; // No Visible cable for first hook

  G_Spawn_Trails(TE_BFG_LASER, hook->owner->s.origin, hook->s.origin, hook->s.origin);

  hook->nextthink = level.time + 0.1; // Must redraw every frame!!
}

//================================================================
// Separate entity so that cable think can function independently
// of the hook think so cable gets continuous redraw while player
// hangs in mid-air..
//================================================================
edict_t *Spawn_Cable(edict_t *hook, edict_t *other) {
edict_t *cable=NULL;
vec3_t up;

  // Find out which direction is up!
  AngleVectors(other->client->v_angle, NULL, NULL, up);

  // Spawn the Cable entity.
  cable = G_Spawn();
  cable->owner = hook;
  cable->goalentity = other;
  VectorCopy(up, cable->movedir);
  VectorCopy(other->s.origin, cable->s.origin);
  cable->takedamage=DAMAGE_NO;
  cable->movetype = MOVETYPE_NONE;
  cable->solid = SOLID_NOT;
  VectorClear(cable->mins);
  VectorClear(cable->maxs);
  cable->think = Cable_Think;
  cable->nextthink = level.time + 0.1;

  return cable;
}

//==========================================================
// Second hook fired UP from targeted player's origin.
//==========================================================
void Spawn_Hook2(edict_t *owner, edict_t *other) {
edict_t *hook2=NULL;
edict_t *cable=NULL;
vec3_t up;

  // Find out which direction is up!  Stupid Question!!
  AngleVectors(other->client->v_angle, NULL, NULL, up);

  // Spawn the Hook entity.
  hook2 = G_Spawn();
  hook2->owner = owner;      // Link to original owner..
  hook2->goalentity = other; // Link to targeted player.
  VectorCopy(up, hook2->movedir);
  hook2->s.effects = EF_ROCKET;
  VectorSet(hook2->avelocity,0,0,-2000);
  VectorScale(up, 1600, hook2->velocity);
  VectorCopy(other->s.origin, hook2->s.origin);
  hook2->s.origin[2] += other->viewheight; // from the neck!
  hook2->takedamage=DAMAGE_NO;
  hook2->movetype = MOVETYPE_FLYMISSILE;
  hook2->clipmask = MASK_SHOT;
  hook2->solid = SOLID_BBOX;
  VectorSet(hook2->mins,-5,-5,-5);
  VectorSet(hook2->maxs, 5, 5, 5);
  hook2->s.modelindex = gi.modelindex("models/weapons/grapple/hook/tris.md2");

  hook2->touch = Hook2_Touch;
  hook2->think = NULL;  // No think function needed.
  hook2->nextthink = 0;

  gi.linkentity(hook2);

  cable=Spawn_Cable(hook2, other);
  hook2->activator = cable;  // Link Cable to Hook.
  gi.linkentity(cable);
}

//=========================================================
// Fired grapple hook hit something... What did it hit?
//=========================================================
void Hook1_Touch(edict_t *hook, edict_t *other, cplane_t *plane, csurface_t *surf) {

  // Smacked into a surface so Sound, Sparks, Radius Damage.
  if (!(surf && surf->flags & SURF_SKY)) {
    gi.sound(hook, CHAN_VOICE, HOOK_SMACK_SOUND, 1, ATTN_IDLE, 0);
    G_Spawn_Sparks(TE_SCREEN_SPARKS, hook->s.origin, plane->normal, hook->s.origin);
    T_RadiusDamage(hook, hook->owner, 30, NULL, 200, MOD_SPLASH); }
  else
  // Hit a Player? so launch 2nd Hook Straight UP!
  if ((G_EntExists(other)) && (other->takedamage!=DAMAGE_NO)) {
    gi.sound(hook, CHAN_VOICE, HOOK_SMACK_SOUND, 1, ATTN_IDLE, 0);
    G_Spawn_Sparks(TE_BLOOD, hook->s.origin, plane->normal, other->s.origin);
    Spawn_Hook2(hook->owner, other); }

  G_FreeEdict(hook); // Free Up First Hook;
}

//==========================================================
// Fire the hook at something in crosshairs..
//==========================================================
void Shoot_Hook(edict_t *ent) {
edict_t *hook=NULL;
vec3_t forward;

  // derive forward direction vector
  AngleVectors(ent->client->v_angle, forward, NULL, NULL);

  // spawn hook
  hook = G_Spawn();
  hook->owner = ent;
  ent->goalentity = ent; // Tie back for Cable..
  VectorCopy(ent->s.origin, hook->s.origin);
  VectorCopy(forward, hook->movedir);
  VectorScale(hook->movedir, 1600, hook->velocity);
  hook->movetype = MOVETYPE_FLY;
  hook->clipmask = MASK_SHOT;
  hook->solid = SOLID_BBOX;
  VectorSet(hook->mins,-5,-5,-5);
  VectorSet(hook->maxs, 5, 5, 5);
  hook->takedamage=DAMAGE_NO;
  hook->s.modelindex = gi.modelindex("models/weapons/grapple/hook/tris.md2");
  VectorSet(hook->avelocity,0,0,-2000);

  hook->touch = Hook1_Touch; // Execute at impact.
  hook->think = Hook1_Think; // Execute during flight.
  hook->nextthink = level.time + 0.1;

  gi.linkentity(hook);

  // Play Hook launch sound..
  gi.sound(hook->owner, CHAN_AUTO, HOOK_LAUNCH_SOUND, 1, ATTN_NORM, 0);
}


//==========================================================
//=============== MEGAHEALTH DEATHPAK ROUTINES =============
//==========================================================

//==========================================================
void Beam_Touch(edict_t *a, edict_t *b, cplane_t *c, csurface_t *d)
{}

//==========================================================
qboolean Raise_Player(edict_t *beam) {
vec3_t end;
float dmg=5;

  // Check if time to lift player more..
  if (level.time >= beam->delay) {
    // Can we lift this player another 50 units?
    VectorMA(beam->goalentity->s.origin, 50, beam->movedir, end);
    if (!gi.pointcontents(end) & MASK_SHOT)
      VectorCopy(end, beam->goalentity->s.origin);
    if (beam->goalentity->health <= dmg)
      dmg += 30; // Maximize final damage for Exploding Body Parts
    // Damage this player in decrements of 'dmg' units per cycle.
    T_Damage(beam->goalentity, beam, beam->activator, zvec, beam->s.origin, NULL, dmg, 0, 0, MOD_DEATHPAK);
    // Has player died yet?
    if (beam->goalentity->health <= 0) {
      // Fireball explosion..
      G_Spawn_Explosion(TE_EXPLOSION1, beam->goalentity->s.origin, beam->goalentity->s.origin);
      return false; }
    // Otherwise, repeat in 1 sec..
    beam->delay = level.time + 1.0; }

  return true;
}

//==========================================================
void Beam_Think(edict_t *beam) {
trace_t tr;
vec3_t end;

  if (!Raise_Player(beam)) {
     G_FreeEdict(beam);
     return; }

  // Generate Beam up to the sky/ceiling
  VectorMA(beam->s.origin, 8192, beam->movedir, end);
  tr=gi.trace(beam->s.origin, NULL, NULL, end, beam, MASK_SHOT);
  VectorCopy(tr.endpos, beam->s.old_origin);
  beam->nextthink = level.time + 0.1; // Every frame else it flashes!!
}

//======================================================
void DeathPak_Touch(edict_t *deathpak, edict_t *other, cplane_t *plane, csurface_t *surf) {
edict_t *beam=NULL;

  // Not touchable until stopped moving.
  if (VectorLength(deathpak->velocity) > 1) return;

  // Only touchable by real players.
  if (!G_EntExists(other)) return;

  // Fireball explosion..
  G_Spawn_Explosion(TE_GRENADE_EXPLOSION, deathpak->s.origin, deathpak->s.origin);

  // Create the Laser Beam Effect
  beam = G_Spawn();
  beam->owner=world;
  beam->goalentity=other; // Link to trapped player
  beam->activator=deathpak->activator; // Link to Owner For frags!!
	beam->movetype = MOVETYPE_NONE;
  beam->solid=SOLID_BBOX;
  beam->takedamage = DAMAGE_NO;
  beam->clipmask=CONTENTS_SOLID;
  beam->s.renderfx |= RF_BEAM | RF_TRANSLUCENT | RF_GLOW;
  beam->s.modelindex=1; // must be non-zero
  beam->s.frame=60;     // beam diameter in units
  beam->s.skinnum=Laser_Green;
  VectorClear(beam->velocity);// No Movement
  VectorClear(beam->s.angles);// No Tilting
  VectorSet(beam->movedir,0,0,1); // Straight UP!
  VectorClear(beam->mins);//,-30,-30,-60); // Size of BBOX for Touch()
  VectorClear(beam->maxs);//, 30, 30,500); // Size of BBOX for Touch()
  VectorCopy(deathpak->s.origin, beam->s.origin);
  beam->s.origin[2] -=15;
  VectorMA(beam->s.origin, 50, beam->movedir, other->s.origin);
	VectorCopy(beam->s.origin, beam->s.old_origin);
  beam->s.sound = gi.soundindex("world/laser.wav");
  beam->delay = level.time + 0.5; // Lift delay

  beam->touch = Beam_Touch;
  beam->think = Beam_Think;
  beam->nextthink = level.time + 0.1;

  gi.linkentity(beam);

  G_FreeEdict(deathpak);

  // Trap this player for ClientThink()
  other->client->is_trapped=1;
}

//======================================================
void Spawn_DeathPak(edict_t *ent) {
edict_t *deathpak=NULL;
vec3_t torigin, forward, right, up;
gitem_t *item=NULL;

    VectorCopy(ent->s.origin,torigin);
    AngleVectors(ent->client->v_angle, forward, right, up);
    VectorMA(torigin, 50, forward, torigin);

    if (gi.pointcontents(torigin) & MASK_SHOT) {
      gi_cprintf(ent,PRINT_HIGH,"Cannot project into Solid!\n");
      return; }

    deathpak = G_Spawn();
    deathpak->owner=world;
    deathpak->activator=ent; // For frag assignments

    deathpak->movetype=MOVETYPE_BOUNCE;

    deathpak->solid = SOLID_BBOX;
    deathpak->s.renderfx = RF_NONE;
    deathpak->s.effects = EF_NONE;

    VectorSet(deathpak->mins, -15, -15, -15);
    VectorSet(deathpak->maxs, 15, 15, 15);
    VectorClear(deathpak->velocity);
    VectorScale(forward, 600, deathpak->velocity);
    VectorMA(deathpak->velocity, 200+crandom()*10.0, up, deathpak->velocity);
    VectorMA(deathpak->velocity, crandom()*10.0, right, deathpak->velocity);
    VectorClear(deathpak->avelocity);
    VectorClear(deathpak->s.angles);
    VectorCopy(torigin,deathpak->s.origin);

    deathpak->model = "models/items/mega_h/tris.md2";
    gi.setmodel(deathpak, deathpak->model);

    deathpak->touch=DeathPak_Touch;

    deathpak->think=G_FreeEdict;
    deathpak->nextthink = level.time + 30.0; // Self Destructs in 30 secs.

    gi.linkentity(deathpak);
}


//======================================================
//=============== Booby Trap Entity ====================
//======================================================

//======================================================
// Throw out 10 grenades in all directions!
//======================================================
void Spawn_Grenades(edict_t *booby) {
trace_t tr;
gitem_t *item=NULL;
edict_t *grenade=NULL;
vec3_t offset;
int i;
vec3_t spray[] = {  {  25,  00,  40 },
                    {  17, -17,  40 },
                    {  00, -25,  40 },
                    { -17, -17,  40 },
                    { -25,  00,  40 },
                    { -17, -17,  40 },
                    { -25,  00,  40 },
                    { -17,  17,  40 },
                    {  00,  25,  40 },
                    {  17,  17,  40 }};
vec3_t forward,right,up,dir;

  VectorSet(offset,0,0,0);

  for (i=1; i<=10; i++) {
    grenade = G_Spawn();
    grenade->owner=world;
    VectorSet(offset, spray[i-1][0], spray[i-1][1], spray[i-1][2]);
    offset[0] += ((crandom()*16.0)-8.0);
    offset[1] += ((crandom()*16.0)-8.0);
    offset[2] += ((crandom()*16.0)-8.0);
    vectoangles(offset, dir);
    AngleVectors(dir, forward, right, up);
    VectorSet(grenade->mins, -15, -15, -15);
    VectorSet(grenade->maxs, 15, 15, 15);
    G_ProjectSource(booby->s.origin, offset, forward, right, grenade->s.origin);
    tr=gi.trace(booby->s.origin, grenade->mins, grenade->maxs, grenade->s.origin, booby, CONTENTS_SOLID);
    VectorCopy(tr.endpos, grenade->s.origin);
    VectorScale(offset, (crandom()*10.0), grenade->velocity);
    grenade->velocity[2]=300;
    grenade->movetype=MOVETYPE_BOUNCE;
    grenade->classname="grenade";
    item = item_grenades;
    grenade->clipmask=MASK_SHOT;
    grenade->solid=SOLID_BBOX;
    grenade->s.effects |= EF_GRENADE;
    grenade->dmg=40;
    grenade->dmg_radius=120;
    grenade->spawnflags = 5; // Signal to Grenade_Explode().
    grenade->model = "models/objects/grenade/tris.md2";
    grenade->s.modelindex=gi.modelindex(grenade->model);
    grenade->touch=Grenade_Touch;
    grenade->think=Grenade_Explode;
    grenade->nextthink = level.time + 10.0+(random()*5.0);
    gi.linkentity(grenade);
    } // end for

  G_FreeEdict(booby);
}

//======================================================
void Booby_Think(edict_t *booby) {
edict_t *ent=NULL;
int i;

  if (booby->delay<=level.time) {
     G_FreeEdict(booby);
     return; }

  // Detonate on first player in 50 units radius.
  for(i=0;i < ga.maxclients;i++) {
    ent=g_edicts+i+1;
    if (!G_ClientInGame(ent)) continue;
    if (ent==booby) continue;
    if (!G_Within_Radius(booby->s.origin, ent->s.origin, 50)) continue;
    // Blow up the Booby Trap in a big explosion.
    G_Spawn_Explosion(TE_EXPLOSION2, booby->s.origin, booby->s.origin);
    // Give off radius damage!
    T_RadiusDamage(booby, booby->owner, booby->dmg, NULL, booby->dmg_radius, MOD_BOOBYTRAP);
    // Toss out Grenades
    Spawn_Grenades(booby);
    return; }

  booby->nextthink = level.time + 0.1;
}

//======================================================
void Booby_Touch(edict_t *baton, edict_t *other, cplane_t *plane, csurface_t *surf)
{}

//======================================================
qboolean SetBoobyTrap(edict_t *ent, int index) {
edict_t *booby=NULL;
vec3_t torigin, forward, right, up;
gitem_t *item=NULL;

  VectorCopy(ent->s.origin,torigin);
  AngleVectors(ent->client->v_angle, forward, right, up);
  VectorMA(torigin, 25, forward, torigin);
  if (gi.pointcontents(torigin) & MASK_SHOT) {
    gi_cprintf(ent,PRINT_HIGH,"Cannot set Trap in Solid!\n");
    return false; }

  booby = G_Spawn();
  booby->classname = "Booby";
  booby->owner = ent;
  booby->takedamage = DAMAGE_NO;
  VectorCopy(torigin, booby->s.origin);
  VectorClear(booby->movedir);
  VectorClear(booby->s.angles);
  VectorClear(booby->velocity);
  booby->movetype = MOVETYPE_TOSS;
  booby->solid = SOLID_BBOX;
  booby->s.effects = EF_ROTATE;
  VectorSet(booby->mins,-16,-16,-16);
  VectorSet(booby->maxs,16,16,16);

  if (index==ARMOR_JACKET)
    booby->s.modelindex = gi.modelindex("models/items/armor/jacket/tris.md2");
  else if (index==ARMOR_COMBAT)
    booby->s.modelindex = gi.modelindex("models/items/armor/combat/tris.md2");
  else
    booby->s.modelindex = gi.modelindex("models/items/armor/body/tris.md2");

  booby->s.modelindex2 = 0;

  booby->delay = level.time + 60; // Turns OFF in 60 seconds..

  booby->dmg=40;         // same as grenade
  booby->dmg_radius=120; // same as grenade

  booby->touch = Booby_Touch;
  booby->think = Booby_Think;
  booby->nextthink = level.time + 5.0; // 5 Secs. to Activation

  gi.linkentity(booby);

  return true;
}

//======================================================
//============== THE BATON WEAPON ======================
//======================================================

//======================================================
void Baton_Explode(edict_t *baton) {

  // Immediately Flag as OFF
  baton->owner->client->baton=0;

  // Blow up the Baton in a big fireball.
  G_Spawn_Explosion(TE_EXPLOSION2, baton->s.origin, baton->s.origin);

  // Send small debris flying all around..
  ThrowDebris(baton, DEBRIS2_MODEL, 1.50, baton->s.origin);
  ThrowDebris(baton, DEBRIS1_MODEL, 2.50, baton->s.origin);
  ThrowDebris(baton, DEBRIS1_MODEL, 3.50, baton->s.origin);
  ThrowDebris(baton, DEBRIS1_MODEL, 3.00, baton->s.origin);
  ThrowDebris(baton, DEBRIS2_MODEL, 1.30, baton->s.origin);

  // Assign any Radius damage frags to the Baton's owner..
  T_RadiusDamage(baton, baton->owner, baton->dmg, NULL, baton->dmg_radius, MOD_SPLASH);

  G_FreeEdict(baton); // Free the baton entity.
}

//========================================================
// True if Baton's timer has expired (or owner has died!)
//========================================================
qboolean Baton_Expired(edict_t *baton) {

  if ((baton->delay < level.time)
   || (baton->owner->client->baton==OFF)) {
    Baton_Explode(baton);
    return true; }
  else
    return false;
}

//==================================================================
// Fires beam at all visible players within 1000 unit radius
//==================================================================
void Baton_Think(edict_t *baton) {
edict_t *ent=NULL;
trace_t tr;
vec3_t start,end;
int i;

  if (Baton_Expired(baton)) return; // Baton exploded?

  baton->viewheight = 16; // required for visible().

  // Find ALL visible ents within 1000 unit radius...
  for(i=0;i < ga.maxclients;i++) {
    ent=g_edicts+i+1;
    if (!G_ClientInGame(ent)) continue;
    if (ent==baton) continue;
//  if (ent==baton->owner) continue; // Exempt Baton's owner??
    if (ent->takedamage==DAMAGE_NO) continue;
    if (!visible(baton,ent)) continue;
    if (!G_Within_Radius(baton->s.origin, ent->s.origin, 1000)) continue;
    VectorCopy(baton->s.origin, start);
    VectorCopy(ent->s.origin, end);
    tr=gi.trace(start, NULL, NULL, end, NULL, MASK_SHOT);
    G_Spawn_Trails(TE_BFG_LASER, start, tr.endpos, tr.endpos); // FIRE!!
    if (G_EntExists(tr.ent) && (tr.ent->takedamage!=DAMAGE_NO))
      T_Damage(tr.ent, baton->owner, baton->owner, zvec, start, zvec, baton->dmg, 1, 0, MOD_BATON);
   } // end for

  // Initiate Re-targeting on next frame.
  baton->nextthink = level.time + 0.1;
}

//==================================================================
// Burn 10 sec fuse of green sparks before targeting visible ents..
//==================================================================
void Baton_Fuse(edict_t *baton) {

  if (Baton_Expired(baton)) return; // Baton exploded?

  // Has the 10 sec fuse burned out yet?
  if (baton->delay-level.time<=1) {
    baton->delay = level.time + 30.0;    // 30 sec to self destruct.
    baton->think = Baton_Think;          // Activate Laser Scan!
    baton->nextthink = level.time + 0.1; // Think on next frame.
    return; }

  // Shower of fuse sparks...
  G_Spawn_Sparks(TE_SCREEN_SPARKS, baton->s.origin, zvec, baton->s.origin);

  baton->nextthink = level.time + 1.0; // Burn fuse every 1 sec..
}

//==========================================================
void Baton_Touch(edict_t *baton, edict_t *other, cplane_t *plane, csurface_t *surf){

  // Hit Sky?  Turn Baton OFF and exit quietly..
  if (surf && surf->flags & SURF_SKY) {
    baton->owner->client->baton=0;
    G_FreeEdict(baton);
    return; }

  // Hit a Player? then Detonate!
  if (G_EntExists(other)) {
    Baton_Explode(baton);
    return; }

  //
  // Hit a World Surface!
  //

  baton->takedamage = DAMAGE_YES; // Can be killed now!

  // Play a sound at point of Baton's impact..
  gi.sound(baton, CHAN_VOICE, gi.soundindex("misc/menu1.wav"), 1, ATTN_IDLE, 0);

  // Stop baton's forward motion.
  VectorClear(baton->avelocity);
  VectorClear(baton->velocity);

  baton->delay = level.time + 11.0; // Really a 10 sec fuse timer.

  baton->touch = NULL; // Don't touch this!

  baton->think = Baton_Fuse;

  // Ignite the Baton's fuse on next frame..
  baton->nextthink = level.time + 0.1;
}

//==========================================================
void Fire_Baton(edict_t *ent) {
edict_t *baton=NULL;
vec3_t offset, start;
vec3_t forward, right;

  VectorSet(offset,0,0,0);
  VectorSet(start,0,0,0);

  // Derive point of Baton's origin
  AngleVectors(ent->client->v_angle, forward, right, NULL);
  VectorSet(offset, 8, 8, ent->viewheight-8); // Off-Handed Launch
  P_ProjectSource_Reverse(ent->client, ent->s.origin, offset, forward, right, start);

  baton = G_Spawn();
  baton->classname = "Baton";
  baton->owner = ent;
  baton->takedamage = DAMAGE_NO; // No Damage until Touch().
  baton->clipmask = MASK_SHOT;   // Ability to be hit by weapon's fire.
  baton->health = 30;            // Hard to target but easy to Kill
  baton->max_health=30;
  VectorCopy(start, baton->s.origin);
  VectorCopy(forward, baton->movedir);
  vectoangles(forward, baton->s.angles);
  VectorScale(forward, 800, baton->velocity); // Baton's toss speed..
  baton->movetype = MOVETYPE_FLY;
  baton->solid = SOLID_BBOX;
  baton->s.effects = EF_NONE;
  VectorSet(baton->mins,-5,-5,-5); // size of bbox for touch
  VectorSet(baton->maxs, 5, 5, 5); // size of bbox for touch
  baton->dmg = 80;         // Damage amount..
  baton->dmg_radius = 300; // Explosion Damage radius
  baton->s.modelindex = gi.modelindex("models/objects/minelite/light2/tris.md2");
  baton->s.modelindex2 = 0;
  VectorSet(baton->avelocity,0,0,-1600); // Add some spin to baton flight..

  baton->touch = Baton_Touch;  // Function to call upon impact

  baton->think = NULL; // Touch will ignite fuse timer
  baton->nextthink = 0;

  ent->client->baton=1; // Flag baton as ON!

  gi.linkentity(baton);
}



//======================================================
//========= Shockwave Enhancement for Grenades =========
//======================================================

//======================================================
void Generate_Shockwave(edict_t *grenade) {
int i;
edict_t *ent=NULL;
vec3_t start, forward, kvelocity, tangles, dir;

  if (CVAR_DEATHMATCH)
    for (i=0;i < ga.maxclients;i++) {
      ent=g_edicts+i+1;
      if (!G_ClientInGame(ent)) continue;
      if (!G_Within_Radius(grenade->s.origin, ent->s.origin, 500)) continue;
      VectorCopy(grenade->s.origin, start);
      VectorSubtract(start, ent->s.origin, dir);
      vectoangles(dir, tangles);
      AngleVectors(tangles, forward, NULL, NULL);
      VectorScale(forward, 10, kvelocity);
      kvelocity[2] += random()*10;
      VectorMA(zvec, 5, kvelocity, ent->velocity); }
  else
    // Single Player Mode..
    while ((ent=findradius(ent, grenade->s.origin, 500))!= NULL) {
      if (!G_IsMonster(ent)) continue;
      VectorCopy(grenade->s.origin, start);
      VectorSubtract(start, ent->s.origin, dir);
      vectoangles(dir, tangles);
      AngleVectors(tangles, forward, NULL, NULL);
      VectorScale(forward, 10, kvelocity);
      kvelocity[2] += random()*10;
      VectorMA(zvec, 10, kvelocity, ent->velocity); }
}

//======================================================
//============== DEPTHCHARGE ROUTINES ==================
//======================================================

//======================================================
void Secondary_Explosion(edict_t *dcharge) {
vec3_t forward, backward, right, left, up;

  VectorSet(up,0,0,1);
  VectorSet(forward,0,1,0);
  VectorSet(right,1,0,0);
  VectorSet(backward,0,-1,0);
  VectorSet(left,-1,0,0);

  // Fire BFG fireball with dmg=200; speed=400; radius=1000!!
  fire_bfg(dcharge->activator, dcharge->s.origin, up, 200, 400, 1000);
  fire_bfg(dcharge->activator, dcharge->s.origin, forward, 200, 400, 1000);
  fire_bfg(dcharge->activator, dcharge->s.origin, right, 200, 400, 1000);
  fire_bfg(dcharge->activator, dcharge->s.origin, backward, 200, 400, 1000);
  fire_bfg(dcharge->activator, dcharge->s.origin, left, 200, 400, 1000);

  // Create a big shockwave
  Generate_Shockwave(dcharge);

  G_FreeEdict(dcharge);
}

//======================================================
void Primary_Explosion(edict_t *dcharge) {

  // Not touchable until stopped moving.
  if ((VectorLength(dcharge->velocity) > 1)
   || (level.time < dcharge->delay)) {
     dcharge->nextthink = level.time + 5.0;
     return; }

  // If in water then big secondary explosion!!
  if (gi.pointcontents(dcharge->s.origin) & CONTENTS_WATER) {
    dcharge->think=Secondary_Explosion;
    dcharge->nextthink = level.time + 1.0; }
  else {
    // Else, small explosion
    G_Spawn_Explosion(TE_EXPLOSION2, dcharge->s.origin, dcharge->s.origin);
    T_RadiusDamage(dcharge, dcharge->activator, 40, NULL, 300, MOD_DEPTHCHARGE);
    G_FreeEdict(dcharge); }
}

//======================================================
void Spawn_DepthCharge(edict_t *ent) {
edict_t *dcharge=NULL;
vec3_t torigin, forward, right, up;
gitem_t *item=NULL;

  VectorCopy(ent->s.origin,torigin);
  AngleVectors(ent->client->v_angle, forward, right, up);
  VectorMA(torigin, 50, forward, torigin);

  if (gi.pointcontents(torigin) & MASK_SHOT) {
    gi_cprintf(ent,PRINT_HIGH,"Cannot project into Solid!\n");
    return; }

  dcharge = G_Spawn();
  dcharge->owner=NULL;
  dcharge->activator=ent;
  dcharge->movetype=MOVETYPE_BOUNCE;
  dcharge->solid = SOLID_BBOX;
  dcharge->s.renderfx = RF_NONE;
  VectorCopy(up, dcharge->s.angles);
  dcharge->s.effects = EF_NONE;

  VectorSet(dcharge->mins, -10, -10, 0);
  VectorSet(dcharge->maxs, 10, 20, 30);
  VectorClear(dcharge->velocity);
  VectorScale(forward, 600, dcharge->velocity);
  VectorMA(dcharge->velocity, 200+crandom()*10.0, up, dcharge->velocity);
  VectorMA(dcharge->velocity, crandom()*10.0, right, dcharge->velocity);
  VectorClear(dcharge->avelocity);
  VectorCopy(torigin,dcharge->s.origin);
  dcharge->model = "models/objects/barrels/tris.md2";
  gi.setmodel(dcharge, dcharge->model);
  dcharge->delay=5.0;
  dcharge->touch=NULL;
  dcharge->think=Primary_Explosion;
  dcharge->nextthink = level.time + 1.0;

  gi.linkentity(dcharge);
}

//======================================================
//============= zylon GAS GRENADES =====================
//======================================================

//======================================================
void Zylon_Touch(edict_t *zylon, edict_t *target, cplane_t *plane, csurface_t *surf) {

  zylon->enemy=target;

  T_Damage(target, zylon, zylon->owner, zvec, zylon->s.origin, plane->normal, 20, 0, 0, MOD_ZYLON_GAS);

  G_FreeEdict(zylon);
}

//======================================================
void Generate_Zylon_Gas(edict_t *ent, vec3_t last_angles) {
edict_t *zylon;
int x,y;

  zylon = G_Spawn();

  zylon->classname = "zylon";
  zylon->owner = ent;

  VectorCopy(ent->s.origin, zylon->s.origin);
  x=(random()>0.5?-1:1);
  y=(random()>0.5?-1:1);

  zylon->s.origin[0] += (random()*20+1)*x;
  zylon->s.origin[1] += (random()*20+1)*y;
  zylon->s.origin[2] += 8;

  VectorCopy(ent->s.old_origin, zylon->s.old_origin);
  VectorClear(zylon->s.angles);

  zylon->velocity[2] = (random()*40)+40;
  zylon->velocity[1] = ((int)((random()*40)+20+last_angles[1])%60)*y;
  zylon->velocity[0] = ((int)((random()*40)+20+last_angles[0])%60)*x;
  VectorCopy(zylon->velocity, last_angles);

  zylon->movetype = MOVETYPE_FLY;
  zylon->solid = SOLID_BBOX;
  zylon->clipmask = MASK_SHOT;
  zylon->s.renderfx = RF_SHELL_GREEN; // gas clouds have green glow..
  zylon->s.effects = EF_COLOR_SHELL;
  zylon->s.frame=0;
  zylon->s.sound=0;
  zylon->s.effects &= EF_ANIM_ALLFAST;
  VectorSet(zylon->mins, -10, -10, -10); // size of bbox for touch
  VectorSet(zylon->maxs, 10, 10, 10);    // size of bbox for touch
  zylon->s.modelindex = gi.modelindex("sprites/s_explod.sp2");

  zylon->touch=Zylon_Touch; // take health away if touched.

  zylon->nextthink = level.time+10; // kill gas cloud in 10 secs..
  zylon->think=G_FreeEdict;

  gi.linkentity(zylon);
}

//======================================================
void Zylon_Grenade(edict_t *ent) {

  Generate_Zylon_Gas(ent, ent->move_angles);

  if (ent->zylon_timer > level.time) {
    ent->nextthink = level.time + 0.2;
    ent->think = Zylon_Grenade;
    return;  }

  G_FreeEdict(ent);
}

//======================================================
//============ RAILBOMB GRENADE CONVERSION =============
//======================================================

//==================================================================
// Fires Rail Slugs into all visible players within 1000 unit radius
//==================================================================
void Railbomb(edict_t *grenade) {
edict_t *ent=NULL;
int i;

  if (CVAR_DEATHMATCH)
    for (i=0;i < ga.maxclients;i++) {
      ent=g_edicts+i+1;
      if (!G_ClientInGame(ent)) continue;
      if (ent->takedamage==DAMAGE_NO) continue;
      if (!G_ClearPath(grenade->s.origin,ent->s.origin)) continue;
      if (!G_Within_Radius(grenade->s.origin, ent->s.origin, 1000)) continue;
      G_Spawn_Trails(TE_RAILTRAIL, grenade->s.origin, ent->s.origin, ent->s.origin);
      T_Damage(ent, grenade->owner, grenade->owner, zvec, grenade->s.origin, zvec, grenade->dmg, 1, 0, MOD_RAILBOMB); }
  else
    // Single Player Mode.
    while ((ent=findradius(ent, grenade->s.origin, 1000))!= NULL) {
      if (!G_IsMonster(ent)) continue;
      if (ent==grenade->owner) continue;
      if (!G_ClearPath(grenade->s.origin,ent->s.origin)) continue;
      G_Spawn_Trails(TE_RAILTRAIL, grenade->s.origin, ent->s.origin, ent->s.origin);
      T_Damage(ent, grenade->owner, grenade->owner, zvec, grenade->s.origin, zvec, grenade->dmg, 1, 0, MOD_RAILBOMB); }
}

//========================================================================
//==================== HOMING GRENADE ROUTINE ============================
//========================================================================

//========================================================================
void HGrenade_Think(edict_t *grenade) {
vec3_t dir, start, up;

  // Time to self-destruct??
  if (grenade->delay<=level.time) {
    Grenade_Explode(grenade);
    return; }

  // Calculate some directional stuff..
  VectorCopy(grenade->goalentity->s.origin, start);
  AngleVectors(grenade->goalentity->s.angles, NULL, NULL, up);
  VectorMA(start,10,up,start);
  VectorSubtract(start,grenade->s.origin, dir);
  VectorCopy(dir,grenade->movedir);
  vectoangles(dir,grenade->s.angles);
  VectorMA(dir,15,up,grenade->velocity);

  grenade->nextthink = level.time + 0.1;
}

//========================================================================
void Homing_Grenade(edict_t *self, vec3_t start, int damage, float damage_radius) {
edict_t *grenade;
vec3_t dir, forward, right, up;

  vectoangles(self->s.angles, dir);
  AngleVectors(dir, forward, right, up);

  grenade = G_Spawn();
  grenade->classname = "hominggrenade";
  grenade->owner = self;
  grenade->activator = self;
  grenade->goalentity = self->mynoise2; // Targeted Player.
  VectorCopy(start, grenade->s.origin);
  VectorClear(grenade->velocity);
  VectorScale(up, 100, grenade->velocity);
  VectorScale(forward, 200, grenade->velocity);
  VectorClear(grenade->avelocity);
  grenade->movetype = MOVETYPE_FLY;
  grenade->clipmask = MASK_SHOT;
  grenade->solid = SOLID_BBOX;
  grenade->s.effects |= EF_GRENADE;
  VectorSet(grenade->mins, -15, -15, -15);
  VectorSet(grenade->maxs, 15, 15, 15);
  grenade->s.modelindex = gi.modelindex("models/objects/grenade2/tris.md2");
  grenade->dmg = damage;
  grenade->dmg_radius = damage_radius;
  grenade->spawnflags = 6;
  grenade->s.sound = gi.soundindex("world/airhiss1.wav");
  grenade->delay = level.time + 30.0; // 30 secs to self-destruct!
  grenade->touch = Grenade_Touch;
  grenade->think = HGrenade_Think;
  grenade->nextthink = level.time + 0.1;
  gi.linkentity(grenade);
}

//======================================================
qboolean Valid_Target_Infront(edict_t *self) {
int i;
edict_t *player;

  if (CVAR_DEATHMATCH)
    for(i=0;i < ga.maxclients;i++) {
      player=g_edicts+i+1;
      if (!G_ClientInGame(player)) continue;
      if (self==player) continue;
      if (!G_Within_Radius(self->s.origin, player->s.origin, 500)) continue;
      if (!infront(self, player)) continue;
      if (!visible(self, player)) continue;
      // Got One!! Chase this player down!
      self->mynoise2=player; // Temp storage of targeted Player.
      return true; }
  else
    // Single Player Mode..
    while ((player=findradius(player, self->s.origin, 1000))!= NULL) {
      if (!G_IsMonster(player)) continue;
      if (!infront(self, player)) continue;
      if (!visible(self, player)) continue;
      // Got One!! Chase this Monster down!
      self->mynoise2=player;
      return true; }

  return false; // nobody in front so be 'regular' grenade.
}

//======================================================
//============= TELEPORT GRENADES ======================
//======================================================

//======================================================
void Teleport_Grenade(edict_t *grenade){
edict_t *ent=NULL;
vec3_t spawn_origin;
vec3_t spawn_angles;

  VectorSet(spawn_origin,0,0,0);
  VectorSet(spawn_angles,0,0,0);

  // Auto Teleport all ents within 300 units of blast..
  while ((ent=findradius(ent,grenade->s.origin,300))!=NULL) {

    if (!G_ClientInGame(ent)) continue; // Must be client!!

    // Have System select a random spawning location
    SelectSpawnPoint(ent, spawn_origin, spawn_angles);

    // Copy over ent's last movement info.
    ent->client->ps.pmove.origin[0] = spawn_origin[0]*8;
    ent->client->ps.pmove.origin[1] = spawn_origin[1]*8;
    ent->client->ps.pmove.origin[2] = spawn_origin[2]*8;

    // Actually Relocate ent to the new spot
    VectorCopy(spawn_origin, ent->s.origin);

    // Must set Ents Respawn Time!
    if (deathmatch->value)
      ent->client->respawn_time=level.time;

    // Do Particle effect at new spot
    ent->s.event = EV_PLAYER_TELEPORT;

    // Play teleport sound effects.
    gi.sound(ent, CHAN_VOICE, gi.soundindex("misc/tele1.wav"), 1, ATTN_NORM, 0);
    } // while
}

//============================================================
void check_dodge(edict_t *self, vec3_t start, vec3_t dir, int speed) {
vec3_t end;
vec3_t v;
trace_t tr;
float eta;

  // easy mode only ducks one quarter the time
  if (CVAR_SKILL == SKILL_EASY)
    if (random() > 0.25)
      return;

  VectorMA(start, 8192, dir, end);
  tr=gi.trace(start, NULL, NULL, end, self, MASK_SHOT);
  if ((tr.ent) && (tr.ent->svflags & SVF_MONSTER)
   && (tr.ent->health > 0)
   && (tr.ent->monsterinfo.dodge)
   && infront(tr.ent, self)) {
    VectorSubtract(tr.endpos, start, v);
    eta = (VectorLength(v)-tr.ent->maxs[0])/speed;
    tr.ent->monsterinfo.dodge(tr.ent, self, eta); }
}

//============================================================
qboolean fire_hit(edict_t *self, vec3_t aim, int damage, int kick) {
trace_t tr;
vec3_t v, dir, point, forward, right, up;
float range;

  //see if enemy is in range
  VectorSubtract(self->enemy->s.origin, self->s.origin, dir);
  range=VectorLength(dir);
  if (range > aim[0])
    return false;

  if (aim[1] > self->mins[0] && aim[1] < self->maxs[0])
    // the hit is straight on so back the range up to the edge of their bbox
    range -= self->enemy->maxs[0];
  else
    // this is a side hit so adjust the "right" value out to the edge of their bbox
    aim[1]=(aim[1]<0)?self->enemy->mins[0]:self->enemy->maxs[0];

  VectorMA(self->s.origin, range, dir, point);

  tr=gi.trace(self->s.origin, NULL, NULL, point, self, MASK_SHOT);
  if (tr.fraction != 1.0) {
    if (tr.ent->takedamage==DAMAGE_NO)
      return false;
    if ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client))
      tr.ent=self->enemy; }

  AngleVectors(self->s.angles, forward, right, up);
  VectorMA(self->s.origin, range, forward, point);
  VectorMA(point, aim[1], right, point);
  VectorMA(point, aim[2], up, point);
  VectorSubtract(point, self->enemy->s.origin, dir);

  T_Damage(tr.ent, self, self, dir, point, zvec, damage, kick/2, DAMAGE_NO_KNOCKBACK, MOD_HIT);

  if (!(tr.ent->svflags & SVF_MONSTER) && (!tr.ent->client))
    return false;

  // do our special form of knockback here
  VectorMA(self->enemy->absmin, 0.5, self->enemy->size, v);
  VectorSubtract(v, point, v);
  VectorNormalize(v);
  VectorMA(self->enemy->velocity, kick, v, self->enemy->velocity);
  if (self->enemy->velocity[2] > 0)
    self->enemy->groundentity=NULL;
  return true;
}

//============================================================
void fire_lead(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int te_impact, int hspread, int vspread, int mod) {
trace_t tr;
vec3_t forward, right, up, dir, end;
float r, u;
vec3_t pos,water_start;
qboolean water=false;
int color, content_mask;

  content_mask=MASK_SHOT|MASK_WATER;
  tr=gi.trace(self->s.origin, NULL, NULL, start, self, MASK_SHOT);
  if (!(tr.fraction != 1.0)) {
    vectoangles(aimdir, dir);
    AngleVectors(dir, forward, right, up);
    r=crandom()*hspread;
    u=crandom()*vspread;
    VectorMA(start, 8192, forward, end);
    VectorMA(end, r, right, end);
    VectorMA(end, u, up, end);
    if (gi.pointcontents(start) & MASK_WATER) {
      water=true;
      VectorCopy(start, water_start);
      content_mask &= ~MASK_WATER; }
    tr=gi.trace(start, NULL, NULL, end, self, content_mask);

    // see if we hit water
    if (tr.contents & MASK_WATER) {
      water=true;
      VectorCopy(tr.endpos, water_start);
      if (!VectorCompare(start, tr.endpos)) {
        if (tr.contents & CONTENTS_WATER) {
          if (!Q_stricmp(tr.surface->name, "*brwater"))
            color=SPLASH_BROWN_WATER;
          else
            color=SPLASH_BLUE_WATER; }
        else if (tr.contents & CONTENTS_SLIME)
          color=SPLASH_SLIME;
        else if (tr.contents & CONTENTS_LAVA)
          color=SPLASH_LAVA;
        else
          color=SPLASH_UNKNOWN;
        if (color != SPLASH_UNKNOWN)
          G_Spawn_Splash(TE_SPLASH, 8, color, tr.endpos, tr.plane.normal, tr.endpos);
        // change bullet's course when it enters water
        VectorSubtract(end, start, dir);
        vectoangles(dir, dir);
        AngleVectors(dir, forward, right, up);
        r=crandom()*hspread*2;
        u=crandom()*vspread*2;
        VectorMA(water_start, 8192, forward, end);
        VectorMA(end, r, right, end);
        VectorMA(end, u, up, end); }
      // re-trace ignoring water this time
      tr=gi.trace(water_start, NULL, NULL, end, self, MASK_SHOT); } }

  // send gun puff/flash
  if (!((tr.surface) && (tr.surface->flags & SURF_SKY)))
    if (tr.fraction != 1.0)
      if (tr.ent->takedamage!=DAMAGE_NO)
        T_Damage(tr.ent, self, self, aimdir, tr.endpos, tr.plane.normal, damage, kick, DAMAGE_BULLET, mod);
      else
        if (strncmp(tr.surface->name, "sky", 3) != 0) {
          G_Spawn_Sparks(te_impact, tr.endpos, tr.plane.normal, tr.endpos);
          PlayerNoise(self, tr.endpos, PNOISE_IMPACT); }

  // if went through water, determine where the end and make a bubble trail
  if (water) {
    VectorSubtract(tr.endpos, water_start, dir);
    VectorNormalize(dir);
    VectorMA(tr.endpos, -2, dir, pos);
    if (gi.pointcontents(pos) & MASK_WATER)
      VectorCopy(pos, tr.endpos);
    else
      tr=gi.trace(pos, NULL, NULL, water_start, tr.ent, MASK_WATER);
    VectorAdd(water_start, tr.endpos, pos);
    VectorScale(pos, 0.5, pos);
    G_Spawn_Trails(TE_BUBBLETRAIL, water_start, tr.endpos, pos); }
}

//============================================================
void fire_bullet(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int mod) {
  fire_lead(self, start, aimdir, damage, kick, TE_GUNSHOT, hspread, vspread, mod);
}

//============================================================
void fire_shotgun(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int count, int mod) {
int i;
  for (i=0; i < count; i++)
    fire_lead(self, start, aimdir, damage, kick, TE_SHOTGUN, hspread, vspread, mod);
}

//============================================================
void blaster_touch(edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf) {
int mod;

  if (other == self->owner) return;

  if (surf && (surf->flags & SURF_SKY)) {
    G_FreeEdict(self);
    return; }

  PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

  if (other->takedamage!=DAMAGE_NO) {
    if (self->spawnflags & 1)
      mod=MOD_HYPERBLASTER;
    else
      mod=MOD_BLASTER;
    T_Damage(other, self, self->owner, self->velocity, self->s.origin, plane->normal, self->dmg, 1, DAMAGE_ENERGY, mod); }
  else {
    if (plane)
      VectorCopy(plane->normal, zvec);
    G_Spawn_Sparks(TE_BLASTER, self->s.origin, plane->normal, self->s.origin); }

  G_FreeEdict(self);
}

//======================================================
void fire_laser(edict_t *attacker, vec3_t start, vec3_t dir, int damage){
trace_t tr;
vec3_t from, end;

  VectorNormalize(dir);
  VectorMA(start, 8192, dir, end);
  VectorCopy(start, from);
  tr = gi.trace(from, zvec, zvec, end, attacker, MASK_SHOT);
  VectorCopy(tr.endpos, from);

  // show the laser beam effect.
  G_Spawn_Trails(TE_BFG_LASER, start, tr.endpos, attacker->s.origin);

  // if target can takedamage, then show splash of blood
  if (tr.ent->takedamage!=DAMAGE_NO) {
    G_Spawn_Sparks(TE_BLOOD, tr.endpos, tr.plane.normal, tr.endpos);
    T_Damage(tr.ent, attacker, attacker, dir, tr.endpos, tr.plane.normal, damage, 0, DAMAGE_ENERGY, MOD_HYPERBLASTER); }
  else if (!((tr.surface) && (tr.surface->flags & SURF_SKY))){
     G_Spawn_Sparks(TE_SCREEN_SPARKS, tr.endpos, tr.plane.normal, tr.endpos);
     T_RadiusDamage(tr.ent, attacker, 30, NULL, damage, MOD_SPLASH);}
}

//============================================================
void fire_blaster(edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int effect, qboolean hyper) {
edict_t *bolt;
trace_t tr;

  if (hyper) {
    fire_laser(self, start, dir, damage);
    return; }

  bolt=G_Spawn();
  VectorNormalize(dir);
  bolt->svflags=SVF_DEADMONSTER;
  VectorCopy(start, bolt->s.origin);
  VectorCopy(start, bolt->s.old_origin);
  vectoangles(dir, bolt->s.angles);
  VectorScale(dir, speed, bolt->velocity);
  bolt->movetype=MOVETYPE_FLYMISSILE;
  bolt->clipmask=MASK_SHOT;
  bolt->solid=SOLID_BBOX;
  bolt->s.effects |= effect;
  VectorClear(bolt->mins);
  VectorClear(bolt->maxs);
  bolt->s.modelindex=gi.modelindex("models/objects/laser/tris.md2");
  bolt->s.sound=gi.soundindex("misc/lasfly.wav");
  bolt->owner=self;
  bolt->touch=blaster_touch;
  bolt->nextthink=level.time+2;
  bolt->think=G_FreeEdict;
  bolt->dmg=damage;
  bolt->classname="bolt";
  if (hyper)
    bolt->spawnflags=1;
  gi.linkentity(bolt);

  if (self->client)
    check_dodge(self, bolt->s.origin, dir, speed);

  tr=gi.trace(self->s.origin, NULL, NULL, bolt->s.origin, bolt, MASK_SHOT);
  if (tr.fraction != 1.0) {
    VectorMA(bolt->s.origin, -10, dir, bolt->s.origin);
    bolt->touch(bolt, tr.ent, NULL, NULL); }
}

//============================================================
void Grenade_Explode(edict_t *ent) {
vec3_t v,dir,origin;
int mod, te_type;
float points;

  // Zylon Gas Grenades only if activated by real Player..
  if (G_EntExists(ent->owner))
    if (ent->owner->client->zylon_grenade) {
      ent->zylon_timer = level.time+10+(random()*10);
      Zylon_Grenade(ent);
      return; }

  PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

  if (G_EntExists(ent->enemy)) {
    VectorAdd(ent->enemy->mins, ent->enemy->maxs, v);
    VectorMA(ent->enemy->s.origin, 0.5, v, v);
    VectorSubtract(ent->s.origin, v, v);
    points=ent->dmg-0.5*VectorLength(v);
    VectorSubtract(ent->enemy->s.origin, ent->s.origin, dir);
    if (ent->spawnflags & 5)
      mod=MOD_BOOBYTRAP;
    else if (ent->spawnflags & 6)
      mod=MOD_HGRENADE;
    else if (ent->spawnflags & 1)
      mod=MOD_HANDGRENADE;
    else if (ent->spawnflags & 4)
      mod=MOD_CLUSTER_BOMBS;
    else
      mod=MOD_GRENADE;
    T_Damage(ent->enemy, ent, ent->owner, dir, ent->s.origin, zvec,(int)points,(int)points, DAMAGE_RADIUS, mod); }

  if (ent->spawnflags & 5)
    mod=MOD_BOOBYTRAP;
  else if (ent->spawnflags & 6)
    mod=MOD_HGRENADE;
  else  if (ent->spawnflags & 2)
    mod=MOD_HELD_GRENADE;
  else if (ent->spawnflags & 4)
    mod=MOD_CLUSTER_BOMBS;
  else if (ent->spawnflags & 1)
    mod=MOD_HG_SPLASH;
  else
    mod=MOD_G_SPLASH;

  if ((G_EntExists(ent->owner)) && (ent->owner->client->Tgrenade))
    Teleport_Grenade(ent);
  else
    T_RadiusDamage(ent, ent->owner, ent->dmg, ent->enemy, ent->dmg_radius, mod);

  VectorMA(ent->s.origin, -0.02, ent->velocity, origin);
  if (ent->waterlevel) {
    if (ent->groundentity)
      te_type=TE_GRENADE_EXPLOSION_WATER;
    else
      te_type=TE_ROCKET_EXPLOSION_WATER; }
  else {
    if (ent->groundentity)
      te_type=TE_GRENADE_EXPLOSION;
    else
      te_type=TE_ROCKET_EXPLOSION; }

  G_Spawn_Explosion(te_type, origin, ent->s.origin);

  // Railbomb only if activated by real Player..
  if (G_EntExists(ent->owner))
    if (ent->owner->client->railbomb)
      Railbomb(ent);

  // Always enabled!
  Generate_Shockwave(ent);

  G_FreeEdict(ent);
}

//============================================================
void Grenade_Touch(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf) {

  if (other == ent->owner) return;

  if (surf && (surf->flags & SURF_SKY)) {
    G_FreeEdict(ent);
    return; }

  if (other->takedamage==DAMAGE_NO) {
    if (ent->spawnflags & 1) {
      if (random() > 0.5)
        gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/hgrenb1a.wav"), 1, ATTN_NORM, 0);
      else
        gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/hgrenb2a.wav"), 1, ATTN_NORM, 0); }
    else
      gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/grenlb1b.wav"), 1, ATTN_NORM, 0);
    return; }

  ent->enemy=other;
  Grenade_Explode(ent);
}

//============================================================
void fire_grenade(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius) {
edict_t *grenade;
vec3_t dir, forward, right, up;

  vectoangles(aimdir, dir);
  AngleVectors(dir, forward, right, up);

  grenade=G_Spawn();
  VectorCopy(start, grenade->s.origin);
  VectorScale(aimdir, speed, grenade->velocity);
  VectorMA(grenade->velocity, 200+crandom()*10.0, up, grenade->velocity);
  VectorMA(grenade->velocity, crandom()*10.0, right, grenade->velocity);
  VectorSet(grenade->avelocity, 300, 300, 300);
  grenade->movetype=MOVETYPE_BOUNCE;
  grenade->clipmask=MASK_SHOT;
  grenade->solid=SOLID_BBOX;
  grenade->s.effects |= EF_GRENADE;
  VectorClear(grenade->mins);
  VectorClear(grenade->maxs);
  grenade->s.modelindex=gi.modelindex("models/objects/grenade/tris.md2");
  grenade->owner=self;
  grenade->touch=Grenade_Touch;
  grenade->nextthink=level.time+timer;
  grenade->think=Grenade_Explode;
  grenade->dmg=damage;
  grenade->dmg_radius=damage_radius;
  grenade->classname="grenade";

  gi.linkentity(grenade);
}

//============================================================
void fire_grenade2(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius, qboolean held) {
edict_t *grenade;
vec3_t dir, forward, right, up;

  // Homing Grenade Activated?
  if (self->client->hgrenade)
    // Is there a valid target to go after?
    if (Valid_Target_Infront(self)) {
      Homing_Grenade(self, start, damage, damage_radius);
      return; }

  vectoangles(aimdir, dir);
  AngleVectors(dir, forward, right, up);

  grenade=G_Spawn();
  VectorCopy(start, grenade->s.origin);
  VectorScale(aimdir, speed, grenade->velocity);
  VectorMA(grenade->velocity, 200+crandom()*10.0, up, grenade->velocity);
  VectorMA(grenade->velocity, crandom()*10.0, right, grenade->velocity);
  VectorSet(grenade->avelocity, 300, 300, 300);
  grenade->movetype=MOVETYPE_BOUNCE;
  grenade->clipmask=MASK_SHOT;
  grenade->solid=SOLID_BBOX;
  grenade->s.effects |= EF_GRENADE;
  VectorClear(grenade->mins);
  VectorClear(grenade->maxs);
  grenade->s.modelindex=gi.modelindex("models/objects/grenade2/tris.md2");
  grenade->owner=self;
  grenade->touch=Grenade_Touch;
  grenade->nextthink=level.time+timer;
  grenade->think=Grenade_Explode;
  grenade->dmg=damage;
  grenade->dmg_radius=damage_radius;
  grenade->classname="hgrenade";
  if (held)
    grenade->spawnflags=3;
  else
    grenade->spawnflags=1;
  grenade->s.sound=gi.soundindex("weapons/hgrenc1b.wav");

  if (timer<=0.0)
    Grenade_Explode(grenade);
  else {
    gi.sound(self, CHAN_WEAPON, gi.soundindex("weapons/hgrent1a.wav"), 1, ATTN_NORM, 0);
    gi.linkentity(grenade); }
}

//============================================================
void rocket_touch(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf) {
vec3_t origin;
int n;

  if (other == ent->owner) return;

  if (surf && (surf->flags & SURF_SKY)) {
    G_FreeEdict(ent);
    return; }

  PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

  // calculate position for the explosion entity
  VectorMA(ent->s.origin, -0.02, ent->velocity, origin);

  if (other->takedamage!=DAMAGE_NO)
    T_Damage(other, ent, ent->owner, ent->velocity, ent->s.origin, plane->normal, ent->dmg, 0, 0, MOD_ROCKET);
  else
    // don't throw any debris in net games
    if (!CVAR_DEATHMATCH && !CVAR_COOP)
      if ((surf) && !(surf->flags & (SURF_WARP|SURF_TRANS33|SURF_TRANS66|SURF_FLOWING))) {
        n=rand()%5;
        while (n--)
          ThrowDebris(ent, "models/objects/debris2/tris.md2", 2, ent->s.origin); }

  T_RadiusDamage(ent, ent->owner, ent->radius_dmg, other, ent->dmg_radius, MOD_R_SPLASH);

  if (ent->waterlevel)
    G_Spawn_Explosion(TE_ROCKET_EXPLOSION_WATER, origin, origin);
  else
    G_Spawn_Explosion(TE_ROCKET_EXPLOSION, origin, origin);

  G_FreeEdict(ent);
}

//============================================================
void fire_rocket(edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage) {
edict_t *rocket;

  rocket=G_Spawn();
  VectorCopy(start, rocket->s.origin);
  VectorCopy(dir, rocket->movedir);
  vectoangles(dir, rocket->s.angles);
  VectorScale(dir, speed, rocket->velocity);
  rocket->movetype=MOVETYPE_FLYMISSILE;
  rocket->clipmask=MASK_SHOT;
  rocket->solid=SOLID_BBOX;
  rocket->s.effects |= EF_ROCKET;
  VectorClear(rocket->mins);
  VectorClear(rocket->maxs);
  rocket->s.modelindex=gi.modelindex("models/objects/rocket/tris.md2");
  rocket->owner=self;
  rocket->touch=rocket_touch;
  rocket->nextthink=level.time+8000/speed;
  rocket->think=G_FreeEdict;
  rocket->dmg=damage;
  rocket->radius_dmg=radius_damage;
  rocket->dmg_radius=damage_radius;
  rocket->s.sound=gi.soundindex("weapons/rockfly.wav");
  rocket->classname="rocket";

  if (self->client)
    check_dodge(self, rocket->s.origin, dir, speed);

  gi.linkentity(rocket);
}

//============================================================
void fire_rail(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick) {
vec3_t from, end;
trace_t tr;
edict_t *ignore=self;
int mask,n=0;
qboolean water=false;

  VectorMA(start, 8192, aimdir, end);
  VectorCopy(start, from);
  mask=MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA;

  while (ignore) {
    tr=gi.trace(from, NULL, NULL, end, ignore, mask);
    if (tr.contents & (CONTENTS_SLIME|CONTENTS_LAVA)) {
      mask &= ~(CONTENTS_SLIME|CONTENTS_LAVA);
      water=true; }
    else {
      ignore=((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client) || (tr.ent->solid == SOLID_BBOX))?tr.ent:NULL;
      if ((tr.ent != self) && (tr.ent->takedamage!=DAMAGE_NO))
        T_Damage(tr.ent, self, self, aimdir, tr.endpos, tr.plane.normal, damage, kick, 0, MOD_RAILGUN); }
    VectorCopy(tr.endpos, from); }

  G_Spawn_Trails(TE_RAILTRAIL, start, tr.endpos, self->s.origin);

  if (water)
    G_Spawn_Trails(TE_RAILTRAIL, start, tr.endpos, tr.endpos);

  PlayerNoise(self, tr.endpos, PNOISE_IMPACT);

  if (G_EntExists(self)) {
    // Wall Piercing RailSlug code..
    VectorMA(tr.endpos, 10, aimdir, from);
    while (n < 10) {
      if ((!(gi.pointcontents(from) & CONTENTS_SOLID)) ) {
        // Found a hole...fire again...
        fire_rail(self, from, aimdir, damage, kick);
        n = 10; }
      else
        n++;
      VectorMA(from, 10, aimdir, from); } }
}

//============================================================
void bfg_explode(edict_t *self) {
edict_t *ent=NULL;
float points, dist;
vec3_t v;

  if (self->s.frame == 0)
    while ((ent=findradius(ent, self->s.origin, self->dmg_radius)) != NULL) {
      if (ent->takedamage==DAMAGE_NO) continue;
      if (ent == self->owner) continue;
      if (!CanDamage(ent, self)) continue;
      if (!CanDamage(ent, self->owner)) continue;
      VectorAdd(ent->mins, ent->maxs, v);
      VectorMA(ent->s.origin, 0.5, v, v);
      VectorSubtract(self->s.origin, v, v);
      dist=VectorLength(v);
      points=self->radius_dmg*(1.0-sqrt(dist/self->dmg_radius));
      if (ent == self->owner)
        points=points*0.5;
      G_Spawn_Explosion(TE_BFG_EXPLOSION, ent->s.origin, ent->s.origin);
      T_Damage(ent, self, self->owner, self->velocity, ent->s.origin, zvec,(int)points, 0, DAMAGE_ENERGY, MOD_BFG_EFFECT); }

  self->nextthink=level.time+FRAMETIME;
  self->s.frame++;
  if (self->s.frame == 5)
    self->think=G_FreeEdict;
}

//============================================================
void bfg_touch(edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf) {

  if (other == self->owner) return;

  if (surf && (surf->flags & SURF_SKY)) {
    G_FreeEdict(self);
    return; }

  PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

  T_Damage(other, self, self->owner, self->velocity, self->s.origin, plane->normal, 200, 0, 0, MOD_BFG_BLAST);

  T_RadiusDamage(self, self->owner, 200, other, 100, MOD_BFG_BLAST);

  gi.sound(self, CHAN_VOICE, gi.soundindex("weapons/bfg__x1b.wav"), 1, ATTN_NORM, 0);
  self->solid=SOLID_NOT;
  self->touch=NULL;
  VectorMA(self->s.origin, -1*FRAMETIME, self->velocity, self->s.origin);
  VectorClear(self->velocity);
  self->s.modelindex=gi.modelindex("sprites/s_bfg3.sp2");
  self->s.frame=0;
  self->s.sound=0;
  self->s.effects &= ~EF_ANIM_ALLFAST;
  self->think=bfg_explode;
  self->nextthink=level.time+FRAMETIME;
  self->enemy=other;

  G_Spawn_Explosion(TE_BFG_BIGEXPLOSION, self->s.origin, self->s.origin);
}

//============================================================
void bfg_think(edict_t *self){
edict_t *ent=NULL, *ignore;
vec3_t point, dir, start, end;
int dmg=10;
trace_t tr;

  if (CVAR_DEATHMATCH && !MonstersInUse)
    dmg=5;

  while ((ent=findradius(ent, self->s.origin, 256)) != NULL) {
    if (ent == self || ent == self->owner) continue;
    if (ent->takedamage==DAMAGE_NO) continue;
    if (!(ent->svflags & SVF_MONSTER) && (!ent->client)
    && (Q_stricmp(ent->classname, "misc_explobox")))
      continue;
    VectorMA(ent->absmin, 0.5, ent->size, point);
    VectorSubtract(point, self->s.origin, dir);
    VectorNormalize(dir);
    ignore=self;
    VectorCopy(self->s.origin, start);
    VectorMA(start, 2048, dir, end);
    while (1) {
      tr=gi.trace(start, NULL, NULL, end, ignore, CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);
      if (!tr.ent) break;
      // hurt it if we can
      if ((tr.ent->takedamage!=DAMAGE_NO) && !(tr.ent->flags & FL_IMMUNE_LASER) && (tr.ent != self->owner))
        T_Damage(tr.ent, self, self->owner, dir, tr.endpos, zvec, dmg, 1, DAMAGE_ENERGY, MOD_BFG_LASER);
      // if we hit something that's not a monster or player we're done
      if (!(tr.ent->svflags & SVF_MONSTER) && (!tr.ent->client)) {
        G_Spawn_Splash(TE_LASER_SPARKS, 4, self->s.skinnum, tr.endpos, tr.plane.normal, tr.endpos);
        break; }
      ignore=tr.ent;
      VectorCopy(tr.endpos, start); }
    G_Spawn_Trails(TE_BFG_LASER, self->s.origin, tr.endpos, self->s.origin); }

  self->nextthink=level.time+FRAMETIME;
}

//============================================================
void fire_bfg(edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius) {
edict_t *bfg;

  bfg=G_Spawn();
  VectorCopy(start, bfg->s.origin);
  VectorCopy(dir, bfg->movedir);
  vectoangles(dir, bfg->s.angles);
  VectorScale(dir, speed, bfg->velocity);
  bfg->movetype=MOVETYPE_FLYMISSILE;
  bfg->clipmask=MASK_SHOT;
  bfg->solid=SOLID_BBOX;
  bfg->s.effects |= EF_BFG|EF_ANIM_ALLFAST;
  VectorClear(bfg->mins);
  VectorClear(bfg->maxs);
  bfg->s.modelindex=gi.modelindex("sprites/s_bfg1.sp2");
  bfg->owner=self;
  bfg->touch=bfg_touch;
  bfg->nextthink=level.time+8000/speed;
  bfg->think=G_FreeEdict;
  bfg->radius_dmg=damage;
  bfg->dmg_radius=damage_radius;
  bfg->classname="bfg blast";
  bfg->s.sound=gi.soundindex("weapons/bfg__l1a.wav");

  bfg->think=bfg_think;
  bfg->nextthink=level.time+FRAMETIME;
  bfg->teammaster=bfg;
  bfg->teamchain=NULL;

  if (self->client)
    check_dodge(self, bfg->s.origin, dir, speed);

  gi.linkentity(bfg);
}
