#include "defines.h"

//==============================================================
void PlayerNoise(edict_t *who, vec3_t where, int type) {
edict_t *noise;

  if (!G_EntExists(who)) return;

  if (type == PNOISE_WEAPON)
    if (who->client->silencer_shots) {
      who->client->silencer_shots--;
      return; }

  if (G_IsDeathmatch(who)) return;

  if (who->flags & FL_NOTARGET)
    return;

  if (!who->mynoise) {
    noise=G_Spawn();
    noise->classname="player_noise";
    VectorSet(noise->mins, -8, -8, -8);
    VectorSet(noise->maxs, 8, 8, 8);
    noise->owner=who;
    noise->svflags=SVF_NOCLIENT;
    who->mynoise=noise;
    noise=G_Spawn();
    noise->classname="player_noise";
    VectorSet(noise->mins, -8, -8, -8);
    VectorSet(noise->maxs, 8, 8, 8);
    noise->owner=who;
    noise->svflags=SVF_NOCLIENT;
    who->mynoise2=noise; }

  if (type == PNOISE_SELF || type == PNOISE_WEAPON) {
    noise=who->mynoise;
    level.sound_entity=noise;
    level.sound_entity_framenum=level.framenum; }
  else {
    noise=who->mynoise2;
    level.sound2_entity=noise;
    level.sound2_entity_framenum=level.framenum; }

  VectorCopy(where, noise->s.origin);
  VectorSubtract(where, noise->maxs, noise->absmin);
  VectorAdd(where, noise->maxs, noise->absmax);
  noise->teleport_time=level.time;
  gi.linkentity(noise);
}

//==============================================================
void G_ProjectSource(vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result) {
  result[0]=point[0]+forward[0]*distance[0]+right[0]*distance[1];
  result[1]=point[1]+forward[1]*distance[0]+right[1]*distance[1];
  result[2]=point[2]+forward[2]*distance[0]+right[2]*distance[1]+distance[2];
}

//==============================================================
void P_ProjectSource(gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result) {
vec3_t dist;
  VectorCopy(distance, dist);
  dist[1]=(client->pers.hand==LEFT_HANDED)?-dist[1]:(client->pers.hand==CENTER_HANDED)?0:dist[1];
  G_ProjectSource(point, dist, forward, right, result);
}

//==========================================================
// this is the same as function P_ProjectSource in p_weapons.c
// except it projects the offset distance in reverse since hook
// is launched with player's free hand
//==========================================================
void P_ProjectSource_Reverse(gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result) {
vec3_t dist;
  VectorCopy(distance, dist);
  dist[1]=(client->pers.hand==LEFT_HANDED)?-dist[1]:(client->pers.hand==CENTER_HANDED)?0:dist[1];
  G_ProjectSource(point, dist, forward, right, result);
}

//==============================================================
edict_t *G_Find(edict_t *from, int fieldofs, char *match) {
char *s;

  if (!from)
    from=g_edicts;
  else
    from++;

  for (; from < &g_edicts[ge.num_edicts]; from++) {
    if (!from->inuse) continue;
    s=*(char **)((byte *)from+fieldofs);
    if (!s) continue;
    if (!Q_stricmp(s, match))
      return from; }

  return NULL;
}

//==============================================================
edict_t *findradius(edict_t *from, vec3_t org, float rad) {
vec3_t eorg;
int j;

  if (!from)
    from=g_edicts;
  else
    from++;

  for (; from < &g_edicts[ge.num_edicts]; from++) {
    if (!from->inuse) continue;
    if (from->solid == SOLID_NOT) continue;
    for (j=0; j<3; j++)
      eorg[j]=org[j] -(from->s.origin[j]+(from->mins[j]+from->maxs[j])*0.5);
    if (VectorLength(eorg) > rad) continue;
    return from; }

  return NULL;
}

//==============================================================
edict_t *G_PickTarget(char *targetname) {
edict_t *ent=NULL;
int num_choices=0;
edict_t *choice[8];

  if (!targetname) {
    gi.dprintf("G_PickTarget called with NULL targetname\n");
    return NULL; }

  while (1) {
    ent=G_Find(ent, FOFS(targetname), targetname);
    if (!ent) break;
    choice[num_choices++]=ent;
    if (num_choices == 8)
      break; }

  if (!num_choices) {
    gi.dprintf("G_PickTarget: target %s not found\n", targetname);
    return NULL; }

  return choice[rand()%num_choices];
}

//==============================================================
void Think_Delay(edict_t *ent) {
  G_UseTargets(ent, ent->activator);
  G_FreeEdict(ent);
}

//==============================================================
void G_UseTargets(edict_t *ent, edict_t *activator) {
edict_t *t;

  //
  // check for a delay
  //
  if (ent->delay) {
  // create a temp object to fire at a later time
    t=G_Spawn();
    t->classname="DelayedUse";
    t->nextthink=level.time+ent->delay;
    t->think=Think_Delay;
    t->activator=activator;
    if (!activator)
      gi.dprintf("Think_Delay with no activator\n");
    t->message=ent->message;
    t->target=ent->target;
    t->killtarget=ent->killtarget;
    return; }

  //
  // print the message
  //
  if ((ent->message) && !(activator->svflags & SVF_MONSTER)) {
    gi_centerprintf(activator, "%s", ent->message);
    if (ent->noise_index)
      gi.sound(activator, CHAN_AUTO, ent->noise_index, 1, ATTN_NORM, 0);
    else
      gi.sound(activator, CHAN_AUTO, gi.soundindex("misc/talk1.wav"), 1, ATTN_NORM, 0); }

  //
  // kill killtargets
  //
  if (ent->killtarget) {
    t=NULL;
    while ((t=G_Find(t, FOFS(targetname), ent->killtarget))) {
      G_FreeEdict(t);
      if (!ent->inuse) {
        gi.dprintf("edict was removed while using killtargets\n");
        return; } } }

  //
  // fire targets
  //
  if (ent->target) {
    t=NULL;
    while ((t=G_Find(t, FOFS(targetname), ent->target))) {
      if (!Q_stricmp(t->classname, "func_areaportal")
       && (!Q_stricmp(ent->classname, "func_door")
       || !Q_stricmp(ent->classname, "func_door_rotating")))
        continue;
      if (t == ent)
        gi.dprintf("WARNING: edict used itself.\n");
      else
        if (t->use)
          t->use(t, ent, activator);
      if (!ent->inuse) {
        gi.dprintf("edict was removed while using targets\n");
        return; } } }
}

//==============================================================
//==============================================================
//==============================================================

vec3_t VEC_UP       = (0, -1,  0);
vec3_t MOVEDIR_UP   = (0,  0,  1);
vec3_t VEC_DOWN     = (0, -2,  0);
vec3_t MOVEDIR_DOWN = (0,  0, -1);

//==============================================================
void G_SetMovedir(vec3_t angles, vec3_t movedir) {

  if (VectorCompare(angles, VEC_UP))
    VectorCopy(MOVEDIR_UP, movedir);
  else if (VectorCompare(angles, VEC_DOWN))
    VectorCopy(MOVEDIR_DOWN, movedir);
  else
    AngleVectors(angles, movedir, NULL, NULL);

  VectorClear(angles);
}

//==============================================================
void G_InitEdict(edict_t *e) {
  e->inuse=true;
  e->classname="noclass";
  e->gravity=1.0;
  e->s.number=e-g_edicts;
}

//==============================================================
edict_t *G_Spawn(void) {
int i;
edict_t *e;

  e=&g_edicts[(int)maxclients->value+1];
  for (i=ga.maxclients+1; i<ge.num_edicts; i++, e++)
    if (!e->inuse && (e->freetime < 2 || level.time-e->freetime > 0.5)) {
      G_InitEdict(e);
      return e; }

  if (i == ga.maxentities)
    gi.error(ERR_FATAL, "G_Spawn: no free edicts");

  ge.num_edicts++;
  G_InitEdict(e);
  return e;
}

//==============================================================
void G_FreeEdict(edict_t *ed) {

  gi.unlinkentity(ed);

  if ((ed-g_edicts) <=(ga.maxclients+BODY_QUEUE_SIZE))
    return;

  memset(ed, 0, sizeof(*ed));
  ed->classname="freed";
  ed->freetime=level.time;
  ed->inuse=false;
}

//==============================================================
void G_TouchTriggers(edict_t *ent) {
int i, num;
edict_t *touch[MAX_EDICTS], *hit;

  // dead things don't activate triggers!
  if ((ent->client || (ent->svflags & SVF_MONSTER)) && (ent->health<=0))
    return;

  num=gi.BoxEdicts(ent->absmin, ent->absmax, touch, MAX_EDICTS, AREA_TRIGGERS);

  for (i=0; i<num; i++) {
    hit=touch[i];
    if (!hit->inuse || !hit->touch) continue;
    hit->touch(hit, ent, NULL, NULL); }
}

//==============================================================
void G_TouchSolids(edict_t *ent) {
int i, num;
edict_t *touch[MAX_EDICTS], *hit;

  num=gi.BoxEdicts(ent->absmin, ent->absmax, touch , MAX_EDICTS, AREA_SOLID);

  // be careful, it is possible to have an edict in this
  // list removed before we get to it(killtriggered)
  for (i=0; i<num; i++) {
    hit=touch[i];
    if (!hit->inuse) continue;
    if (ent->touch)
      ent->touch(hit, ent, NULL, NULL);
    if (!ent->inuse) break; }
}

//==============================================================
qboolean KillBox(edict_t *ent) {
trace_t tr;

  while (1) {
    tr=gi.trace(ent->s.origin, ent->mins, ent->maxs, ent->s.origin, NULL, MASK_PLAYERSOLID);
    if (!tr.ent) break;
    T_Damage(tr.ent, ent, ent, zvec, ent->s.origin, zvec, 100000, 0, DAMAGE_NO_PROTECTION, MOD_TELEFRAG);
    if (tr.ent->solid)
      return false; }

  return true;
}

//==============================================================
void Telefrag_All(edict_t *ent) {
  KillBox(ent);
}

//=======================================================
// Returns the distance between two entities..
//=======================================================
float G_Distance(edict_t *ent1, edict_t *ent2) {
vec3_t v;
  VectorSubtract(ent1->s.origin, ent2->s.origin, v);
  return VectorLength(v);
}

//=====================================================
// Returns Player with Highest Score.
//=====================================================
edict_t *BestScoreEnt(void) {
edict_t *bestplayer=NULL;
int i, bestscore=-999;
edict_t *ent;

  // Search thru all clients
  for(i=0; i < ga.maxclients; i++) {
    ent=g_edicts+i+1;
    if (!G_EntExists(ent)) continue;
    if (ent->client->resp.score > bestscore) {
      bestplayer=ent; // Found one!
      bestscore=ent->client->resp.score; } }

   return bestplayer;
}

//======================================================
//=========== LINKED LIST ROUTINES =====================
//======================================================

//===============================================
//            LINKED LIST STRUCTURE
//===============================================
//
typedef struct ent_list_s {
  edict_t *entptr;
  struct ent_list_s *next;
} entlist;

entlist *ptr1=NULL,*ptr2=NULL;
int num_players=0;
entlist *nextptr=NULL;

//=========================================================
//  Returns next non-NULL edict in Linked List.
//=========================================================
edict_t *G_GetNextEnt(void) {
entlist *tptr=NULL;

   if (!nextptr) nextptr=ptr1;

   while (nextptr!=NULL) {
     tptr=nextptr; // one to return;
     nextptr=nextptr->next; // move to next rec in list.
     if (tptr->entptr!=NULL)
       return tptr->entptr;
     if (nextptr==NULL)
       nextptr=ptr1; }

   return NULL;
}

//=========================================================
//  Returns a Random edict in Linked List.
//=========================================================
edict_t *G_GetRandomEnt(void) {
int i,rec;

   rec = rand()%num_players+1; // selection method..

   ptr2=ptr1; // ptr2 ALWAYS starts at ptr1

   for (i=2; i<=rec; i++) { // Skip to random rec number
     ptr2=ptr2->next;
     if (ptr2==NULL)
       ptr2=ptr1; } // A little bit of safeguarding...

   if (ptr2==NULL) return NULL;

   return ptr2->entptr;
}

//=========================================================
// Returns edict with Highest Score from List.
//=========================================================
edict_t *G_GetBestScoreEnt(void) {
edict_t *bestptr=NULL;
int bestscore=-999;

   ptr2=ptr1; // ptr2 ALWAYS starts at ptr1

   // scan thru entire list..
   while (ptr2!=NULL) {
     if (ptr2->entptr->client->resp.score > bestscore) {
       bestptr=ptr2->entptr; // Found one. Can it be beat?
       bestscore=ptr2->entptr->client->resp.score; }
     ptr2=ptr2->next; }

   return bestptr;
}

//=========================================================
// edict is added to List in ClientBeginDeathmatch()
//=========================================================
void G_AddToEntList(edict_t *ent) {
entlist *newptr;

  // create the next rec in list
  newptr = (entlist *)malloc(sizeof(entlist));
//   newptr = gi.TagMalloc(sizeof(entlist), TAG_LEVEL);
   if (newptr == NULL) {
     gi.error(ERR_FATAL, "AddToEntList: NOT ENOUGH MEMORY!!\n");
     return;}

   newptr->entptr = ent; // make the assignment
   newptr->next = NULL;  // tie off end pointer

   if (ptr1==NULL)       // if this is first rec then
     ptr1 = newptr;      // set ptr1 to point to new rec
   else {
     ptr2=ptr1;          // ptr2 ALWAYS starts at ptr1
     while (ptr2->next!=NULL)
       ptr2=ptr2->next;  // move quickly to last rec.
     ptr2->next=newptr;} // connect the dots..

   num_players+=1;       // added player to list.
}

//=========================================================
// edict is removed from List in ClientDisconnect()
//=========================================================
void G_RemoveFromEntList(edict_t *ent) {
entlist *ptr3;

   ptr3=ptr2=ptr1; // ptr2 ALWAYS starts at ptr1

   // scan all links in list.
   while (ptr2 != NULL) {
     if (ptr2->entptr==ent) {
       if (ptr2==ptr1)
         ptr1=ptr2->next;
       else
         ptr3->next = ptr2->next;
     free(ptr2);      // put into garbage collection..
       num_players--;   // one less player on list.
     return; }        // Okay, we're done, so Exit
     ptr3=ptr2;
     ptr2=ptr2->next; } // move to next rec in list
}

//=========================================================
// Removes all Entities from EntList in EndDMLevel()
//=========================================================
void G_ScrubEntList(void) {
entlist *tptr;

   ptr2=ptr1; // ptr2 ALWAYS starts at ptr1

   // step across entire list.
   while (ptr2!=NULL) {
     tptr=ptr2;
     ptr2=ptr2->next;
     free(tptr); }

   ptr1=NULL;     // reset ptr to start of list.
   num_players=0; // nobody on list anymore.
}

//============================================================
//================== HELPER FUNCTIONS ========================
//============================================================

//=========================================================
// Returns the next available edict_t record.
//=========================================================
int G_GetFreeEdict(void) {
edict_t *ent=NULL;
int i;

   // Get next available edict record..
   for (i = 0; i < ga.maxclients; i++) {
      ent=g_edicts+i+1;
      if (!ent->inuse)
        return i; }

    // Otherwise, No Free Edicts!

    return -1; // Signal to Refuse Connection!!
}

//============================================================
// Used by all monster code to see if deathmatch mode is set.
//============================================================
qboolean G_IsDeathmatch(edict_t *self) {
  if (CVAR_DEATHMATCH && !MonstersInUse) {
    G_FreeEdict(self);
    return true; }
  else
    return false;
}

//======================================================
// True if start and end are within radius distance.
//======================================================
qboolean G_Within_Radius(vec3_t start, vec3_t end, float rad) {
vec3_t eorg;
int j;
    for (j=0; j<3; j++)
      eorg[j]=abs(start[j]-end[j]);
    return (VectorLength(eorg) < rad);
}

//======================================================
// True if Ent is valid, has client, and edict_t inuse.
//======================================================
qboolean G_EntExists(edict_t *ent) {
  return ((ent) && (ent->client) && (ent->inuse));
}

//======================================================
// True if ent is not DEAD or DEAD or DEAD (and BURIED!)
//======================================================
qboolean G_ClientNotDead(edict_t *ent) {
qboolean buried=true;
qboolean b1=ent->client->ps.pmove.pm_type!=PM_DEAD;
qboolean b2=ent->deadflag==DEAD_NO;
qboolean b3=ent->health > 0;
  return ((b3 || b2 || b1) && buried);
}

//======================================================
// True if ent is not DEAD and not just did a Respawn.
//======================================================
qboolean G_ClientInGame(edict_t *ent) {
  if (!G_EntExists(ent)) return false;
  if (!G_ClientNotDead(ent)) return false;
  return (ent->client->respawn_time + 5.0 < level.time);
}

//======================================================
// True if Ent is valid Monster edict.
//======================================================
qboolean G_IsMonster(edict_t *ent) {
   return ((ent->svflags & SVF_MONSTER)
        && (ent->deadflag==DEAD_NO)
        && (ent->takedamage!=DAMAGE_NO)
        && ((ent->movetype==MOVETYPE_WALK)
         || (ent->movetype==MOVETYPE_STEP)
         || (ent->movetype==MOVETYPE_FLY)));
}

//======================================================
// Returns 1 if clear path from spot1 to spot2
//======================================================
qboolean G_ClearPath(vec3_t spot1, vec3_t spot2) {
  return (gi.trace(spot1, NULL, NULL, spot2, NULL, MASK_OPAQUE).fraction == 1.0);
}

//===================================================
void gi_cprintf(edict_t *ent, int printlevel, char *fmt, ...) {
char bigbuffer[0x10000];
va_list argptr;
int len;

  if (!ent || !ent->inuse || !ent->client)
    return;

  va_start(argptr,fmt);
  len = vsprintf(bigbuffer,fmt,argptr);
  va_end(argptr);

  gi.cprintf(ent, printlevel, bigbuffer);
}

//===================================================
void gi_centerprintf(edict_t *ent, char *fmt, ...) {
char bigbuffer[0x10000];
va_list argptr;
int len;

  if (!ent || !ent->inuse || !ent->client)
    return;

  va_start(argptr,fmt);
  len = vsprintf(bigbuffer,fmt,argptr);
  va_end(argptr);

  gi.centerprintf(ent, bigbuffer);
}

//===================================================
void gi_bprintf(int printlevel, char *fmt, ...) {
char bigbuffer[0x10000];
int i, len;
va_list argptr;
edict_t *ent;

  va_start(argptr,fmt);
  len = vsprintf(bigbuffer,fmt,argptr);
  va_end(argptr);

  if (CVAR_DEDICATED)
    gi.cprintf(NULL, printlevel, bigbuffer);

  for (i=0; i<ga.maxclients; i++) {
    ent=g_edicts+1+i;
    gi_cprintf(ent, printlevel, bigbuffer); }
}

