#include "defines.h"

//=============================================
void SP_item_health(edict_t *self);
void SP_item_health_small(edict_t *self);
void SP_item_health_large(edict_t *self);
void SP_item_health_mega(edict_t *self);

void SP_info_player_start(edict_t *ent);
void SP_info_player_deathmatch(edict_t *ent);
void SP_info_player_coop(edict_t *ent);
void SP_info_player_intermission(edict_t *ent);

void SP_func_plat(edict_t *ent);
void SP_func_rotating(edict_t *ent);
void SP_func_button(edict_t *ent);
void SP_func_door(edict_t *ent);
void SP_func_door_secret(edict_t *ent);
void SP_func_door_rotating(edict_t *ent);
void SP_func_water(edict_t *ent);
void SP_func_train(edict_t *ent);
void SP_func_conveyor(edict_t *self);
void SP_func_wall(edict_t *self);
void SP_func_object(edict_t *self);
void SP_func_explosive(edict_t *self);
void SP_func_timer(edict_t *self);
void SP_func_areaportal(edict_t *ent);
void SP_func_clock(edict_t *ent);
void SP_func_killbox(edict_t *ent);

void SP_trigger_always(edict_t *ent);
void SP_trigger_once(edict_t *ent);
void SP_trigger_multiple(edict_t *ent);
void SP_trigger_relay(edict_t *ent);
void SP_trigger_push(edict_t *ent);
void SP_trigger_hurt(edict_t *ent);
void SP_trigger_key(edict_t *ent);
void SP_trigger_counter(edict_t *ent);
void SP_trigger_elevator(edict_t *ent);
void SP_trigger_gravity(edict_t *ent);
void SP_trigger_monsterjump(edict_t *ent);

void SP_target_temp_entity(edict_t *ent);
void SP_target_speaker(edict_t *ent);
void SP_target_explosion(edict_t *ent);
void SP_target_changelevel(edict_t *ent);
void SP_target_secret(edict_t *ent);
void SP_target_goal(edict_t *ent);
void SP_target_splash(edict_t *ent);
void SP_target_spawner(edict_t *ent);
void SP_target_blaster(edict_t *ent);
void SP_target_crosslevel_trigger(edict_t *ent);
void SP_target_crosslevel_target(edict_t *ent);
void SP_target_laser(edict_t *self);
void SP_target_help(edict_t *ent);
void SP_target_actor(edict_t *ent);
void SP_target_lightramp(edict_t *self);
void SP_target_earthquake(edict_t *ent);
void SP_target_character(edict_t *ent);
void SP_target_string(edict_t *ent);

void SP_worldspawn(edict_t *ent);
void SP_viewthing(edict_t *ent);

void SP_light(edict_t *self);
void SP_light_mine1(edict_t *ent);
void SP_light_mine2(edict_t *ent);
void SP_info_null(edict_t *self);
void SP_info_notnull(edict_t *self);
void SP_path_corner(edict_t *self);
void SP_point_combat(edict_t *self);

void SP_misc_explobox(edict_t *self);
void SP_misc_banner(edict_t *self);
void SP_misc_satellite_dish(edict_t *self);
void SP_misc_actor(edict_t *self);
void SP_misc_gib_arm(edict_t *self);
void SP_misc_gib_leg(edict_t *self);
void SP_misc_gib_head(edict_t *self);
void SP_misc_insane(edict_t *self);
void SP_misc_deadsoldier(edict_t *self);
void SP_misc_viper(edict_t *self);
void SP_misc_viper_bomb(edict_t *self);
void SP_misc_bigviper(edict_t *self);
void SP_misc_strogg_ship(edict_t *self);
void SP_misc_teleporter(edict_t *self);
void SP_misc_teleporter_dest(edict_t *self);
void SP_misc_blackhole(edict_t *self);
void SP_misc_eastertank(edict_t *self);
void SP_misc_easterchick(edict_t *self);
void SP_misc_easterchick2(edict_t *self);

void SP_monster_berserk(edict_t *self);
void SP_monster_gladiator(edict_t *self);
void SP_monster_gunner(edict_t *self);
void SP_monster_infantry(edict_t *self);
void SP_monster_soldier_light(edict_t *self);
void SP_monster_soldier(edict_t *self);
void SP_monster_soldier_ss(edict_t *self);
void SP_monster_tank(edict_t *self);
void SP_monster_medic(edict_t *self);
void SP_monster_flipper(edict_t *self);
void SP_monster_chick(edict_t *self);
void SP_monster_parasite(edict_t *self);
void SP_monster_flyer(edict_t *self);
void SP_monster_brain(edict_t *self);
void SP_monster_floater(edict_t *self);
void SP_monster_hover(edict_t *self);
void SP_monster_mutant(edict_t *self);
void SP_monster_supertank(edict_t *self);
void SP_monster_boss2(edict_t *self);
void SP_monster_jorg(edict_t *self);
void SP_monster_boss3_stand(edict_t *self);
void SP_monster_commander_body(edict_t *self);

void SP_turret_breach(edict_t *self);
void SP_turret_base(edict_t *self);
void SP_turret_driver(edict_t *self);

typedef struct {
  char *name;
  void (*spawn)(edict_t *ent);
} spawn_t;

//=====================================================
void SP_info_player_intermission(edict_t *ent)
{}

//=====================================================

spawn_t  spawns[]={
  {"item_health", SP_item_health},
  {"item_health_small", SP_item_health_small},
  {"item_health_large", SP_item_health_large},
  {"item_health_mega", SP_item_health_mega},

  {"info_player_start", SP_info_player_start},
  {"info_player_deathmatch", SP_info_player_deathmatch},
  {"info_player_coop", SP_info_player_coop},
  {"info_player_intermission", SP_info_player_intermission},

  {"func_plat", SP_func_plat},
  {"func_button", SP_func_button},
  {"func_door", SP_func_door},
  {"func_door_secret", SP_func_door_secret},
  {"func_door_rotating", SP_func_door_rotating},
  {"func_rotating", SP_func_rotating},
  {"func_train", SP_func_train},
  {"func_water", SP_func_water},
  {"func_conveyor", SP_func_conveyor},
  {"func_areaportal", SP_func_areaportal},
  {"func_clock", SP_func_clock},
  {"func_wall", SP_func_wall},
  {"func_object", SP_func_object},
  {"func_timer", SP_func_timer},
  {"func_explosive", SP_func_explosive},
  {"func_killbox", SP_func_killbox},

  {"trigger_always", SP_trigger_always},
  {"trigger_once", SP_trigger_once},
  {"trigger_multiple", SP_trigger_multiple},
  {"trigger_relay", SP_trigger_relay},
  {"trigger_push", SP_trigger_push},
  {"trigger_hurt", SP_trigger_hurt},
  {"trigger_key", SP_trigger_key},
  {"trigger_counter", SP_trigger_counter},
  {"trigger_elevator", SP_trigger_elevator},
  {"trigger_gravity", SP_trigger_gravity},
  {"trigger_monsterjump", SP_trigger_monsterjump},

  {"target_temp_entity", SP_target_temp_entity},
  {"target_speaker", SP_target_speaker},
  {"target_explosion", SP_target_explosion},
  {"target_changelevel", SP_target_changelevel},
  {"target_secret", SP_target_secret},
  {"target_goal", SP_target_goal},
  {"target_splash", SP_target_splash},
  {"target_spawner", SP_target_spawner},
  {"target_blaster", SP_target_blaster},
  {"target_crosslevel_trigger", SP_target_crosslevel_trigger},
  {"target_crosslevel_target", SP_target_crosslevel_target},
  {"target_laser", SP_target_laser},
  {"target_help", SP_target_help},
  {"target_actor", SP_target_actor},
  {"target_lightramp", SP_target_lightramp},
  {"target_earthquake", SP_target_earthquake},
  {"target_character", SP_target_character},
  {"target_string", SP_target_string},

  {"worldspawn", SP_worldspawn},
  {"viewthing", SP_viewthing},

  {"light", SP_light},
  {"light_mine1", SP_light_mine1},
  {"light_mine2", SP_light_mine2},
  {"info_null", SP_info_null},
  {"func_group", SP_info_null},
  {"info_notnull", SP_info_notnull},
  {"path_corner", SP_path_corner},
  {"point_combat", SP_point_combat},

  {"misc_explobox", SP_misc_explobox},
  {"misc_banner", SP_misc_banner},
  {"misc_satellite_dish", SP_misc_satellite_dish},
  {"misc_actor", SP_misc_actor},
  {"misc_gib_arm", SP_misc_gib_arm},
  {"misc_gib_leg", SP_misc_gib_leg},
  {"misc_gib_head", SP_misc_gib_head},
  {"misc_insane", SP_misc_insane},
  {"misc_deadsoldier", SP_misc_deadsoldier},
  {"misc_viper", SP_misc_viper},
  {"misc_viper_bomb", SP_misc_viper_bomb},
  {"misc_bigviper", SP_misc_bigviper},
  {"misc_strogg_ship", SP_misc_strogg_ship},
  {"misc_teleporter", SP_misc_teleporter},
  {"misc_teleporter_dest", SP_misc_teleporter_dest},
  {"misc_blackhole", SP_misc_blackhole},
  {"misc_eastertank", SP_misc_eastertank},
  {"misc_easterchick", SP_misc_easterchick},
  {"misc_easterchick2", SP_misc_easterchick2},

  {"monster_berserk", SP_monster_berserk},
  {"monster_gladiator", SP_monster_gladiator},
  {"monster_gunner", SP_monster_gunner},
  {"monster_infantry", SP_monster_infantry},
  {"monster_soldier_light", SP_monster_soldier_light},
  {"monster_soldier", SP_monster_soldier},
  {"monster_soldier_ss", SP_monster_soldier_ss},
  {"monster_tank", SP_monster_tank},
  {"monster_tank_commander", SP_monster_tank},
  {"monster_medic", SP_monster_medic},
  {"monster_flipper", SP_monster_flipper},
  {"monster_chick", SP_monster_chick},
  {"monster_parasite", SP_monster_parasite},
  {"monster_flyer", SP_monster_flyer},
  {"monster_brain", SP_monster_brain},
  {"monster_floater", SP_monster_floater},
  {"monster_hover", SP_monster_hover},
  {"monster_mutant", SP_monster_mutant},
  {"monster_supertank", SP_monster_supertank},
  {"monster_boss2", SP_monster_boss2},
  {"monster_boss3_stand", SP_monster_boss3_stand},
  {"monster_jorg", SP_monster_jorg},

  {"monster_commander_body", SP_monster_commander_body},

  {"turret_breach", SP_turret_breach},
  {"turret_base", SP_turret_base},
  {"turret_driver", SP_turret_driver},

  {NULL, NULL}
};

//============================================================
void ED_CallSpawn(edict_t *ent) {
spawn_t *s;
gitem_t *item;
int i;

  if (!ent->classname) {
    gi.dprintf("ED_CallSpawn: NULL classname\n");
    return; }

  // check item spawn functions
  for (i=0,item=itemlist; i<ga.num_items; i++,item++) {
    if (!item->classname) continue;
    if (!Q_stricmp(item->classname, ent->classname)) {
      SpawnItem(ent, item);
      return; } }

  // check normal spawn functions
  for (s=spawns; s->name; s++)
    if (!Q_stricmp(s->name, ent->classname)) {
      s->spawn(ent);
      return; }

  gi.dprintf("%s doesn't have a spawn function\n", ent->classname);
}

//============================================================
char *ED_NewString(char *string) {
char *newb, *new_p;
int i,l;

  l=strlen(string)+1;

  newb=gi.TagMalloc(l, TAG_LEVEL);

  new_p=newb;

  for (i=0; i< l; i++)
    if (string[i] == '\\' && i < l-1) {
      i++;
      *new_p++=(string[i] == 'n')?'\n':'\\'; }
    else
     *new_p++=string[i];

  return newb;
}

//============================================================
void ED_ParseField(char *key, char *value, edict_t *ent) {
field_t *f;
byte *b;
float v;
vec3_t vec;

  for (f=fields; f->name; f++) {
    if (!(f->flags & FFL_NOSPAWN) && !Q_stricmp(f->name, key)) {
      b=(f->flags & FFL_SPAWNTEMP)?(byte *)&st:(byte *)ent;
      switch (f->type) {
        case F_LSTRING:
         *(char **)(b+f->ofs)=ED_NewString(value);
          break;
        case F_VECTOR:
          sscanf(value, "%f %f %f", &vec[0], &vec[1], &vec[2]);
          ((float *)(b+f->ofs))[0]=vec[0];
          ((float *)(b+f->ofs))[1]=vec[1];
          ((float *)(b+f->ofs))[2]=vec[2];
          break;
        case F_INT:
         *(int *)(b+f->ofs)=atoi(value);
          break;
        case F_FLOAT:
         *(float *)(b+f->ofs)=atof(value);
          break;
        case F_ANGLEHACK:
          v=atof(value);
          ((float *)(b+f->ofs))[0]=0;
          ((float *)(b+f->ofs))[1]=v;
          ((float *)(b+f->ofs))[2]=0;
          break;
        case F_IGNORE: break;
        } // end switch
      return; } }

  gi.dprintf("%s is not a field\n", key);
}

//============================================================
char *ED_ParseEdict(char *data, edict_t *ent) {
qboolean init=false;
char keyname[256];
char *com_token;

  memset(&st, 0, sizeof(st));

  // go through all the dictionary pairs
  while (1) {
    // parse key
    com_token=COM_Parse(&data);
    if (com_token[0] == '}')
      break;
    if (!data)
      gi.error(ERR_FATAL,"ED_ParseEntity: EOF without closing brace");
    strncpy(keyname, com_token, sizeof(keyname)-1);
    // parse value
    com_token=COM_Parse(&data);
    if (!data)
      gi.error(ERR_FATAL,"ED_ParseEntity: EOF without closing brace");
    if (com_token[0] == '}')
      gi.error(ERR_FATAL,"ED_ParseEntity: closing brace without data");
    init=true;
    // keynames with a leading underscore are used for utility comments,
    // and are immediately discarded by quake
    if (keyname[0] == '_') continue;
    ED_ParseField(keyname, com_token, ent);
    } // end while

  if (!init)
    memset(ent, 0, sizeof(*ent));

  return data;
}

//============================================================
void G_FindTeams(void) {
edict_t *e, *e2, *chain;
int i, j, c=0, c2=0;

  for (i=1, e=g_edicts+i; i < ge.num_edicts; i++,e++) {
    if (!e->inuse || !e->team) continue;
    if (e->flags & FL_TEAMSLAVE) continue;
    chain=e;
    e->teammaster=e;
    c++;
    c2++;
    for (j=i+1, e2=e+1; j < ge.num_edicts; j++,e2++) {
      if (!e2->inuse || !e2->team) continue;
      if (e2->flags & FL_TEAMSLAVE) continue;
      if (!Q_stricmp(e->team, e2->team)) {
        c2++;
        chain->teamchain=e2;
        e2->teammaster=e;
        chain=e2;
        e2->flags |= FL_TEAMSLAVE; } } }

  if (c>0 && c2>0)
    gi.dprintf("%i teams with %i entities\n", c, c2);
}

//============================================================
void SpawnEntities(char *mapname, char *entities, char *spawnpoint) {
edict_t *ent=NULL;
int i, inhibit=0;
char *com_token;

  // Force skill to NIGHTMARE MODE - hehe!!
  gi.cvar_forceset("skill", va("%f","3"));

  SaveClientData();

  gi.FreeTags(TAG_LEVEL);

  memset(&level, 0, sizeof(level));
  memset(g_edicts, 0, ga.maxentities*sizeof(g_edicts[0]));

  strncpy(level.mapname, mapname, sizeof(level.mapname)-1);
  strncpy(ga.spawnpoint, spawnpoint, sizeof(ga.spawnpoint)-1);

  // set client fields on player ents
  for (i=0; i<ga.maxclients; i++)
    g_edicts[i+1].client=ga.clients+i;

  // parse ents
  while (1) {
    com_token=COM_Parse(&entities);
    if (!entities) break;
    if (com_token[0] != '{')
      gi.error(ERR_FATAL,"ED_LoadFromFile: found %s when expecting {",com_token);
    ent=(!ent)?g_edicts:G_Spawn();
    entities=ED_ParseEdict(entities, ent);

    // yet another map hack
    if (!Q_stricmp(level.mapname, "command")
     && !Q_stricmp(ent->classname, "trigger_once")
     && !Q_stricmp(ent->model, "*27"))
      ent->spawnflags &= ~SPAWNFLAG_NOT_HARD;

    // remove things(except the world) from different skill levels or deathmatch
    if (ent != g_edicts) {
      if (CVAR_DEATHMATCH) {
        if (ent->spawnflags & SPAWNFLAG_NOT_DEATHMATCH) {
          G_FreeEdict(ent);
          inhibit++;
          continue; } }
      else {
        if (((CVAR_SKILL == SKILL_EASY) && (ent->spawnflags & SPAWNFLAG_NOT_EASY)) ||
         ((CVAR_SKILL == SKILL_MEDIUM) && (ent->spawnflags & SPAWNFLAG_NOT_MEDIUM)) ||
         (((CVAR_SKILL == SKILL_HARD) || (CVAR_SKILL == NIGHTMARE_MODE)) && (ent->spawnflags & SPAWNFLAG_NOT_HARD))) {
            G_FreeEdict(ent);
            inhibit++;
            continue; } }
      ent->spawnflags &= ~(SPAWNFLAG_NOT_EASY|SPAWNFLAG_NOT_MEDIUM|SPAWNFLAG_NOT_HARD|SPAWNFLAG_NOT_COOP|SPAWNFLAG_NOT_DEATHMATCH);
      } // endif

    ED_CallSpawn(ent);
    } // end while

  G_FindTeams();

  PlayerTrail_Init();
}

//===================================================================
//===================================================================
//===================================================================

//===================================================================
//===================================================================
//===================================================================

char *single_statusbar =
"yb  -24 "

// health
"xv  0 "
"hnum "
"xv  50 "
"pic 0 "

// ammo
"if 2 "
"  xv  100 "
"  anum "
"  xv  150 "
"  pic 2 "
"endif "

// armor
"if 4 "
"  xv  200 "
"  rnum "
"  xv  250 "
"  pic 4 "
"endif "

// selected item
"if 6 "
"  xv  296 "
"  pic 6 "
"endif "

"yb  -50 "

// picked up item
"if 7 "
"  xv  0 "
"  pic 7 "
"  xv  26 "
"  yb  -42 "
"  stat_string 8 "
"  yb  -50 "
"endif "

// timer
"if 9 "
"  xv  262 "
"  num  3  10 " // Fieldwidth=3
"  xv  296 "
"  pic  9 "
"endif "

//  help/weapon icon
"if 11 "
"  xv  148 "
"  pic  11 "
"endif "
;

char *dm_statusbar =
"yb  -24 "

// health
"xv  0 "
"hnum "
"xv  50 "
"pic 0 "

// ammo
"if 2 "
"  xv  100 "
"  anum "
"  xv  150 "
"  pic 2 "
"endif "

// armor
"if 4 "
"  xv  200 "
"  rnum "
"  xv  250 "
"  pic 4 "
"endif "

// selected item
"if 6 "
"  xv  296 "
"  pic 6 "
"endif "

"yb  -50 "

// picked up item
"if 7 "
"  xv  0 "
"  pic 7 "
"  xv  26 "
"  yb  -42 "
"  stat_string 8 "
"  yb  -50 "
"endif "

// timer
"if 9 "
"  xv  246 "
"  num  3  10 " // Fieldwidth=3
"  xv  296 "
"  pic  9 "
"endif "

//  help/weapon icon
"if 11 "
"  xv  148 "
"  pic  11 "
"endif "

//  frags
"xr  -50 "
"yt 2 "
"num 3 14 "

// spectator
"if 17 "
  "xv 0 "
  "yb -58 "
  "string2 \"SPECTATOR MODE\" "
"endif "

// chase camera
"if 16 "
  "xv 0 "
  "yb -68 "
  "string \"Chasing\" "
  "xv 64 "
  "stat_string 16 "
"endif "
;

//===================================================================
//===================================================================
//===================================================================

/*QUAKED worldspawn(0 0 0) ?

Only used for the world.
"sky"  environment map name
"skyaxis"  vector axis for rotating sky
"skyrotate"  speed of rotation in degrees/second
"sounds"  music cd track number
"gravity"  800 is default gravity
"message"  text to print at user logon
*/

//============================================================
void SP_worldspawn(edict_t *ent) {

  ent->movetype=MOVETYPE_PUSH;
  ent->solid=SOLID_BSP;
  ent->inuse=true;      // since the world doesn't use G_Spawn()
  ent->s.modelindex=1;    // world model is always index 1

  //---------------

  // reserve some spots for dead player bodies
  InitBodyQue();

  // set configstrings for items
  SetItemNames();

  if (st.nextmap)
    strcpy(level.nextmap, st.nextmap);

  // make some data visible to the server

  if (ent->message && ent->message[0]) {
    gi.configstring(CS_NAME, ent->message);
    strncpy(level.level_name, ent->message, sizeof(level.level_name)); }
  else
    strncpy(level.level_name, level.mapname, sizeof(level.level_name));

  if (st.sky && st.sky[0])
    gi.configstring(CS_SKY, st.sky);
  else
    gi.configstring(CS_SKY, "unit1_");

  gi.configstring(CS_SKYROTATE, va("%f", st.skyrotate));

  gi.configstring(CS_SKYAXIS, va("%f %f %f", st.skyaxis[0], st.skyaxis[1], st.skyaxis[2]));

  gi.configstring(CS_CDTRACK, va("%i", ent->sounds));

  gi.configstring(CS_MAXCLIENTS, va("%i",(int)(maxclients->value)));

  // status bar program
  if (CVAR_DEATHMATCH)
    gi.configstring(CS_STATUSBAR, dm_statusbar);
  else
    gi.configstring(CS_STATUSBAR, single_statusbar);

  //---------------

  // help icon for statusbar
  gi.imageindex("i_help");
  level.pic_health=gi.imageindex("i_health");
  gi.imageindex("help");
  gi.imageindex("field_3");

  if (!st.gravity)
    gi.cvar_set("sv_gravity", "800");
  else
    gi.cvar_set("sv_gravity", st.gravity);

  snd_fry=gi.soundindex("player/fry.wav");  // standing in lava/slime

  PrecacheItem(item_blaster);

  gi.soundindex("player/lava1.wav");
  gi.soundindex("player/lava2.wav");

  gi.soundindex("misc/pc_up.wav");
  gi.soundindex("misc/talk1.wav");

  gi.soundindex("misc/udeath.wav");

  // gibs
  gi.soundindex("items/respawn1.wav");

  // sexed sounds
  gi.soundindex("*death1.wav");
  gi.soundindex("*death2.wav");
  gi.soundindex("*death3.wav");
  gi.soundindex("*death4.wav");
  gi.soundindex("*fall1.wav");
  gi.soundindex("*fall2.wav");
  gi.soundindex("*gurp1.wav");    // drowning damage
  gi.soundindex("*gurp2.wav");
  gi.soundindex("*jump1.wav");    // player jump
  gi.soundindex("*pain25_1.wav");
  gi.soundindex("*pain25_2.wav");
  gi.soundindex("*pain50_1.wav");
  gi.soundindex("*pain50_2.wav");
  gi.soundindex("*pain75_1.wav");
  gi.soundindex("*pain75_2.wav");
  gi.soundindex("*pain100_1.wav");
  gi.soundindex("*pain100_2.wav");

  // sexed models
  // THIS ORDER MUST MATCH THE DEFINES IN g_local.h
  // you can add more, max 15
  gi.modelindex("#w_blaster.md2");
  gi.modelindex("#w_shotgun.md2");
  gi.modelindex("#w_sshotgun.md2");
  gi.modelindex("#w_machinegun.md2");
  gi.modelindex("#w_chaingun.md2");
  gi.modelindex("#a_grenades.md2");
  gi.modelindex("#w_glauncher.md2");
  gi.modelindex("#w_rlauncher.md2");
  gi.modelindex("#w_hyperblaster.md2");
  gi.modelindex("#w_railgun.md2");
  gi.modelindex("#w_bfg.md2");

  //-------------------

  gi.soundindex("player/gasp1.wav");    // gasping for air
  gi.soundindex("player/gasp2.wav");    // head breaking surface, not gasping

  gi.soundindex("player/watr_in.wav");  // feet hitting water
  gi.soundindex("player/watr_out.wav"); // feet leaving water

  gi.soundindex("player/watr_un.wav");  // head going underwater

  gi.soundindex("player/u_breath1.wav");
  gi.soundindex("player/u_breath2.wav");

  gi.soundindex("items/pkup.wav");    // bonus item pickup
  gi.soundindex("world/land.wav");    // landing thud
  gi.soundindex("misc/h2ohit1.wav");  // landing splash

  gi.soundindex("items/damage.wav");
  gi.soundindex("items/protect.wav");
  gi.soundindex("items/protect4.wav");
  gi.soundindex("weapons/noammo.wav");

  gi.soundindex("infantry/inflies1.wav");

  sm_meat_index=gi.modelindex("models/objects/gibs/sm_meat/tris.md2");
  gi.modelindex("models/objects/gibs/arm/tris.md2");
  gi.modelindex("models/objects/gibs/bone/tris.md2");
  gi.modelindex("models/objects/gibs/bone2/tris.md2");
  gi.modelindex("models/objects/gibs/chest/tris.md2");
  gi.modelindex("models/objects/gibs/skull/tris.md2");
  gi.modelindex("models/objects/gibs/head2/tris.md2");

//
// Setup light animation tables. 'a' is total darkness, 'z' is doublebright.
//

  // 0 normal
  gi.configstring(CS_LIGHTS+0, "m");

  // 1 FLICKER(first variety)
  gi.configstring(CS_LIGHTS+1, "mmnmmommommnonmmonqnmmo");

  // 2 SLOW STRONG PULSE
  gi.configstring(CS_LIGHTS+2, "abcdefghijklmnopqrstuvwxyzyxwvutsrqponmlkjihgfedcba");

  // 3 CANDLE(first variety)
  gi.configstring(CS_LIGHTS+3, "mmmmmaaaaammmmmaaaaaabcdefgabcdefg");

  // 4 FAST STROBE
  gi.configstring(CS_LIGHTS+4, "mamamamamama");

  // 5 GENTLE PULSE 1
  gi.configstring(CS_LIGHTS+5,"jklmnopqrstuvwxyzyxwvutsrqponmlkj");

  // 6 FLICKER(second variety)
  gi.configstring(CS_LIGHTS+6, "nmonqnmomnmomomno");

  // 7 CANDLE(second variety)
  gi.configstring(CS_LIGHTS+7, "mmmaaaabcdefgmmmmaaaammmaamm");

  // 8 CANDLE(third variety)
  gi.configstring(CS_LIGHTS+8, "mmmaaammmaaammmabcdefaaaammmmabcdefmmmaaaa");

  // 9 SLOW STROBE(fourth variety)
  gi.configstring(CS_LIGHTS+9, "aaaaaaaazzzzzzzz");

  // 10 FLUORESCENT FLICKER
  gi.configstring(CS_LIGHTS+10, "mmamammmmammamamaaamammma");

  // 11 SLOW PULSE NOT FADE TO BLACK
  gi.configstring(CS_LIGHTS+11, "abcdefghijklmnopqrrqponmlkjihgfedcba");

  // styles 32-62 are assigned by the light program for switchable lights

  // 63 testing
  gi.configstring(CS_LIGHTS+63, "a");
}


//=========================================================
float PlayersRangeFromSpot(edict_t *spot){
edict_t *player;
float bestplayerdistance=9999999;
vec3_t v;
int n;
float playerdistance;

  for (n=1; n<=maxclients->value; n++) {
    player=&g_edicts[n];
    if (!player->inuse) continue;
    if (player->health<=0) continue;
    VectorSubtract(spot->s.origin, player->s.origin, v);
    playerdistance=VectorLength(v);
    if (playerdistance < bestplayerdistance)
      bestplayerdistance=playerdistance; }

  return bestplayerdistance;
}

//=========================================================
edict_t *SelectRandomDeathmatchSpawnPoint(void) {
edict_t *spot=NULL, *spot1=NULL, *spot2=NULL;
int count=0, selection;
float range, range1=99999, range2=99999;

  while ((spot=G_Find(spot, FOFS(classname), "info_player_deathmatch")) != NULL) {
    count++;
    range=PlayersRangeFromSpot(spot);
    if (range < range1) {
      range1=range;
      spot1=spot; }
    else if (range < range2) {
      range2=range;
      spot2=spot; } }

  if (!count)
    return NULL;

  if (count<=2)
    spot1=spot2=NULL;
  else
    count -= 2;

  selection=rand()%count;

  spot=NULL;
  do {
    spot=G_Find(spot, FOFS(classname), "info_player_deathmatch");
    if (spot == spot1 || spot == spot2)
      selection++;
  } while (selection--);

  return spot;
}

//=========================================================
edict_t *SelectFarthestDeathmatchSpawnPoint(void) {
edict_t *bestspot=NULL, *spot=NULL;
float bestdistance=0, bestplayerdistance;

  while ((spot=G_Find(spot, FOFS(classname), "info_player_deathmatch")) != NULL) {
    bestplayerdistance=PlayersRangeFromSpot(spot);
    if (bestplayerdistance > bestdistance) {
      bestspot=spot;
      bestdistance=bestplayerdistance; } }

  if (bestspot) return bestspot;

  // if there is a player just spawned on each and every start spot
  // we have no choice to turn one into a telefrag meltdown
  spot=G_Find(NULL, FOFS(classname), "info_player_deathmatch");

  return spot;
}

//=========================================================
edict_t *SelectDeathmatchSpawnPoint(void) {
  if ((int)(dmflags->value) & DF_SPAWN_FARTHEST)
    return SelectFarthestDeathmatchSpawnPoint();
  else
    return SelectRandomDeathmatchSpawnPoint();
}

//=========================================================
edict_t *SelectCoopSpawnPoint(edict_t *ent) {
int index;
edict_t *spot=NULL;
char *target;

  index=ent->client-ga.clients;

  // player 0 starts in normal player spawn point
  if (!index) return NULL;

  // assume there are four coop spots at each spawnpoint
  while (1) {
    spot=G_Find(spot, FOFS(classname), "info_player_coop");
    if (!spot) return NULL;  // we didn't have enough...
    target=spot->targetname;
    if (!target) target="";
    if (!Q_stricmp(ga.spawnpoint, target)) {
      index--;
      if (!index)
        return spot; } }

  return spot;
}

//=========================================================
void SelectSpawnPoint(edict_t *ent, vec3_t origin, vec3_t angles) {
edict_t *spot=NULL;

  if (CVAR_DEATHMATCH)
    spot=SelectDeathmatchSpawnPoint();
  else if (CVAR_COOP)
    spot=SelectCoopSpawnPoint(ent);

  // find a single player start spot
  if (!spot) {
    while ((spot=G_Find(spot, FOFS(classname), "info_player_start")) != NULL) {
      if (!ga.spawnpoint[0] && !spot->targetname) break;
      if (!ga.spawnpoint[0] || !spot->targetname) continue;
      if (!Q_stricmp(ga.spawnpoint, spot->targetname)) break; }
    if (!spot) {
      if (!ga.spawnpoint[0])
        spot=G_Find(spot, FOFS(classname), "info_player_start");
      if (!spot)
        gi.error(ERR_FATAL,"Couldn't find spawn point %s\n", ga.spawnpoint); } }

  VectorCopy(spot->s.origin, origin);
  origin[2] += 9;
  VectorCopy(spot->s.angles, angles);
}

//=========================================================
// New Death Sequence Routine-called only from body_die()
//=========================================================
void Throw_Body_Parts_Everywhere(edict_t *victim, int damage) {
int n;

    // Throw Gib debris everywhere..
    for (n=0; n<2; n++) // throw 2 misc bones
      ThrowGib(victim, GIB_BONE_MODEL, damage, GIB_ORGANIC);
    for (n=0; n<1; n++) // throw 1 skull
      ThrowGib(victim, GIB_SKULL_MODEL, damage, GIB_ORGANIC);
    for (n=0; n<2; n++) // throw 2 meat chunks
      ThrowGib(victim, GIB_SM_MEAT_MODEL, damage, GIB_ORGANIC);
    for (n=0; n<2; n++) // throw 2 arms
      ThrowGib(victim, GIB_ARM_MODEL, damage, GIB_ORGANIC);
    for (n=0; n<1; n++) // throw a chest too!
      ThrowGib(victim, GIB_CHEST_MODEL, damage, GIB_ORGANIC);
    for (n=0; n<2; n++) // throw 2 legs
      ThrowGib(victim, GIB_LEG_MODEL, damage, GIB_ORGANIC);
    for (n=0; n<2; n++) // throw 2 more meat chunks
      ThrowGib(victim, GIB_SM_MEAT_MODEL, damage, GIB_ORGANIC);
    for (n=0; n<4; n++) // throw 4 more bones
      ThrowGib(victim, GIB_BONE2_MODEL, damage, GIB_ORGANIC);
}

//==============================================================
// Destroy the body (deadbody hit by bfg, railgun, rocket, etc.)
//==============================================================
void body_die(edict_t *victim, edict_t *weapon, edict_t *attacker, int damage, vec3_t point){
int n;

  // Check to see if player had extreme death
  if (victim->health < -15) {
    // make the player scream...
    gi.sound(victim, CHAN_BODY, gi.soundindex("misc/udeath.wav"), 1, ATTN_NORM, 0);
    // if very extreme death, completely splatter the Player
    if (victim->health < -50) // splatter..
      for (n=0; n<=3; n++) // throw 4 meat chunks w/blood..
        ThrowGib(victim,GIB_SM_MEAT_MODEL,damage,GIB_ORGANIC);
    else
      // else throw exploding body parts everywhere..
      Throw_Body_Parts_Everywhere(victim, damage);

    victim->s.origin[2] -= 48;
    ThrowClientHead(victim, damage);
    victim->takedamage=DAMAGE_NO; }
}

//=========================================================
void CopyToBodyQue(edict_t *ent) {
edict_t *body;

  // grab a body que and cycle to the next one
  body=&g_edicts[(int)maxclients->value+level.body_que+1];
  level.body_que = (level.body_que+1)%BODY_QUEUE_SIZE;

  gi.unlinkentity(ent);
  gi.unlinkentity(body);

  body->s=ent->s;
  body->s.number=body-g_edicts;
  body->svflags=ent->svflags;
  VectorCopy(ent->mins, body->mins);
  VectorCopy(ent->maxs, body->maxs);
  VectorCopy(ent->absmin, body->absmin);
  VectorCopy(ent->absmax, body->absmax);
  VectorCopy(ent->size, body->size);
  body->solid=ent->solid;
  body->clipmask=ent->clipmask;
  body->owner=ent->owner;
  body->movetype=ent->movetype;
  body->die=body_die;
  body->takedamage=DAMAGE_YES;

  gi.linkentity(body);
}

//=========================================================
void respawn(edict_t *self) {

  if (CVAR_DEATHMATCH || CVAR_COOP) {
    // spectator's don't leave bodies
    if (self->movetype != MOVETYPE_NOCLIP)
      CopyToBodyQue(self);
    self->svflags &= ~SVF_NOCLIENT;
    PutClientInServer(self);
    // add a teleportation effect
    self->s.event=EV_PLAYER_TELEPORT;
    // hold in place briefly
    self->client->ps.pmove.pm_flags=PMF_TIME_TELEPORT;
    self->client->ps.pmove.pm_time=14;
    self->client->respawn_time=level.time;
    return; }

  // restart the entire server
  gi.AddCommandString("menu_loadgame\n");
}

//=========================================================
void spectator_respawn(edict_t *ent) {
int i, numspec;
char *value;

  // if the user wants to become a spectator, make sure he doesn't
  // exceed max_spectators

  if (ent->client->pers.spectator) {
    value=Info_ValueForKey(ent->client->pers.userinfo, "spectator");
    if (*spectator_password->string &&
      Q_stricmp(spectator_password->string, "none") &&
      Q_stricmp(spectator_password->string, value)) {
      gi_cprintf(ent, PRINT_HIGH, "Spectator password incorrect.\n");
      ent->client->pers.spectator=false;
      G_StuffText(ent, "spectator 0\n", true);
      return; }

    // count spectators
    for (i=1, numspec=0; i<=maxclients->value; i++)
      if (g_edicts[i].inuse && g_edicts[i].client->pers.spectator)
        numspec++;

    if (numspec >= maxspectators->value) {
      gi_cprintf(ent, PRINT_HIGH, "Server spectator limit is full.");
      ent->client->pers.spectator=false;
      // reset his spectator var
      G_StuffText(ent, "spectator 0\n", true);
      return; } }
  else {
    // he was a spectator and wants to join the game
    // he must have the right password
    char *value=Info_ValueForKey(ent->client->pers.userinfo, "password");
    if (*password->string && Q_stricmp(password->string, "none") && Q_stricmp(password->string, value)) {
      gi_cprintf(ent, PRINT_HIGH, "Password incorrect.\n");
      ent->client->pers.spectator=true;
      G_StuffText(ent, "spectator 1\n", true);
      return; } }

  // clear client on respawn
  ent->client->resp.score=ent->client->pers.score=0;

  ent->svflags &= ~SVF_NOCLIENT;
  PutClientInServer(ent);

  // add a teleportation effect
  if (!ent->client->pers.spectator)  {
    G_MuzzleFlash((short)(ent-g_edicts), ent->s.origin, (int)MZ_LOGIN);
    ent->client->ps.pmove.pm_flags=PMF_TIME_TELEPORT;
    ent->client->ps.pmove.pm_time=14; }

  ent->client->respawn_time=level.time;

  if (ent->client->pers.spectator)
    gi_bprintf(PRINT_HIGH, "%s has moved to the sidelines\n", ent->client->pers.netname);
  else
    gi_bprintf(PRINT_HIGH, "%s joined the game\n", ent->client->pers.netname);
}

//======================================================
//============= HELPER FUNCTIONS HERE ==================
//======================================================

/* Don't know where (if anyplace) these go!
  TE_FLAME,
  TE_LIGHTNING,
  TE_FLASHLIGHT,
  TE_FORCEWALL,
  TE_HEATBEAM,
  TE_MONSTER_HEATBEAM,
  TE_STEAM,
  TE_HEATBEAM_STEAM,
  TE_TELEPORT_EFFECT,
  TE_DBALL_GOAL,
  TE_WIDOWBEAMOUT,
  TE_FLECHETTE
*/

//======================================================
//========== Spawn Temp Entity Functions ===============
//======================================================
/*
   Spawns (type) Splash with {count} particles of (color) at (start) moving
   in (direction) and Broadcast to all in Potentially Visible Set from
   vector (origin)

   TE_LASER_SPARKS-Splash particles obey gravity
   TE_WELDING_SPARKS-Splash particles with flash of light at {origin}
   TE_SPLASH-Randomly shaded shower of particles
   TE_WIDOWSPLASH-New to v3.20
*/
//======================================================
void G_Spawn_Splash(int type, int count, int color, vec3_t start, vec3_t movdir, vec3_t origin) {
  gi.WriteByte(svc_temp_entity);
  gi.WriteByte(type);
  gi.WriteByte(count);
  gi.WritePosition(start);
  gi.WriteDir(movdir);
  gi.WriteByte(color);
  gi.multicast(origin, MULTICAST_PVS);
}

//======================================================
//======================================================
//======================================================
/*
  Spawns a string of successive (type) models of from record (rec_no)
  from (start) to (endpos) which are offset by vector (offset) and
  Broadcasts to all in Potentially Visible Set from vector (origin)

Type:
     TE_GRAPPLE_CABLE-The grappling hook cable (NOT IN 3.19!)
     TE_MEDIC_CABLE_ATTACK-NOT IMPLEMENTED IN ENGINE
     TE_PARASITE_ATTACK-NOT IMPLEMENTED IN ENGINE
*/
//======================================================
void G_Spawn_Models(int type, short rec_no, vec3_t start, vec3_t endpos, vec3_t offset, vec3_t origin) {
  gi.WriteByte(svc_temp_entity);
  gi.WriteByte(type);
  gi.WriteShort(rec_no);
  gi.WritePosition(start);
  gi.WritePosition(endpos);
  gi.WritePosition(offset);
  gi.multicast(origin, MULTICAST_PVS);
}

//======================================================
//======================================================
//======================================================
/*
 Spawns a trail of (type) from (start) to (end) and Broadcasts to all
 in Potentially Visible Set from vector (origin)

     TE_BFG_LASER-Spawns a green laser
     TE_BUBBLETRAIL-Spawns a trail of bubbles
     TE_BUBBLETRAIL2-NOT IMPLEMENTED IN ENGINE
     TE_PLASMATRAIL-NOT IMPLEMENTED IN ENGINE
     TE_RAILTRAIL-Spawns a blue spiral trail filled with white smoke
     TE_RAILTRAIL2-NOT IMPLEMENTED IN ENGINE
     TE_DEBUGTRAIL-New to v3.20
*/
//======================================================
void G_Spawn_Trails(int type, vec3_t start, vec3_t endpos, vec3_t origin) {
  gi.WriteByte(svc_temp_entity);
  gi.WriteByte(type);
  gi.WritePosition(start);
  gi.WritePosition(endpos);
  gi.multicast(origin, MULTICAST_PVS);
}

//======================================================
//======================================================
//======================================================
/*
 Spawns sparks of (type) from (start) in direction of (movdir) and
 Broadcasts to all in Potentially Visible Set from vector (origin)

     TE_BLASTER-Spawns a blaster sparks
     TE_BLOOD-Spawns a spurt of red blood
     TE_BULLET_SPARKS-Same as TE_SPARKS, with a bullet puff and richochet sound
     TE_GREENBLOOD-NOT IMPLEMENTED-Spawns a spurt of green blood
     TE_GUNSHOT-Spawns a grey splash of particles, with a bullet puff
     TE_SCREEN_SPARKS-Spawns a large green/white splash of sparks
     TE_SHIELD_SPARKS-Spawns a large blue/violet splash of sparks
     TE_SHOTGUN-Spawns a small grey splash of spark particles, with a bullet puff
     TE_SPARKS-Spawns a red/gold splash of spark particles
     TE_BLASTER2-New to v3.20
     TE_MOREBLOOD-New to v3.20
     TE_CHAINFIST_SMOKE-New to v3.20
     TE_TUNNEL_SPARKS-New to v3.20
     TE_ELECTRIC_SPARKS-New to v3.20
     TE_HEATBEAM_SPARKS-New to v3.20
     TE_BLUEHYPERBLASTER-New to v3.20
*/
//======================================================
void G_Spawn_Sparks(int type, vec3_t start, vec3_t movdir, vec3_t origin) {
  gi.WriteByte(svc_temp_entity);
  gi.WriteByte(type);
  gi.WritePosition(start);
  gi.WriteDir(movdir);
  gi.multicast(origin, MULTICAST_PVS);
}

//======================================================
//======================================================
//======================================================
/*
 Spawns a (type) explosion at (start} and Broadcasts to all in the
 Potentially Hearable set from vector (origin)

     TE_BFG_BIGEXPLOSION-Spawns a BFG particle explosion
     TE_BFG_EXPLOSION-Spawns a BFG explosion sprite
     TE_BOSSTPORT-Spawns a mushroom-cloud particle effect
     TE_EXPLOSION1-Spawns a mid-air-style explosion
     TE_EXPLOSION2-Spawns a nuclear-style explosion
     TE_GRENADE_EXPLOSION-Spawns a grenade explosion
     TE_GRENADE_EXPLOSION_WATER-Spawns an underwater grenade explosion
     TE_ROCKET_EXPLOSION-Spawns a rocket explosion
     TE_ROCKET_EXPLOSION_WATER-Spawns an underwater rocket explosion
     TE_NUKEBLAST-New to v3.20
     TE_EXPLOSION1_BIG-New to v3.20
     TE_EXPLOSION1_NP-New to v3.20
     TE_PLAIN_EXPLOSION-New to v3.20
     TE_PLASMA_EXPLOSION-New to v3.20
     TE_TRACKER_EXPLOSION-New to v3.20
*/
//======================================================
void G_Spawn_Explosion(int type, vec3_t start, vec3_t origin) {
  gi.WriteByte(svc_temp_entity);
  gi.WriteByte(type);
  gi.WritePosition(start);
  gi.multicast(origin, MULTICAST_PHS);
}

//======================================================
/*
G_Spawn_Steam-create some nice steamy particles.
Cut from the Rogue source.
speed = velocity of particles (default 50)
count = number of particles (default 32)
color = color of particles (default 8 for steam)
    the color range is from this color to this color + 6
origin = duh.
movedir = probably a plane.normal, but you can give it whatever =)
good colors to use:
6-9-varying whites (darker to brighter)
224-sparks
176-blue water
80 -brown water
208-slime
232-blood
*/
//======================================================
void G_Spawn_Steam(int count, vec3_t origin, vec3_t movedir, int color, int speed){
  gi.WriteByte(svc_temp_entity);
  gi.WriteByte(TE_STEAM);
  gi.WriteShort((short int)-1);
  gi.WriteByte(count);
  gi.WritePosition(origin);
  gi.WriteDir(movedir);
  gi.WriteByte(color&0xff);
  gi.WriteShort((short int)(speed));
  gi.multicast(origin, MULTICAST_PVS);
}

//======================================================
// Display Muzzleflash of type 'flashtype' at vector start.
//======================================================
void G_MuzzleFlash(short rec_no, vec3_t start, int flashtype) {
  gi.WriteByte(svc_muzzleflash);
  gi.WriteShort(rec_no);
  gi.WriteByte(flashtype);
  gi.multicast(start, MULTICAST_PVS);
}

//======================================================
// Muzzleflash2 of type flashtype (Monster Fire weapons)
//======================================================
void G_MuzzleFlash2(short rec_no, vec3_t start, int flashtype) {
  gi.WriteByte(svc_muzzleflash2);
  gi.WriteShort(rec_no);
  gi.WriteByte(flashtype);
  gi.multicast(start, MULTICAST_PVS);
}

//======================================================
// Stuff the String command to client's console..
//======================================================
void G_StuffText(edict_t *ent, char *str, qboolean unicast) {
  gi.WriteByte(svc_stufftext);
  gi.WriteString(str);
  gi.unicast(ent,unicast);
}

//======================================================
// Writes the client's inventory to the HUD
//======================================================
void G_WriteInventory(edict_t *ent) {
int i;
  gi.WriteByte(svc_inventory);
  for (i=0; i<MAX_ITEMS; i++)
    gi.WriteShort(ent->client->pers.inventory[i]);
  gi.unicast(ent,true);
}

//======================================================
// Writes the specified string to client's HUD
//======================================================
void G_WriteLayout(edict_t *ent, char *str) {
  gi.WriteByte(svc_layout);
  gi.WriteString(str);
  gi.unicast(ent,true);
}


