#include "defines.h"

#define Function(f) {#f, f}

mmove_t mmove_reloc;

field_t fields[]={
  {"classname", FOFS(classname), F_LSTRING},
  {"model", FOFS(model), F_LSTRING},
  {"spawnflags", FOFS(spawnflags), F_INT},
  {"speed", FOFS(speed), F_FLOAT},
  {"accel", FOFS(accel), F_FLOAT},
  {"decel", FOFS(decel), F_FLOAT},
  {"target", FOFS(target), F_LSTRING},
  {"targetname", FOFS(targetname), F_LSTRING},
  {"pathtarget", FOFS(pathtarget), F_LSTRING},
  {"deathtarget", FOFS(deathtarget), F_LSTRING},
  {"killtarget", FOFS(killtarget), F_LSTRING},
  {"combattarget", FOFS(combattarget), F_LSTRING},
  {"message", FOFS(message), F_LSTRING},
  {"team", FOFS(team), F_LSTRING},
  {"wait", FOFS(wait), F_FLOAT},
  {"delay", FOFS(delay), F_FLOAT},
  {"random", FOFS(random), F_FLOAT},
  {"move_origin", FOFS(move_origin), F_VECTOR},
  {"move_angles", FOFS(move_angles), F_VECTOR},
  {"style", FOFS(style), F_INT},
  {"count", FOFS(count), F_INT},
  {"health", FOFS(health), F_INT},
  {"sounds", FOFS(sounds), F_INT},
  {"light", 0, F_IGNORE},
  {"dmg", FOFS(dmg), F_INT},
  {"mass", FOFS(mass), F_INT},
  {"volume", FOFS(volume), F_FLOAT},
  {"attenuation", FOFS(attenuation), F_FLOAT},
  {"map", FOFS(map), F_LSTRING},
  {"origin", FOFS(s.origin), F_VECTOR},
  {"angles", FOFS(s.angles), F_VECTOR},
  {"angle", FOFS(s.angles), F_ANGLEHACK},

  {"goalentity", FOFS(goalentity), F_EDICT, FFL_NOSPAWN},
  {"movetarget", FOFS(movetarget), F_EDICT, FFL_NOSPAWN},
  {"enemy", FOFS(enemy), F_EDICT, FFL_NOSPAWN},
  {"oldenemy", FOFS(oldenemy), F_EDICT, FFL_NOSPAWN},
  {"activator", FOFS(activator), F_EDICT, FFL_NOSPAWN},
  {"groundentity", FOFS(groundentity), F_EDICT, FFL_NOSPAWN},
  {"teamchain", FOFS(teamchain), F_EDICT, FFL_NOSPAWN},
  {"teammaster", FOFS(teammaster), F_EDICT, FFL_NOSPAWN},
  {"owner", FOFS(owner), F_EDICT, FFL_NOSPAWN},
  {"mynoise", FOFS(mynoise), F_EDICT, FFL_NOSPAWN},
  {"mynoise2", FOFS(mynoise2), F_EDICT, FFL_NOSPAWN},
  {"target_ent", FOFS(target_ent), F_EDICT, FFL_NOSPAWN},
  {"chain", FOFS(chain), F_EDICT, FFL_NOSPAWN},

  {"prethink", FOFS(prethink), F_FUNCTION, FFL_NOSPAWN},
  {"think", FOFS(think), F_FUNCTION, FFL_NOSPAWN},
  {"blocked", FOFS(blocked), F_FUNCTION, FFL_NOSPAWN},
  {"touch", FOFS(touch), F_FUNCTION, FFL_NOSPAWN},
  {"use", FOFS(use), F_FUNCTION, FFL_NOSPAWN},
  {"pain", FOFS(pain), F_FUNCTION, FFL_NOSPAWN},
  {"die", FOFS(die), F_FUNCTION, FFL_NOSPAWN},

  {"stand", FOFS(monsterinfo.stand), F_FUNCTION, FFL_NOSPAWN},
  {"idle", FOFS(monsterinfo.idle), F_FUNCTION, FFL_NOSPAWN},
  {"search", FOFS(monsterinfo.search), F_FUNCTION, FFL_NOSPAWN},
  {"walk", FOFS(monsterinfo.walk), F_FUNCTION, FFL_NOSPAWN},
  {"run", FOFS(monsterinfo.run), F_FUNCTION, FFL_NOSPAWN},
  {"dodge", FOFS(monsterinfo.dodge), F_FUNCTION, FFL_NOSPAWN},
  {"attack", FOFS(monsterinfo.attack), F_FUNCTION, FFL_NOSPAWN},
  {"melee", FOFS(monsterinfo.melee), F_FUNCTION, FFL_NOSPAWN},
  {"sight", FOFS(monsterinfo.sight), F_FUNCTION, FFL_NOSPAWN},
  {"checkattack", FOFS(monsterinfo.checkattack), F_FUNCTION, FFL_NOSPAWN},
  {"currentmove", FOFS(monsterinfo.currentmove), F_MMOVE, FFL_NOSPAWN},

  {"endfunc", FOFS(moveinfo.endfunc), F_FUNCTION, FFL_NOSPAWN},

  // temp spawn vars -- only valid when the spawn function is called
  {"lip", STOFS(lip), F_INT, FFL_SPAWNTEMP},
  {"distance", STOFS(distance), F_INT, FFL_SPAWNTEMP},
  {"height", STOFS(height), F_INT, FFL_SPAWNTEMP},
  {"noise", STOFS(noise), F_LSTRING, FFL_SPAWNTEMP},
  {"pausetime", STOFS(pausetime), F_FLOAT, FFL_SPAWNTEMP},
  {"item", STOFS(item), F_LSTRING, FFL_SPAWNTEMP},

//need for item field in edict struct, FFL_SPAWNTEMP item will be skipped on saves
  {"item", FOFS(item), F_ITEM},

  {"gravity", STOFS(gravity), F_LSTRING, FFL_SPAWNTEMP},
  {"sky", STOFS(sky), F_LSTRING, FFL_SPAWNTEMP},
  {"skyrotate", STOFS(skyrotate), F_FLOAT, FFL_SPAWNTEMP},
  {"skyaxis", STOFS(skyaxis), F_VECTOR, FFL_SPAWNTEMP},
  {"minyaw", STOFS(minyaw), F_FLOAT, FFL_SPAWNTEMP},
  {"maxyaw", STOFS(maxyaw), F_FLOAT, FFL_SPAWNTEMP},
  {"minpitch", STOFS(minpitch), F_FLOAT, FFL_SPAWNTEMP},
  {"maxpitch", STOFS(maxpitch), F_FLOAT, FFL_SPAWNTEMP},
  {"nextmap", STOFS(nextmap), F_LSTRING, FFL_SPAWNTEMP},

  {0, 0, 0, 0}

};

field_t levelfields[] =
{
  {"changemap", LLOFS(changemap), F_LSTRING},

  {"sight_client", LLOFS(sight_client), F_EDICT},
  {"sight_entity", LLOFS(sight_entity), F_EDICT},
  {"sound_entity", LLOFS(sound_entity), F_EDICT},
  {"sound2_entity", LLOFS(sound2_entity), F_EDICT},

  {NULL, 0, F_INT}
};

field_t clientfields[] =
{
  {"pers.weapon", CLOFS(pers.weapon), F_ITEM},
  {"pers.lastweapon", CLOFS(pers.lastweapon), F_ITEM},
  {"newweapon", CLOFS(newweapon), F_ITEM},

  {NULL, 0, F_INT}
};

//============================================================
//============================================================
//============================================================

//============================================================
void InitGame(void) {

  srand(time(NULL));

  MonstersInUse=false;

  gi.dprintf("==== InitGame ====\n");

  gun_x=gi.cvar("gun_x", "0", 0);
  gun_y=gi.cvar("gun_y", "0", 0);
  gun_z=gi.cvar("gun_z", "0", 0);

  sv_rollspeed=gi.cvar("sv_rollspeed", "200", 0);
  sv_rollangle=gi.cvar("sv_rollangle", "2", 0);
  sv_maxvelocity=gi.cvar("sv_maxvelocity", "2000", 0);
  sv_gravity=gi.cvar("sv_gravity", "800", 0);

  // noset vars
  dedicated=gi.cvar("dedicated", "0", CVAR_NOSET);

  // latched vars
  sv_cheats=gi.cvar("cheats", "0", CVAR_SERVERINFO|CVAR_LATCH);
  gi.cvar("gamename", GAMEVERSION , CVAR_SERVERINFO|CVAR_LATCH);
  gi.cvar("gamedate", __DATE__ , CVAR_SERVERINFO|CVAR_LATCH);

  maxclients=gi.cvar("maxclients", "4", CVAR_SERVERINFO|CVAR_LATCH);
  maxspectators=gi.cvar("maxspectators", "4", CVAR_SERVERINFO);
  sv_bestplayer=gi.cvar("sv_bestplayer","0",CVAR_SERVERINFO);
  deathmatch=gi.cvar("deathmatch", "0", CVAR_LATCH);
  coop=gi.cvar("coop", "0", CVAR_LATCH);
  skill=gi.cvar("skill", "1", CVAR_LATCH);
  maxentities=gi.cvar("maxentities", "1024", CVAR_LATCH);

  // change anytime vars
  dmflags=gi.cvar("dmflags", "0", CVAR_SERVERINFO);
  fraglimit=gi.cvar("fraglimit", "0", CVAR_SERVERINFO);
  timelimit=gi.cvar("timelimit", "0", CVAR_SERVERINFO);
  password=gi.cvar("password", "", CVAR_USERINFO);
  spectator_password=gi.cvar("spectator_password", "", CVAR_USERINFO);
  needpass=gi.cvar("needpass", "0", CVAR_SERVERINFO);
  filterban=gi.cvar("filterban", "1", 0);

  g_select_empty=gi.cvar("g_select_empty", "0", CVAR_ARCHIVE);

  run_pitch=gi.cvar("run_pitch", "0.002", 0);
  run_roll=gi.cvar("run_roll", "0.005", 0);
  bob_up =gi.cvar("bob_up", "0.005", 0);
  bob_pitch=gi.cvar("bob_pitch", "0.002", 0);
  bob_roll=gi.cvar("bob_roll", "0.002", 0);

  // flood control
  flood_msgs=gi.cvar("flood_msgs", "4", 0);
  flood_persecond=gi.cvar("flood_persecond", "4", 0);
  flood_waitdelay=gi.cvar("flood_waitdelay", "10", 0);

  // dm map list
  sv_maplist=gi.cvar("sv_maplist", "", 0);

  // items
  InitItems();

  Com_sprintf(ga.helpmessage1, sizeof(ga.helpmessage1), "");

  Com_sprintf(ga.helpmessage2, sizeof(ga.helpmessage2), "");

  // initialize all entities for this game
  ga.maxentities=maxentities->value;
  g_edicts= gi.TagMalloc(ga.maxentities*sizeof(g_edicts[0]), TAG_GAME);
  ge.edicts=g_edicts;
  ge.max_edicts=ga.maxentities;

  // initialize all clients for this game
  ga.maxclients=maxclients->value;
  ga.clients=gi.TagMalloc(ga.maxclients*sizeof(ga.clients[0]), TAG_GAME);
  ge.num_edicts=ga.maxclients+1;
}

//=========================================================
void WriteField1(FILE *f, field_t *field, byte *base) {
void *p;

  if (field->flags & FFL_SPAWNTEMP)
    return;

  p = (void *)(base+field->ofs);

  switch (field->type) {
  case F_LSTRING:
  case F_GSTRING:
    *(int *)p=(*(char **)p)?strlen(*(char **)p)+1:0;
    break;

  case F_EDICT:
    *(int *)p=(*(edict_t **)p==((void *)0))?-1:*(edict_t **)p-g_edicts;
    break;

  case F_CLIENT:
    *(int *)p=(*(gclient_t **)p==((void *)0))?-1:*(gclient_t **)p-ga.clients;
    break;

  case F_ITEM:
    *(int *)p=(*(edict_t **)p==((void *)0))?-1:*(gitem_t **)p-itemlist;
    break;

  case F_FUNCTION:
    *(int *)p=(*(byte **)p==((void *)0))?0:*(byte **)p-((byte *)(void *)InitGame);
    break;

  case F_MMOVE:
    *(int *)p=(*(byte **)p==((void *)0))?0:*(byte **)p-(byte *)&mmove_reloc;
    break;

  default: break;
  } // end switch
}

//============================================================
void WriteField2(FILE *f, field_t *field, byte *base) {
void *p;

  if (field->flags & FFL_SPAWNTEMP)
    return;

  p = (void *)(base+field->ofs);

  if (field->type==F_LSTRING && (*(char **)p))
    fwrite(*(char **)p, (int)(strlen(*(char **)p)+1), 1, f);
}

//============================================================
void ReadField(FILE *f, field_t *field, byte *base) {
void *p;
int len, index;

  if (field->flags & FFL_SPAWNTEMP)
    return;

  p = (void *)(base+field->ofs);

  switch (field->type) {

  case F_LSTRING:
    len=*(int *)p;
    *(char **)p=(!len)?((void *)0):gi.TagMalloc(len, TAG_LEVEL);
    if (len)
      fread(*(char **)p, len, 1, f);
    break;

  case F_EDICT:
    index=*(int *)p;
    *(edict_t **)p=(index == -1)?((void *)0):&g_edicts[index];
    break;

  case F_CLIENT:
    index=*(int *)p;
    *(gclient_t **)p=(index == -1)?((void *)0):&ga.clients[index];
    break;

  case F_ITEM:
    index=*(int *)p;
    *(gitem_t **)p=(index == -1)?((void *)0):&itemlist[index];
    break;

  case F_FUNCTION:
    index=*(int *)p;
    *(byte **)p=(index==0)?((void *)0):((byte *)(void *)InitGame)+index;
    break;

  case F_MMOVE:
    index=*(int *)p;
    *(byte **)p=(index==0)?((void *)0):(byte *)&mmove_reloc+index;
    break;

  default: break;
  } // end switch
}

//============================================================
void WriteClient(FILE *f, gclient_t *client) {
field_t *field;
gclient_t temp;

  // all of the ints, floats, and vectors stay as they are
  temp=*client;

  // change the pointers to lengths or indexes
  for (field=clientfields; field->name; field++)
    WriteField1(f, field,(byte *)&temp);

  // write the block
  fwrite(&temp, sizeof(temp), 1, f);

  // now write any allocated data following the edict
  for (field=clientfields; field->name; field++)
    WriteField2(f, field,(byte *)client);
}

//============================================================
void ReadClient(FILE *f, gclient_t *client) {
field_t *field;

  fread(client, sizeof(*client), 1, f);

  for (field=clientfields; field->name; field++)
    ReadField(f, field,(byte *)client);
}

//============================================================
void WriteGame(char *filename, qboolean autosave) {
FILE *f;
int i;
char str[16];

  if (!autosave)
    SaveClientData();

  f=fopen(filename, "wb");
  if (!f)
    gi.error(ERR_FATAL,"Couldn't open %s", filename);

  memset(str, 0, sizeof(str));
  strcpy(str, __DATE__);
  fwrite(str, sizeof(str), 1, f);

  ga.autosaved=autosave;
  fwrite(&ga, sizeof(ga), 1, f);
  ga.autosaved=false;

  for (i=0; i<ga.maxclients; i++)
    WriteClient(f, &ga.clients[i]);

  fclose(f);
}

//============================================================
void ReadGame(char *filename) {
FILE *f;
int i;
char str[16];

  gi.FreeTags(TAG_GAME);

  f=fopen(filename, "rb");
  if (!f)
    gi.error(ERR_FATAL,"Couldn't open %s", filename);

  fread(str, sizeof(str), 1, f);
  if (Q_stricmp(str, __DATE__)) {
    fclose(f);
    gi.error(ERR_FATAL,"Savegame from an older version.\n"); }

  g_edicts= gi.TagMalloc(ga.maxentities*sizeof(g_edicts[0]), TAG_GAME);
  ge.edicts=g_edicts;

  fread(&ga, sizeof(ga), 1, f);
  ga.clients=gi.TagMalloc(ga.maxclients*sizeof(ga.clients[0]), TAG_GAME);
  for (i=0; i<ga.maxclients; i++)
    ReadClient(f, &ga.clients[i]);

  fclose(f);
}

//============================================================
void WriteEdict(FILE *f, edict_t *ent) {
field_t *field;
edict_t temp;

  // all of the ints, floats, and vectors stay as they are
  temp=*ent;

  // change the pointers to lengths or indexes
  for (field=fields; field->name; field++)
    WriteField1(f, field,(byte *)&temp);

  // write the block
  fwrite(&temp, sizeof(temp), 1, f);

  // now write any allocated data following the edict
  for (field=fields; field->name; field++)
    WriteField2(f, field,(byte *)ent);
}

//============================================================
void WriteLevelLocals(FILE *f) {
field_t *field;
level_locals_t temp;

  // all of the ints, floats, and vectors stay as they are
  temp=level;

  // change the pointers to lengths or indexes
  for (field=levelfields; field->name; field++)
    WriteField1(f, field,(byte *)&temp);

  // write the block
  fwrite(&temp, sizeof(temp), 1, f);

  // now write any allocated data following the edict
  for (field=levelfields; field->name; field++)
    WriteField2(f, field,(byte *)&level);
}

//============================================================
void ReadEdict(FILE *f, edict_t *ent) {
field_t *field;

  fread(ent, sizeof(*ent), 1, f);

  for (field=fields; field->name; field++)
    ReadField(f, field,(byte *)ent);
}

//============================================================
void ReadLevelLocals(FILE *f) {
field_t *field;

  fread(&level, sizeof(level), 1, f);

  for (field=levelfields; field->name; field++)
    ReadField(f, field,(byte *)&level);
}

//============================================================
void WriteLevel(char *filename) {
int i;
edict_t *ent;
FILE *f;
void *base;

  f=fopen(filename, "wb");
  if (!f)
    gi.error(ERR_FATAL,"Couldn't open %s", filename);

  // write out edict size for checking
  i=sizeof(edict_t);
  fwrite(&i, sizeof(i), 1, f);

  // write out a function pointer for checking
  base = (void *)InitGame;
  fwrite(&base, sizeof(base), 1, f);

  // write out level_locals_t
  WriteLevelLocals(f);

  // write out all the entities
  for (i=0; i<ge.num_edicts; i++) {
    ent=&g_edicts[i];
    if (!ent->inuse) continue;
    fwrite(&i, sizeof(i), 1, f);
    WriteEdict(f, ent); }
  i= -1;
  fwrite(&i, sizeof(i), 1, f);
  fclose(f);
}

//============================================================
void ReadLevel(char *filename) {
int i, entnum;
FILE *f;
void *base;
edict_t *ent;

  f=fopen(filename, "rb");
  if (!f)
    gi.error(ERR_FATAL,"Couldn't open %s", filename);

  // free any dynamic memory allocated by loading the level
  // base state
  gi.FreeTags(TAG_LEVEL);

  // wipe all the entities
  memset(g_edicts, 0, ga.maxentities*sizeof(g_edicts[0]));
  ge.num_edicts=maxclients->value+1;

  // check edict size
  fread(&i, sizeof(i), 1, f);
  if (i != sizeof(edict_t)) {
    fclose(f);
    gi.error(ERR_FATAL,"ReadLevel: mismatched edict size"); }

  // check function pointer base address
  fread(&base, sizeof(base), 1, f);

#ifdef _WIN32
  if (base != (void *)InitGame) {
    fclose(f);
    gi.error(ERR_FATAL,"ReadLevel: function pointers have moved"); }
#else
  gi.dprintf("Function offsets %d\n",((byte *)base)-((byte *)InitGame));
#endif

  // load the level locals
  ReadLevelLocals(f);

  // load all the entities
  while (1) {
    if (fread(&entnum, sizeof(entnum), 1, f) != 1) {
      fclose(f);
      gi.error(ERR_FATAL,"ReadLevel: failed to read entnum"); }
    if (entnum == -1) break;
    if (entnum >= ge.num_edicts)
      ge.num_edicts=entnum+1;
    ent=&g_edicts[entnum];
    ReadEdict(f, ent);
    // let the server rebuild world links for this ent
    memset(&ent->area, 0, sizeof(ent->area));
    gi.linkentity(ent); }

  fclose(f);

  // mark all clients as unconnected
  for (i=0; i<maxclients->value; i++) {
    ent=&g_edicts[i+1];
    ent->client=ga.clients+i;
    ent->client->pers.connected=false; }

  // do any load time things at this point
  for (i=0; i<ge.num_edicts; i++) {
    ent=&g_edicts[i];
    if (!ent->inuse) continue;
    // fire any cross-level triggers
    if (ent->classname)
      if (!Q_stricmp(ent->classname, "target_crosslevel_target"))
        ent->nextthink=level.time+ent->delay; }
}
