#include "defines.h"

gitem_armor_t jacketarmor_info = { 25, // base_count (amount per item)
                                   50, // max_count (total allowed of this type)
                                  .30, // normal_protection
                                  .00, // energy_protection
                        ARMOR_JACKET };// int armor

gitem_armor_t combatarmor_info = { 50, 100, .60, .30, ARMOR_COMBAT};
gitem_armor_t bodyarmor_info   = {100, 200, .80, .60, ARMOR_BODY};

int jacket_armor_index;
int combat_armor_index;
int body_armor_index;
int power_screen_index;
int power_shield_index;

#define HEALTH_IGNORE_MAX  1

#define HEALTH_TIMED 2

int quad_drop_timeout_hack;

//==========================================================
gitem_t *GetItemByIndex(int index) {
  return (index == 0 || index >= ga.num_items) ? NULL : &itemlist[index];
}

//==========================================================
gitem_t *FindItemByClassname(char *classname) {
int i;
gitem_t *it=itemlist;

  for (i=0; i<ga.num_items; i++, it++) {
    if (!it->classname) continue;
    if (!Q_stricmp(it->classname, classname))
      return it; }

  return NULL;
}

//==========================================================
gitem_t *FindItem(char *pickup_name) {
int i;
gitem_t *it=itemlist;

  for (i=0; i<ga.num_items; i++, it++) {
    if (!it->pickup_name) continue;
    if (!Q_stricmp(it->pickup_name, pickup_name))
      return it; }

  return NULL;
}

//============================================================
void SelectNextItem(edict_t *ent, int itflags) {
int i, index;
gitem_t *it;

  if (ent->client->chase_target) {
    ChaseNext(ent);
    return; }

  // scan for the next valid one
  for (i=1; i<=MAX_ITEMS; i++) {
    index=(ent->client->pers.selected_item+i)%MAX_ITEMS;
    if (!ent->client->pers.inventory[index]) continue;
    it=&itemlist[index];
    if (!it->use) continue;
    if (!(it->flags & itflags)) continue;
    ent->client->pers.selected_item=index;
    return; }

  ent->client->pers.selected_item= -1;
}

//============================================================
void SelectPrevItem(edict_t *ent, int itflags) {
int i, index;
gitem_t *it;

  if (ent->client->chase_target) {
    ChasePrev(ent);
    return; }

  // scan for the next valid one
  for (i=1; i<=MAX_ITEMS; i++) {
    index = (ent->client->pers.selected_item+MAX_ITEMS-i)%MAX_ITEMS;
    if (!ent->client->pers.inventory[index]) continue;
    it=&itemlist[index];
    if (!it->use) continue;
    if (!(it->flags & itflags)) continue;
    ent->client->pers.selected_item=index;
    return; }

  ent->client->pers.selected_item= -1;
}

//============================================================
void ValidateSelectedItem(edict_t *ent) {

  if (ent->client->pers.inventory[ent->client->pers.selected_item])
    return;  // valid

  SelectNextItem(ent, -1);
}

//==========================================================
void Use_Quad(edict_t *ent, gitem_t *item) {
int timeout=300;

  ent->client->pers.inventory[ITEM_INDEX(item)]--;
  ValidateSelectedItem(ent);

  if (quad_drop_timeout_hack) {
    timeout=quad_drop_timeout_hack;
    quad_drop_timeout_hack=0; }

  if (ent->client->quad_framenum > level.framenum)
    ent->client->quad_framenum += timeout;
  else
    ent->client->quad_framenum=level.framenum+timeout;

  gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage.wav"), 1, ATTN_NORM, 0);
}

//==========================================================
void Use_Breather(edict_t *ent, gitem_t *item) {

  ent->client->pers.inventory[ITEM_INDEX(item)]--;
  ValidateSelectedItem(ent);

  if (ent->client->breather_framenum > level.framenum)
    ent->client->breather_framenum += 300;
  else
    ent->client->breather_framenum=level.framenum+300;
}

//==========================================================
//==========================================================
void Use_Envirosuit(edict_t *ent, gitem_t *item) {

  ent->client->pers.inventory[ITEM_INDEX(item)]--;
  ValidateSelectedItem(ent);

  if (ent->client->enviro_framenum > level.framenum)
    ent->client->enviro_framenum += 300;
  else
    ent->client->enviro_framenum=level.framenum+300;
}

//==========================================================
//==========================================================
void Use_Invulnerability(edict_t *ent, gitem_t *item) {

  ent->client->pers.inventory[ITEM_INDEX(item)]--;
  ValidateSelectedItem(ent);

  if (ent->client->invincible_framenum > level.framenum)
    ent->client->invincible_framenum += 300;
  else
    ent->client->invincible_framenum=level.framenum+300;

  gi.sound(ent, CHAN_ITEM, gi.soundindex("items/protect.wav"), 1, ATTN_NORM, 0);
}

//==========================================================
void Use_Silencer(edict_t *ent, gitem_t *item) {
  ent->client->pers.inventory[ITEM_INDEX(item)]--;
  ValidateSelectedItem(ent);
  ent->client->silencer_shots += 30;
}

//==========================================================
void DoRespawn(edict_t *ent) {
edict_t *master;
int count, choice;

  if (ent->team) {
    master=ent->teammaster;
    for (count=0, ent=master; ent; ent=ent->chain, count++) ;
    choice=rand()%count;
    for (count=0, ent=master; count < choice; ent=ent->chain, count++) ; }

  ent->svflags &= ~SVF_NOCLIENT;
  ent->solid=SOLID_TRIGGER;
  gi.linkentity(ent);

  // send an effect
  ent->s.event=EV_ITEM_RESPAWN;
}

//==========================================================
void SetRespawn(edict_t *ent, float delay) {
  ent->flags |= FL_RESPAWN;
  ent->svflags |= SVF_NOCLIENT;
  ent->solid=SOLID_NOT;
  ent->nextthink=level.time+delay;
  ent->think=DoRespawn;
  gi.linkentity(ent);
}

//==========================================================
qboolean Pickup_Powerup(edict_t *ent, edict_t *other) {
int quantity;

  quantity=other->client->pers.inventory[ITEM_INDEX(ent->item)];
  if ((CVAR_SKILL == SKILL_MEDIUM && quantity >= 2) || (CVAR_SKILL >= SKILL_HARD && quantity >= 1))
    return false;

  if ((CVAR_COOP) && (ent->item->flags & IT_STAY_COOP) && (quantity > 0))
    return false;

  other->client->pers.inventory[ITEM_INDEX(ent->item)]++;

  if (CVAR_DEATHMATCH) {
    if (!(ent->spawnflags & DROPPED_ITEM))
      SetRespawn(ent, ent->item->quantity);
    if (((int)dmflags->value & DF_INSTANT_ITEMS)
     || ((ent->item->use == Use_Quad)
     && (ent->spawnflags & DROPPED_PLAYER_ITEM))) {
      if ((ent->item->use == Use_Quad) && (ent->spawnflags & DROPPED_PLAYER_ITEM))
        quad_drop_timeout_hack = (ent->nextthink-level.time)/FRAMETIME;
      ent->item->use(other, ent->item); } }

  return true;
}

//==========================================================
void Drop_General(edict_t *ent, gitem_t *item) {
  Drop_Item(ent, item);
  ent->client->pers.inventory[ITEM_INDEX(item)]--;
  ValidateSelectedItem(ent);
}

//==========================================================
qboolean Pickup_Adrenaline(edict_t *ent, edict_t *other) {

  if (!CVAR_DEATHMATCH)
    other->max_health++;

  if (other->health < other->max_health)
    other->health=other->max_health;

  if (!(ent->spawnflags & DROPPED_ITEM) && (CVAR_DEATHMATCH))
    SetRespawn(ent, ent->item->quantity);

  return true;
}

//==========================================================
qboolean Pickup_AncientHead(edict_t *ent, edict_t *other) {

  other->max_health += 2;

  if (!(ent->spawnflags & DROPPED_ITEM) && (CVAR_DEATHMATCH))
    SetRespawn(ent, ent->item->quantity);

  return true;
}

//==========================================================
qboolean Pickup_Bandolier(edict_t *ent, edict_t *other) {
int index;

  if (other->client->pers.max_bullets < 250)
    other->client->pers.max_bullets=250;
  if (other->client->pers.max_shells < 150)
    other->client->pers.max_shells=150;
  if (other->client->pers.max_cells < 250)
    other->client->pers.max_cells=250;
  if (other->client->pers.max_slugs < 75)
    other->client->pers.max_slugs=75;

  if (item_bullets) {
    index=ITEM_INDEX(item_bullets);
    other->client->pers.inventory[index] += item_bullets->quantity;
    if (other->client->pers.inventory[index] > other->client->pers.max_bullets)
      other->client->pers.inventory[index]=other->client->pers.max_bullets; }

  if (item_shells) {
    index=ITEM_INDEX(item_shells);
    other->client->pers.inventory[index] += item_shells->quantity;
    if (other->client->pers.inventory[index] > other->client->pers.max_shells)
      other->client->pers.inventory[index]=other->client->pers.max_shells; }

  if (!(ent->spawnflags & DROPPED_ITEM) && (CVAR_DEATHMATCH))
    SetRespawn(ent, ent->item->quantity);

  return true;
}

//==========================================================
qboolean Pickup_Pack(edict_t *ent, edict_t *other) {
int index;

  if (other->client->pers.max_bullets < 300)
    other->client->pers.max_bullets=300;
  if (other->client->pers.max_shells < 200)
    other->client->pers.max_shells=200;
  if (other->client->pers.max_rockets < 100)
    other->client->pers.max_rockets=100;
  if (other->client->pers.max_grenades < 100)
    other->client->pers.max_grenades=100;
  if (other->client->pers.max_cells < 300)
    other->client->pers.max_cells=300;
  if (other->client->pers.max_slugs < 100)
    other->client->pers.max_slugs=100;

  if (item_bullets) {
    index=ITEM_INDEX(item_bullets);
    other->client->pers.inventory[index] += item_bullets->quantity;
    if (other->client->pers.inventory[index] > other->client->pers.max_bullets)
      other->client->pers.inventory[index]=other->client->pers.max_bullets; }

  if (item_shells) {
    index=ITEM_INDEX(item_shells);
    other->client->pers.inventory[index] += item_shells->quantity;
    if (other->client->pers.inventory[index] > other->client->pers.max_shells)
      other->client->pers.inventory[index]=other->client->pers.max_shells; }

  if (item_cells) {
    index=ITEM_INDEX(item_cells);
    other->client->pers.inventory[index] += item_cells->quantity;
    if (other->client->pers.inventory[index] > other->client->pers.max_cells)
      other->client->pers.inventory[index]=other->client->pers.max_cells; }

  if (item_grenades) {
    index=ITEM_INDEX(item_grenades);
    other->client->pers.inventory[index] += item_grenades->quantity;
    if (other->client->pers.inventory[index] > other->client->pers.max_grenades)
      other->client->pers.inventory[index]=other->client->pers.max_grenades; }

  if (item_rockets) {
    index=ITEM_INDEX(item_rockets);
    other->client->pers.inventory[index] += item_rockets->quantity;
    if (other->client->pers.inventory[index] > other->client->pers.max_rockets)
      other->client->pers.inventory[index]=other->client->pers.max_rockets; }

  if (item_slugs) {
    index=ITEM_INDEX(item_slugs);
    other->client->pers.inventory[index] += item_slugs->quantity;
    if (other->client->pers.inventory[index] > other->client->pers.max_slugs)
      other->client->pers.inventory[index]=other->client->pers.max_slugs; }

  if (!(ent->spawnflags & DROPPED_ITEM) && (CVAR_DEATHMATCH))
    SetRespawn(ent, ent->item->quantity);

  return true;
}

//==========================================================
//==========================================================
qboolean Pickup_Key(edict_t *ent, edict_t *other) {

  if (CVAR_COOP) {
    if (!Q_stricmp(ent->classname, "key_power_cube")) {
      if (other->client->pers.power_cubes & ((ent->spawnflags & 0x0000ff00)>> 8))
        return false;
      other->client->pers.inventory[ITEM_INDEX(ent->item)]++;
      other->client->pers.power_cubes |=((ent->spawnflags & 0x0000ff00) >> 8); }
    else {
      if (other->client->pers.inventory[ITEM_INDEX(ent->item)])
        return false;
      other->client->pers.inventory[ITEM_INDEX(ent->item)]=1; }
    return true; }

  other->client->pers.inventory[ITEM_INDEX(ent->item)]++;

  return true;
}

//==========================================================
//==========================================================
qboolean Add_Ammo(edict_t *ent, gitem_t *item, int count) {
int index, max;

  if (!G_EntExists(ent)) return false;

  if (item->tag == AMMO_BULLETS)
    max=ent->client->pers.max_bullets;
  else if (item->tag == AMMO_SHELLS)
    max=ent->client->pers.max_shells;
  else if (item->tag == AMMO_ROCKETS)
    max=ent->client->pers.max_rockets;
  else if (item->tag == AMMO_GRENADES)
    max=ent->client->pers.max_grenades;
  else if (item->tag == AMMO_CELLS)
    max=ent->client->pers.max_cells;
  else if (item->tag == AMMO_SLUGS)
    max=ent->client->pers.max_slugs;
  else
    return false;

  index=ITEM_INDEX(item);

  if (ent->client->pers.inventory[index] == max)
    return false;

  ent->client->pers.inventory[index] += count;

  if (ent->client->pers.inventory[index] > max)
    ent->client->pers.inventory[index]=max;

  return true;
}

//==========================================================
qboolean Pickup_Ammo(edict_t *ent, edict_t *other) {
int oldcount, count;
qboolean weapon;

  weapon = (ent->item->flags & IT_WEAPON);
  if ((weapon) && ((int)dmflags->value & DF_INFINITE_AMMO))
    count=1000;
  else if (ent->count)
    count=ent->count;
  else
    count=ent->item->quantity;

  oldcount=other->client->pers.inventory[ITEM_INDEX(ent->item)];

  if (!Add_Ammo(other, ent->item, count))
    return false;

  if (weapon && !oldcount)
    if (other->client->pers.weapon != ent->item && (!CVAR_DEATHMATCH || other->client->pers.weapon == item_blaster))
      other->client->newweapon=ent->item;

  if (!(ent->spawnflags & (DROPPED_ITEM|DROPPED_PLAYER_ITEM)) && (CVAR_DEATHMATCH))
    SetRespawn(ent, 30);

  return true;
}

//==========================================================
void Drop_Ammo(edict_t *ent, gitem_t *item) {
edict_t *dropped;
int index;

  index=ITEM_INDEX(item);
  dropped=Drop_Item(ent,item);

  if (ent->client->pers.inventory[index] >= item->quantity)
    dropped->count=item->quantity;
  else
    dropped->count=ent->client->pers.inventory[index];

  if (ent->client->pers.weapon
  && ent->client->pers.weapon->tag == AMMO_GRENADES
  && item->tag == AMMO_GRENADES
  && ent->client->pers.inventory[index]-dropped->count<=0) {
    gi_cprintf(ent, PRINT_HIGH, "Can't drop current weapon\n");
    G_FreeEdict(dropped);
    return; }

  ent->client->pers.inventory[index] -= dropped->count;
  ValidateSelectedItem(ent);
}

//==========================================================
//==========================================================
void MegaHealth_think(edict_t *self) {

  if (self->owner->health > self->owner->max_health) {
    self->nextthink=level.time+1;
    self->owner->health--;
    return; }

  if (!(self->spawnflags & DROPPED_ITEM) && (CVAR_DEATHMATCH))
    SetRespawn(self, 20);
  else
    G_FreeEdict(self);
}

//==========================================================
void drop_temp_touch(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf) {

  if (other==ent->owner) return;

  Touch_Item(ent, other, plane, surf);
}

//======================================================
// Create 10 grenades
//======================================================
void spawn_into_grenades(edict_t *ent, edict_t *other) {
trace_t tr;
gitem_t *item=NULL;
edict_t *grenade=NULL;
vec3_t offset;
int i;
vec3_t spray[] = {  {  25,  00,  40 },
                    {  17, -17,  40 },
                    {  00, -25,  40 },
                    { -17, -17,  40 },
                    { -25,  00,  40 },
                    { -17, -17,  40 },
                    { -25,  00,  40 },
                    { -17,  17,  40 },
                    {  00,  25,  40 },
                    {  17,  17,  40 }};
vec3_t dir, forward, right, up;

  VectorSet(offset,0,0,0);

  for (i=1; i<=10; i++) {
    grenade = G_Spawn();
    grenade->owner=world; // Allow owner to get damaged!
    VectorSet(offset, spray[i-1][0], spray[i-1][1], spray[i-1][2]);
    offset[0] += ((crandom()*16.0)-8.0);
    offset[1] += ((crandom()*16.0)-8.0);
    offset[2] += ((crandom()*16.0)-8.0);
    vectoangles(offset, dir);
    AngleVectors(dir, forward, right, up);
    VectorSet(grenade->mins, -8, -8, -8);
    VectorSet(grenade->maxs, 8, 8, 8);
    G_ProjectSource(ent->s.origin, offset, forward, right, grenade->s.origin);
    tr=gi.trace(ent->s.origin, grenade->mins, grenade->maxs, grenade->s.origin, ent, CONTENTS_SOLID);
    VectorCopy(tr.endpos, grenade->s.origin);
    VectorScale(offset, crandom()*10.0, grenade->velocity);
    grenade->velocity[2]=300;
    grenade->movetype=MOVETYPE_BOUNCE;
    grenade->classname="grenade";
    item=item_grenades;
    grenade->clipmask=MASK_SHOT;
    grenade->solid=SOLID_BBOX;
    grenade->s.effects |= EF_GRENADE;
    grenade->dmg=40;
    grenade->dmg_radius=120;
    grenade->model = "models/objects/grenade/tris.md2";
    grenade->s.modelindex=gi.modelindex(grenade->model);
    grenade->touch=Grenade_Touch;
    grenade->think=Grenade_Explode;
    grenade->nextthink = level.time + 5.0+(random()*10.0);
    gi.linkentity(grenade);
    } // end for
}

//======================================================
void spawn_health_paks(edict_t *ent, edict_t *other) {
trace_t tr;
gitem_t *item=NULL;
edict_t *dropped=NULL;
vec3_t offset;
int i,k;
vec3_t spray[] = {  {  25,  00,  40 },
                    {  17, -17,  40 },
                    {  00, -25,  40 },
                    { -17, -17,  40 },
                    { -25,  00,  40 },
                    { -17, -17,  40 },
                    { -25,  00,  40 },
                    { -17,  17,  40 },
                    {  00,  25,  40 },
                    {  17,  17,  40 }};
vec3_t  dir, forward, right, up;

  VectorSet(offset,0,0,0);
  k=(ent->count==10)?10:1;

  for (i=1; i<=k; i++) {
    dropped = G_Spawn();
    dropped->owner=(other->health > 100)?other:world;
    VectorSet(offset, spray[i-1][0], spray[i-1][1], spray[i-1][2]);
    offset[0] += ((crandom()*16.0)-8.0);
    offset[1] += ((crandom()*16.0)-8.0);
    offset[2] += ((crandom()*16.0)-8.0);
    vectoangles(offset, dir);
    AngleVectors(dir, forward, right, up);
    VectorSet(dropped->mins, -15, -15, -15);
    VectorSet(dropped->maxs, 15, 15, 15);
    G_ProjectSource(ent->s.origin, offset, forward, right, dropped->s.origin);
    tr=gi.trace(ent->s.origin, dropped->mins, dropped->maxs, dropped->s.origin, ent, CONTENTS_SOLID);
    VectorCopy(tr.endpos, dropped->s.origin);
    VectorScale(offset, (crandom()*10.0), dropped->velocity);
    dropped->velocity[2]=300;
    dropped->movetype=MOVETYPE_BOUNCE;
    if (ent->count==10) {
      dropped->count = 2;  // 2 = Stimpak Health Increase
      dropped->style = HEALTH_IGNORE_MAX;
      item = item_stimpak;
      dropped->model = "models/items/healing/stimpack/tris.md2"; }
    else {
      dropped->count = 100;
      dropped->style = HEALTH_IGNORE_MAX|HEALTH_TIMED;
      item=item_health_mega;
      dropped->model = "models/items/mega_h/tris.md2"; }

    gi.soundindex("items/s_health.wav");
    dropped->classname = item->classname;
    dropped->item = item;
    gi.setmodel(dropped, dropped->model);
    dropped->spawnflags = DROPPED_ITEM;
    dropped->solid = SOLID_TRIGGER;
    dropped->s.renderfx = RF_GLOW;
    dropped->s.effects = item->world_model_flags;
    dropped->touch = drop_temp_touch;
    dropped->think=G_FreeEdict;
    dropped->nextthink = level.time + 20.0;
    gi.linkentity(dropped);
    } // end for
}

//======================================================
qboolean Pickup_Health(edict_t *ent, edict_t *other) {
int type=(int)(random()*10);

  // if health > max then explode into Mega or Stimpaks
  if (!(ent->style & HEALTH_IGNORE_MAX))
   if (other->health >= other->max_health) {
     switch(abs(type)) {
       case 1: // 1 in 5 chance of getting grenades
       case 2: spawn_into_grenades(ent,other); break;
       default:spawn_health_paks(ent,other); }
     if (!(ent->spawnflags & DROPPED_ITEM))
       SetRespawn(ent, 20);   /* respawn quicker than normal */
     return true; }

  other->health += ent->count;

  if (!(ent->style & HEALTH_IGNORE_MAX))
    if (other->health > other->max_health)
      other->health=other->max_health;

  if (ent->style & HEALTH_TIMED) {
    ent->think=MegaHealth_think;
    ent->nextthink=level.time+5;
    ent->owner=other;
    ent->flags |= FL_RESPAWN;
    ent->svflags |= SVF_NOCLIENT;
    ent->solid=SOLID_NOT; }
  else
    if (!(ent->spawnflags & DROPPED_ITEM) && (CVAR_DEATHMATCH))
      SetRespawn(ent, 30);

  return true;
}

//==========================================================
//==========================================================
qboolean Pickup_Armor(edict_t *ent, edict_t *other) {
int old_armor_index;
gitem_armor_t *oldinfo;
gitem_armor_t *newinfo;
int newcount,salvagecount;
float salvage;

  // get info on new armor
  newinfo = (gitem_armor_t *)ent->item->info;

  old_armor_index=ArmorIndex(other);

  // handle armor shards specially
  if (ent->item->tag == ARMOR_SHARD) {
    if (!old_armor_index)
      other->client->pers.inventory[jacket_armor_index] = 2;
    else
      other->client->pers.inventory[old_armor_index] += 2; }

  // if player has no armor, just use it
  else if (!old_armor_index)
    other->client->pers.inventory[ITEM_INDEX(ent->item)]=newinfo->base_count;

  // use the better armor
  else {
    // get info on old armor
    if (old_armor_index == jacket_armor_index)
      oldinfo=&jacketarmor_info;
    else if (old_armor_index == combat_armor_index)
      oldinfo=&combatarmor_info;
    else //(old_armor_index == body_armor_index)
      oldinfo=&bodyarmor_info;
    if (newinfo->normal_protection > oldinfo->normal_protection) {
      // calc new armor values
      salvage=oldinfo->normal_protection/newinfo->normal_protection;
      salvagecount=salvage*other->client->pers.inventory[old_armor_index];
      newcount=newinfo->base_count+salvagecount;
      if (newcount > newinfo->max_count)
        newcount=newinfo->max_count;
      // zero count of old armor so it goes away
      other->client->pers.inventory[old_armor_index]=0;
      // change armor to new item with computed value
      other->client->pers.inventory[ITEM_INDEX(ent->item)]=newcount; }
    else {
      // calc new armor values
      salvage=newinfo->normal_protection/oldinfo->normal_protection;
      salvagecount=salvage*newinfo->base_count;
      newcount=other->client->pers.inventory[old_armor_index]+salvagecount;
      if (newcount > oldinfo->max_count)
        newcount=oldinfo->max_count;
      // if we're already maxed out then we don't need the new armor
      if (other->client->pers.inventory[old_armor_index] >= newcount)
        return false;
      // update current armor value
      other->client->pers.inventory[old_armor_index]=newcount; } }

  if (!(ent->spawnflags & DROPPED_ITEM) && (CVAR_DEATHMATCH))
    SetRespawn(ent, 20);

  return true;
}

//==========================================================
int ArmorIndex(edict_t *ent) {

  if (!G_EntExists(ent)) return 0;

  if (ent->client->pers.inventory[jacket_armor_index] > 0)
    return jacket_armor_index;

  if (ent->client->pers.inventory[combat_armor_index] > 0)
    return combat_armor_index;

  if (ent->client->pers.inventory[body_armor_index] > 0)
    return body_armor_index;

  return 0;
}

//==========================================================
//==========================================================
int PowerArmorType(edict_t *ent) {

  if (!G_EntExists(ent) || !(ent->flags & FL_POWER_ARMOR))
    return POWER_ARMOR_NONE;

  if (ent->client->pers.inventory[power_shield_index] > 0)
    return POWER_ARMOR_SHIELD;

  if (ent->client->pers.inventory[power_screen_index] > 0)
    return POWER_ARMOR_SCREEN;

  return POWER_ARMOR_NONE;
}

//==========================================================
void Use_PowerArmor(edict_t *ent, gitem_t *item) {

  if (ent->flags & FL_POWER_ARMOR) {
    ent->flags &= ~FL_POWER_ARMOR;
    gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/power2.wav"), 1, ATTN_NORM, 0); }
  else {
    if (!ent->client->pers.inventory[ITEM_INDEX(item_cells)]) {
      gi_cprintf(ent, PRINT_HIGH, "No cells for power armor.\n");
      return; }
    ent->flags |= FL_POWER_ARMOR;
    gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/power1.wav"), 1, ATTN_NORM, 0); }
}

//==========================================================
qboolean Pickup_PowerArmor(edict_t *ent, edict_t *other) {
int quantity;

  quantity=other->client->pers.inventory[ITEM_INDEX(ent->item)];

  other->client->pers.inventory[ITEM_INDEX(ent->item)]++;

  if (CVAR_DEATHMATCH) {
    if (!(ent->spawnflags & DROPPED_ITEM))
      SetRespawn(ent, ent->item->quantity);
    if (!quantity)
      ent->item->use(other, ent->item); }

  return true;
}

//==========================================================
void Drop_PowerArmor(edict_t *ent, gitem_t *item) {
  if ((ent->flags & FL_POWER_ARMOR) && (ent->client->pers.inventory[ITEM_INDEX(item)] == 1))
    Use_PowerArmor(ent, item);
  Drop_General(ent, item);
}

//==========================================================
// Other = Player touching the item.
// Ent = The edict of the item being touched.
//==========================================================
void Touch_Item(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf) {

  if (!G_EntExists(other)) return;

  if (other->health < 1 || !ent->item->pickup)
    return;

  // Not successfully picked up?
  if (!ent->item->pickup(ent, other)) return;

  // flash the screen
  other->client->bonus_alpha=0.25;

  // show icon and name on status bar
  other->client->ps.stats[STAT_PICKUP_ICON]=gi.imageindex(ent->item->icon);
  other->client->ps.stats[STAT_PICKUP_STRING]=CS_ITEMS+ITEM_INDEX(ent->item);
  other->client->pickup_msg_time=level.time+3.0;

  // change selected item
  if (ent->item->use)
    other->client->pers.selected_item=other->client->ps.stats[STAT_SELECTED_ITEM]=ITEM_INDEX(ent->item);

  if (ent->item->pickup == Pickup_Health) {
    if (ent->count == 2)
      gi.sound(other, CHAN_ITEM, gi.soundindex("items/s_health.wav"), 1, ATTN_NORM, 0);
    else if (ent->count == 10)
      gi.sound(other, CHAN_ITEM, gi.soundindex("items/n_health.wav"), 1, ATTN_NORM, 0);
    else if (ent->count == 25)
      gi.sound(other, CHAN_ITEM, gi.soundindex("items/l_health.wav"), 1, ATTN_NORM, 0);
    else //(ent->count == 100)
      gi.sound(other, CHAN_ITEM, gi.soundindex("items/m_health.wav"), 1, ATTN_NORM, 0); }
  else
  if (ent->item->pickup_sound)
    gi.sound(other, CHAN_ITEM, gi.soundindex(ent->item->pickup_sound), 1, ATTN_NORM, 0);

  if (!(ent->spawnflags & ITEM_TARGETS_USED)) {
    G_UseTargets(ent, other);
    ent->spawnflags |= ITEM_TARGETS_USED; }

  if (!((CVAR_COOP) && (ent->item->flags & IT_STAY_COOP))
     || (ent->spawnflags & (DROPPED_ITEM|DROPPED_PLAYER_ITEM)))
    if (ent->flags & FL_RESPAWN)
      ent->flags &= ~FL_RESPAWN;
    else
      G_FreeEdict(ent);
}

//==========================================================
void drop_make_touchable(edict_t *ent) {
  ent->touch=Touch_Item;
  if (CVAR_DEATHMATCH) {
    ent->nextthink=level.time+29;
    ent->think=G_FreeEdict; }
}

//==========================================================
edict_t *Drop_Item(edict_t *ent, gitem_t *item) {
edict_t *dropped;
vec3_t forward, right;
vec3_t offset;
trace_t tr;

  dropped=G_Spawn();

  dropped->classname=item->classname;
  dropped->item=item;
  dropped->spawnflags=DROPPED_ITEM;
  dropped->s.effects=item->world_model_flags;
  dropped->s.renderfx=RF_GLOW;
  VectorSet(dropped->mins, -15, -15, -15);
  VectorSet(dropped->maxs, 15, 15, 15);
  gi.setmodel(dropped, dropped->item->world_model);
  dropped->solid=SOLID_TRIGGER;
  dropped->movetype=MOVETYPE_TOSS;
  dropped->touch=drop_temp_touch;
  dropped->owner=ent;

  if (ent->client) {
    AngleVectors(ent->client->v_angle, forward, right, NULL);
    VectorSet(offset, 24, 0, -16);
    G_ProjectSource(ent->s.origin, offset, forward, right, dropped->s.origin);
    tr=gi.trace(ent->s.origin, dropped->mins, dropped->maxs,
      dropped->s.origin, ent, CONTENTS_SOLID);
    VectorCopy(tr.endpos, dropped->s.origin); }
  else {
    AngleVectors(ent->s.angles, forward, right, NULL);
    VectorCopy(ent->s.origin, dropped->s.origin); }

  VectorScale(forward, 100, dropped->velocity);
  dropped->velocity[2]=300;

  dropped->think=drop_make_touchable;
  dropped->nextthink=level.time+1;

  gi.linkentity(dropped);

  return dropped;
}

//==========================================================
void Use_Item(edict_t *ent, edict_t *other, edict_t *activator) {

  ent->svflags &= ~SVF_NOCLIENT;
  ent->use=NULL;

  if (ent->spawnflags & ITEM_NO_TOUCH) {
    ent->solid=SOLID_BBOX;
    ent->touch=NULL; }
  else {
    ent->solid=SOLID_TRIGGER;
    ent->touch=Touch_Item; }

  gi.linkentity(ent);
}

//==========================================================
void droptofloor(edict_t *ent) {
trace_t tr;
vec3_t v,dest;

  VectorSet(ent->mins,-15,-15,-15);
  VectorSet(ent->maxs,15,15,15);

  if (ent->model)
    gi.setmodel(ent, ent->model);
  else
    gi.setmodel(ent, ent->item->world_model);
  ent->solid=SOLID_TRIGGER;
  ent->movetype=MOVETYPE_TOSS;
  ent->touch=Touch_Item;

  VectorSet(v,0,0,-128);
  VectorAdd(ent->s.origin, v, dest);

  tr=gi.trace(ent->s.origin, ent->mins, ent->maxs, dest, ent, MASK_SOLID);
  if (tr.startsolid) {
    gi.dprintf("droptofloor: %s startsolid at %s\n", ent->classname, vtos(ent->s.origin));
    G_FreeEdict(ent);
    return; }

  VectorCopy(tr.endpos, ent->s.origin);

  if (ent->team) {
    ent->flags &= ~FL_TEAMSLAVE;
    ent->chain=ent->teamchain;
    ent->teamchain=NULL;
    ent->svflags |= SVF_NOCLIENT;
    ent->solid=SOLID_NOT;
    if (ent == ent->teammaster) {
      ent->nextthink=level.time+FRAMETIME;
      ent->think=DoRespawn; } }

  if (ent->spawnflags & ITEM_NO_TOUCH) {
    ent->solid=SOLID_BBOX;
    ent->touch=NULL;
    ent->s.effects &= ~EF_ROTATE;
    ent->s.renderfx &= ~RF_GLOW; }

  if (ent->spawnflags & ITEM_TRIGGER_SPAWN) {
    ent->svflags |= SVF_NOCLIENT;
    ent->solid=SOLID_NOT;
    ent->use=Use_Item; }

  gi.linkentity(ent);
}

//==========================================================
void PrecacheItem(gitem_t *it) {
char *s, *start;
char data[MAX_QPATH];
int len;
gitem_t *ammo;

  if (!it) return;

  if (it->pickup_sound)
    gi.soundindex(it->pickup_sound);
  if (it->world_model)
    gi.modelindex(it->world_model);
  if (it->view_model)
    gi.modelindex(it->view_model);
  if (it->icon)
    gi.imageindex(it->icon);

  // parse everything for its ammo
  if (it->ammo && it->ammo[0]) {
    ammo=FindItem(it->ammo);
    if (ammo != it)
      PrecacheItem(ammo); }

  // parse the space seperated precache string for other items
  s=it->precaches;
  if (!s || !s[0]) return;

  while (*s) {
    start=s;
    while (*s && (*s != ' ')) s++;
    len=s-start;
    if (len >= MAX_QPATH || len < 5)
      gi.error(ERR_FATAL, "PrecacheItem: %s has bad precache string", it->classname);
    memcpy(data, start, len);
    data[len]=0;
    if (*s) s++;
    // determine type based on extension
    if (!Q_stricmp(data+len-3, "md2"))
      gi.modelindex(data);
    else if (!Q_stricmp(data+len-3, "sp2"))
      gi.modelindex(data);
    else if (!Q_stricmp(data+len-3, "wav"))
      gi.soundindex(data);
    if (!Q_stricmp(data+len-3, "pcx"))
      gi.imageindex(data); }
}

//==========================================================
void SpawnItem(edict_t *ent, gitem_t *item) {

  PrecacheItem(item);

  if (ent->spawnflags)
    if (Q_stricmp(ent->classname, "key_power_cube")) {
      ent->spawnflags=0;
      gi.dprintf("%s at %s has invalid spawnflags set\n", ent->classname, vtos(ent->s.origin)); }

  // some items will be prevented in deathmatch
  if (CVAR_DEATHMATCH) {
    if ((int)dmflags->value & DF_NO_ARMOR) {
      if (item->pickup == Pickup_Armor || item->pickup == Pickup_PowerArmor) {
        G_FreeEdict(ent);
        return; } }
    if ((int)dmflags->value & DF_NO_ITEMS) {
      if (item->pickup == Pickup_Powerup) {
        G_FreeEdict(ent);
        return; } }
    if ((int)dmflags->value & DF_NO_HEALTH) {
      if (item->pickup == Pickup_Health || item->pickup == Pickup_Adrenaline || item->pickup == Pickup_AncientHead) {
        G_FreeEdict(ent);
        return; } }
    if ((int)dmflags->value & DF_INFINITE_AMMO) {
      if ((item->flags == IT_AMMO)
       || (!Q_stricmp(ent->classname, "weapon_bfg"))) {
        G_FreeEdict(ent);
        return; } }
    } // endif

  if (CVAR_COOP && (!Q_stricmp(ent->classname, "key_power_cube"))) {
    ent->spawnflags |=(1 <<(8+level.power_cubes));
    level.power_cubes++; }

  // don't let them drop items that stay in a coop game
  if ((CVAR_COOP) && (item->flags & IT_STAY_COOP))
    item->drop=NULL;

  ent->item=item;
  ent->nextthink=level.time+2*FRAMETIME;
  ent->think=droptofloor;
  ent->s.effects=item->world_model_flags;
  ent->s.renderfx=RF_GLOW;
  if (ent->model)
    gi.modelindex(ent->model);
}

//==============================================================
qboolean Pickup_Weapon(edict_t *ent, edict_t *other) {
gitem_t *ammo, *weapon;

  // Make sure ent exists!
  if (!G_EntExists(other)) return false;

  weapon=ent->item;

  if ((((int)(dmflags->value) & DF_WEAPONS_STAY) || CVAR_COOP)
    && other->client->pers.inventory[WeapIndex(weapon)])
    if (!(ent->spawnflags & (DROPPED_ITEM|DROPPED_PLAYER_ITEM)))
      return false;  // leave the weapon for others to pickup

  other->client->pers.inventory[WeapIndex(ent->item)]++;

  if (!(ent->spawnflags & DROPPED_ITEM)) {
    ammo=FindItem(weapon->ammo);
    if ((int)dmflags->value & DF_INFINITE_AMMO)
      Add_Ammo(other, ammo, 1000);
    else
      Add_Ammo(other, ammo, ammo->quantity);
    if (!(ent->spawnflags & DROPPED_PLAYER_ITEM)) {
      if (CVAR_DEATHMATCH) {
        if ((int)(dmflags->value) & DF_WEAPONS_STAY)
          ent->flags |= FL_RESPAWN;
        else
          SetRespawn(ent, 30); }
      if (CVAR_COOP)
        ent->flags |= FL_RESPAWN; } }

  if (other->client->pers.weapon != weapon
  && (other->client->pers.inventory[WeapIndex(weapon)] == 1)
  && (!CVAR_DEATHMATCH || other->client->pers.weapon == item_blaster))
    other->client->newweapon=weapon;

  return true;
}

//==============================================================
void Use_Weapon(edict_t *ent, gitem_t *weapon) {
int ammo_index;
gitem_t *ammo_item;

  // Make sure ent exists!
  if (!G_EntExists(ent)) return;

  // see if we're already using it
  if (weapon == ent->client->pers.weapon)
    return;

  if (weapon->ammo && !g_select_empty->value && !(weapon->flags & IT_AMMO)) {
    ammo_item=FindItem(weapon->ammo);
    ammo_index=ITEM_INDEX(ammo_item);
    if (!ent->client->pers.inventory[ammo_index]) {
      gi_cprintf(ent, PRINT_HIGH, "No %s for %s.\n", ammo_item->pickup_name, weapon->pickup_name);
      return; }
    if (ent->client->pers.inventory[ammo_index] < weapon->quantity) {
      gi_cprintf(ent, PRINT_HIGH, "Not enough %s for %s.\n", ammo_item->pickup_name, weapon->pickup_name);
      return; } }

  // change to this weapon when down
  ent->client->newweapon=weapon;
}

//==============================================================
void Drop_Weapon(edict_t *ent, gitem_t *weapon) {

  // Make sure ent exists!
  if (!G_EntExists(ent)) return;

  if ((int)(dmflags->value) & DF_WEAPONS_STAY) return;

  // see if we're already using it
  if (((weapon == ent->client->pers.weapon)
    || (weapon == ent->client->newweapon))
    && (ent->client->pers.inventory[WeapIndex(weapon)] == 1)) {
    gi_cprintf(ent, PRINT_HIGH, "Can't drop current weapon\n");
    return; }

  Drop_Item(ent, weapon);

  ent->client->pers.inventory[WeapIndex(weapon)]--;
}

//==========================================================
//==========================================================
//==========================================================

//==========================================================
gitem_t itemlist[] = {
  { NULL },  // leave index 0 alone
{
    "item_armor_body",   // char *classname; (for indexing)
    Pickup_Armor,        // qboolean (*pickup)
    NULL,                // void (*use)
    NULL,                // void (*drop)
    NULL,                // void (*weaponthink)
    "misc/ar1_pkup.wav", // char *pickup_sound;
    "models/items/armor/body/tris.md2", // char *world_model;
    EF_ROTATE,           // int world_model_flags;
    NULL,                // char *view_model;
    "i_bodyarmor",       // char *icon;
    "Body Armor",        // char *pickup_name; (for printing on pickup)
    3,                   // int count_width; (num digits to display by icon)
    0,                   // int quantity; (for ammo how much, for weapons how much is used per shot)
    NULL,                // char *ammo; (for weapons)
    IT_ARMOR,            // int flags; (see IT_* flags)
    0,                   // int weapmodel; (weapon model index for weapons)
    &bodyarmor_info,     // void *info;
    ARMOR_BODY,          // int tag; (see ARMOR_* flags)
    ""                   // char *precaches; (string of all models, sounds, and images this item will use)
  },

//QUAKE2 item_armor_combat (-16 -16 -16)(16 16 16)
  {
    "item_armor_combat",
    Pickup_Armor,
    NULL,
    NULL,
    NULL,
    "misc/ar1_pkup.wav",
    "models/items/armor/combat/tris.md2", EF_ROTATE,
    NULL,
    "i_combatarmor",
    "Combat Armor",
    3,
    0,
    NULL,
    IT_ARMOR,
    0,
    &combatarmor_info,
    ARMOR_COMBAT,
    ""
  },

//QUAKE2 item_armor_jacket (-16 -16 -16)(16 16 16)
  {
    "item_armor_jacket",
    Pickup_Armor,
    NULL,
    NULL,
    NULL,
    "misc/ar1_pkup.wav",
    "models/items/armor/jacket/tris.md2", EF_ROTATE,
    NULL,
    "i_jacketarmor",
    "Jacket Armor",
    3,
    0,
    NULL,
    IT_ARMOR,
    0,
    &jacketarmor_info,
    ARMOR_JACKET,
    ""
  },

//QUAKE2 item_armor_shard (-16 -16 -16)(16 16 16)
  {
    "item_armor_shard",
    Pickup_Armor,
    NULL,
    NULL,
    NULL,
    "misc/ar2_pkup.wav",
    "models/items/armor/shard/tris.md2", EF_ROTATE,
    NULL,
    "i_jacketarmor",
    "Armor Shard",
    3,
    0,
    NULL,
    IT_ARMOR,
    0,
    NULL,
    ARMOR_SHARD,
    ""
  },


//QUAKE2 item_power_screen (-16 -16 -16)(16 16 16)

  {
    "item_power_screen",
    Pickup_PowerArmor,
    Use_PowerArmor,
    Drop_PowerArmor,
    NULL,
    "misc/ar3_pkup.wav",
    "models/items/armor/screen/tris.md2", EF_ROTATE,
    NULL,
    "i_powerscreen",
    "Power Screen",
    0,
    60,
    NULL,
    IT_ARMOR,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 item_power_shield (-16 -16 -16)(16 16 16)

  {
    "item_power_shield",
    Pickup_PowerArmor,
    Use_PowerArmor,
    Drop_PowerArmor,
    NULL,
    "misc/ar3_pkup.wav",
    "models/items/armor/shield/tris.md2", EF_ROTATE,
    NULL,
    "i_powershield",
    "Power Shield",
    0,
    60,
    NULL,
    IT_ARMOR,
    0,
    NULL,
    0,
    "misc/power2.wav misc/power1.wav"
  },


  //
  // WEAPONS
  //

// weapon_blaster (-16 -16 -16)(16 16 16) always owned, never in the world
  {
    "weapon_blaster",
    NULL,
    Use_Weapon,
    NULL,
    Weapon_Blaster,
    "misc/w_pkup.wav",
    NULL, 0,
    "models/weapons/v_blast/tris.md2",
    "w_blaster",
    "Blaster",
    0,
    0,
    NULL,
    IT_WEAPON|IT_STAY_COOP,
    WEAP_BLASTER,
    NULL,
    0,
    "weapons/blastf1a.wav misc/lasfly.wav"
  },

//QUAKE2 weapon_shotgun (-16 -16 -16)(16 16 16)
  {
    "weapon_shotgun",
    Pickup_Weapon,
    Use_Weapon,
    Drop_Weapon,
    Weapon_Shotgun,
    "misc/w_pkup.wav",
    "models/weapons/g_shotg/tris.md2", EF_ROTATE,
    "models/weapons/v_shotg/tris.md2",
    "w_shotgun",
    "Shotgun",
    0,
    1,
    "Shells",
    IT_WEAPON|IT_STAY_COOP,
    WEAP_SHOTGUN,
    NULL,
    0,
    "weapons/shotgf1b.wav weapons/shotgr1b.wav"
  },

//QUAKE2 weapon_supershotgun (-16 -16 -16)(16 16 16)
  {
    "weapon_supershotgun",
    Pickup_Weapon,
    Use_Weapon,
    Drop_Weapon,
    Weapon_SuperShotgun,
    "misc/w_pkup.wav",
    "models/weapons/g_shotg2/tris.md2", EF_ROTATE,
    "models/weapons/v_shotg2/tris.md2",
    "w_sshotgun",
    "Super Shotgun",
    0,
    2,
    "Shells",
    IT_WEAPON|IT_STAY_COOP,
    WEAP_SUPERSHOTGUN,
    NULL,
    0,
    "weapons/sshotf1b.wav"
  },

//QUAKE2 weapon_machinegun (-16 -16 -16)(16 16 16)
  {
    "weapon_machinegun",
    Pickup_Weapon,
    Use_Weapon,
    Drop_Weapon,
    Weapon_Machinegun,
    "misc/w_pkup.wav",
    "models/weapons/g_machn/tris.md2", EF_ROTATE,
    "models/weapons/v_machn/tris.md2",
    "w_machinegun",
    "Machinegun",
    0,
    1,
    "Bullets",
    IT_WEAPON|IT_STAY_COOP,
    WEAP_MACHINEGUN,
    NULL,
    0,
    "weapons/machgf1b.wav weapons/machgf2b.wav weapons/machgf3b.wav weapons/machgf4b.wav weapons/machgf5b.wav"
  },

//QUAKE2 weapon_chaingun (-16 -16 -16)(16 16 16)
  {
    "weapon_chaingun",
    Pickup_Weapon,
    Use_Weapon,
    Drop_Weapon,
    Weapon_Chaingun,
    "misc/w_pkup.wav",
    "models/weapons/g_chain/tris.md2", EF_ROTATE,
    "models/weapons/v_chain/tris.md2",
    "w_chaingun",
    "Chaingun",
    0,
    1,
    "Bullets",
    IT_WEAPON|IT_STAY_COOP,
    WEAP_CHAINGUN,
    NULL,
    0,
    "weapons/chngnu1a.wav weapons/chngnl1a.wav weapons/machgf3b.wav` weapons/chngnd1a.wav"
  },

//QUAKE2 ammo_grenades (-16 -16 -16)(16 16 16)
  {
    "ammo_grenades",
    Pickup_Ammo,
    Use_Weapon,
    Drop_Ammo,
    Weapon_Grenade,
    "misc/am_pkup.wav",
    "models/items/ammo/grenades/medium/tris.md2", 0,
    "models/weapons/v_handgr/tris.md2",
    "a_grenades",
    "Grenades",
    3,
    5,
    "grenades",
    IT_AMMO|IT_WEAPON,
    WEAP_GRENADES,
    NULL,
    AMMO_GRENADES,
    "weapons/hgrent1a.wav weapons/hgrena1b.wav weapons/hgrenc1b.wav weapons/hgrenb1a.wav weapons/hgrenb2a.wav "
  },

//QUAKE2 weapon_grenadelauncher (-16 -16 -16)(16 16 16)
  {
    "weapon_grenadelauncher",
    Pickup_Weapon,
    Use_Weapon,
    Drop_Weapon,
    Weapon_GrenadeLauncher,
    "misc/w_pkup.wav",
    "models/weapons/g_launch/tris.md2", EF_ROTATE,
    "models/weapons/v_launch/tris.md2",
    "w_glauncher",
    "Grenade Launcher",
    0,
    1,
    "Grenades",
    IT_WEAPON|IT_STAY_COOP,
    WEAP_GRENADELAUNCHER,
    NULL,
    0,
    "models/objects/grenade/tris.md2 weapons/grenlf1a.wav weapons/grenlr1b.wav weapons/grenlb1b.wav"
  },

//QUAKE2 weapon_rocketlauncher (-16 -16 -16)(16 16 16)
  {
    "weapon_rocketlauncher",
    Pickup_Weapon,
    Use_Weapon,
    Drop_Weapon,
    Weapon_RocketLauncher,
    "misc/w_pkup.wav",
    "models/weapons/g_rocket/tris.md2", EF_ROTATE,
    "models/weapons/v_rocket/tris.md2",
    "w_rlauncher",
    "Rocket Launcher",
    0,
    1,
    "Rockets",
    IT_WEAPON|IT_STAY_COOP,
    WEAP_ROCKETLAUNCHER,
    NULL,
    0,
    "models/objects/rocket/tris.md2 weapons/rockfly.wav weapons/rocklf1a.wav weapons/rocklr1b.wav models/objects/debris2/tris.md2"
  },

//QUAKE2 weapon_hyperblaster (-16 -16 -16)(16 16 16)
  {
    "weapon_hyperblaster",
    Pickup_Weapon,
    Use_Weapon,
    Drop_Weapon,
    Weapon_HyperBlaster,
    "misc/w_pkup.wav",
    "models/weapons/g_hyperb/tris.md2", EF_ROTATE,
    "models/weapons/v_hyperb/tris.md2",
    "w_hyperblaster",
    "HyperBlaster",
    0,
    1,
    "Cells",
    IT_WEAPON|IT_STAY_COOP,
    WEAP_HYPERBLASTER,
    NULL,
    0,
    "weapons/hyprbu1a.wav weapons/hyprbl1a.wav weapons/hyprbf1a.wav weapons/hyprbd1a.wav misc/lasfly.wav"
  },

//QUAKE2 weapon_railgun (-16 -16 -16)(16 16 16)
  {
    "weapon_railgun",
    Pickup_Weapon,
    Use_Weapon,
    Drop_Weapon,
    Weapon_Railgun,
    "misc/w_pkup.wav",
    "models/weapons/g_rail/tris.md2", EF_ROTATE,
    "models/weapons/v_rail/tris.md2",
    "w_railgun",
    "Railgun",
    0,
    1,
    "Slugs",
    IT_WEAPON|IT_STAY_COOP,
    WEAP_RAILGUN,
    NULL,
    0,
    "weapons/rg_hum.wav"
  },

//QUAKE2 weapon_bfg (-16 -16 -16)(16 16 16)
  {
    "weapon_bfg",
    Pickup_Weapon,
    Use_Weapon,
    Drop_Weapon,
    Weapon_BFG,
    "misc/w_pkup.wav",
    "models/weapons/g_bfg/tris.md2", EF_ROTATE,
    "models/weapons/v_bfg/tris.md2",
    "w_bfg",
    "BFG10K",
    0,
    50,
    "Cells",
    IT_WEAPON|IT_STAY_COOP,
    WEAP_BFG,
    NULL,
    0,
    "sprites/s_bfg1.sp2 sprites/s_bfg2.sp2 sprites/s_bfg3.sp2 weapons/bfg__f1y.wav weapons/bfg__l1a.wav weapons/bfg__x1b.wav weapons/bfg_hum.wav"
  },

  //
  // AMMO ITEMS
  //

//QUAKE2 ammo_shells (-16 -16 -16)(16 16 16)
  {
    "ammo_shells",
    Pickup_Ammo,
    NULL,
    Drop_Ammo,
    NULL,
    "misc/am_pkup.wav",
    "models/items/ammo/shells/medium/tris.md2", 0,
    NULL,
    "a_shells",
    "Shells",
    3,
    10,
    NULL,
    IT_AMMO,
    0,
    NULL,
    AMMO_SHELLS,
    ""
  },

//QUAKE2 ammo_bullets (-16 -16 -16)(16 16 16)
  {
    "ammo_bullets",
    Pickup_Ammo,
    NULL,
    Drop_Ammo,
    NULL,
    "misc/am_pkup.wav",
    "models/items/ammo/bullets/medium/tris.md2", 0,
    NULL,
    "a_bullets",
    "Bullets",
    3,
    50,
    NULL,
    IT_AMMO,
    0,
    NULL,
    AMMO_BULLETS,
    ""
  },

//QUAKE2 ammo_cells (-16 -16 -16)(16 16 16)
  {
    "ammo_cells",
    Pickup_Ammo,
    NULL,
    Drop_Ammo,
    NULL,
    "misc/am_pkup.wav",
    "models/items/ammo/cells/medium/tris.md2", 0,
    NULL,
    "a_cells",
    "Cells",
    3,
    50,
    NULL,
    IT_AMMO,
    0,
    NULL,
    AMMO_CELLS,
    ""
  },

//QUAKE2 ammo_rockets (-16 -16 -16)(16 16 16)
  {
    "ammo_rockets",
    Pickup_Ammo,
    NULL,
    Drop_Ammo,
    NULL,
    "misc/am_pkup.wav",
    "models/items/ammo/rockets/medium/tris.md2", 0,
    NULL,
    "a_rockets",
    "Rockets",
    3,
    5,
    NULL,
    IT_AMMO,
    0,
    NULL,
    AMMO_ROCKETS,
    ""
  },

//QUAKE2 ammo_slugs (-16 -16 -16)(16 16 16)
  {
    "ammo_slugs",
    Pickup_Ammo,
    NULL,
    Drop_Ammo,
    NULL,
    "misc/am_pkup.wav",
    "models/items/ammo/slugs/medium/tris.md2", 0,
    NULL,
    "a_slugs",
    "Slugs",
    3,
    10,
    NULL,
    IT_AMMO,
    0,
    NULL,
    AMMO_SLUGS,
    ""
  },


  //
  // POWERUP ITEMS
  //

//QUAKE2 item_quad (-16 -16 -16)(16 16 16)
  {
    "item_quad",
    Pickup_Powerup,
    Use_Quad,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/quaddama/tris.md2", EF_ROTATE,
    NULL,
    "p_quad",
    "Quad Damage",
    2,
    60,
    NULL,
    IT_POWERUP,
    0,
    NULL,
    0,
    "items/damage.wav items/damage2.wav items/damage3.wav"
  },

//QUAKE2 item_invulnerability (-16 -16 -16)(16 16 16)
  {
    "item_invulnerability",
    Pickup_Powerup,
    Use_Invulnerability,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/invulner/tris.md2", EF_ROTATE,
    NULL,
    "p_invulnerability",
    "Invulnerability",
    2,
    300,
    NULL,
    IT_POWERUP,
    0,
    NULL,
    0,
    "items/protect.wav items/protect2.wav items/protect4.wav"
  },

//QUAKE2 item_silencer (-16 -16 -16)(16 16 16)
  {
    "item_silencer",
    Pickup_Powerup,
    Use_Silencer,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/silencer/tris.md2", EF_ROTATE,
    NULL,
    "p_silencer",
    "Silencer",
    2,
    60,
    NULL,
    IT_POWERUP,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 item_breather (-16 -16 -16)(16 16 16)
  {
    "item_breather",
    Pickup_Powerup,
    Use_Breather,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/breather/tris.md2", EF_ROTATE,
    NULL,
    "p_rebreather",
    "Rebreather",
    2,
    60,
    NULL,
    IT_STAY_COOP|IT_POWERUP,
    0,
    NULL,
    0,
    "items/airout.wav"
  },

//QUAKE2 item_enviro (-16 -16 -16)(16 16 16)
  {
    "item_enviro",
    Pickup_Powerup,
    Use_Envirosuit,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/enviro/tris.md2", EF_ROTATE,
    NULL,
    "p_envirosuit",
    "Environment Suit",
    2,
    60,
    NULL,
    IT_STAY_COOP|IT_POWERUP,
    0,
    NULL,
    0,
    "items/airout.wav"
  },

//QUAKE2 item_ancient_head (-16 -16 -16)(16 16 16)
// Special item that gives +2 to maximum health
  {
    "item_ancient_head",
    Pickup_AncientHead,
    NULL,
    NULL,
    NULL,
    "items/pkup.wav",
    "models/items/c_head/tris.md2", EF_ROTATE,
    NULL,
    "i_fixme",
    "Ancient Head",
    2,
    60,
    NULL,
    0,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 item_adrenaline (-16 -16 -16)(16 16 16) gives +1 to maximum health
  {
    "item_adrenaline",
    Pickup_Adrenaline,
    NULL,
    NULL,
    NULL,
    "items/pkup.wav",
    "models/items/adrenal/tris.md2", EF_ROTATE,
    NULL,
    "p_adrenaline",
    "Adrenaline",
    2,
    60,
    NULL,
    IT_HEALTH, // NEW FLAG HERE
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 item_bandolier (-16 -16 -16)(16 16 16)
  {
    "item_bandolier",
    Pickup_Bandolier,
    NULL,
    NULL,
    NULL,
    "items/pkup.wav",
    "models/items/band/tris.md2", EF_ROTATE,
    NULL,
    "p_bandolier",
    "Bandolier",
    2,
    60,
    NULL,
    IT_PACK,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 item_pack (-16 -16 -16)(16 16 16)
  {
    "item_pack",
    Pickup_Pack,
    NULL,
    NULL,
    NULL,
    "items/pkup.wav",
    "models/items/pack/tris.md2", EF_ROTATE,
    NULL,
    "i_pack",
    "Ammo Pack",
    2,
    180,
    NULL,
    IT_PACK,
    0,
    NULL,
    0,
    ""
  },

  //
  // KEYS
  //

//QUAKE2 key_data_cd(0 .5 .8)(-16 -16 -16)(16 16 16) key for computer centers
  {
    "key_data_cd",
    Pickup_Key,
    NULL,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/keys/data_cd/tris.md2", EF_ROTATE,
    NULL,
    "k_datacd",
    "Data CD",
    2,
    0,
    NULL,
    IT_STAY_COOP|IT_KEY,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 key_power_cube(0 .5 .8)(-16 -16 -16)(16 16 16) TRIGGER_SPAWN NO_TOUCH warehouse circuits
  {
    "key_power_cube",
    Pickup_Key,
    NULL,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/keys/power/tris.md2", EF_ROTATE,
    NULL,
    "k_powercube",
    "Power Cube",
    2,
    0,
    NULL,
    IT_STAY_COOP|IT_KEY,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 key_pyramid(0 .5 .8)(-16 -16 -16)(16 16 16) key for the entrance of jail3
  {
    "key_pyramid",
    Pickup_Key,
    NULL,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/keys/pyramid/tris.md2", EF_ROTATE,
    NULL,
    "k_pyramid",
    "Pyramid Key",
    2,
    0,
    NULL,
    IT_STAY_COOP|IT_KEY,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 key_data_spinner(0 .5 .8)(-16 -16 -16)(16 16 16) key for the city computer
  {
    "key_data_spinner",
    Pickup_Key,
    NULL,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/keys/spinner/tris.md2", EF_ROTATE,
    NULL,
    "k_dataspin",
    "Data Spinner",
    2,
    0,
    NULL,
    IT_STAY_COOP|IT_KEY,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 key_pass(0 .5 .8)(-16 -16 -16)(16 16 16) security pass for the security level
  {
    "key_pass",
    Pickup_Key,
    NULL,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/keys/pass/tris.md2", EF_ROTATE,
    NULL,
    "k_security",
    "Security Pass",
    2,
    0,
    NULL,
    IT_STAY_COOP|IT_KEY,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 key_blue_key(0 .5 .8)(-16 -16 -16)(16 16 16) normal door key-blue
  {
    "key_blue_key",
    Pickup_Key,
    NULL,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/keys/key/tris.md2", EF_ROTATE,
    NULL,
    "k_bluekey",
    "Blue Key",
    2,
    0,
    NULL,
    IT_STAY_COOP|IT_KEY,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 key_red_key(0 .5 .8)(-16 -16 -16)(16 16 16) normal door key-red
  {
    "key_red_key",
    Pickup_Key,
    NULL,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/keys/red_key/tris.md2", EF_ROTATE,
    NULL,
    "k_redkey",
    "Red Key",
    2,
    0,
    NULL,
    IT_STAY_COOP|IT_KEY,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 key_commander_head(0 .5 .8)(-16 -16 -16)(16 16 16) tank commander's head
  {
    "key_commander_head",
    Pickup_Key,
    NULL,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/monsters/commandr/head/tris.md2", EF_GIB,
    NULL,
    "k_comhead",
    "Commander's Head",
    2,
    0,
    NULL,
    IT_STAY_COOP|IT_KEY,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 key_airstrike_target(0 .5 .8)(-16 -16 -16)(16 16 16)
  {
    "key_airstrike_target",
    Pickup_Key,
    NULL,
    Drop_General,
    NULL,
    "items/pkup.wav",
    "models/items/keys/target/tris.md2", EF_ROTATE,
    NULL,
    "i_airstrike",
    "Airstrike Marker",
    2,
    0,
    NULL,
    IT_STAY_COOP|IT_KEY,
    0,
    NULL,
    0,
    ""
  },

//QUAKE2 item_healt (-16 -16 -16)(16 16 16)
  {
    NULL,
    Pickup_Health,
    NULL,
    NULL,
    NULL,
    "items/pkup.wav",
    NULL, 0,
    NULL,
    "i_health",
    "Health",
    3,
    0,
    NULL,
    IT_HEALTH, // NEW FLAG HERE
    0,
    NULL,
    0,
    "items/s_health.wav items/n_health.wav items/l_health.wav items/m_health.wav"
  },
  {NULL}
};

//==========================================================
//==========================================================
//==========================================================

//==========================================================
void SP_item_health(edict_t *self) {

  if (CVAR_DEATHMATCH && ((int)dmflags->value & DF_NO_HEALTH)) {
    G_FreeEdict(self);
    return; }

  self->model="models/items/healing/medium/tris.md2";
  self->count=10;
  SpawnItem(self, item_health);
  gi.soundindex("items/n_health.wav");
}

//==========================================================
void SP_item_health_small(edict_t *self) {

  if (CVAR_DEATHMATCH && ((int)dmflags->value & DF_NO_HEALTH)) {
    G_FreeEdict(self);
    return; }

  self->model="models/items/healing/stimpack/tris.md2";
  self->count=2;
  SpawnItem(self, item_stimpak);
  self->style=HEALTH_IGNORE_MAX;
  gi.soundindex("items/s_health.wav");
}

//==========================================================
void SP_item_health_large(edict_t *self) {

  if (CVAR_DEATHMATCH && ((int)dmflags->value & DF_NO_HEALTH)) {
    G_FreeEdict(self);
    return; }

  self->model="models/items/healing/large/tris.md2";
  self->count=25;
  SpawnItem(self, item_health_large);
  gi.soundindex("items/l_health.wav");
}

//==========================================================
void SP_item_health_mega(edict_t *self) {

  if (CVAR_DEATHMATCH && ((int)dmflags->value & DF_NO_HEALTH)) {
    G_FreeEdict(self);
    return; }

  self->model="models/items/mega_h/tris.md2";
  self->count=100;
  SpawnItem(self, item_health_mega);
  gi.soundindex("items/m_health.wav");
  self->style=HEALTH_IGNORE_MAX|HEALTH_TIMED;
}

//==========================================================
void InitItems(void) {
  ga.num_items=sizeof(itemlist)/sizeof(itemlist[0])-1;
}

//==========================================================
void SetItemNames(void) {
int i;
gitem_t *it;

  for (i=0; i<ga.num_items; i++) {
    it=&itemlist[i];
    gi.configstring(CS_ITEMS+i, it->pickup_name); }

  // -------------------------------
  // Make item lookup MUCH FASTER!
  // -------------------------------

  // set IT_ARMOR lookups
  item_jacketarmor=FindItem("Jacket Armor");
  item_combatarmor=FindItem("Combat Armor");
  item_bodyarmor  =FindItem("Body Armor");
  item_armorshard =FindItem("Armor Shard");
  item_powerscreen=FindItem("Power Screen");
  item_powershield=FindItem("Power Shield");

  jacket_armor_index=ITEM_INDEX(item_jacketarmor);
  combat_armor_index=ITEM_INDEX(item_combatarmor);
  body_armor_index  =ITEM_INDEX(item_bodyarmor);
  power_screen_index=ITEM_INDEX(item_powerscreen);
  power_shield_index=ITEM_INDEX(item_powershield);

  // set IT_AMMO lookups
  item_shells = FindItem("shells");
  item_cells = FindItem("cells");
  item_bullets = FindItem("bullets");
  item_rockets = FindItem("rockets");
  item_slugs = FindItem("slugs");
  item_grenades = FindItem("grenades");

  // set IT_WEAPON lookups
  item_blaster = FindItem("blaster");
  item_shotgun = FindItem("shotgun");
  item_supershotgun = FindItem("super shotgun");
  item_handgrenade = FindItem("grenades");
  item_machinegun = FindItem("machinegun");
  item_chaingun = FindItem("chaingun");
  item_grenadelauncher = FindItem("grenade launcher");
  item_rocketlauncher = FindItem("rocket launcher");
  item_railgun = FindItem("railgun");
  item_hyperblaster = FindItem("hyperblaster");
  item_bfg = FindItem("bfg10k");

  // set IT_HEALTH lookups
  item_adrenaline = FindItem("Adrenaline");
  item_health = FindItem("Health");
  item_stimpak = FindItem("Health");
  item_health_large = FindItem("Health");
  item_health_mega = FindItem("Health");

  // set IT_POWERUP lookups
  item_quad = FindItem("Quad Damage");
  item_invulnerability = FindItem("Invulnerability");
  item_silencer = FindItem("Silencer");
  item_breather = FindItem("Rebreather");
  item_enviro = FindItem("Environment Suit");

  // set IT_PACK lookups
  item_pack = FindItem("Ammo Pack");
  item_bandolier = FindItem("Bandolier");

  // set IT_KEY lookups
  item_ancient_head = FindItem("Ancient Head");
  key_data_cd = FindItem("Data CD");
  key_power_cube = FindItem("Power Cube");
  key_pyramid = FindItem("Pyramid Key");
  key_data_spinner = FindItem("Data Spinner");
  key_pass = FindItem("Security Pass");
  key_blue_key = FindItem("Blue Key");
  key_red_key = FindItem("Red Key");
  key_commander_head = FindItem("Commander's Head");
  key_airstrike_target = FindItem("Airstrike Marker");
}

//========================================================
//============= NEW INDEXING SCHEMES =====================
//========================================================

//========================================================
// Returns the WEAPON inventory index for the given weapon.
//========================================================
int WeapIndex(gitem_t *weapon) {
  return ITEM_INDEX(weapon);
}

//========================================================
// Returns the AMMO inventory index for the given weapon.
//========================================================
int AmmoIndex(gitem_t *weapon) {

  if (weapon==item_shotgun)         return ITEM_INDEX(item_shells);
  if (weapon==item_supershotgun)    return ITEM_INDEX(item_shells);
  if (weapon==item_machinegun)      return ITEM_INDEX(item_bullets);
  if (weapon==item_chaingun)        return ITEM_INDEX(item_bullets);
  if (weapon==item_handgrenade)     return ITEM_INDEX(item_grenades);
  if (weapon==item_grenadelauncher) return ITEM_INDEX(item_grenades);
  if (weapon==item_rocketlauncher)  return ITEM_INDEX(item_rockets);
  if (weapon==item_railgun)         return ITEM_INDEX(item_slugs);
  if (weapon==item_hyperblaster)    return ITEM_INDEX(item_cells);
  if (weapon==item_bfg)             return ITEM_INDEX(item_cells);

  return ITEM_INDEX(item_shells); // Must return something
}

//========================================================
//============ AMMO/WEAPONS IN INVENTORY? ================
//========================================================

//========================================================
// TRUE if inventory FULL of given ammo item.
//========================================================
qboolean AlreadyAtMaxAmmo(edict_t *ent, gitem_t *ammo) {

  if ((int)dmflags->value & DF_INFINITE_AMMO)
    return true;

  if (ammo == item_shells)
    return (ent->client->pers.inventory[ITEM_INDEX(item_shells)] >= ent->client->pers.max_shells);
  if (ammo == item_bullets)
    return (ent->client->pers.inventory[ITEM_INDEX(item_bullets)] >= ent->client->pers.max_bullets);
  if (ammo == item_grenades)
    return (ent->client->pers.inventory[ITEM_INDEX(item_grenades)] >= ent->client->pers.max_grenades);
  if (ammo == item_rockets)
    return (ent->client->pers.inventory[ITEM_INDEX(item_rockets)] >= ent->client->pers.max_rockets);
  if (ammo == item_slugs)
    return (ent->client->pers.inventory[ITEM_INDEX(item_slugs)] >= ent->client->pers.max_slugs);
  if (ammo == item_cells)
    return (ent->client->pers.inventory[ITEM_INDEX(item_cells)] >= ent->client->pers.max_cells);
  return false;
}

//========================================================
// TRUE if bot is already FULL of armor item.
//========================================================
qboolean AlreadyAtMaxArmor(edict_t *bot, gitem_t *newarmor) {
int old_armor_index;
gitem_armor_t *oldinfo;
gitem_armor_t *newinfo;

  // These are additive to existing armor!
  // ALWAYS pick up these types!
  if (newarmor == item_armorshard
   || newarmor == item_powerscreen
   || newarmor == item_powershield)
    return false;

  // See if bot wearing armor now!
  old_armor_index=ArmorIndex(bot);

  // No current armor? Then, pick it up!
  if (!old_armor_index) return false;

// -----------------------------------------------
// See gitem_armor_t structs at top of g_items.c
//
// Armor is ADDITIVE !!
// Check ceilings on various armor types..
// -----------------------------------------------

  // What kind of armor is bot currently wearing?
  if (old_armor_index == jacket_armor_index)
    oldinfo=&jacketarmor_info;
  else if (old_armor_index == combat_armor_index)
    oldinfo=&combatarmor_info;
  else
    oldinfo=&bodyarmor_info;

  // What kind of armor is new item?
  newinfo=(gitem_armor_t *)newarmor->info;

  // If new armor of better protection type then grab it!
  if (newinfo->normal_protection > oldinfo->normal_protection)
    return false;

  // New armor must be same or lesser type than previous armor...
  // Check if already at max allowed armor for prev armor.
  return (bot->client->pers.inventory[old_armor_index] >= oldinfo->max_count);
}

//========================================================
// TRUE if self has weapon for the given ammo item.
//========================================================
qboolean HasWeaponForAmmo(edict_t *self, gitem_t *ammo) {
  if (ammo==item_shells)
    return ((HasWeaponInInventory(self,item_supershotgun)
         || (HasWeaponInInventory(self,item_shotgun))));
  if (ammo==item_rockets)
    return (HasWeaponInInventory(self,item_rocketlauncher));
  if (ammo==item_cells)
    return ((HasWeaponInInventory(self,item_hyperblaster)
         || (HasWeaponInInventory(self,item_bfg))));
  if (ammo==item_bullets)
    return ((HasWeaponInInventory(self,item_chaingun)
         || (HasWeaponInInventory(self,item_machinegun))));
  if (ammo==item_slugs)
    return (HasWeaponInInventory(self,item_railgun));
  if (ammo==item_grenades)
    return ((HasWeaponInInventory(self,item_grenadelauncher)
        || (HasWeaponInInventory(self,item_grenades))));

  return false;
}

//========================================================
// TRUE if self has sufficient ammo in inventory for weapon.
//========================================================
qboolean HasAmmoForWeapon(edict_t *self, gitem_t *weapon) {

  if ((int)dmflags->value & DF_INFINITE_AMMO)
    return true;

  if (weapon==item_blaster) return true;

  if (weapon==item_bfg)
    return (self->client->pers.inventory[AmmoIndex(item_bfg)]>=50);

  if (weapon==item_supershotgun)
    return (self->client->pers.inventory[AmmoIndex(item_supershotgun)]>=2);

  return (self->client->pers.inventory[AmmoIndex(weapon)]);
}

//========================================================
// TRUE if self has Weapon in inventory
//========================================================
qboolean HasWeaponInInventory(edict_t *self, gitem_t *item) {
  return (self->client->pers.inventory[ITEM_INDEX(item)]);
}

//========================================================
// TRUE if self has 'Special' item in inventory
//========================================================
qboolean HasSpecialInInventory(edict_t *self, gitem_t *item) {
  return (self->client->pers.inventory[ITEM_INDEX(item)]);
}

//========================================================
//=============== ITEM IDENTIFICATION ====================
//========================================================

//========================================================
// TRUE if item is ammo
//========================================================
qboolean IsAmmo(gitem_t *item) {
  return (item->flags & IT_AMMO|IT_PACK);
}

//========================================================
// TRUE if item is armor or 'armor related'
//========================================================
qboolean IsArmor(gitem_t *item) {
  return (item->flags & IT_ARMOR);
}

//========================================================
// TRUE if item is health
//========================================================
qboolean IsHealth(gitem_t *item) {
  return (item->flags & IT_HEALTH);
}

//========================================================
// TRUE if item is weapon
//========================================================
qboolean IsWeapon(gitem_t *item) {
  return (item->flags & IT_WEAPON);
}

//========================================================
// TRUE if item is a 'PowerUp' item
//========================================================
qboolean IsPowerup(gitem_t *item) {
  return (item->flags & IT_POWERUP);
}

//========================================================
// TRUE if item is a 'Key' item
//========================================================
qboolean IsKey(gitem_t *item) {
  return (item->flags & IT_KEY);
}

//========================================================
//================= WEAPON SELECTION =====================
//========================================================

//========================================================
// TRUE if Self switched to that weapon
//========================================================
qboolean CanSwitchToThisWeapon(edict_t *self, gitem_t *weapon) {

  if (HasWeaponInInventory(self,weapon))
    if (HasAmmoForWeapon(self,weapon)) {
      self->client->newweapon=weapon;
      self->client->ammo_index=AmmoIndex(weapon);
      if (weapon!=self->client->pers.weapon) {
        ChangeWeapon(self); }
      return true; }

  return false;
}

//========================================================
// Switch to the first CLOSE weapon you can switch to!
//=======================================================
void GetCloseWeapon(edict_t *self) {

  if (CanSwitchToThisWeapon(self,item_supershotgun))   return;
  if (CanSwitchToThisWeapon(self,item_chaingun))       return;
  if (CanSwitchToThisWeapon(self,item_hyperblaster))   return;
  if (CanSwitchToThisWeapon(self,item_machinegun))     return;
  if (CanSwitchToThisWeapon(self,item_grenades))       return;
  if (CanSwitchToThisWeapon(self,item_bfg))            return;
  if (CanSwitchToThisWeapon(self,item_railgun))        return;
  if (CanSwitchToThisWeapon(self,item_grenadelauncher))return;
  if (CanSwitchToThisWeapon(self,item_shotgun))        return;
  if (CanSwitchToThisWeapon(self,item_rocketlauncher)) return;

  CanSwitchToThisWeapon(self,item_blaster);
}

//========================================================
// Switch to the first FAR weapon you can switch to!
//======================================================
void GetFarWeapon(edict_t *self) {

  if (CanSwitchToThisWeapon(self,item_railgun))        return;
  if (CanSwitchToThisWeapon(self,item_hyperblaster))   return;
  if (CanSwitchToThisWeapon(self,item_chaingun))       return;
  if (CanSwitchToThisWeapon(self,item_bfg))            return;
  if (CanSwitchToThisWeapon(self,item_rocketlauncher)) return;
  if (CanSwitchToThisWeapon(self,item_machinegun))     return;
  if (CanSwitchToThisWeapon(self,item_shotgun))        return;
  if (CanSwitchToThisWeapon(self,item_supershotgun))   return;
  if (CanSwitchToThisWeapon(self,item_grenadelauncher))return;
  if (CanSwitchToThisWeapon(self,item_grenades))       return;

  CanSwitchToThisWeapon(self,item_blaster);
}

//========================================================
// Switch to the first BEST weapon you can switch to!
//========================================================
void GetBestWeapon(edict_t *self) {

  if (CanSwitchToThisWeapon(self,item_bfg))            return;
  if (CanSwitchToThisWeapon(self,item_railgun))        return;
  if (CanSwitchToThisWeapon(self,item_hyperblaster))   return;
  if (CanSwitchToThisWeapon(self,item_rocketlauncher)) return;
  if (CanSwitchToThisWeapon(self,item_chaingun))       return;
  if (CanSwitchToThisWeapon(self,item_supershotgun))   return;
  if (CanSwitchToThisWeapon(self,item_grenadelauncher))return;
  if (CanSwitchToThisWeapon(self,item_machinegun))     return;
  if (CanSwitchToThisWeapon(self,item_shotgun))        return;
  if (CanSwitchToThisWeapon(self,item_grenades))       return;

  CanSwitchToThisWeapon(self,item_blaster);
}


