/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/

#include "stdafx.h"
#include "Life.h"
#include "MainFrm.h"
#include "lifeDoc.h"
#include "compiler.h"
#include "lifeview.h"
#include "mmsystem.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Ccompiler::Ccompiler()
{
	int i;
	for (i = 0; i < 10; i++)
		param[i] = new char[256];
}

Ccompiler::~Ccompiler()
{
	int i;
	for (i = 0; i < 10; i++)
		if (param[i])
			delete [] param[i];
}


int Ccompiler::parse()
{   
   int i, 
		 pindex = 0,			// Global parameter index
		 paramindex = 0;		// Local parameter index
   
	for (i = 0; i < 10; i++)
		memset(param[i], 0, 255);

	i = 0;
	// Get the command:

	if (!ParseCommand(i, param[pindex]))
      return -1;
	// Validate the command:
   commandindex = semantic(param[pindex]);
   if (commandindex < 0)
      return -1;

	pDoc->commandindex = commandindex;

	// Get the command parameters:
	while (pDoc->commandline[i] == ' ') i++;
   if (pDoc->bnf[commandindex].head)
      if (pDoc->commandline[i++] != pDoc->bnf[commandindex].head)
         return 0;
   pindex++;
   while (pDoc->bnf[commandindex].params[paramindex + 1] != BNF_END)
      {
      switch (pDoc->bnf[commandindex].params[paramindex])
         {
         case BNF_INT:
            if (!ParseInt(i, ',', param[pindex]))
               return 0;
            break;
         case BNF_FLOAT:
            if (!ParseFloat(i, ',', param[pindex]))
               return 0;
            break;
         case BNF_STRING:
            if (!ParseString(i, ',', param[pindex]))
               return 0;
            break;
         case BNF_VECTOR:
            if (!ParseVector(i, ',', pindex))
               return 0;
            break;
         case BNF_COMMAND:
            if (!ParseCommand(i, param[pindex]))
               return 0;         
            if (pDoc->commandline[i++] != ',')
               return 0;

            break;
         }       
      if (pindex < 7) 
         pindex++;      
      paramindex++;
      }
   switch (pDoc->bnf[commandindex].params[paramindex])
      {
      case BNF_INT:
         if (!ParseInt(i, pDoc->bnf[commandindex].tail, param[pindex]))
            return 0;
         break;
      case BNF_FLOAT:
         if (!ParseFloat(i, pDoc->bnf[commandindex].tail,param[pindex]))
            return 0;
         break;
      case BNF_STRING:
         if (!ParseString(i, pDoc->bnf[commandindex].tail, param[pindex]))
            return 0;
         break;
      case BNF_VECTOR:
         if (!ParseVector(i, pDoc->bnf[commandindex].tail, pindex))
            return 0;
         break;
      case BNF_COMMAND:
         if (!ParseCommand(i, param[pindex]))
            return 0;
         if (pDoc->bnf[commandindex].tail)
            if (pDoc->commandline[i++] != pDoc->bnf[commandindex].tail)
               return 0;
         break;
      }
   pindex++;
   while (pDoc->commandline[i] == ' ') i++;
   if (pDoc->bnf[commandindex].head)
      if (pDoc->commandline[i] != ';')      
         return -2;
   return pDoc->bnf[commandindex].format;
}

int Ccompiler::semantic(char *c)
{
   int i = 0;
   while (pDoc->bnf[i].syntax)
      {
      if (!strcmp(pDoc->bnf[i].syntax, c))
         return i;
      i++;     
      }
   return -1;
}

int Ccompiler::ParseParam(int &i, char rangestart, char rangeend, char endchar, char *c)
{
   int k = 0, old_i = i;
   while (pDoc->commandline[i] == ' ') i++;      
   while (pDoc->commandline[i] >= rangestart && pDoc->commandline[i] <= rangeend 
          && pDoc->commandline[i] != endchar)
      c[k++] = pDoc->commandline[i++];
   while (pDoc->commandline[i] == ' ') i++;      
   if (pDoc->commandline[i++] != endchar || !k)
      {
      i = old_i;
      return 0;
      }
   return 1;
}

int Ccompiler::ParseCommand(int & i, char *c)
{
   int k = 0, old_i = i;
   while (pDoc->commandline[i] == ' ') i++;
   while ((pDoc->commandline[i] >= 'a' && pDoc->commandline[i] <= 'z') || 
          (pDoc->commandline[i] >= '0' && pDoc->commandline[i] <= '9') ||  
           pDoc->commandline[i] == '-' || pDoc->commandline[i] == '_' || 
           pDoc->commandline[i] == '.')
      c[k++] = pDoc->commandline[i++];
   while (pDoc->commandline[i] == ' ') i++;      
   if (!k)
      {
      i = old_i;
      return 0;
      }
   return 1;
}


int Ccompiler::ParseInt(int & i, char endchar, char *c)
{
   int k = 0, old_k = 0;
   while (pDoc->commandline[i] == ' ') i++;
   if (pDoc->commandline[i] == '+' || pDoc->commandline[i] == '-')
      c[k++] = pDoc->commandline[i++];
   old_k = k;
   while (pDoc->commandline[i] >= '0' && pDoc->commandline[i] <= '9')
      c[k++] = pDoc->commandline[i++];
   if (old_k == k)
      return 0;
   while (pDoc->commandline[i] == ' ') i++;
   if (endchar && pDoc->commandline[i++] != endchar)
      return 0;
   return 1;
}

int Ccompiler::ParseFloat(int & i, char endchar, char *c)
{
   int k = 0, old_k = 0, noint = 0;
   while (pDoc->commandline[i] == ' ') i++;
   if (pDoc->commandline[i] == '+' || pDoc->commandline[i] == '-')
      c[k++] = pDoc->commandline[i++];
   old_k = k;
   while (pDoc->commandline[i] >= '0' && pDoc->commandline[i] <= '9')
      c[k++] = pDoc->commandline[i++];
   if (old_k == k)
      noint = 1;
   if (pDoc->commandline[i] == '.')
      {
      c[k++] = pDoc->commandline[i++];     
      old_k = k;
      while (pDoc->commandline[i] >= '0' && pDoc->commandline[i] <= '9')
            c[k++] = pDoc->commandline[i++];
      if (old_k == k && noint)
         return 0;
      }
   while (pDoc->commandline[i] == ' ') i++;      
   if (endchar && pDoc->commandline[i++] != endchar)
      return 0;
   return 1;
}

int Ccompiler::ParseString(int & i, char endchar, char *c)
{
   int k = 0;
   while (pDoc->commandline[i] == ' ') i++;
   if (pDoc->commandline[i++] != '\"')
      return 0;
   while (pDoc->commandline[i] != '\"')
      c[k++] = pDoc->commandline[i++];
   i++;
   while (pDoc->commandline[i] == ' ') i++;
   if (endchar && pDoc->commandline[i++] != endchar)
      return 0;
   return 1;
}

int Ccompiler::ParseVector(int & i, char endchar, int &j)
{     
     while (pDoc->commandline[i] == ' ') i++;
     if (pDoc->commandline[i++] =! '<')
         return 0;   
     if (!ParseFloat(i, ',', param[j]))
         return 0;
     j++;
     if (!ParseFloat(i, ',', param[j]))
         return 0;
     j++;
     if (!ParseFloat(i, '>', param[j]))
         return 0;
     while (pDoc->commandline[i] == ' ') i++;
   if (endchar && pDoc->commandline[i++] != endchar)
      return 0;
   return 1;
}


void Ccompiler::ShowUsage(int i)
{
   int k = 0, j = 0, z = 0;
   char x[256];
   if (!pDoc->bnf[i].usage)
      return;
   sprintf(pDoc->dline[pDoc->ly], ">> &c660 USAGE &r <<");
   NewLine();
   if (pDoc->bnf[i].usage)
      {
      while (pDoc->bnf[i].usage[j])
			{
			while (pDoc->bnf[i].usage[j] && pDoc->bnf[i].usage[j] != '\n' && k < 255)
					x[k++] = pDoc->bnf[i].usage[j++];
			x[k] = 0;
			if (!z)
				{
				z = 1;
				sprintf(pDoc->dline[pDoc->ly], "&c660      %s", x);
				NewLine();               
				}
			else
				{
				sprintf(pDoc->dline[pDoc->ly], "     %s", x);
				NewLine();
				}
			j++;
			k = 0;
			}
		}
		/*
      while (pDoc->bnf[i].usage[j])
         {
         while (pDoc->bnf[i].usage[j] && pDoc->bnf[i].usage[j] != '\n' && k < 255)
            x[k++] = pDoc->bnf[i].usage[j++];
         x[k] = 0;
         j++;
         k = 0;
         sprintf(pDoc->dline[pDoc->ly], x);
         NewLine();
         }
      }
		*/
}


int Ccompiler::ParamInt(char *c)
{
   int k = 0, neg = 0;
   if (*c == '-')
      {c++; neg = 1;}
   else if (*c == '+')
      c++;
   while (*c)
      k = k * 10 + (*(c++) - '0');
   if (neg) k = -k;
   return k;
}

float Ccompiler::ParamFloat(char * c)
{
   float k = 0;
   int neg = 0, decimal = 0;
   if (*c == '-')
      {c++; neg = 1;}
   else if (*c == '+')
      c++;
   while (*c && *c != '.')
      k = k * 10 + (*(c++) - '0');
   if (*c == '.')
      {
      c++;
      decimal = 10;
      while (*c)
         {
         k += (float)(*(c++) - '0') / decimal;
         decimal *= 10;
         }
      }
   if (neg) k = -k;
   return k;
}

char * Ccompiler::ParamString(char *realc)
{
	char v[256] = {0}, *c = realc;
   int k = 0;
   while (*c)
      {
      if (*c == '\\' && *(c+1) == 'n')
         {
         c+=2;
         v[k++] = '\n';
         }
      else
         v[k++] = *(c++);
      }
   v[k] = 0;
   memcpy(realc, v, 255);
   return realc;
}

//*****************************************************************************//

int Ccompiler::Compile()
{
   CFile X,		// Input SCR file
			Y;		// Ouput DAT file
   char c;		// Read Character
	char st1, st2;
   int i = 0, 
		 linenumber = 0,	// Current line number
		 parint = 0,		// Parameter Interger
		 parfloat = 0,		// Paramtere Float
		 parvector = 0,	// Paramter Vec3_t	
		 parchar = 0;		// Paramter Character/String

   pDoc->intercepts = 0;	// Number of intercepts is now 0
   CompileLabels();
   if (!X.Open(pDoc->FileIn, CFile::typeText|CFile::modeRead))   
      return -2;
   if (!Y.Open(pDoc->FileOut, CFile::typeBinary|CFile::modeWrite|CFile::shareExclusive|CFile::modeCreate))
      return -3;
   Y.Write(&pDoc->current_instruction, sizeof(pDoc->current_instruction));
   Y.Write(&pDoc->intercepts, sizeof(pDoc->intercepts));
   i = 0;
   while (X.Read (&c, 1))
      {      
      if (c == '\n')
         {
         linenumber++;
         //AfxMessageBox(pDoc->commandline);
         pDoc->commandline[i] = 0;
         if (i > 0)
            switch (CompileLine())
               {   
               case 0:
						if (pDoc->env.errorsound)
							{
							char x[256];
							sprintf (x,"%s\\doh.wav", pDoc->PathName);
							sndPlaySound(x, SND_SYNC);
							}	
						else
							AfxMessageBox("Compile was unsuccessfull. Please check your source file for any errors. If you are need help on script commands, please check the LifeScript webpage by clicking on the page icon. There is also a list of commands available from the program.\n");
                  sprintf(pDoc->dline[pDoc->ly], "&c700 Error encountered at line &c660 %d", linenumber);
                  NewLine();
                  return -1;
               case FORMAT_SCRIPT:
						st1 = strlen(pDoc->script.ParamString[0]);
						st2 = strlen(pDoc->script.ParamString[1]);
						Y.Write(&pDoc->script.command, sizeof(pDoc->script.command));
						Y.Write(&pDoc->script.ParamInt[0], sizeof(pDoc->script.ParamInt[0]));
						Y.Write(&pDoc->script.ParamInt[1], sizeof(pDoc->script.ParamInt[1]));
						Y.Write(&pDoc->script.ParamFloat[0], sizeof(pDoc->script.ParamFloat[0]));
						Y.Write(&pDoc->script.ParamFloat[1], sizeof(pDoc->script.ParamFloat[1]));
						Y.Write(&st1, 1);
						Y.Write(&st2, 1);
						Y.Write(&pDoc->script.ParamString[0], st1);
						Y.Write(&pDoc->script.ParamString[1], st2);
						Y.Write(&pDoc->script.ParamVector, sizeof(pDoc->script.ParamVector));
               }
         i = 0;
         }
      else 
			{
			if (c == '\t') c = ' ';
			if (i < 256)
				pDoc->commandline[i++] = c;
			}
      }
	linenumber++;
	//AfxMessageBox(pDoc->commandline);
   pDoc->commandline[i] = 0;
	if (i > 0)
		switch (CompileLine())
			{   
			case 0:
				if (pDoc->env.errorsound)
					{
					char x[256];
					sprintf (x,"%s\\doh.wav", pDoc->PathName);
					sndPlaySound(x, SND_SYNC);
					}	
				else
					AfxMessageBox("Compile was unsuccessfull. Please check your source file for any errors. If you are need help on script commands, please check the LifeScript webpage by clicking on the page icon. There is also a list of commands available from the program.\n");
            sprintf(pDoc->dline[pDoc->ly], "&c700 Error encountered at line &c660 %d", linenumber);
            NewLine();
            return -1;
         case FORMAT_SCRIPT:
				st1 = strlen(pDoc->script.ParamString[0]);
				st2 = strlen(pDoc->script.ParamString[1]);
				Y.Write(&pDoc->script.command, sizeof(pDoc->script.command));
            Y.Write(&pDoc->script.ParamInt[0], sizeof(pDoc->script.ParamInt[0]));
            Y.Write(&pDoc->script.ParamInt[1], sizeof(pDoc->script.ParamInt[1]));
            Y.Write(&pDoc->script.ParamFloat[0], sizeof(pDoc->script.ParamFloat[0]));
            Y.Write(&pDoc->script.ParamFloat[1], sizeof(pDoc->script.ParamFloat[1]));
            Y.Write(&st1, 1);
            Y.Write(&st2, 1);
            Y.Write(&pDoc->script.ParamString[0], st1);
            Y.Write(&pDoc->script.ParamString[1], st2);
            Y.Write(&pDoc->script.ParamVector, sizeof(pDoc->script.ParamVector));
         }
   Y.Seek(0L, 0);
   Y.Write(&pDoc->current_instruction, sizeof(pDoc->current_instruction));
   Y.Write(&pDoc->intercepts, sizeof(pDoc->intercepts));
   Y.Close();
   X.Close();
   sprintf(pDoc->dline[pDoc->ly], "Number of intercetps %d out of possible 100", pDoc->intercepts);
   NewLine();
   return 1;
}

int Ccompiler::CompileLabels()
{
   CFile X;			// Input SCR File
   char c;			// Read character
	short quotes = 0;
   int i;
   pDoc->labels = 0;

	// Initialize all the labels and their vectors
   for (i = 0; i < 200; i++)
      {
      pDoc->history[i].command = 0;
      memset(pDoc->history[i].labelname, 0, 255);
      }
   for (i = 0; i < 100; i++)
      memset(pDoc->on_uses[i].activator, 0, 255);
   i = 0;
   pDoc->current_instruction = 0;
   if (!X.Open(pDoc->FileIn, CFile::typeText|CFile::modeRead))   
      return -2;
   while (X.Read (&c, 1))
      {      
      if (c == '\n')
         {
         pDoc->commandline[i] = 0;
         if (i > 0)
            {
				// Remove the comments && trailing white spaces:   
				validate_command(pDoc->commandline);
            if (pDoc->commandline[0])
					{
               switch(parse())
                  {
                  case FORMAT_COMPILER:
                     CompilerLine();                     
                     break;
                  case FORMAT_SCRIPT:
                     pDoc->current_instruction++;
                     break;
                  }
					}
            }
         i = 0;
         }
      else 
			{
			if (c == '\t') c = ' ';
			if (i < 256)
				pDoc->commandline[i++] = c;
			}
      }
   X.Close();
   pDoc->current_instruction = 0;
   return 0;
}

int Ccompiler::CompileLine()
{
   pMainWnd = (CMainFrame *) AfxGetMainWnd();
   short quotes = 0;
   
   // Remove the comment and trailing white spaces:
	validate_command(pDoc->commandline);
   if (pDoc->commandline[0])
      switch (parse())
         {
         case -2:
            sprintf(pDoc->dline[pDoc->ly], "No EOL in current statement. Use semicolon.");
            NewLine();
            return 0;
            break;
         case -1:
            sprintf(pDoc->dline[pDoc->ly], "Bad instruction or system data: %s", pDoc->commandline);
            NewLine();
            return 0;
            break;
         case 0:
            ShowUsage(commandindex);
            return 0;
            break;
         case FORMAT_EDITOR:
            ApplyCommand();
            break;
         case FORMAT_SCRIPT:
            pDoc->current_instruction++;
            if (Opcode())
               return FORMAT_SCRIPT;
            return 0;
            break;
         case FORMAT_COMPILER:
            /*   
            if (CompilerLine())
               return FORMAT_COMPILER;
            return 0;
            */
            break;
         }  
    return 1;
}

int Ccompiler::Opcode()
{
   short par_int = 0, 
         par_float = 0, 
         par_vector = 0, 
         par_string = 0, 
         i = 0,
         j = 1;

   memset(&pDoc->script, 0, sizeof(pDoc->script));
	pDoc->script.command = commandindex;
   while (pDoc->bnf[commandindex].params[i] != BNF_END)
      {
      switch (pDoc->bnf[commandindex].params[i])
         {
         case BNF_INT:
            if (par_int < 2)
               pDoc->script.ParamInt[par_int++] = ParamInt(param[j++]);
            else
               return 0;
            break;
         case BNF_FLOAT:
            if (par_float < 2)
               pDoc->script.ParamFloat[par_float++] = ParamFloat(param[j++]);
            else
               return 0;
            break;
         case BNF_STRING:
            if (par_string < 4)
               strcpy(pDoc->script.ParamString[par_string++], ParamString(param[j++]));
            else
               return 0;
            break;
         case BNF_VECTOR:
            if (!par_vector)
               {
               pDoc->script.ParamVector[0] = ParamFloat(param[j++]);
               pDoc->script.ParamVector[1] = ParamFloat(param[j++]);
               pDoc->script.ParamVector[2] = ParamFloat(param[j++]);
               }
            else
               return 0;
            break;
         case BNF_COMMAND:
            if (par_string < 4)
               strcpy(pDoc->script.ParamString[par_string++], ParamString(param[j++]));
            else
               return 0;
            break;
         }
      i++;
      }  

   if (!strcmp(param[0], "say"))
      {
      if (!strcmp(pDoc->script.ParamString[1], "attn_none"))
         pDoc->script.ParamInt[0] = 0;
      else if (!strcmp(pDoc->script.ParamString[1], "attn_norm"))
         pDoc->script.ParamInt[0] = 1;
      else if (!strcmp(pDoc->script.ParamString[1], "attn_idle"))
         pDoc->script.ParamInt[0] = 2;
      else if (!strcmp(pDoc->script.ParamString[1], "attn_static"))
         pDoc->script.ParamInt[0] = 3;
      else 
         return 0;
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "attack"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[1] = pDoc->script.ParamInt[0];
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      } 
   else if (!strcmp(param[0], "rotate_smooth"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      } 
   else if (!strcmp(param[0], "say_slave"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {         
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {         
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      if (!strcmp(pDoc->script.ParamString[2], "attn_none"))
         pDoc->script.ParamInt[1] = 0;
      else if (!strcmp(pDoc->script.ParamString[2], "attn_norm"))
         pDoc->script.ParamInt[1] = 1;
      else if (!strcmp(pDoc->script.ParamString[2], "attn_idle"))
         pDoc->script.ParamInt[1] = 2;
      else if (!strcmp(pDoc->script.ParamString[2], "attn_static"))
         pDoc->script.ParamInt[1] = 3;
      else 
         return 0;
      } 
   else if (!strcmp(param[0], "hand"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      if (!strcmp(pDoc->script.ParamString[1], "health"))
         pDoc->script.ParamInt[1] = 0;         
      else if (!strcmp(pDoc->script.ParamString[1], "armor_light"))
         pDoc->script.ParamInt[1] = 1;         
      else if (!strcmp(pDoc->script.ParamString[1], "armor_medium"))
         pDoc->script.ParamInt[1] = 2;         
      else if (!strcmp(pDoc->script.ParamString[1], "armor_heavy"))
         pDoc->script.ParamInt[1] = 3;
      else
         return 0;
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "start"))
      {
      pDoc->script.ParamInt[0] = GetHistory(pDoc->script.ParamString[0]);    
      if (pDoc->script.ParamInt[0] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "start: Label %s not found!", pDoc->script.ParamString[0]);
         NewLine();
         return 0;
         }
      memset(pDoc->script.ParamString[0], 0, 255);
      }
   else if (!strcmp(param[0], "goto"))
      {
      pDoc->script.ParamInt[0] = GetHistory(pDoc->script.ParamString[0]);    
      if (pDoc->script.ParamInt[0] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "goto: Label %s not found!", pDoc->script.ParamString[0]);
         NewLine();
         return 0;
         }
      memset(pDoc->script.ParamString[0], 0, 255);
      }
   else if (!strcmp(param[0], "on_block"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".client"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".none"))
         {
         pDoc->script.ParamInt[1] = -1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		if (pDoc->script.ParamInt[1] != -1)
			{
			pDoc->script.ParamInt[1] = GetHistory(pDoc->script.ParamString[1]);
			if (pDoc->script.ParamInt[1] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "on_block: Label %s not found!", pDoc->script.ParamString[1]);
				NewLine();         
				return 0;
				}
			}
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "on_touch"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".client"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".any"))
         {
         pDoc->script.ParamInt[0] = 2;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".none"))
         {
         pDoc->script.ParamInt[1] = -1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      if (pDoc->script.ParamInt[1] != -1)
			{
			pDoc->script.ParamInt[1] = GetHistory(pDoc->script.ParamString[1]);
			if (pDoc->script.ParamInt[1] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "on_touch: Label %s not found!", pDoc->script.ParamString[1]);
				NewLine();         
				return 0;
				}
			}
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "on_see"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".client"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".none"))
         {
         pDoc->script.ParamInt[1] = -1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		if (pDoc->script.ParamInt[1] != -1)
			{
			pDoc->script.ParamInt[1] = GetHistory(pDoc->script.ParamString[1]);
			if (pDoc->script.ParamInt[1] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "on_see: Label %s not found!", pDoc->script.ParamString[1]);
				NewLine();         
				return 0;
				}
			}
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "on_pain"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".client"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".any"))
         {
         pDoc->script.ParamInt[0] = 2;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".none"))
         {
         pDoc->script.ParamInt[1] = -1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		if (pDoc->script.ParamInt[1] != -1)
			{
			pDoc->script.ParamInt[1] = GetHistory(pDoc->script.ParamString[1]);
			if (pDoc->script.ParamInt[1] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "on_pain: Label %s not found!", pDoc->script.ParamString[1]);
				NewLine();         
				return 0;
				}
			}
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "on_use"))
      {
      if (!strcmp(pDoc->script.ParamString[1], ".none"))
			{
         pDoc->script.ParamInt[0] = -1;
			sprintf(pDoc->dline[pDoc->ly], "User %s intercept killed.", pDoc->script.ParamString[0]);
			NewLine();
			}
      else
			{
			pDoc->script.ParamInt[0] = GetHistory(pDoc->script.ParamString[1]);
			if	(pDoc->script.ParamInt[0] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "on_use: Label %s not found!", pDoc->script.ParamString[1]);
				NewLine();         
				return 0;
				}
			add_on_use(pDoc->script.ParamString[0]);
			sprintf(pDoc->dline[pDoc->ly], "When used by %s goto %s (ip%d)", pDoc->script.ParamString[0], pDoc->script.ParamString[1], pDoc->script.ParamInt[0]);
			NewLine();
			}
		memset(pDoc->script.ParamString[1], 0, 255);
		}
   else if (!strcmp(param[0], "look_at"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      }   
   else if (!strcmp(param[0], "action_target"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[1] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      }   
   else if (!strcmp(param[0], "spawn"))
      {
      if (!strcmp(pDoc->script.ParamString[1], ".none"))
         memset(pDoc->script.ParamString[1], 0, 255);
      }   
   else if (!strcmp(param[0], "use"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      if (!strcmp(pDoc->script.ParamString[1], ".self"))
         {
         pDoc->script.ParamInt[1] = 1;
         memset(pDoc->script.ParamString[1], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[1], ".activator"))
         {
         pDoc->script.ParamInt[1] = 255;
         memset(pDoc->script.ParamString[1], 0, 255);
         }
      }   
   else if (!strcmp(param[0], "multi_use"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      }   
   else if (!strcmp(param[0], "run"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      }   
   else if (!strcmp(param[0], "run_slave"))
      {
      if (!strcmp(pDoc->script.ParamString[1], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[1], 0, 255);
         }
      }   
   else if (!strcmp(param[0], "walk_slave"))
      {
      if (!strcmp(pDoc->script.ParamString[1], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[1], 0, 255);
         }
      }   
   else if (!strcmp(param[0], "walk"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      }   
   else if (!strcmp(param[0], "sound_loop"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".none"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		}
   else if (!strcmp(param[0], "sound_loop_slave"))
      {
      if (!strcmp(pDoc->script.ParamString[1], ".none"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[1], 0, 255);
         }
		}
   else if (!strcmp(param[0], "move"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".origin"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		}
   else if (!strcmp(param[0], "move_slave"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      if (!strcmp(pDoc->script.ParamString[1], ".origin"))
         {
         pDoc->script.ParamInt[1] = 1;
         memset(pDoc->script.ParamString[1], 0, 255);
         }
		}
   else if (!strcmp(param[0], "set_field"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      pDoc->script.ParamInt[1] = GetFieldTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "set_field: Invalid Field Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamFloat[1] = (float) GetOperatorTag(pDoc->script.ParamString[2]);
      if (pDoc->script.ParamFloat[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "set_field: Invalid Operator Tag: %s", pDoc->script.ParamString[2]);
         NewLine();         
         return 0;
         }		
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "if"))
      {   
		if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      pDoc->script.ParamInt[1] = GetFieldTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "if: Invalid Field Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamFloat[1] = (float) GetCheckTag(pDoc->script.ParamString[2]);
      if (pDoc->script.ParamFloat[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "if: Invalid Operator Tag: %s", pDoc->script.ParamString[2]);
         NewLine();         
         return 0;
         }		
		if (!strcmp(pDoc->script.ParamString[3], ".return"))
			pDoc->script.ParamVector[0] = -1;
		else
			{
			pDoc->script.ParamVector[0] = (float) GetHistory(pDoc->script.ParamString[3]);
			if	(pDoc->script.ParamVector[0] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "if: Label %s not found!", pDoc->script.ParamString[3]);
				NewLine();         
				return 0;
				}
			}
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "on_drop"))
      {
      pDoc->script.ParamInt[0] = GetHistory(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[0] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "on_drop: Label %s not found!", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      memset(pDoc->script.ParamString[0], 0, 255);
		}
	else if (!strcmp(param[0], "set_model"))
		{
		if (!strcmp(pDoc->script.ParamString[0], ".none"))
			{
         memset(pDoc->script.ParamString[0], 0, 255);
			pDoc->script.ParamInt[1] = 1;
			}
		}
	else if (!strcmp(param[0], "pickup"))
		{
		if (!strcmp(pDoc->script.ParamString[0], "drop_on"))
			pDoc->script.ParamInt[0] = 2;
		else if (!strcmp(pDoc->script.ParamString[0], "drop_off"))
			pDoc->script.ParamInt[0] = 0;
		else if (!strcmp(pDoc->script.ParamString[0], "drop_return"))
			pDoc->script.ParamInt[0] = 1;
		else 
			{
			sprintf(pDoc->dline[pDoc->ly], "pickup: Invalid droppable %s!", pDoc->script.ParamString[0]);
			NewLine();         
			return 0;
			}
		memset(pDoc->script.ParamString[0], 0, 255);
		}
	else if (!strcmp(param[0], "set_solid"))
		{
		if (!strcmp(pDoc->script.ParamString[0], "solid_not"))
			pDoc->script.ParamInt[0] = 0;
		else if (!strcmp(pDoc->script.ParamString[0], "solid_trigger"))
			pDoc->script.ParamInt[0] = 1;
		else if (!strcmp(pDoc->script.ParamString[0], "solid_bbox"))
			pDoc->script.ParamInt[0] = 2;
		else if (!strcmp(pDoc->script.ParamString[0], "solid_bsp"))
			pDoc->script.ParamInt[0] = 3;
		else 
			{
			sprintf(pDoc->dline[pDoc->ly], "set_solid: Invalid solid %s!", pDoc->script.ParamString[0]);
			NewLine();         
			return 0;
			}
		memset(pDoc->script.ParamString[0], 0, 255);
		}
	else if (!strcmp(param[0], "set_movetype"))
		{
		if (!strcmp(pDoc->script.ParamString[0], "movetype_none"))
			pDoc->script.ParamInt[0] = 0;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_noclip"))
			pDoc->script.ParamInt[0] = 1;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_push"))
			pDoc->script.ParamInt[0] = 2;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_stop"))
			pDoc->script.ParamInt[0] = 3;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_walk"))
			pDoc->script.ParamInt[0] = 4;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_step"))
			pDoc->script.ParamInt[0] = 5;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_fly"))
			pDoc->script.ParamInt[0] = 6;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_toss"))
			pDoc->script.ParamInt[0] = 7;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_flymissile"))
			pDoc->script.ParamInt[0] = 8;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_bounce"))
			pDoc->script.ParamInt[0] = 9;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_roll"))
			pDoc->script.ParamInt[0] = 10;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_flyricochet"))
			pDoc->script.ParamInt[0] = 11;
		else if (!strcmp(pDoc->script.ParamString[0], "movetype_flyarc"))
			pDoc->script.ParamInt[0] = 12;
		else 
			{
			sprintf(pDoc->dline[pDoc->ly], "set_movetype: Invalid movement type %s!", pDoc->script.ParamString[0]);
			NewLine();         
			return 0;
			}
		memset(pDoc->script.ParamString[0], 0, 255);
		}
	else if (!strcmp(param[0], "animate"))
		{
		if (!strcmp(pDoc->script.ParamString[0], "one_shot"))
			pDoc->script.ParamFloat[0] = 1;
		else if (!strcmp(pDoc->script.ParamString[0], "looped"))
			pDoc->script.ParamFloat[0] = 2;
		else if (!strcmp(pDoc->script.ParamString[0], ".none"))
			pDoc->script.ParamFloat[0] = 0;
		else 
			{
			sprintf(pDoc->dline[pDoc->ly], "animate: Invalid format %s!", pDoc->script.ParamString[0]);
			NewLine();         
			return 0;
			}
		memset(pDoc->script.ParamString[0], 0, 255);
		}
   else if (!strcmp(param[0], "class.set_string"))
      {
      pDoc->script.ParamInt[1] = GetClassStringTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "class.set_string: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      memset(pDoc->script.ParamString[0], 0, 255);
      }
   else if (!strcmp(param[0], "class.set_value"))
      {
      pDoc->script.ParamInt[1] = GetClassTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "class.set_value: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamFloat[1] = (float) GetOperatorTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamFloat[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "class.set_value: Invalid Operator Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }		
      memset(pDoc->script.ParamString[0], 0, 255);
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "class.if"))
      {   
      pDoc->script.ParamInt[1] = GetClassTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "class.if: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamFloat[1] = (float) GetCheckTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamFloat[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "class.if: Invalid Operator Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }		
		if (!strcmp(pDoc->script.ParamString[2], ".return"))
			pDoc->script.ParamVector[0] = -1;
		else
			{
			pDoc->script.ParamVector[0] = (float) GetHistory(pDoc->script.ParamString[2]);
			if	(pDoc->script.ParamVector[0] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "class.if: Label %s not found!", pDoc->script.ParamString[2]);
				NewLine();         
				return 0;
				}
			}
      memset(pDoc->script.ParamString[0], 0, 255);
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "level.set_string"))
      {
      pDoc->script.ParamInt[1] = GetLevelStringTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "level.set_string: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      memset(pDoc->script.ParamString[0], 0, 255);
      }
   else if (!strcmp(param[0], "level.set_value"))
      {
      pDoc->script.ParamInt[1] = GetLevelTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "level.set_value: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamFloat[1] = (float) GetOperatorTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamFloat[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "level.set_value: Invalid Operator Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }		
      memset(pDoc->script.ParamString[0], 0, 255);
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "level.if"))
      {   
      pDoc->script.ParamInt[1] = GetClassTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "level.if: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamFloat[1] = (float) GetCheckTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamFloat[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "level.if: Invalid Operator Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }		
		if (!strcmp(pDoc->script.ParamString[2], ".return"))
			pDoc->script.ParamVector[0] = -1;
		else
			{
			pDoc->script.ParamVector[0] = (float) GetHistory(pDoc->script.ParamString[2]);
			if	(pDoc->script.ParamVector[0] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "level.if: Label %s not found!", pDoc->script.ParamString[2]);
				NewLine();         
				return 0;
				}
			}
      memset(pDoc->script.ParamString[0], 0, 255);
      memset(pDoc->script.ParamString[1], 0, 255);
      }
	else if (!strcmp(param[0], "model_slave"))
		{
		if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		if (!strcmp(pDoc->script.ParamString[1], "modelindex"))
			pDoc->script.ParamInt[1] = 1;
		else if (!strcmp(pDoc->script.ParamString[1], "modelindex2"))
			pDoc->script.ParamInt[1] = 2;
		else if (!strcmp(pDoc->script.ParamString[1], "modelindex3"))
			pDoc->script.ParamInt[1] = 3;
		else if (!strcmp(pDoc->script.ParamString[1], "modelindex4"))
			pDoc->script.ParamInt[1] = 4;
		else 
			{
			sprintf(pDoc->dline[pDoc->ly], "model_slave: Invalid model tag %s!", pDoc->script.ParamString[1]);
			NewLine();         
			return 0;
			}
		if (!strcmp(pDoc->script.ParamString[2], ".none"))
			{
			pDoc->script.ParamFloat[0] = 1;
			memset (pDoc->script.ParamString[2], 0, 255);
			}
		strcpy(pDoc->script.ParamString[1], pDoc->script.ParamString[2]);
		}
   else if (!strcmp(param[0], "team.set_value"))
      {
      pDoc->script.ParamInt[1] = GetTeamTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.set_value: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamFloat[1] = (float) GetOperatorTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamFloat[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.set_value: Invalid Operator Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }		
      memset(pDoc->script.ParamString[0], 0, 255);
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "team.if"))
      {   
      pDoc->script.ParamInt[1] = GetTeamTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.if: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamFloat[1] = (float) GetCheckTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamFloat[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.if: Invalid Operator Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }		
		if (!strcmp(pDoc->script.ParamString[2], ".return"))
			pDoc->script.ParamVector[0] = -1;
		else
			{
			pDoc->script.ParamVector[0] = (float) GetHistory(pDoc->script.ParamString[2]);
			if	(pDoc->script.ParamVector[0] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "team.if: Label %s not found!", pDoc->script.ParamString[2]);
				NewLine();         
				return 0;
				}
			}
      memset(pDoc->script.ParamString[0], 0, 255);
      memset(pDoc->script.ParamString[1], 0, 255);
      }
   else if (!strcmp(param[0], "on_die"))
      {
      if (!strcmp(pDoc->script.ParamString[0], ".client"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".any"))
         {
         pDoc->script.ParamInt[0] = 2;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      else if (!strcmp(pDoc->script.ParamString[0], ".none"))
         {
         pDoc->script.ParamInt[1] = -1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
      if (pDoc->script.ParamInt[1] != -1)
			{
			pDoc->script.ParamInt[1] = GetHistory(pDoc->script.ParamString[1]);
			if (pDoc->script.ParamInt[1] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "on_die: Label %s not found!", pDoc->script.ParamString[1]);
				NewLine();         
				return 0;
				}
			}
      memset(pDoc->script.ParamString[1], 0, 255);
      }


	else if (!strcmp(param[0], "print"))
		{
		if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		}	

   else if (!strcmp(param[0], "team.respawn"))
      {   
      pDoc->script.ParamInt[1] = GetFieldTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.respawn: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamFloat[1] = (float) GetCheckTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamFloat[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.respawn: Invalid Operator Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }		
      memset(pDoc->script.ParamString[0], 0, 255);
      memset(pDoc->script.ParamString[1], 0, 255);
      }

   else if (!strcmp(param[0], "team.damage"))
      {   
      pDoc->script.ParamInt[1] = GetFieldTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.damage: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamVector[0] = (float) GetCheckTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamVector[0] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.damage: Invalid Operator Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }		
      memset(pDoc->script.ParamString[0], 0, 255);
      memset(pDoc->script.ParamString[1], 0, 255);
      }

   else if (!strcmp(param[0], "team.score"))
      {   
      pDoc->script.ParamInt[1] = GetFieldTag(pDoc->script.ParamString[0]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.score: Invalid Field Tag: %s", pDoc->script.ParamString[0]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamVector[0] = (float) GetCheckTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamVector[0] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.score: Invalid Operator Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }		
      memset(pDoc->script.ParamString[0], 0, 255);
      memset(pDoc->script.ParamString[1], 0, 255);
      }

   else if (!strcmp(param[0], "team.print"))
      {   
      pDoc->script.ParamInt[1] = GetFieldTag(pDoc->script.ParamString[1]);
      if (pDoc->script.ParamInt[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.print: Invalid Field Tag: %s", pDoc->script.ParamString[1]);
         NewLine();         
         return 0;
         }
      pDoc->script.ParamFloat[1] = (float) GetCheckTag(pDoc->script.ParamString[2]);
      if (pDoc->script.ParamFloat[1] == -1)
         {
         sprintf(pDoc->dline[pDoc->ly], "team.print: Invalid Operator Tag: %s", pDoc->script.ParamString[2]);
         NewLine();         
         return 0;
         }		
      memset(pDoc->script.ParamString[1], 0, 255);
      }
	else if (!strcmp(param[0], "drop"))
		{
		if (!strcmp(pDoc->script.ParamString[0], ".self"))
         {
         pDoc->script.ParamInt[0] = 1;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		else if (!strcmp(pDoc->script.ParamString[0], ".activator"))
         {
         pDoc->script.ParamInt[0] = 255;
         memset(pDoc->script.ParamString[0], 0, 255);
         }
		if (!strcmp(pDoc->script.ParamString[1], ".carried"))
         {
         pDoc->script.ParamInt[1] = 255;
         memset(pDoc->script.ParamString[1], 0, 255);
         }
		if (!strcmp(pDoc->script.ParamString[1], ".self"))
         {
         pDoc->script.ParamInt[1] = 1;
         memset(pDoc->script.ParamString[1], 0, 255);
         }
		if (!strcmp(pDoc->script.ParamString[2], "drop_on"))
			pDoc->script.ParamFloat[0] = 2;
		else if (!strcmp(pDoc->script.ParamString[2], "drop_off"))
			pDoc->script.ParamFloat[0] = 0;
		else if (!strcmp(pDoc->script.ParamString[2], "drop_return"))
			pDoc->script.ParamFloat[0] = 1;
		else 
			{
			sprintf(pDoc->dline[pDoc->ly], "pickup: Invalid droppable %s!", pDoc->script.ParamString[2]);
			NewLine();         
			return 0;
			}
		}	
   else if (!strcmp(param[0], "if_onsameteam"))
      {   
		if (!strcmp(pDoc->script.ParamString[0], ".return"))
			pDoc->script.ParamVector[0] = -1;
		else
			{
			pDoc->script.ParamInt[0] = GetHistory(pDoc->script.ParamString[0]);
			if	(pDoc->script.ParamInt[0] == -1)
				{
				sprintf(pDoc->dline[pDoc->ly], "if_onsameteam: Label %s not found!", pDoc->script.ParamString[0]);
				NewLine();         
				return 0;
				}
			}
      memset(pDoc->script.ParamString[0], 0, 255);
      }
	
	if (pDoc->debug)
      {
      sprintf(pDoc->dline[pDoc->ly], "Script:");
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "command: %d", pDoc->script.command);
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "Int1: %d", pDoc->script.ParamInt[0]);
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "Int2: %d", pDoc->script.ParamInt[1]);
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "Float1: %f", pDoc->script.ParamFloat[0]);
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "Float2: %f", pDoc->script.ParamFloat[1]);
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "Vector: <%f, %f, %f>", pDoc->script.ParamVector[0], pDoc->script.ParamVector[1], pDoc->script.ParamVector[2]);
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "String1: %s", pDoc->script.ParamString[0]);
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "String2: %s", pDoc->script.ParamString[1]);
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "-----");
      NewLine();
      }
   return 1;
}

int Ccompiler::GetHistory(char *c)
{
   short i;
   for (i = 0; i < pDoc->labels; i++)
      {
      if (!strcmp(pDoc->history[i].labelname, c))
         return pDoc->history[i].command;
      }
   return -1;
}

int Ccompiler::GetFieldTag(char *c)
{
	short i;
	for (i = 0; pDoc->field_tag[i].name; i++)
		if (!strcmp(pDoc->field_tag[i].name, c))
			return i;
	return -1;
}

int Ccompiler::GetOperatorTag(char * c)
{
	short i;
	for (i = 0; pDoc->operator_tag[i].name; i++)
		if (!strcmp(pDoc->operator_tag[i].name, c))
			return i;
	return -1;
}

int Ccompiler::GetCheckTag(char * c)
{
	short i;
	for (i = 0; pDoc->check_tag[i].name; i++)
		if (!strcmp(pDoc->check_tag[i].name, c))
			return i;
	return -1;
}

int Ccompiler::GetClassStringTag(char *c)
{
	short i;
	for (i = 0; pDoc->class_string_tag[i].name; i++)
		if (!strcmp(pDoc->class_string_tag[i].name, c))
			return i;
	return -1;
}

int Ccompiler::GetClassTag(char *c)
{
	short i;
	for (i = 0; pDoc->class_tag[i].name; i++)
		if (!strcmp(pDoc->class_tag[i].name, c))
			return i;
	return -1;
}

int Ccompiler::GetLevelTag(char *c)
{
	short i;
	for (i = 0; pDoc->level_tag[i].name; i++)
		if (!strcmp(pDoc->level_tag[i].name, c))
			return i;
	return -1;
}

int Ccompiler::GetLevelStringTag(char *c)
{
	short i;
	for (i = 0; pDoc->level_string_tag[i].name; i++)
		if (!strcmp(pDoc->level_string_tag[i].name, c))
			return i;
	return -1;
}

int Ccompiler::GetTeamTag(char * c)
{
	short i;
	for (i = 0; pDoc->team_tag[i].name; i++)
		if (!strcmp(pDoc->team_tag[i].name, c))
			return i;
	return -1;
}

int Ccompiler::CompilerLine()
{
	if (*(param[0]))
	if (!strcmp(param[0], "label"))
		{
		pDoc->history[pDoc->labels].command = pDoc->current_instruction;
		strcpy(pDoc->history[pDoc->labels].labelname, ParamString(param[1]));
		pDoc->labels++;
		return 1;
		}
   return 0;         
}

void Ccompiler::add_on_use(char * activator)
{
	if (!activator)
		return;
   for (short i = 0; i < pDoc->intercepts; i++)
      if (!strcmpi(activator, pDoc->on_uses[i].activator))
         return;
   strcpy(pDoc->on_uses[pDoc->intercepts++].activator, activator);
}

void Ccompiler::finalintercept()
{
   sprintf(pDoc->dline[pDoc->ly], "Intercept Table:");
   NewLine();
}


void Ccompiler::validate_command(char * c)
{
	// Remove comments && trailing spaces:
	short i, quotes = 0;
	for (i = 0; c[i] && i < 255; i++)
		switch (c[i])
			{
			case '\"':
				if (quotes)
					quotes = 0;
				else
					quotes = 1;
				break;
			case '/':
				if (!quotes && (c[i + 1] == '/'))
					while (i < 255)
						c[i++] = 0;
				break;
			}

	// Remove the trailing command line white spaces.
   for (i = strlen(c); i >= 0 && c[i] <= 32; i--)
		c[i] = 0;
}


//***********************************************************

void Ccompiler::ApplyCommand()
{
   if (!strcmp(param[0], "sv_color"))
      pDoc->console_foreground = ParamInt(param[1]);     
   else if (!strcmp(param[0], "sv_quake2_dir"))
      {
      strcpy(pDoc->env.quakedir, param[1]);
      if (pDoc->env.quakedir[strlen(pDoc->env.quakedir) - 1] != '\\')
         sprintf(pDoc->env.quakedir, "%s\\", pDoc->env.quakedir);
      sprintf(pDoc->dline[pDoc->ly], "Quake2 directory is now: %s", pDoc->env.quakedir);
      NewLine();
      }
   else if (!strcmp(param[0], "sv_load_dir"))
      {
      strcpy(pDoc->env.loaddir, param[1]);
      if (pDoc->env.loaddir[strlen(pDoc->env.loaddir) - 1] != '\\')
         sprintf(pDoc->env.loaddir, "%s\\", pDoc->env.loaddir);
      sprintf(pDoc->dline[pDoc->ly], "Loading directory is now: %s", pDoc->env.loaddir);
      NewLine();
      }
   else if (!strcmp(param[0], "sv_editor"))
      {
      strcpy(pDoc->env.editor, param[1]);
      sprintf(pDoc->dline[pDoc->ly], ".SCR editor is now: %s", pDoc->env.editor);
      NewLine();
      }
   else if (!strcmp(param[0], "sv_save_dir"))
      {
      strcpy(pDoc->env.savedir, param[1]);
      if (pDoc->env.savedir[strlen(pDoc->env.savedir) - 1] != '\\')
         sprintf(pDoc->env.savedir, "%s\\", pDoc->env.savedir);
      sprintf(pDoc->dline[pDoc->ly], "Saving directory is now: %s", pDoc->env.savedir);
      NewLine();
      }
   else if (!strcmp(param[0], "compile"))
      {
      sprintf(pDoc->FileIn, "%s%s.scr", pDoc->env.loaddir, param[1]);
      sprintf(pDoc->FileOut, "%s%s.dat", pDoc->env.savedir, param[1]);
		memset(pDoc->dline[pDoc->ly], '-', 254);
      NewLine();
      switch (Compile())
			{
         case -2:
				sprintf(pDoc->dline[pDoc->ly], "&c600 File %s not found.", pDoc->FileIn);
            NewLine();
            break;
			case -3:
				sprintf(pDoc->dline[pDoc->ly], "&c600 Cannot open file %s.", pDoc->FileOut);
            NewLine();
            break;
			case 1:
				sprintf(pDoc->dline[pDoc->ly], "Compile successful. &c660 %d &r instructions.&c660 %d &r bytes", 
						pDoc->current_instruction, pDoc->current_instruction * sizeof(pDoc->script));
				NewLine();
            break;
         }
		memset(pDoc->dline[pDoc->ly], '-', 254);
      NewLine();
      }
   else if (!strcmp(param[0], "god"))
      if (pDoc->env.god)
         {
         pDoc->env.god = false;
         sprintf(pDoc->dline[pDoc->ly], "God mode off");
         NewLine();
         }
      else
         {
         pDoc->env.god = true;
         sprintf(pDoc->dline[pDoc->ly], "God mode on");
         NewLine();
         }
   else if (!strcmp(param[0], "cheats"))
      if (pDoc->env.cheats)
         {
         pDoc->env.cheats = false;
         sprintf(pDoc->dline[pDoc->ly], "Cheats mode off");
         NewLine();
         }
      else
         {
         pDoc->env.cheats = true;
         sprintf(pDoc->dline[pDoc->ly], "Cheats mode on");
         NewLine();
         }
   else if (!strcmp(param[0], "notarget"))
      if (pDoc->env.notarget)
         {
         pDoc->env.notarget = false;
         sprintf(pDoc->dline[pDoc->ly], "No Target off");
         NewLine();
         }
      else
         {
         pDoc->env.notarget = true;
         sprintf(pDoc->dline[pDoc->ly], "No Target on");
         NewLine();
         }
   else if (!strcmp(param[0], "disconnect"))
      if (pDoc->env.disconnect)
         {
         pDoc->env.disconnect = false;
         sprintf(pDoc->dline[pDoc->ly], "Disconnect off");
         NewLine();
         }
      else
         {
         pDoc->env.disconnect = true;
         sprintf(pDoc->dline[pDoc->ly], "Disconnect on");
         NewLine();
         }
   else if (!strcmp(param[0], "give_all"))
      {
      if (pDoc->env.give_all)
			{
			pDoc->env.give_all = false;
         sprintf(pDoc->dline[pDoc->ly], "Give All off");
         NewLine();
         }
		else
			{
         pDoc->env.give_all = true;
         sprintf(pDoc->dline[pDoc->ly], "Give All on");
         NewLine();
         }
      }
   else if (!strcmp(param[0], "game"))
      {
      strcpy(pDoc->env.quakegame, param[1]);
      sprintf(pDoc->dline[pDoc->ly], "Game set to %s", pDoc->env.quakegame);
      NewLine();
      }
   else if (!strcmp(param[0], "sv_params"))
      {
      strcpy(pDoc->env.quakeparams, param[1]);
      sprintf(pDoc->dline[pDoc->ly], "Parameters are %s", pDoc->env.quakeparams);
      NewLine();
      }
   else if (!strcmp(param[0], "deathmatch"))
      {
      pDoc->env.deathmatch = ParamInt(param[1]);
      sprintf(pDoc->dline[pDoc->ly], "Deathmatch set to %d", pDoc->env.deathmatch);
      NewLine();
      }
   else if (!strcmp(param[0], "map"))
      {
      strcpy(pDoc->env.quakemap, param[1]);      
      sprintf(pDoc->dline[pDoc->ly], "Map set to %s", pDoc->env.quakemap);
      NewLine();
      }
   else if (!strcmp(param[0], "video"))
      {
      pDoc->env.video = ParamInt(param[1]);
      sprintf(pDoc->dline[pDoc->ly], "Video set to %d", pDoc->env.video);
      NewLine();
      }
}

void Ccompiler::DisplayStatus()
{
   sprintf(pDoc->dline[pDoc->ly], " -> Quake Dir: &c660 %s", pDoc->env.quakedir);
   NewLine();   
   sprintf(pDoc->dline[pDoc->ly], " -> Quake Parameters: &c660 %s", pDoc->env.quakeparams);
   NewLine();   
   sprintf(pDoc->dline[pDoc->ly], " -> Quake Game: &c660 %s", pDoc->env.quakegame);
   NewLine();   
   sprintf(pDoc->dline[pDoc->ly], " -> Quake Map: &c660 %s", pDoc->env.quakemap);
   NewLine();   
   if (pDoc->env.deathmatch)
      sprintf(pDoc->dline[pDoc->ly], " -> Deathmatch: &c660 %d",pDoc->env.deathmatch);
   else
      sprintf(pDoc->dline[pDoc->ly], " -> Deathmatch: &c660 OFF");
   NewLine();   
   sprintf(pDoc->dline[pDoc->ly], " -> Video: &c660 %d",pDoc->env.video);
   NewLine();   
   sprintf(pDoc->dline[pDoc->ly], " -> Save Dir: &c660 %s", pDoc->env.savedir);
   NewLine();   
   sprintf(pDoc->dline[pDoc->ly], " -> Load Dir: &c660 %s", pDoc->env.loaddir);
   NewLine();  
   sprintf(pDoc->dline[pDoc->ly], " -> .SCR Editor: &c660 %s", pDoc->env.editor);
   NewLine();  
   sprintf(pDoc->dline[pDoc->ly], " -> .WAL Dir: &c660 %s", pDoc->env.waldir);
   NewLine();  
   sprintf(pDoc->dline[pDoc->ly], " -> Model Dir: &c660 %s", pDoc->env.modeldir);
   NewLine();  
   sprintf(pDoc->dline[pDoc->ly], " -> Sound Dir: &c660 %s", pDoc->env.sounddir);
   NewLine();  
}

void Ccompiler::NewLine()
{
   pDoc->m_display = CONSOLE_DISPLAY;   
   if (pDoc->ly < pDoc->max_lines) 
      pDoc->ly++;
   else
      {
      for (short i = 1; i < 50; i++)
         {
         memcpy(pDoc->dline[i - 1], 
                pDoc->dline[i], 255);
         }      
      }  
   pDoc->lx = 3;
   *(pDoc->dline[pDoc->ly])= 'O';
   *(pDoc->dline[pDoc->ly] + 1)= 'K';
   *(pDoc->dline[pDoc->ly] + 2)= '>';
   *(pDoc->dline[pDoc->ly] + pDoc->lx) = 27;
}
