/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/

#include "bnf.h"


void BNF_set(bnf_t *bnf)
{
   bnf[0].syntax = "goto";
   bnf[0].head = '(';
   bnf[0].tail = ')';
   bnf[0].params[0] = BNF_COMMAND;
   bnf[0].params[1] = BNF_END;
   bnf[0].format = FORMAT_SCRIPT;
   bnf[0].usage = "goto(string x);\n"
                  "Where x is the label name\n"
						"goto statements overwrite the instruction pointer IP.\n";
   
   bnf[1].syntax = "sv_color";
   bnf[1].head = 0;
   bnf[1].tail = 0;
   bnf[1].params[0] = BNF_INT;
   bnf[1].params[1] = BNF_END;
   bnf[1].format = FORMAT_EDITOR;
   bnf[1].usage = "sv_color <int x>\n"
                  "Where x is the color intensity number\n"
                  "'color' will set intensity of the green text.\n";
   
   bnf[2].syntax = "wait";
   bnf[2].head = '(';
   bnf[2].tail = ')';
   bnf[2].params[0] = BNF_FLOAT;
   bnf[2].params[1] = BNF_END;
   bnf[2].format = FORMAT_SCRIPT;
   bnf[2].usage = "wait(float x);\n"
                  "Where x is the number of seconds to wait before the next statement is executed.\n";

   bnf[3].syntax = "move_to";
   bnf[3].head = '(';
   bnf[3].tail = ')';
   bnf[3].params[0] = BNF_STRING;
   bnf[3].params[1] = BNF_VECTOR;
   bnf[3].params[2] = BNF_END;
   bnf[3].format = FORMAT_SCRIPT;
   bnf[3].usage = "move_to(string x, vector y);\n"
                  "Where x is the targetname of the entity to be moved\n"
						"and y is the world x,y,z coordinate.\n";

   bnf[4].syntax = "sv_quake2_dir";
   bnf[4].head = '=';
   bnf[4].tail = 0;
   bnf[4].params[0] = BNF_STRING;
   bnf[4].params[1] = BNF_END;
   bnf[4].format = FORMAT_EDITOR;
   bnf[4].usage = "sv_quake2_dir = <string dir>;\n"
                  "Where x is the name of the directory where Quake2.exe resides.\n";

   bnf[5].syntax = "god";
   bnf[5].head = 0;
   bnf[5].tail = 0;
   bnf[5].params[0] = BNF_END;
   bnf[5].format = FORMAT_EDITOR;
   bnf[5].usage = "god\n"
						"God mode [On/Off].\n";

   bnf[6].syntax = "map";
   bnf[6].head = 0;
   bnf[6].tail = 0;
   bnf[6].params[0] = BNF_COMMAND;
   bnf[6].params[1] = BNF_END;
   bnf[6].format = FORMAT_EDITOR;
   bnf[6].usage = "Map <string Mapname>\n"
						"Map to load upon Quake2 startup.\n";

   bnf[7].syntax = "cheats";
   bnf[7].head = 0;
   bnf[7].tail = 0;
   bnf[7].params[0] = BNF_END;
   bnf[7].format = FORMAT_EDITOR;
   bnf[7].usage =	"cheats\n"	
						"Server cheats [On/Off].\n";

   bnf[8].syntax = "disconnect";
   bnf[8].head = 0;
   bnf[8].tail = 0;
   bnf[8].params[0] = BNF_END;
   bnf[8].format = FORMAT_EDITOR;
   bnf[8].usage = "disconnect\n"
						"Disconnect from server upon Quake2 startup [On/Off].\n";

   bnf[9].syntax = "give_all";
   bnf[9].head = 0;
   bnf[9].tail = 0;
   bnf[9].params[0] = BNF_END;
   bnf[9].format = FORMAT_EDITOR;
   bnf[9].usage = "give_all\n"
						"Give All [On/Off].\n";

   bnf[10].syntax = "notarget";
   bnf[10].head = 0;
   bnf[10].tail = 0;
   bnf[10].params[0] = BNF_END;
   bnf[10].format = FORMAT_EDITOR;
   bnf[10].usage = "notarget\n"
						 "Notarget [On/Off].\n";

   bnf[11].syntax = "sv_params";
   bnf[11].head = '=';
   bnf[11].tail = 0;
   bnf[11].params[0] = BNF_STRING;
   bnf[11].params[1] = BNF_END;
   bnf[11].format = FORMAT_EDITOR;
   bnf[11].usage = "sv_params <string x>;\n"
                   "Where x is the parameters string.\n";

   bnf[12].syntax = "game";
   bnf[12].head = 0;
   bnf[12].tail = 0;
   bnf[12].params[0] = BNF_COMMAND;
   bnf[12].params[1] = BNF_END;
   bnf[12].format = FORMAT_EDITOR;
   bnf[12].usage = "game <string x>\n"
                   "Where x is the game name.\n";

   bnf[13].syntax = "deathmatch";
   bnf[13].head = 0;
   bnf[13].tail = 0;
   bnf[13].params[0] = BNF_INT;
   bnf[13].params[1] = BNF_END;
   bnf[13].format = FORMAT_EDITOR;
   bnf[13].usage = "deathmatch <int x>\n"
                   "Where x is the deathmatch value.\n";

   bnf[14].syntax = "video";
   bnf[14].head = 0;
   bnf[14].tail = 0;
   bnf[14].params[0] = BNF_INT;
   bnf[14].params[1] = BNF_END;
   bnf[14].format = FORMAT_EDITOR;
   bnf[14].usage = "video <int x>\n"
                   "Where x is the video mode.\n";

   bnf[15].syntax = "sv_load_dir";
   bnf[15].head = '=';
   bnf[15].tail = 0;
   bnf[15].params[0] = BNF_STRING;
   bnf[15].params[1] = BNF_END;
   bnf[15].format = FORMAT_EDITOR;
   bnf[15].usage = "sv_load_dir = <string x>;\n"
                   "Where x is the name of the script loading directory.\n";

   bnf[16].syntax = "sv_save_dir";
   bnf[16].head = '=';
   bnf[16].tail = 0;
   bnf[16].params[0] = BNF_STRING;
   bnf[16].params[1] = BNF_END;
   bnf[16].format = FORMAT_EDITOR;
   bnf[16].usage = "sv_save_dir = <string x>;\n"
                   "Where x is the name of the script saving directory.\n";

   bnf[17].syntax = "compile";
   bnf[17].head = 0;
   bnf[17].tail = 0;
   bnf[17].params[0] = BNF_COMMAND;
   bnf[17].params[1] = BNF_END;
   bnf[17].format = FORMAT_EDITOR;
   bnf[17].usage = "compile <string x>\n"
                   "Where x is the script filename.\n";

   bnf[18].syntax = "say";
   bnf[18].head = '(';
   bnf[18].tail = ')';
   bnf[18].params[0] = BNF_STRING;
   bnf[18].params[1] = BNF_FLOAT;
   bnf[18].params[2] = BNF_COMMAND;
   bnf[18].params[3] = BNF_END;
   bnf[18].format = FORMAT_SCRIPT;
   bnf[18].usage = "say(string wavefile, float volume, string attenuation);\n";
						 "wavefile: .wav file of sound (rooted at sound)\n"
						 "volume: 0.0 - 1.0\n"
						 "attenuation: attn_none, attn_norm, attn_idle, attn_static\n"
						 "See Quake2 technical specifications for more information.\n";

   bnf[19].syntax = "walk";
   bnf[19].head = '(';
   bnf[19].tail = ')';
   bnf[19].params[0] = BNF_COMMAND;
   bnf[19].params[1] = BNF_END;
   bnf[19].format = FORMAT_SCRIPT;
   bnf[19].usage = "walk(string targetname);\n";
						 "Actor will walk to the destination in the map\n"
						 "All script code will be not be resumed until the actor\n"
						 "reaches its destination.\n";

   bnf[20].syntax = "sv_editor";
   bnf[20].head = '=';
   bnf[20].tail = 0;
   bnf[20].params[0] = BNF_STRING;
   bnf[20].params[1] = BNF_END;
   bnf[20].format = FORMAT_EDITOR;
   bnf[20].usage = "sv_editor = <string x>;\n"
                   "Where x is the command line to the script editor.\n";

   bnf[21].syntax = "run";
   bnf[21].head = '(';
   bnf[21].tail = ')';
   bnf[21].params[0] = BNF_COMMAND;
   bnf[21].params[1] = BNF_END;
   bnf[21].format = FORMAT_SCRIPT;
   bnf[21].usage = "run(string targetname);\n"
						 "Actor will run to the destination in the map\n"
						 "All script code will be not be resumed until the actor\n"
						 "reaches its destination.\n";

   bnf[22].syntax = "reserved";
   bnf[22].head = 0;
   bnf[22].tail = 0;
   bnf[22].params[0] = BNF_END;
   bnf[22].format = FORMAT_SCRIPT;
   bnf[22].usage = "TE(int effect);\n"
	                " +++ RESERVED +++\n";

   bnf[23].syntax = "die";
   bnf[23].head = '(';
   bnf[23].tail = ')';
   bnf[23].params[0] = BNF_INT;
   bnf[23].params[1] = BNF_END;
   bnf[23].format = FORMAT_SCRIPT;
   bnf[23].usage = "die(int damage);\n"
	                " +++ RESERVED +++\n";

   bnf[24].syntax = "RESERVED_drop";
   bnf[24].head = '(';
   bnf[24].tail = ')';
   bnf[24].params[0] = BNF_INT;
   bnf[24].params[1] = BNF_INT;
   bnf[24].params[2] = BNF_END;
   bnf[24].format = FORMAT_SCRIPT;
   bnf[24].usage = "RESERVED_drop(int field, int velocity);\n"
	                " +++ RESERVED +++\n";
   
   bnf[25].syntax = "rotate_smooth";
   bnf[25].head = '(';
   bnf[25].tail = ')';
   bnf[25].params[0] = BNF_COMMAND;
   bnf[25].params[1] = BNF_VECTOR;
   bnf[25].params[2] = BNF_FLOAT;
   bnf[25].params[3] = BNF_END;
   bnf[25].format = FORMAT_SCRIPT;
   bnf[25].usage = "rotate_smooth(string targetname, vec3_t dest_angle, float speed);\n"
		             " +++ RESERVED +++\n";
   
   bnf[26].syntax = "remove";
   bnf[26].head = '(';
   bnf[26].tail = ')';
   bnf[26].params[0] = BNF_STRING;
   bnf[26].params[1] = BNF_END;
   bnf[26].format = FORMAT_SCRIPT;
   bnf[26].usage = "remove(string targetname);\n"
		             " +++ RESERVED +++\n";

   bnf[27].syntax = "hide";
   bnf[27].head = '(';
   bnf[27].tail = ')';
   bnf[27].params[0] = BNF_STRING;
   bnf[27].params[1] = BNF_END;
   bnf[27].format = FORMAT_SCRIPT;
   bnf[27].usage = "hide(string targetname);\n";

   bnf[28].syntax = "chase";
   bnf[28].head = '(';
   bnf[28].tail = ')';
   bnf[28].params[0] = BNF_STRING;
   bnf[28].params[1] = BNF_END;
   bnf[28].format = FORMAT_SCRIPT;
   bnf[28].usage = "chase(string targetname);\n"
		             " +++ RESERVED +++\n";

   bnf[29].syntax = "on_block";
   bnf[29].head = '(';
   bnf[29].tail = ')';
   bnf[29].params[0] = BNF_COMMAND;
   bnf[29].params[1] = BNF_COMMAND;
   bnf[29].params[2] = BNF_FLOAT;
   bnf[29].params[3] = BNF_END;
   bnf[29].format = FORMAT_SCRIPT;
   bnf[29].usage = "on_block(string targetname, string labelname, float delay);\n";
						 "Block Intercept:\n"
						 "This intercept will be called when the actor is blocked by the target entity\n"
						 "The intercept will not be possible until all of the parameters are satisfied\n"
						 "targetname: activator (blocker)\n"
						 "labelname: label to call on intercept\n"
						 "delay: frequency of intercept in seconds\n"
						 "Once this intercept is called, we have:\n"
						 ".self = actor\n"
						 ".activator = activator\n"
						 "IP = current instruction before the branch\n";
   
   bnf[30].syntax = "on_use";
   bnf[30].head = '(';
   bnf[30].tail = ')';
   bnf[30].params[0] = BNF_COMMAND;
   bnf[30].params[1] = BNF_COMMAND;
   bnf[30].params[2] = BNF_END;
   bnf[30].format = FORMAT_SCRIPT;
   bnf[30].usage = "on_use(string activator, string labelname);\n"
						 "Use Intercept:\n"
						 "This intercept will be called when the actor is used by the target entity\n"
						 "targetname: activator (user)\n"
						 "labelname: label to call on intercept\n"
						 "Once this intercept is called, we have:\n"
						 ".self = actor\n"
						 ".activator = activator\n"
						 "IP = current instruction before the branch\n";

   bnf[31].syntax = "action_target";
   bnf[31].head = '(';
   bnf[31].tail = ')';
   bnf[31].params[0] = BNF_INT;
   bnf[31].params[1] = BNF_COMMAND;
   bnf[31].params[2] = BNF_END;
   bnf[31].format = FORMAT_SCRIPT;
   bnf[31].usage = "action_target(int action, string targetname);\n"
		             " +++ RESERVED +++\n";

   bnf[32].syntax = "hammer";
   bnf[32].head = '(';
   bnf[32].tail = ')';
   bnf[32].params[0] = BNF_STRING;
   bnf[32].params[1] = BNF_INT;
   bnf[32].params[2] = BNF_END;
   bnf[32].format = FORMAT_SCRIPT;
   bnf[32].usage = "hammer(string targetname, int damage);\n"
		             " +++ RESERVED +++\n";

   bnf[33].syntax = "attack";
   bnf[33].head = '(';
   bnf[33].tail = ')';
   bnf[33].params[0] = BNF_COMMAND;
   bnf[33].params[1] = BNF_INT;
   bnf[33].params[2] = BNF_END;
   bnf[33].format = FORMAT_SCRIPT;
   bnf[33].usage = "attack(string targetname, int damage);\n"
		             " +++ RESERVED +++\n";

   bnf[34].syntax = "spawn";
   bnf[34].head = '(';
   bnf[34].tail = ')';
   bnf[34].params[0] = BNF_COMMAND;
   bnf[34].params[1] = BNF_COMMAND;
   bnf[34].params[2] = BNF_VECTOR;
   bnf[34].params[3] = BNF_INT;
   bnf[34].params[4] = BNF_END;
   bnf[34].format = FORMAT_SCRIPT;
   bnf[34].usage = "spawn(string entity, string targetname, vec3_t origin, int spawnflags);\n"
		             " +++ RESERVED +++\n";

   bnf[35].syntax = "start";
   bnf[35].head = '(';
   bnf[35].tail = ')';
   bnf[35].params[0] = BNF_COMMAND;
   bnf[35].params[1] = BNF_END;
   bnf[35].format = FORMAT_SCRIPT;
   bnf[35].usage = "start(string labelname);\n"
						 " +++ RESERVED +++\n";

   bnf[36].syntax = "on_touch";
   bnf[36].head = '(';
   bnf[36].tail = ')';
   bnf[36].params[0] = BNF_COMMAND;
   bnf[36].params[1] = BNF_COMMAND;
   bnf[36].params[2] = BNF_FLOAT;
   bnf[36].params[3] = BNF_END;
   bnf[36].format = FORMAT_SCRIPT;
   bnf[36].usage = "on_touch(string targetname, string labelname, float delay);\n"
						 "Touch Intercept:\n"
						 "This intercept will be called when the actor is touched by the target entity\n"
						 "The intercept will not be possible until all of the parameters are satisfied\n"
						 "targetname: activator\n"
						 "labelname: label to call on intercept\n"
						 "delay: frequency of intercept in seconds\n"
						 "Once this intercept is called, we have:\n"
						 ".self = actor\n"
						 ".activator = activator\n"
						 "IP = current instruction before the branch\n";

   bnf[37].syntax = "on_see";
   bnf[37].head = '(';
   bnf[37].tail = ')';
   bnf[37].params[0] = BNF_COMMAND;
   bnf[37].params[1] = BNF_COMMAND;
   bnf[37].params[2] = BNF_FLOAT;
   bnf[37].params[3] = BNF_FLOAT;
   bnf[37].params[4] = BNF_END;
   bnf[37].format = FORMAT_SCRIPT;
   bnf[37].usage = "on_see(string targetname, string labelname, float delay, float range);\n"
						 "See Intercept:\n"
						 "This intercept will be called when the actor sees the target entity\n"
						 "The intercept will not be possible until all of the parameters are satisfied\n"
						 "targetname: activator\n"
						 "labelname: label to call on intercept\n"
						 "delay: frequency of intercept in seconds\n"
						 "range: maximum distance from activator (range of sight of actor)\n"
						 "Once this intercept is called, we have:\n"
						 ".self = actor\n"
						 ".activator = activator\n"
						 "IP = current instruction before the branch\n";
   
   bnf[38].syntax = "on_pain";
   bnf[38].head = '(';
   bnf[38].tail = ')';
   bnf[38].params[0] = BNF_COMMAND;
   bnf[38].params[1] = BNF_COMMAND;
   bnf[38].params[2] = BNF_FLOAT;
   bnf[38].params[3] = BNF_FLOAT;
   bnf[38].params[4] = BNF_END;
   bnf[38].format = FORMAT_SCRIPT;
   bnf[38].usage = "on_pain(string targetname, string labelname, float delay, float range);\n"
						 "Pain Intercept:\n"
						 "This intercept will be called when the actor is hurt by the target entity\n"
						 "The intercept will not be possible until all of the parameters are satisfied\n"
						 "targetname: activator\n"
						 "labelname: label to call on intercept\n"
						 "delay: frequency of intercept in seconds\n"
						 "range: maximum distance from activator\n"
						 "Once this intercept is called, we have:\n"
						 ".self = actor\n"
						 ".activator = activator\n"
						 "IP = current instruction before the branch\n";
   
   bnf[39].syntax = "label";
   bnf[39].head = '@';
   bnf[39].tail = 0;
   bnf[39].params[0] = BNF_COMMAND;
   bnf[39].params[1] = BNF_END;
   bnf[39].format = FORMAT_COMPILER;
   bnf[39].usage = "label@<string labelname>;\n"
						 "Label for a certain branch in code.\n";

   bnf[40].syntax = "return";
   bnf[40].head = 0;
   bnf[40].tail = 0;
   bnf[40].params[0] = BNF_END;
   bnf[40].format = FORMAT_SCRIPT;
   bnf[40].usage = "return;\n"
					    "Restore Instruction Pointer (IP) before the intercept\n"
						 "The IP will be freed for future use by new intercepts.\n";

   bnf[41].syntax = "look_at";
   bnf[41].head = '(';
   bnf[41].tail = ')';
   bnf[41].params[0] = BNF_COMMAND;
   bnf[41].params[1] = BNF_END;
   bnf[41].format = FORMAT_SCRIPT;
   bnf[41].usage = "look_at(string targetname);\n"
						 "Actor is rotated to look at target entity.\n";

   bnf[42].syntax = "action";
   bnf[42].head = '(';
   bnf[42].tail = ')';
   bnf[42].params[0] = BNF_INT;
   bnf[42].params[1] = BNF_END;
   bnf[42].format = FORMAT_SCRIPT;
   bnf[42].usage = "action(int actionnumber);\n"
						 "Actor will play the specified action (animation/sound)\n"
						 "Action numbers for a certain entity are defined by the DLL.\n";

   bnf[43].syntax = "stand";
   bnf[43].head = 0;
   bnf[43].tail = 0;
   bnf[43].params[1] = BNF_END;
   bnf[43].format = FORMAT_SCRIPT;
   bnf[43].usage = "stand;\n"
						 "Actor will stand still.\n";

   bnf[44].syntax = "use";
   bnf[44].head = '(';
   bnf[44].tail = ')';
   bnf[44].params[0] = BNF_COMMAND;
   bnf[44].params[1] = BNF_COMMAND;
   bnf[44].params[2] = BNF_END;
   bnf[44].format = FORMAT_SCRIPT;
   bnf[44].usage = "use(string targetname, string activator);\n"
						 "activator: <targetname> or .self or .activator\n"				 
					    "Activator will use the target entity.\n";

   bnf[45].syntax = "chill";
   bnf[45].head = '(';
   bnf[45].tail = ')';
   bnf[45].params[0] = BNF_FLOAT;
   bnf[45].params[1] = BNF_END;
   bnf[45].format = FORMAT_SCRIPT;
   bnf[45].usage = "chill(float seconds);\n"
						 "+++ RESERVED +++\n";

   bnf[46].syntax = "stop";
   bnf[46].head = 0;
   bnf[46].tail = 0;
   bnf[46].params[0] = BNF_END;
   bnf[46].format = FORMAT_SCRIPT;
   bnf[46].usage = "stop;\n"
						 "Kill script\n" 
						 "Actor's script information is freed to memory in DLL.\n";

   bnf[47].syntax = "camera";
   bnf[47].head = '(';
   bnf[47].tail = ')';
   bnf[47].params[0] = BNF_INT;
   bnf[47].params[1] = BNF_FLOAT;
   bnf[47].params[2] = BNF_END;
   bnf[47].format = FORMAT_SCRIPT;
   bnf[47].usage = "camera(int camera_number, float fade);\n"
						 "Trigger the camera with the matching camera_number, usually set\n"
						 "by team_data field in the BSP.\n"
						 "fade: gradual speed of fade in. 0.0 - 1.0\n";

   bnf[48].syntax = "script";
   bnf[48].head = 0;
   bnf[48].tail = 0;
   bnf[48].params[1] = BNF_END;
   bnf[48].format = FORMAT_SCRIPT;
   bnf[48].usage = "script;\n"
					    "Turn on the scope vision (letterbox).\n";

   bnf[49].syntax = "run_slave";
   bnf[49].head = '(';
   bnf[49].tail = ')';
   bnf[49].params[0] = BNF_COMMAND;
   bnf[49].params[1] = BNF_COMMAND;
   bnf[49].params[2] = BNF_END;
   bnf[49].format = FORMAT_SCRIPT;
   bnf[49].usage = "run_slave(string targetname, string destination);\n"
						 "Target entity will run to the destination in the map\n"
						 "All script code will be not be resumed until the target entity\n"
						 "reaches its destination.\n";

   bnf[50].syntax = "target_camera";
   bnf[50].head = '(';
   bnf[50].tail = ')';
   bnf[50].params[0] = BNF_COMMAND;
   bnf[50].params[1] = BNF_END;
   bnf[50].format = FORMAT_SCRIPT;
   bnf[50].usage = "target_camera(string targetname);\n"
					    "Trigger a camera that follows the target entity\n"
						 "If the target entity has an enemy, then the camera finds the best\n"
						 "way to focus on both the target entity and its enemy.\n";

   bnf[51].syntax = "rotate_camera";
   bnf[51].head = '(';
   bnf[51].tail = ')';
   bnf[51].params[0] = BNF_COMMAND;
   bnf[51].params[1] = BNF_FLOAT;
   bnf[51].params[2] = BNF_END;
   bnf[51].format = FORMAT_SCRIPT;
   bnf[51].usage = "rotate_camera(string targetname, float distance);\n"
						 "Trigger the rotating camera around the target entity\n"
						 "distance: distance in map units from the target (radius)\n"
						 "Rotating cameras can clip into walls, so beware.\n";

   bnf[52].syntax = "rotate";
   bnf[52].head = '(';
   bnf[52].tail = ')';
   bnf[52].params[0] = BNF_VECTOR;
   bnf[52].params[1] = BNF_END;
   bnf[52].format = FORMAT_SCRIPT;
   bnf[52].usage = "rotate(vec3_t vector);\n"
						 "Actor entity's angles are set to the specified vector.\n";

   bnf[53].syntax = "rotate_slave";
   bnf[53].head = '(';
   bnf[53].tail = ')';
   bnf[53].params[0] = BNF_COMMAND;
   bnf[53].params[1] = BNF_VECTOR;
   bnf[53].params[2] = BNF_END;
   bnf[53].format = FORMAT_SCRIPT;
   bnf[53].usage = "rotate_slave(string targetname, vec3_t vector);\n"
						 "Target entity's angles are set to the specified vector.\n";

   bnf[54].syntax = "look_at_slave";
   bnf[54].head = '(';
   bnf[54].tail = ')';
   bnf[54].params[0] = BNF_COMMAND;
   bnf[54].params[1] = BNF_COMMAND;
   bnf[54].params[2] = BNF_END;
   bnf[54].format = FORMAT_SCRIPT;
   bnf[54].usage = "look_at_slave(string targetname, string destination);\n"
						 "Target entity is rotated to look at destination.\n";

   bnf[55].syntax = "action_slave";
   bnf[55].head = '(';
   bnf[55].tail = ')';
   bnf[55].params[0] = BNF_COMMAND;
   bnf[55].params[1] = BNF_INT;
   bnf[55].params[2] = BNF_END;
   bnf[55].format = FORMAT_SCRIPT;
   bnf[55].usage = "action_slave(string targetname, int action);\n"
						 "Set target entity to play a certain action (animation/sound)\n"
						 "Action numbers for a certain entity are defined by the DLL.\n";

   bnf[56].syntax = "stand_slave";
   bnf[56].head = '(';
   bnf[56].tail = ')';
   bnf[56].params[0] = BNF_COMMAND;
   bnf[56].params[1] = BNF_END;
   bnf[56].format = FORMAT_SCRIPT;
   bnf[56].usage = "stand_slave(string targetname);\n"
						 "Set target entity to standing mode (No Enemy).\n";

   bnf[57].syntax = "say_slave";
   bnf[57].head = '(';
   bnf[57].tail = ')';
   bnf[57].params[0] = BNF_COMMAND;
   bnf[57].params[1] = BNF_STRING;
   bnf[57].params[2] = BNF_FLOAT;
   bnf[57].params[3] = BNF_COMMAND;
   bnf[57].params[4] = BNF_END;
   bnf[57].format = FORMAT_SCRIPT;
   bnf[57].usage = "say_slave(string targetname, string wavefile, float volume, string attenuation);\n"
						 "Play the sound from the entity with matching targetname\n"
						 "wavefile: .wav file of sound (rooted at sound)\n"
						 "volume: 0.0 - 1.0\n"
						 "attenuation: attn_none, attn_norm, attn_idle, attn_static\n"
						 "See Quake2 technical specifications for more information.\n";

   bnf[58].syntax = "load_map";
   bnf[58].head = '(';
   bnf[58].tail = ')';
   bnf[58].params[0] = BNF_COMMAND;
   bnf[58].params[1] = BNF_END;
   bnf[58].format = FORMAT_SCRIPT;
   bnf[58].usage = "map(string mapname);\n"
						 "Load the specified BSP.\n";

   bnf[59].syntax = "stuffcmd";
   bnf[59].head = '(';
   bnf[59].tail = ')';
   bnf[59].params[0] = BNF_STRING;
   bnf[59].params[1] = BNF_END;
   bnf[59].format = FORMAT_SCRIPT;
   bnf[59].usage = "stuffcmd(string command);\n"
						 "Send the command to the client console.\n";

   bnf[60].syntax = "listen";
   bnf[60].head = 0;
   bnf[60].tail = 0;
   bnf[60].params[0] = BNF_END;
   bnf[60].format = FORMAT_SCRIPT;
   bnf[60].usage = "listen;\n"
						 "Overwrite the Instruction Pointer (IP) and listen to intercepts.\n";

   bnf[61].syntax = "credits";
   bnf[61].head = 0;
   bnf[61].tail = 0;
   bnf[61].params[0] = BNF_END;
   bnf[61].format = FORMAT_SCRIPT;
   bnf[61].usage = "credits;\n"
						 "Roll the demo credits.\n";

   bnf[62].syntax = "multi_use";
   bnf[62].head = '(';
   bnf[62].tail = ')';
   bnf[62].params[0] = BNF_COMMAND;
   bnf[62].params[1] = BNF_FLOAT;
   bnf[62].params[2] = BNF_END;
   bnf[62].format = FORMAT_SCRIPT;
   bnf[62].usage = "multi_use(string user, float range);\n"
						 "multi_use will send a trigger to all visible entities who are in the\n"
						 "specified range from the actor.\n";

   bnf[63].syntax = "zoom";
   bnf[63].head = '(';
   bnf[63].tail = ')';
   bnf[63].params[0] = BNF_FLOAT;
   bnf[63].params[1] = BNF_FLOAT;
   bnf[63].params[2] = BNF_END;
   bnf[63].format = FORMAT_SCRIPT;
   bnf[63].usage = "zoom(float fov, float speed);\n"
						 "Zoom the camera at a certain speed.\n";

   bnf[64].syntax = "sound_loop";
   bnf[64].head = '(';
   bnf[64].tail = ')';
   bnf[64].params[0] = BNF_STRING;
   bnf[64].params[1] = BNF_END;
   bnf[64].format = FORMAT_SCRIPT;
   bnf[64].usage = "sound_loop(string targetname, string wavefile);\n"
						 "Play looped sound for actor entity until wavefile = .none.\n";

   bnf[65].syntax = "sound_loop_slave";
   bnf[65].head = '(';
   bnf[65].tail = ')';
   bnf[65].params[0] = BNF_COMMAND;
   bnf[65].params[1] = BNF_STRING;
   bnf[65].params[2] = BNF_END;
   bnf[65].format = FORMAT_SCRIPT;
   bnf[65].usage = "sound_loop_slave(string targetname, string wavefile);\n"
						 "Play looped sound for targeted entity until wavefile = .none.\n";

   bnf[66].syntax = "move";
   bnf[66].head = '(';
   bnf[66].tail = ')';
   bnf[66].params[0] = BNF_COMMAND;
   bnf[66].params[1] = BNF_END;
   bnf[66].format = FORMAT_SCRIPT;
   bnf[66].usage = "move(string targetname);\n"
						 "Move the actor entity to the target position.\n";
						 

   bnf[67].syntax = "move_slave";
   bnf[67].head = '(';
   bnf[67].tail = ')';
   bnf[67].params[0] = BNF_COMMAND;
   bnf[67].params[1] = BNF_COMMAND;
   bnf[67].params[2] = BNF_END;
   bnf[67].format = FORMAT_SCRIPT;
   bnf[67].usage = "move_slave(string targetname, string pos-targetname);\n"
						 "Move the target entity to the targeted position.\n";


   bnf[68].syntax = "set_field";
   bnf[68].head = '(';
   bnf[68].tail = ')';
   bnf[68].params[0] = BNF_COMMAND;
   bnf[68].params[1] = BNF_COMMAND;
   bnf[68].params[2] = BNF_STRING;
   bnf[68].params[3] = BNF_FLOAT;
   bnf[68].params[4] = BNF_END;
   bnf[68].format = FORMAT_SCRIPT;
   bnf[68].usage = "set_field(string targetname, string field, string operator, float value);\n"
						 "Sets the (float/int) field of the target entity\n";

   bnf[69].syntax = "if";
   bnf[69].head = '(';
   bnf[69].tail = ')';
   bnf[69].params[0] = BNF_COMMAND;
   bnf[69].params[1] = BNF_COMMAND;
   bnf[69].params[2] = BNF_STRING;
   bnf[69].params[3] = BNF_FLOAT;
   bnf[69].params[4] = BNF_COMMAND;
   bnf[69].params[5] = BNF_END;
   bnf[69].format = FORMAT_SCRIPT;
   bnf[69].usage = "if(string targetname, string field, string operator, float value, string label);\n"
						 "Goes to label if statement is true\n"
						 "Label could be a label name or .return\n";


   bnf[70].syntax = "pump_ammo";
   bnf[70].head = 0;
   bnf[70].tail = 0;
   bnf[70].format = FORMAT_SCRIPT;
   bnf[70].usage = "pump_ammo;\n"
						 ".activator will be pumped with ammo\n";

   bnf[71].syntax = "pickup";
   bnf[71].head = '(';
   bnf[71].tail = ')';
   bnf[71].params[0] = BNF_COMMAND;
   bnf[71].params[1] = BNF_END;
   bnf[71].format = FORMAT_SCRIPT;
   bnf[71].usage = "pickup(string droppable);\n"
						 ".activator will pick up entity\n"
						 "droppable = drop_on - for droppable item\n"
						 "droppable = drop_off - for non droppable item\n";

   bnf[72].syntax = "on_drop";
   bnf[72].head = '(';
   bnf[72].tail = ')';
   bnf[72].params[0] = BNF_COMMAND;
   bnf[72].params[1] = BNF_END;
   bnf[72].format = FORMAT_SCRIPT;
   bnf[72].usage = "on_drop(string label);\n"
						 "Player drops the script\n";

   bnf[73].syntax = "set_model";
   bnf[73].head = '(';
   bnf[73].tail = ')';
   bnf[73].params[0] = BNF_STRING;
   bnf[73].params[1] = BNF_INT;
   bnf[73].params[2] = BNF_END;
   bnf[73].format = FORMAT_SCRIPT;
   bnf[73].usage = "set_model(string modelname, int index);\n"
						 "Actor will have the model set to modelname\n"
						 "index is from 1 to 4\n";

   bnf[74].syntax = "set_skin";
   bnf[74].head = '(';
   bnf[74].tail = ')';
   bnf[74].params[0] = BNF_INT;
   bnf[74].params[1] = BNF_END;
   bnf[74].format = FORMAT_SCRIPT;
   bnf[74].usage = "set_skin(int skinnumber);\n"
						 "Actor will change skin to skinnumber\n";

   bnf[75].syntax = "set_mins";
   bnf[75].head = '(';
   bnf[75].tail = ')';
   bnf[75].params[0] = BNF_VECTOR;
   bnf[75].params[1] = BNF_END;
   bnf[75].format = FORMAT_SCRIPT;
   bnf[75].usage = "set_mins(vec3_t mins);\n"
						 "Set actor bounding box minima\n";

   bnf[76].syntax = "set_maxs";
   bnf[76].head = '(';
   bnf[76].tail = ')';
   bnf[76].params[0] = BNF_VECTOR;
   bnf[76].params[1] = BNF_END;
   bnf[76].format = FORMAT_SCRIPT;
   bnf[76].usage = "set_maxs(vec3_t maxs);\n"
						 "Set actor bounding box maxima\n";

   bnf[77].syntax = "set_solid";
   bnf[77].head = '(';
   bnf[77].tail = ')';
   bnf[77].params[0] = BNF_COMMAND;
   bnf[77].params[1] = BNF_END;
   bnf[77].format = FORMAT_SCRIPT;
   bnf[77].usage = "set_solid (string solid);\n"
						 "Set actor solid detail\n"
						 "Available solids:\n"
						 "solid_not: not solid\n"
						 "solid_trigger: trigger\n"
						 "solid_bbox: solid\n"
						 "solid_bsp: static map entity (wall for example)\n";

   bnf[78].syntax = "set_movetype";
   bnf[78].head = '(';
   bnf[78].tail = ')';
   bnf[78].params[0] = BNF_COMMAND;
   bnf[78].params[1] = BNF_END;
   bnf[78].format = FORMAT_SCRIPT;
   bnf[78].usage = "set_movetype (string movetype);\n"
						 "Set actor movevement type\n"
						 "Available solids:\n"
						 "movetype_none\n"
						 "movetype_noclip\n"
						 "movetype_push\n"
						 "movetype_stop\n"
						 "movetype_walk\n"
						 "movetype_step\n"
						 "movetype_fly\n"
						 "movetype_toss\n"
						 "movetype_flymissile\n"
						 "movetype_bounce\n"
						 "movetype_roll\n"
						 "movetype_flyricochet\n"
						 "movetype_flyarc\n";

   bnf[79].syntax = "animate";
   bnf[79].head = '(';
   bnf[79].tail = ')';
   bnf[79].params[0] = BNF_INT;
   bnf[79].params[1] = BNF_INT;
   bnf[79].params[2] = BNF_COMMAND;
   bnf[79].params[3] = BNF_END;
   bnf[79].format = FORMAT_SCRIPT;
   bnf[79].usage = "animate(int startframe, int endframe, string format);\n"
						 "format is:\n"
						 "one_shot: stop animation when endframe is reached\n"
						 "looped: animation is looped when endframe is drawn\n"
						 "Each frame takes 1 word frametime.\n";

   bnf[80].syntax = "critical";
   bnf[80].head = 0;
   bnf[80].tail = 0;
   bnf[80].params[0] = BNF_END;
   bnf[80].format = FORMAT_SCRIPT;
   bnf[80].usage = "critical;\n"
						 "Set CPU to critical mode.\n"
						 "All consecutive instructions will be executed in a single frame\n"
						 "until release is encountered\n";

   bnf[81].syntax = "release";
   bnf[81].head = 0;
   bnf[81].tail = 0;
   bnf[81].params[0] = BNF_END;
   bnf[81].format = FORMAT_SCRIPT;
   bnf[81].usage = "release;\n"
						 "Release CPU from critical mode. Go back to 1 instruction per frame.\n";

   bnf[82].syntax = "class.set_string";
   bnf[82].head = '[';
   bnf[82].tail = ']';
   bnf[82].params[0] = BNF_INT;
   bnf[82].params[1] = BNF_COMMAND;
   bnf[82].params[2] = BNF_STRING;
   bnf[82].params[3] = BNF_END;
   bnf[82].format = FORMAT_SCRIPT;
   bnf[82].usage = "class.set_string[int number, string tag, string value];\n"
						 "Set the string field value for a certain class.\n";

   bnf[83].syntax = "class.set_value";
   bnf[83].head = '[';
   bnf[83].tail = ']';
   bnf[83].params[0] = BNF_INT;
   bnf[83].params[1] = BNF_COMMAND;
   bnf[83].params[2] = BNF_STRING;
   bnf[83].params[3] = BNF_FLOAT;
   bnf[83].params[4] = BNF_END;
   bnf[83].format = FORMAT_SCRIPT;
   bnf[83].usage = "class.set_value[int number, string tag, string operator, value];\n"
						 "Set the float field value for a certain class.\n";

   bnf[84].syntax = "class.if";
   bnf[84].head = '[';
   bnf[84].tail = ']';
   bnf[84].params[0] = BNF_INT;
   bnf[84].params[1] = BNF_COMMAND;
   bnf[84].params[2] = BNF_STRING;
   bnf[84].params[3] = BNF_FLOAT;
   bnf[84].params[4] = BNF_COMMAND;
   bnf[84].params[5] = BNF_END;
   bnf[84].format = FORMAT_SCRIPT;
   bnf[84].usage = "class.if[int number, string tag, string operator, int value, string label];\n"
						 "Goes to label if statement is true\n"
						 "Label could be a label name or .return\n";

   bnf[85].syntax = "level.set_string";
   bnf[85].head = '[';
   bnf[85].tail = ']';
   bnf[85].params[0] = BNF_COMMAND;
   bnf[85].params[1] = BNF_STRING;
   bnf[85].params[2] = BNF_END;
   bnf[85].format = FORMAT_SCRIPT;
   bnf[85].usage = "level.set_string[string tag, string value];\n"
						 "Set the string field value for level.\n";

   bnf[86].syntax = "level.set_value";
   bnf[86].head = '[';
   bnf[86].tail = ']';
   bnf[86].params[0] = BNF_COMMAND;
   bnf[86].params[1] = BNF_STRING;
   bnf[86].params[2] = BNF_FLOAT;
   bnf[86].params[3] = BNF_END;
   bnf[86].format = FORMAT_SCRIPT;
   bnf[86].usage = "level.set_value[string tag, string operator, value];\n"
						 "Set the float field value for level.\n";

   bnf[87].syntax = "level.if";
   bnf[87].head = '[';
   bnf[87].tail = ']';
   bnf[87].params[0] = BNF_COMMAND;
   bnf[87].params[1] = BNF_STRING;
   bnf[87].params[2] = BNF_FLOAT;
   bnf[87].params[3] = BNF_COMMAND;
   bnf[87].params[4] = BNF_END;
   bnf[87].format = FORMAT_SCRIPT;
   bnf[87].usage = "level.if[string tag, string operator, int value, string label];\n"
						 "Goes to label if statement is true\n"
						 "Label could be a label name or .return\n";

   bnf[88].syntax = "model_slave";
   bnf[88].head = '(';
   bnf[88].tail = ')';
   bnf[88].params[0] = BNF_COMMAND;
   bnf[88].params[1] = BNF_COMMAND;
   bnf[88].params[2] = BNF_STRING;
   bnf[88].params[3] = BNF_END;
   bnf[88].format = FORMAT_SCRIPT;
   bnf[88].usage = "model_slave(string targetname, string modeltag, string model];\n"
						 "Set the model for targetname\n"
						 "Available modeltags:\n"
						 "modelindex\n"
						 "modelindex2\n"
						 "modelindex3\n"
						 "modelindex4\n";

   bnf[89].syntax = "team.set_value";
   bnf[89].head = '[';
   bnf[89].tail = ']';
   bnf[89].params[0] = BNF_INT;
   bnf[89].params[1] = BNF_COMMAND;
   bnf[89].params[2] = BNF_STRING;
   bnf[89].params[3] = BNF_FLOAT;
   bnf[89].params[4] = BNF_END;
   bnf[89].format = FORMAT_SCRIPT;
   bnf[89].usage = "team.set_value[int number, string tag, string operator, value];\n"
						 "Set the float field value for a certain team.\n";

   bnf[90].syntax = "team.if";
   bnf[90].head = '[';
   bnf[90].tail = ']';
   bnf[90].params[0] = BNF_INT;
   bnf[90].params[1] = BNF_COMMAND;
   bnf[90].params[2] = BNF_STRING;
   bnf[90].params[3] = BNF_FLOAT;
   bnf[90].params[4] = BNF_COMMAND;
   bnf[90].params[5] = BNF_END;
   bnf[90].format = FORMAT_SCRIPT;
   bnf[90].usage = "team.if[int number, string tag, string operator, int value, string label];\n"
						 "Goes to label if statement is true\n"
						 "Label could be a label name or .return\n";

   bnf[91].syntax = "on_die";
   bnf[91].head = '(';
   bnf[91].tail = ')';
   bnf[91].params[0] = BNF_COMMAND;
   bnf[91].params[1] = BNF_COMMAND;
   bnf[91].params[2] = BNF_END;
   bnf[91].format = FORMAT_SCRIPT;
   bnf[91].usage = "on_die(string targetname, string labelname);\n"
						 "Die Intercept:\n"
						 "This intercept will be called when the actor is killed by the target entity\n"
						 "The intercept will not be possible until all of the parameters are satisfied\n"
						 "targetname: activator\n"
						 "labelname: label to call on intercept\n"
						 "Once this intercept is called, we have:\n"
						 ".self = actor\n"
						 ".activator = activator\n"
						 "IP = current instruction before the branch\n";

   bnf[92].syntax = "print";
   bnf[92].head = '(';
   bnf[92].tail = ')';
   bnf[92].params[0] = BNF_COMMAND;
   bnf[92].params[1] = BNF_STRING;
   bnf[92].params[2] = BNF_END;
   bnf[92].format = FORMAT_SCRIPT;
   bnf[92].usage = "print (string targetname, string message);\n"
						 "Prints the message to center of the screen of target entity\n";

   bnf[93].syntax = "level.print";
   bnf[93].head = '(';
   bnf[93].tail = ')';
   bnf[93].params[0] = BNF_STRING;
   bnf[93].params[1] = BNF_END;
   bnf[93].format = FORMAT_SCRIPT;
   bnf[93].usage = "print (string message);\n"
						 "Prints the message the whole level\n";

   bnf[94].syntax = "team.respawn";
   bnf[94].head = '(';
   bnf[94].tail = ')';
   bnf[94].params[0] = BNF_INT;				// int 0
   bnf[94].params[1] = BNF_COMMAND;			// int 1
   bnf[94].params[2] = BNF_STRING;			// float 1
   bnf[94].params[3] = BNF_FLOAT;			// float 0
   bnf[94].params[4] = BNF_END;
   bnf[94].format = FORMAT_SCRIPT;
   bnf[94].usage = "team.respawn(int teamnumber, string tag, string op, float value);\n"
						 "Respawn all teams members if their tag values are met\n";

   bnf[95].syntax = "team.damage";
   bnf[95].head = '(';
   bnf[95].tail = ')';
   bnf[95].params[0] = BNF_INT;				// int 0
   bnf[95].params[1] = BNF_FLOAT;			// float 0
   bnf[95].params[2] = BNF_COMMAND;			// int 1
   bnf[95].params[3] = BNF_STRING;			// vect[0]
   bnf[95].params[4] = BNF_FLOAT;			// float 1
   bnf[95].params[5] = BNF_END;
   bnf[95].format = FORMAT_SCRIPT;
   bnf[95].usage = "team.damage(int teamnumber, float damage, string tag, string op, float value);\n"
						 "Damage all teams members if their tag values are met\n";

   bnf[96].syntax = "team.score";
   bnf[96].head = '(';
   bnf[96].tail = ')';
   bnf[96].params[0] = BNF_INT;				// int 0
   bnf[96].params[1] = BNF_FLOAT;			// float 0
   bnf[96].params[2] = BNF_COMMAND;			// int 1
   bnf[96].params[3] = BNF_STRING;			// vect[0]
   bnf[96].params[4] = BNF_FLOAT;			// float 1
   bnf[96].params[5] = BNF_END;
   bnf[96].format = FORMAT_SCRIPT;
   bnf[96].usage = "team.score(int teamnumber, float score, string tag, string op, float value);\n"
						 "Add score to all teams members if their tag values are met\n";

   bnf[97].syntax = "team.print";
   bnf[97].head = '(';
   bnf[97].tail = ')';
   bnf[97].params[0] = BNF_INT;				// int 0
   bnf[97].params[1] = BNF_STRING;			// string 0
   bnf[97].params[2] = BNF_COMMAND;			// int 1
   bnf[97].params[3] = BNF_STRING;			// float 1
   bnf[97].params[4] = BNF_FLOAT;			// float 0
   bnf[97].params[5] = BNF_END;
   bnf[97].format = FORMAT_SCRIPT;
   bnf[97].usage = "team.print(int teamnumber, string message, string tag, string op, float value);\n"
						 "Print message to all teams members if their tag values are met\n";

   bnf[98].syntax = "link";
   bnf[98].head = 0;
   bnf[98].tail = 0;
   bnf[98].params[0] = BNF_END;
   bnf[98].format = FORMAT_SCRIPT;
   bnf[98].usage = "link;\n"
						 "link actor to world\n";

   bnf[99].syntax = "unlink";
   bnf[99].head = 0;
   bnf[99].tail = 0;
   bnf[99].params[0] = BNF_END;
   bnf[99].format = FORMAT_SCRIPT;
   bnf[99].usage = "unlink;\n"
						 "unlink actor from world\n";

   bnf[100].syntax = "drop";
   bnf[100].head = '(';
   bnf[100].tail = ')';
   bnf[100].params[0] = BNF_COMMAND;
   bnf[100].params[1] = BNF_COMMAND;
   bnf[100].params[2] = BNF_COMMAND;
   bnf[100].params[3] = BNF_END;
   bnf[100].format = FORMAT_SCRIPT;
   bnf[100].usage = "drop(string targetname, string dropentity, string droptype);\n"
						  "Drops anything target entity is carrying\n"
						  "droptype can be either drop_on, drop_off, or drop_return\n"
						  "drop_on: item is droppable once carried\n"
						  "drop_return: item returns to its original place whend dropped\n"
						  "drop_off: item is dropped near carrier\n"
						  "Target entity can drop anything it was carring with dropentity = .carried\n";

   bnf[101].syntax = "if_onsameteam";
   bnf[101].head = '(';
   bnf[101].tail = ')';
   bnf[101].params[0] = BNF_COMMAND;
   bnf[101].params[1] = BNF_END;
   bnf[101].format = FORMAT_SCRIPT;
   bnf[101].usage = "if_onsameteam(string label);\n"
						  "Go to label if actor is on the same team as its activator\n";
}

void BNF_set_fields(field_tag_t *field_tag)
{
	field_tag[0].name = "speed";
	field_tag[1].name = "acceleration";
	field_tag[2].name = "deceleration";
	field_tag[3].name = "mass";
	field_tag[4].name = "air_finished";
	field_tag[5].name = "gravity";
	field_tag[6].name = "health";
	field_tag[7].name = "max_health";
	field_tag[8].name = "gib_health";
	field_tag[9].name = "viewheight";
	field_tag[10].name = "takedamage";
	field_tag[11].name = "damage";
	field_tag[12].name = "radius_damage";
	field_tag[13].name = "flipping";
	field_tag[14].name = "status";
	field_tag[15].name = "type";
	field_tag[16].name = "team_data";
	field_tag[17].name = "s.skin";
	field_tag[18].name = "s.renderfx";
	field_tag[19].name = "s.effects";
	field_tag[20].name = "pers.hand";
	field_tag[21].name = "resp.score";
	field_tag[22].name = "client.field1";
	field_tag[23].name = "client.field2";
	field_tag[24].name = "client.field3";
	field_tag[25].name = "client.field4";
	field_tag[26].name = "client.field5";
	field_tag[27].name = "client.field6";
	field_tag[28].name = "client.field7";
	field_tag[29].name = "client.field8";
	field_tag[30].name = "client.field9";
	field_tag[31].name = "client.field10";
	field_tag[32].name = "client.field11";
	field_tag[33].name = "client.field12";
	field_tag[34].name = "client.field13";
	field_tag[35].name = "client.field14";
	field_tag[36].name = "client.field15";
	field_tag[37].name = "client.field16";
	field_tag[38].name = "resp.classnumber";
	field_tag[39].name = "client.classspeed";
	field_tag[40].name = "client.classarmor";
	field_tag[41].name = "client.classgrenades";
	field_tag[42].name = "targetname";
}

void BNF_set_operators(operator_tag_t *operator_tag)
{
	operator_tag[0].name = "=";
	operator_tag[1].name = "|=";
	operator_tag[2].name = "&=";
	operator_tag[3].name = "&= ~";
	operator_tag[4].name = "~";
	operator_tag[5].name = "+=";
	operator_tag[6].name = "-=";
	operator_tag[7].name = "/=";
	operator_tag[8].name = "*=";
}

void BNF_set_checks(check_tag_t *check_tag)
{
	check_tag[0].name = "==";
	check_tag[1].name = "|";
	check_tag[2].name = "&";
	check_tag[3].name = "& ~";
	check_tag[4].name = "!=";
	check_tag[5].name = ">";
	check_tag[6].name = "<";
	check_tag[7].name = ">=";
	check_tag[8].name = "<=";
}

void BNF_set_class_strings(class_string_tag_t *class_string_tag)
{
	class_string_tag[0].name = "classname";
	class_string_tag[1].name = "spawnmessage";
	class_string_tag[2].name = "help";
	class_string_tag[3].name = "modelindex";
	class_string_tag[4].name = "modelindex2";
	class_string_tag[5].name = "modelindex3";
	class_string_tag[6].name = "skin";
}

void BNF_set_classes(class_tag_t *class_tag)
{
	class_tag[0].name = "mass";
	class_tag[1].name = "speed";
	class_tag[2].name = "weapons";
	class_tag[3].name = "grenades";
	class_tag[4].name = "num_grenades";
	class_tag[5].name = "armor";
	class_tag[6].name = "health";
	class_tag[7].name = "technology";
	class_tag[8].name = "communication";
	class_tag[9].name = "max_players";
}

void BNF_set_level_strings(level_string_tag_t *level_string_tag)
{
	level_string_tag[0].name = "team1_name";
	level_string_tag[1].name = "team2_name";
	level_string_tag[2].name = "team3_name";
	level_string_tag[3].name = "team4_name";
	level_string_tag[4].name = "nextmap";
	level_string_tag[5].name = "team1_name";
	level_string_tag[6].name = "team2_name";
	level_string_tag[7].name = "team3_name";
	level_string_tag[8].name = "team4_name";
}

void BNF_set_levels(level_tag_t *level_tag)
{
	level_tag[0].name = "max_goals";
	level_tag[1].name = "goal";
	level_tag[2].name = "teams";
	level_tag[3].name = "num_classes";
	level_tag[4].name = "dm_flags";
	level_tag[5].name = "field1";
	level_tag[6].name = "field2";
	level_tag[7].name = "field3";
	level_tag[8].name = "field4";
	level_tag[9].name = "field5";
	level_tag[10].name = "field6";
	level_tag[11].name = "field7";
	level_tag[12].name = "field8";
	level_tag[13].name = "field9";
	level_tag[14].name = "field10";
	level_tag[15].name = "field11";
	level_tag[16].name = "field12";
	level_tag[17].name = "field13";
	level_tag[18].name = "field14";
	level_tag[19].name = "field15";
	level_tag[20].name = "field16";
	level_tag[21].name = "meansofdeath";
}

void BNF_set_teams(team_tag_t *team_tag)
{
	team_tag[0].name = "score";
	team_tag[1].name = "deaths";
	team_tag[2].name = "frags";
	team_tag[3].name = "members";
	team_tag[4].name = "field1";
	team_tag[5].name = "field2";
	team_tag[6].name = "field3";
	team_tag[7].name = "field4";
	team_tag[8].name = "field5";
	team_tag[9].name = "field6";
	team_tag[10].name = "field7";
	team_tag[11].name = "field8";
	team_tag[12].name = "field9";
	team_tag[13].name = "field10";
	team_tag[14].name = "field11";
	team_tag[15].name = "field12";
	team_tag[16].name = "field13";
	team_tag[17].name = "field14";
	team_tag[18].name = "field15";
	team_tag[19].name = "field16";
}
