/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/

#ifndef BNF_H
#define BNF_H

#define BNF_END      0
#define BNF_INT      1   
#define BNF_STRING   2
#define BNF_FLOAT    3
#define BNF_VECTOR   4
#define BNF_COMMAND  5

#define FORMAT_EDITOR   1
#define FORMAT_COMPILER 2
#define FORMAT_SCRIPT   3

typedef float vec_t;
typedef vec_t vec3_t[3];

typedef struct
	{
   unsigned long color;
	char quakedir[256];
   char quakeparams[256];
	char quakemap[256];
   char quakegame[256];
	int cheats;
   int god;
   int notarget;
   int give_all;
   int  deathmatch;
   int disconnect;
   int  video;
   char savedir[256];
   char loaddir[256];
   char editor[256];
	int errorsound;
   char waldir[256];
   char modeldir[256];
   char sounddir[256];
	} env_t;

typedef struct
	{
   char *syntax;
   char head, tail;
   char params[8];
   char format;
   char *usage;
   } bnf_t;

typedef struct
	{
	char *name;
	} field_tag_t;

typedef struct
	{
	char *name;
	} class_string_tag_t;

typedef struct
	{
	char *name;
	} class_tag_t;

typedef struct
	{
	char *name;
	} level_string_tag_t;

typedef struct
	{
	char *name;
	} level_tag_t;

typedef struct
	{
	char *name;
	} team_tag_t;

typedef struct
	{
	char *name;
	} operator_tag_t;

typedef struct
	{
	char *name;
	} check_tag_t;

typedef struct
	{
   int command;
   int ParamInt[2];
   float ParamFloat[2];
   char ParamString[4][256];
   vec3_t ParamVector;
   } script_t;

typedef struct
	{
   int command;
   char labelname[256];      
   } history_t;
   
typedef struct
   {
   char activator[256];
   } on_uses_t;

#endif