/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/

#include "stdafx.h"
#include "LifeDoc.h"
#include "MainFrm.h"
#include "Life.h"
#include "Waller.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Waller dialog


Waller::Waller(CWnd* pParent /*=NULL*/)
	: CDialog(Waller::IDD, pParent)
{
	//{{AFX_DATA_INIT(Waller)
	//}}AFX_DATA_INIT
}


void Waller::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(Waller)
	DDX_Control(pDX, IDC_LIST2, m_list);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(Waller, CDialog)
	//{{AFX_MSG_MAP(Waller)
	ON_BN_CLICKED(IDC_CONCRETE, OnConcrete)
	ON_BN_CLICKED(IDC_DIRT, OnDirt)
	ON_BN_CLICKED(IDC_LOAD, OnLoad)
	ON_BN_CLICKED(IDC_METAL, OnMetal)
	ON_BN_CLICKED(IDC_RESTORE, OnRestore)
	ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_BN_CLICKED(IDC_TILES, OnTiles)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Waller message handlers

void Waller::OnConcrete() 
{
	short i;
   for (i = 0; i < list_size; i++)
       if (m_list.GetItemState(index[i], LVIS_SELECTED) & LVIS_SELECTED)
         {
         wal_index[i].flags &= ~(TEXTURE_DIRT |TEXTURE_METAL | TEXTURE_TILES);
         wal_index[i].flags |=  TEXTURE_WOOD;
         m_list.SetItemText(index[i], 1, "");
         m_list.SetItemText(index[i], 2, "");
         m_list.SetItemText(index[i], 3, "");         
         m_list.SetItemText(index[i], 4, "X");         
         }   	
}

void Waller::OnDirt() 
{
	short i;
   for (i = 0; i < list_size; i++)
       if (m_list.GetItemState(index[i], LVIS_SELECTED) & LVIS_SELECTED)
         {
         wal_index[i].flags &= ~(TEXTURE_METAL | TEXTURE_TILES | TEXTURE_WOOD);
         wal_index[i].flags |= TEXTURE_DIRT;
         m_list.SetItemText(index[i], 1, "X");
         m_list.SetItemText(index[i], 2, "");
         m_list.SetItemText(index[i], 3, "");         
         m_list.SetItemText(index[i], 4, "");         
         }   
}

void Waller::OnLoad() 
{
   int i = 0, k = 0;
	char v[256], ext[3];
   CFile X;		// Input WAL file
	miptex_t	t;
	POSITION file_pos;
	static char BASED_CODE szFilter[] = "WALs (*.WAL)|*.wal||";
   CFileDialog GetFile1(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT
								| OFN_ALLOWMULTISELECT, 
                        szFilter, NULL);   
   GetFile1.m_ofn.lpstrInitialDir = pDoc->env.waldir;
   if (GetFile1.DoModal())
      {
		file_pos = GetFile1.GetStartPosition();
		i = 0;
		while (file_pos)
			{
			i++;
			strcpy(v, GetFile1.GetNextPathName(file_pos));
			strcpy(ext, v + strlen(v) - 3);
			if (stricmp(ext, "wal"))
				i--;
			}
		if (i < 1)
			return;
		m_list.DeleteAllItems();
		if (wal_index)
			delete [] wal_index;
		if (index)
			delete [] index;
		wal_index = new wal_file[i + 1];
		index = new int[i + 1];
		list_index = list_size = i = 0;
		file_pos = GetFile1.GetStartPosition();
		while (file_pos)
			{
			strcpy (wal_index[list_index].path, GetFile1.GetNextPathName(file_pos));
			strcpy(ext, wal_index[list_index].path + strlen(wal_index[list_index].path) - 3);
			if (!stricmp(ext, "wal"))
				{
				if (!X.Open(wal_index[list_index].path, CFile::typeBinary|CFile::modeRead))
					return;
				X.Read(&t, sizeof(t));
				//i = strlen(wal_index[list_index].path);
				//while (i >= 0 && wal_index[list_index].path[i] != '\\')
					//i--;
				//strcpy(wal_index[list_index].name, wal_index[list_index].path + i + 1);
				strcpy(wal_index[list_index].name, t.name);
				//wal_index[list_index].name[strlen(wal_index[list_index].name) - 4] = 0;
				index[list_index] = m_list.InsertItem(list_index, wal_index[list_index].name);
				if (t.flags & TEXTURE_DIRT)
					m_list.SetItemText(index[list_index], 1, "X");
				else if (t.flags & TEXTURE_METAL)
					m_list.SetItemText(index[list_index], 2, "X");
				else if (t.flags & TEXTURE_TILES)
					m_list.SetItemText(index[list_index], 3, "X");
				else if (t.flags & TEXTURE_WOOD)
					m_list.SetItemText(index[list_index], 4, "X");
				wal_index[list_index].flags = t.flags;
				X.Close();
				list_index++;
				}
			}
		list_size = list_index;	
		}
}

void Waller::OnMetal() 
{
	short i;
   for (i = 0; i < list_size; i++)
       if (m_list.GetItemState(index[i], LVIS_SELECTED) & LVIS_SELECTED)
         {
         wal_index[i].flags &= ~(TEXTURE_DIRT | TEXTURE_TILES | TEXTURE_WOOD);
         wal_index[i].flags |= TEXTURE_METAL;
         m_list.SetItemText(index[i], 1, "");
         m_list.SetItemText(index[i], 2, "X");
         m_list.SetItemText(index[i], 3, "");         
         m_list.SetItemText(index[i], 4, "");         
         }   
}

void Waller::OnRestore() 
{
	short i;
   for (i = 0; i < list_size; i++)
       if (m_list.GetItemState(index[i], LVIS_SELECTED) & LVIS_SELECTED)
         {
         wal_index[i].flags &= ~(TEXTURE_DIRT | TEXTURE_METAL | TEXTURE_TILES | TEXTURE_WOOD);
         m_list.SetItemText(index[i], 1, "");
         m_list.SetItemText(index[i], 2, "");
         m_list.SetItemText(index[i], 3, "");         
         m_list.SetItemText(index[i], 4, "");         
         }   
}

void Waller::OnSave() 
{
   CFile X;		// Input WAL file
	int i;
	miptex_t t;
	for (i = 0; i < list_size; i++)
		{
		if (!X.Open(wal_index[i].path, CFile::typeBinary|CFile::modeReadWrite))
			return;
		X.Read(&t, sizeof(t));
		t.flags = wal_index[i].flags;
		X.SeekToBegin();
		X.Write(&t, sizeof(t));
		}
}

void Waller::OnTiles() 
{
	short i;
   for (i = 0; i < list_size; i++)
       if (m_list.GetItemState(index[i], LVIS_SELECTED) & LVIS_SELECTED)
         {
         wal_index[i].flags &= ~(TEXTURE_DIRT | TEXTURE_METAL | TEXTURE_WOOD);
         wal_index[i].flags |= TEXTURE_TILES;
         m_list.SetItemText(index[i], 1, "");
         m_list.SetItemText(index[i], 2, "");
         m_list.SetItemText(index[i], 3, "X");         
         m_list.SetItemText(index[i], 4, "");
         }   
}

void Waller::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

BOOL Waller::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_list.SetBkColor(0x00000000);
   m_list.SetTextColor(0x0000A700);
   m_list.SetTextBkColor(0x0);	
	m_list.InsertColumn(0, "Texture", LVCFMT_LEFT, pDoc->logfont.lfWidth * 14);
   m_list.InsertColumn(1, "Dirt", LVCFMT_LEFT, pDoc->logfont.lfWidth * 8 - 2);   
   m_list.InsertColumn(2, "Metal", LVCFMT_LEFT, pDoc->logfont.lfWidth * 8 - 2);   
   m_list.InsertColumn(3, "Tile", LVCFMT_LEFT, pDoc->logfont.lfWidth * 8 - 2);   
	m_list.InsertColumn(4, "Wood", LVCFMT_LEFT, pDoc->logfont.lfWidth * 12 - 2);   
	// TODO: Add extra initialization here
	
	list_index = list_size = 0;
	wal_index = NULL;
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void Waller::OnDestroy() 
{
	if (wal_index)
		delete [] wal_index;
	if (index)
		delete [] index;	

	CDialog::OnDestroy();
}
