/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/

#include "stdafx.h"
#include "Life.h"
#include "LifeDoc.h"
#include "MainFrm.h"
#include "LifeView.h"
#include "Scene.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Scene dialog


Scene::Scene(CWnd* pParent /*=NULL*/)
	: CDialog(Scene::IDD, pParent)
{
	//{{AFX_DATA_INIT(Scene)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void Scene::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(Scene)
	DDX_Control(pDX, IDC_SLIDER1, m_gamma);
	DDX_Control(pDX, IDC_CREALTIME, m_realtime);
	DDX_Control(pDX, IDC_SCENELIST, m_list);
	DDX_Control(pDX, IDC_SPIN_INTERPOLATION, m_interpolation);
	DDX_Control(pDX, IDC_SPIN_FRAMEDELAY, m_framedelay);
	DDX_Control(pDX, IDC_CINTERPOLATION, m_interpolations);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(Scene, CDialog)
	//{{AFX_MSG_MAP(Scene)
	ON_BN_CLICKED(IDLOOPSTART, OnLoopstart)
	ON_BN_CLICKED(IDSOUND, OnSound)
	ON_BN_CLICKED(IDSTART, OnStart)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDEND, OnEnd)
	ON_BN_CLICKED(IDSAVE, OnSave)
	ON_BN_CLICKED(IDRESET, OnReset)
	ON_BN_CLICKED(IDLOAD, OnLoad)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Scene message handlers

void Scene::OnLoopstart() 
{
	short i = GetCurrentFrame();
	if (i >= 0)
		if (pView->loop_frame == i)
			pView->loop_frame = -1;
		else
			pView->loop_frame = i;
	UpdateList();
}

void Scene::OnSound() 
{
	int k, i;
	static char BASED_CODE szFilter[] = "Waves (*.WAV)|*.wav||";
   CFileDialog GetFile1(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
                        szFilter, NULL);   
   GetFile1.m_ofn.lpstrInitialDir = pDoc->env.sounddir;
	i = GetCurrentFrame();
	if (i < 0)
		return;
   if (GetFile1.DoModal())
		{
      if (GetFile1.GetFileExt() == "WAV" || GetFile1.GetFileExt() == "wav")
			{
			k = strlen(GetFile1.GetPathName());		
			if (pDoc->FrameSound[i])
				delete [] pDoc->FrameSound[i];
			pDoc->FrameSound[i] = new char [k];
			strcpy (pDoc->FrameSound[i], GetFile1.GetPathName());
			m_list.SetItemText(index[i], 4, pDoc->FrameSound[i]);
			return;
			}
		if (pDoc->FrameSound[i])
			delete [] pDoc->FrameSound[i];
		pDoc->FrameSound[i] = NULL;
		m_list.SetItemText(index[i], 4, "");
		}
}

int Scene::GetCurrentFrame() 
{
	short i, k;
	k = LVIS_SELECTED | LVIS_FOCUSED;
   for (i = 0; i < list_size; i++)
      if (m_list.GetItemState(index[i], k) & k)
			return i;
	return -1;
}

void Scene::OnStart() 
{
	short i = GetCurrentFrame();
	if (i >= 0)	
		pView->begin_frame = i;
	UpdateList();
}

void Scene::OnOK() 
{
	pView->framedelay = m_framedelay.GetPos();
	if (pView->framedelay > 2000)
		pView->framedelay = 2000;
	else if (pView->framedelay < 0)
		pView->framedelay = 1;
	
	pView->old_interpolations = m_interpolation.GetPos();
	if (pView->old_interpolations > 90)
		pView->old_interpolations = 90;
	else if (pView->old_interpolations < 0)
		pView->old_interpolations = 0;

	pView->realtime = m_realtime.GetCheck();

	if (m_interpolations.GetCheck())
		pView->interpolations = pView->old_interpolations;
	else
		pView->interpolations = 0;

	if (pView->begin_frame > pView->end_frame)
		pView->begin_frame = pView->end_frame;
	if (pView->loop_frame > pView->end_frame)
		pView->loop_frame = pView->end_frame;

	pView->gamma = m_gamma.GetPos();
	if (pView->imageTexture.glTexture &&  (pView->model_mode & MODEL_SKIN_LOADED))
		{
		pView->imageTexture.Gamma(pView->gamma);
		glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		glTexImage2D(GL_TEXTURE_2D, 0, 4, pView->imageTexture.m_iscaledWidth, 
			pView->imageTexture.m_iscaledHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, 
			pView->imageTexture.glTexture);
		}

	CDialog::OnOK();
}

BOOL Scene::OnInitDialog() 
{
	int i;
	char x[256];
	CDialog::OnInitDialog();
	
	m_list.SetBkColor(0x00000000);
   m_list.SetTextColor(0x0000A700);
   m_list.SetTextBkColor(0x0);	
	m_list.InsertColumn(0, "Frame", LVCFMT_LEFT, pDoc->logfont.lfWidth * 12);
   m_list.InsertColumn(1, "Start", LVCFMT_LEFT, pDoc->logfont.lfWidth * 8 - 2);   
   m_list.InsertColumn(2, "Loop", LVCFMT_LEFT, pDoc->logfont.lfWidth * 8 - 2);   
   m_list.InsertColumn(3, "End", LVCFMT_LEFT, pDoc->logfont.lfWidth * 8 - 2);   
	m_list.InsertColumn(4, "Sound", LVCFMT_LEFT, pDoc->logfont.lfWidth * 40);   
	list_index = list_size = 0;
	index = NULL;
	if (pView->md2Model.m_iFrames)
		index = new int[pView->md2Model.m_iFrames];
   for (i = 0; i < pView->md2Model.m_iFrames; i++)
		{
		sprintf (x, "%s[%d]", pView->md2Model.m_frame_list[i].name, i);
		index[i] = m_list.InsertItem(i, x);
		}
	list_size = i;

	OnReset();
   m_list.GetItemState(index[pView->frame], LVIS_SELECTED | LVIS_FOCUSED);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void Scene::OnDestroy() 
{
	if (index)	
		delete [] index;

	CDialog::OnDestroy();	
}
	

void Scene::OnEnd() 
{
	short i = GetCurrentFrame();
	if (i >= 0)	
		pView->end_frame = i;
	UpdateList();
}

void Scene::UpdateList()
{
  int i;
  for (i = 0; i < list_size; i++)
		{
		 if (pView->begin_frame == i)
			 m_list.SetItemText(index[i], 1, "X");
		 else 
			 m_list.SetItemText(index[i], 1, "");
		 if (pView->loop_frame == i)
			 m_list.SetItemText(index[i], 2, "X");
		 else 
			 m_list.SetItemText(index[i], 2, "");
		 if (pView->end_frame == i)
			 m_list.SetItemText(index[i], 3, "X");
		 else 
			 m_list.SetItemText(index[i], 3, "");
		 if (pDoc->FrameSound[i])
			 m_list.SetItemText(index[i], 4, pDoc->FrameSound[i]);
		 else 
			 m_list.SetItemText(index[i], 4, "");
		}	
}

void Scene::OnSave() 
{
	int k, i, j;
	static char BASED_CODE szFilter[] = "Scenes (*.SCN)|*.scn||";
   CFileDialog GetFile1(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
                        szFilter, NULL);   
   GetFile1.m_ofn.lpstrInitialDir = pDoc->env.loaddir;
	CFile X;
   if (GetFile1.DoModal())
		{
      if (GetFile1.GetFileExt() == "SCN" || GetFile1.GetFileExt() == "scn")
			{
			if (!X.Open(GetFile1.GetPathName(),
				CFile::typeBinary|CFile::modeWrite|CFile::shareExclusive|CFile::modeCreate))
				return;
			j = pView->md2Model.m_iFrames;
			X.Write (&j, sizeof(j));
			X.Write (&pView->begin_frame, sizeof(pView->begin_frame));
			X.Write (&pView->loop_frame, sizeof(pView->loop_frame));
			X.Write (&pView->end_frame, sizeof(pView->end_frame));
			X.Write (&pView->old_interpolations, sizeof(pView->old_interpolations));
			X.Write (&pView->interpolations, sizeof(pView->interpolations));
			X.Write (&pView->framedelay, sizeof(pView->framedelay));
			X.Write (&pView->m_xRotation, sizeof(pView->m_xRotation));
			X.Write (&pView->m_yRotation, sizeof(pView->m_yRotation));
			X.Write (&pView->m_xTranslation, sizeof(pView->m_xTranslation));
			X.Write (&pView->m_yTranslation, sizeof(pView->m_yTranslation));
			X.Write (&pView->m_zTranslation, sizeof(pView->m_zTranslation));
			X.Write (&pView->m_xScaling, sizeof(pView->m_xScaling));
			for (i = 0; i < j; i++)
				{
				if (pDoc->FrameSound[i])
					{				
					X.Write (&i, sizeof(i));
					k = strlen(pDoc->FrameSound[i]);
					X.Write (&k, sizeof(k));
					X.Write (pDoc->FrameSound[i], k);
					}
				}
			i = -1;
			X.Write (&i, sizeof(i));
			X.Close();
			return;
			}
		AfxMessageBox("File Not Save\nFile extension must be .scn");
		}		
}

void Scene::OnReset() 
{
	m_framedelay.SetRange(1, 2000);
	m_framedelay.SetPos(pView->framedelay);
	m_interpolation.SetRange(2, 90);
	//m_einterpolation.SetRange(2, 90);
	if (pView->interpolations)
		m_interpolation.SetPos(pView->interpolations);
	else
		m_interpolation.SetPos(pView->old_interpolations);
	m_gamma.SetPos(pView->gamma);
	m_gamma.SetRange (-50, 50, TRUE);
	m_interpolations.SetCheck(pView->interpolations);
	m_realtime.SetCheck(pView->realtime);
	UpdateList();
}

void Scene::OnLoad() 
{
	int k, i, j;
	static char BASED_CODE szFilter[] = "Scenes (*.SCN)|*.scn||";
   CFileDialog GetFile1(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
                        szFilter, NULL);   
   GetFile1.m_ofn.lpstrInitialDir = pDoc->env.loaddir;
	CFile X;
   if (GetFile1.DoModal())
		{
      if (GetFile1.GetFileExt() == "SCN" || GetFile1.GetFileExt() == "scn")
			{
			if (!X.Open(GetFile1.GetPathName(),
				CFile::typeBinary|CFile::modeRead|CFile::shareExclusive))
				return;
			for (i = 0; i < 512; i++)
				if (pDoc->FrameSound[i])
					{
					delete [] pDoc->FrameSound[i];
					pDoc->FrameSound[i] = NULL;
					}
			X.Read (&j, sizeof(j));
			X.Read (&pView->begin_frame, sizeof(pView->begin_frame));
			X.Read (&pView->loop_frame, sizeof(pView->loop_frame));
			X.Read (&pView->end_frame, sizeof(pView->end_frame));
			X.Read (&pView->old_interpolations, sizeof(pView->old_interpolations));
			X.Read (&pView->interpolations, sizeof(pView->interpolations));
			X.Read (&pView->framedelay, sizeof(pView->framedelay));
			X.Read (&pView->m_xRotation, sizeof(pView->m_xRotation));
			X.Read (&pView->m_yRotation, sizeof(pView->m_yRotation));
			X.Read (&pView->m_xTranslation, sizeof(pView->m_xTranslation));
			X.Read (&pView->m_yTranslation, sizeof(pView->m_yTranslation));
			X.Read (&pView->m_zTranslation, sizeof(pView->m_zTranslation));
			X.Read (&pView->m_xScaling, sizeof(pView->m_xScaling));
			do {
				X.Read (&i, sizeof(i));
				if (i >= 0)
					{
					X.Read (&k, sizeof(k));
					pDoc->FrameSound[i] = new char[k + 1];
					X.Read (pDoc->FrameSound[i], k);
					}
				} while (i >= 0);
			X.Close();
			m_framedelay.SetPos(pView->framedelay);
			if (pView->interpolations)
				m_interpolation.SetPos(pView->interpolations);
			else
				m_interpolation.SetPos(pView->old_interpolations);		
			m_interpolations.SetCheck(pView->interpolations);
			m_realtime.SetCheck(pView->realtime);
			UpdateList();
			return;
			}
		}		
}
