/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/

#if !defined(AFX_MD2_H__4EC2FFE0_FF4E_11D2_A9D8_444553540000__INCLUDED_)
#define AFX_MD2_H__4EC2FFE0_FF4E_11D2_A9D8_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


#define MAX_TRIANGLES	4096
#define MAX_VERTS			2048
#define MAX_FRAMES		512
#define MAX_MD2SKINS		32
#define MAX_SKINNAME		64

typedef struct
{
	int a, b, c;
	int a_s, a_t,
		 b_s, b_t,
		 c_s, c_t;
} make_index_list;

typedef struct
{
	float x, y, z;
} make_vertex_list;

typedef struct
{
	make_vertex_list *vertex;
	char name[16];
} make_frame_list;

typedef unsigned char byte;

typedef struct
{
	float v[3];
} md2_vec3_t;

typedef struct
{
	short s;
	short t;
} dstvert_t;

typedef struct 
{
	short index_xyz[3];
	short index_st[3];
} dtriangle_t;


typedef struct
{
	byte v[3];
	byte lightnormalindex;
} dtrivertx_t;

typedef struct
{
	float scale[3];
	float translate[3];
	char name[16];
	dtrivertx_t verts[1];

} daliasframe_t;

typedef struct
{
	int ident;
	int version;

	int skinwidth;
	int skinheight;
	int framesize;

	int num_skins;
	int num_xyz;
	int num_st;
	int num_tris;
	int num_glcmds;
	int num_frames;

	int ofs_skins;
	int ofs_st;
	int ofs_tris;
	int ofs_frames;
	int ofs_glcmds; 
	int ofs_end;

} dmdl_t;

typedef struct
{
        md2_vec3_t          v;
        int		lightnormalindex;
} trivert_t;

typedef struct
{
        md2_vec3_t          mins, maxs;
        char            name[16];
        trivert_t       v[MAX_VERTS];
} frame_t;

//////////////////////////////////////////////////////////////////////////////////////

class CMD2 {

friend void redraw (int);

public:
	CMD2();
	~CMD2();

	int Read (char []);
	void Destroy (void);

	inline long getnumberFrames (void) {return (long)m_iFrames;};
	inline long getnumberVertices (void) {return (long)m_iVertices;};
	inline long getnumberTriangles (void){return (long)m_iTriangles;};

	void SafeRead (FILE *f, void *buffer, int count) {fread (buffer, 1, count, f);}

	make_index_list *m_index_list;
	make_frame_list *m_frame_list;
	long m_iFrames, m_iVertices, m_iTriangles;
private:
};


#endif // !defined(AFX_MD2_H__4EC2FFE0_FF4E_11D2_A9D8_444553540000__INCLUDED_)
