/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/

#include "stdafx.h"
#include "Life.h"
#include "MD2.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMD2::CMD2 ()
{
	m_index_list = NULL;
	m_frame_list = NULL;
	m_iFrames = m_iVertices = m_iTriangles = 0;
}

CMD2::~CMD2 ()
{
	int i;

	if (m_frame_list != NULL) {

		for (i = 0; i < m_iFrames; i++)
			delete [] m_frame_list[i].vertex;

		delete [] m_frame_list;
	}

	if (m_index_list != NULL)
		delete [] m_index_list;
}

void CMD2::Destroy (void)
{
	int i;

	if (m_frame_list != NULL) {

		for (i = 0; i < m_iFrames; i++)
			delete [] m_frame_list[i].vertex;

		delete [] m_frame_list;
		m_frame_list = NULL;
	}

	if (m_index_list != NULL) {
		delete [] m_index_list;
		m_index_list = NULL;
	}
	m_iFrames = 0;
}

int CMD2::Read (char filename[])
{
	FILE		*modelfile = NULL;
	char		g_skins[MAX_MD2SKINS][64];
	dstvert_t	base_st[MAX_VERTS];
	byte		buffer[MAX_VERTS*4+128];
	dmdl_t		modelheader;

	dtriangle_t     tri;
	daliasframe_t	*out;

	int i, j;

	if ((modelfile = fopen (filename, "rb")) == NULL)
		return 0;

	SafeRead (modelfile, &modelheader, sizeof(modelheader));

	modelheader.framesize = (int)&((daliasframe_t *)0)->verts[modelheader.num_xyz];

	////////////////////////////////////////////////////

	m_iFrames		= modelheader.num_frames;
	m_iVertices		= modelheader.num_xyz;
	m_iTriangles	= modelheader.num_tris;

	m_index_list = new make_index_list [modelheader.num_tris];
	m_frame_list = new make_frame_list [modelheader.num_frames];

	for (i = 0; i < modelheader.num_frames; i++)
		m_frame_list[i].vertex = new make_vertex_list [modelheader.num_xyz];

	////////////////////////////////////////////////////

	SafeRead (modelfile, g_skins, modelheader.num_skins * MAX_SKINNAME);

	SafeRead (modelfile, base_st, modelheader.num_st * sizeof(base_st[0]));

	for (i = 0; i < modelheader.num_tris; i++) {
		SafeRead (modelfile, &tri, sizeof(dtriangle_t));

		(m_index_list)[i].a = tri.index_xyz[2];
		(m_index_list)[i].b = tri.index_xyz[1];
		(m_index_list)[i].c = tri.index_xyz[0];

		(m_index_list)[i].a_s = base_st[tri.index_st[2]].s;
		(m_index_list)[i].a_t = base_st[tri.index_st[2]].t;
		(m_index_list)[i].b_s = base_st[tri.index_st[1]].s;
		(m_index_list)[i].b_t = base_st[tri.index_st[1]].t;
		(m_index_list)[i].c_s = base_st[tri.index_st[0]].s;
		(m_index_list)[i].c_t = base_st[tri.index_st[0]].t;
	}

	for (i = 0; i < modelheader.num_frames; i++) {

		out = (daliasframe_t *)buffer;

		SafeRead (modelfile, out, modelheader.framesize);

		for (j = 0; j < modelheader.num_xyz; j++) {

			(m_frame_list)[i].vertex[j].x = out->verts[j].v[0] * out->scale[0] + out->translate[0];
			(m_frame_list)[i].vertex[j].y = out->verts[j].v[1] * out->scale[1] + out->translate[1];
			(m_frame_list)[i].vertex[j].z = out->verts[j].v[2] * out->scale[2] + out->translate[2];
		}
		strcpy((m_frame_list)[i].name, out->name);
	}

	fclose (modelfile);
	return 1;
}