/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/

#if !defined(AFX_LIFEVIEW_H__79D3612C_663D_11D2_86B4_444553540000__INCLUDED_)
#define AFX_LIFEVIEW_H__79D3612C_663D_11D2_86B4_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#define CONSOLE_HIGHLIGHT 1
#define CONSOLE_DISPLAY   2
#define CONSOLE_CLEAR     4

#define MODEL_WIREFRAME		1
#define MODEL_TEXTURED		2
#define MODEL_LIGHTS			4
#define MODEL_SMOOTH			8
#define MODEL_SKIN_LOADED	16
#define MODEL_LOADED			32
#define MODEL_MIPMAPPED		64
#define MODEL_FIRSTPERSON	128
#define MODEL_STOPMOTION	256


#include "md2.h"
#include "image.h"
#include "compiler.h"

class CLifeView : public CView
{
	int next_frame;
	int interpolation;
	float frame_x[3], frame_y[3], frame_z[3];
	float frame_x_delta[3], frame_y_delta[3], frame_z_delta[3];
	char last_command[256];
	int old_lx;

	// OpenGL specific
	GLubyte rasters[2050];
	BOOL SetWindowPixelFormat(HDC hDC);
	BOOL CreateViewGLContext(HDC hDC);
	HGLRC m_hGLContext;
	int m_GLPixelIndex;

	// Mouse 
	BOOL m_LeftButtonDown;
	BOOL m_RightButtonDown;
	CPoint m_LeftDownPos;
	CPoint m_RightDownPos;
	HCURSOR m_CursorRotation;
	int	old_mouse_y;
	int	old_mouse_x;
	int	old_mouse_button;

	// Position, rotation ,scaling
	void InitGeometry(void);

	// Colors
	float m_ClearColorRed;
	float m_ClearColorGreen;
	float m_ClearColorBlue;

protected: // create from serialization only
	CLifeView();
	DECLARE_DYNCREATE(CLifeView)

// Attributes
public:
	CLifeDoc *GetDocument();
   CLifeDoc *pDoc;
	CPaintDC *dc; 
   CMainFrame *pMainWnd;
	Ccompiler cmp;
	HWND hWnd;
	HDC hDC;

	CMD2 md2Model;
	CImage imageTexture;	
	int begin_frame, end_frame, loop_frame, frame;
	int interpolations;
	int old_interpolations;
	int framedelay;
	int realtime;
	float m_xRotation, xRotation;
	float m_yRotation, yRotation;
	float m_zRotation, zRotation;
	float m_xTranslation, xTranslation;
	float m_yTranslation, yTranslation;
	float m_zTranslation, zTranslation;
	float m_xScaling, xScaling;
	float m_yScaling, yScaling;
	float m_zScaling, zScaling;
	int gamma;
   bool openbracket;
	int OpenGL;
	int model_mode;
// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CLifeView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	//}}AFX_VIRTUAL

// Implementation
public:
	void QuarkTexture ();
	void RenderScene();
	virtual ~CLifeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CLifeView)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnCancelMode();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnAppExit();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnDestroy();
	afx_msg void OnFileOpen();
	afx_msg void OnActionClearscreen();
	afx_msg void OnHelpHome();
	afx_msg void OnActionStatus();
	afx_msg void OnHelpCommandlist();
	afx_msg void OnActionQuake2();
	afx_msg void OnActionEnvironment();
	afx_msg void OnHelpSupport();
	afx_msg void OnFileEdit();
	afx_msg void OnActionSaveoptions();
	afx_msg void OnToolsWalflags();
	afx_msg void OnPaint();
	afx_msg void OnCaptureChanged(CWnd *pWnd);
	afx_msg void OnFormatOpengl();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnUpdateFormatOpenglOn(CCmdUI* pCmdUI);
	afx_msg void OnFormatOpenglWireframe();
	afx_msg void OnUpdateFormatOpenglWireframe(CCmdUI* pCmdUI);
	afx_msg void OnToolsModelsLoad();
	afx_msg void OnToolsModelsSkin();
	afx_msg void OnFormatOpenglTextured();
	afx_msg void OnUpdateFormatOpenglTextured(CCmdUI* pCmdUI);
	afx_msg void OnFormatOpenglLights();
	afx_msg void OnUpdateFormatOpenglLights(CCmdUI* pCmdUI);
	afx_msg void OnFormatOpenglMipmapping();
	afx_msg void OnUpdateFormatOpenglMipmapping(CCmdUI* pCmdUI);
	afx_msg void OnFormatOpenglShaded();
	afx_msg void OnUpdateFormatOpenglShaded(CCmdUI* pCmdUI);
	afx_msg void OnToolsSceneeditor();
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnFormatOpenglFirstperson();
	afx_msg void OnUpdateFormatOpenglFirstperson(CCmdUI* pCmdUI);
	afx_msg void OnViewSmallerfont();
	afx_msg void OnViewLargerfont();
	afx_msg void OnActionLastcommand();
	afx_msg void OnToolsStopmotion();
	afx_msg void OnUpdateToolsStopmotion(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	//afx_msg void OnPaint();
private:
	void GL_Print (float x, float y, char *);
	void RenderFrame();
	void SetOpenGLMode();
	int SaveOptions();
	void LoadOptions();
	void NewLine();
	void ScrollUp();
	int ExecLine();
};

#ifndef _DEBUG  // debug version in LifeView.cpp
inline CLifeDoc* CLifeView::GetDocument()
   { return (CLifeDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_LIFEVIEW_H__79D3612C_663D_11D2_86B4_444553540000__INCLUDED_)
