/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/


#include "stdafx.h"
#include "Life.h"

#include "MainFrm.h"
#include "LifeDoc.h"
#include "compiler.h"
#include "LifeView.h"
#include "Enviro.h"
#include "mmsystem.h"
#include "waller.h"

#include "scene.h"

#include <gl/gl.h>
#include <gl/glu.h>

//#include "rodcone.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

UINT GL_Thread(LPVOID param);
/////////////////////////////////////////////////////////////////////////////
// CLifeView

#define PLAY_OPENGL_STOP	0
#define PLAY_OPENGL_NOW		1
#define PLAY_OPENGL_SOON	2


IMPLEMENT_DYNCREATE(CLifeView, CView)

BEGIN_MESSAGE_MAP(CLifeView, CView)
	//{{AFX_MSG_MAP(CLifeView)
	ON_WM_CHAR()
	ON_WM_CANCELMODE()
	ON_WM_CREATE()
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_ACTION_CLEARSCREEN, OnActionClearscreen)
	ON_COMMAND(ID_HELP_HOME, OnHelpHome)
	ON_COMMAND(ID_ACTION_STATUS, OnActionStatus)
	ON_COMMAND(ID_HELP_COMMANDLIST, OnHelpCommandlist)
	ON_COMMAND(ID_ACTION_QUAKE2, OnActionQuake2)
	ON_COMMAND(ID_ACTION_ENVIRONMENT, OnActionEnvironment)
	ON_COMMAND(ID_HELP_SUPPORT, OnHelpSupport)
	ON_COMMAND(ID_FILE_EDIT, OnFileEdit)
	ON_COMMAND(ID_ACTION_SAVEOPTIONS, OnActionSaveoptions)
	ON_COMMAND(ID_TOOLS_WALFLAGS, OnToolsWalflags)
	ON_WM_PAINT()
	ON_WM_CAPTURECHANGED()
	ON_COMMAND(ID_FORMAT_OPENGL_ON, OnFormatOpengl)
	ON_WM_KEYDOWN()
	ON_WM_SIZE()
	ON_WM_MOUSEMOVE()
	ON_UPDATE_COMMAND_UI(ID_FORMAT_OPENGL_ON, OnUpdateFormatOpenglOn)
	ON_COMMAND(ID_FORMAT_OPENGL_WIREFRAME, OnFormatOpenglWireframe)
	ON_UPDATE_COMMAND_UI(ID_FORMAT_OPENGL_WIREFRAME, OnUpdateFormatOpenglWireframe)
	ON_COMMAND(ID_TOOLS_MODELS_LOAD, OnToolsModelsLoad)
	ON_COMMAND(ID_TOOLS_MODELS_SKIN, OnToolsModelsSkin)
	ON_COMMAND(ID_FORMAT_OPENGL_TEXTURED, OnFormatOpenglTextured)
	ON_UPDATE_COMMAND_UI(ID_FORMAT_OPENGL_TEXTURED, OnUpdateFormatOpenglTextured)
	ON_COMMAND(ID_FORMAT_OPENGL_LIGHTS, OnFormatOpenglLights)
	ON_UPDATE_COMMAND_UI(ID_FORMAT_OPENGL_LIGHTS, OnUpdateFormatOpenglLights)
	ON_COMMAND(ID_FORMAT_OPENGL_MIPMAPPING, OnFormatOpenglMipmapping)
	ON_UPDATE_COMMAND_UI(ID_FORMAT_OPENGL_MIPMAPPING, OnUpdateFormatOpenglMipmapping)
	ON_COMMAND(ID_FORMAT_OPENGL_SHADED, OnFormatOpenglShaded)
	ON_UPDATE_COMMAND_UI(ID_FORMAT_OPENGL_SHADED, OnUpdateFormatOpenglShaded)
	ON_COMMAND(ID_TOOLS_SCENEEDITOR, OnToolsSceneeditor)
	ON_WM_KILLFOCUS()
	ON_COMMAND(ID_FORMAT_OPENGL_FIRSTPERSON, OnFormatOpenglFirstperson)
	ON_UPDATE_COMMAND_UI(ID_FORMAT_OPENGL_FIRSTPERSON, OnUpdateFormatOpenglFirstperson)
	ON_COMMAND(ID_VIEW_SMALLERFONT, OnViewSmallerfont)
	ON_COMMAND(ID_VIEW_LARGERFONT, OnViewLargerfont)
	ON_COMMAND(ID_ACTION_LASTCOMMAND, OnActionLastcommand)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_TOOLS_STOPMOTION, OnToolsStopmotion)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_STOPMOTION, OnUpdateToolsStopmotion)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLifeView construction/destruction

CLifeView::CLifeView()
{
   openbracket = 0;
	// OpenGL
	m_hGLContext = NULL;
	m_GLPixelIndex = 0;
	
	// Mouse
	m_LeftButtonDown = FALSE;
	m_RightButtonDown = FALSE;
	//m_CursorRotation = AfxGetApp()->LoadCursor(); //IDC_CURSOR_ROTATION

	// Colors
	m_ClearColorRed   = GetRValue(0);
	m_ClearColorGreen = GetGValue(0);
	m_ClearColorBlue  = GetBValue(0);
}

CLifeView::~CLifeView()
{
}

BOOL CLifeView::PreCreateWindow(CREATESTRUCT& cs)
{
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CLifeView drawing

void CLifeView::OnDraw(CDC* pDC)
{
	if (OpenGL)
		{
		CView::OnDraw(pDC);
		return;
		}
   static RECT Rectangle;
   short i  = 0;   
   COLORREF temp;
   CFont *font, *oldFont;
   CRect rect;
   //pMainWnd->ChangeOrbitPane("Ready");
   GetClientRect(&Rectangle);
   pDoc->max_lines = (short) ((Rectangle.bottom - Rectangle.top) / pDoc->logfont.lfHeight) - 1;
   temp = pDC->GetBkColor();
   temp = pDC->SetBkColor(0x00000000);
   font = new CFont();
   font->CreateFontIndirect(&(pDoc->logfont));
   oldFont = pDC->SelectObject(font);
   CSize docSize(100, 20 * pDoc->logfont.lfHeight);
   GetClientRect(&rect);
   CSize pageSize(rect.right, rect.bottom);
   CSize lineSize(0, pDoc->logfont.lfHeight);
   if (pDoc->m_display == CONSOLE_HIGHLIGHT)
      {
      pDoc->console_foreground = 0xFF;
      pDoc->m_display = CONSOLE_DISPLAY;
      }
   //else
      //pDoc->console_foreground = 0x0000AA00;

   
   switch (pDoc->m_display)
      {
      case 0:
         break;      

      case CONSOLE_CLEAR:
         pDC->SetBkColor(pDoc->console_background);
         pDC->SetTextColor(0x0000 | pDoc->console_foreground << 8);
         pDoc->ly = 0; 
         pDoc->lx = 3;
         for (i = 0; i < 50; i++)
            {
            memset(pDoc->dline[i], ' ', 254);
            *(pDoc->dline[i] + 255) = '\0';            
            }                  
         *(pDoc->dline[0])= 'O';
			*(pDoc->dline[0] + 1)= 'K';
         *(pDoc->dline[0] + 2)= '>';
         *(pDoc->dline[pDoc->ly] + pDoc->lx) = 27;
      case CONSOLE_DISPLAY:
         pDC->SetBkColor(pDoc->console_background);
			int len, v, x, width = pDoc->logfont.lfWidth, height = pDoc->logfont.lfHeight;  
			
         for (i = 0; i < 50; i++)
            {
				pDC->SetTextColor(0x0000 | pDoc->console_foreground << 8);
				len = strlen(pDoc->dline[i]);
				x = -1;
				for (v = 0; v < len; v ++)
					{					
					if (v < len - 4)
						{
						if ((*(pDoc->dline[i] + v) == '&') && (*(pDoc->dline[i] + v + 1) == 'c'))
							{
							v += 2;
							int r = (*(pDoc->dline[i] + v++) - '0') << 5,
								 g = (*(pDoc->dline[i] + v++) - '0') << 5,
								 b = (*(pDoc->dline[i] + v++) - '0') << 5;
							//char x[256];
							//sprintf (x, "r = %d", r >> 20);
							//AfxMessageBox(x);
							pDC->SetTextColor(b << 16 | g << 8 | r);
							}
						else if ((*(pDoc->dline[i] + v) == '&') && (*(pDoc->dline[i] + v + 1) == 'r'))
							{
							v += 2;
							pDC->SetTextColor(0x0000 | pDoc->console_foreground << 8);
							}
						else
							x++;
						}
					else
						x++;
					pDC->TextOut(pDoc->x_pos + (x * width), 
									 pDoc->y_pos + (i * height),  
							       *(pDoc->dline[i] + v)); 					
					}
				x++;
				pDC->TextOut(pDoc->x_pos + (x * width), 
								pDoc->y_pos + (i * height),  
							   "                                                                                                        "); 

				/*
            sprintf(pDoc->dline[i], "%-255s", pDoc->dline[i]);
            pDC->TextOut(pDoc->x_pos, i * pDoc->logfont.lfHeight 
                        + pDoc->y_pos, 
                        pDoc->dline[i]);
				*/
            }                                       
         break;
      }
   pDC->SelectObject(oldFont);


}

/////////////////////////////////////////////////////////////////////////////
// CLifeView diagnostics

#ifdef _DEBUG
void CLifeView::AssertValid() const
{
	CView::AssertValid();
}

void CLifeView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CLifeDoc* CLifeView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CLifeDoc)));
	return (CLifeDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLifeView message handlers

void CLifeView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	pDoc->m_display = CONSOLE_DISPLAY;
	Invalidate(FALSE);
	if (OpenGL)
		{
		OpenGL = PLAY_OPENGL_STOP;
		return;
		}

   switch (nChar)
      {
      case '\t':
      case '\r':
      //case 13:
         openbracket = 0;
         ScrollUp();
         break;
      case '\b':
         if (*(pDoc->dline[pDoc->ly] + pDoc->lx - 1) == '\"')
            {
            if (openbracket == true)
               openbracket = false;
            else
               openbracket = true;            
            }
         *(pDoc->dline[pDoc->ly] + pDoc->lx) = ' ';
         if (pDoc->lx > 3) pDoc->lx--;
         *(pDoc->dline[pDoc->ly] + 
         pDoc->lx) = ' ';
         break;
      case 27:
         break;
      case '\"':
         if (openbracket == true)
            openbracket = false;
         else
            openbracket = true;
      default:
         if (pDoc->lx < 254)
            if (openbracket)
               *(pDoc->dline[pDoc->ly] + pDoc->lx++) = nChar;
            else
               *(pDoc->dline[pDoc->ly] + pDoc->lx++) = tolower(nChar);
      }
   *(pDoc->dline[pDoc->ly] + pDoc->lx) = 27;
	CView::OnChar(nChar, nRepCnt, nFlags);
}

void CLifeView::OnCancelMode() 
{
	CView::OnCancelMode();
	
	// TODO: Add your message handler code here
	
}

int CLifeView::ExecLine()
{
   pMainWnd = (CMainFrame *) AfxGetMainWnd();
   short i;
   for (i = strlen(pDoc->commandline); pDoc->commandline[i] <= 32; i--)
      pDoc->commandline[i] = 0;
   if (!strcmp(pDoc->commandline, "clear"))
      {
      pDoc->m_display = CONSOLE_CLEAR;
      Invalidate();
      return 1;
      }
   if (!strcmp(pDoc->commandline, "font--"))
      {
		pDoc->logfont.lfWidth--;     
		pDoc->logfont.lfHeight--;
		Invalidate(TRUE);
      return 1;
      }
   if (!strcmp(pDoc->commandline, "font++"))
      {
		pDoc->logfont.lfWidth++;     
		pDoc->logfont.lfHeight++;     
		Invalidate(TRUE);
      return 1;
      }
   if (!strcmp(pDoc->commandline, "env"))
      {
      Enviro E;
      E.pDoc = pDoc;
      E.DoModal();	
      return 1;
      }
   if (!strcmp(pDoc->commandline, "exit") || !strcmp(pDoc->commandline, "quit"))
      {
      pMainWnd->PostMessage(WM_CLOSE, 0, 0);
      return 1;
      }
   if (!strcmp(pDoc->commandline, "version"))
      {
      sprintf(pDoc->dline[pDoc->ly], "LifeScript(tm) Compiler Version &c700 %.2f", pDoc->version);
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "Copyright (c) 1998-1999 Endor Productions");
      NewLine();
      sprintf(pDoc->dline[pDoc->ly], "Written by Nawfel Tricha");
      NewLine();
      return 1;
      }
   if (!strcmp(pDoc->commandline, "status"))
      {
      cmp.DisplayStatus();
      return 1;
      }
   if (!strcmp(pDoc->commandline, "home"))
      {
      ShellExecute(NULL, "open", "http://www.endorproductions.com", NULL, NULL,
                 SW_SHOWNORMAL);
      return 1;
      }
   if (!strcmp(pDoc->commandline, "cmdlist") || !strcmp(pDoc->commandline, "help"))
      {
      short h = 1;
      short k = 0, j = 0, z = 0;
      char x[256];
      for (i = pDoc->commandlist; pDoc->bnf[i].syntax; i++)
         {
         k = 0; 
         j = 0;
         if (pDoc->bnf[i].usage)
            {
				memset(pDoc->dline[pDoc->ly], '-', 254);
				NewLine();
				if (h++ > pDoc->max_lines - 1)
					{
               pDoc->commandlist = i;
               return 1;
               }
            sprintf(pDoc->dline[pDoc->ly], "-> &c660 COMMAND &c600 %d:", i);
            NewLine();
				z = 0;
				if (h++ > pDoc->max_lines - 1)
					{
               pDoc->commandlist = i;
               return 1;
               }
            while (pDoc->bnf[i].usage[j])
               {
               while (pDoc->bnf[i].usage[j] && pDoc->bnf[i].usage[j] != '\n' && k < 255)
                  x[k++] = pDoc->bnf[i].usage[j++];
               x[k] = 0;
					if (!z)
						{
						z = 1;
						sprintf(pDoc->dline[pDoc->ly], "&c660      %s", x);
						NewLine();               
						}
					else
						{
						sprintf(pDoc->dline[pDoc->ly], "     %s", x);
						NewLine();
						}
               j++;
               k = 0;
               if (h++ > pDoc->max_lines - 1)
                  {
                  pDoc->commandlist = i;
                  return 1;
                  }
               }
            }
         }
      pDoc->commandlist = 0;
      return 1;
      }
   if (!strcmp(pDoc->commandline, "quake2"))
      {
      char x[1024] = {0}, v[1024] = {0};
      sprintf(x, "%squake2.exe", pDoc->env.quakedir);
      if (pDoc->env.quakeparams[0])
         sprintf(v, "%s", pDoc->env.quakeparams);
      if (pDoc->env.quakegame[0])
         sprintf(v, "%s +set game \"%s\"", v, pDoc->env.quakegame);
      if (pDoc->env.quakemap[0])
         sprintf(v, "%s +map %s", v, pDoc->env.quakemap);
      if (pDoc->env.disconnect)
         sprintf(v, "%s +disconnect", v);
      sprintf(pDoc->dline[pDoc->ly], " -> %s %s", x, v);
      NewLine();
      ShellExecute(NULL, "open", x, v, pDoc->env.quakedir, SW_SHOW);
      return 1;
      }
   if (pDoc->commandline[0])
      switch (cmp.parse())
         {
         case -2:
            sprintf(pDoc->dline[pDoc->ly], "No EOL in current statement. Use semicolon.");
            NewLine();
            return 0;
            break;
         case -1:
            sprintf(pDoc->dline[pDoc->ly], "Bad instruction or system data.");
            NewLine();
            return 0;
            break;
         case 0:
            cmp.ShowUsage(pDoc->commandindex);
            return 0;
            break;
         case FORMAT_EDITOR:
            cmp.ApplyCommand();
            break;
         }  
    return 1;
}
void CLifeView::ScrollUp()
{   
   //*(pDoc->dline[pDoc->ly] + pDoc->lx) = 0; 
	strcpy (last_command, pDoc->dline[pDoc->ly]);
	old_lx = pDoc->lx;
	*(pDoc->dline[pDoc->ly] + pDoc->lx) = ' ';
   memcpy(pDoc->commandline, pDoc->dline[pDoc->ly] + 3, 252);
   NewLine();
   ExecLine();
}

int CLifeView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
   pDoc = GetDocument();
   pMainWnd = (CMainFrame *) AfxGetMainWnd();
	hWnd = GetSafeHwnd();
	hDC = ::GetDC(hWnd);
	cmp.pDoc = pDoc;
	cmp.pMainWnd = pMainWnd;
	dc = new CPaintDC(this);
   pDoc->max_lines = 10;
	GetCurrentDirectory(256, pDoc->PathName);
	strcpy(last_command, "OK>version");
	old_lx = 10;
	last_command[old_lx] = 27;
   sprintf(pDoc->dline[pDoc->ly], "&c660 Entron LifeScript(tm) Compiler");
   NewLine();
   sprintf(pDoc->dline[pDoc->ly], "(c) 1998-1999 Endor Productions. All rights reserved.");
   NewLine();
   sprintf(pDoc->dline[pDoc->ly], "Current version: &c600 %.2f", pDoc->version);
   NewLine();
   sprintf(pDoc->dline[pDoc->ly], "&c444 Loading Options...");
   NewLine();
   LoadOptions();
	//HWND hWnd = GetSafeHwnd();
	//HDC hDC = ::GetDC(hWnd);
   sprintf(pDoc->dline[pDoc->ly], "&c444 Spawning OpenGL server...");
   NewLine();		
   sprintf(pDoc->dline[pDoc->ly], "&c444 [Done]");
   NewLine();		
   sprintf(pDoc->dline[pDoc->ly], "  ");
   NewLine();		
	
	pDoc->logfont.lfWidth--;
	pDoc->logfont.lfHeight--;

   pDoc->m_display = CONSOLE_DISPLAY;
   Invalidate();
	wglMakeCurrent(hDC, m_hGLContext);
	if (SetWindowPixelFormat(hDC)==FALSE)
		return 0;
	
	if (CreateViewGLContext(hDC)==FALSE)
		return 0;
	model_mode |= MODEL_TEXTURED | MODEL_SMOOTH | MODEL_LIGHTS;
	glDepthFunc( GL_LEQUAL );
	SetOpenGLMode();
	OpenGL = 0;
	interpolations = 15;
	old_interpolations = 0;
	framedelay = 10;
	return 0;
}


void CLifeView::NewLine()
{
   pDoc->m_display = CONSOLE_DISPLAY;   
   if (pDoc->ly < pDoc->max_lines) 
      pDoc->ly++;
   else
      {
      for (short i = 1; i < 50; i++)
         {
         memcpy(pDoc->dline[i - 1], 
                pDoc->dline[i], 255);
         }      
      }  
   pDoc->lx = 3;
   *(pDoc->dline[pDoc->ly])= 'O';
   *(pDoc->dline[pDoc->ly] + 1)= 'K';
   *(pDoc->dline[pDoc->ly] + 2)= '>';
   *(pDoc->dline[pDoc->ly] + pDoc->lx) = 27;
}

//#include "LViewCmd.cpp"
//#include "LViewExe.cpp"
//#include "LViewCmp.cpp"

void CLifeView::OnAppExit() 
{
   sprintf(pDoc->commandline, "exit");
   ExecLine();	
}

BOOL CLifeView::OnEraseBkgnd(CDC* pDC) 
{
     // Set brush to desired background color
     CBrush backBrush(RGB(0, 0, 0));

     // Save old brush
     CBrush* pOldBrush = pDC->SelectObject(&backBrush);

     CRect rect;
     pDC->GetClipBox(&rect);     // Erase the area needed

     pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);
     pDC->SelectObject(pOldBrush);
     return TRUE;	
	   //return CView::OnEraseBkgnd(pDC);
}



void CLifeView::LoadOptions()
{
   CFile X;  
   int i;
   if (!X.Open("Life.CFG",    
      CFile::typeBinary|CFile::modeRead|CFile::shareExclusive))   
      {
      sprintf(pDoc->dline[pDoc->ly], "&c600 Warning: Life option file not loaded.");
  	   NewLine();
	   }
   else
      {
      X.Read (&pDoc->env, sizeof(pDoc->env));
      X.Close();
      }
   if (!X.Open("Life.ras", 
      CFile::typeBinary|CFile::modeRead|CFile::shareExclusive))   
	   {
      sprintf(pDoc->dline[pDoc->ly], "&c600 Warning: Life Font not loaded.");
  	   NewLine();
      return;
	   }
   for (i = 0; i < 256; i++)
      {
      X.Read(rasters + (i * 8) + 7, 1);
      X.Read(rasters + (i * 8) + 6, 1);
      X.Read(rasters + (i * 8) + 5, 1);
      X.Read(rasters + (i * 8) + 4, 1);
      X.Read(rasters + (i * 8) + 3, 1);
      X.Read(rasters + (i * 8) + 2, 1);
      X.Read(rasters + (i * 8) + 1, 1);
      X.Read(rasters + (i * 8), 1);
      }
   X.Close();

}

int CLifeView::SaveOptions()
{
   CFile X;
   char x[256];
   sprintf(x, "%s\\life.cfg", pDoc->PathName);
   if (!X.Open(x, CFile::typeBinary|CFile::modeWrite | CFile::modeCreate))   
      return 0;
   X.Write (&pDoc->env, sizeof(pDoc->env));
   X.Close();
	return 1;
}


void CLifeView::OnDestroy() 
{
	OpenGL = 0;
   SaveOptions();	
	md2Model.Destroy ();
	imageTexture.Destroy ();
	wglMakeCurrent(hDC, NULL);
	CView::OnDestroy();	
}



void CLifeView::OnFileOpen() 
{
   short i = 0;
   static char BASED_CODE szFilter[] = 
         "Scripts (*.SCR)|*.scr|"
         "Binary (*.BIN)|*.bin|"
         "Config (*.CFG)|*.cfg||";
   CFileDialog GetFile1(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
                        szFilter, NULL);   
   GetFile1.m_ofn.lpstrInitialDir = pDoc->env.loaddir;
   if (GetFile1.DoModal())
      if (GetFile1.GetFileName() != "")
         {
         //if (GetFile1.GetFileExt() == "scr")
            //GetFile1.GetPathName();            
         if (GetFile1.GetFileExt() == "SCR" || GetFile1.GetFileExt() == "scr")
            {
            strcpy(pDoc->env.loaddir, GetFile1.GetPathName());
            i = strlen(pDoc->env.loaddir);
            while (pDoc->env.loaddir[i] != '\\' && i)
               i--;
            pDoc->env.loaddir[i + 1] = 0;
            //sprintf(pDoc->env.loaddir, "%s%s.scr", pDoc->env.loaddir, GetFile1.GetFileName());
            sprintf(pDoc->FileIn, "%s%s.scr", pDoc->env.loaddir, GetFile1.GetFileTitle());
            sprintf(pDoc->FileOut, "%s%s.dat", pDoc->env.savedir, GetFile1.GetFileTitle());
            memset(pDoc->dline[pDoc->ly], '-', 254);
            NewLine();
            sprintf(pDoc->dline[pDoc->ly], " ->Compiling... %s", pDoc->FileIn);
            NewLine();
            switch (cmp.Compile())
               {
               case -2:
                  sprintf(pDoc->dline[pDoc->ly], "&c600 File %s not found.", pDoc->FileIn);
                  NewLine();
                  break;
               case -3:
                  sprintf(pDoc->dline[pDoc->ly], "&c600 Cannot open file %s.", pDoc->FileOut);
                  NewLine();
                  break;
               case 1:
                  sprintf(pDoc->dline[pDoc->ly], "Compile successful. &c660 %d &r instructions. &c660 %d &r bytes",
                     pDoc->current_instruction, pDoc->current_instruction * sizeof(pDoc->script));
                  NewLine();
                  break;
               }
            memset(pDoc->dline[pDoc->ly], '-', 254);
            NewLine();
            }            
         if (GetFile1.GetFileExt() == "CFG" || GetFile1.GetFileExt() == "cfg")
            {
            strcpy(pDoc->FileIn, GetFile1.GetPathName());
            memset(pDoc->dline[pDoc->ly], '-', 254);
            NewLine();
            sprintf(pDoc->dline[pDoc->ly], " ->Opening... %s", pDoc->FileIn);
            NewLine();
            }            
         }
   pDoc->m_display = CONSOLE_DISPLAY;
   Invalidate(FALSE);
}

void CLifeView::OnFileEdit() 
{
   short i = 0;
   static char BASED_CODE szFilter[] = "Scripts (*.SCR)|*.scr||";
   CFileDialog GetFile1(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
                        szFilter, NULL);   
   GetFile1.m_ofn.lpstrInitialDir = pDoc->env.loaddir;
   if (GetFile1.DoModal())
      if (GetFile1.GetFileName() != "")
         {
         if (GetFile1.GetFileExt() == "SCR" || GetFile1.GetFileExt() == "scr")
            {
            sprintf(pDoc->env.loaddir, "%s", GetFile1.GetPathName());
            i = strlen(pDoc->env.loaddir);
            while (pDoc->env.loaddir[i] != '\\' && i)
               i--;
            pDoc->env.loaddir[i + 1] = 0;
            sprintf(pDoc->FileIn, "%s%s.scr", pDoc->env.loaddir, GetFile1.GetFileTitle());
            ShellExecute(NULL, "open", pDoc->env.editor, pDoc->FileIn, pDoc->env.loaddir, SW_SHOW);
            }            
         }
   pDoc->m_display = CONSOLE_DISPLAY;
   Invalidate(FALSE);
}


void CLifeView::OnActionClearscreen() 
{
   sprintf(pDoc->commandline, "clear");
   ExecLine();	
}

void CLifeView::OnHelpHome() 
{
   sprintf(pDoc->commandline, "home");
   ExecLine();	
}

void CLifeView::OnActionStatus() 
{
   memset(pDoc->dline[pDoc->ly], '-', 255);
   NewLine();
   sprintf(pDoc->commandline, "status");
   ExecLine();	
   memset(pDoc->dline[pDoc->ly], '-', 255);
   NewLine();
   pDoc->m_display = CONSOLE_DISPLAY;
   Invalidate(FALSE);
}

void CLifeView::OnHelpCommandlist() 
{
   sprintf(pDoc->commandline, "cmdlist");
   ExecLine();		
   pDoc->m_display = CONSOLE_DISPLAY;
   Invalidate(FALSE);
}

void CLifeView::OnActionQuake2() 
{
   sprintf(pDoc->commandline, "quake2");
   ExecLine();		
}

void CLifeView::OnActionEnvironment() 
{
   sprintf(pDoc->commandline, "env");
   ExecLine();		
}

void CLifeView::OnHelpSupport() 
{
   ShellExecute(NULL, "open", "http://www.endorproductions.com/support", NULL, NULL,
               SW_SHOWNORMAL);
}

void CLifeView::RenderScene()
{
	int i;

	if (!(model_mode & MODEL_LOADED))
		{
		OpenGL = 0;
		return;
		}

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glClearColor(m_ClearColorRed,m_ClearColorGreen, m_ClearColorBlue, 0.0f); 

	// Start rendering...
	glPushMatrix();	
   GL_Print (-2, 0, "<<OpenGL Font Test>>\n" 
                   "Written and compiled by Nawfel Tricha.\n"
                   "Copyright 1999 Nawfel Tricha. All rights reserved.");
	glRotatef(m_xRotation, 0.0, 1.0, 0.0); 
	glRotatef(m_yRotation, 1.0, 0.0, 0.0);
	glRotatef(m_zRotation, 0.0, 0.0, 1.0);
	glScalef(m_xScaling, m_xScaling, m_xScaling);
	glTranslatef (m_zTranslation, m_xTranslation, m_yTranslation);
	if (model_mode & MODEL_TEXTURED)
		{
		if (interpolations)
			{
			if (interpolation++ == interpolations)
				{
				interpolation = 1;
				frame++;
				next_frame = frame + 1;
				if (next_frame > end_frame) //md2Model.m_iFrames)
					{
					if (loop_frame >= 0)
						next_frame = loop_frame;
					else
						next_frame = end_frame;
					}
				if (frame > end_frame)
					{
					if (loop_frame >= 0)
						{
						frame = loop_frame;
						next_frame = loop_frame + 1;
						}
					else
						{
						frame = end_frame;
						next_frame = end_frame;
						}	
					}
				if (pDoc->FrameSound[frame])
					sndPlaySound(pDoc->FrameSound[frame], SND_ASYNC);
				}
			for (i = 0; i < md2Model.getnumberTriangles(); i++) 
				{
				glBegin(GL_TRIANGLES);
				frame_x[0] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].x;
				frame_y[0] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].y;
				frame_z[0] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].z;
				frame_x[1] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].x;
				frame_y[1] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].y;
				frame_z[1] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].z;
				frame_x[2] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].x;
				frame_y[2] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].y;
				frame_z[2] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].z;
				frame_x_delta[0] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].a].x;
				frame_y_delta[0] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].a].y;
				frame_z_delta[0] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].a].z;
				frame_x_delta[1] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].b].x;
				frame_y_delta[1] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].b].y;
				frame_z_delta[1] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].b].z;
				frame_x_delta[2] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].c].x;
				frame_y_delta[2] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].c].y;
				frame_z_delta[2] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].c].z;
				frame_x[0] += ((frame_x_delta[0] - frame_x[0]) / interpolations) * interpolation;
				frame_y[0] += ((frame_y_delta[0] - frame_y[0]) / interpolations) * interpolation;
				frame_z[0] += ((frame_z_delta[0] - frame_z[0]) / interpolations) * interpolation;
				frame_x[1] += ((frame_x_delta[1] - frame_x[1]) / interpolations) * interpolation;
				frame_y[1] += ((frame_y_delta[1] - frame_y[1]) / interpolations) * interpolation;
				frame_z[1] += ((frame_z_delta[1] - frame_z[1]) / interpolations) * interpolation;
				frame_x[2] += ((frame_x_delta[2] - frame_x[2]) / interpolations) * interpolation;
				frame_y[2] += ((frame_y_delta[2] - frame_y[2]) / interpolations) * interpolation;
				frame_z[2] += ((frame_z_delta[2] - frame_z[2]) / interpolations) * interpolation;
				glTexCoord2f((md2Model.m_index_list[i].a_s)/(float)imageTexture.m_iWidth, (md2Model.m_index_list[i].a_t)/(float)imageTexture.m_iHeight);
					glVertex3f (frame_x[0], frame_y[0], frame_z[0]);
				glTexCoord2f((md2Model.m_index_list[i].b_s)/(float)imageTexture.m_iWidth, (md2Model.m_index_list[i].b_t)/(float)imageTexture.m_iHeight);
					glVertex3f (frame_x[1], frame_y[1], frame_z[1]);
				glTexCoord2f((md2Model.m_index_list[i].c_s)/(float)imageTexture.m_iWidth, (md2Model.m_index_list[i].c_t)/(float)imageTexture.m_iHeight);
					glVertex3f (frame_x[2], frame_y[2], frame_z[2]);
				glEnd();
				}
			}
		else
			{
			if (frame++ >= end_frame)
				if (loop_frame >= 0)
					frame = loop_frame;
				else
					frame = end_frame;
			if (pDoc->FrameSound[frame])
				sndPlaySound(pDoc->FrameSound[frame], SND_ASYNC);
			for (i = 0; i < md2Model.getnumberTriangles(); i++) 
				{
				glBegin(GL_TRIANGLES);
				glTexCoord2f((md2Model.m_index_list[i].a_s)/(float)imageTexture.m_iWidth, (md2Model.m_index_list[i].a_t)/(float)imageTexture.m_iHeight);
				glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].x, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].y, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].z);
				glTexCoord2f((md2Model.m_index_list[i].b_s)/(float)imageTexture.m_iWidth, (md2Model.m_index_list[i].b_t)/(float)imageTexture.m_iHeight);
				glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].x, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].y, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].z);
				glTexCoord2f((md2Model.m_index_list[i].c_s)/(float)imageTexture.m_iWidth, (md2Model.m_index_list[i].c_t)/(float)imageTexture.m_iHeight);
				glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].x, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].y, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].z);
				glEnd();
				}
			}
		}
	else
		{
		if (interpolations)
			{
			if (interpolation++ == interpolations)
				{
				interpolation = 1;
				frame++;
				next_frame = frame + 1;
				if (next_frame > end_frame) //md2Model.m_iFrames)
					{
					if (loop_frame >= 0)
						next_frame = loop_frame;
					else
						next_frame = end_frame;
					}
				if (frame > end_frame)
					{
					if (loop_frame >= 0)
						{
						frame = loop_frame;
						next_frame = loop_frame + 1;
						}
					else
						{
						frame = end_frame;
						next_frame = end_frame;
						}
					}
				if (pDoc->FrameSound[frame])
					sndPlaySound(pDoc->FrameSound[frame], SND_ASYNC);
				}
			for (i = 0; i < md2Model.getnumberTriangles(); i++) 
				{
				glBegin(GL_TRIANGLES);
				frame_x[0] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].x;
				frame_y[0] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].y;
				frame_z[0] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].z;
				frame_x[1] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].x;
				frame_y[1] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].y;
				frame_z[1] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].z;
				frame_x[2] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].x;
				frame_y[2] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].y;
				frame_z[2] = md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].z;
				frame_x_delta[0] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].a].x;
				frame_y_delta[0] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].a].y;
				frame_z_delta[0] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].a].z;
				frame_x_delta[1] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].b].x;
				frame_y_delta[1] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].b].y;
				frame_z_delta[1] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].b].z;
				frame_x_delta[2] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].c].x;
				frame_y_delta[2] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].c].y;
				frame_z_delta[2] = md2Model.m_frame_list[next_frame].vertex[md2Model.m_index_list[i].c].z;
				frame_x[0] += ((frame_x_delta[0] - frame_x[0]) / interpolations) * interpolation;
				frame_y[0] += ((frame_y_delta[0] - frame_y[0]) / interpolations) * interpolation;
				frame_z[0] += ((frame_z_delta[0] - frame_z[0]) / interpolations) * interpolation;
				frame_x[1] += ((frame_x_delta[1] - frame_x[1]) / interpolations) * interpolation;
				frame_y[1] += ((frame_y_delta[1] - frame_y[1]) / interpolations) * interpolation;
				frame_z[1] += ((frame_z_delta[1] - frame_z[1]) / interpolations) * interpolation;
				frame_x[2] += ((frame_x_delta[2] - frame_x[2]) / interpolations) * interpolation;
				frame_y[2] += ((frame_y_delta[2] - frame_y[2]) / interpolations) * interpolation;
				frame_z[2] += ((frame_z_delta[2] - frame_z[2]) / interpolations) * interpolation;
				glVertex3f (frame_x[0], frame_y[0], frame_z[0]);
				glVertex3f (frame_x[1], frame_y[1], frame_z[1]);
				glVertex3f (frame_x[2], frame_y[2], frame_z[2]);
				glEnd();
				}
			}
		else	
			{
			if (frame++ >= end_frame)
				if (loop_frame >= 0)
					frame = loop_frame;
				else
					frame = end_frame;
			if (pDoc->FrameSound[frame])
				sndPlaySound(pDoc->FrameSound[frame], SND_ASYNC);
			for (i = 0; i < md2Model.getnumberTriangles(); i++) 
				{
				glBegin(GL_TRIANGLES);
				glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].x, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].y, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].z);
				glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].x, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].y, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].z);
				glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].x, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].y, 
					md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].z);
				glEnd();
				}
			}
		}	
	//glBegin(GL_POINTS);
		//glVertex3f (30, 30, 50);
	//glEnd();
	glPopMatrix();
	glFlush();	
	
	// Double buffer
	SwapBuffers(dc->m_ps.hdc);
}

BOOL CLifeView::CreateViewGLContext(HDC hDC)
{
	m_hGLContext = wglCreateContext(hDC);
	
	if(m_hGLContext==NULL)
		return FALSE;
	
	if(wglMakeCurrent(hDC,m_hGLContext)==FALSE)
		return FALSE;
	
	return TRUE;
}

BOOL CLifeView::SetWindowPixelFormat(HDC hDC)
{
	PIXELFORMATDESCRIPTOR pixelDesc;
	
	pixelDesc.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pixelDesc.nVersion = 1;
	
	pixelDesc.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL
		| PFD_DOUBLEBUFFER | PFD_STEREO_DONTCARE;
	
	pixelDesc.iPixelType = PFD_TYPE_RGBA;
	pixelDesc.cColorBits = 16; //32
	pixelDesc.cRedBits = 0;
	pixelDesc.cRedShift = 0;
	pixelDesc.cGreenBits = 0;
	pixelDesc.cGreenShift = 0;
	pixelDesc.cBlueBits = 0;
	pixelDesc.cBlueShift = 0;
	pixelDesc.cAlphaBits = 0;
	pixelDesc.cAlphaShift = 0;
	pixelDesc.cAccumBits = 0;
	pixelDesc.cAccumRedBits = 0;
	pixelDesc.cAccumGreenBits = 0;
	pixelDesc.cAccumBlueBits = 0;
	pixelDesc.cAccumAlphaBits = 0;
	pixelDesc.cDepthBits = 16;
	pixelDesc.cStencilBits = 0;
	pixelDesc.cAuxBuffers = 0;
	pixelDesc.iLayerType = PFD_MAIN_PLANE;
	pixelDesc.bReserved = 0;
	pixelDesc.dwLayerMask = 0;
	pixelDesc.dwVisibleMask = 0;
	pixelDesc.dwDamageMask = 0;
	
	m_GLPixelIndex = ChoosePixelFormat(hDC,&pixelDesc);
	if(m_GLPixelIndex == 0) // Choose default
		{
		m_GLPixelIndex = 1;
		AfxMessageBox("ChoosePixelFormat failed.");
		if(DescribePixelFormat(hDC,m_GLPixelIndex,
			sizeof(PIXELFORMATDESCRIPTOR),&pixelDesc)==0)
			return FALSE;
		}
	
	if(!SetPixelFormat(hDC,m_GLPixelIndex,&pixelDesc))
		{
		AfxMessageBox("SetPixelFormat failed.");
		return FALSE;
		}
	return TRUE;
}

void CLifeView::OnPaint() 
{
	if (OpenGL == PLAY_OPENGL_NOW || (OpenGL && realtime))
		{
		RenderScene();
		OpenGL = PLAY_OPENGL_SOON;
		}
	else if (!OpenGL)
		CView::OnPaint();
}

void CLifeView::OnActionSaveoptions() 
{
if (SaveOptions())
	{
   sprintf(pDoc->dline[pDoc->ly], "Current options saved to '%s\\file.cfg'", 	pDoc->PathName);
   NewLine();
	Invalidate();
	return;
	}
sprintf(pDoc->dline[pDoc->ly], "Unable to saved to 'File.CFG'!");
NewLine();	
Invalidate();
}


void CLifeView::OnToolsWalflags() 
{
	Waller w;
	w.pDoc = pDoc;
	w.pMainWnd = pMainWnd;
	w.DoModal();	
}

void CLifeView::OnCaptureChanged(CWnd *pWnd) 
{
	// TODO: Add your message handler code here
	
	CView::OnCaptureChanged(pWnd);
}

void CLifeView::OnFormatOpengl() 
{
	if (md2Model.m_iFrames <= 0)
		return;
	if (OpenGL)
		{
		OpenGL = PLAY_OPENGL_STOP;	
		interpolation = 0;
		pDoc->m_display = CONSOLE_DISPLAY;
		Invalidate();
		}
	else
		{
		OpenGL = PLAY_OPENGL_SOON;	
		frame = begin_frame;
		next_frame = begin_frame + 1;
		interpolation = 0;
		AfxBeginThread(GL_Thread, (LPVOID) (CLifeView *) this, THREAD_PRIORITY_HIGHEST);// THREAD_PRIORITY_LOWEST THREAD_PRIORITY_BELOW_NORMAL);
		}
}

void CLifeView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
	//char x[256];
	//sprintf (x, "%d", nChar);
	//AfxMessageBox(x);
	switch (nChar)
		{		
		case 114:
			strcpy(pDoc->dline[pDoc->ly], last_command);
			pDoc->lx = old_lx;
			pDoc->m_display = CONSOLE_DISPLAY;
			Invalidate(FALSE);
			break;
		}
	if (model_mode & MODEL_STOPMOTION)
		{
		if (!OpenGL)
		switch(nChar)
			{
			case 37:
				frame--;
				if (frame < 0)
					frame = 0;
				RenderFrame();
				break;
			case 39:
				frame++;
				if (frame >= md2Model.m_iFrames)
					frame--;
				RenderFrame();
				break;
			case 38:
				frame--;
				if (frame < 0)
					frame = 0;
				RenderFrame();
				break;
			case 40:
				frame++;
				if (frame >= md2Model.m_iFrames)
					frame--;
				RenderFrame();
				break;
			}	
		else
		switch(nChar)
			{
			case 37:
				frame = begin_frame;
				next_frame = frame + 1;
				break;
			case 39:
				frame = end_frame - 1;
				next_frame = frame + 1;
				break;
			case 38:
				frame = begin_frame;
				next_frame = frame + 1;
				break;
			case 40:
				frame = end_frame - 1;
				next_frame = frame + 1;
				break;
			}	
		}
}

void CLifeView::OnSize(UINT nType, int cx, int cy) 
{
	//float k = (float) cy/ (float)cx;
	CView::OnSize(nType, cx, cy);
	//glWindow.SetSize (x, y);
	glViewport(0,0, cx, cy);
	SetOpenGLMode();
}



void CLifeView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnMouseMove(nFlags, point);

	// Left Mouse Button:
	if (!(model_mode & MODEL_LOADED))
		return;

	if (nFlags == 1)
		{
		if (old_mouse_x > point.x)
			m_xRotation -= 3;
		else if (old_mouse_x < point.x)
			m_xRotation += 3;

		if (old_mouse_y > point.y)
			m_yRotation -= 3;
		else if (old_mouse_y < point.y)
			m_yRotation += 3;
		//Invalidate();
		if ((model_mode & MODEL_STOPMOTION) && !OpenGL)
			RenderFrame();
		}
	else if (nFlags == 2)
		{
		if (old_mouse_x > point.x)
			m_xTranslation -= 1;
		else if (old_mouse_x < point.x)
			m_xTranslation += 1;

		if (old_mouse_y > point.y)
			m_yTranslation += 1;
		else if (old_mouse_y < point.y)
			m_yTranslation -= 1;
		//Invalidate();
		if ((model_mode & MODEL_STOPMOTION) && !OpenGL)
			RenderFrame();
		}
	else if (nFlags == 3)
		{
		if (old_mouse_y > point.y)
			{
			m_xScaling -= .001f;
			if (m_xScaling < .01)
				m_xScaling += .001f;
			}
		else if (old_mouse_y < point.y)
			{
			m_xScaling += .001f;
			if (m_xScaling > 1)
				m_xScaling -= .001f;
			}
		if ((model_mode & MODEL_STOPMOTION) && !OpenGL)
			RenderFrame();
		}


	old_mouse_x = point.x;
	old_mouse_y = point.y;
	//Invalidate();
	//old_mouse_button = nFlags;
	//point.x > old_mouse_y)
}


UINT GL_Thread(LPVOID param)
{
	while (1)
		{
		::Sleep((DWORD) ((CLifeView*) param)->framedelay);
		if (((CLifeView*) param)->OpenGL)
			{
			((CLifeView*) param)->OpenGL = PLAY_OPENGL_NOW;	
			((CLifeView*) param)->Invalidate(FALSE);
			}
		else
			{
			AfxEndThread(0);	
			return 0;
			}
		}
}

void CLifeView::OnUpdateFormatOpenglOn(CCmdUI* pCmdUI) 
{
	if (OpenGL)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
}

void CLifeView::OnFormatOpenglWireframe() 
{
	OpenGL = 0;
	if (model_mode & MODEL_WIREFRAME)
		{
		model_mode &= ~MODEL_WIREFRAME;
		SetOpenGLMode();
		}
	else
		{
		model_mode &= ~MODEL_TEXTURED;
		model_mode |= MODEL_WIREFRAME;
		SetOpenGLMode();
		}				
   pDoc->m_display = CONSOLE_DISPLAY;
	Invalidate();
}

void CLifeView::OnUpdateFormatOpenglWireframe(CCmdUI* pCmdUI) 
{
	if (model_mode & MODEL_WIREFRAME)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
}

void CLifeView::SetOpenGLMode()
{	
	glFlush();
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	//gluPerspective (90, 1.2, 1, 3);
	glOrtho(-4, 4, -3, 3, -20, 20);
   //glFrustum (-4, 4, -3, 3, -20, 20);

	//glEnable(GL_NORMALIZE);

	if (model_mode & MODEL_LIGHTS)
		{
		glEnable(GL_BLEND);
		// Lights, material properties
		GLfloat	ambientProperties[]  = {0.0f, 0.0f, 0.0f, 1.0f};
		GLfloat	specularProperties[] = {1.0f, 1.0f, 0.0f, 1.0f};
		GLfloat	lightPosition[] = {0.0f, 1.0f, 0.0f, 1.0};
		GLfloat	mat_amb_diff[] = {0.1f, 0.5f, 0.8f, 1.0f};
		glClearDepth( 1.0 );	
		//glLightfv(GL_LIGHT0, GL_AMBIENT_AND_DIFFUSE, ambientProperties);
		glLightfv(GL_LIGHT0, GL_SPECULAR, specularProperties);
		glLightfv(GL_LIGHT0, GL_POSITION, lightPosition);
		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, mat_amb_diff);
      glMaterialfv(GL_FRONT, GL_EMISSION, mat_amb_diff);
		glMaterialfv(GL_FRONT, GL_SPECULAR, specularProperties);
		glMaterialf(GL_FRONT, GL_SHININESS, 40.0f);
		//glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
		//glMatrixMode(GL_PROJECTION); //MODELVIEW
		glEnable(GL_LIGHTING);
		glEnable(GL_LIGHT0);
		}
	else
		{
		glDisable(GL_BLEND);
		glDisable(GL_LIGHT0);
		glDisable(GL_LIGHTING);
		}
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	if (model_mode & MODEL_MIPMAPPED)
		{
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
		glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST );		
		}
	else
		{
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
	   glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
		glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST );		
		}
	
	if ((model_mode & MODEL_TEXTURED) && (model_mode & MODEL_SKIN_LOADED))
		{
		glEnable(GL_DEPTH_TEST);
		glPolygonMode (GL_FRONT, GL_FILL);
		glEnable(GL_TEXTURE_2D);
		//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
		glCullFace(GL_BACK);
		glEnable(GL_CULL_FACE);
		}
	else if (model_mode & MODEL_WIREFRAME)
		{
		glDisable(GL_DEPTH_TEST);
		glDisable(GL_CULL_FACE);
		glDisable(GL_TEXTURE_2D);
		glPolygonMode (GL_FRONT_AND_BACK, GL_LINE);
		}
	else
		{
		glEnable(GL_DEPTH_TEST);
		glCullFace(GL_BACK);
		glEnable(GL_CULL_FACE);
		glDisable(GL_TEXTURE_2D);
		glPolygonMode (GL_FRONT, GL_FILL);
		}


	if (model_mode & MODEL_SMOOTH)
		{
		glShadeModel(GL_SMOOTH);
		glEnable(GL_POLYGON_SMOOTH);
		}
	else
		{
		glShadeModel(GL_FLAT);
		glDisable(GL_POLYGON_SMOOTH);
		}
   // Environment Mapping:
   //glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
   //glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR);
   //glEnable(GL_TEXTURE_GEN_S);
   //glEnable(GL_TEXTURE_GEN_T);

   //glBlendFunc (GL_SRC_COLOR, GL_DST_COLOR);
}

void CLifeView::OnToolsModelsLoad() 
{
   short i = 0;
	int k;
   static char BASED_CODE szFilter[] = "Model (*.MD2)|*.md2||";
	char x[256] = {0};
	OpenGL = 0;
   CFileDialog GetFile1(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
                        szFilter, NULL);   
   GetFile1.m_ofn.lpstrInitialDir = pDoc->env.modeldir;
   if (GetFile1.DoModal())
      if (GetFile1.GetFileName() != "")
         {
         if (GetFile1.GetFileExt() == "MD2" || GetFile1.GetFileExt() == "md2")
            {            
				strcpy(x, GetFile1.GetPathName());
				md2Model.Destroy();
				k = model_mode & MODEL_TEXTURED;
				model_mode &= ~(MODEL_TEXTURED | MODEL_LOADED | MODEL_SKIN_LOADED | MODEL_STOPMOTION); 
				imageTexture.Destroy ();
				if (md2Model.Read (x)) 
					{
					for (i = 0; i < 512; i++)
						if (pDoc->FrameSound[i])
							{
							delete [] pDoc->FrameSound[i];
							pDoc->FrameSound[i] = NULL;
							}
					model_mode |= MODEL_LOADED;
					if (model_mode & MODEL_FIRSTPERSON)
						OnFormatOpenglFirstperson();
					i = strlen(x) - 1;
					while (i >= 0  && x[i] != '\\')
						i--;
					x[i + 1] = 0;
					strcat (x, "skin.pcx");
					m_xScaling  = .03f;
					m_yRotation = 270;
					m_xRotation = 270;
					m_zRotation	= 0;
					begin_frame = loop_frame = 0;
					end_frame = md2Model.m_iFrames - 1;
					if (imageTexture.Read (x) == 0) 
						{
						if (k)
							model_mode |= MODEL_TEXTURED;
						model_mode |= MODEL_SKIN_LOADED;
						imageTexture.Image2GLTexture ();
						glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
						glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
						glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
						glTexImage2D(GL_TEXTURE_2D, 0, 4, imageTexture.m_iscaledWidth, imageTexture.m_iscaledHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, imageTexture.glTexture);
						}
					else
						AfxMessageBox ("Skin not loaded on model load");
					SetOpenGLMode();
					sprintf(pDoc->dline[pDoc->ly], "&c666 Model Loaded. Use arrow keys to change frames.");
					NewLine();	
					model_mode |= MODEL_STOPMOTION;
					frame = 0;
					}
				else
					AfxMessageBox("Could not load model\n");
            }            
         }
   pDoc->m_display = CONSOLE_DISPLAY;
   Invalidate(FALSE);
}

void CLifeView::OnToolsModelsSkin() 
{
   int k = 0;
   static char BASED_CODE szFilter[] = "Model (*.PCX)|*.pcx||";
	char x[256] = {0};
	if (md2Model.m_iFrames <= 0)
		return;
	OpenGL = 0;
   CFileDialog GetFile1(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
                        szFilter, NULL);   
   GetFile1.m_ofn.lpstrInitialDir = pDoc->env.modeldir;
   if (GetFile1.DoModal())
      if (GetFile1.GetFileName() != "")
         {
         if (GetFile1.GetFileExt() == "PCX" || GetFile1.GetFileExt() == "pcx")
            {            
				strcpy(x, GetFile1.GetPathName());
				model_mode &= ~MODEL_TEXTURED;
				model_mode &= ~MODEL_SKIN_LOADED;
				imageTexture.Destroy ();
				if (imageTexture.Read (x) == -1) 
					{
					AfxMessageBox("Could not load skin\n");
					}
				else
					{
					if (k)
						model_mode |= MODEL_TEXTURED;
					model_mode |= MODEL_SKIN_LOADED;
					imageTexture.Image2GLTexture ();
					glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
					glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
					glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
					glTexImage2D(GL_TEXTURE_2D, 0, 4, imageTexture.m_iscaledWidth, imageTexture.m_iscaledHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, imageTexture.glTexture);
					}
				SetOpenGLMode();
            }            
         }
   pDoc->m_display = CONSOLE_DISPLAY;
   Invalidate(FALSE);
}

void CLifeView::OnFormatOpenglTextured() 
{
	OpenGL = 0;
	if (model_mode & MODEL_TEXTURED)
		{
		model_mode &= ~MODEL_TEXTURED;
		SetOpenGLMode();
		}
	else
		{
		if (model_mode & MODEL_SKIN_LOADED)
			{
			model_mode |= MODEL_TEXTURED;		
			model_mode &= ~MODEL_WIREFRAME;
			}
		SetOpenGLMode();
		}				
   pDoc->m_display = CONSOLE_DISPLAY;
	Invalidate();
}

void CLifeView::OnUpdateFormatOpenglTextured(CCmdUI* pCmdUI) 
{
	if (model_mode & MODEL_TEXTURED)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
}

void CLifeView::OnFormatOpenglLights() 
{
	OpenGL = 0;
	if (model_mode & MODEL_LIGHTS)
		{
		model_mode &= ~MODEL_LIGHTS;
		SetOpenGLMode();
		}
	else
		{
		model_mode |= MODEL_LIGHTS;
		SetOpenGLMode();
		}				
   pDoc->m_display = CONSOLE_DISPLAY;
	Invalidate();
}

void CLifeView::OnUpdateFormatOpenglLights(CCmdUI* pCmdUI) 
{
	if (model_mode & MODEL_LIGHTS)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
}

void CLifeView::OnFormatOpenglMipmapping() 
{
	OpenGL = 0;
	if (model_mode & MODEL_MIPMAPPED)
		{
		model_mode &= ~MODEL_MIPMAPPED;
		SetOpenGLMode();
		}
	else
		{
		model_mode |= MODEL_MIPMAPPED;
		SetOpenGLMode();
		}				
   pDoc->m_display = CONSOLE_DISPLAY;
	Invalidate();
}

void CLifeView::OnUpdateFormatOpenglMipmapping(CCmdUI* pCmdUI) 
{
	if (model_mode & MODEL_MIPMAPPED)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);	
}

void CLifeView::OnFormatOpenglShaded() 
{
	OpenGL = 0;
	if (model_mode & MODEL_SMOOTH)
		{
		model_mode &= ~MODEL_SMOOTH;
		SetOpenGLMode();
		}
	else
		{
		model_mode |= MODEL_SMOOTH;
		SetOpenGLMode();
		}				
   pDoc->m_display = CONSOLE_DISPLAY;
	Invalidate();
}

void CLifeView::OnUpdateFormatOpenglShaded(CCmdUI* pCmdUI) 
{
	if (model_mode & MODEL_SMOOTH)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
}

void CLifeView::OnToolsSceneeditor() 
{
	Scene s;
	if (md2Model.m_iFrames <= 0)
		return;
	OpenGL = 0;
	s.pDoc = pDoc;
	s.pView = this;
	s.pMainWnd = pMainWnd;

	s.DoModal();
}

void CLifeView::OnKillFocus(CWnd* pNewWnd) 
{
	CView::OnKillFocus(pNewWnd);
	if (OpenGL)
		{
		OpenGL = 0;	
		sprintf(pDoc->dline[pDoc->ly], "&c006 [Window focus killed]: Animation interrupted.", pDoc->version);
		NewLine();	
		}
}


void CLifeView::OnFormatOpenglFirstperson() 
{
	OpenGL = 0;
	if (model_mode & MODEL_FIRSTPERSON)
		{
		model_mode &= ~MODEL_FIRSTPERSON;
		m_xRotation = xRotation;
		m_yRotation = yRotation;
		m_zRotation = zRotation;
		m_xTranslation = xTranslation;
		m_yTranslation = yTranslation;
		m_zTranslation = zTranslation;
		m_xScaling = xScaling;
		m_yScaling = yScaling;
		m_zScaling = zScaling;
		}
	else		
		{
		model_mode |= MODEL_FIRSTPERSON;
		xRotation = m_xRotation;
		yRotation = m_yRotation;
		zRotation = m_zRotation;
		xTranslation = m_xTranslation;
		yTranslation = m_yTranslation;
		zTranslation = m_zTranslation;
		xScaling = m_xScaling;
		yScaling = m_yScaling;
		zScaling = m_zScaling;
		m_xScaling  = .18f;
		m_yRotation = 270;
		m_xRotation = 90;
		m_zRotation = 10;
		m_zTranslation = -20,
		m_yTranslation = 1,
		m_xTranslation = 0;
		}
}

void CLifeView::OnUpdateFormatOpenglFirstperson(CCmdUI* pCmdUI) 
{
	if (model_mode & MODEL_FIRSTPERSON)		
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
}

void CLifeView::OnViewSmallerfont() 
{
   sprintf(pDoc->commandline, "font--");
   ExecLine();	
	Invalidate(TRUE);
}

void CLifeView::OnViewLargerfont() 
{
   sprintf(pDoc->commandline, "font++");
   ExecLine();	
	Invalidate(TRUE);
}

void CLifeView::OnActionLastcommand() 
{
	strcpy(pDoc->dline[pDoc->ly], last_command);
	pDoc->lx = old_lx;
	pDoc->m_display = CONSOLE_DISPLAY;
	Invalidate(FALSE);
}

void CLifeView::OnToolsStopmotion() 
{
	OpenGL = 0;
	if (!(model_mode & MODEL_LOADED))
		return;
	if (model_mode & MODEL_STOPMOTION)	
		model_mode &= ~MODEL_STOPMOTION;
	else
		model_mode |= MODEL_STOPMOTION;
}

void CLifeView::OnUpdateToolsStopmotion(CCmdUI* pCmdUI) 
{
	if (model_mode & MODEL_STOPMOTION)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
}

void CLifeView::RenderFrame()
{
	int i;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glClearColor(m_ClearColorRed,m_ClearColorGreen, m_ClearColorBlue, 0.0f); 


	// Start rendering...
	glPushMatrix();	
   GL_Print (-2, 0, "<<OpenGL Font Test>>\n" 
                   "Written and compiled by Nawfel Tricha.\n"
                   "Copyright 1999 Nawfel Tricha. All rights reserved.");
	glRotatef(m_xRotation, 0.0, 1.0, 0.0); 
	glRotatef(m_yRotation, 1.0, 0.0, 0.0);
	glRotatef(m_zRotation, 0.0, 0.0, 1.0);
	glScalef(m_xScaling, m_xScaling, m_xScaling);
	glTranslatef (m_zTranslation, m_xTranslation, m_yTranslation);

	if (model_mode & MODEL_TEXTURED)
		{
		if (pDoc->FrameSound[frame])
			sndPlaySound(pDoc->FrameSound[frame], SND_ASYNC);
		for (i = 0; i < md2Model.getnumberTriangles(); i++) 
			{
			glBegin(GL_TRIANGLES);
			glTexCoord2f((md2Model.m_index_list[i].a_s)/(float)imageTexture.m_iWidth, (md2Model.m_index_list[i].a_t)/(float)imageTexture.m_iHeight);
			glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].x, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].y, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].z);
			glTexCoord2f((md2Model.m_index_list[i].b_s)/(float)imageTexture.m_iWidth, (md2Model.m_index_list[i].b_t)/(float)imageTexture.m_iHeight);
			glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].x, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].y, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].z);
			glTexCoord2f((md2Model.m_index_list[i].c_s)/(float)imageTexture.m_iWidth, (md2Model.m_index_list[i].c_t)/(float)imageTexture.m_iHeight);
			glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].x, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].y, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].z);
			glEnd();
			}
		}
	else
		{
		if (pDoc->FrameSound[frame])
			sndPlaySound(pDoc->FrameSound[frame], SND_ASYNC);
		for (i = 0; i < md2Model.getnumberTriangles(); i++) 
			{
			glBegin(GL_TRIANGLES);
			glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].x, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].y, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].a].z);
			glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].x, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].y, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].b].z);
			glVertex3f (md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].x, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].y, 
				md2Model.m_frame_list[frame].vertex[md2Model.m_index_list[i].c].z);
			glEnd();
			}
		}
	glPopMatrix();
	glFlush();	
	SwapBuffers(dc->m_ps.hdc);
}

void CLifeView::QuarkTexture()
{
	CFileFind;

}

void CLifeView::GL_Print(float x, float y, char *ptr)
{
   glRasterPos2f(x, y);
   glColor3f(1.0, 1.0, 1.0);
   while (*ptr)
      {
      while (*ptr == '\n')
         {
         y -= .12f;
         glRasterPos2f(x, y);
         ptr++;
         }
	   glBitmap (8, 8, 0.0, 0.0, 10.0, 0.0, rasters + (*ptr++ * 8));
      }
}
