/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/

#include "stdafx.h"
#include "Life.h"

#include "LifeDoc.h"

#include "bnf_init.cpp"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLifeDoc

IMPLEMENT_DYNCREATE(CLifeDoc, CDocument)

BEGIN_MESSAGE_MAP(CLifeDoc, CDocument)
	//{{AFX_MSG_MAP(CLifeDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLifeDoc construction/destruction

CLifeDoc::CLifeDoc()
{
   LOGFONT LogFont;
   CFont::FromHandle((HFONT)GetStockObject(SYSTEM_FIXED_FONT))->GetLogFont(&LogFont);
   logfont.lfHeight = LogFont.lfHeight;
   logfont.lfWidth = LogFont.lfWidth;
   logfont.lfEscapement = logfont.lfEscapement;
   logfont.lfOrientation = logfont.lfOrientation;
   logfont.lfItalic = logfont.lfItalic;
   logfont.lfUnderline = logfont.lfUnderline;
   logfont.lfStrikeOut = logfont.lfStrikeOut;
   logfont.lfCharSet = LogFont.lfCharSet;
   logfont.lfOutPrecision = LogFont.lfOutPrecision;
   logfont.lfClipPrecision = LogFont.lfClipPrecision;
   logfont.lfQuality = LogFont.lfQuality;
   logfont.lfPitchAndFamily = LogFont.lfPitchAndFamily;
   strcpy(logfont.lfFaceName, LogFont.lfFaceName);
	//CreateFontIndirect(&logfont);
   console_background = 0x0;  // Black
   console_foreground = env.color;
   console_foreground = 0xAA;  // Green
   for (short i = 0; i < 50; i++)
      {
      dline[i] = new char[256];
      memset(dline[i], 32, 254);
      *(dline[i] + 255) = '\0';
      }
   m_display = 2;
   ly = 0;
   lx = 3;
   x_pos = 0; 
   y_pos = 0;
   prompt = 1;
   version = (float) 1.01;
   debug = 0;
   commandlist = 0;   
   for (i = 0; i < 100; i++)
      memset(on_uses[i].activator, 0, 255);
   for (i = 0; i < 512; i++)
      FrameSound[i] = NULL;
   setbnf();
}

CLifeDoc::~CLifeDoc()
{
}

BOOL CLifeDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CLifeDoc serialization

void CLifeDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
	}
	else
	{
	}
}

/////////////////////////////////////////////////////////////////////////////
// CLifeDoc diagnostics

#ifdef _DEBUG
void CLifeDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CLifeDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLifeDoc commands

void CLifeDoc::setbnf()
{
   int i;
   for (i = 0; i < 200; i++ )
      {
      bnf[i].syntax = NULL;
      bnf[i].usage = NULL;
      }
   for (i = 0; i < 48; i++ )
		{
      field_tag[i].name = NULL;
		class_tag[i].name = NULL;
		class_string_tag[i].name = NULL;
		level_tag[i].name = NULL;
		level_string_tag[i].name = NULL;
		team_tag[i].name = NULL;
		}
   for (i = 0; i < 16; i++ )
		{
      operator_tag[i].name = NULL;
      check_tag[i].name = NULL;
		}
	BNF_set(bnf);
	BNF_set_fields(field_tag);
	BNF_set_operators(operator_tag);
	BNF_set_checks(check_tag);
	BNF_set_class_strings(class_string_tag);
	BNF_set_classes(class_tag);
	BNF_set_level_strings(level_string_tag);
	BNF_set_levels(level_tag);
	BNF_set_teams(team_tag);
}

/*
goto(string labelname);
say(string wavefile, float volume, string attenuation);
   attenuation 
      attn_none = 0;
      attn_norm = 1;
      attn_idle = 2;
      attn_static = 3;

walk(string targetname);
attack(string targetname, int damage);
wait(float time);
run(string targetname);
rotate(vec3_t angles);
die(int damage);
hammer(string targetname, int damage);
pickup();
walkpickup(vec3_t destination);
drop(int field, int velocity);
hand(string targetname, string field, float amount);
   field
      health = 0;
      armor_light = 1;
      armor_medium = 2;
      armor_heavy = 3;
      ...
take(string targetname, string field, float amount);
spawn(string entity, vec3_t origin, int spawnflags);
remove(string targetname);
hide(string targetname);
chase(string targetname);
start(string labelname);
on_see(string targetname, string labelname, float delay, float range);
on_touch(string targetname, string labelname, float delay, float range);
on_pain(string targetname, string labelname, float delay, float range);
label@<string labelname>;
return();
lookat(string targetname);
action(int actionnumber);
use(string targetname, string activator);
chill(float seconds);

  item_armor_body = 1;
  item_armor_bombat = 2;
  item_armor_jacker = 3;
  item_armor_shard = 4;
  item_power_screen = 5;
  item_power_shield = 6;
  weapon_hammer = 7;
  weapon_u23k = 8;
  weapon_u23k2 = 9;
  weapon_ripper = 10;
  weapon_plasmagun = 11;
  weapon_riffle = 12;
  weapon_cec = 13;
  ammo_clip = 14;
  ammo_dics = 15;
  ammo_plasma_slugs = 16;
  ammo_srounds = 17;
  item_goggles = 18;
  item_quad = 19;
  item_invulnerability = 20;
  item_silencer = 21;
  item_enviro = 22;
  item_breather = 23;
  item_ancient_head = 24;
  item_adrenaline = 25;
  item_bandolier = 26;
  item_pack = 27;
  item_health = 28;

	drop;	
	print (string targetname, string message);
	level.print (string message);
	team.respawn(int teamnumber, string tag, string op, float value);
	team.damage(int teamnumber, float value, string tag, string op, float value);
	team.score(int teamnumber, string tag, string op, float value);
	team.print(int teamnumber, string message, string tag, string op, float value);
	unlink;	
	link;

level.set_string (string tag, string value);
level.if (string tag, string operator, int value, string label);

*/
