/****************************************************************************\
 Copyright 1998, 1999 Endor Productions Inc.. All rights reserved.
 Written and compiled by Nawfel 'Topaz' Tricha. 
 Source code to LifeScript compiler, OpenGL Model Viewer, Scene editor, and 
 .WAL texture sound linker. 
 This code is open source. It is available to everybody for educational 
 purposes only. Legal actions will be taken against any financial exploitation 
 of this material.
 Enjoy,
 
   -Nawfel 'Topaz' Tricha
\****************************************************************************/

#include "stdafx.h"
#include "Life.h"
#include "LifeDoc.h"
#include "Enviro.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Enviro dialog


Enviro::Enviro(CWnd* pParent /*=NULL*/)
	: CDialog(Enviro::IDD, pParent)
{
	//{{AFX_DATA_INIT(Enviro)
	m_dir = _T("");
	m_game = _T("");
	m_load = _T("");
	m_map = _T("");
	m_params = _T("");
	m_save = _T("");
	m_editor = _T("");
	m_waldir = _T("");
	m_modeldir = _T("");
	m_sounddir = _T("");
	//}}AFX_DATA_INIT
}


void Enviro::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(Enviro)
	DDX_Control(pDX, IDC_CHECK_PLAY, m_playsound);
	DDX_Control(pDX, IDC_CHECK_CHEATS, m_cheats);
	DDX_Control(pDX, IDC_CHECK_DISCONNECT, m_disconnect);
	DDX_Control(pDX, IDC_CHECK_GIVEALL, m_giveall);
	DDX_Control(pDX, IDC_CHECK_NOTARGET, m_notarget);
	DDX_Control(pDX, IDC_CHECK_GOD, m_god);
	DDX_Text(pDX, IDC_EDIT_DIR, m_dir);
	DDV_MaxChars(pDX, m_dir, 255);
	DDX_Text(pDX, IDC_EDIT_GAME, m_game);
	DDV_MaxChars(pDX, m_game, 32);
	DDX_Text(pDX, IDC_EDIT_LOAD, m_load);
	DDV_MaxChars(pDX, m_load, 255);
	DDX_Text(pDX, IDC_EDIT_MAP, m_map);
	DDV_MaxChars(pDX, m_map, 32);
	DDX_Text(pDX, IDC_EDIT_PARAMS, m_params);
	DDV_MaxChars(pDX, m_params, 255);
	DDX_Text(pDX, IDC_EDIT_SAVE, m_save);
	DDV_MaxChars(pDX, m_save, 255);
	DDX_Text(pDX, IDC_EDIT_EDITOR, m_editor);
	DDV_MaxChars(pDX, m_editor, 255);
	DDX_Text(pDX, IDC_EDIT_WALDIR, m_waldir);
	DDV_MaxChars(pDX, m_waldir, 255);
	DDX_Text(pDX, IDC_EDIT_MODELDIR, m_modeldir);
	DDV_MaxChars(pDX, m_modeldir, 255);
	DDX_Text(pDX, IDC_EDIT_SOUNDDIR, m_sounddir);
	DDV_MaxChars(pDX, m_sounddir, 255);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(Enviro, CDialog)
	//{{AFX_MSG_MAP(Enviro)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Enviro message handlers

void Enviro::OnOK() 
{
   UpdateData(TRUE);
   pDoc->env.god = m_god.GetCheck();
   pDoc->env.cheats = m_cheats.GetCheck();
   pDoc->env.notarget = m_notarget.GetCheck();
   pDoc->env.give_all = m_giveall.GetCheck();
   pDoc->env.disconnect = m_disconnect.GetCheck();	
   pDoc->env.errorsound = m_playsound.GetCheck();
   strcpy(pDoc->env.quakedir, m_dir);
   strcpy(pDoc->env.quakeparams, m_params);
   strcpy(pDoc->env.quakegame, m_game);
   strcpy(pDoc->env.quakemap, m_map);
   strcpy(pDoc->env.savedir, m_save);
   strcpy(pDoc->env.loaddir, m_load);
   strcpy(pDoc->env.editor, m_editor);
   strcpy(pDoc->env.waldir, m_waldir);
   strcpy(pDoc->env.modeldir, m_modeldir);
   strcpy(pDoc->env.sounddir, m_sounddir);
   if (pDoc->env.loaddir[strlen(pDoc->env.loaddir) - 1] != '\\')
       sprintf(pDoc->env.loaddir, "%s\\", pDoc->env.loaddir);
   if (pDoc->env.savedir[strlen(pDoc->env.savedir) - 1] != '\\')
       sprintf(pDoc->env.savedir, "%s\\", pDoc->env.savedir);
   if (pDoc->env.waldir[strlen(pDoc->env.waldir) - 1] != '\\')
       sprintf(pDoc->env.waldir, "%s\\", pDoc->env.waldir);
   if (pDoc->env.modeldir[strlen(pDoc->env.modeldir) - 1] != '\\')
       sprintf(pDoc->env.modeldir, "%s\\", pDoc->env.modeldir);
   if (pDoc->env.sounddir[strlen(pDoc->env.sounddir) - 1] != '\\')
       sprintf(pDoc->env.sounddir, "%s\\", pDoc->env.sounddir);
	CDialog::OnOK();
}

BOOL Enviro::OnInitDialog() 
{
	CDialog::OnInitDialog();

   m_god.SetCheck(pDoc->env.god);
   m_cheats.SetCheck(pDoc->env.cheats);
   m_notarget.SetCheck(pDoc->env.notarget);
   m_giveall.SetCheck(pDoc->env.give_all);
   m_disconnect.SetCheck(pDoc->env.disconnect);
   m_playsound.SetCheck(pDoc->env.errorsound);

   m_dir = pDoc->env.quakedir;
   m_params = pDoc->env.quakeparams;
   m_game = pDoc->env.quakegame;
   m_map = pDoc->env.quakemap;
   m_save = pDoc->env.savedir;
   m_load = pDoc->env.loaddir;
   m_editor = pDoc->env.editor;
   m_waldir = pDoc->env.waldir;
   m_modeldir = pDoc->env.modeldir;
   m_sounddir = pDoc->env.sounddir;
   UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
