#include "SJSFreeAmp.h"
#include <direct.h>

SJSFreeAmp::SJSFreeAmp()
{
	// Initialise
    context = new FAContext;
    prefs = new Win32Prefs();
	char prevInstallDir[255];
	unsigned int iLen;

	// SJS
	// This makes it always check for plugins relative to EXE
	char* cwd = new char[255];
	getcwd(cwd, 255);
	iLen = 255;
	prefs->GetInstallDirectory(prevInstallDir, &iLen);
	prefs->SetInstallDirectory(cwd);
	//SJS

    context->prefs = prefs;
    context->log = new LogFile("freeamp.log");

    

    // find all the plug-ins we use
    Registrar* registrar;
    LMCRegistry* lmc;
    PMIRegistry* pmi;
    PMORegistry* pmo;
    UIRegistry*  ui;

    registrar = new Registrar;

    registrar->SetSubDir("plugins");
    registrar->SetSearchString("*.lmc");
    lmc = new LMCRegistry;
    registrar->InitializeRegistry(lmc, context->prefs);

    registrar->SetSearchString("*.pmi");
    pmi = new PMIRegistry;
    registrar->InitializeRegistry(pmi, context->prefs);

    registrar->SetSearchString("*.pmo");
    pmo = new PMORegistry;
    registrar->InitializeRegistry(pmo, context->prefs);

    //registrar->SetSearchString("*.ui");
    //ui = new UIRegistry;
    //registrar->InitializeRegistry(ui, context->prefs);

    delete registrar;

	

    // create the player
	player = Player::GetPlayer(context);

    
    // register items... we give up ownership here
    player->RegisterLMCs(lmc);
    player->RegisterPMIs(pmi);
    player->RegisterPMOs(pmo);
    player->RegisterUIs(ui);

 
    // kick player off
    player->Run();

	
	// Get Playlist manager
	plm = player->getPlayListManager();
	// Set for repeat of current item
	plm->SetRepeat(REPEAT_CURRENT);

	// Set install directory back to previous
	prefs->SetInstallDirectory(prevInstallDir);

}

SJSFreeAmp::~SJSFreeAmp()
{
	
	// Tell player to quit
	player->AcceptEvent(new Event(CMD_QuitPlayer));

	// delete resources
	delete player;
	delete context;

}


void SJSFreeAmp::Play(char* filename)
{
	plm->MakeEmpty();
	plm->AddItem(filename, 1);
	plm->SetFirst();
	//plm->SetRepeat(REPEAT_CURRENT);
	player->AcceptEvent(new Event(CMD_Play));
}

void SJSFreeAmp::Stop(void)
{
	player->AcceptEvent(new Event(CMD_Stop));
}




