/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class MDLMovieCanvas
extends Canvas
implements Runnable {
    long startTime;
    int delayTime = 100;
    int currentFrame;
    Image[] frames;
    Image bImage;
    boolean haveBImage = false;
    boolean scale = false;
    Color bgColor = Color.black;
    int[] delays;
    Thread aniThread;
    int height;
    int width;
    Dimension mySize;
    boolean isAnimated = false;
    int num_frames;
    private String message = "Loading....";
    boolean modelReady = false;
    boolean gotFrames = false;
    int percentage;

    public MDLMovieCanvas(Dimension dimension) {
        this.height = dimension.height;
        this.width = dimension.width;
        this.mySize = dimension;
        this.frames = new Image[1];
        this.delays = new int[1];
    }

    public void setNumberOfFrames(int n) {
        this.frames = new Image[n];
        this.delays = new int[n];
        this.num_frames = n;
    }

    public void setMessage(String string) {
        this.message = string;
        this.repaint();
    }

    public void setDelayTime(int n) {
        if (n < 1000) {
            this.delayTime = n;
        }
    }

    public void movieReady() {
        this.gotFrames = true;
    }

    public void setBackgroundImage(Image image, boolean bl) {
        if (image != null) {
            this.haveBImage = true;
            this.bImage = image;
            this.scale = bl;
        }
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
    }

    public void showPercentage(int n) {
        this.percentage = n;
        this.update(this.getGraphics());
    }

    public void addFrame(Image image, int n, int n2) {
        this.delays[n2] = n;
        Image image2 = this.createImage(this.width, this.height);
        Graphics graphics = image2.getGraphics();
        graphics.setColor(this.bgColor);
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.haveBImage) {
            if (this.scale) {
                graphics.drawImage(this.bImage, 0, 0, this.width, this.height, this);
            } else {
                int n3 = this.bImage.getWidth(this);
                int n4 = this.bImage.getHeight(this);
                int n5 = this.width - n3;
                int n6 = this.height - n4;
                graphics.drawImage(this.bImage, n5 /= 2, n6 /= 2, n3, n4, this);
            }
        }
        graphics.drawImage(image, 0, 0, this);
        this.frames[n2] = image2;
        this.currentFrame = n2;
        this.update(this.getGraphics());
    }

    public void addFrame(Image image, int n) {
        this.delays[n] = this.delayTime;
        Image image2 = this.createImage(this.width, this.height);
        Graphics graphics = image2.getGraphics();
        graphics.setColor(this.bgColor);
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.haveBImage) {
            if (this.scale) {
                graphics.drawImage(this.bImage, 0, 0, this.width, this.height, this);
            } else {
                int n2 = this.bImage.getWidth(this);
                int n3 = this.bImage.getHeight(this);
                int n4 = this.width - n2;
                int n5 = this.height - n3;
                graphics.drawImage(this.bImage, n4 /= 2, n5 /= 2, n2, n3, this);
            }
        }
        graphics.drawImage(image, 0, 0, this);
        this.frames[n] = image2;
        this.currentFrame = n;
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.mySize;
    }

    public Dimension getPreferedSize() {
        return this.mySize;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void setModelReady(boolean bl) {
        this.modelReady = bl;
    }

    public void update(Graphics graphics) {
        if (this.frames[this.currentFrame] != null) {
            graphics.drawImage(this.frames[this.currentFrame], 0, 0, this);
            return;
        }
        if (!this.modelReady && graphics != null) {
            Image image = this.createImage(this.width, this.height);
            Graphics graphics2 = image.getGraphics();
            graphics2.setColor(Color.white);
            graphics2.fillRect(0, 0, this.width, this.height);
            graphics2.setColor(Color.black);
            graphics2.drawRect(0, 0, this.width, this.height);
            graphics2.drawString(this.message, 5, 30);
            graphics2.drawRect(5, 32, this.width - 10, 10);
            int n = (int)((float)this.percentage * (float)(this.width - 10));
            graphics2.fillRect(5, 32, n /= 100, 10);
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public void startAnimation() {
        if (!this.isAnimated && this.gotFrames) {
            this.isAnimated = true;
            this.startTime = System.currentTimeMillis();
            this.aniThread = new Thread((Runnable)this, "animateThread");
            this.aniThread.start();
        }
    }

    public void stopAnimation() {
        this.isAnimated = false;
    }

    public void run() {
        while (this.isAnimated) {
            Thread.yield();
            ++this.currentFrame;
            this.currentFrame %= this.num_frames;
            this.update(this.getGraphics());
            try {
                this.startTime += (long)this.delays[this.currentFrame];
                Thread.sleep(Math.max(0L, this.startTime - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Interupted animation thread");
            }
        }
    }

    public int getFrameNumber() {
        return this.currentFrame;
    }

    public static final String getAuthorInfo() {
        return "Copyright T.J.Grey 1998";
    }
}

