/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;

public class MDLMovie
extends Applet
implements MDLModelTracker,
Runnable {
    MDLViewCanvas mdlViewCanvas;
    MDLMovieCanvas mdlMovieCanvas;
    static int Version = 103;
    URL codeBase;
    URL docBase;
    URL paletteURL;
    URL modelURL;
    MDLModel myModel;
    static final int MDL_VER = 6;
    String modelFileName;
    String palFileName;
    int movieType = 1;
    static final int movieRotate = 1;
    static final int movieAnimate = 2;
    Dimension d;
    String loadframes;
    String loadskins;
    boolean initialised = false;
    int shiftY;
    boolean modelReady = false;
    boolean DEBUG;
    boolean noOut = false;
    String statusMessage;

    public void init() {
        System.gc();
        String string = this.getParameter("NOSTATUS");
        if (string != null) {
            string = string.toLowerCase();
            this.noOut = string.startsWith("t");
        }
        this.debugOut("MDLMovie v" + Version / 100 + "." + Version % 100 + " by T.J.Grey (tjg1@ch.ic.ac.uk)");
        this.showStatus("MDLView: Initialising...");
        this.codeBase = this.getCodeBase();
    }

    public void start() {
        this.codeBase = this.getCodeBase();
        this.docBase = this.getDocumentBase();
        System.gc();
        System.gc();
        System.gc();
        Dimension dimension = this.size();
        if (!this.initialised) {
            Object object;
            this.DEBUG = this.getParameter("DEBUG") != null;
            dimension = this.size();
            this.showStatus("MDLMovie: Initialising canvas");
            this.mdlMovieCanvas = new MDLMovieCanvas(dimension);
            this.setLayout(new BorderLayout());
            this.add("Center", this.mdlMovieCanvas);
            this.mdlMovieCanvas.setModelReady(false);
            this.codeBase = this.getCodeBase();
            this.docBase = this.getDocumentBase();
            String string = this.getParameter("BCOLOUR");
            if (string == null || string.length() != 7) {
                System.out.println("MDLMovie: BCOLOUR not specified or specified incorrectly, using white for background");
                System.out.println("... usage eg <PARAM NAME=BCOLOUR VALUE=#FF00FF>");
                string = "#FFFFFF";
            }
            this.mdlMovieCanvas.setBackground(this.getColourFromHex(string));
            String string2 = this.getParameter("BIMAGE");
            String string3 = this.getParameter("SCALEBIMAGE");
            if (string3 == null) {
                string3 = "false";
            }
            if (string2 != null) {
                object = new MediaTracker(this);
                Image image = this.getImage(this.getDocumentBase(), string2);
                ((MediaTracker)object).addImage(image, 0);
                this.showStatus("MDLView: Loading background");
                this.debugOut("MDLView: Loading background image as " + string2);
                try {
                    ((MediaTracker)object).waitForAll();
                }
                catch (InterruptedException interruptedException) {}
                if (((MediaTracker)object).checkAll() && !((MediaTracker)object).isErrorAny()) {
                    boolean bl = false;
                    String string4 = this.getParameter("SCALEBIMAGE");
                    if (string4 != null) {
                        bl = (string4 = string4.toLowerCase()).equals("true");
                    }
                    this.mdlMovieCanvas.setBackgroundImage(image, bl);
                } else {
                    System.out.println("MDLView: BIMAGE ignored- error getting image");
                    this.showStatus("MDLView: BIMAGE ignored- error getting image");
                }
            }
            this.showStatus("MDLMovie: Begining initialisation thread");
            object = new Thread((Runnable)this, "MDLInitThread");
            ((Thread)object).start();
            return;
        }
        this.mdlMovieCanvas.startAnimation();
    }

    public void run() {
        int n;
        int n2;
        String string;
        int n3;
        String string2;
        Object object;
        Object object2;
        String string3 = this.getParameter("FORMAT");
        String string4 = "MDL" + string3 + "Model";
        if (string3 == null) {
            string4 = "MDLquakeModel";
        }
        this.showStatus("MDLMovie: Finding and loading model format: " + string4);
        try {
            this.debugOut("MDLMovie: Instancing model as " + string4);
            this.showStatus("MDLMovie: Instancing model as " + string4);
            object2 = Class.forName(string4);
            this.debugOut("MDLMovie: Model class created");
            this.showStatus("MDLMovie: Model class created");
            object = ((Class)object2).newInstance();
            this.showStatus("MDLMovie: Model class instanced");
            this.debugOut("MDLMovie: Model class instanced");
            this.myModel = (MDLModel)object;
            this.debugOut("MDLMovie: Model class cast");
            this.showStatus("MDLMovie: Model class cast");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("MDLMovie: No class can be found which matches the FORMAT you specifed");
            throw new RuntimeException("MDLMovie: No class can be found which matches the FORMAT you specifed");
        }
        catch (InstantiationException instantiationException) {
            System.out.println("MDLMovie: Model class problem: Instancing exception: " + instantiationException);
            throw new RuntimeException("MDLMovie: Model class problem: Instancing exception");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("MDLMovie: Model class problem: IllegalAccessException exception: " + illegalAccessException);
            throw new RuntimeException("MDLMovie: Model class problem: IllegalAccessException exception");
        }
        this.myModel.setModelTracker((MDLModelTracker)this);
        this.d = this.size();
        this.showStatus("MDLMovie: Initialising renderer");
        this.mdlViewCanvas = new MDLViewCanvas(this.d, this.myModel, this.DEBUG);
        object2 = this.getParameter("MOVIETYPE");
        if (object2 == null) {
            object2 = "rotate";
        }
        this.movieType = ((String)(object2 = ((String)object2).toLowerCase())).equals("animate") ? 2 : 1;
        object = this.getParameter("SHIFTY");
        if (object != null) {
            try {
                this.shiftY = Integer.decode(object);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("MDLMovie: Bad SHIFTY value: " + object);
                this.shiftY = 0;
            }
        } else {
            this.shiftY = 0;
        }
        if ((string2 = this.getParameter("DELAYTIME")) != null) {
            try {
                n3 = Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("MDLMovie: Bad DELAYTIME value: " + string2);
                n3 = 100;
            }
        } else {
            n3 = 100;
        }
        this.mdlMovieCanvas.setDelayTime(n3);
        String string5 = this.getParameter("ZOOM");
        float f = 0.0f;
        if (string5 != null) {
            try {
                f = Double.valueOf(string5).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("MDLMovie: Bad ZOOM value: " + string5);
            }
            this.mdlViewCanvas.setZoom(f);
        }
        if ((string = this.getParameter("YANGLE")) != null) {
            try {
                n2 = Integer.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("MDLMovie: Bad YANGLE value: " + string);
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        this.mdlViewCanvas.setZAngle(n2);
        String string6 = this.getParameter("XANGLE");
        if (string6 != null) {
            try {
                n = Integer.decode(string6);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("MDLMovie: Bad XANGLE value: " + string6);
                n = 0;
            }
        } else {
            n = 0;
        }
        this.mdlViewCanvas.setYAngle(n);
        String string7 = this.getParameter("MODEL");
        if (this.modelFileName != string7) {
            if (string7 == null) {
                System.out.println("MDLMovie: No model specified... please add to html...");
                System.out.println("          <PARAM NAME=MODEL VALUE=player.mdl>");
                this.showStatus("MDLMovie: !!Fatal!! No model to load");
                this.mdlViewCanvas.setMode("Error");
                throw new RuntimeException("MDLMovie: Can't run- no model specified in page");
            }
            this.modelFileName = string7;
            this.modelReady = false;
        }
        this.mdlViewCanvas.setMode("texturemapped");
        this.loadframes = this.getParameter("LOADFRAMES");
        this.loadskins = this.getParameter("LOADSKINS");
        if (this.movieType == 1 && this.myModel.getNumberOfFrames() > 1) {
            System.out.println("MDLMovie: Bad load frames- only need ONE frame for rotation");
            throw new RuntimeException("MDLMovie: Bad loadframes: More than one frame in a rotate movie");
        }
        if (this.movieType == 2 && this.myModel.getNumberOfFrames() > 100) {
            System.out.println("MDLMovie: Can't have more than 100 frames!");
            throw new RuntimeException("MDLMovie: Can't have more than 100 frames!");
        }
        this.getModel(this.docBase, this.modelFileName, this.loadframes, this.loadskins, this.shiftY);
        this.mdlViewCanvas.setModel(this.myModel);
    }

    public void stop() {
        if (this.myModel != null) {
            this.myModel.stopCall();
        }
        this.mdlMovieCanvas.stopAnimation();
    }

    public void showPercentage(int n) {
        this.mdlMovieCanvas.showPercentage(n);
    }

    public void debugOut(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    public String getAppletInfo() {
        return "MDLMovie v" + Version / 100 + "." + Version % 100 + ": An Applet by T.J.Grey to Display Model Files";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"MODEL", "relative URL", "The URL of the mdl file relative to document base (ie the HTML page)"}, {"MOVIETYPE", "String", "Type of movie: 'ROTATE' or 'ANIMATE'"}, {"BCOLOUR", "hex number", "Colour of background eg #FFFFFF"}, {"PALETTE", "relative URL", "URL of Palette file, relative to codebase"}, {"LOADFRAMES", "string", "Number frames to load , then frame numbers IN ORDER, no spaces eg 4,0-3,5 (NB need only one frame for a ROTATE movie)"}, {"LOADSKINS", "string", "Number skins to load, then skin numbers IN ORDER, no spaces eg 2,0,5"}, {"DELAYTIME", "int", "Time between frames in milliseconds if < 100"}, {"YANGLE", "int", "Start with model rotated by this about the vertical angle"}, {"XANGLE", "int", "Start with model rotated by this about the left/right angle"}, {"NOSTATUS", "boolean", "Suppress statusline messages"}, {"ZOOM", "float", "Zoom level for model- use with care!"}, {"SHIFTY", "int", "Shifts model vertically (use with care!)"}, {"BIMAGE", "relative URL", "Image to be used as background"}, {"SCALEBIMAGE", "Boolean", "Scale background image to fill background"}, {"EXTRA", "String", "Extra info for model format- model format specific"}, {"MOUSEOVER", "String", "Text to show when user moves mouse over applet"}};
        return stringArray;
    }

    public void modelReady() {
        int n;
        this.showStatus("MDLMovie: Model read");
        this.debugOut("MDLMovie: Model read");
        String string = this.getParameter("PALETTE");
        String string2 = this.getParameter("FORMAT");
        IndexColorModel indexColorModel = null;
        if (string == null) {
            string = string2 == null ? "quake.pal" : String.valueOf(string2) + ".pal";
        }
        if (string.equals("INTERNAL")) {
            this.debugOut("MDLMovie: Internal palette!");
            indexColorModel = this.myModel.getInternalPalette();
            if (indexColorModel == null) {
                System.out.println("MDLMovie: Model won't give me the internal palette :( ");
                throw new RuntimeException("MDLMovie: Model won't give me the internal palette :( ");
            }
        } else if (string != this.palFileName) {
            indexColorModel = this.readPalette(this.getCodeBase(), string);
            this.palFileName = string;
        }
        this.mdlViewCanvas.setPalette(indexColorModel);
        this.mdlViewCanvas.modelReady();
        this.mdlMovieCanvas.setModelReady(true);
        this.showStatus("MDLMovie: Generating animation");
        this.debugOut("MDLMovie: Generating animation");
        if (this.movieType == 2) {
            n = this.myModel.getNumberOfAnimationFrames(0, this.myModel.getNumberOfFrames() - 1);
            this.myModel.setCurrentFrameIndex(0);
            n = Math.min(100, n);
            this.mdlMovieCanvas.setNumberOfFrames(n);
            int n2 = 0;
            while (n2 < n) {
                this.showStatus("MDLMovie: Generating frame " + n2);
                this.debugOut("MDLMovie: Generating frame " + n2);
                this.mdlMovieCanvas.addFrame(this.mdlViewCanvas.getImage(), this.myModel.getFrameDelayMillis(), n2);
                this.mdlViewCanvas.nextSimpleFrame();
                ++n2;
            }
        } else {
            this.mdlMovieCanvas.setNumberOfFrames(20);
            n = 0;
            while (n < 20) {
                this.showStatus("MDLMovie: Generating frame " + n);
                this.mdlMovieCanvas.addFrame(this.mdlViewCanvas.getImage(), n);
                this.mdlViewCanvas.rotateZ(18);
                ++n;
            }
        }
        this.add("Center", this.mdlMovieCanvas);
        this.mdlMovieCanvas.movieReady();
        this.mdlMovieCanvas.startAnimation();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        this.showStatus("MDLMovie: Starting movie");
        this.mdlViewCanvas = null;
        this.myModel = null;
        this.initialised = true;
        this.repaint();
        String string3 = this.getParameter("MOUSEOVER");
        if (string3 != null) {
            this.statusMessage = "MDLMovie: " + string3;
            return;
        }
        this.statusMessage = "MDLMovie running";
    }

    public void showStatus(String string) {
        if (!this.modelReady) {
            this.statusMessage = string;
        }
        if (!this.noOut) {
            super.showStatus(this.statusMessage);
            if (this.mdlMovieCanvas != null) {
                this.mdlMovieCanvas.setMessage(string);
            }
        }
    }

    public final String getAuthorInfo() {
        return "T.J.Grey (tjg1@ch.ic.ac.uk) Copyright 1998";
    }

    private IndexColorModel readPalette(URL uRL, String string) {
        IndexColorModel indexColorModel = null;
        try {
            this.paletteURL = new URL(this.codeBase, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MDLMovie: Error in palette URL <" + malformedURLException + ">");
            this.showStatus("MDLMovie: Error in palette URL...");
            throw new RuntimeException("MDLMovie: Can't get palette");
        }
        this.showStatus("MDLMovie: Opening connection for palette as " + this.paletteURL);
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(this.paletteURL.openStream());
            StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
            streamTokenizer.eolIsSignificant(true);
            int n2 = 0;
            while (n2 < 2) {
                n = streamTokenizer.nextToken();
                if (n != 10) continue;
                ++n2;
            }
            streamTokenizer.nextToken();
            n = (int)streamTokenizer.nval;
            if (n != 256) {
                System.out.println("MDLMovie: !CARE!.. Pal says " + n + " colours.. we use 255");
            }
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            streamTokenizer.eolIsSignificant(false);
            int n3 = 0;
            while (n3 < n) {
                streamTokenizer.nextToken();
                byArray[n3] = (byte)streamTokenizer.nval;
                streamTokenizer.nextToken();
                byArray2[n3] = (byte)streamTokenizer.nval;
                streamTokenizer.nextToken();
                byArray3[n3] = (byte)streamTokenizer.nval;
                ++n3;
            }
            indexColorModel = new IndexColorModel(8, n, byArray, byArray2, byArray3, 255);
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            System.out.println("MDLMovie: Error reading palette- <" + iOException + ">");
            this.showStatus("MDLMovie: Error reading palette- <" + iOException + ">");
            throw new RuntimeException("MDLMovie: Error getting palette");
        }
        return indexColorModel;
    }

    public String getExtraParameter() {
        return this.getParameter("EXTRA");
    }

    private int intFromFourBytes(byte[] byArray) {
        int n = 0;
        n |= (byArray[0] & 0xFF) << 24;
        n |= (byArray[1] & 0xFF) << 16;
        n |= (byArray[2] & 0xFF) << 8;
        return n |= byArray[3] & 0xFF;
    }

    private float floatFromFourBytes(byte[] byArray) {
        float f = 0.0f;
        int n = this.intFromFourBytes(byArray);
        f = Float.intBitsToFloat(n);
        return f;
    }

    private int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[3 - n] = (byte)inputStream.read();
            ++n;
        }
        return this.intFromFourBytes(byArray);
    }

    private float readFloat(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[3 - n] = (byte)inputStream.read();
            ++n;
        }
        return this.floatFromFourBytes(byArray);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.mdlMovieCanvas.isAnimated()) {
            this.showStatus("MDLMovie: Starting movie...");
            this.mdlMovieCanvas.startAnimation();
        } else {
            this.showStatus("MDLMovie: Stopping movie..");
            this.mdlMovieCanvas.stopAnimation();
        }
        return true;
    }

    public InputStream getStreamForFile(String string) {
        URL uRL = null;
        try {
            uRL = new URL(this.getDocumentBase(), string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MDLMovie: Error in requested URL <" + malformedURLException + ">");
            this.showStatus("MDLMovie: Error in requested URL...");
            throw new RuntimeException("MDLMovie: Error in requested URL");
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            System.out.println("MDLMovie: Error reading model-requested URL for " + string + ": " + iOException);
            this.showStatus("MDLMovie: Error reading a model-requested URL for " + string);
            throw new RuntimeException("MDLMovie: Error reading URL");
        }
        return inputStream;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.requestFocus();
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        this.showStatus(this.statusMessage);
        return true;
    }

    private void getModel(URL uRL, String string, String string2, String string3, int n) {
        try {
            this.modelURL = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MDLMovie: Error in model URL <" + malformedURLException + ">");
            this.showStatus("MDLMovie: Error in model URL...");
            throw new RuntimeException("MDLMovie: Error in model URL");
        }
        this.myModel.readModel(this.docBase, this.codeBase, string2, string3, n);
        this.showStatus("MDLMovie: Opening connection for model as " + this.modelURL);
    }

    private Color getColourFromHex(String string) throws NumberFormatException {
        String string2 = "0x" + string.substring(1, 3);
        String string3 = "0x" + string.substring(3, 5);
        String string4 = "0x" + string.substring(5, 7);
        int n = Integer.decode(string2);
        int n2 = Integer.decode(string3);
        int n3 = Integer.decode(string4);
        return new Color(n, n2, n3);
    }
}

