/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;

public class MDLViewMain {
    MDLView master;
    MDLViewCanvas mdlViewCanvas;
    MDLHelpWindow helpWindow;
    Frame skinWindow;
    URL codeBase;
    URL docBase;
    URL paletteURL;
    String palFileName;
    MDLModel myModel;
    static final int MDL_VER = 6;
    String modelFileName;
    int mouseX;
    int mouseY;
    boolean moveNotRotate;
    boolean tabReady = true;
    boolean fastRendering = false;
    boolean suppressFastRender = false;
    boolean initialised = false;
    boolean rotating = false;
    boolean modelReady = false;
    int shiftY;
    int i;
    String statusMessage;

    public MDLViewMain(MDLView mDLView) {
        System.gc();
        this.master = mDLView;
        if (MDLView.Version % 100 >= 10) {
            this.master.showStatus("MDLView v" + MDLView.Version / 100 + "." + MDLView.Version % 100 + " by T.J.Grey (tjg1@ch.ic.ac.uk)");
        } else {
            this.master.showStatus("MDLView v" + MDLView.Version / 100 + ".0" + MDLView.Version % 100 + " by T.J.Grey (tjg1@ch.ic.ac.uk)");
        }
        this.master.showStatus("MDLView: Initialising...");
        this.codeBase = this.master.getCodeBase();
        this.master.size();
        this.modelFileName = "newModelNotSet";
    }

    public void start() {
        Object object;
        String string;
        String string2;
        System.gc();
        System.gc();
        System.gc();
        if (!this.initialised) {
            int n;
            int n2;
            String string3;
            Object object2;
            this.codeBase = this.master.getCodeBase();
            this.docBase = this.master.getDocumentBase();
            string2 = this.master.getParameter("FORMAT");
            string = "MDL" + string2 + "Model";
            if (string2 == null) {
                string = "MDLquakeModel";
            }
            this.master.showStatus("MDLView: Finding model format class: " + string);
            try {
                this.master.showStatus("MDLView: Instancing model as " + string);
                object = Class.forName(string);
                this.master.showStatus("MDLView: Model class created");
                object2 = ((Class)object).newInstance();
                this.master.showStatus("MDLView: Creating model class instance");
                this.myModel = (MDLModel)object2;
                this.master.showStatus("MDLView: Model class cast");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.error("No class (MDL" + string2 + "Model.class) can be found which matches the FORMAT you specifed");
            }
            catch (InstantiationException instantiationException) {
                this.error("Model class problem: Instancing exception: " + instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.error("Model class problem: IllegalAccessException exception: " + illegalAccessException);
            }
            this.myModel.setModelTracker((MDLModelTracker)this.master);
            this.master.getParameter("LOADSKINS");
            object = this.master.size();
            this.master.showStatus("MDLView: Loading and initialising renderer");
            this.mdlViewCanvas = new MDLViewCanvas((Dimension)object, this.myModel, this.master.DEBUG);
            this.master.showStatus("MDLView: Initialised, adding canvas to applet");
            this.master.setLayout(new BorderLayout());
            this.master.add("Center", (Component)this.mdlViewCanvas);
            object2 = this.master.getParameter("SHIFTY");
            if (object2 != null) {
                try {
                    this.shiftY = Integer.decode(object2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad SHIFTY value: " + object2);
                    this.shiftY = 0;
                }
            } else {
                this.shiftY = 0;
            }
            String string4 = this.master.getParameter("ZOOM");
            float f = 0.0f;
            if (string4 != null) {
                try {
                    f = Double.valueOf(string4).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad ZOOM value: " + string4);
                }
                this.mdlViewCanvas.setZoom(f);
            }
            if ((string3 = this.master.getParameter("YANGLE")) != null) {
                try {
                    n2 = Integer.decode(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad YANGLE value: " + string3);
                    n2 = 0;
                }
            } else {
                n2 = 0;
            }
            this.mdlViewCanvas.setZAngle(n2);
            String string5 = this.master.getParameter("XANGLE");
            if (string5 != null) {
                try {
                    n = Integer.decode(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad XANGLE value: " + string5);
                    n = 0;
                }
            } else {
                n = 0;
            }
            this.mdlViewCanvas.setYAngle(n);
            String string6 = this.master.getParameter("ROTATE");
            if (string6 != null) {
                this.rotating = this.interpretBoolean(string6);
                this.mdlViewCanvas.setRotating(this.rotating);
            } else {
                this.mdlViewCanvas.setRotating(false);
                this.rotating = false;
            }
            String string7 = this.master.getParameter("CYCLE");
            if (string7 != null) {
                this.mdlViewCanvas.startAnimated(this.interpretBoolean(string7));
            } else {
                this.mdlViewCanvas.startAnimated(false);
            }
            String string8 = this.master.getParameter("RENDERMODE");
            if (this.myModel.getModelError()) {
                this.mdlViewCanvas.setMode("error");
            } else if (string8 != null) {
                this.mdlViewCanvas.setMode(string8);
            } else {
                this.mdlViewCanvas.setMode("wireframe");
            }
            this.mdlViewCanvas.setForegroundColour(this.master.getForeground());
            this.mdlViewCanvas.setBackgroundColour(this.master.getBackground());
            this.initialised = true;
        }
        if (this.modelFileName != (string2 = this.master.getParameter("MODEL"))) {
            if (string2 == null) {
                this.error("MDLView: No model specified... please add to html... <PARAM NAME=MODEL VALUE=nameOfModelFile");
            } else {
                this.modelFileName = string2;
            }
            this.modelReady = false;
        }
        if (this.myModel.getModelReady()) {
            this.mdlViewCanvas.modelReady();
            this.mdlViewCanvas.start();
        } else {
            string = this.master.getParameter("LOADSKINS");
            object = this.master.getParameter("LOADFRAMES");
            this.master.removeAll();
            int n = this.shiftY;
            this.myModel.readModel(this.docBase, this.codeBase, (String)object, string, n);
            this.mdlViewCanvas.setModel(this.myModel);
        }
        this.master.repaint();
    }

    public void stop() {
        this.myModel.stopCall();
        this.mdlViewCanvas.stop();
    }

    public void destroy() {
        this.myModel.stopCall();
        System.gc();
    }

    public void modelReady() {
        Object object;
        this.modelReady = true;
        IndexColorModel indexColorModel = null;
        String string = this.master.getParameter("LOADSKINS");
        String string2 = this.master.getParameter("FORMAT");
        this.master.showStatus("MDLView: Model read");
        if (string == null || !string.startsWith("0")) {
            object = this.master.getParameter("PALETTE");
            if (object == null) {
                object = string2 == null ? "quake.pal" : String.valueOf(string2) + ".pal";
            }
            if (((String)object).equals("INTERNAL")) {
                this.master.showStatus("MDLView: Internal palette!");
                indexColorModel = this.myModel.getInternalPalette();
                if (indexColorModel == null) {
                    this.error("Model won't give me the internal palette :( ");
                }
            } else if (object != this.palFileName) {
                indexColorModel = this.readPalette(this.master.getCodeBase(), (String)object);
                this.palFileName = object;
            }
        }
        this.master.add((Component)this.mdlViewCanvas);
        this.master.validate();
        this.mdlViewCanvas.setPalette(indexColorModel);
        if (this.master.haveBackgroundImage()) {
            object = this.master.getBackgroundImage();
            boolean bl = this.master.scaleBackgroundImage();
            this.mdlViewCanvas.initialiseGraphics((Image)object, bl);
        } else {
            this.mdlViewCanvas.initialiseGraphics(null, false);
        }
        this.mdlViewCanvas.modelReady();
        this.master.showStatus("MDLView: Starting renderer");
        this.mdlViewCanvas.start();
    }

    public final String getAuthorInfo() {
        return "T.J.Grey (tjg1@ch.ic.ac.uk) Copyright 1998";
    }

    private IndexColorModel readPalette(URL uRL, String string) {
        IndexColorModel indexColorModel = null;
        try {
            this.paletteURL = new URL(this.codeBase, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MDLView: Error in palette URL <" + malformedURLException + ">");
            this.master.showStatus("MDLView: Error in palette URL...");
            throw new RuntimeException("MDLView: Error in palette URL...");
        }
        this.master.showStatus("MDLView: Opening connection for palette as " + this.paletteURL);
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(this.paletteURL.openStream());
            StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
            streamTokenizer.eolIsSignificant(true);
            int n2 = 0;
            while (n2 < 2) {
                n = streamTokenizer.nextToken();
                if (n != 10) continue;
                ++n2;
            }
            streamTokenizer.nextToken();
            n = (int)streamTokenizer.nval;
            if (n != 256) {
                this.master.showStatus("MDLView: !CARE!.. Pal says " + n + " colours.. we use 256");
            }
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            streamTokenizer.eolIsSignificant(false);
            int n3 = 0;
            while (n3 < n) {
                this.master.showStatus("MDLView: Reading colour " + n3);
                streamTokenizer.nextToken();
                byArray[n3] = (byte)streamTokenizer.nval;
                streamTokenizer.nextToken();
                byArray2[n3] = (byte)streamTokenizer.nval;
                streamTokenizer.nextToken();
                byArray3[n3] = (byte)streamTokenizer.nval;
                ++n3;
            }
            indexColorModel = new IndexColorModel(8, n, byArray, byArray2, byArray3, 255);
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            this.error("Error reading palette- <" + iOException + ">");
        }
        return indexColorModel;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.mouseX = n;
        this.mouseY = n2;
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.i = this.mdlViewCanvas.getRenderMode();
        if (this.i == 2 && !this.suppressFastRender) {
            this.fastRendering = true;
            this.mdlViewCanvas.setRenderMode(1);
        }
        if (this.moveNotRotate) {
            this.mdlViewCanvas.translateZ(2 * (this.mouseY - n2));
        } else {
            this.mdlViewCanvas.rotateZ(n - this.mouseX);
            this.mdlViewCanvas.rotateY(n2 - this.mouseY);
        }
        this.mouseX = n;
        this.mouseY = n2;
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        this.master.showStatus(this.statusMessage);
        return true;
    }

    public boolean keyDown(Event event, int n) {
        switch (n) {
            case 63: {
                if (this.helpWindow == null) {
                    this.helpWindow = new MDLHelpWindow(MDLView.Version, this.myModel);
                    this.helpWindow.show();
                } else {
                    this.helpWindow.show();
                }
                return true;
            }
            case 109: {
                this.mdlViewCanvas.toggleShowInfo();
                return true;
            }
            case 122: {
                this.moveNotRotate = true;
                return true;
            }
            case 97: {
                this.suppressFastRender = !this.suppressFastRender;
                this.master.showStatus("MDLView: Goto wireframe is now " + !this.suppressFastRender);
                return true;
            }
            case 114: {
                this.rotating = !this.rotating;
                this.master.showStatus("MDLView: Rotate model is now " + this.rotating);
                this.mdlViewCanvas.setRotating(this.rotating);
                return true;
            }
            case 9: {
                if (this.tabReady) {
                    this.master.showStatus("MDLView: Changing mode");
                    this.mdlViewCanvas.nextRenderMode();
                    this.tabReady = false;
                    return true;
                }
            }
            case 1006: {
                this.master.showStatus("MDLView: Retreating one sub-frame");
                this.mdlViewCanvas.lastSimpleFrame();
                return true;
            }
            case 1007: {
                this.mdlViewCanvas.nextSimpleFrame();
                this.master.showStatus("MDLView: Advancing one sub-frame");
                return true;
            }
            case 99: {
                if (!this.mdlViewCanvas.isAnimated) {
                    this.master.showStatus("MDLView: Starting animation");
                    this.mdlViewCanvas.startAnimation();
                } else {
                    this.master.showStatus("MDLView: Stopping animation");
                    this.mdlViewCanvas.stopAnimation();
                }
                return true;
            }
            case 1004: {
                if (this.mdlViewCanvas.getRenderMode() == 2) {
                    this.mdlViewCanvas.lastSkin();
                    return true;
                }
            }
            case 1005: {
                if (this.mdlViewCanvas.getRenderMode() != 2) break;
                this.mdlViewCanvas.nextSkin();
                return true;
            }
        }
        if (this.myModel.keyPressed(n)) {
            this.mdlViewCanvas.scheduleTransform();
            this.mdlViewCanvas.scheduleRender();
        }
        return true;
    }

    public boolean keyUp(Event event, int n) {
        switch (n) {
            case 122: {
                this.moveNotRotate = false;
                return true;
            }
            case 9: {
                this.tabReady = true;
                return true;
            }
        }
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.fastRendering && !this.suppressFastRender) {
            this.fastRendering = false;
            this.mdlViewCanvas.setRenderMode(2);
            return true;
        }
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.master.requestFocus();
        this.master.showStatus("MDLView: For help press '?'");
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.master.showStatus("");
        return false;
    }

    protected boolean interpretBoolean(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).startsWith("t");
    }

    private void error(String string) {
        this.master.showStatus("MDLView " + string);
        System.out.println("MDLView " + string);
        throw new RuntimeException("MDLView " + string);
    }

    private void getModel(String string, String string2, String string3, int n) {
        this.myModel.readModel(this.docBase, this.codeBase, string2, string3, n);
    }
}

