/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.Serializable;

public class MDLView
extends Applet
implements MDLModelTracker,
Runnable {
    MDLViewMain main;
    boolean initialised = false;
    boolean modelReady = false;
    String mouseOverText;
    String statusMessage = "MDLView loading...";
    Color backgroundColour;
    Color foregroundColour;
    boolean haveBImage = false;
    boolean scaleBI;
    Image bImage;
    boolean DEBUG = false;
    boolean noOut = false;
    static int Version = 103;
    int w;
    int h;
    int ix;
    int iy;
    int pcolx;
    int pcorx;
    int pcoty;
    int pcoby;
    Thread starterThread;
    int pcbx;

    public void init() {
        System.gc();
        String string = this.getParameter("NOSTATUS");
        if (string != null) {
            string = string.toLowerCase();
            this.noOut = string.startsWith("t");
        }
        this.showStatus("MDLView: Initialising...");
        String string2 = this.getParameter("BCOLOUR");
        String string3 = this.getParameter("FCOLOUR");
        this.backgroundColour = this.getColourFromString(string2);
        this.foregroundColour = this.getColourFromString(string3);
        Dimension dimension = this.size();
        this.w = dimension.width;
        this.h = dimension.height;
        this.pcolx = (int)(0.05 * (double)(this.w - 1));
        this.pcorx = this.w - 1 - 2 * this.pcolx;
        this.pcoty = (int)(0.1 * (double)(this.h - 1));
        if (this.pcoty < 36) {
            this.pcoty = 36;
        }
        this.pcoby = 14;
        this.pcbx = 0;
        this.showStatus("MDLView: Loading main applet methods");
    }

    public void start() {
        if (!this.initialised) {
            Serializable serializable;
            this.removeAll();
            this.DEBUG = this.getParameter("DEBUG") != null;
            this.setLayout(new BorderLayout());
            String string = this.getParameter("BCOLOUR");
            String string2 = this.getParameter("FCOLOUR");
            this.backgroundColour = this.getColourFromString(string);
            this.foregroundColour = this.getColourFromString(string2);
            this.haveBImage = false;
            String string3 = this.getParameter("BIMAGE");
            String string4 = this.getParameter("SCALEBIMAGE");
            if (string4 == null) {
                string4 = "false";
            }
            this.scaleBI = !(string4 = string4.toLowerCase()).startsWith("f");
            if (string3 != null) {
                serializable = new MediaTracker(this);
                this.bImage = this.getImage(this.getDocumentBase(), string3);
                ((MediaTracker)serializable).addImage(this.bImage, 0);
                this.showStatus("MDLView: Loading background");
                try {
                    ((MediaTracker)serializable).waitForAll();
                }
                catch (InterruptedException interruptedException) {}
                if (((MediaTracker)serializable).checkAll() && !((MediaTracker)serializable).isErrorAny()) {
                    this.haveBImage = true;
                } else {
                    System.out.println("MDLView: BIMAGE ignored- error getting image");
                    this.showStatus("MDLView: BIMAGE ignored- error getting image");
                }
            }
            serializable = this.size();
            this.w = ((Dimension)serializable).width;
            this.h = ((Dimension)serializable).height;
            this.pcolx = (int)(0.05 * (double)(this.w - 1));
            this.pcorx = this.w - 1 - 2 * this.pcolx;
            this.pcoty = (int)(0.1 * (double)(this.h - 1));
            if (this.pcoty < 36) {
                this.pcoty = 36;
            }
            this.pcoby = 14;
            this.pcbx = 0;
        }
        this.showStatus("MDLView: Creating thread to read parameters");
        this.starterThread = new Thread((Runnable)this, "StarterThread");
        this.starterThread.start();
    }

    public void stop() {
        this.main.stop();
        if (this.starterThread != null && this.starterThread.isAlive()) {
            this.starterThread.stop();
            this.starterThread = null;
            this.initialised = false;
        }
        this.main.stop();
    }

    public Image getBackgroundImage() {
        return this.bImage;
    }

    public boolean haveBackgroundImage() {
        return this.haveBImage;
    }

    public boolean scaleBackgroundImage() {
        return this.scaleBI;
    }

    public void destroy() {
        this.main.destroy();
    }

    public Color getBackground() {
        return this.backgroundColour;
    }

    public Color getForeground() {
        return this.foregroundColour;
    }

    public String getAppletInfo() {
        if (Version % 100 >= 10) {
            return "MDLView v" + Version / 100 + "." + Version % 100 + ": An Applet by T.J.Grey to Display 3D Model Files";
        }
        return "MDLView v" + Version / 100 + ".0" + Version % 100 + ": An Applet by T.J.Grey to Display 3D Model Files";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"MODEL", "relative URL", "The URL of the model file (ie MODELPATH is not set) relative to document base (ie the HTML page)"}, {"MODELPATH", "relative URL", "The path of the model files relative to code base (ie the applet classes)"}, {"BCOLOUR", "hex number", "Colour of background eg #FFFFFF"}, {"FCOLOUR", "hex number", "Colour used for wireframe eg #000000"}, {"PALETTE", "relative URL", "URL of Palette file, relative to codebase"}, {"FORMAT", "string", "Supported model type- the name of the Model class without 'MDL' or 'Model'"}, {"LOADFRAMES", "string", "Number frames to load, then frame numbers IN ORDER, no spaces eg 4,0-3,5"}, {"LOADSKINS", "string", "Number skins to load, then skin numbers IN ORDER, no spaces eg 2,0,5"}, {"RENDERMODE", "string", "Start mode- currently 'wireframe','hiddenline' or 'texturemapped'"}, {"ROTATE", "boolean", "Start with model rotating either 'true' or 'false'"}, {"YANGLE", "int", "Start with model rotated by this about the vertical angle"}, {"XANGLE", "int", "Start with model rotated by this about the left/right angle"}, {"STARTSKIN", "int", "Start with this skin"}, {"CYCLE", "boolean", "Start with model cycling through frames"}, {"ZOOM", "float", "Zoom level for model- use with care!"}, {"SHIFTY", "int", "Shifts model vertically (use with care!)"}, {"BIMAGE", "String", "NAME of a gif or jpeg to show behind the model"}, {"SCALEBIMAGE", "boolean", "Scale the BIMAGE to fit applet"}, {"EXTRA", "String", "Info passed to the model format class."}, {"NOSTATUS", "boolean", "Suppress statusline messages."}, {"MOUSEOVER", "String", "Text to be displayed when the mouse is over the applet"}};
        return stringArray;
    }

    public void run() {
        this.update(this.getGraphics());
        if (!this.initialised) {
            this.main = new MDLViewMain(this);
        }
        this.main.start();
        this.initialised = true;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (this.haveBImage) {
            if (this.scaleBI) {
                graphics.drawImage(this.bImage, 0, 0, this.w, this.h, this);
                graphics.setColor(this.foregroundColour);
                graphics.drawRect(0, 0, this.w - 1, this.h - 1);
            } else {
                graphics.drawImage(this.bImage, this.ix, this.iy, this);
                graphics.setColor(this.foregroundColour);
                graphics.drawRect(0, 0, this.w - 1, this.h - 1);
            }
        } else {
            graphics.setColor(this.backgroundColour);
            graphics.fillRect(0, 0, this.w, this.h);
            graphics.setColor(this.foregroundColour);
            graphics.drawRect(0, 0, this.w - 1, this.h - 1);
        }
        this.writeMessage(this.statusMessage);
        graphics.setColor(this.backgroundColour);
        graphics.fillRect(this.pcolx, this.pcoty, this.pcorx, this.pcoby);
        graphics.setColor(this.foregroundColour);
        graphics.drawRect(this.pcolx, this.pcoty, this.pcorx, this.pcoby);
        graphics.drawRect(this.pcolx + 2, this.pcoty + 2, this.pcorx - 4, this.pcoby - 4);
        graphics.fillRect(this.pcolx + 2, this.pcoty + 2, this.pcbx, this.pcoby - 4);
    }

    public void writeMessage(String string) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(this.backgroundColour);
        graphics.fillRect(1, 1, this.w - 2, 35);
        graphics.setColor(this.foregroundColour);
        graphics.drawString(this.statusMessage, 10, 30);
    }

    public void showPercentage(int n) {
        if (!this.modelReady) {
            Graphics graphics = this.getGraphics();
            int n2 = this.pcbx;
            this.pcbx = n * (this.pcorx - 4) / 100;
            if (this.pcbx < n2) {
                graphics.setColor(this.backgroundColour);
                graphics.fillRect(this.pcolx + 2, this.pcoty + 2, this.pcorx - 4, this.pcoby - 4);
                graphics.setColor(this.foregroundColour);
                graphics.drawRect(this.pcolx + 2, this.pcoty + 2, this.pcorx - 4, this.pcoby - 4);
            }
            graphics.setColor(this.foregroundColour);
            graphics.fillRect(this.pcolx + 2, this.pcoty + 2, this.pcbx, this.pcoby - 4);
        }
    }

    public void modelReady() {
        this.modelReady = true;
        String string = this.getParameter("MOUSEOVER");
        this.mouseOverText = string != null ? "MDLView: " + string : "MDLView: For help press '?'";
        this.main.modelReady();
    }

    public void showStatus(String string) {
        if (this.DEBUG && !this.modelReady && !string.equals(this.statusMessage)) {
            System.out.println("DBG: " + string);
        }
        if (!this.noOut) {
            super.showStatus(string);
            if (!this.modelReady) {
                this.statusMessage = string;
                this.writeMessage(this.statusMessage);
            }
        }
    }

    public final String getAuthorInfo() {
        return "T.J.Grey (tjg1@ch.ic.ac.uk) Copyright 1998";
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return this.main.mouseDown(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return this.main.mouseDrag(event, n, n2);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.modelReady) {
            this.statusMessage = this.mouseOverText;
        }
        this.showStatus(this.statusMessage);
        return true;
    }

    public boolean keyDown(Event event, int n) {
        return this.main.keyDown(event, n);
    }

    public boolean keyUp(Event event, int n) {
        return this.main.keyUp(event, n);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return this.main.mouseUp(event, n, n2);
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.requestFocus();
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return false;
    }

    public String getExtraParameter() {
        return this.getParameter("EXTRA");
    }

    private Color getColourFromString(String string) {
        if (string == null || string.length() != 7) {
            System.out.println("MDLView: " + string + " not specified or specified incorrectly, using white");
            System.out.println("... usage eg <PARAM NAME=BCOLOUR VALUE=#FF00FF>");
            string = "#FFFFFF";
        }
        Color color = null;
        try {
            String string2 = "0x" + string.substring(1, 3);
            String string3 = "0x" + string.substring(3, 5);
            String string4 = "0x" + string.substring(5, 7);
            int n = Integer.decode(string2);
            int n2 = Integer.decode(string3);
            int n3 = Integer.decode(string4);
            color = new Color(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("MDLView: Error extracting colour, using white");
            color = new Color(255, 255, 255);
        }
        return color;
    }
}

