//-----------------------------------------------------------
//
//-----------------------------------------------------------
class mLaserBeamEffect extends xEmitter;

#exec OBJ LOAD FILE=XEffectMat.utx

var PainterBeamSpot Spot;
var Vector StartEffect, EndEffect;
var Vector EffectOffset;
var LinkMuzFlashBeam3rd MuzFlash;
var float Brightness;

var() Sound MarkSound;
var() Sound AquiredSound;
var() String MarkForce;  // jdf
var() String AmbientForce;  // jdf

replication
{
    unreliable if (Role == ROLE_Authority)
        StartEffect, EndEffect;
}

simulated function PostBeginPlay()
{
 AttachToBone(self, '89DBarrel');
}

simulated function Destroyed()
{
    if (MuzFlash != None)
        MuzFlash.mRegen = false;


    Super.Destroyed();
}

//simulated function BeamTick(float dt)
simulated function BeamTick()
{
    local Vector BeamDir;
    local Vector StartTrace, EndTrace, X,Y,Z;
    local Vector HitLocation, HitNormal;
    local Actor Other;
    local xWeaponAttachment Attachment;
    local Coords boneCoords;

    if (Role == ROLE_Authority && (Instigator == None || Instigator.Controller == None))
    {
        Destroy();
        return;
    }

    if (!MagnumWeapon(Instigator.Weapon).bAllowsLaser)
    {
      return;
    }


    if (Level.NetMode == NM_DedicatedServer)
    {
       StartEffect = Instigator.Location + Instigator.EyeHeight*Vect(0,0,1);
       return;
    }

    if ( Instigator.IsFirstPerson() && Instigator.Weapon != None )
    {
        boneCoords = Instigator.Weapon.GetBoneCoords('89DBarrel');
        StartTrace = boneCoords.Origin;

        X = Vector(Instigator.Weapon.GetBoneRotation('89DBarrel'));

    }
    else
    {
        StartTrace = Instigator.Location + Instigator.EyePosition() + X*Instigator.CollisionRadius;
        X = Vector(Instigator.Controller.Rotation);
    }

    EndTrace = StartTrace + 10000.0 * X;

    Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

    EndEffect = HitLocation;

    // set beam start location
    if ( Instigator == None )
    {
        SetLocation(StartEffect);
    }
    else
    {

        if ( Instigator.IsFirstPerson() && Instigator.Weapon != None )
        {

			if ( Instigator.Weapon.WeaponCentered() )
            {
			   SetLocation( Instigator.Location );
			}
			else
			{
//                Instigator.Weapon.GetViewAxes(X, Y, Z);
       			//SetLocation( (Instigator.Location + Instigator.CalcDrawOffset(Instigator.Weapon) + EffectOffset.X * X + Instigator.Weapon.Hand * EffectOffset.Y * Y + EffectOffset.Z * Z) );
				SetLocation(Instigator.Weapon.GetBoneCoords('89DBarrel').origin );
			}

        }
        else
        {
            Attachment = xPawn(Instigator).WeaponAttachment;
            if (Attachment != None && (Level.TimeSeconds - Attachment.LastRenderTime) < 1)
                SetLocation( Attachment.GetTipLocation() );
            else
                SetLocation( Instigator.Location + Instigator.EyeHeight*Vect(0,0,1) + Normal(EndEffect - Instigator.Location) * 25.0 );
        }
        if (Role == ROLE_Authority) // what clients will use if their instigator is not relevant yet
            StartEffect = Location;
    }

    BeamDir = Normal(EndEffect - Location);
    SetRotation(Rotator(BeamDir));

    mSpawnVecA = EndEffect;

//    Log ("PAY - Beam - Start Eff=("$ StartEffect $") | End Eff=("$ EndEffect $") | pawn = ("$ Instigator.Location $")");
}


simulated function SetBrightness(float b)
{
    Brightness = b;
    mColorRange[0].R = b;
    mColorRange[0].G = b;
    mColorRange[0].B = b;
    mColorRange[1] = mColorRange[0];
}

defaultproperties
{
    RemoteRole=ROLE_SimulatedProxy
    bNetTemporary=false
    bReplicateInstigator=true

    mParticleType=PT_Beam
    mStartParticles=1
    mAttenuate=false
    mSizeRange(0)=1.0 // width
    mRegenDist=100.0 // section length
    mMaxParticles=3 // planes
    mColorRange(0)=(R=100,B=100,G=100)
    mColorRange(1)=(R=100,B=100,G=100)
    mSpinRange(0)=2 // spin
    mAttenKa=1.0

    Skins(0)=Texture'XEffectMat.painter_beam'
    Style=STY_Additive
    bUnlit=true
    EffectOffset=(X=-5,Y=15,Z=-7)

    SoundVolume=112
    SoundRadius=100
}
