class MagnumWeaponFire extends InstantFire;

var float RecoilDuration;  // Time before accuracy returns to normal.
var float LastFireTime;			// Time we last fired the gun (successfully or not)
var float FireDelay;			// Time before we can fire again, override with weapon anims when I get them
var float MaxSpread;			// Maximum inaccuracy of the gun
var float Penetration;     // The size of the wall these guns can go through
var int MaxPenetration;   // The max number of walls we can go through

replication
{
	reliable if (ROLE == ROLE_Authority)
    	LastFireTime;

    reliable if( Role < ROLE_Authority )
        Reload;

}

function InitEffects()
{
    Super.InitEffects();

    // Put the effect on the guns tip... duh.
    if ( FlashEmitter != None )
		Weapon.AttachToBone(FlashEmitter, '89DBarrel');
}

function FlashMuzzleFlash()
{
    local rotator r;

    // Make the flash rotate so it looks different each time
//    r.Roll = Rand(65536);
    r.Yaw = 32768;
    Weapon.SetBoneRotation('89DBarrel', r, 0, 1.f);

    // Draw the flash.
    Super.FlashMuzzleFlash();
}

function ModeDoFire()
{
	AdjustSpread();
	if (MagnumWeapon(Weapon).CurrClipSize != 0 ) // If you still have ammo in the clip.
	{
		MagnumWeapon(Weapon).CurrClipSize--; // Minus one ammo in clip.

 	   if (MaxHoldTime > 0.0)
	        HoldTime = FMin(HoldTime, MaxHoldTime);

	    // server
	    if (Weapon.Role == ROLE_Authority)
	    {
//	        Weapon.ConsumeAmmo(ThisModeNum, Load);
	        DoFireEffect();
	        if ( (Instigator == None) || (Instigator.Controller == None) )
	            return;
	        if ( AIController(Instigator.Controller) != None )
	            AIController(Instigator.Controller).WeaponFireAgain(BotRefireRate, true);
	        Instigator.SpawnTime = -100000;
	    }

	    // client
	    if (Instigator.IsLocallyControlled())
	    {
	        ShakeView();
	        PlayFiring();
	        FlashMuzzleFlash();
	        StartMuzzleSmoke();
	    }
	    else // server
	    {
	        ServerPlayFiring();
	    }

	    Weapon.IncrementFlashCount(ThisModeNum);

	    // set the next firing time. must be careful here so client and server do not get out of sync
	    if (bFireOnRelease)
	    {
	        if (bIsFiring)
	            NextFireTime += MaxHoldTime + FireRate;
	        else
	            NextFireTime = Level.TimeSeconds + FireRate;
	    }
	    else
	    {
	        NextFireTime += FireRate;
	        NextFireTime = FMax(NextFireTime, Level.TimeSeconds);
	    }
	    Load = AmmoPerFire;
	    HoldTime = 0;

	    if (Instigator.PendingWeapon != Weapon && Instigator.PendingWeapon != None)
	    {
	        bIsFiring = false;
	        Weapon.PutDown();
	    }

	}


}

function PlayFiring()
{
    if (FireCount > 0)
    {
        if (Weapon.HasAnim(FireLoopAnim))
        {
            Weapon.PlayAnim(FireLoopAnim, FireLoopAnimRate, 0.0);
        }
        else
        {
            Weapon.PlayAnim(FireAnim, FireAnimRate, TweenTime);
        }
    }
    else
    {
        Weapon.PlayAnim(FireAnim, FireAnimRate, TweenTime);
    }

    //Instigator.PlayOwnedSound(FireSound,SLOT_Interact,TransientSoundVolume,,,,false);
    Weapon.PlayOwnedSound(FireSound,SLOT_Interact,TransientSoundVolume,,,Default.FireAnimRate/FireAnimRate,false);

    ClientPlayForceFeedback(FireForce);  // jdf

    FireCount++;
}

simulated function AdjustSpread()
{
	//////////////////////////
	// Ducked decrement
	//////////////////////////
	if (Instigator.Controller.bDuck == 1)
		Spread = FMax(Spread-0.05, 0.03); // Never get more accurate than .03 - May need to adjust for snipers...

	//////////////////////////
	// Dive Decrement
	//////////////////////////
	// Only give the full dive bonus if we've not got any recoil on the gun
	if (Instigator.Controller.IsInState('Diving') && ( Level.TimeSeconds - LastFireTime > RecoilDuration ))
		Spread = FMax(Spread-0.06, 0.00);
	else if (Instigator.Controller.IsInState('Diving')) // Otherwise reduce the spread a little
		Spread = Default.Spread-0.03;

	//////////////////////
	// Recoil increment
	//////////////////////

	// If we fired after we recovered from the recoil
	if ( Level.TimeSeconds - LastFireTime > RecoilDuration )
		Spread = Default.Spread; // reset the inaccuracy
	else
		Spread = FMin(Spread+0.02,MaxSpread); // increment the inaccuracy up to a range of .12 - make higher?

	if ((MagnumPawn(Instigator)!= None)
           && (MagnumPawn(Instigator).SpecialItem != None)
           && MagnumPawn(Instigator).SpecialItem.IsA('MagnumLaserSight')
           && MagnumPawn(Instigator).SpecialItem.bActive)
           Spread = FMax(Spread-0.06, 0.00);

	LastFireTime = Level.TimeSeconds;

	/////////////////////////////
	// Movement speed increment
	/////////////////////////////

	if (VSize(Instigator.Controller.Velocity) > (Instigator.Default.GroundSpeed / 2) )
		Spread = FMin(Spread+0.02,MaxSpread);	// We're running so add a little more

    Log ("PAY - Spread = "$ Spread);

}

function Reload()
{
	local int chamber;

	// Dont reload if it wont give us more bullets in the gun
	if ( MagnumWeapon(Weapon).CurrClipSize >  MagnumWeapon(Weapon).Default.CurrClipSize)
		return;

	// got any carrots... erm I mean spare clips.
	if ((Weapon.Ammo[ThisModeNum].AmmoAmount) != 0 )
	{
		// Check if there is one in the barrel.
		if ( MagnumWeapon(Weapon).CurrClipSize != 0)
			chamber = 1;
		else
			chamber = 0;

		// Remove a clip
		Weapon.Ammo[0].AmmoAmount--;


		//Set the number of bullets in the gun (including the one in the chamber)
		MagnumWeapon(Weapon).CurrClipSize=MagnumWeapon(Weapon).Default.CurrClipSize + chamber;
		// Debug, show the fact that we reloaded.
		PlayerController(Instigator.Controller).myHUD.Message
		(
			PlayerController(Instigator.Controller).PlayerReplicationInfo,
			"Weapon Reloaded",
			'StringMessagePlus'
		);
	}

}

simulated function bool AllowFire()
{

//   	Log ("PAY - WeaponAmmo "$ Weapon.Ammo[ThisModeNum] $" Ammount "$ CurrClipSize $" time "$ Level.TimeSeconds $" Lastfire "$ LastFireTime);

	  if ( (MagnumWeapon(Weapon).CurrClipSize > 0) &&
	         (Level.TimeSeconds > LastFireTime) &&
              MagnumWeapon(Weapon).bInReload == false )
      {
		if (Instigator.IsA('MagnumPawn'))
        {
            if (!MagnumPawn(Instigator).bBandaging)
		        return true;
            else if (MagnumPawn(Instigator).bBandaging)
            	return false;
            else
            {
            	// play that we have no ammo
	            PlayEmptySound();
    	        return false;
            }

      	}
        else
        	return true;


      }
      else
      {
          return false;
      }

}

simulated function PlayEmptySound()
{
    if( Weapon != none  && (Level.TimeSeconds > LastFireTime) ) {
        Weapon.PlayOwnedSound(
                NoAmmoSound,SLOT_Interact,TransientSoundVolume,,,,false);
        LastFireTime = Level.TimeSeconds + 0.25;
    }
}

function DoTrace(Vector Start, Rotator Dir)
{
    local Vector X, End, HitLocation, HitNormal, RefNormal;
    local Vector FrontHitLoc, BackHitLoc;
    local Actor Other;
    local int Damage;
    local bool bDoReflect;
    local int ReflectNum;
    local float NewTraceRange;
    local int PenetrationAmount;

    NewTraceRange = TraceRange;
    Penetration = Default.Penetration;
    PenetrationAmount = MaxPenetration;

    ReflectNum = 0;
    while (true)
    {
        bDoReflect = false;
        X = Vector(Dir);
        End = Start + NewTraceRange * X;

        Other = Trace(HitLocation, HitNormal, End, Start, true);

        if ( Other != None && (Other != Instigator || ReflectNum > 0) )
        {
            if (bReflective && Other.IsA('xPawn') && xPawn(Other).CheckReflect(HitLocation, RefNormal, DamageMin*0.25))
            {
                bDoReflect = true;
                HitNormal = Vect(0,0,0);
            }
            else if (!Other.bWorldGeometry)
            {
                Damage = (DamageMin + Rand(DamageMax - DamageMin)) * DamageAtten;
                Other.TakeDamage(Damage, Instigator, HitLocation, Momentum*X, DamageType);
                HitNormal = Vect(0,0,0);
            }
            else if ( WeaponAttachment(Weapon.ThirdPersonActor) != None )
				WeaponAttachment(Weapon.ThirdPersonActor).UpdateHit(Other,HitLocation,HitNormal);
        }
        else
        {
            HitLocation = End;
            HitNormal = Vect(0,0,0);
        }

        SpawnBeamEffect(Start, Dir, HitLocation, HitNormal, ReflectNum);

        if (bDoReflect && ++ReflectNum < 4)
        {
            //Log("reflecting off"@Other@Start@HitLocation);
            //if we reflected we aint gonna penetrate
            penetration = 0;
            Start = HitLocation;
            Dir = Rotator(RefNormal); //Rotator( X - 2.0*RefNormal*(X dot RefNormal) );
        }
        else if ((penetration > 0) && (penetrationAmount > 0))
        {
        	   // Trace back in order to get the amount of material penetrated,
        	   // the position on the other side of the wall so we can continue the trace,
        	   // and spawn some wall effects (hopefully)

        	   // Make sure the next trace is shortened by the right amount.
        	   NewTraceRange -= VSize(Start - HitLocation);

        	   // Where we hit the wall/person/whatever
        	   FrontHitLoc = HitLocation;
        	   // We want to trace back to where started from
        	   End = Start;
        	   // from whatever penetration amount we have left
        	   Start = HitLocation + (penetration * X);

        	   // Trace it (and ignore ppl/actors, well get them when we go forward again.)
        	   Other = Trace(HitLocation, HitNormal, End, Start, false);

        	   // Store this off so that I remember we are looking at the size of the wall.
        	   BackHitLoc = HitLocation;

        	   // Drop the penetration + trace range by this much
        	   penetration -= VSize(FrontHitLoc - BackHitLoc);
        	   NewTraceRange -= VSize(FrontHitLoc - BackHitLoc);

        	   penetrationAmount--;

        }
        else
        {
            break;
        }
    }

    // paranoia
    Penetration = Default.Penetration;
}


defaultproperties
{
	AmmoClass=class'MagnumAmmunition'
   	AmmoPerFire=1
    DamageType=class'DamTypeAssaultBullet'
    DamageMin=45
    DamageMax=45
    bPawnRapidFireAnim=false
    bWaitForRelease=true

    penetration=8
    MaxPenetration=1

    FireAnim=Fire
    FireEndAnim=None
    FireLoopAnim=None
    FireAnimRate=1.0

    FlashEmitterClass=class'XEffects.AssaultMuzFlash1st'

    FireSound=Sound'WeaponSounds.AssaultRifle.AssaultRifleFire'
    FireForce="AssaultRifleFire"   // jdf

    Spread=0.020
    SpreadStyle=SS_Random
    PreFireTime=0.0
    FireRate=0.35
    bModeExclusive=true

    BotRefireRate=0.99
    AimError=800

    ShakeOffsetMag=(X=1.0,Y=1.0,Z=1.0)
    ShakeOffsetRate=(X=1000.0,Y=1000.0,Z=1000.0)
    ShakeOffsetTime=2
    ShakeRotMag=(X=50.0,Y=50.0,Z=50.0)
    ShakeRotRate=(X=10000.0,Y=10000.0,Z=10000.0)
    ShakeRotTime=2

   	RecoilDuration=0.5


	FireDelay=0.25
	MaxSpread=0.12

}
