// ====================================================================
//  Class:  MagnumEngine.MagnumWeapon
//  Parent: Engine.Weapon
//
//  <Enter a description here>
// ====================================================================

class MagnumWeapon extends Weapon;

var bool bInReload;
var bool bReloadableWeapon;
var bool bRoundChambered;
var bool bAllowsLaser;
var int CurrClipSize;

var() float WeaponReloadTime;
var() Name ReloadAnim;
var() float ReloadAnimRate;
var() Sound ReloadSound;

var mLaserBeamEffect Beam;  // Laserbeam

replication
{
	reliable if (Role == Role_Authority)
    	bInReload, Reload, CurrClipSize;

//    reliable if( Role < ROLE_Authority )
//        Reload;
}

function Destroyed()
{
    if (Beam != None)
    {
        Log ("PAY - Destroying beam");
        Beam.Destroy();
    }

    Super.Destroyed();
}

//Reload the weapon
simulated function Reload()
{
	if ( CurrClipSize > default.CurrClipSize)
    	return;

    if ( !Ammo[0].HasAmmo() )
    	return;

    bInReload = true;
	Log ("PAY - In reload");
    ConsumeAmmo(0, FireMode[0].AmmoPerFire);

//    PlayOwnedSound(SelectSound, SLOT_Interact,,,,, false);
	PlayReloadAnim();
    ClientPlayForceFeedback(SelectForce);  // jdf

/*     if (Instigator.IsLocallyControlled())
     {
         if (HasAnim(ReloadAnim))
             PlayAnim(ReloadAnim, ReloadAnimRate, 0.0);
     }*/

}

//HEGI CODE
simulated function PlayReloadAnim()
{
	if ( CurrClipSize > default.CurrClipSize)
    	return;

  Log ("PAY - In PlayReloadAnim");

   SetTimer(WeaponReloadTime, false);
   ClientState = WS_PutDown;

   PlayOwnedSound(ReloadSound, SLOT_Interact,,,,, false);
   PlayAnim(ReloadAnim, ReloadAnimRate, 0.0);
}

simulated function Timer()
{
	local int chamber;
    local int Mode;

    Log ("PAY - In Timer");
    chamber = 0;

    if (bInReload)
    {
		bInReload = false;

      	if (CurrClipSize > 0)
   			chamber = 1;

	   	CurrClipSize = default.CurrClipSize + chamber;

        if (MagnumPlayer(Instigator.Controller).bHoldingReload)
        {
           Reload();
           MagnumPlayer(Instigator.Controller).bHoldingReload =  bInReload;

           if (MagnumPlayer(Instigator.Controller).bHoldingReload)
              return;
        }
    }

    if (ClientState == WS_BringUp)
    {
		for( Mode = 0; Mode < NUM_FIRE_MODES; Mode++ )
	       FireMode[Mode].InitEffects();
        PlayIdle();
        ClientState = WS_ReadyToFire;
        MagnumPlayer(Instigator.Controller).DefaultFOV = MagnumPlayer(Instigator.Controller).default.DefaultFOV;
    }
    else if (ClientState == WS_PutDown &&
    		 (MagnumPawn(Instigator) != None) &&
             (!MagnumPawn(Instigator).bBandaging) )
    {
		if ( Instigator.PendingWeapon == None )
		{
			PlayIdle();
			ClientState = WS_ReadyToFire;
		}
		else
		{
			ClientState = WS_Hidden;
			Instigator.ChangedWeapon();
			for( Mode = 0; Mode < NUM_FIRE_MODES; Mode++ )
				FireMode[Mode].DestroyEffects();
		}
    }
    else if ( (MagnumPawn(Instigator) != None) &&
             (MagnumPawn(Instigator).bBandaging) )
    {
	    ClientState = WS_Hidden;
    }
}


simulated function PlayIdle()
{
//	Log ("Pay - Looping Idle");
	if (bInReload)
    	return;

    LoopAnim(IdleAnim, IdleAnimRate, 0.2);
}

simulated function GetAmmoCount(out float MaxAmmoPrimary, out float CurAmmoPrimary)
{
	if ( Ammo[0] == None )
		return;

//	MaxAmmoPrimary = Ammo[0].MaxAmmo;
//	CurAmmoPrimary = Ammo[0].AmmoAmount;

	MaxAmmoPrimary = Ammo[0].AmmoAmount * Default.CurrClipSize ;
	CurAmmoPrimary = CurrClipSize;
}

simulated function GetCurrentClipSize(out float CurAmmoPrimary)
{
	if ( FireMode[0] == None )
		return;

	CurAmmoPrimary = CurrClipSize;
}

simulated function GetClips(out float CurClips)
{
	if ( FireMode[0] == None )
		return;

	CurClips = Ammo[0].AmmoAmount;
}

simulated function bool HasAmmo()
{
    return ( (Ammo[0] != None && FireMode[0] != None && Ammo[0].AmmoAmount >= FireMode[0].AmmoPerFire)
          || (Ammo[1] != None && FireMode[1] != None && Ammo[1].AmmoAmount >= FireMode[1].AmmoPerFire)
          || (CurrClipSize > 0)
          || (bInReload));
}

function bool CanFire()
{
	if (Level.Game.IsInState('RoundStart'))
		return false;

   	if(bInReload)
		return false;

    if (MagnumPlayer(Instigator.Controller).IsInState('Bandaging'))
    	return false;

    if (bInReload)
		return false;

    if (CurrClipSize == 0)
    	return false;


	return true;
}

function ServerReload()
{
}

function bool HandlePickupQuery( pickup Item )
{
    local WeaponPickup wpu;
    local MagnumWeapon wpn;
    local int FullMaxAmmo;

	if (class == Item.InventoryType)
    {


        wpn = MagnumWeapon(Instigator.FindInventoryType(Item.InventoryType));

        Log ("PAY - HandlePickupQuery -O"$ Instigator.Class $" wpn "$ wpn);
        Log ("PAY - Instigator.Class "$ Instigator.Class);
        Log ("PAY - wpn "$ wpn);
        Log ("PAY - Ammo[0].AmmoAmount "$ Ammo[0].AmmoAmount);
//        Log ("PAY - Ammo[1].AmmoAmount "$ Ammo[1].AmmoAmount);

        if ( wpn != None)
        {
           Log ("PAY - got wpn Ammo0 = "$ Ammo[0].AmmoAmount);

      if ((Instigator.IsA('MagnumPawn') &&
          (MagnumPawn(Instigator).SpecialItem != None) &&
          (MagnumPawn(Instigator).SpecialItem.IsA('MagnumBandolier')))
          )
      {
          FullMaxAmmo = Ammo[0].MaxAmmo * 2;
//          FullMaxAmmo2 = Ammo[1].MaxAmmo * 2;
      }
      else
      {
          FullMaxAmmo = Ammo[0].MaxAmmo;
//          FullMaxAmmo1 = Ammo[1].MaxAmmo;
      }


           // They already have this weapon.  See if they need the ammo
//           if ((Ammo[0].AmmoAmount >= FullMaxAmmo1) ||
//               (Ammo[1].AmmoAmount >= FullMaxAmmo2))
               if (Ammo[0].AmmoAmount >= FullMaxAmmo)
               {
                  Log ("PAY - returning true");
                  return true;
               }
        }

        wpu = WeaponPickup(Item);
        if (wpu != None)
        {
            Log ("PAY - wpu allow repeat");
            return !wpu.AllowRepeatPickup();
        }
        else
        {
           Log ("PAY - wpu return false");
            return false;
        }
    }

    if ( Inventory == None )
		return false;

	return Super.HandlePickupQuery(Item);
}

function GiveAmmo(int m, WeaponPickup WP, bool bJustSpawned)
{
    local bool bJustSpawnedAmmo;
    local int addAmount;

    Log ("PAY - In Give ammo");

    if ( FireMode[m] != None && FireMode[m].AmmoClass != None )
    {
        Ammo[m] = Ammunition(Instigator.FindInventoryType(FireMode[m].AmmoClass));
		bJustSpawnedAmmo = false;

        Log ("PAY - AmmoClass = "$FireMode[m].AmmoClass);

        if ( (Ammo[m] == None) && (FireMode[m].AmmoClass != None) )
        {
            Log ("PAY - GiveAmmo 1");
            Ammo[m] = Spawn(FireMode[m].AmmoClass, FireMode[m]);
            Instigator.AddInventory(Ammo[m]);
            bJustSpawnedAmmo = true;
        }
        else if ( (m == 0) || (FireMode[m].AmmoClass != FireMode[0].AmmoClass) )
        {
            Log ("PAY - GiveAmmo 2");
			bJustSpawnedAmmo = ( bJustSpawned || ((WP != None) && !WP.bWeaponStay) );
        }

//        Log ("PAY - WP = "$ WP $" WP.Ammo = "$ WP.AmmoAmount[m]);

        if ( (WP != None) && (WP.AmmoAmount[m] > 0) )
        {
            Log ("PAY - GiveAmmo 3");
            addAmount = Ammo[m].InitialAmount;
        }
        else if ( bJustSpawnedAmmo )
        {
            Log ("PAY - GiveAmmo 4");
//            Log (" self = "$ Instigator );
//            Log (" SI = "$ MagnumPawn(Instigator).SpecialItem);
//            Log (" IsA(Bando) = "$ MagnumPawn(Instigator).SpecialItem.IsA('MagnumBandolier'));

            if ((Instigator.IsA('MagnumPawn')) &&
              (MagnumPawn(Instigator).SpecialItem != None) &&
              (MagnumPawn(Instigator).SpecialItem.IsA('MagnumBandolier'))
              )
              {
                  Log ("PAY - Bando doubled stuff");
                  addAmount = Ammo[m].InitialAmount*2;
              }
              else
              {
                  Log ("PAY - Bando failed :(");
                  addAmount = Ammo[m].InitialAmount;
              }
        }
        else if ( (  (m == 0) || (FireMode[m].AmmoClass != FireMode[0].AmmoClass) )
                 && (Ammo[m] != None) && (Ammo[m].InitialAmount > 0))
        {
             Log ("PAY - GiveAmmo 5");
             addAmount = Ammo[m].InitialAmount;
        }

        Log ("PAY - Add amount = "$ addAmount);
        Ammo[m].AddAmmo(addAmount);
        Ammo[m].GotoState('');
    }
}

simulated function ClientWeaponSet(bool bPossiblySwitch)
{
    local int Mode;

    Log ("PAY - ClientWeaponSet");

    Instigator = Pawn(Owner);

    bPendingSwitch = bPossiblySwitch;

    if( Instigator == None )
    {
        GotoState('PendingClientWeaponSet');
        return;
    }

    for( Mode = 0; Mode < NUM_FIRE_MODES; Mode++ )
    {
        if( FireModeClass[Mode] != None )
        {
            if( ( FireMode[Mode] == None ) || ( FireMode[Mode].AmmoClass != None ) && ( Ammo[Mode] == None ) )
            {
                GotoState('PendingClientWeaponSet');
                return;
            }
        }

        FireMode[Mode].Instigator = Instigator;
    }

    ClientState = WS_Hidden;
    GotoState('Hidden');

    if( Level.NetMode == NM_DedicatedServer || !Instigator.IsHumanControlled() )
        return;

    if( Instigator.Weapon == self || Instigator.PendingWeapon == self ) // this weapon was switched to while waiting for replication, switch to it now
    {
        if (Instigator.PendingWeapon != None)
            Instigator.ChangedWeapon();					// Dont need to check if they are a bot, so use the state
        else if (!MagnumPawn(Instigator).bBandaging) // If we are bandaging we'll pop the weapon up when we are done
        {
        	log ("PAY - Bringing up");
            BringUp();
        }
        return;
    }

    if( Instigator.PendingWeapon != None && Instigator.PendingWeapon.bForceSwitch )
        return;

    if( Instigator.Weapon == None )
    {
        Instigator.PendingWeapon = self;
        Instigator.ChangedWeapon();
    }
    else if ( bPossiblySwitch )
    {
		if ( PlayerController(Instigator.Controller) != None && PlayerController(Instigator.Controller).bNeverSwitchOnPickup )
			return;
        if ( Instigator.PendingWeapon != None )
        {
            if ( RateSelf() > Instigator.PendingWeapon.RateSelf() )
            {
                Instigator.PendingWeapon = self;
                Instigator.Weapon.PutDown();
            }
        }
        else if ( RateSelf() > Instigator.Weapon.RateSelf() )
        {
            Instigator.PendingWeapon = self;
            Instigator.Weapon.PutDown();
        }
    }
}

function DropFrom(vector StartLocation)
{
    local int m;
	local Pickup Pickup;

// Not important till I create kungfu
//    if (!bCanThrow || !HasAmmo())
//        return;

    ClientWeaponThrown();

    for (m = 0; m < NUM_FIRE_MODES; m++)
    {
        if (FireMode[m].bIsFiring)
            StopFire(m);
    }

    Log ("PAY - Dropping "$ Self);

	if ( Instigator != None )
	{
		DetachFromPawn(Instigator);
	}

	Pickup = Spawn(PickupClass,,, StartLocation);
	if ( Pickup != None )
	{
    	Pickup.InitDroppedPickupFor(self);
	    Pickup.Velocity = Velocity;
        if (Instigator.Health > 0)
            WeaponPickup(Pickup).bThrown = true;
    }

    Destroy();
}

simulated event WeaponTick(float dt)
{
   If (Beam != None)
      beam.BeamTick();
}


simulated function BringUp(optional Weapon PrevWeapon)
{
     if (Role == ROLE_Authority)
     {
       Log ("PAY - bal = "$ bAllowsLaser $" si = "$ MagnumPawn(Instigator).SpecialItem $" active = "$MagnumPawn(Instigator).SpecialItem.bActive);

       if ((Beam == None) && bAllowsLaser
          && (MagnumPawn(Instigator).SpecialItem != None)
           && MagnumPawn(Instigator).SpecialItem.IsA('MagnumLaserSight')
           && MagnumPawn(Instigator).SpecialItem.bActive
           )
       {
          Log ("PAY - Spawning beam");
          Beam = Spawn(class'mLaserBeamEffect');
       }
    }
    Super.BringUp(PrevWeapon);
}





simulated function bool PutDown()
{
    local int Mode;

    if (ClientState == WS_BringUp || ClientState == WS_ReadyToFire)
    {

        if (Instigator.PendingWeapon != None)
        {
          if (!Instigator.PendingWeapon.bForceSwitch)
          {
              for (Mode = 0; Mode < NUM_FIRE_MODES; Mode++)
              {
                  if (FireMode[Mode].bFireOnRelease && FireMode[Mode].bIsFiring)
                      return false;
              }
          }
        }

        if (Instigator.IsLocallyControlled())
        {
            for (Mode = 0; Mode < NUM_FIRE_MODES; Mode++)
            {
                if (FireMode[Mode].bIsFiring)
                    ClientStopFire(Mode);
            }

            if (ClientState != WS_BringUp && HasAnim(PutDownAnim))
                PlayAnim(PutDownAnim, PutDownAnimRate, 0.0);
        }
        ClientState = WS_PutDown;

        SetTimer(0.3, false);
    }

    for (Mode = 0; Mode < NUM_FIRE_MODES; Mode++)
    {
		FireMode[Mode].bServerDelayStartFire = false;
		FireMode[Mode].bServerDelayStopFire = false;
	}
    Instigator.AmbientSound = None;

    if (Beam != None)
    {
        Log ("PAY - Destroying beam in put down");
        Beam.Destroy();
    }


    return true; // return false if preventing weapon switch
}

simulated function Tick(float dt)
{
}

defaultproperties
{
	bInReload=false
	bRoundChambered=false
    bReloadableWeapon=true
    WeaponReloadTime=0.5
    CurrClipSize=1
    bAllowsLaser=false
}
