//-----------------------------------------------------------
//
//-----------------------------------------------------------
class MagnumSniperRifle extends MagnumWeapon;

#EXEC OBJ LOAD FILE=Ruger89.ukx
#EXEC OBJ LOAD FILE=Ruger.utx

#EXEC OBJ LOAD FILE=InterfaceContent.utx
#exec OBJ LOAD FILE=XGameShaders.utx

var() bool zoomed;

simulated function Timer()
{
	local int chamber;
    local int Mode;

    if (bInReload)
    {
		 zoomlevel = 0;
		 MagnumPlayer(Instigator.Controller).DefaultFOV = MagnumPlayer(Instigator.Controller).default.DefaultFOV;

    }

    if (ClientState == WS_BringUp)
    {
		for( Mode = 0; Mode < NUM_FIRE_MODES; Mode++ )
	       FireMode[Mode].InitEffects();
        PlayIdle();
        ClientState = WS_ReadyToFire;        
    }
    else if (ClientState == WS_PutDown &&
    		 (MagnumPawn(Instigator) != None) &&
             (!MagnumPawn(Instigator).bBandaging) )
    {
		if ( Instigator.PendingWeapon == None )
		{
			PlayIdle();
			ClientState = WS_ReadyToFire;
		}
		else
		{
			ClientState = WS_Hidden;
			Instigator.ChangedWeapon();
			for( Mode = 0; Mode < NUM_FIRE_MODES; Mode++ )
				FireMode[Mode].DestroyEffects();
		}
		
		zoomlevel = 0;
		MagnumPlayer(Instigator.Controller).DefaultFOV = MagnumPlayer(Instigator.Controller).default.DefaultFOV;
    }
    else if ( (MagnumPawn(Instigator) != None) &&
             (MagnumPawn(Instigator).bBandaging) )
    {
	    ClientState = WS_Hidden;
    }
    
    super.timer();
}  

// compensate for bright fog
simulated function SetZoomBlendColor(Canvas c)
{
    local Byte    val;
    local Color   clr;
    local Color   fog;

    clr.R = 255;
    clr.G = 255;
    clr.B = 255;
    clr.A = 255;

    if( Instigator.Region.Zone.bDistanceFog )
    {
        fog = Instigator.Region.Zone.DistanceFogColor;
        val = 0;
        val = Max( val, fog.R);
        val = Max( val, fog.G);
        val = Max( val, fog.B);

        if( val > 128 )
        {
            val -= 128;
            clr.R -= val;
            clr.G -= val;
            clr.B -= val;
        }
    }
    c.DrawColor = clr;
}

simulated event RenderOverlays( Canvas Canvas )
{
	local float tileScaleX;
	local float tileScaleY;
	local float bX;
	local float bY;
	local float fX;
	local float fY;
	local float charge;

	local float tX;
	local float tY;

	local float barOrgX;
	local float barOrgY;
	local float barSizeX;
	local float barSizeY;

	if ( PlayerController(Instigator.Controller) == None )
	{
        Super.RenderOverlays(Canvas);
		zoomed=false;
		return;
	}
		
    if ( LastFOV > PlayerController(Instigator.Controller).DesiredFOV )
    {
        PlaySound(Sound'WeaponSounds.LightningGun.LightningZoomIn', SLOT_Misc,,,,,false);
    }
    else if ( LastFOV < PlayerController(Instigator.Controller).DesiredFOV )
    {
        PlaySound(Sound'WeaponSounds.LightningGun.LightningZoomOut', SLOT_Misc,,,,,false);
    }
    LastFOV = PlayerController(Instigator.Controller).DesiredFOV;

    if (PlayerController(Instigator.Controller).DesiredFOV == PlayerController(Instigator.Controller).DefaultFOV)
	{
        Super.RenderOverlays(Canvas);
		zoomed=false;
	}
	else
    {

		tileScaleX = Canvas.SizeX / 640.0f;
		tileScaleY = Canvas.SizeY / 480.0f;

		bX = borderX * tileScaleX;
		bY = borderY * tileScaleY;
		fX = focusX * tileScaleX;
		fY = focusY * tileScaleX;

		tX = testX * tileScaleX;
		tY = testY * tileScaleX;

		barOrgX = RechargeOrigin.X * tileScaleX;
		barOrgY = RechargeOrigin.Y * tileScaleY;

		barSizeX = RechargeSize.X * tileScaleX;
		barSizeY = RechargeSize.Y * tileScaleY;

        SetZoomBlendColor(Canvas);

        Canvas.Style = 255;
		Canvas.SetPos(0,0);
        Canvas.DrawTile( Material'ZoomFB', Canvas.SizeX, Canvas.SizeY, 0.0, 0.0, 512, 512 ); // !! hardcoded size

/*		Canvas.DrawColor = FocusColor;
        Canvas.DrawColor.A = 255; // 255 was the original -asp. WTF??!?!?!
		Canvas.Style = ERenderStyle.STY_Alpha;

		Canvas.SetPos((Canvas.SizeX*0.5)-fX,(Canvas.SizeY*0.5)-fY);
		Canvas.DrawTile( Texture'SniperFocus', fX*2.0, fY*2.0, 0.0, 0.0, Texture'SniperFocus'.USize, Texture'SniperFocus'.VSize );

        fX = innerArrowsX * tileScaleX;
		fY = innerArrowsY * tileScaleY;

        Canvas.DrawColor = ArrowColor;
        Canvas.SetPos((Canvas.SizeX*0.5)-fX,(Canvas.SizeY*0.5)-fY);
		Canvas.DrawTile( Texture'SniperArrows', fX*2.0, fY*2.0, 0.0, 0.0, Texture'SniperArrows'.USize, Texture'SniperArrows'.VSize );*/

		zoomed = true;
	}
}

defaultproperties
{
	ItemName="Sniper Rifle"
    // animation //
    IdleAnim=Idle
    RestAnim=Idle
    AimAnim=Idle
    RunAnim=Idle
    SelectAnim=Draw
    PutDownAnim=Down
    ReloadAnim=Reload

    IdleAnimRate=1.0
    RestAnimRate=1.0
    AimAnimRate=1.0
    RunAnimRate=1.0
    SelectAnimRate=1.5
    PutDownAnimRate=1.5
    ReloadAnimRate=1.0

    PlayerViewOffset=(X=-35,Y=-8,Z=0)
    PlayerViewPivot=(Pitch=0,Roll=0,Yaw=49302)
    EffectOffset=(X=200.0,Y=200.0,Z=20000.0)

    InventoryGroup=6

    PickupClass=class'MagnumSniperRiflePickup'
    AttachmentClass=class'MagnumSniperRifleAttachment'

    // Objects for each weapons firing
    FireModeClass(0)=MagnumSniperRifleFire
    FireModeClass(1)=MagnumSniperRifleToggle
//	FireModeClass(0)=AssaultFire
//    FireModeClass(1)=AssaultFire
	Mesh=mesh'Ruger89.Ruger89D'
//    Mesh=mesh'Weapons.ShockRifle_1st'

    CurrClipSize=6
}
