// ====================================================================
//  Class:  "MagnumEngine.MagnumPlayer
//
//  <Enter a description here>
// ====================================================================

class MagnumPlayer extends xPlayer;

var String EquipList;
var bool bHoldingReload;

enum EStuntDir
{
	SD_None,
	SD_Left,
	SD_Right,
	SD_Forward,
	SD_Backward,
	SD_Prone,
	SD_Getup,
	SD_GetupBack,
	SD_GetupLeft,
	SD_GetupRight
};
var EStuntDir CurrentStuntDir;
var bool bInDive;
var bool bToProne;
var float SlideSpeed;
var vector SlideVelocity;
var bool bHasInteraction;


replication
{
    reliable if ( Role < ROLE_Authority )
		ServerBandage, ServerChangeEquipment, ServerStunt, bHoldingReload;

    reliable if(Role == ROLE_Authority)
		bInDive, bToProne, EquipList;
}

// Player movement.
// Player Standing, walking, running, falling.

auto state PlayerWaiting
{
    exec function Fire( optional float F )
    {
    	Log ("PAY - Playerwaiting state fire");

        if (EquipList == "")
        {
           ClientOpenMenu("MagnumInterface.MagnumChangeEquipmentMenu");
        }
        else
        {
           LoadPlayers();
           ServerReStartPlayer();
        }
    }

    function BeginState()
    {
        if ( PlayerReplicationInfo != None )
            PlayerReplicationInfo.SetWaitingPlayer(true);

        bCollideWorld = true;
    }

Begin:
    If ((Viewport(Player) != None) && (!bHasInteraction))
    {
        Player.InteractionMaster.AddInteraction("MagnumInterface.mInterfaceInteraction", Player);
        bHasInteraction = True;
    }
}

///////////////////////////////////////
// Dead state, modified to allow     //
// person to stay dead during rounds //
///////////////////////////////////////

state Dead
{
ignores SeePlayer, HearNoise, KilledBy, SwitchWeapon, NextWeapon, PrevWeapon;

	function bool IsDead()
	{
		return true;
	}

	function ServerReStartPlayer()
	{
    	Log ("Pay in Dead serverrestartplayer");
		Super.ServerRestartPlayer();
	}

    exec function Fire( optional float F )
    {
    	Log ("PAY - Playerwaiting state fire");

        if (EquipList == "")
        {
           ClientOpenMenu("MagnumInterface.MagnumChangeEquipmentMenu");
        }
        else
        {
           ServerReStartPlayer();
        }
    }

    exec function AltFire( optional float F )
    {
         Fire(F);
    }

    function ServerMove
    (
        float TimeStamp,
        vector Accel,
        vector ClientLoc,
        bool NewbRun,
        bool NewbDuck,
        bool NewbJumpStatus,
        bool NewbDoubleJump,
        eDoubleClickDir DoubleClickMove,
        byte ClientRoll,
        int View,
        optional byte OldTimeDelta,
        optional int OldAccel
    )
    {
        Global.ServerMove(
                    TimeStamp,
                    Accel,
                    ClientLoc,
                    false,
                    false,
                    false,
                    false,
                    DoubleClickMove,
                    ClientRoll,
                    View);
    }

    function PlayerMove(float DeltaTime)
    {
        local vector X,Y,Z;
        local rotator ViewRotation;

        if ( !bFrozen )
        {
            if ( bPressedJump )
            {
                Fire(0);
                bPressedJump = false;
            }
            GetAxes(Rotation,X,Y,Z);
            // Update view rotation.
            ViewRotation = Rotation;
            ViewRotation.Yaw += 32.0 * DeltaTime * aTurn;
            ViewRotation.Pitch += 32.0 * DeltaTime * aLookUp;
            ViewRotation.Pitch = LimitPitch(ViewRotation.Pitch); //amb
            SetRotation(ViewRotation);
            if ( Role < ROLE_Authority ) // then save this move and replicate it
                ReplicateMove(DeltaTime, vect(0,0,0), DCLICK_None, rot(0,0,0));
        }
        else if ( (TimerRate <= 0.0) || (TimerRate > 1.0) )
			bFrozen = false;

        ViewShake(DeltaTime);
        ViewFlash(DeltaTime);
    }

    function FindGoodView()
    {
        local vector cameraLoc;
        local rotator cameraRot, ViewRotation;
        local int tries, besttry;
        local float bestdist, newdist;
        local int startYaw;
        local actor ViewActor;

        ////log("Find good death scene view");
        ViewRotation = Rotation;
        ViewRotation.Pitch = 56000;
        tries = 0;
        besttry = 0;
        bestdist = 0.0;
        startYaw = ViewRotation.Yaw;

        for (tries=0; tries<16; tries++)
        {
            cameraLoc = ViewTarget.Location;
			SetRotation(ViewRotation);
            PlayerCalcView(ViewActor, cameraLoc, cameraRot);
            newdist = VSize(cameraLoc - ViewTarget.Location);
            if (newdist > bestdist)
            {
                bestdist = newdist;
                besttry = tries;
            }
            ViewRotation.Yaw += 4096;
        }

        ViewRotation.Yaw = startYaw + besttry * 4096;
        SetRotation(ViewRotation);
    }

    function Timer()
    {
        if (!bFrozen)
            return;

        bFrozen = false;
        bPressedJump = false;
    }

    function BeginState()
    {
		if ( (Pawn != None) && (Pawn.Controller == self) )
			Pawn.Controller = None;
		EndZoom();
		FOVAngle = DesiredFOV;
		Pawn = None;
        Enemy = None;
        bBehindView = true;
        bFrozen = true;
		bJumpStatus = false;
        bPressedJump = false;
        bBlockCloseCamera = true;
		bValidBehindCamera = false;
        FindGoodView();
        SetTimer(1.0, false);
		StopForceFeedback();
		ClientPlayForceFeedback("Damage");  // jdf
		CleanOutSavedMoves();
    }

    function EndState()
    {
		bBlockCloseCamera = false;
		CleanOutSavedMoves();
        Velocity = vect(0,0,0);
        Acceleration = vect(0,0,0);
		bBehindView = false;
        bPressedJump = false;
		myHUD.bShowScoreBoard = false;
    }
Begin:
    Sleep(3.0);
    myHUD.bShowScoreBoard = true;
}

function ServerReStartPlayer()
{
	Log ("PAY - In Player ServerRestartPlayer");

    if ( Level.NetMode == NM_Client )
        return;

    if (CanRestartPlayer())
       Level.Game.RestartPlayer(self);


}


// Player movement.
// Player Standing, walking, running, falling.
state PlayerWalking
{
ignores SeePlayer, HearNoise;

	function ProcessMove(float DeltaTime, vector NewAccel, eDoubleClickDir DoubleClickMove, rotator DeltaRot)
	{
        Super.ProcessMove(DeltaTime,NewAccel,DoubleClickMove,DeltaRot);

        MagnumPawn(Pawn).LongTermDamage();
	}

    function PlayerMove ( float DeltaTime )
    {
    	local bool bTwoKeys;

        Super.PlayerMove(DeltaTime);
        bTwoKeys = false;

        CurrentStuntDir = SD_None;

        // Stunt Dir
        if(aForward > 0)
            CurrentStuntDir = SD_Forward;
        if(aForward < 0)
            CurrentStuntDir = SD_Backward;
        if(aStrafe > 0)
            CurrentStuntDir = SD_Right;
        if(aStrafe < 0)
            CurrentStuntDir = SD_Left;

        // Check to make sure we arent holding more than one button :o
        if(aForward > 0 || aForward < 0)
        {
    		bTwoKeys = true;
            if(aStrafe > 0 || aStrafe < 0)
                if(bTwoKeys)
                    CurrentStuntDir = SD_None;
        }
        else if(aStrafe > 0 || aStrafe < 0)
        {
            bTwoKeys = true;
            if(aForward < 0 || aForward > 0)
                if(bTwoKeys)
                    CurrentStuntDir = SD_None;
        }
    }
}

function NotifyTakeHit(pawn InstigatedBy, vector HitLocation, int Damage, class<DamageType> damageType, vector Momentum)
{
	local int iDam;

	Super.NotifyTakeHit(InstigatedBy,HitLocation,Damage,DamageType,Momentum);

	if ( (Pawn != None) && (Pawn.ShieldStrength > 0) )
		ClientFlash(0.5,vect(700,700,0));
	else if ( Damage > 1 )
		ClientFlash(DamageType.Default.FlashScale,DamageType.Default.FlashFog);

	DamageShake(Damage);
	iDam = Clamp(Damage,0,250);
	if ( (Level.NetMode == NM_DedicatedServer) || (Level.NetMode == NM_ListenServer) )
		ClientPlayTakeHit(hitLocation - Pawn.Location, iDam, damageType);
}



/*function ResetPlayer()
{
	Log ("Pay in Magnum RestartPlayer");

	MagnumPawn(Pawn).BleedTime = 0.0;
    MagnumPawn(Pawn).bBleeding = false;
    MagnumPawn(Pawn).bLegDamage = false;
    MagnumPawn(Pawn).LastAttacker = None;
    ClearWounds();

}*/

function HandleWalking()
{
    if ( Pawn != None )
        Pawn.SetWalking( ((bRun != 0) && !Region.Zone.IsA('WarpZoneInfo')) || IsInState('PlayerBandage') || (MagnumPawn(Pawn).bLegDamage) );
}

///////////////
// Bandaging
///////////////

exec function Bandage()
{
	Log ("PAY - Called bandage");
	if(IsInState('PlayerBandage') || (!MagnumPawn(Pawn).bBleeding && !MagnumPawn(Pawn).bLegDamage))
		return;

    Log ("PAY - Going to state");
	GotoState('PlayerBandage');
	ServerBandage();
}

function ServerBandage()
{
	Log ("Pay - ServerBandage");
	GotoState('PlayerBandage');
	Bandaging();
}

function Bandaging()
{
	Log ("PAY - WTS?");
}
function EndBandage(){}
function ClientEndBandage(){}

// Turn off all wound damage
function ClearWounds()
{
	local int i;

	for (i = 0; i < 7; i++)
	{
		MagnumPawn(Pawn).BleedLocations[i] = 1;
	}
}


state PlayerBandage extends PlayerWalking
{
//ignores SeePlayer, HearNoise, Bump;
	function Bandaging()
	{
	    Log ("Pay - Bandaging");
        // Otherwise we cant shoot anymore
		MagnumPawn(Pawn).bInReload = false;
        MagnumPawn(Pawn).bBandaging = true;

        Pawn.Weapon.PutDown();

        if (!Pawn.bIsWalking)
        {
	        Log ("Pay - Setting walking");
			MagnumPawn(Pawn).SetWalking(true);
        }


        if (!MagnumPawn(Pawn).bLegDamage)
        {
			MagnumPawn(Pawn).GroundSpeed = MagnumPawn(Pawn).Default.GroundSpeed * 0.5;
            Log ("Pay - bld="$ MagnumPawn(Pawn).bLegDamage $" State = "$ GetStateName());
        }
	}
	function EndBandage()
	{
    	Log ("Pay - ending bandage");
        Log ("Pay - EndBandage bld="$ MagnumPawn(Pawn).bLegDamage $" State = "$ GetStateName());
		MagnumPawn(Pawn).GroundSpeed = MagnumPawn(Pawn).Default.GroundSpeed;
        MagnumPawn(Pawn).SetWalking(true);
        MagnumPawn(Pawn).bBandaging = false;

        MagnumPawn(Pawn).LastAttacker = None;

        Log ("PAY - end bandage bringingup");
        Pawn.Weapon.BringUp();
		if(Role == ROLE_Authority)
			GotoState('PlayerWalking');


	}
	simulated function ClientEndBandage()
	{
	    Log ("Pay - client end bandage");
		if(Role < ROLE_Authority)
			GotoState('PlayerWalking');
	}
Begin:
	Bandaging();
	Sleep(2.5);
	MagnumPawn(Pawn).bBleeding = false;
	MagnumPawn(Pawn).blegdamage = false;
    Log ("Pay - PlayerBandage (main) bld="$ MagnumPawn(Pawn).bLegDamage );
    MagnumPawn(Pawn).GroundSpeed = MagnumPawn(Pawn).Default.GroundSpeed * 0.70;
    Sleep(2.5);
	EndBandage();
	ClientEndBandage();
}

///////////////////////
// End bandage code  //
///////////////////////

//////////////////////////
// Stunt  code          //
// Modded from AUT code //
//////////////////////////

//
// Dive initialization - Client calls initializer, and server calls function as well. Server
// disregards CurrentStuntDir, instead relying on the clients stunt copy since their more likely to be right.
//
exec function Stunt()	// Client Side
{
	Log ("Pay - In Stunt - bInDive = "$ bInDive $" State = "$ GetStateName());

	// Get up from prone if we must
	if(bInDive && IsInState('PlayerProne'))
	{
		GotoState('PlayerGetUp');
		ServerStunt(SD_Getup);
		return;
	}
	else if(bInDive && IsInState('PlayerProneBack'))
	{
		GotoState('PlayerBackGetUp');
		ServerStunt(SD_GetupBack);
		return;
	}
    else if (bInDive && IsInState('PlayerProneLeft'))
    {
   		GotoState('PlayerBackGetUp');
		ServerStunt(SD_GetupLeft);
		return;
    }
    else if (bInDive && IsInState('PlayerProneRight'))
    {
    	GotoState('PlayerBackGetUp');
		ServerStunt(SD_GetupRight);
		return;
    }

    if (MagnumPawn(Pawn).Stamina < 30)
       return;

    Log ("PAY - CurrentStuntDir =" $ CurrentStuntDir );

	if(CurrentStuntDir == SD_None)
		return;

    log ("PAY - stunt 1");

	// Dont stunt if we have a vertical
	// velocity OR if we are currently in a stunt
	if(bInDive || Pawn.Velocity.Z != 0)
		return;

	log ("PAY - stunt 2");

	switch(CurrentStuntDir)
	{
	case SD_Forward:
		GotoState('PlayerDiveForward');
		ServerStunt(CurrentStuntDir);
		break;
	case SD_Backward:
		GotoState('PlayerDiveBackward');
		ServerStunt(CurrentStuntDir);
		break;
	case SD_Left:
		GotoState('PlayerDiveLeft');
		ServerStunt(CurrentStuntDir);
		break;
	case SD_Right:
		GotoState('PlayerDiveRight');
		ServerStunt(CurrentStuntDir);
		break;
	case SD_Prone:
		GotoState('PlayerProne');
		ServerStunt(CurrentStuntDir);
		break;
	case SD_Getup:
		GotoState('PlayerGetUp');
		ServerStunt(CurrentStuntDir);
		break;
	}
}

// Server version of stunt
function ServerStunt(EStuntDir Dir)
{

	Log ("Pay - In ServerStunt");
	bInDive = true;

	switch(Dir)
	{
	case SD_Forward:
    	Log("Pay - Going to state DiveForward");
		GotoState('PlayerDiveForward');
		break;
	case SD_Backward:
    	Log("Pay - Going to state DiveBackward");
		GotoState('PlayerDiveBackward');
		break;
	case SD_Left:
    	Log("Pay - Going to state DiveLeft");
		GotoState('PlayerDiveLeft');
		break;
	case SD_Right:
    	Log("Pay - Going to state DiveRight");
		GotoState('PlayerDiveRight');
		break;
	case SD_Prone:
    	Log("Pay - Going to state Prone");
		GotoState('PlayerProne');
		break;
	case SD_Getup:
    	Log("Pay - Going to state GetUp");
		GotoState('PlayerGetUp');
		break;
	case SD_GetupBack:
    	Log("Pay - Going to state BackGetUp");
		GotoState('PlayerBackGetUp');
		break;
    case SD_GetupLeft:
    	Log("Pay - Going to state LeftGetUp");
		GotoState('PlayerLeftGetUp');
		break;
    case SD_GetupRight:
    	Log("Pay - Going to state RightGetUp");
		GotoState('PlayerRightGetUp');
		break;

	}
}

//
// Dive states
//
state PlayerDive extends PlayerWalking	// Just placeholdin ;o
{
	exec function FeignDeath() {}
	function ServerFeignDeath() {}
	function AnimEnd(int Channel){}

	function BeginState()
	{
//		if ( Mesh == None )
//			SetMesh();
//		WalkBob = vect(0,0,0);
//		DoubleClickMove = DCLICK_None;
//		bIsCrouching = false;
//		bIsTurning = false;
//		bPressedJump = false;
		if (Physics != PHYS_Falling) SetPhysics(PHYS_Walking);

		MagnumPawn(pawn).GotoState('PawnDiving');

	//	if ( !IsAnimating() )
	//		PlayWaiting();
	}

    function EndState()
    {
        MagnumPawn(Pawn).GotoState('None');
    }

	// Anims
	function PlayDuck(){}
	function PlayTurning(){}
	function PlayCrawling(){}
	function PlayLanded(float impactVel){}
	function TweenToFighter(float tweentime){}
	function TweenToRunning(float tweentime){}
	function TweenToWalking(float tweentime){}
	function TweenToPatrolStop(float tweentime){}
	function TweenToWaiting(float tweentime){}

	// other stuff
	exec function Bandage(){}
}

state PlayerDiveForward extends PlayerDive
{
    function bool NotifyLanded(vector HitNormal)
    {
        if ( Pawn.PhysicsVolume.bWaterVolume )
            Pawn.SetPhysics(PHYS_Swimming);
        else
        {
		    if(Role == ROLE_Authority)
			    bToProne = true;
		}
        return true;
    }

	function BeginState()
	{
		local vector X,Y,Z;
		local float VelocityZ;

		GetAxes(Pawn.Rotation,X,Y,Z);

        VelocityZ = Pawn.Velocity.Z;
        // Strangley, using the same math as the dodge feels good. I was expecting to need more thrust.
        Pawn.Velocity = Pawn.DodgeSpeedFactor*Pawn.GroundSpeed*X + (Velocity Dot Y)*Y;


        Pawn.Velocity.Z = VelocityZ + Pawn.DodgeSpeedZ;
        SlideVelocity = Pawn.Velocity;
        SlideVelocity.z = 0;

        SetCollisionSize(Pawn.Default.CollisionRadius/2,Pawn.Default.CollisionHeight/2);
        Pawn.SetPhysics(PHYS_Falling);

        if (MagnumPawn(Pawn) != none)
                MagnumPawn(Pawn).stamina -= 30;

		super.BeginState();
	}

	function PlayerMove( float DeltaTime )
	{
		aForward = 0;
		aStrafe  = 0;

    	// slide on Ground
		if(Pawn.Velocity.Z == 0)
		{
            // Set eye height here so it can blend as we fall

      	    Pawn.BaseEyeHeight = FMin(1.2 * Pawn.CrouchHeight, Pawn.CrouchHeight - 65);
            Log ("PAY - BaseEyeHeight = "$ Pawn.BaseEyeHeight);

			Log ("PAY - F SlideVelocity = "$ SlideVelocity $" aForward = "$ aForward );
			Pawn.Velocity = SlideVelocity;

			if (aForward > 50)
				SlideVelocity *= 0.99;
			else
				SlideVelocity *= 0.93;

			if (VSize(SlideVelocity) < 50)
				GotoState('PlayerProne');
		}

		// Go to prone if on ground
		if(bToProne && Pawn.Velocity.X == 0)
			GotoState('PlayerProne');

		Super.PlayerMove(DeltaTime);
	}
}

state PlayerDiveBackward extends PlayerDive
{
    function bool NotifyLanded(vector HitNormal)
    {
        if ( Pawn.PhysicsVolume.bWaterVolume )
            Pawn.SetPhysics(PHYS_Swimming);
        else
        {
		    if(Role == ROLE_Authority)
			    bToProne = true;
		}
        return true;
    }

    function BeginState()
	{
		local vector X,Y,Z;
		local float VelocityZ;

		GetAxes(Pawn.Rotation,X,Y,Z);

        VelocityZ = Pawn.Velocity.Z;
        // Strangley, using the same math as the dodge feels good. I was expecting to need more thrust.
        Pawn.Velocity = -Pawn.DodgeSpeedFactor*Pawn.GroundSpeed*X + (Velocity Dot Y)*Y;


        Pawn.Velocity.Z = VelocityZ + Pawn.DodgeSpeedZ;
        SlideVelocity = Pawn.Velocity;
        SlideVelocity.z = 0;

        SetCollisionSize(Pawn.Default.CollisionRadius/2,Pawn.Default.CollisionHeight/2);
        Pawn.SetPhysics(PHYS_Falling);

        if (MagnumPawn(Pawn) != none)
                MagnumPawn(Pawn).stamina -= 30;

		super.BeginState();
	}

	function PlayerMove(float DeltaTime)
	{
		aForward = 0;
		aStrafe  = 0;

		// slide on Ground
		if(Pawn.Velocity.Z == 0)
		{
            // Set eye height here so it can blend as we fall

      	    Pawn.BaseEyeHeight = FMin(1.2 * Pawn.CrouchHeight, Pawn.CrouchHeight - 65);
            Log ("PAY - BaseEyeHeight = "$ Pawn.BaseEyeHeight);

			Log ("PAY - BSlideVelocity = "$ SlideVelocity $" aForward = "$ aForward );
			Pawn.Velocity = SlideVelocity;

			if (aForward > 50)
				SlideVelocity *= 0.99;
			else
				SlideVelocity *= 0.93;

			if (VSize(SlideVelocity) < 50)
				GotoState('PlayerProneBack');
		}

		// Go to prone if on ground
		if(bToProne && Pawn.Velocity.X == 0)
			GotoState('PlayerProneBack');

		Super.PlayerMove(DeltaTime);
	}
}


state PlayerDiveLeft extends PlayerDive
{
   function bool NotifyLanded(vector HitNormal)
    {
        if ( Pawn.PhysicsVolume.bWaterVolume )
            Pawn.SetPhysics(PHYS_Swimming);
        else
        {
		    if(Role == ROLE_Authority)
			    bToProne = true;
		}
        return true;
    }

    function BeginState()
	{
		local vector X,Y,Z;
		local float VelocityZ;

		GetAxes(Pawn.Rotation,X,Y,Z);

        VelocityZ = Pawn.Velocity.Z;
        // Strangley, using the same math as the dodge feels good. I was expecting to need more thrust.
        Pawn.Velocity = -Pawn.DodgeSpeedFactor*Pawn.GroundSpeed*Y + (Velocity Dot X)*X;

        Pawn.Velocity.Z = VelocityZ + Pawn.DodgeSpeedZ;
        SlideVelocity = Pawn.Velocity;
        SlideVelocity.z = 0;

        SetCollisionSize(Pawn.Default.CollisionRadius/2,Pawn.Default.CollisionHeight/2);
        Pawn.SetPhysics(PHYS_Falling);

        if (MagnumPawn(Pawn) != none)
                MagnumPawn(Pawn).stamina -= 30;

		super.BeginState();
	}

	function PlayerMove(float DeltaTime)
	{
		aForward = 0;
		aStrafe  = 0;

		// slide on Ground
		if(Pawn.Velocity.Z == 0)
		{
            // Set eye height here so it can blend as we fall

      	    Pawn.BaseEyeHeight = FMin(1.2 * Pawn.CrouchHeight, Pawn.CrouchHeight - 65);
            Log ("PAY - BaseEyeHeight = "$ Pawn.BaseEyeHeight);

			Log ("PAY - LSlideVelocity = "$ SlideVelocity $" aStrafe = "$ aStrafe );
			Pawn.Velocity = SlideVelocity;

			if (aStrafe > 50)
				SlideVelocity *= 0.99;
			else
				SlideVelocity *= 0.93;

			if (VSize(SlideVelocity) < 50)
				GotoState('PlayerProneLeft');
		}

		// Go to prone if on ground
		if(bToProne && Pawn.Velocity.X == 0)
			GotoState('PlayerProneLeft');

		Super.PlayerMove(DeltaTime);
	}
}

state PlayerDiveRight extends PlayerDive
{
   function bool NotifyLanded(vector HitNormal)
    {
        if ( Pawn.PhysicsVolume.bWaterVolume )
            Pawn.SetPhysics(PHYS_Swimming);
        else
        {
		    if(Role == ROLE_Authority)
			    bToProne = true;
		}

		return true;
    }

    function BeginState()
	{
		local vector X,Y,Z;
		local float VelocityZ;

		GetAxes(Pawn.Rotation,X,Y,Z);

        VelocityZ = Pawn.Velocity.Z;
        // Strangley, using the same math as the dodge feels good. I was expecting to need more thrust.
        Pawn.Velocity = Pawn.DodgeSpeedFactor*Pawn.GroundSpeed*Y + (Velocity Dot X)*X;

        Pawn.Velocity.Z = VelocityZ + Pawn.DodgeSpeedZ;
        SlideVelocity = Pawn.Velocity;
        SlideVelocity.z = 0;

        SetCollisionSize(Pawn.Default.CollisionRadius/2,Pawn.Default.CollisionHeight/2);
        Pawn.SetPhysics(PHYS_Falling);

        if (MagnumPawn(Pawn) != none)
                MagnumPawn(Pawn).stamina -= 30;

		super.BeginState();
	}

	function PlayerMove(float DeltaTime)
	{
		aForward = 0;
		aStrafe  = 0;

		// slide on Ground
		if(Pawn.Velocity.Z == 0)
		{
            // Set eye height here so it can blend as we fall

      	    Pawn.BaseEyeHeight = FMin(1.2 * Pawn.CrouchHeight, Pawn.CrouchHeight - 65);
            Log ("PAY - BaseEyeHeight = "$ Pawn.BaseEyeHeight);

			Log ("PAY - RSlideVelocity = "$ SlideVelocity $" aStrafe = "$ aStrafe );
			Pawn.Velocity = SlideVelocity;

			if (aStrafe > 50)
				SlideVelocity *= 0.99;
			else
				SlideVelocity *= 0.93;

			if (VSize(SlideVelocity) < 50)
				GotoState('PlayerProneRight');
		}

		// Go to prone if on ground
		if(bToProne && Pawn.Velocity.X == 0)
			GotoState('PlayerProneRight');

		Super.PlayerMove(DeltaTime);
	}
}

state PlayerProne extends PlayerDive
{
	function BeginState()
	{
       	Log("Pay - In state PlayerProne");
		if(Role == ROLE_Authority)
			bToProne = false;

		MagnumPawn(Pawn).PlayProne();
        Pawn.BaseEyeHeight = FMin(1.2 * Pawn.CrouchHeight, Pawn.CrouchHeight - 65);
		Super.BeginState();
	}

	function PlayerMove(float DeltaTime)
	{
		Pawn.Velocity = SlideVelocity;

		if (aForward > 50)
				SlideVelocity *= 0.97;
		else
				SlideVelocity *= 0.93;

        Log ("Pay prone aForward - "$ aForward);

		if (aForward < -50)
			Stunt();

        aForward = 0;
		aStrafe  = 0;

		if(aStrafe > 0)
			aStrafe = 50;
		else if(aStrafe < 0)
			aStrafe = -50;

		Super.PlayerMove(DeltaTime);
	}
}

state PlayerProneBack extends PlayerDive
{
	function BeginState()
	{
		if(Role == ROLE_Authority)
			bToProne = false;

		MagnumPawn(Pawn).PlayProne();

        Pawn.BaseEyeHeight = FMin(1.2 * Pawn.CrouchHeight, Pawn.CrouchHeight - 65);
		Super.BeginState();
	}

	function PlayerMove(float DeltaTime)
	{

		Pawn.Velocity = SlideVelocity;

		if (aForward < -50)
			SlideVelocity *= 0.97;
		else
			SlideVelocity *= 0.93;

        Log ("Pay bprone aForward - "$ aForward);

		if (aForward > 50)
			Stunt();

		aForward = 0;
		aStrafe = 0;

		Super.PlayerMove(DeltaTime);
	}
}

state PlayerProneLeft extends PlayerDive
{
	function BeginState()
	{
		if(Role == ROLE_Authority)
			bToProne = false;

		MagnumPawn(Pawn).PlayLeftProne();

        Pawn.BaseEyeHeight = FMin(1.2 * Pawn.CrouchHeight, Pawn.CrouchHeight - 65);
		Super.BeginState();
	}

	function PlayerMove(float DeltaTime)
	{

		Pawn.Velocity = SlideVelocity;

		if (aStrafe < -50)
			SlideVelocity *= 0.97;
		else
			SlideVelocity *= 0.93;

        Log ("Pay lprone aStrafe - "$ aStrafe);

		if (aStrafe > 50)
			Stunt();

		aForward = 0;
		aStrafe = 0;

		Super.PlayerMove(DeltaTime);
	}
}

state PlayerProneRight extends PlayerDive
{
	function BeginState()
	{
		if(Role == ROLE_Authority)
			bToProne = false;

		MagnumPawn(Pawn).PlayRightProne();

        Pawn.BaseEyeHeight = FMin(1.2 * Pawn.CrouchHeight, Pawn.CrouchHeight - 65);
		Super.BeginState();
	}

	function PlayerMove(float DeltaTime)
	{

		Pawn.Velocity = SlideVelocity;

		if (aStrafe > 50)
			SlideVelocity *= 0.97;
		else
			SlideVelocity *= 0.93;

        Log ("Pay rprone aStrafe - "$ aStrafe);

		if (aStrafe < -50)
			Stunt();

		aForward = 0;
		aStrafe = 0;

		Super.PlayerMove(DeltaTime);
	}
}

state PlayerStand extends PlayerDive
{
	function AnimEnd(int Channel)
	{
		GotoState('PlayerWalking');
	}

	function BeginState()
	{
		Super.BeginState();

		if(Role == ROLE_Authority)
			SetCollisionSize(Default.CollisionRadius,Default.CollisionHeight/2);

        Pawn.BaseEyeHeight = Pawn.Default.BaseEyeHeight;
	}

	function EndState()
	{
		if(Role == ROLE_Authority)
		{
			bInDive = false;
			SetCollisionSize(Default.CollisionRadius,Default.CollisionHeight);
		}
		CurrentStuntDir = SD_None;

		Super.EndState();
	}

    function PlayerMove(float DeltaTime)
    {
        if (Pawn.EyeHeight >= Pawn.default.BaseEyeHeight - 10)
        {
      	    // Temp
    		GotoState('PlayerWalking');
  		}
    }
}

state PlayerGetUp extends PlayerStand
{

	function BeginState()
	{
		Super.BeginState();
		MagnumPawn(Pawn).PlayGetUp();
	}
}

state PlayerBackGetUp extends PlayerStand
{
	function BeginState()
	{
		Super.BeginState();
		MagnumPawn(Pawn).PlayBackGetUp();
	}
}

state PlayerLeftGetUp extends PlayerStand
{
	function BeginState()
	{
		Super.BeginState();
		MagnumPawn(Pawn).PlayLeftGetUp();
	}
}

state PlayerRightGetUp extends PlayerStand
{
	function BeginState()
	{
		Super.BeginState();
		MagnumPawn(Pawn).PlayRightGetUp();
	}
}

////////////////////
// End Stunt Code //
////////////////////

exec function Reload()
{
   	local MagnumWeapon W;

    Log ("PAY - Hit the reload :)");
	if (IsInState('PlayerBandage'))
		return;

   	if (Pawn.Weapon != None)
		W = MagnumWeapon(Pawn.Weapon);

	 Log ("PAY - Got a gun :)");
	if(W.bInReload)
		return;

    Log ("PAY - Not in Reload :)");
	if(W == None || !(W.bReloadableWeapon))
		return;

	Log ("PAY - Calling the weapons reload :)");
	//	bInReload = W.Reload();
    W.Reload();
	bHoldingReload = W.bInReload;
}

exec function ReloadOff()
{
	bHoldingReload = false;
}

exec function ChangeEquipment(string newEquip)
{
    local Controller C;

    C = Level.GetLocalPlayerController();

    Log ("PAY - ChangeEquipment = "$newEquip);
    ServerChangeEquipment(newEquip);
}

function ServerChangeEquipment(string newEquip)
{
    local int i;

    // First, store that we selected our stuff
  	EquipList = newEquip;

    // Then check if we've spawned or not
    if (Pawn == None)
    {
          GotoState('PlayerWaiting');
          ServerRestartPlayer();
          return;
    }

    Log ("PAY - ServerChangeEquipment = "$newEquip);

    Log ("PAY - Changing for "$ Pawn);
   	Log (" Role = "$ GetPropertyText("Role"));

 //   for (i = 0; i <= 15; i++)
 //			UnrealPawn(Pawn).SelectedEquipment[i] = 1;

	// Pistols
    if (Instr(newEquip, "Light Pistol") != -1)    MagnumPawn(Pawn).SelectedEquipment[0] = 1;
    if (Instr(newEquip, "Meduim Pistol") != -1)    MagnumPawn(Pawn).SelectedEquipment[1] = 1;
    if (Instr(newEquip, "Heavy Pistol") != -1)    MagnumPawn(Pawn).SelectedEquipment[2] = 1;
    // Weapons
    if (Instr(newEquip, "Light Akimbos") != -1)    MagnumPawn(Pawn).SelectedEquipment[3] = 1;
    if (Instr(newEquip, "Meduim Akimbos") != -1)    MagnumPawn(Pawn).SelectedEquipment[4] = 1;
    if (Instr(newEquip, "Heavy Akimbos") != -1)    MagnumPawn(Pawn).SelectedEquipment[5] = 1;
    if (Instr(newEquip, "Sub Machinegun") != -1)    MagnumPawn(Pawn).SelectedEquipment[6] = 1;
    if (Instr(newEquip, "Assault Rifle") != -1)    MagnumPawn(Pawn).SelectedEquipment[7] = 1;
    if (Instr(newEquip, "Shotgun") != -1)    MagnumPawn(Pawn).SelectedEquipment[8] = 1;
    if (Instr(newEquip, "HandCannon") != -1)    MagnumPawn(Pawn).SelectedEquipment[9] = 1;
    if (Instr(newEquip, "Sniper Rifle") != -1)    MagnumPawn(Pawn).SelectedEquipment[10] = 1;
	// Items
    if (Instr(newEquip, "Armour Vest") != -1)    MagnumPawn(Pawn).SelectedEquipment[11] = 1;
    if (Instr(newEquip, "Bandolier") != -1)    MagnumPawn(Pawn).SelectedEquipment[12] = 1;
    if (Instr(newEquip, "Stealth Slippers") != -1)    MagnumPawn(Pawn).SelectedEquipment[13] = 1;
    if (Instr(newEquip, "Night Vison") != -1)    MagnumPawn(Pawn).SelectedEquipment[14] = 1;
    if (Instr(newEquip, "Frag Grenade") != -1)    MagnumPawn(Pawn).SelectedEquipment[15] = 1;

    for (i = 0; i <= 15; i++)
        Log ("PAY - SelectedEquip["$i$"] = "$UnrealPawn(Pawn).SelectedEquipment[i]);

}

function bool CanRestartPlayer()
{
    Log ("PAY - CanRestartPlayer");

    if (EquipList != "")
    {
       Log ("PAY - Returning true");
       return true;
    }
    else
    {
       ClientOpenMenu("MagnumInterface.MagnumChangeEquipmentMenu");
       return false;
    }

    if (!PlayerReplicationInfo.bOnlySpectator)
    {
       Log ("PAY - Returning true");
       return true;
    }


    Log ("PAY - Returning false");

    return false;
}


exec function ShowMenu()
{
	// Pause if not already
	if(Level.Pauser == None)
		SetPause(true);

	StopForceFeedback();  // jdf - no way to pause feedback

	// Open menu
	ClientOpenMenu("MagnumInterface.MagnumMidGameMenu");
}


defaultproperties
{
	PawnClass=class'MagnumEngine.MagnumPawn'
    bHoldingReload=false
}
