// ====================================================================
//  Class:  "MagnumEngine.MagnumPawn
//  Parent: UnrealGame.UnrealPawn
//
//  <Enter a description here>
// ====================================================================

//class MagnumPawn extends UnrealPawn
class MagnumPawn extends xPawn
    config(User)
    dependsOn(xUtil)					// Replace this stuff if and when needed.
    dependsOn(xPawnSoundGroup)
    dependsOn(xPawnGibGroup);

#exec OBJ LOAD FILE=HeroMaleB.ukx

var bool bLegDamage;
var bool bLeftLeg;
var bool bBandaging;
var bool bBleeding;
var bool bInReload;
var float BleedTime;
var float BleedSpeed;
var int BleedLocations[7];
var bool bNotSolid;

var float Stamina;
var float StaminaRecoverySpeed;
var float LastStaminaTime;

// Flashlight stuff
var MagnumFlashlightEffect	flashlight;
var bool bFlashlightOn;
var const vector		FlashlightOffset;
var BulldogHeadlightCorona FlashlightCorona;

var Controller LastAttacker;

// Unique weapon, Item, Alt weapon (for bando)
// Pistol and alt pistol (for akimbo)

var bool bHasUniqueItem;
var MagnumEquipment SpecialItem;
var config byte SelectedEquipment[25];	// what player has selected (replicate using function)
var string OptionalEquipment[25];	// Action needs lots more slots!

replication
{
    reliable if(Role == ROLE_Authority)
    	bInReload, bLegDamage, bBleeding, BleedSpeed, BleedTime, bBandaging,
        bLeftLeg, SpecialItem, bHasUniqueItem, stamina, StaminaRecoverySpeed, LastStaminaTime;

    reliable if(Role < ROLE_Authority)
		ThrowItem,ToggleItem;

//	unreliable if(Role < ROLE_Authority)
//		WoosApprentice,JohnWoo;
}


/////////////////////////
// Begin the functions //
/////////////////////////

////////////////////////////////////////////////////////
// All stuff that I wanted from the xPawn class       //
// It was roughly 50/50 so I extended from unrealpawn //
// rather than xpawn. Course xpawn is sure to work... //
////////////////////////////////////////////////////////

simulated function PlayWaiting() {}

function RosterEntry GetPlacedRoster()
{
	PlayerReplicationInfo.CharacterName = PlacedCharacterName;
	return class'xRosterEntry'.static.CreateRosterEntryCharacter(PlacedCharacterName);
}

function UnPossessed()
{
	OldController = Controller;
	Super.UnPossessed();
}

// return true if was controlled by a Player (AI or human)
simulated function bool WasPlayerPawn()
{
	return ( (OldController != None) && OldController.bIsPlayer );
}

// Set up default blending parameters and pose. Ensures the mesh doesn't have only a T-pose whenever it first springs into view.
simulated function AssignInitialPose()
{
	TweenAnim(MovementAnims[0],0.0);
	AnimBlendParams(1, 1.0, 0.2, 0.2, 'Bip01 Spine1');
        BoneRefresh();
}

simulated function Destroyed()
{
    if ( LeftMarker != None )
    {
        LeftMarker.Destroy();
        LeftMarker = None;
    }

    if ( RightMarker != None )
    {
        RightMarker.Destroy();
        RightMarker = None;
    }

    if( PlayerShadow != None )
        PlayerShadow.Destroy();

/*    if( DeResFX != None )
	{
		DeResFX.Emitters[0].SkeletalMeshActor = None;
		DeResFX.Kill();
	}*/

	if(Level.NetMode != NM_DedicatedServer)
	{
		Flashlight.Destroy();
	}


    Super.Destroyed();
}

function ResetPlayer()
{
	Log ("Pay in Magnum RestartPlayer");

    MagnumPlayer(Controller).bInDive = false;
    MagnumPlayer(Controller).CurrentStuntDir = SD_None;
    MagnumPlayer(Controller).DesiredFOV = MagnumPlayer(Controller).default.DesiredFOV;
    BleedTime = 0.0;
    bBleeding = false;
    bLegDamage = false;
    LastAttacker = None;
//    MagnumClearWounds();

}

simulated function RemoveFlamingEffects()
{
    local int i;

    if( Level.NetMode == NM_DedicatedServer )
        return;

    for( i=0; i<Attached.length; i++ )
    {
        if( Attached[i].IsA('xEmitter') && !Attached[i].IsA('BloodJet'))
        {
            xEmitter(Attached[i]).mRegen = false;
        }
    }
}

simulated event PhysicsVolumeChange( PhysicsVolume NewVolume )
{
    if ( NewVolume.bWaterVolume )
        RemoveFlamingEffects();
    Super.PhysicsVolumeChange(NewVolume);
}

function PlayMoverHitSound()
{
	PlaySound(SoundGroupClass.static.GetHitSound(), SLOT_Interact);
}

function PlayDyingSound()
{
	local bool playedDeathPhrase;

	// Dont play dying sound if a skeleton. Tricky without vocal chords.
	if ( bSkeletized )
		return;

	if ( bGibbed )
	{
        PlaySound(GibGroupClass.static.GibSound(), SLOT_Pain,2.5*TransientSoundVolume,true,500);
		return;
	}

    if ( HeadVolume.bWaterVolume )
    {
        PlaySound(GetSound(EST_Drown), SLOT_Pain,2.5*TransientSoundVolume,true,500);
        return;
    }

	if(FRand() < 0.05)
	{
		playedDeathPhrase = VoiceClass.static.PlayDeathPhrase(self);
		if(playedDeathPhrase)
			return;
	}

	PlaySound(SoundGroupClass.static.GetDeathSound(), SLOT_Pain,2.5*TransientSoundVolume, true,500);
}

function Gasp()
{
    if ( Role != ROLE_Authority )
        return;
    if ( BreathTime < 2 )
        PlaySound(GetSound(EST_Gasp), SLOT_Interact);
    else
        PlaySound(GetSound(EST_BreatheAgain), SLOT_Interact);
}

function Controller GetKillerController()
{
	if ( Controller != None )
		return Controller;
	if ( OldController != None )
		return OldController;
	return None;
}

function TeamInfo GetTeam()
{
	if ( PlayerReplicationInfo != None )
		return PlayerReplicationInfo.Team;
	if ( (OldController != None) && (OldController.PlayerReplicationInfo != None) )
		return OldController.PlayerReplicationInfo.Team;
	return None;
}

function Died(Controller Killer, class<DamageType> damageType, vector HitLocation)
{
    local Inventory Inv, NextInv;
    local Vector X,Y,Z;

    if (CurrentCombo != None)
    {
		CurrentCombo.Destroy();
		if ( Controller != None )
			Controller.Adrenaline = 0;
	}

    // drop Items
    Inv = Inventory;
    while (Inv != None)
    {
         NextInv = Inv.Inventory;

         if (Inv.IsA('MagnumEquipment'))
            Inv.DropFrom(Location + 0.8 * CollisionRadius * X - 0.5 * CollisionRadius * Y);

         Inv = NextInv;
    }

    // Drop all non-held weapons
    Inv = Inventory;
    while (Inv != None)
    {
         NextInv = Inv.Inventory;

         // Drop the weapon if it isnt in our hand
         // The one in our hand will be launched when calling super.died
         if (Inv.IsA('Weapon') && Inv != Weapon)
         {
            Weapon(Inv).HolderDied(); // Just in case
            Weapon(Inv).GetAxes(Rotation,X,Y,Z);
          	Weapon(Inv).DropFrom(Location + 0.8 * CollisionRadius * X - 0.5 * CollisionRadius * Y);
         }
         Inv = NextInv;
    }


    Super.Died( Killer, damageType, HitLocation );

}

exec function ThrowWeapon()
{
	if( Level.NetMode == NM_Client )
		return;

// Put back when I add kungfu
//	if(Weapon == None || !Weapon.bCanThrow)
//		return;


	Weapon.bTossedOut = true;
	TossWeapon(Vector(GetViewRotation()) * 500 + vect(0,0,220));
	if ( Weapon == None )
		Controller.SwitchToBestWeapon();
}

exec function ThrowItem()
{
	if( Level.NetMode == NM_Client )
		return;
	if(SpecialItem == None)
		return;
	SpecialItem.Velocity = Vector(GetViewRotation()) * 500 + vect(0,0,220);
	SpecialItem.bTossedOut = true;
	TossItem();
}

// toss out the item currently held
function TossItem()
{
	local vector X,Y,Z;
	if ( SpecialItem == None )
		return;
	GetAxes(Rotation,X,Y,Z);
	SpecialItem.DropFrom(Location + 0.8 * CollisionRadius * X + - 0.5 * CollisionRadius * Y);
	SpecialItem = None;
}

exec function ToggleItem()
{
     Log ("PAY - Toggling item");
	if(SpecialItem != None)
		SpecialItem.SetMode();
}

event BreathTimer()
{
	if ( (Health < 0) || (Level.NetMode == NM_Client) )
		return;
	TakeDrowningDamage();
    Log ("PAY - Good for long term damage?");
	if ( Health > 0 )
		BreathTime = 2.0;
}

simulated function AttachEffect( class<xEmitter> EmitterClass, Name BoneName, Vector Location, Rotator Rotation )
{
    local Actor a;
    local int i;

    if( BoneName == 'None' )
        return;

    for( i = 0; i < Attached.Length; i++ )
    {
        if( Attached[i] == None )
            continue;

        if( Attached[i].AttachmentBone != BoneName )
            continue;

        if( ClassIsChildOf( EmitterClass, Attached[i].Class ) )
            return;
    }

    a = Spawn( EmitterClass,,, Location, Rotation );

    if( !AttachToBone( a, BoneName ) )
    {
        log( "Couldn't attach "$EmitterClass$" to "$BoneName, 'Error' );
        a.Destroy();
        return;
    }

    for( i = 0; i < Attached.length; i++ )
    {
        if( Attached[i] == a )
            break;
    }

    a.SetRelativeRotation( Rotation );
}

simulated function SpawnGiblet( class<Gib> GibClass, Vector Location, Rotator Rotation, float GibPerterbation )
{
    local Gib Giblet;
    local Vector Direction, Dummy;

    if( (GibClass == None) || class'GameInfo'.static.UseLowGore() )
        return;

	Instigator = self;
    Giblet = Spawn( GibClass,,, Location, Rotation );

    if( Giblet == None )
        return;

    GibPerterbation *= 32768.0;
    Rotation.Pitch += ( FRand() * 2.0 * GibPerterbation ) - GibPerterbation;
    Rotation.Yaw += ( FRand() * 2.0 * GibPerterbation ) - GibPerterbation;
    Rotation.Roll += ( FRand() * 2.0 * GibPerterbation ) - GibPerterbation;

    GetAxes( Rotation, Dummy, Dummy, Direction );

    Giblet.Velocity = Velocity + Normal(Direction) * 512.0;
}

simulated function ProcessHitFX()
{
    local Coords boneCoords;
    local class<xEmitter> HitEffects[4];
    local int i;

    if( Level.NetMode == NM_DedicatedServer )
        return;

    for ( SimHitFxTicker = SimHitFxTicker; SimHitFxTicker != HitFxTicker; SimHitFxTicker = (SimHitFxTicker + 1) % ArrayCount(HitFX) )
    {
        if( HitFX[SimHitFxTicker].damtype == None )
            continue;

        boneCoords = GetBoneCoords( HitFX[SimHitFxTicker].bone );

        if ( !Level.bDropDetail )
        {
			AttachEffect( GibGroupClass.static.GetBloodEmitClass(), HitFX[SimHitFxTicker].bone, boneCoords.Origin, HitFX[SimHitFxTicker].rotDir );

			HitFX[SimHitFxTicker].damtype.static.GetHitEffects( HitEffects, Health );

			if( !PhysicsVolume.bWaterVolume ) // don't attach effects under water
			{
				for( i = 0; i < ArrayCount(HitEffects); i++ )
				{
					if( HitEffects[i] == None )
						continue;

					AttachEffect( HitEffects[i], HitFX[SimHitFxTicker].bone, boneCoords.Origin, HitFX[SimHitFxTicker].rotDir );
				}
			}
		}

    }

    PlayBleed();
}

simulated function HideBone(name boneName)
{
	local int BoneScaleSlot;

    if( boneName == 'lthigh' )
		boneScaleSlot = 0;
	else if ( boneName == 'rthigh' )
		boneScaleSlot = 1;
	else if( boneName == 'rfarm' )
		boneScaleSlot = 2;
	else if ( boneName == 'lfarm' )
		boneScaleSlot = 3;
	else if ( boneName == 'head' )
		boneScaleSlot = 4;
	else if ( boneName == 'spine' )
		boneScaleSlot = 5;

    SetBoneScale(BoneScaleSlot, 0.0, BoneName);
}

function CalcHitLoc( Vector hitLoc, Vector hitRay, out Name boneName, out float dist )
{
    boneName = GetClosestBone( hitLoc, hitRay, dist );
}

function DoDamageFX( Name boneName, int Damage, class<DamageType> DamageType, Rotator r )
{
	local float DismemberProbability;
    local bool bExtraGib;

    if ( FRand() > 0.3f || Damage > 30 || Health <= 0 )
    {
        HitFX[HitFxTicker].damtype = DamageType;

        if( Health <= 0 )
        {
            switch( boneName )
            {
                case 'lfoot':
                    boneName = 'lthigh';
                    break;

                case 'rfoot':
                    boneName = 'rthigh';
                    break;

                case 'rhand':
                    boneName = 'rfarm';
                    break;

                case 'lhand':
                    boneName = 'lfarm';
                    break;

                case 'rshoulder':
                case 'lshoulder':
                    boneName = 'spine';
                    break;
            }

			if( DamageType.default.bAlwaysSevers || (Damage == 1000) )
			{
                HitFX[HitFxTicker].bSever = true;
                if ( boneName == 'None' )
                {
					boneName = 'spine';
					bExtraGib = true;
				}
			}
            else if( (Damage*DamageType.Default.GibModifier > 50+120*FRand()) && (Damage + Health > 0) ) // total gib prob
			{
				HitFX[HitFxTicker].bSever = true;
				boneName = 'spine';
				bExtraGib = true;
			}
            else
            {
	            DismemberProbability = Abs( (Health - Damage*DamageType.Default.GibModifier) / 130.0f );
				switch( boneName )
                {
                    case 'lthigh':
                    case 'rthigh':
                    case 'rfarm':
                    case 'lfarm':
                    case 'head':
                        if( FRand() < DismemberProbability )
                            HitFX[HitFxTicker].bSever = true;
                        break;

                    case 'None':
 						boneName = 'spine';
                     case 'spine':
                        if( FRand() < DismemberProbability * 0.3 )
                        {
                            HitFX[HitFxTicker].bSever = true;
                            if ( FRand() < 0.65 )
								bExtraGib = true;
						}
                        break;
                }
            }
        }

        if ( class'GameInfo'.static.UseLowGore() )
        {
			HitFX[HitFxTicker].bSever = false;
			bExtraGib = false;
		}

        HitFX[HitFxTicker].bone = boneName;
        HitFX[HitFxTicker].rotDir = r;
        HitFxTicker++;
        if( HitFxTicker > ArrayCount(HitFX)-1 )
            HitFxTicker = 0;
        if ( bExtraGib )
        {
			if ( FRand() < 0.3 )
			{
				DoDamageFX('lthigh',1000,DamageType,r);
				DoDamageFX('rthigh',1000,DamageType,r);
			}
			else if ( FRand() < 0.5 )
				DoDamageFX('lthigh',1000,DamageType,r);
			else
				DoDamageFX('rthigh',1000,DamageType,r);
		}
    }
}

simulated function LongTermDamage()
{
//		if (MagnumBot(Controller) != None)
//        	Log ("PAY - Bot ltd - leveltimeseconds = "$ Level.TimeSeconds $" | bandagetime + 5 = "$ MagnumBot(Controller).BandageTime );

        if (bLegDamage && !bBandaging)
        {
//        	Log ("PAY - Bot ltd limp damit");
   			GroundSpeed = Default.GroundSpeed * 0.55;

            if (!bIsWalking)  // If we are a bot
			{

               	bIsWalking = true;
                SetWalking(true);
            }
        }

        // To make bots think about bandaging..
        if (MagnumBot(Controller) != None)
        {
            if (bBandaging)
            {

            	if (  Level.TimeSeconds > (MagnumBot(Controller).BandageTime + 6)  )
                {
                        Log ("PAY - Ending bandage at "$ Level.TimeSeconds $" | bot should end at "$MagnumBot(Controller).BandageTime + 6);
            			MagnumBot(Controller).EndBandage();
                }
				else if (  Level.TimeSeconds > (MagnumBot(Controller).BandageTime + 3)  )
          	            GroundSpeed = Default.GroundSpeed * 0.70;
            }

/*        	if ((bBandaging) && (Level.TimeSeconds > (MagnumBot(Controller).BandageTime + 3))   )
            {
//               	log ("PAY - half way, moving faster");
	            GroundSpeed = Default.GroundSpeed * 0.70;
            }
            else if (bBandaging)
//            	log ("PAY - still doing the slow bit");

         	if ((bBandaging) && (Level.TimeSeconds > (MagnumBot(Controller).BandageTime + 6))   )
        	{
            	Log ("PAY - Ending bandage at "$ Level.TimeSeconds $" | bot should end at "$MagnumBot(Controller).BandageTime + 6);
            	MagnumBot(Controller).EndBandage();
            }*/

        }

        if (bBleeding)
        {
        	TakeBleedDamage();
        }

        if ((stamina < 100) && ((Level.TimeSeconds - LastStaminaTime) > StaminaRecoverySpeed))
        {
           stamina+=1;
           LastStaminaTime = Level.TimeSeconds;
        }
}

simulated function TakeBleedDamage()
{

    if(!((Level.TimeSeconds - BleedTime) > BleedSpeed))
        return;

    TakeDamage( 1, None, Location, vect(0,0,0), class'Bled');
    BleedTime = Level.TimeSeconds;


}

simulated function SetOverlayMaterial( Material mat, float time, bool bOverride )
{
	if ( Level.bDropDetail || Level.DetailMode == DM_Low )
		time *= 0.75;
	Super.SetOverlayMaterial(mat,time,bOverride);
}


simulated function Tick(float DeltaTime)
{
	if ( Level.NetMode == NM_DedicatedServer )
		return;
	if ( Controller != None )
		OldController = Controller;

   TickFX(DeltaTime);

    // assume dead if bTearOff - for remote clients unfff unfff
    if ( bTearOff )
    {
        if ( !bPlayedDeath )
            PlayDying(HitDamageType, TakeHitLocation);
        return;
    }

    FlashlightTick(DeltaTime);

    SolidifyPlayer();
}

////////////////
// Flashlight //
////////////////

exec function ToggleFlashlight()
{
	ServerFlashlight(!bFlashlightOn);
}

function ServerFlashlight(bool FlashlightStatus)
{
	Log ("Flashlight on = "$ bFlashlightOn);
    bFlashlightOn = FlashlightStatus;
}

simulated function FlashlightTick( float DeltaTime )
{
	// Dont bother making emitters etc. on dedicated server
	if(Level.NetMode != NM_DedicatedServer)
	{
    	// Set flashlight projector state.
	    Flashlight.DetachProjector();
     	if(bFlashlightOn)
      	{
      		Flashlight.SetRotation(Controller.GetViewRotation());
	       	Flashlight.AttachProjector();

        }
	}
}

simulated function PostNetBeginPlay()
{
	local vector RotX, RotY, RotZ;

    Super.PostNetBeginPlay();

    GetAxes(Rotation,RotX,RotY,RotZ);

    Log ("PAY - Adding flashlight");

	// Dont bother making emitters etc. on dedicated server
	if(Level.NetMode != NM_DedicatedServer)
	{
		// Create flashlight projector. We make sure it doesn't project on the person.
		Flashlight = spawn(class'MagnumFlashlightEffect', self,, Location + FlashlightOffset.X * RotX + FlashlightOffset.Y * RotY + FlashlightOffset.Z * RotZ);
		Flashlight.SetBase(self);
		Flashlight.SetRelativeRotation(rot(0, 0, 0));

//		FlashlightCorona = spawn(class'BulldogHeadlightCorona', self,, Location + (FlashlightOffset >> Rotation) );
//		FlashlightCorona.SetBase(self);
	}
}


function SolidifyPlayer()
{
    local bool bCanSolidify;
    local Vector Diff;
    local Controller C;

    bCanSolidify = true;

    if (!Level.Game.IsInState('MatchInProgress'))
       return;

    if (bNotSolid)
    {
    	// verify won't telefrag anyone
     	for ( C=Level.ControllerList; C!=None; C=C.NextController )
		if ( (C.Pawn != None) && (C.Pawn != self))
		{
			Diff = Location - C.Pawn.Location;
			if ( Abs(Diff.Z) < C.Pawn.CollisionHeight + 2 * CollisionHeight )
			{
				Diff.Z = 0;
				if ( VSize(Diff) < C.Pawn.CollisionRadius + CollisionRadius + 8 )
				{
					bCanSolidify = false;
					break;
				}
			}
		}

       if (bCanSolidify)
       {
          Log ("PAY - Solidifying @ "$ MagnumGameReplicationInfo(Level.Game.GameReplicationInfo).ElapsedRoundTime);
          bNotSolid = false;
          SetCollision(true, true, true);
       }
    }
}

//==============
// Encroachment
event bool EncroachingOn( actor Other )
{
    log ("PAY - "$ PlayerReplicationInfo.PlayerName $" is being encroached");

	if ( Other.bWorldGeometry )
		return true;

	if ( ((Controller == None) || !Controller.bIsPlayer || bWarping) && (Pawn(Other) != None) )
		return true;

	return false;
}

event EncroachedBy( actor Other )
{
    log ("PAY - "$ PlayerReplicationInfo.PlayerName $" is being encroached on by "$ Other);

// No telefragging?
//	if ( Pawn(Other) != None )
//		gibbedBy(Other);
}

//=============
// Fx

simulated function TickFX(float DeltaTime)
{

	local xPlayerReplicationInfo xPRI;

    if ( SimHitFxTicker != HitFxTicker )
    {
        ProcessHitFX();
    }


	xPRI = xPlayerReplicationInfo(PlayerReplicationInfo);

    if( (PlayerReplicationInfo == None) || (PlayerReplicationInfo.Team == None) || (Level.NetMode == NM_DedicatedServer)
		|| class'DeathMatch'.Default.bNoCoronas || bPlayedDeath || (xPRI != None && xPRI.bForceNoPlayerLights) )
        return;

/*	if ( LeftMarker == None )
	{
		LeftMarker = Spawn(class'PlayerLight',self,,Location);
		if( !AttachToBone(LeftMarker,'lshoulder') )
		{
			log( "Couldn't attach LeftMarker to lshoulder", 'Error' );
			LeftMarker.Destroy();
			return;
		}

		RightMarker = Spawn(class'PlayerLight',self,,Location);
		if( !AttachToBone(RightMarker,'rshoulder') )
		{
			log( "Couldn't attach RightMarker to rshoulder", 'Error' );
			RightMarker.Destroy();
			return;
		}
		LeftMarker.SetRelativeLocation(LeftOffset);
		RightMarker.SetRelativeLocation(RightOffset);
		if ( PlayerReplicationInfo.Team.TeamIndex == 0 )
		{
			RightMarker.Texture = Texture'RedMarker_t';
			LeftMarker.Texture = Texture'RedMarker_t';
		}
		else
		{
			RightMarker.Texture = Texture'BlueMarker_t';
			LeftMarker.Texture = Texture'BlueMarker_t';
		}
	}
	else if( LeftMarker != None )
	{
		LeftMarker.Destroy();
		RightMarker.Destroy();
	}*/
}

simulated function PostBeginPlay()
{
    Super.PostBeginPlay();
    AssignInitialPose();

    if(bActorShadows && bPlayerShadows && (Level.NetMode != NM_DedicatedServer))
    {
        PlayerShadow = Spawn(class'ShadowProjector',Self,'',Location);
        PlayerShadow.ShadowActor = self;
        PlayerShadow.bBlobShadow = bBlobShadow;
        PlayerShadow.LightDirection = Normal(vect(1,1,3));
        PlayerShadow.LightDistance = 320;
        PlayerShadow.MaxTraceDistance = 350;
        PlayerShadow.InitShadow();
    }
}


function UpdateDamageDirIntensity(int i, int damage)
{
    DamageDirIntensity[i] = Clamp(DamageDirIntensity[i] + (120), 0, 255);
}

function bool CheckReflect( Vector HitLocation, out Vector RefNormal, int Damage )
{
    if (Weapon != None)
        return Weapon.CheckReflect( HitLocation, RefNormal, Damage );
    else
        return false;
}

function name GetWeaponBoneFor(Inventory I)
{
     return 'righthand';
}

event Landed(vector HitNormal)
{
    Super.Landed(HitNormal);
    MultiJumpRemaining = MaxMultiJump;

    if (Health > 0)
    {
    	if ((SpecialItem != None) &&
            SpecialItem.IsA('MagnumStealthSlippers') &&
            (SpecialItem.bActive == true))
        PlaySound(GetSound(EST_Land), SLOT_Interact, FMin(1,-0.3 * Velocity.Z/JumpZ));
    }
}

// ----- animation ----- //

simulated function name GetAnimSequence()
{
    local name anim;
    local float frame, rate;

    GetAnimParams(0, anim, frame, rate);
    return anim;
}

simulated event SetAnimAction(name NewAction)
{
    AnimAction = NewAction;
    if (!bWaitForAnim)
    {
		if ( AnimAction == 'Weapon_Switch' )
        {
            AnimBlendParams(1, 1.0, 0.0, 0.2, FireRootBone);
            PlayAnim(NewAction,, 0.0, 1);
        }
        else if ( (Physics == PHYS_None)
			|| ((Level.Game != None) && Level.Game.IsInState('MatchOver')) )
        {
            PlayAnim(AnimAction,,0.1);
			AnimBlendToAlpha(1,0.0,0.05);
        }
        else if ( (Physics == PHYS_Falling) || ((Physics == PHYS_Walking) && (Velocity.Z != 0)) )
		{
			if ( CheckTauntValid(AnimAction) )
			{
				if (FireState == FS_None || FireState == FS_Ready)
				{
					AnimBlendParams(1, 1.0, 0.0, 0.2, FireRootBone);
					PlayAnim(NewAction,, 0.1, 1);
					FireState = FS_Ready;
				}
			}
			else if ( PlayAnim(AnimAction) )
			{
				if ( Physics != PHYS_None )
					bWaitForAnim = true;
			}
		}
        else if (bIsIdle && !bIsCrouched && (Bot(Controller) == None) ) // standing taunt
        {
            PlayAnim(AnimAction,,0.1);
			AnimBlendToAlpha(1,0.0,0.05);
        }
        else // running taunt
        {
            if (FireState == FS_None || FireState == FS_Ready)
            {
                AnimBlendParams(1, 1.0, 0.0, 0.2, FireRootBone);
                PlayAnim(NewAction,, 0.1, 1);
                FireState = FS_Ready;
            }
        }
    }
}

simulated function StartFiring(bool bHeavy, bool bRapid)
{
    local name FireAnim;

    if (Physics == PHYS_Swimming)
        return;

    if (bHeavy)
    {
        if (bRapid)
            FireAnim = FireHeavyRapidAnim;
        else
            FireAnim = FireHeavyBurstAnim;
    }
    else
    {
        if (bRapid)
            FireAnim = FireRifleRapidAnim;
        else
            FireAnim = FireRifleBurstAnim;
    }

    AnimBlendParams(1, 1.0, 0.0, 0.2, FireRootBone);

    if (bRapid)
    {
        if (FireState != FS_Looping)
        {
            LoopAnim(FireAnim,, 0.0, 1);
            FireState = FS_Looping;
        }
    }
    else
    {
        PlayAnim(FireAnim,, 0.0, 1);
        FireState = FS_PlayOnce;
    }

    IdleTime = Level.TimeSeconds;
}

simulated function StopFiring()
{
    if (FireState == FS_Looping)
    {
        FireState = FS_PlayOnce;
    }
    IdleTime = Level.TimeSeconds;
}

simulated function AnimEnd(int Channel)
{
    if (Channel == 1)
    {
        if (FireState == FS_Ready)
        {
            AnimBlendToAlpha(1, 0.0, 0.12);
            FireState = FS_None;
        }
        else if (FireState == FS_PlayOnce)
        {
            PlayAnim(IdleWeaponAnim,, 0.2, 1);
            FireState = FS_Ready;
            IdleTime = Level.TimeSeconds;
        }
        else
            AnimBlendToAlpha(1, 0.0, 0.12);
    }
    else if ( bKeepTaunting && (Channel == 0) )
		PlayVictoryAnimation();
}

function PlayWeaponSwitch(Weapon NewWeapon)
{
    SetAnimAction('Weapon_Switch');
}

function PlayVictoryAnimation()
{
	local int tauntNum;

	// First 4 taunts are 'order' anims. Don't pick them.
	tauntNum = Rand(TauntAnims.Length - 3);
	SetAnimAction(TauntAnims[3 + tauntNum]);
}

simulated function SetWeaponAttachment(xWeaponAttachment NewAtt)
{
    WeaponAttachment = NewAtt;
    if (WeaponAttachment.bHeavy)
        IdleWeaponAnim = IdleHeavyAnim;
    else
        IdleWeaponAnim = IdleRifleAnim;
}

// Event called whenever ragdoll convulses
event KSkelConvulse()
{
	if(RagConvulseMaterial != None)
		SetOverlayMaterial(RagConvulseMaterial, 0.4, true);
}

simulated function PlayDying(class<DamageType> DamageType, vector HitLoc)
{
	local vector shotDir, hitLocRel, deathAngVel, shotStrength;
	local float maxDim, frame, rate;
	local string RagSkelName;
	local KarmaParamsSkel skelParams;
    local name seq;
	local bool PlayersRagdoll;
	local PlayerController pc;
	local LavaDeath LD;

	AmbientSound = None;
    bCanTeleport = false; // sjs - fix karma going crazy when corpses land on teleporters
    bReplicateMovement = false;
    bTearOff = true;
    bPlayedDeath = true;

    if (CurrentCombo != None)
        CurrentCombo.Destroy();

	HitDamageType = DamageType; // these are replicated to other clients
    TakeHitLocation = HitLoc;

    if ( (DamageType != None) && DamageType.default.bSkeletize && (SkeletonMesh != None) )
    {
        if (!bSkeletized)
        {
            GetAnimParams( 0, seq, frame, rate );
            LinkMesh(SkeletonMesh, true);
            Skins.Length = 0;
            PlayAnim(seq, 0, 0);
            SetAnimFrame(frame);
            if (Physics == PHYS_Walking)
                Velocity = Vect(0,0,0);
            TearOffMomentum *= 0.25;
            bSkeletized = true;

			if(DamageType == class'FellLava')
			{
				LD = spawn(class'LavaDeath');
				if ( LD != None )
				{
					LD.SetLocation(Location);
					LD.SetRotation(Rotation);
					LD.SetBase(self);
				}
				// This should destroy itself once its finished.

				PlaySound( sound'WeaponSounds.BExplosion5', SLOT_None, 1.5*TransientSoundVolume );
			}
        }
    }

    // stop shooting
    AnimBlendParams(1, 0.0);
    FireState = FS_None;
	LifeSpan = RagdollLifeSpan;

    GotoState('Dying');

	if ( Level.NetMode != NM_DedicatedServer )
	{
		// Is this the local player's ragdoll?
		if(OldController != None)
			pc = PlayerController(OldController);
		if( pc != None && pc.ViewTarget == self )
			PlayersRagdoll = true;

		// In low physics detail, if we were not just controlling this pawn,
		// and it has not been rendered in 3 seconds, just destroy it.
		if(Level.PhysicsDetailLevel == PDL_Low && !PlayersRagdoll && (Level.TimeSeconds - LastRenderTime > 3) )
		{
			Destroy();
			return;
		}

		// Try and obtain a rag-doll setup
		if(Species != None)
			RagSkelName = Species.static.GetRagSkelName(GetMeshName());
		else
			Log("xPawn.PlayDying: No Species");

		// If we managed to find a name, try and make a rag-doll slot availbale.
		if( RagSkelName != "" )
		{
			KMakeRagdollAvailable();
		}

		if( KIsRagdollAvailable() && RagSkelName != "" )
		{
			skelParams = KarmaParamsSkel(KParams);
			skelParams.KSkeleton = RagSkelName;
			KParams = skelParams;

			//Log("RAGDOLL");

			// Stop animation playing.
			StopAnimating(true);

			// DEBUG
			//if(VSize(TearOffMomentum) < 0.01)
			//	Log("TearOffMomentum magnitude of Zero");
			// END DEBUG

			if(DamageType != None && DamageType.default.bKUseOwnDeathVel)
			{
				RagDeathVel = DamageType.default.KDeathVel;
				RagDeathUpKick = DamageType.default.KDeathUpKick;
			}

			// Set the dude moving in direction he was shot in general
			shotDir = Normal(TearOffMomentum);
			shotStrength = RagDeathVel * shotDir;

		    // Calculate angular velocity to impart, based on shot location.
		    hitLocRel = TakeHitLocation - Location;

		    // We scale the hit location out sideways a bit, to get more spin around Z.
		    hitLocRel.X *= RagSpinScale;
		    hitLocRel.Y *= RagSpinScale;
		    deathAngVel = RagInvInertia * (hitLocRel Cross shotStrength);

    		// Set initial angular and linear velocity for ragdoll.
			// Scale horizontal velocity for characters - they run really fast!
			skelParams.KStartLinVel.X = 0.6 * Velocity.X;
			skelParams.KStartLinVel.Y = 0.6 * Velocity.Y;
			skelParams.KStartLinVel.Z = 1.0 * Velocity.Z;
    		skelParams.KStartLinVel += shotStrength;

			// If not moving downwards - give extra upward kick
			if(Velocity.Z > -10)
				skelParams.KStartLinVel.Z += RagDeathUpKick;

    		skelParams.KStartAngVel = deathAngVel;

    		// Set up deferred shot-bone impulse
			maxDim = Max(CollisionRadius, CollisionHeight);

    		skelParams.KShotStart = TakeHitLocation - (1 * shotDir);
    		skelParams.KShotEnd = TakeHitLocation + (2*maxDim*shotDir);
    		skelParams.KShotStrength = RagShootStrength;

    		// If this damage type causes convulsions, turn them on here.
    		if(DamageType != None && DamageType.default.bCauseConvulsions)
    		{
    			RagConvulseMaterial=DamageType.default.DamageOverlayMaterial;
    			skelParams.bKDoConvulsions = true;
		    }

    		// Turn on Karma collision for ragdoll.
			KSetBlockKarma(true);

			// Set physics mode to ragdoll.
			// This doesn't actaully start it straight away, it's deferred to the first tick.
			SetPhysics(PHYS_KarmaRagdoll);

			// If viewing this ragdoll, set the flag to indicate that it is 'important'
			if( PlayersRagdoll )
				skelParams.bKImportantRagdoll = true;

			return;
		}
		// jag
	}

	// non-ragdoll death fallback
	Velocity += TearOffMomentum;
    BaseEyeHeight = Default.BaseEyeHeight;
    SetTwistLook(0, 0);
//    SetInvisibility(0.0);
    PlayDirectionalDeath(HitLoc);
    SetPhysics(PHYS_Falling);
}

simulated function SpawnGibs(Rotator HitRotation, float ChunkPerterbation)
{
	bGibbed = true;
	PlayDyingSound();
    if( GibCountTorso+GibCountHead+GibCountForearm+GibCountUpperArm > 3 )
    {
        if ( class'GameInfo'.static.UseLowGore() )
             Spawn( GibGroupClass.default.LowGoreBloodGibClass,,,Location );
        else
            Spawn( GibGroupClass.default.BloodGibClass,,,Location );
    }
    if ( class'GameInfo'.static.UseLowGore() )
		return;

    SpawnGiblet( GetGibClass(EGT_Torso), Location, HitRotation, ChunkPerterbation );
    GibCountTorso--;

    while( GibCountTorso-- > 0 )
        SpawnGiblet( GetGibClass(EGT_Torso), Location, HitRotation, ChunkPerterbation );
    while( GibCountHead-- > 0 )
        SpawnGiblet( GetGibClass(EGT_Head), Location, HitRotation, ChunkPerterbation );
    while( GibCountForearm-- > 0 )
        SpawnGiblet( GetGibClass(EGT_UpperArm), Location, HitRotation, ChunkPerterbation );
    while( GibCountUpperArm-- > 0 )
        SpawnGiblet( GetGibClass(EGT_Forearm), Location, HitRotation, ChunkPerterbation );
}

function ClientDying(class<DamageType> DamageType, vector HitLocation)
{
}

function PlayTakeHit(vector HitLocation, int Damage, class<DamageType> DamageType)
{
     if (DamageType.name != 'Bled')
     {
	    PlayDirectionalHit(HitLocation);
     }
//     else
//	     PlayBleed();

    if( Level.TimeSeconds - LastPainSound < MinTimeBetweenPainSounds )
        return;

    LastPainSound = Level.TimeSeconds;

    if( HeadVolume.bWaterVolume )
    {
        if( DamageType.IsA('Drowned') )
            PlaySound( GetSound(EST_Drown), SLOT_Pain,1.5*TransientSoundVolume );
        else
            PlaySound( GetSound(EST_HitUnderwater), SLOT_Pain,1.5*TransientSoundVolume );
        return;
    }

    if (DamageType.name != 'Bled')
	    PlaySound(SoundGroupClass.static.GetHitSound(), SLOT_Pain,2*TransientSoundVolume,,400);
	else if (health % 5 == 0)
	    PlaySound(SoundGroupClass.static.GetHitSound(), SLOT_Pain,TransientSoundVolume/2,,400);

}

// jag
// Called when in Ragdoll when we hit something over a certain threshold velocity
// Used to play impact sounds.
event KImpact(actor other, vector pos, vector impactVel, vector impactNorm)
{
	local int numSounds, soundNum;
	numSounds = RagImpactSounds.Length;

	//log("ouch! iv:"$VSize(impactVel));

	if(numSounds > 0 && Level.TimeSeconds > RagLastSoundTime + RagImpactSoundInterval)
	{
		soundNum = Rand(numSounds);
		//Log("Play Sound:"$soundNum);
		PlaySound(RagImpactSounds[soundNum], SLOT_Pain, RagImpactVolume);
		RagLastSoundTime = Level.TimeSeconds;
	}
}
//jag

simulated function PlayDirectionalDeath(Vector HitLoc)
{
    local Vector X,Y,Z, Dir;

    GetAxes(Rotation, X,Y,Z);
    HitLoc.Z = Location.Z;

    // random
    if ( VSize(Velocity) < 10.0 && VSize(Location - HitLoc) < 1.0 )
    {
        Dir = VRand();
    }
    // velocity based
    else if ( VSize(Velocity) > 0.0 )
    {
        Dir = Normal(Velocity*Vect(1,1,0));
    }
    // hit location based
    else
    {
        Dir = -Normal(Location - HitLoc);
    }

    if ( Dir Dot X > 0.7 || Dir == vect(0,0,0))
        PlayAnim('DeathB',, 0.2);
    else if ( Dir Dot X < -0.7 )
         PlayAnim('DeathF',, 0.2);
    else if ( Dir Dot Y > 0 )
        PlayAnim('DeathL',, 0.2);
    else
        PlayAnim('DeathR',, 0.2);
}

simulated function PlayDirectionalHit(Vector HitLoc)
{
    local Vector X,Y,Z, Dir;

    GetAxes(Rotation, X,Y,Z);
    HitLoc.Z = Location.Z;

    // random
    if ( VSize(Location - HitLoc) < 1.0 )
    {
        Dir = VRand();
    }
    // hit location based
    else
    {
        Dir = -Normal(Location - HitLoc);
    }

    if ( Dir Dot X > 0.7 || Dir == vect(0,0,0))
    {
        PlayAnim('HitF',, 0.1);
    }
    else if ( Dir Dot X < -0.7 )
    {
        PlayAnim('HitB',, 0.1);
    }
    else if ( Dir Dot Y > 0 )
    {
        PlayAnim('HitR',, 0.1);
    }
    else
    {
        PlayAnim('HitL',, 0.1);
    }
}

simulated function FootStepping(int Side)
{
    local int SurfaceType, i;
	local actor A;
	local material FloorMat;
	local vector HL,HN,Start,End;

    SurfaceType = 0;

    for ( i=0; i<Touching.Length; i++ )
		if ( (PhysicsVolume(Touching[i]) != None) && PhysicsVolume(Touching[i]).bWaterVolume )
		{
			if ( FRand() < 0.5 )
				PlaySound(sound'PlayerSounds.FootStepWater2', SLOT_Interact, FootstepVolume );
			else
				PlaySound(sound'PlayerSounds.FootStepWater1', SLOT_Interact, FootstepVolume );
			return;
		}

	if ( bIsCrouched || bIsWalking )
		return;

	if ((SpecialItem != None) &&
        SpecialItem.IsA('MagnumStealthSlippers') &&
        (SpecialItem.bActive == true))
        return;

	if ( (Base!=None) && (!Base.IsA('LevelInfo')) && (Base.SurfaceType!=0) )
	{
		SurfaceType = Base.SurfaceType;
	}
	else
	{
		Start = Location - Vect(0,0,1)*CollisionHeight;
		End = Start - Vect(0,0,16);
		A = Trace(hl,hn,End,Start,false,,FloorMat);
		if (FloorMat !=None)
			SurfaceType = FloorMat.SurfaceType;
	}
	PlaySound(SoundFootsteps[SurfaceType], SLOT_Interact, FootstepVolume,,400 );
}

simulated function PlayFootStepLeft()
{
    PlayFootStep(-1);
}

simulated function PlayFootStepRight()
{
    PlayFootStep(1);
}

event SetWalking(bool bNewIsWalking)
{
	if ( bNewIsWalking != bIsWalking )
	{
		bIsWalking = bNewIsWalking;
        //Log ("Pay - changeanim called. bIsWalking now - "$ bIsWalking );
		ChangeAnimation();
	}
}


simulated event PostNetReceive()
{
	if ( PlayerReplicationInfo != None )
    {
		Setup(class'xUtil'.static.FindPlayerRecord(PlayerReplicationInfo.CharacterName));
        bNetNotify = false;
    }
}

simulated function ClientRestart()
{
	Super.ClientRestart();
	if ( Controller != None )
		OldController = Controller;
}

simulated function Setup(xUtil.PlayerRecord rec, optional bool bLoadNow)
{
	if ( class'DeathMatch'.default.bForceDefaultCharacter )
		rec = class'xUtil'.static.FindPlayerRecord("Gorge");

    Species = rec.Species;
    if ( Species == None )
    {
		warn("Could not load species "$rec.Species$" for "$rec.DefaultName);
		return;
	}

// PAYBACK - Find out why I error
	if ( Species.static.Setup(self,rec) )
		ResetPhysicsBasedAnim();
}

simulated function ResetPhysicsBasedAnim()
{
    bIsIdle = false;
    bWaitForAnim = false;
}

function Sound GetSound(xPawnSoundGroup.ESoundType soundType)
{
    return SoundGroupClass.static.GetSound(soundType);
}

function class<Gib> GetGibClass(xPawnGibGroup.EGibType gibType)
{
    return GibGroupClass.static.GetGibClass(gibType);
}

/*simulated function DoDerezEffect()
{
    Spawn(TeleportFXClass);
} */

State Dying
{
    simulated function AnimEnd( int Channel )
    {
        ReduceCylinder();
    }

	event FellOutOfWorld(eKillZType KillType)
	{
		local LavaDeath LD;

		// If we fall past a lava killz while dead- burn off skin.
		if( KillType == KILLZ_Lava )
		{
			if (!bSkeletized)
			{
				//LinkMesh(SkeletonMesh, true);
				//Skins.Length = 0;
				bSkeletized = true;

				LD = spawn(class'LavaDeath', , , Location + vect(0, 0, 10), Rotation );
				if ( LD != None )
					LD.SetBase(self);
				// This should destroy itself once its finished.

				PlaySound( sound'WeaponSounds.BExplosion5', SLOT_None, 1.5*TransientSoundVolume );
			}

			return;
		}

		Super.FellOutOfWorld(KillType);
	}

    function LandThump()
    {
        // animation notify - play sound if actually landed, and animation also shows it
        if ( Physics == PHYS_None)
        {
            bThumped = true;
            PlaySound(GetSound(EST_CorpseLanded));
        }
    }

    simulated function TakeDamage( int Damage, Pawn InstigatedBy, Vector Hitlocation, Vector Momentum, class<DamageType> damageType)
    {
        local Vector SelfToHit, SelfToInstigator, CrossPlaneNormal;
        local float W;
        local float YawDir;

        local Vector HitNormal, shotDir;
        local Vector PushLinVel, PushAngVel;
        local Name HitBone;
        local float HitBoneDist;
        local int MaxCorpseYawRate;

		if(bPlayedDeath && Physics == PHYS_KarmaRagdoll)
		{
			// Can't shoot corpses during de-res
//			if(bDeRes)
//				return;

			//log("HIT RAGDOLL. M:"$Momentum);
			// Throw the body if its a rocket explosion or shock combo
			if(damageType.Name == 'DamTypeRocket' || damageType.Name == 'DamTypeShockCombo' || damageType.Name == 'DamTypeFlakShell')
			{
				shotDir = Normal(Momentum);
                PushLinVel = (RagDeathVel * shotDir) +  vect(0, 0, 250);
				PushAngVel = Normal(shotDir Cross vect(0, 0, 1)) * -18000;
				KSetSkelVel( PushLinVel, PushAngVel );
			}
			else
			{
                PushLinVel = RagShootStrength*Normal(Momentum);
				KAddImpulse(PushLinVel, HitLocation);
			}

			return;
		}

        if ( DamageType.default.bFastInstantHit && GetAnimSequence() == 'Death_Spasm' && RepeaterDeathCount < 6)
        {
            PlayAnim('Death_Spasm',, 0.2);
            RepeaterDeathCount++;
        }
        else if (Damage > 0)
        {
			if ( InstigatedBy != None )
			{
				if ( InstigatedBy.IsA('xPawn') && xPawn(InstigatedBy).bBerserk )
					Damage *= 2;

				// Figure out which direction to spin:

				if( InstigatedBy.Location != Location )
				{
					SelfToInstigator = InstigatedBy.Location - Location;
					SelfToHit = HitLocation - Location;

					CrossPlaneNormal = Normal( SelfToInstigator cross Vect(0,0,1) );
					W = CrossPlaneNormal dot Location;

					if( HitLocation dot CrossPlaneNormal < W )
						YawDir = -1.0;
					else
						YawDir = 1.0;
				}
			}
            if( VSize(Momentum) < 10 )
            {
                Momentum = - Normal(SelfToInstigator) * Damage * 1000.0;
                Momentum.Z = Abs( Momentum.Z );
            }

            SetPhysics(PHYS_Falling);
            Momentum = Momentum / Mass;
            AddVelocity( Momentum );
            bBounce = true;

            RotationRate.Pitch = 0;
            RotationRate.Yaw += VSize(Momentum) * YawDir;

            MaxCorpseYawRate = 150000;
            RotationRate.Yaw = Clamp( RotationRate.Yaw, -MaxCorpseYawRate, MaxCorpseYawRate );
            RotationRate.Roll = 0;

            bFixedRotationDir = true;
            bRotateToDesired = false;

            Health -= Damage;
            CalcHitLoc( HitLocation, vect(0,0,0), HitBone, HitBoneDist );

            if( InstigatedBy != None )
                HitNormal = Normal( Normal(InstigatedBy.Location-HitLocation) + VRand() * 0.2 + vect(0,0,2.8) );
            else
                HitNormal = Normal( Vect(0,0,1) + VRand() * 0.2 + vect(0,0,2.8) );

            DoDamageFX( HitBone, Damage, DamageType, Rotator(HitNormal) );
        }
    }

    simulated function BeginState()
	{
		Super.BeginState();
		AmbientSound = None;
        if ( LeftMarker != None )
            LeftMarker.Destroy();

        if ( RightMarker != None )
            RightMarker.Destroy();
 	}

    simulated function Timer()
	{
//		local KarmaParamsSkel skelParams;

		if ( !PlayerCanSeeMe() )
        {
			Destroy();
        }
        // PAYBACK - Overridden so that bodies stay so I can shoot them and stuff
        // If we are running out of life, bute we still haven't come to rest, force the de-res.
        // unless pawn is the viewtarget of a player who used to own it
/*        else if ( LifeSpan <= DeResTime && bDeRes == false )
        {
			skelParams = KarmaParamsSkel(KParams);

			// check not viewtarget
			if ( (PlayerController(OldController) != None) && (PlayerController(OldController).ViewTarget == self) )
			{
				skelParams.bKImportantRagdoll = true;
				LifeSpan = FMax(LifeSpan,DeResTime + 2.0);
				SetTimer(1.0, false);
				return;
			}
			else
			{
				skelParams.bKImportantRagdoll = false;
			}
            // spawn derez
            StartDeRes();
        }*/
		else
        {
			SetTimer(1.0, false);
        }
	}

	// We shorten the lifetime when the guys comes to rest.
	event KVelDropBelow()
	{
//		local float NewLifeSpan;

/*		if(bDeRes == false)
		{
			//Log("Low Vel - Reducing LifeSpan!");
			NewLifeSpan = DeResTime + 3.5;
			if(NewLifeSpan < LifeSpan)
				LifeSpan = NewLifeSpan;
		}*/
	}
}


//////////////////////////////////
// Stuff that I overrode myself //
// from UnrealPawn class        //
//////////////////////////////////

function ServerChangedWeapon(Weapon OldWeapon, Weapon NewWeapon)
{
	Log ("PAY - ServerChangedWeapon");
	Super.ServerChangedWeapon(OldWeapon, NewWeapon);
}

// Just changed to pendingWeapon
function ChangedWeapon()
{
	Log ("PAY - ChangedWeapon");
    Super.ChangedWeapon();
}

function TakeFallingDamage()
{
	local float Shake, EffectiveSpeed, damage, NewFallSpeed;

	if (Velocity.Z < -0.5 * MaxFallSpeed)
	{
		MakeNoise(1.0);
        //Log ("PAY - Velocity.Z = "$ Velocity.Z $" Maxfallspeed = "$ MaxFallSpeed $" on "$ (Controller).PlayerReplicationInfo.PlayerName);
		if (Velocity.Z < -1 * MaxFallSpeed)
		{
			if ( Role == ROLE_Authority )
			{
				EffectiveSpeed = Velocity.Z;
				if ( TouchingWaterVolume() )
					EffectiveSpeed += 100;

                if (MultiJumpRemaining != 0)
                    NewFallSpeed = MaxFallSpeed; // We werent multijumping
                else
                    NewFallSpeed = MaxFallSpeed * 1.1; // We were multijumping, so expecting the hard landing
                                                       // (hence less damage)

                damage = -100 * (EffectiveSpeed + NewFallSpeed)/NewFallSpeed;

                if (damage <= 0)
                   return;

                Log ("Pay damage = -100 * ("$ EffectiveSpeed $" + "$ NewFallSpeed $")/"$ NewFallSpeed $"   ("$ (EffectiveSpeed + MaxFallSpeed)/MaxFallSpeed $" = "$ damage);
				TakeDamage(damage, None, Location, vect(0,0,0), class'Fell');

                if (( damage > 12 ) && (!IsInState('PawnDiving')))
                	bLegDamage = true;
			}
		}
		if ( Controller != None )
		{
			Shake = FMin(1, -1 * Velocity.Z/MaxFallSpeed);
            Controller.DamageShake(Shake);
		}
	}
	else if (Velocity.Z < -1.4 * JumpZ)
		MakeNoise(0.5);
}


function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation,
						Vector momentum, class<DamageType> damageType)
{
	local int actualDamage;
	local bool bAlreadyDead;
	local Controller Killer;
    local float shotDist;
    local class<MagnumWeaponDamageType> mDamageType;

	if ( damagetype == None )
		warn("No damagetype for damage by "$instigatedby$" with weapon "$InstigatedBy.Weapon);
	if ( Role < ROLE_Authority )
	{
		log(self$" client damage type "$damageType$" by "$instigatedBy);
		return;
	}

	bAlreadyDead = (Health <= 0);

	if (Physics == PHYS_None)
		SetMovementPhysics();

	if (Physics == PHYS_Walking)
		momentum.Z = FMax(momentum.Z, 0.4 * VSize(momentum));

	if ( (instigatedBy == self)
		|| ((Controller != None) && (InstigatedBy != None) && (InstigatedBy.Controller != None) && InstigatedBy.Controller.SameTeamAs(Controller)) )
		momentum *= 0.6;
	momentum = momentum/Mass;

    if (Weapon != None)
        Weapon.AdjustPlayerDamage( Damage, InstigatedBy, HitLocation, Momentum, DamageType );
    if ( (InstigatedBy != None) && InstigatedBy.HasUDamage() ) // FIXME THIS SUCKS
        Damage *= 2;
	actualDamage = Level.Game.ReduceDamage(Damage, self, instigatedBy, HitLocation, Momentum, DamageType);
	if( DamageType.default.bArmorStops && (actualDamage > 0) )
		actualDamage = ShieldAbsorb(actualDamage);

    Log ("PAY - DamageFrom ("$ damageType.name $")");

    // Magnum damage specific stuff
    // Dont do range reduction for sniper (and maybe magnum?)
    if (InstigatedBy != None)
	{
        if (ClassIsChildOf(damageType, class'MagnumWeaponDamageType'))
        {
           mDamageType = class<MagnumWeaponDamageType>( damageType );

           shotDist = VSize(Location - InstigatedBy.Location);

           Log ("PAY - ShotDist = "$ shotDist);

		   if ( shotDist > mDamageType.default.mindist )
           {
                if (shotDist < mDamageType.default.middist)
                    actualDamage *= 0.67;  // Just over a third
				else if (shotDist < mDamageType.default.maxdist)
					actualDamage *= 0.44;  // Just over half off
				else
					actualDamage *= 0.27;  // barely nicked him
		   }
	   }
	}

   	if ((damageType.name != 'bled') && (damageType.name != 'fell')) // Dont reduce damage on bleeding
    {
		actualDamage = LocationDamage(actualDamage, InstigatedBy, hitLocation);
		LastAttacker =  InstigatedBy.Controller;
    }
	// End magnum damamge specific stuff

	Log ("PAY - Final damage = "$ actualDamage);

	Health -= actualDamage;
	if ( HitLocation == vect(0,0,0) )
		HitLocation = Location;
	if ( bAlreadyDead )
		return;

	PlayHit(actualDamage,InstigatedBy, hitLocation, damageType, Momentum);
	if ( Health <= 0 )
	{
		// pawn died
		if ( instigatedBy != None )
			Killer = instigatedBy.GetKillerController();
		if ( bPhysicsAnimUpdate )
			TearOffMomentum = momentum;
		Died(Killer, damageType, HitLocation);
	}
	else
	{
    	// dont want this if we are just bleeding, it looks frickin stupid
    	if (damageType.name != 'bled')
		{
        	if ( (InstigatedBy != None) && (InstigatedBy != self) && (Controller != None)
	            && (InstigatedBy.Controller != None) && InstigatedBy.Controller.SameTeamAs(Controller) )
	            Momentum *= 0.5;

	        AddVelocity( momentum );
        }

		if ( Controller != None )
			Controller.NotifyTakeHit(instigatedBy, HitLocation, actualDamage, DamageType, Momentum);
	}
	MakeNoise(1.0);
}

function float LocationDamage(float ActualDamage, Pawn instigatedBy, Vector hitlocation)
{
	local Name HitBone;
	local float HitBoneDist;
	local Vector HitRay;

	// First, figure out where the shot came from
	HitRay = vect(0,0,0);
   if( InstigatedBy != None )
       HitRay = Normal(HitLocation-(InstigatedBy.Location+(vect(0,0,1)*InstigatedBy.EyeHeight)));

	// Figure out where we hit
    CalcHitLoc( HitLocation, HitRay, HitBone, HitBoneDist );

	// Now that we have a hit location, start multiplying the damage
    Log ("PAY - Location damage - Hit from CalcHitLoc ("$ HitBone $") with damage "$ actualDamage);


	switch( HitBone )
	{
		case 'lthigh':
		case 'rthigh':
				  bLegDamage = true;
				  ActualDamage *= 0.45;
				  BleedSpeed = 1.3;
		 		  break;

		case 'rfarm':
		case 'lfarm':
		case 'righthand':
    	case 'lefthand':
				ActualDamage *= 0.55;
				BleedSpeed = 0.9;
		 		break;

		case 'head':
//        		 ActualDamage *= 1.8;
				ActualDamage *= 2.3;  // Testin.
				BleedSpeed = 0.4;
		  		  break;

		case 'spine':
		case 'none': // <- wtf is this?! How can a hit on a player get no bone.
                if ((self.IsA('MagnumPawn')) &&
                    (self.SpecialItem != None) &&
                    (self.SpecialItem.IsA('MagnumVest'))
                    )
                {
                    ActualDamage *= 0.67;
                    // No bleeding plz.
                    Log ("PAY - HIT THAT VEST!");
                }
                else
                {
   				    ActualDamage *= 0.735;
				    BleedSpeed = 0.6;
                }
		  		break;
	}

    Log ("PAY - Actual Damage - "$ ActualDamage);

    bBleeding = true;

	if (bLegDamage)
	{
		if (HitBone == 'lthigh')
			bLeftLeg = true;
		else
			bLeftLeg = false;
	}

	return ActualDamage;

}

function PlayHit(float Damage, Pawn InstigatedBy, vector HitLocation, class<DamageType> damageType, vector Momentum)
{
	local float bleedrate;
    local Vector HitNormal;

	Super.PlayHit(Damage, InstigatedBy, HitLocation, damageType, Momentum);

    if (damageType.default.bCausesBlood && (damageType.name != 'Fell'))
    {
    	bBleeding = True;
        BleedTime = Level.TimeSeconds;
        bleedrate = 0.9;             // Change this to bleed faster depending on which limb it hit.

		if (BleedRate > BleedSpeed)
	        BleedSpeed = BleedRate;
    }

    if( InstigatedBy != None )
		HitNormal = Normal( Normal(InstigatedBy.Location-HitLocation) + VRand() * 0.2 + vect(0,0,2.8) );
	else
		HitNormal = Normal( Vect(0,0,1) + VRand() * 0.2 + vect(0,0,2.8) );

}

simulated function PlayBleed()
{
    local vector WallHit, WallNormal;
	local Actor WallActor;

	//Log ("PAY - PlayBleed low gore= "$ class'GameInfo'.static.UseLowGore() $" @ "$ Location);
	if ( class'GameInfo'.static.UseLowGore() )
		Spawn( GibGroupClass.default.LowGoreBloodHitClass,,, Location, );
	else
		Spawn( GibGroupClass.default.BloodHitClass,,, Location, );

	if ( FRand() > 0.8 )
		return;
	WallActor = Trace(WallHit, WallNormal, Location + vect(0,0,-200), Location, false);
	if ( WallActor != None )
		spawn(class'bloodsplatter',,,WallHit + 20 * (WallNormal + VRand()), rotator(-WallNormal));
}


function AddDefaultInventory()
{
	local int i;

    Log ("**** Setting up for "$ MagnumPlayer(Controller).PlayerReplicationInfo.PlayerName $" ****");
//   	Log (" Role = "$ GetPropertyText("Role"));
    if ((Controller) != None && (MagnumPlayer(Controller) != None))
	{
        Log ("ADI - EquipList = "$ MagnumPlayer(Controller).EquipList);
        BuildSelectedlist(MagnumPlayer(Controller).EquipList);
    }

	if ( IsLocallyControlled() )
	{
	    // As special items are optional, but affect required items
	    // we need it to go first.

    	for ( i=15; i >= 0; i-- )
        {
//        	Log ("PAY - (local player) Selected = "$ SelectedEquipment[i] $" | optional = "$OptionalEquipment[i]);
			if ( (SelectedEquipment[i] == 1) && (OptionalEquipment[i] != "") )
				CreateInventory(OptionalEquipment[i]);
        }

		for ( i=15; i >= 0; i-- )
			if ( RequiredEquipment[i] != "" )
				CreateInventory(RequiredEquipment[i]);

	    Level.Game.AddGameSpecificInventory(self);
	}
	else
	{
	    Level.Game.AddGameSpecificInventory(self);

		for ( i=15; i>=0; i-- )
        {
//	        Log ("PAY - (server?) Selected = "$ SelectedEquipment[i] $" | optional = "$OptionalEquipment[i]);
			if ( (SelectedEquipment[i] == 1) && (OptionalEquipment[i] != "") )
				CreateInventory(OptionalEquipment[i]);
			if ( (SelectedEquipment[i] == 1) && (OptionalEquipment[i] != "") )
				CreateInventory(OptionalEquipment[i]);
        }

		for ( i=15; i>=0; i-- )
			if ( RequiredEquipment[i] != "" )
				CreateInventory(RequiredEquipment[i]);
	}

	// HACK FIXME
	if ( inventory != None )
		inventory.OwnerEvent('LoadOut');

	Controller.ClientSwitchToBestWeapon();
}

function CreateInventory(string InventoryClassName)
{
	local Inventory Inv;
	local class<Inventory> InventoryClass;

	InventoryClass = Level.Game.BaseMutator.GetInventoryClass(InventoryClassName);
	if( (InventoryClass!=None) && (FindInventoryType(InventoryClass)==None) )
	{
		Inv = Spawn(InventoryClass);
		if( Inv != None )
		{
            Log ("PAY - giving "$ InventoryClassName);
			Inv.GiveTo(self);
			Inv.PickupFunction(self);
		}
	}
}

function BuildSelectedList(string newEquip)
{
	Local int i;
	
	//  If you change this function, remember to update
	//  the optionalequipment in the default_properties
	//  else you wont get the guns you chose from the menu

    // Pistols
    if (Instr(newEquip, "Random Pistol") != -1)    SelectedEquipment[RandRange(0,2)] = 1;
	 if (Instr(newEquip, "Light Pistol") != -1)    	SelectedEquipment[0] = 1;
    if (Instr(newEquip, "Meduim Pistol") != -1)   	SelectedEquipment[1] = 1;
    if (Instr(newEquip, "Heavy Pistol") != -1)    	SelectedEquipment[2] = 1;
    // Weapons
    if (Instr(newEquip, "Random Weapon") != -1)  	SelectedEquipment[RandRange(3,10)] = 1;
    if (Instr(newEquip, "Light Akimbos") != -1)		SelectedEquipment[3] = 1;
    if (Instr(newEquip, "Meduim Akimbos") != -1)	SelectedEquipment[4] = 1;
    if (Instr(newEquip, "Heavy Akimbos") != -1)		SelectedEquipment[5] = 1;
    if (Instr(newEquip, "Sub Machinegun") != -1)	SelectedEquipment[6] = 1;
    if (Instr(newEquip, "Assault Rifle") != -1)    SelectedEquipment[7] = 1;
    if (Instr(newEquip, "Shotgun") != -1)    		SelectedEquipment[8] = 1;
    if (Instr(newEquip, "HandCannon") != -1)    	SelectedEquipment[9] = 1;
    if (Instr(newEquip, "Sniper Rifle") != -1)    	SelectedEquipment[10] = 1;
	// Items
	if (Instr(newEquip, "Random Item") != -1)    	SelectedEquipment[RandRange(11,15)] = 1;
    if (Instr(newEquip, "Armour Vest") != -1)    	SelectedEquipment[11] = 1;
    if (Instr(newEquip, "Bandolier") != -1)    		SelectedEquipment[12] = 1;
    if (Instr(newEquip, "Stealth Slippers") != -1) SelectedEquipment[13] = 1;
    if (Instr(newEquip, "Night Vison") != -1)    	SelectedEquipment[14] = 1;
    if (Instr(newEquip, "Laser Sight") != -1)    	SelectedEquipment[15] = 1;
    if (Instr(newEquip, "Silencer") != -1)    	   SelectedEquipment[16] = 1;
    if (Instr(newEquip, "Frag Grenade") != -1)    	SelectedEquipment[17] = 1;

    for (i = 0; i <= 15; i++)
        Log ("PAY - SelectedEquipment["$i$"] = "$ SelectedEquipment[i]);
}

///////////////////
// Action stunts //
///////////////////

// Gonna use a state to stop all the functions we dont want
state PawnDiving
{
      function bool Dodge(eDoubleClickDir DoubleClickMove){ return false; };
}

// Implemented in child class
function PlayGotoProne()
{
//    if( !HasAnim( 'GoProne' ) ) LinkSkelAnim( MeshAnimation'HeroMaleB.BullitMale' );
	PlayAnim('GoProne',,0.1);
}

function PlayRightDive()
{
// if( !HasAnim( 'DiveRSm' ) ) LinkSkelAnim( MeshAnimation'HeroMaleB.BullitMale' );
	//TODO: 1 and 2 handed anims
	PlayAnim('DiveRSm',,0.1);
}

function PlayLeftDive()
{
	//TODO: 1 and 2 handed anims
	PlayAnim('DiveLSm',,0.1);
}

function PlayProne()
{
	LoopAnim('ProneIdle',,0.1);
}

function PlayLeftProne()
{
	LoopAnim('ProneIdle',,0.1);
}

function PlayRightProne()
{
	LoopAnim('ProneIdle',,0.1);
}

function TweenProne()
{
/*	ViewRotation.Pitch = ViewRotation.Pitch & 65535;

	if( (ViewRotation.Pitch > RotationRate.Pitch)
		&& (ViewRotation.Pitch < 65536 - RotationRate.Pitch) )
	{
		if(ViewRotation.Pitch < 32768)
		{
			if ( (Weapon == None) || (Weapon.Mass < 20) )
				TweenAnim('ProneUpSm', 0.3);
			else
				TweenAnim('ProneUpLg', 0.3);
		}
		else
		{
			if( ( Weapon == None) || (Weapon.Mass < 20) )
				TweenAnim('ProneDnSm', 0.3);
			else
				TweenAnim('ProneDnLg', 0.3);
		}
	}*/
}

function PlayBackDive()
{
	// TODO: one and two hand anims
	if( !HasAnim( 'Back_Dive_One' ) )
    {
     log ("PAY - Linking");
//     LinkSkelAnim( MeshAnimation'HeroMaleB.BullitMale' );
    }
	PlayAnim('Back_Dive_One',,0.1);
}

function PlayGetUp()
{
	PlayAnim('ProneStand',,0.1);
}

function PlayBackGetUp()
{
	// TODO: One and Two Handed anims
	PlayAnim('BackStandSm',,0.1);
}

function PlayLeftGetUp()
{
	// TODO: One and Two Handed anims
	PlayAnim('BackStandSm',,0.1);
}

function PlayRightGetUp()
{
	// TODO: One and Two Handed anims
	PlayAnim('BackStandSm',,0.1);
}

function PlayForwardDive()
{
    if( !HasAnim( 'Forward_Dive_One' ) )
    {
     log ("PAY - Linking");
//     LinkSkelAnim( MeshAnimation'HeroMaleB.BullitMale' );
    }

        if (self.HasAnim('Forward_Dive_One'))
           Log ("PAY - Found forward dive anim");
        else
            Log ("Pay - No forward dive anim found");

	// TODO: Implement one and two handed dives
	PlayAnim('Forward_Dive_One',,0.1);
}


function PlayRightRoll(){}
function PlayLeftRoll(){}

////////////////////////
// Standard UT stunts //
////////////////////////

function DoDoubleJump( bool bUpdating )
{
  Super.DoDoubleJump(bUpdating);

  stamina -= 30;
}

function bool CanDoubleJump()
{
	return ( (MultiJumpRemaining > 0) && (Physics == PHYS_Falling)
            && (stamina > 0) && (!bLegDamage));
}

function bool Dodge(eDoubleClickDir DoubleClickMove)
{

  log ("PAY stamina = "$stamina);
  if (stamina <= 0)
     return false;

  stamina -= 10;
  log ("Pay new stamina = "$stamina);
  Super.Dodge(DoubleClickMove);

}

////////////////////
// End Stunt Code //
////////////////////


defaultproperties
{
   FlashlightOffset=(X=-50,Y=0,Z=2)
   bFlashlightOn=false
   stamina=100
   staminarecoveryspeed=0.2

   // Equipment first as they can have a bearing on weapons/ammo
   RequiredEquipment(0)="MagnumWeapons.MagnumFists"
   RequiredEquipment(4)="MagnumWeapons.mFragGrenade"
   // Then pistols
   RequiredEquipment(3)="MagnumWeapons.mKnife"
   RequiredEquipment(1)="MagnumWeapons.MagnumPistol9mm"
   // Then special items
   RequiredEquipment(2)="MagnumWeapons.MagnumLaserSight"

	OptionalEquipment(0)="MagnumWeapons.mKnife"
	OptionalEquipment(1)="MagnumWeapons.MagnumPistol9mm"
	OptionalEquipment(2)="MagnumWeapons.MagnumPistol9mm"
	OptionalEquipment(3)="MagnumWeapons.MagnumPistol9mm"
	OptionalEquipment(4)="MagnumWeapons.MagnumPistol9mm"
	OptionalEquipment(5)="MagnumWeapons.MagnumPistol9mm"
	OptionalEquipment(6)="MagnumWeapons.MagnumMp5a"
	OptionalEquipment(7)="MagnumWeapons.MagnumAssaultRifle"
   OptionalEquipment(8)="MagnumWeapons.MagnumShotgun"
   OptionalEquipment(9)="MagnumWeapons.MagnumHandCannon"
	OptionalEquipment(10)="MagnumWeapons.MagnumMp5a"
   OptionalEquipment(11)="MagnumGame.MagnumVest"
   OptionalEquipment(12)="MagnumGame.MagnumBandolier"
   OptionalEquipment(13)="MagnumGame.MagnumStealthSlippers"
   OptionalEquipment(14)="MagnumGame.MagnumNVG"
   OptionalEquipment(15)="MagnumWeapons.MagnumLaserSight"
   OptionalEquipment(16)="MagnumWeapons.mFragGrenade"
   OptionalEquipment(17)="MagnumWeapons.MagnumMp5a"

   	MaxFallSpeed=+700.0

	bNetNotify=true

//    DamageDirReduction=30.0
//    DamageDirLimit=0.5

    // default everything to juggmaleaa
    Mesh=Mesh'HeroMaleB.BullitMale'
//    Skins(0)=Texture'PlayerSkins.JuggMaleABodyA'
//    Skins(1)=Texture'PlayerSkins.JuggMaleAHeadA'
    Species=class'SPECIES_Jugg'
//    SoundGroupClass=class'xJuggMaleSoundGroup'
    GibGroupClass=class'xJuggGibGroup'

    bStatic=False
    DrawScale=1.0

    Buoyancy=+00099.000000
    UnderWaterTime=+00020.000000
    bCanStrafe=True
    DrawType=DT_Mesh
    Style=STY_Normal
    LightBrightness=255
    LightHue=204
    LightSaturation=0
    LightRadius=3
    RotationRate=(Pitch=3072,Yaw=20000,Roll=2048)

    BloodEffect=class'MagnumBloodJet'
    LowGoreBlood=class'AlienSmallHit'
    AirControl=+0.35
    bStasis=false
    bCanCrouch=true
    bCanClimbLadders=True
    bCanPickupInventory=True
    WalkingPct=+0.4

    BaseEyeHeight=30.0
    EyeHeight=30.0
    CollisionRadius=25.0
    CollisionHeight=44.0
    GroundSpeed=380.0
    AirSpeed=380.0
    WaterSpeed=290.0
    DodgeSpeedFactor=1.5
    DodgeSpeedZ=210.0
    AccelRate=2048.0
    JumpZ=340.0
    CrouchHeight=29.0
    CrouchRadius=25.0

    LODBias=1.8

    SoundFootsteps(0)=Sound'PlayerSounds.Final.FootstepDefault'
    SoundFootsteps(1)=Sound'PlayerSounds.Final.FootstepRock'
    SoundFootsteps(2)=Sound'PlayerSounds.Final.FootstepDirt'
    SoundFootsteps(3)=Sound'PlayerSounds.Final.FootStepMetal'
    SoundFootsteps(4)=Sound'PlayerSounds.Final.FootstepWood'
    SoundFootsteps(5)=Sound'PlayerSounds.Final.FootstepPlant'
    SoundFootsteps(6)=Sound'PlayerSounds.Final.FootstepFlesh'
    SoundFootsteps(7)=Sound'PlayerSounds.Final.FootstepIce'
    SoundFootsteps(8)=Sound'PlayerSounds.Final.FootstepSnow'
    SoundFootsteps(9)=Sound'PlayerSounds.Final.FootstepWater'
    SoundFootsteps(10)=Sound'PlayerSounds.Final.FootstepGlass'

    MinTimeBetweenPainSounds=0.75
    ScaleGlow=1.0
    AmbientGlow=20

    GibCountCalf=4
    GibCountForearm=2
    GibCountHead=2
    GibCountTorso=2
    GibCountUpperArm=2

    bDoTorsoTwist=true

    bActorShadows=true
    bPlayerShadows=true

        RagdollLifeSpan=13
	RagDeathVel=200
	RagInvInertia=4
	RagShootStrength=8000
	RagSpinScale=2.5
	RagDeathUpKick=150

  	Begin Object Class=KarmaParamsSkel Name=PawnKParams
		KFriction=0.6
		KRestitution=0.3
		KAngularDamping=0.05
		KLinearDamping=0.15
		KBuoyancy=1
		KStartEnabled=True
		KImpactThreshold=500
		KVelDropBelowThreshold=50
		KConvulseSpacing=(Min=0.5,Max=2.2)
		bHighDetailOnly=False
        Name="PawnKParams"
    End Object
    KParams=KarmaParams'PawnKParams'

	RagImpactSounds(0)=sound'GeneralImpacts.Breakbone_01'
	RagImpactSounds(1)=sound'GeneralImpacts.Breakbone_02'
	RagImpactSounds(2)=sound'GeneralImpacts.Breakbone_03'
	RagImpactSounds(3)=sound'GeneralImpacts.Breakbone_04'

	RagImpactVolume=2.5
	RagImpactSoundInterval=0.5

	VoiceType="xGame.MercMaleVoice"

	RootBone="Bip01"
	HeadBone="Bip01 Head"
	SpineBone1="Bip01 Spine1"
	SpineBone2="Bip01 Spine2"
	FireRootBone="Bip01 Spine"

	GruntVolume=0.18
	FootstepVolume=0.15

	bPhysicsAnimUpdate=true
    MovementAnims(0)=RunF
    MovementAnims(1)=RunB
    MovementAnims(2)=RunL
    MovementAnims(3)=RunR
    SwimAnims(0)=SwimF
    SwimAnims(1)=SwimB
    SwimAnims(2)=SwimL
    SwimAnims(3)=SwimR
    CrouchAnims(0)=CrouchF
    CrouchAnims(1)=CrouchB
    CrouchAnims(2)=CrouchL
    CrouchAnims(3)=CrouchR
    WalkAnims(0)=WalkF
    WalkAnims(1)=WalkB
    WalkAnims(2)=WalkL
    WalkAnims(3)=WalkR
    AirStillAnim=Jump_Mid
    AirAnims(0)=JumpF_Mid
    AirAnims(1)=JumpB_Mid
    AirAnims(2)=JumpL_Mid
    AirAnims(3)=JumpR_Mid
    TakeoffStillAnim=Jump_Takeoff
    TakeoffAnims(0)=JumpF_Takeoff
    TakeoffAnims(1)=JumpB_Takeoff
    TakeoffAnims(2)=JumpL_Takeoff
    TakeoffAnims(3)=JumpR_Takeoff
    LandAnims(0)=JumpF_Land
    LandAnims(1)=JumpB_Land
    LandAnims(2)=JumpL_Land
    LandAnims(3)=JumpR_Land
    DoubleJumpAnims(0)=DoubleJumpF
    DoubleJumpAnims(1)=DoubleJumpB
    DoubleJumpAnims(2)=DoubleJumpL
    DoubleJumpAnims(3)=DoubleJumpR
    DodgeAnims(0)=DodgeF
    DodgeAnims(1)=DodgeB
    DodgeAnims(2)=DodgeL
    DodgeAnims(3)=DodgeR
    WallDodgeAnims(0)=WallDodgeF
    WallDodgeAnims(1)=WallDodgeB
    WallDodgeAnims(2)=WallDodgeL
    WallDodgeAnims(3)=WallDodgeR

    TurnRightAnim=TurnR
    TurnLeftAnim=TurnL
    CrouchTurnRightAnim=Crouch_TurnR
    CrouchTurnLeftAnim=Crouch_TurnL
    IdleRestAnim=Idle_Rest
    IdleCrouchAnim=Crouch
    IdleSwimAnim=Swim_Tread
    IdleWeaponAnim=Idle_Rifle
    IdleHeavyAnim=Idle_Biggun
    IdleRifleAnim=Idle_Rifle
    FireHeavyRapidAnim=Biggun_Burst
    FireHeavyBurstAnim=Biggun_Aimed
    FireRifleRapidAnim=Rifle_Burst
    FireRifleBurstAnim=Rifle_Aimed
    PlacedCharacterName="Mook"

    ControllerClass=class'MagnumEngine.MagnumBot'

}
/*
   OptionalEquipment(0)="MagnumWeapons.Knives"
   OptionalEquipment(1)="MagnumWeapons.LightPistol"
   OptionalEquipment(2)="MagnumWeapons.MediumPistol"
   OptionalEquipment(3)="MagnumWeapons.HeavyPistol"
   OptionalEquipment(4)="MagnumWeapons.LightAkimbo"
   OptionalEquipment(5)="MagnumWeapons.MeduimAkimbo"
   OptionalEquipment(6)="MagnumWeapons.HeavyAkimbo"
   OptionalEquipment(7)="MagnumWeapons.SubMachineGun"
   OptionalEquipment(8)="MagnumWeapons.AssaultRifle"
   OptionalEquipment(9)="MagnumWeapons.Shotgun"
   OptionalEquipment(10)="MagnumWeapons.HandCannon"
   OptionalEquipment(11)="MagnumWeapons.SniperRifle"
   OptionalEquipment(12)="MagnumWeapons.Bandolier"
   OptionalEquipment(13)="MagnumWeapons.Slippers"
   OptionalEquipment(14)="MagnumWeapons.ArmourVest"
   OptionalEquipment(15)="MagnumWeapons.NightVision"
   OptionalEquipment(16)="MagnumWeapons.FragGrenade"
*/
