/*******************************************************************************
Action HUD.  Has clips and shows Special Items.
********************************************************************************/
class MagnumHUD extends HudBTeamDeathMatch;

var() NumericWidget ClipCount;
var transient float CurClips;

var() SpriteWidget ItemIcon;

var() SpriteWidget StaminaFill;
var() SpriteWidget StaminaTeamTint;
var() SpriteWidget StaminaTrim;

simulated function CalculateAmmo()
{
    MaxAmmoPrimary = 1;
    CurAmmoPrimary = 1;
    CurClips = 0;

    if ( (PawnOwner != none) && (PawnOwner.Weapon != none) )
		PawnOwner.Weapon.GetAmmoCount(MaxAmmoPrimary,CurAmmoPrimary);
    RHud2[2].Scale = CurAmmoPrimary / MaxAmmoPrimary;

    if ( (PawnOwner != none) && (PawnOwner.Weapon != none) && PawnOwner.Weapon.IsA('MagnumWeapon') )
	{
    	 MagnumWeapon(PawnOwner.Weapon).GetCurrentClipSize(CurAmmoPrimary);
    	 MagnumWeapon(PawnOwner.Weapon).GetClips(CurClips);
    }

}

simulated function UpdateHud()
{
/*    if ((PawnOwnerPRI != none) && (PawnOwnerPRI.Team != None))
        TeamIndex = Clamp (PawnOwnerPRI.Team.TeamIndex, 0, 1);
    else
        TeamIndex = 1; // Default to the blue HUD because it's sexier

    // Update values ===============================================================================

    CalculateScore();
    // Score.Value = CurScore;

    CalculateHealth();
    CalculateShield();
    ShieldCount.Value = CurShield;

    CalculateEnergy();
    Adrenaline[2].Scale = CurEnergy / MaxEnergy;
    if(CurEnergy == MaxEnergy)
        AdrenalineReady = true;
    else
        AdrenalineReady = false;
  */
    CalculateAmmo();
    AmmoCount.Value = CurAmmoPrimary;
    ClipCount.Value = CurClips;

/*    if(!TeamLinked)
    {
        RHud2[3].Tints[TeamIndex].R = 255 - ( 255 * ( FClamp( CurAmmoPrimary / MaxAmmoPrimary, 0.0, 1.0) ));
        RHud2[3].Tints[TeamIndex].G = ( 255 * ( FClamp( CurAmmoPrimary / MaxAmmoPrimary, 0.0, 1.0) ));
        RHud2[3].Tints[TeamIndex].B = 0;
    }*/
    Super.UpdateHud ();
}

// Alpha Pass ==================================================================================
simulated function DrawHudPassA (Canvas C)
{
    super.DrawHudPassA(C);

    if( (MagnumPawn(PawnOwner).SpecialItem != None) && (MagnumPawn(PawnOwner).SpecialItem.IconMaterial != None) )
    {
        ItemIcon.WidgetTexture = MagnumPawn(PawnOwner).SpecialItem.IconMaterial;
        ItemIcon.TextureCoords = MagnumPawn(PawnOwner).SpecialItem.IconCoords;
        DrawSpriteWidget (C, ItemIcon);
    }

    // Stamina bar
    StaminaFill.Scale = FClamp(MagnumPawn(PawnOwner).Stamina / MagnumPawn(PawnOwner).default.stamina, 0.0, 1.0);

    DrawSpriteWidget (C, StaminaFill);
    DrawSpriteWidget (C, StaminaTeamTint);
    DrawSpriteWidget (C, StaminaTrim);
}

simulated function DrawHudPassC (Canvas C)
{
	local float PortraitWidth,PortraitHeight, XL, YL, Abbrev;
	local string PortraitString;

	// portrait
	if ( bShowPersonalInfo && (Portrait != None) )
	{
		PortraitWidth = 0.125 * C.ClipY;
		PortraitHeight = 1.5 * PortraitWidth;
		C.DrawColor = WhiteColor;

		C.SetPos(-PortraitWidth*PortraitX + 0.025*PortraitWidth,0.5*(C.ClipY-PortraitHeight) + 0.025*PortraitHeight);
		C.DrawTile( Portrait, PortraitWidth, PortraitHeight, 0, 0, 256, 384);

		C.SetPos(-PortraitWidth*PortraitX,0.5*(C.ClipY-PortraitHeight));
		C.Font = GetFontSizeIndex(C,-2);
		PortraitString = PortraitPRI.PlayerName;
		C.StrLen(PortraitString,XL,YL);
		if ( XL > PortraitWidth )
		{
			C.Font = GetFontSizeIndex(C,-3);
			C.StrLen(PortraitString,XL,YL);
			if ( XL > PortraitWidth )
			{
				Abbrev = float(len(PortraitString)) * PortraitWidth/XL;
				PortraitString = left(PortraitString,Abbrev);
				C.StrLen(PortraitString,XL,YL);
			}
		}

		C.DrawColor = C.static.MakeColor(160,160,160);
		C.SetPos(-PortraitWidth*PortraitX + 0.025*PortraitWidth,0.5*(C.ClipY-PortraitHeight) + 0.025*PortraitHeight);
		C.DrawTile( Material'XGameShaders.ModuNoise', PortraitWidth, PortraitHeight, 0.0, 0.0, 512, 512 );

		C.DrawColor = WhiteColor;
		C.SetPos(-PortraitWidth*PortraitX,0.5*(C.ClipY-PortraitHeight));
		C.DrawTileStretched(texture 'InterfaceContent.Menu.BorderBoxA1', 1.05 * PortraitWidth, 1.05*PortraitHeight);

		C.DrawColor = WhiteColor;
		C.SetPos(C.ClipY/256-PortraitWidth*PortraitX + 0.5 * (PortraitWidth - XL),0.5*(C.ClipY+PortraitHeight) + 0.06*PortraitHeight);
		if ( PortraitPRI != None )
		{
			if ( PortraitPRI.Team != None )
			{
				if ( PortraitPRI.Team.TeamIndex == 0 )
					C.DrawColor = RedColor;
				else
					C.DrawColor = TurqColor;
			}
			C.DrawText(PortraitString,true);
		}
	}

    // Screen
    if( bShowPersonalInfo )
    {
        DrawSpriteWidget (C, LHud1[0]);
        DrawSpriteWidget (C, LHud2[0]);
        DrawSpriteWidget (C, LHud1[3]);
        DrawSpriteWidget (C, LHud2[3]);
    }
    ShowPointBarTop(C);

    if( bShowPersonalInfo )
    {
        DrawSpriteWidget (C, Adrenaline[0]);
        DrawSpriteWidget (C, Adrenaline[3]);
        DrawSpriteWidget (C, Adrenaline[4]);
        DrawNumericWidget (C, AdrenalineCount, DigitsBig);
        DrawSpriteWidget (C, AdrenalineIcon);

		if( PawnOwner.IsA ('XPawn') && (XPawn(PawnOwner).UDamageTime > Level.TimeSeconds) )
		{
			UDamageFill.Scale = FMin((XPawn(PawnOwner).UDamageTime - Level.TimeSeconds) * 0.0333,1);

			DrawSpriteWidget (C, UDamageFill);
			DrawSpriteWidget (C, UDamageTeamTint);
			DrawSpriteWidget (C, UDamageTrim);
		}
        DrawSpriteWidget (C, HealthIcon);

		if( ShieldCount.Value > 0 )
		{
			DrawSpriteWidget (C, ShieldIcon);
			DrawNumericWidget (C, ShieldCount, DigitsBig);
		}

        DrawNumericWidget (C, HealthCount, DigitsBig);
	}

    UpdateRankAndSpread(C);

    if( bShowWeaponInfo && (PawnOwner != None) && (PawnOwner.Weapon != None) )
    {
        DrawNumericWidget (C, AmmoCount, DigitsBig);
        DrawNumericWidget (C, ClipCount, DigitsBig);
		PawnOwner.Weapon.DrawWeaponInfo(C);
    }

    DrawCrosshair(C);
}
/*******************************************************************************
    Author:    Jeff Giles
    Creation date:  20/10/02
    Description:
*******************************************************************************/
function DrawHUD(Canvas c)
{
         // Draw the nvg flicker
/*         if ((MagnumPawn(PawnOwner) != None) &&
             (MagnumPawn(PawnOwner).SpecialItem != None) &&
             (MagnumPawn(PawnOwner).SpecialItem.IsA('MagnumNVG')) &&
             (MagnumPawn(PawnOwner).SpecialItem.bActive == true))
         {*/
             c.Style = 255;
             c.SetPos(0,0);
             c.DrawColor = class'Canvas'.static.MakeColor(200,80,80);
             c.DrawTile( Material'ScreenNoiseFB', c.SizeX, c.SizeY, 0.0, 0.0, 512, 512 );
             
             PawnOwner.bDynamicallyLit = true;
             PawnOwner.LightRadius = 64;

//        }

// then do all other hud stuff
    super.DrawHUD(c);
}
exec function behindV()
{
    playerowner.bbehindview= !playerowner.bbehindview;
}

function PostRender(canvas c)
{
    super.PostRender(c);
    //playerowner.bBehindView=true;
}

defaultproperties
{
    AmmoCount=(TextureScale=0.25,DrawPivot=DP_UpperRight,PosX=1,PosY=0.835,OffsetX=-340,OffsetY=95,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
	ClipCount=(TextureScale=0.25,DrawPivot=DP_UpperRight,PosX=1,PosY=0.835,OffsetX=-145,OffsetY=95,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))

	ItemIcon=(TextureScale=0.45,DrawPivot=DP_UpperLeft,PosX=1.0,PosY=0.75,OffsetX=-151,OffsetY=44,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))

    StaminaTrim=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=450,Y1=415,X1=836,Y2=453),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.0,OffsetX=0,OffsetY=120,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    StaminaTeamTint=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=450,Y1=454,X1=836,Y2=490),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.0,OffsetX=0,OffsetY=120,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=100,G=0,B=0,A=100),Tints[1]=(R=37,G=66,B=102,A=150))
    StaminaFill=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=450,Y1=454,X1=836,Y2=490),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.0,OffsetX=0,OffsetY=120,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
}
