// ====================================================================
//  Class:  MagnumInterface.MagnumChangeEquipmentMenu
//  Parent: XInterface.GUIPage
//
//  <Enter a description here>
// ====================================================================

class MagnumChangeEquipmentMenu extends GUIPage;

var		float ButtonWidth;
var		float ButtonHeight;
var		float ButtonHGap;
var		float ButtonVGap;
var		float BarHeight;
var		float BarVPos;

var		int PistolStart;
var		int WeaponStart;
var		int ItemStart;
var		int ListEnd;

var		GUIListBox PistolList;
var		GUIListBox WeaponList;
var		GUIListBox ItemList;

var Array<string>  WeaponNames;
const MAX_WEAPONS = 25;

function InitComponent(GUIController MyController, GUIComponent MyOwner)
{
    local float leftpos, midpos, rightpos, hpos;
    local int i;

	Super.InitComponent(MyController, MyOwner);

//    OnClose = InternalOnClose;

	// Bar
	Controls[0].WinHeight = BarHeight;
	Controls[0].WinWidth = 1.0;
	Controls[0].WinTop = BarVPos - (0.5 * BarHeight);
	Controls[0].Winleft = 0.0;

    // Cancel button
    Controls[2].WinTop = Controls[0].WinWidth - (ButtonHeight + ButtonHGap);
    // Done button
    Controls[1].WinTop = Controls[2].WinTop - (ButtonHeight + ButtonHGap);

	leftpos =  0.5 - (1.5 * ButtonWidth) - ButtonHGap;
    midpos =   0.5 - (0.5 * ButtonWidth);
    rightpos = 0.5 + (0.5 * ButtonWidth) + ButtonHGap;

    // Set button pos
    // Pistol
    hpos = BarVPos - (0.5 * ButtonVGap) - (ButtonHeight*2);

	PistolList = GUIListBox(Controls[3]);
    Controls[3].WinLeft = leftpos;
	Controls[3].WinWidth =    ButtonWidth;

	WeaponList = GUIListBox(Controls[4]);
	Controls[4].WinLeft = midpos;
   	Controls[4].WinWidth =    ButtonWidth;

	ItemList = GUIListBox(Controls[5]);
    Controls[5].WinLeft = rightpos;
   	Controls[5].WinWidth =    ButtonWidth;

	// Fill the lists

    // Pistols

    for (i = 0; i < 14; i++)
        Log ("Pay - Menu says AllowedWeapons["$i$"] = "$ MagnumGameReplicationInfo(PlayerOwner().GameReplicationInfo).AllowedWeapons[i]);

    for (i = 0; i < 4; i++)
        if (MagnumGameReplicationInfo(PlayerOwner().GameReplicationInfo).AllowedWeapons[i] == 1)
            PistolList.List.Add(WeaponNames[i]);

    for (i = 4; i < 13; i++)
        if (MagnumGameReplicationInfo(PlayerOwner().GameReplicationInfo).AllowedWeapons[i] == 1)
            WeaponList.List.Add(WeaponNames[i]);

    for (i = 13; i < 22; i++)
        if (MagnumGameReplicationInfo(PlayerOwner().GameReplicationInfo).AllowedWeapons[i] == 1)
            ItemList.List.Add(WeaponNames[i]);

}

function InternalOnClose(optional Bool bCanceled)
{
	local PlayerController pc;

    Log ("Pay - Internal On Close");

	pc = PlayerOwner();

	// Turn pause off if currently paused
	if(pc != None && pc.Level.Pauser != None)
		pc.SetPause(false);

	Super.OnClose(bCanceled);
}

function bool InternalOnClick(GUIComponent Sender)
{
	if(Sender==Controls[1]) // Done and accept changes
	{
		SetUpEquipment();

		if (Controller.MenuStack.Length > 1)
		  Controller.CloseMenu();
	    else
		  Controller.CloseAll(false);
	}
	else if(Sender==Controls[2])  // Cancel button
	{
        if (Controller.MenuStack.Length > 1)
		  Controller.CloseMenu();
	    else
		  Controller.CloseAll(false);
	}

	return true;
}

function SetUpEquipment()
{
	// This function basically fills out the selected equipment array with the items the player selected.
	// The MagnumPlayer object will then load them when they spawn.

    Local int SelectedEquipment[16];

	switch (PistolList.List.Get())
	{
		case "Random":
        		// Set up some random code
                Log ("PAY - Pistol = Random");
      	        SelectedEquipment[RandRange(1,3)] = 1;
                //UnrealPawn(PlayerOwner().Pawn).SelectedEquipment[RANDOMNUMBER] = 1;
        		break;
        case "Light Pistol":
                Log ("PAY - Pistol = light");
                SelectedEquipment[1] = 1;
        		break;
        case "Medium Pistol":
		        Log ("PAY - Pistol = meduim");
                SelectedEquipment[2] = 1;
        		break;
        case "Heavy Pistol":
		        Log ("PAY - Pistol = heavy");
                SelectedEquipment[3] = 1;
        		break;
    }


	switch (WeaponList.List.Get())
	{
		case "Random":
        		// Set up some random code
       	        Log ("PAY - item = random");
       	        SelectedEquipment[RandRange(4,11)] = 1;
                //UnrealPawn(PlayerOwner().Pawn).SelectedEquipment[RANDOMNUMBER] = 1;
        		break;
        case "Light Akimbos":
		        Log ("PAY - weapon = light a");
                SelectedEquipment[4] = 1;
        		break;
        case "Medium Akimbos":
		        Log ("PAY - weapon = meduim a");
                SelectedEquipment[5] = 1;
        		break;
        case "Heavy Akimbos":
		        Log ("PAY - weapon = heavy a");
                SelectedEquipment[6] = 1;
        		break;
        case "Sub Machinegun":
		        Log ("PAY - weapon = smg");
                SelectedEquipment[7] = 1;
        		break;
        case "Assault Rifle":
		        Log ("PAY - weapon = assault rifle");
                SelectedEquipment[8] = 1;
        		break;
        case "Shotgun":
		        Log ("PAY - weapon = shotgun");
                SelectedEquipment[9] = 1;
        		break;
	    case "Hand-Cannon":
		        Log ("PAY - weapon = HC");
                SelectedEquipment[10] = 1;
        		break;
  	    case "Sniper Rifle":
		        Log ("PAY - weapon = sniper");
                SelectedEquipment[11] = 1;
        		break;

    }

   	switch (ItemList.List.Get())
	{
		case "Random":
        		// Set up some random code
       	        Log ("PAY - item = random");
       	        SelectedEquipment[RandRange(12,15)] = 1;
                // UnrealPawn(PlayerOwner().Pawn).SelectedEquipment[RANDOM NUMBER] = 1;
        		break;
        case "Bandolier":
 		        Log ("PAY - item = bando");
                SelectedEquipment[12] = 1;
        		break;
        case "Stealth Slippers":
       	        Log ("PAY - item = bando");
                SelectedEquipment[13] = 1;
        		break;
        case "Armour Vest":
       	        Log ("PAY - item = armour");
                SelectedEquipment[14] = 1;
        		break;
        case "Night Vision Kit":
       	        Log ("PAY - item = nvg");
                SelectedEquipment[15] = 1;
        		break;
/*        case "Frag Grenade":             		- MagnumPlayer needs to make the seleceted equip list larger
       	        Log ("PAY - item = frag");
                SelectedEquipment[16] = 1;
        		break;                   */
    }

    PlayerOwner().ConsoleCommand("ChangeEquipment "@PistolList.List.Get()@" "@WeaponList.List.Get()@" "@ItemList.List.Get() );
}

defaultproperties
{
	Begin Object Class=GUIButton name=EquipBackground
		bAcceptsInput=false
		bNeverFocus=true
		StyleName="SquareBar"
	End Object
	Controls(0)=GUIButton'EquipBackground'

   	Begin Object Class=GUIButton Name=DoneButton
		Caption="Done"
		StyleName="MidGameButton"
		OnClick=InternalOnClick
	End Object
	Controls(1)=GUIButton'DoneButton'

   	Begin Object Class=GUIButton Name=CancelButton
		Caption="Cancel"
		StyleName="MidGameButton"
		OnClick=InternalOnClick
	End Object
	Controls(2)=GUIButton'CancelButton'

    // Pistols

  	Begin Object Class=GUIListBox Name=PistolScrollList
		WinWidth=0.368359
		WinLeft=0.041406
		WinHeight=0.502696
		WinTop=0.083281
		bVisibleWhenEmpty=true
		StyleName="SquareButton"
		Hint="Select a pistol."
	End Object
	Controls(3)=GUIListBox'PistolScrollList'

    // Weapons

   	Begin Object Class=GUIListBox Name=WeaponsScrollList
		WinWidth=0.368359
		WinLeft=0.041406
		WinHeight=0.502696
		WinTop=0.083281
		bVisibleWhenEmpty=true
		StyleName="SquareButton"
		Hint="Select a weapon."
	End Object
	Controls(4)=GUIListBox'WeaponsScrollList'

    // Items

   	Begin Object Class=GUIListBox Name=ItemScrollList
		WinWidth=0.368359
		WinLeft=0.041406
		WinHeight=0.502696
		WinTop=0.083281
		bVisibleWhenEmpty=true
		StyleName="SquareButton"
		Hint="Select an item."
	End Object
	Controls(5)=GUIListBox'ItemScrollList'

  	ButtonWidth=0.27
	ButtonHeight=0.04
	ButtonHGap=0.02
	ButtonVGap=0.02
	BarHeight=1
	BarVPos=0.5

	PistolStart=2;
	WeaponStart=5;
	ItemStart=12;
	ListEnd=12;

	WeaponNames(0)="Random Pistol"
	WeaponNames(1)="Light Pistol"
	WeaponNames(2)="Medium Pistol"
	WeaponNames(3)="Heavy Pistol"
	WeaponNames(4)="Random Weapon"
	WeaponNames(5)="Light Akimbos"
	WeaponNames(6)="Medium Akimbos"
	WeaponNames(7)="Heavy Akimbos"
	WeaponNames(8)="Sub Machinegun"
	WeaponNames(9)="Assault Rifle"
	WeaponNames(10)="Shotgun"
	WeaponNames(11)="HandCannon"
	WeaponNames(12)="Sniper Rifle"
	WeaponNames(13)="Random Item"
	WeaponNames(14)="Bandolier"
	WeaponNames(15)="Stealth Slippers"
	WeaponNames(16)="Armour Vest"
	WeaponNames(17)="Night Vision Kit"
	WeaponNames(18)="Laser Sight"
	WeaponNames(19)="Silencer"
	WeaponNames(20)="Holster"
	WeaponNames(21)="Frag Grenade"

	bAllowedAsLast=true
}
