
library RIPPlug;

uses
  Windows, SysUtils;

{
  --------------------------------
  PlugIn system for RIPcoder v1.00
  --------------------------------

  You can build your plugins for use it in RIPcoder.
  This example is "simple replacement method".
  This is not strong method of encryption, it's just a demo of
  "how to make plugin for RIPcoder".

}

const
 PlugName 	  = 'Simple replacement';
 PlugVersion 	  = '1.0';
 maxMoves         = 1000;

var
 pwd	: array of byte;
 pwdsz	: dword;

function PlugIn_Name: pchar; stdcall;
begin
 result := PlugName;
end;

function PlugIn_Version: pchar; stdcall;
begin
 result := PlugVersion;
end;

{
  RIPcoder install plugin by calling "pg_InitPlugIn"
}
function pg_InitPlugIn: bool; stdcall;
begin
 { this is place for initialization }
 result := true;
end;

{
  RIPcoder uninstall plugin by calling "pg_ClosePlugIn"
}
procedure pg_ClosePlugIn; stdcall;
begin
 { this is place for finalization }
 if pwdsz>0 then setlength(pwd,0);
end;

{
  RIPcoder send password for plugin.
  Password sends each time before encryption/decryption.
}
procedure pg_GetPassword(ipwd: pchar); stdcall;
begin
 pwdsz := strlen(ipwd);
 setlength(pwd,pwdsz);
 move(ipwd[0],pwd[0],pwdsz);
end;

{
  RIPcoder gives plugin to work with source data divided by
  many blocks, block size may differ
}

procedure pg_EncodeBlock(var bf: array of byte;count: dword); stdcall;
var
 i,j,
 p1,p2        : dword;
 sb           : byte;

procedure pwdAdd;
begin
 inc(j); if j=pwdsz then j := 0;
end;

begin
 randseed := count;
 j := 0;
 for i:=1 to MaxMoves do
  begin
  p1 := random(count); { unsafe place, I do not recomment to use random }
  p2 := count-p1-1;
  sb := bf[p1];
  bf[p1] := bf[p2]+pwd[j]; pwdAdd;
  bf[p2] := sb-pwd[j]; pwdAdd;
  end;
end;

procedure pg_DecodeBlock(var bf: array of byte;count: dword); stdcall;
var
 i,j,
 p1,p2        : dword;
 sb           : byte;
 lnx          : array of dword;

procedure pwdAdd;
begin
 inc(j); if j=pwdsz then j := 0;
end;

begin
 randseed := count;
 j := 0;
 setlength(lnx,MaxMoves);
 for i:=0 to MaxMoves-1 do
  lnx[i] := random(count);

 for i:=MaxMoves downto 1 do
  begin
  p1 := lnx[pred(i)];
  p2 := count-p1-1;
  sb := bf[p1];
  bf[p1] := bf[p2]+pwd[j]; pwdAdd;
  bf[p2] := sb-pwd[j]; pwdAdd;
  end;
 setlength(lnx,0);
end;

exports
 PlugIn_Name,
 PlugIn_Version,
 pg_InitPlugIn,
 pg_ClosePlugIn,
 pg_GetPassword,
 pg_EncodeBlock,
 pg_DecodeBlock;

end.