// UItoComDoc.h : interface of the CUItoComDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_UITOCOMDOC_H__78954FCA_45B4_11D7_A629_0000E85B5CD9__INCLUDED_)
#define AFX_UITOCOMDOC_H__78954FCA_45B4_11D7_A629_0000E85B5CD9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "vecom.h"

#define BUFFERLEN 1000

struct ThreadParams
{
	HBITMAP m_hBmp;
	int m_pixelPerMeter;
	char* m_settings;
	
};

class CUItoComDoc : public CDocument
{
protected: // create from serialization only
	CUItoComDoc();
	DECLARE_DYNCREATE(CUItoComDoc)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CUItoComDoc)
	public:
	virtual BOOL OnNewDocument();
	//}}AFX_VIRTUAL

// Implementation
public:
	Ivecim* GetVecom();
	void VectorizeInNewThread();
	HBITMAP GetDIB();
	virtual ~CUItoComDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:
	HBITMAP m_hBmp;
	Ivecim * m_pIvecim;
	int m_pixelPerMeter;
	ThreadParams m_threadParams;
	char m_settings[BUFFERLEN];

// Generated message map functions
protected:
	//{{AFX_MSG(CUItoComDoc)
	afx_msg void OnUpdateVectorizeInNewThread(CCmdUI* pCmdUI);
	afx_msg void OnOpenRasterImage();
	afx_msg void OnUpdateMirrowVertically(CCmdUI* pCmdUI);
	afx_msg void OnMirrowVertically();
	afx_msg void OnUpdateRotateLeft(CCmdUI* pCmdUI);
	afx_msg void OnUpdateClean(CCmdUI* pCmdUI);
	afx_msg void OnUpdateConnect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFillHoles(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFillSmallHoles(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNegate(CCmdUI* pCmdUI);
	afx_msg void OnUpdateThicken(CCmdUI* pCmdUI);
	afx_msg void OnUpdateThin(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRotateRight(CCmdUI* pCmdUI);
	afx_msg void OnClean();
	afx_msg void OnConnect();
	afx_msg void OnFillHoles();
	afx_msg void OnFillSmallHoles();
	afx_msg void OnNegate();
	afx_msg void OnRotateLeft();
	afx_msg void OnThicken();
	afx_msg void OnThin();
	afx_msg void OnRotateRight();
	afx_msg void OnUpdateAsBmp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSaveAsTif(CCmdUI* pCmdUI);
	afx_msg void OnSaveAsTif();
	afx_msg void OnAsBmp();
	afx_msg void OnUpdateVectorize(CCmdUI* pCmdUI);
	afx_msg void OnVectorize();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	BOOL readSettings(char *buffer, int buffSize);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_UITOCOMDOC_H__78954FCA_45B4_11D7_A629_0000E85B5CD9__INCLUDED_)
