unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, QzHtmlEdit2, StdCtrls, QzHtmlEditor2, QzHtmlLabel2,
  ComCtrls, QzMiniHtml2, jpeg;

type
  TForm1 = class(TForm)
    QzHtmlLabel21: TQzHtmlLabel2;
    Button1: TButton;
    QzHtmlEditor21: TQzHtmlEditor2;
    Button2: TButton;
    Button3: TButton;
    Image1: TImage;
    Button5: TButton;
    RichEdit2: TRichEdit;
    RichEdit1: TRichEdit;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure QzHtmlLabel21LinkClicked(Sender: TObject; href: String;
      var Handled: Boolean);
    procedure QzHtmlLabel21DynamicUpdate(Sender: TObject;
      dynamicID: String; var Text: String);
    procedure QzHtmlLabel21FormElementClicked(Sender: TObject; fmName,
      fmMethod, fmAction, inputName, inputType, inputValue: String);
    procedure QzHtmlLabel21UserDefinedUpdate(Sender: TObject; itemID,
      ItemType: String; var Width, Height: Integer; var variable1,
      variable2, variable3: String);
    procedure QzHtmlLabel21UserDefinedDraw(Sender: TObject; itemID,
      ItemType: String; Canvas: TCanvas; Rect: TRect; variable1, variable2,
      variable3: String);
    procedure FormShow(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure RichEdit2SelectionChange(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure RichEdit2Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var i : integer;
    t : aTag;
    k : string;
begin
  RichEdit1.Lines.Clear;
  for i := 0 to QzHtmlLabel21.QzMiniHtml2.TagList.Count -1 do
    begin
      t := ATag(QzHtmlLabel21.QzMiniHtml2.TagList.items[i]);
      k := t.GetHtml;
      if (T is AText) then
        RichEdit1.SelAttributes.Color := clBlack else
        RichEdit1.SelAttributes.Color := clGreen;
      RichEdit1.SelText := k;
    end;
 
  RichEdit2.Lines.Clear;
  RichEdit2.Text := QzHtmlLabel21.Html;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  QzHtmlEditor21.Html := QzHtmlLabel21.Html;
  if QzHtmlEditor21.Execute then
    QzHtmlLabel21.Html := QzHtmlEditor21.Html;
end;

procedure TForm1.QzHtmlLabel21LinkClicked(Sender: TObject; href: String;
  var Handled: Boolean);
begin
  showmessage(Href);
  Handled := true;
end;

procedure TForm1.QzHtmlLabel21DynamicUpdate(Sender: TObject;
  dynamicID: String; var Text: String);
begin
  if dynamicId = 'news' then Text := '<p bgcolor="clSilver"><b><font color="clRed">News:</font>Component is now Under <u>MPL/LGPL License</u></b>'+
                                     '<ul>' +
{                                     '<li>' +
                                     'Able to read SelStart/SelLength and draw them as selected (For use in editor)' +
                                     '</li>' +}
                                     '<li>' +
                                     'Restore cursor after clicked on a link ' +
                                     '</li>' +
{                                     '<li>' +
                                     'You can now save the project immediately after using htmleditor. ' +
                                     '</li>' +}
                                     '</ul></p>';

end;
procedure TForm1.QzHtmlLabel21FormElementClicked(Sender: TObject; fmName,
  fmMethod, fmAction, inputName, inputType, inputValue: String);
begin
  if inputType <> 'checkbox' then
  ShowMessage(inputName + ' clicked!');
end;

procedure TForm1.QzHtmlLabel21UserDefinedUpdate(Sender: TObject; itemID,
  ItemType: String; var Width, Height: Integer; var variable1, variable2,
  variable3: String);
begin
  if ItemType='colorbox' then
    begin
       Width := 12;
       Height := 12;
    end;
end;

procedure TForm1.QzHtmlLabel21UserDefinedDraw(Sender: TObject; itemID,
  ItemType: String; Canvas: TCanvas; Rect: TRect; variable1, variable2,
  variable3: String);
begin
  if ItemType='colorbox' then
    begin
      Canvas.Pen.Color := clBlack;
       if Variable1 <> '' then
       Canvas.Brush.Color := WebColor2TColor(Variable1) else
       Canvas.Brush.Color := clLime;
       with Rect do
       Canvas.Rectangle(Left,Top,Right-2,Bottom-2);
    end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  DoubleBuffered := true;
  Button1.Click;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
//  Caption := Inttostr(RichEdit2.SelStart) + ',' + Inttostr(RichEdit2.SelLength);
//  RichEdit2.SetFocus;
end;

procedure TForm1.RichEdit2SelectionChange(Sender: TObject);
var k,l : string;
    i,j : integer;
begin
  with RichEdit2 do
  l := Copy(Text,SelStart+SelLength+1,Length(Text)-SelStart+SelLength);
  i := Pos('<',l);
  j := Pos('>',l);

  if (j >= i) or (i = 0) or (j = 0) then
  begin
  with RichEdit2 do
  k := Copy(Text,0,SelStart)+'<selection>'+
       Richedit2.SelText + '</selection>' + l;
  QzHtmlLabel21.html := k;
  end;
//  QzHtmlLabel21.Html := ;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
if RichEdit2.SelText <> '' then
  RichEdit2.SelText := QzHtmlLabel21.QzMiniHtml2.Bold(RichEdit2.SelText,
                       QzHtmlLabel21.QzMiniHtml2.selectionState);

{  if QzHtmlLabel21.QzMiniHtml2.Selectionstate.Selected then
    if (fsBold in QzHtmlLabel21.QzMiniHtml2.Selectionstate.Font.Style) then
      Showmessage('Select text bolded');}
end;

procedure TForm1.RichEdit2Change(Sender: TObject);
begin
  QzHtmlLabel21.html := RichEdit2.text;
end;

end.
