#!/usr/local/bin/perl

###############################################################################
#
# fixSubjTotals.pl - Fix totals in topics database
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/07/16 20:35:05 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

require "F_Init.pl";

# Get the file name
if (@ARGV[0] eq "") {
	print "usage: $0 class\n";
}

$Class = @ARGV[0];

&lookupClass;

$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FALL";
if (! -e $dbfile) {
	$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FNEW";
}

foreach (`$prtDB $dbfile -tbtree -a -q`) {
	($key, $value) = split(/\t/, $_);
	$value = &UnEscape($value);
	chomp($value);
	@value = split(/\t/, $value);
	
	$totals{"@value[1]"} += 1;
}

################# Update subjects.db for number of posts
$topic = @val[1];
$dbf = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FSUBJ";

foreach (`$prtDB $dbf -tbtree -a -q`) {
	($key, $value) = split(/\t/, $_);
	$value = &UnEscape($value);
	chomp($value);
	@value = split(/\t/, $value);

	if ($totals{"$key"} eq "") {
		$totals{"$key"} = 0;
	}
	@value[6] = $totals{"$key"};

	$val = join("\t", @value);
	@retval = `$setDB $dbf -tbtree -k \"$key\" -d \"$val\"`;
	$status = &dbErrorCheck($?, @retval[0]);
	if ($status) {
		print "$status: Couldn't Update Topics DB ($dbf) for $topic.\n";
	}
}
################# End Update subjects.db
