#!/usr/bin/perl

###############################################################################
#
# _AFUploadDel.cgi - Delete uploads from the Forum
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:53 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFUploadDel.cgi,v 1.11.2.3 2001/08/21 17:50:53 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";

###############################################################################
#
# Process submitted data

$Class = $CGIQuery->param('fid');
$func = $CGIQuery->param('func');
$date = $CGIQuery->param('date');
$age = $CGIQuery->param('age');
$num = $CGIQuery->param('num');

if ($Class eq "") {
	&showErrorHTML("$CorF id not specified");
	exit();
}
	
&lookupClass;
	
&loadColors($ColorQueryString);

&checkCookieGuest($CGIEnvUser, $C_authtype);

if ($CGIEnvUser eq "") {
	&showErrorBackHTML("You are not properly logged in. Please log in and come back.");
	exit();
}

&lookupUser($CGIEnvUser);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !(&IS_FAC($U_Perms) && $C_ModDelete ne "0")) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

# Get the total disk space used by file uploads
if ($func ne "" && $func ne "nothing") {
	$updir = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DIR_FORUMUPLOADS . "/*";
	@files = glob($updir);
	$space = 0;
	foreach $file (@files) {
		$space += -s $file;
	}
}

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

if ($func eq "domsgdel") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doMsgsDel;
	
} elsif ($func eq "copypaste") {
	&parseCopyPaste;
	
} elsif ($func eq "gather") {
	
	################################
	# Print list of messages
	################################

	if ($date eq "NULL") {
		&showHeaderBackHTML("Choose the messages to retrieve above");
		exit();
	}
	
	# What's today?
	($tsec, $tmin, $thr, $tday, $tmon, $tyr, $tdow, $tdoy, $tdls) = localtime(time());
	$tmon += 1;
	
	$todaystart = time() - ($thr * 3600) - ($tmin * 60) - $tsec;
	$todayend = $todaystart + 86400;
	
	# Print out a header
	if ($date eq "ALL") {
		$head = "All Messages with Attachments";
	} else {
		$head = "Messages with Attachments Recommended for Deletion";
	}

	# Get the posts

	$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FALL";
	if (! -e $dbfile) {
		$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FNEW";
	}
	
	foreach (`$prtDB $dbfile -tbtree -a -q`) {
		# Ignore errors. May be caused by no data in database.
	
		($key, $value) = split(/\t/, $_);
		$value = &UnEscape($value);
	
		($id, $j, $j, $j, $j, $upload) = split(/\t/, $value);
		$file = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DIR_FORUMUPLOADS . "/" . $id;
		if ($upload ne "" && -e $file) {
			push (@keys, $key);
			push (@ids, $id);
			push (@values, $value);
			push (@filenames, $upload);
			push (@filesizes, -s $file);
		}
	}
	
	$helplink = "file=MessageAttachmentsDeleteCORP_Admin.html";
	$helplink .= "&anchor=DeleteAttachmentEdtFSummary";
	$helplink .= "&helptitle=Delete%20Attachments%20Editing%20Frame";
	
	&showHeaderBackHTML($head, "", 0, 0, 0, $helplink);
	
	# Print some javascript to select multiple boxes
	&printCheckSelJS;
	&printJavascript;
	&printAllMsgData;
	
##########################################################	
	
} elsif ($func eq "nothing" ) {

	&printEmptyTaskFrame("Choose the messages to retrieve in the frame above.");
	
} elsif ($func eq "menu") {
	$helplink = "file=MessageAttachmentsDeleteCORP_Admin.html";
	$helplink .= "&anchor=DeleteAttachmentsTskFSummary";
	$helplink .= "&helptitle=Delete%20Attachments%20Task%20Frame";

	&showHeaderBackHTML("Delete Attachments from $CorF - $Class",
		"", 0, 1, 0, $helplink);
	
	&printResetJavascript;

	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	print "<tr><td valign=middle align=left>";
	print $FontFace, $FontSize;
	print "Total disk space used by attachments is: <b>";
	if ($space < 1024) {
		print $space, "</b> Bytes ";
	} elsif ($space < 1024 * 1024) {
		print sprintf("%d", $space / 1024), "</b> Kilobytes ";
	} elsif ($space < 1024 * 1024 * 1024) {
		print sprintf("%.1f", $space / (1024 * 1024)), "</b> Megabytes ";
	} else {
		print sprintf("%.2f", $space / (1024 * 1024 * 1024)), "</b> Gigabytes ";
	}
	print "in <b>", $#files + 1, "</b> files.";
	print "<br>\n";
	if ($C_UploadDiskSpace == 0) {
		print "There is no Disk Space Limit.\n";
	} else {
		print "Disk Space Limit for Attachments is: <b>";
		if ($C_UploadDiskSpace >= 1024) {
			print $C_UploadDiskSpace / 1024, "</b> Gigabytes. ";
		} else {
			print $C_UploadDiskSpace, "</b> Megabytes. ";
		}
	}
	
	if (($space > $C_UploadDiskSpace * 1024 * 1024) && $C_UploadDiskSpace != 0){
		print "<br>", $FontRed;
		print "Disk Space limit has been Exceeded!</font>\n";
	}
	
	print "</td></tr>\n\n";
	
	# Start Form
	print "<form action=$CGIEnvScript method=POST target=msgdel>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";
	print "<input type=hidden name=func value=gather>\n\n";
	
	print "<tr><td valign=middle align=left>";
	print $FontFace, $FontSize;
	print "Display: ";
	print "<select name=date>";
	print "<option value=ALL> All Messages With Attachments\n";
	if ($space > $C_UploadDiskSpace * (1024 * 1024)) {
		print "<option value=REC> Messages With Attachments Recommended for Deletion\n";
	}
	print "</select>";
	print $BtnFormSubmit;
	print $BtnFormClear;
	
	print "</td></tr>\n\n";
	
	print "</form>\n";
	
	# Copy and paste a message url
	
	print "<form action=$CGIEnvScript method=POST target=msgdel>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";
	print "<input type=hidden name=func value=copypaste>\n\n";
	
	# Spacer/divider
	print "<tr><td>$ImgIndentSmall</td></tr>\n\n";
	print "<tr><td bgcolor=$FTheaderback>$ImgClearDot</td></tr>\n\n";
	print "<tr><td>$ImgIndentSmall</td></tr>\n\n";
	
	print "<tr><td valign=top>", $FontFace, $FontSize;
	print "Copy and paste the URL of a message here to select it's attachment for deletion.";
	print "<br>\n";
	print "<input type=text name=MsgDelURL size=60>\n";
	print $BtnFormSubmit;
	print $BtnFormClear;
	
	print "<br>";
	print "(e.g. /Forum/cgi-bin/FVwMsgThr.cgi?fid=Forum&tid=Practice&mid=12)\n";
	
	print "</td></tr>\n";
	
	print "</form>\n";

	print "</table>\n";
} else {

	# Print out frameset
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Forum Attachment Deletion</title>\n";
	&printJavascript();
	print "</head>\n";
	print "<frameset rows='200,*' border=2>\n";
	print "	<frame name=msgdelmenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=msgdel src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

#
########

sub parseCopyPaste {
	$MsgDelURL = $CGIQuery->param('MsgDelURL');
	
	if ($MsgDelURL !~ /\?/) {
		&showErrorBackHTML("The URL did not contain a query string.");
		exit();
	}
	
	if ($MsgDelURL !~ /mid/) {
		&showErrorBackHTML("The URL did not contain a valid message ID (msgid)");
		exit();
	}
	
	if ($MsgDelURL !~ /tid/) {
		&showErrorBackHTML("The URL did not contain a valid topic specification (tid)");
		exit();
	}
	
	($junk, $qstring) = split(/\?/, $MsgDelURL);
	
	# Remove anchor
	$qstring =~ s/\#.*$//;
	
	$parseIt = new CGI($qstring);
	
	$id = $parseIt->param('mid');
	$subject = $parseIt->param('tid');
	
	if ($id =~ /\./) {
		@gettop = split(/\./, $id);
		$topid = @gettop[0];
	} else {
		$topid = $id;
	}
	
	$upload = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DIR_FORUMUPLOADS . "/" . $id;
	
	if (! -e $upload) {
		&showErrorBackHTML("The selected attachment does not exist.");
		exit();
	}

	$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$subject/$topid" . ".db";
	
	if (! -e $dbfile) {
		&showErrorBackHTML("The message database, $dbfile, was not found.");
		exit();
	}
	
	$value = "";

	($key, $value) = split(/\t/, `$prtDB $dbfile -tbtree -q -k \"$id\"`);
	$value = &UnEscape($value);
	chomp($value);
	
	$status = &dbErrorCheck($?, $key);
	
	if ($value eq "" || $status ne "") {
		&showErrorBackHTML("The selected message does not exist.");
		exit();
	}
	
	($II, $title, $poster, $posterperm, $posttime, $j, $j, $j, $j, $u, @junk) = split(/\t/, $value);
	($u, $j) = split(/\:/, $u);
	
	@keys[0] = $posttime;
	@values[0] = "$id\t$subject\t$title\t$poster\t$posterperm\t$upload";
	@filenames[0] = $u;
	@filesizes[0] = (-s $upload);
	@ids[0] = $key;
	
	$helplink = "file=MessageAttachmentsDeleteCORP_Admin.html";
	$helplink .= "&anchor=DeleteAttachmentEdtFSummary";
	$helplink .= "&helptitle=Delete%20Attachments%20Editing%20Frame";
	
	&showHeaderBackHTML("Selected Message", "", 0, 0, 0, $helplink);
	
	# print $value;
	
	&printCheckSelJS;
	&printJavascript;
	&printAllMsgData;
}

sub printAllMsgData {
	if (@keys > 0) {
		print "<form action=$CGIEnvScript method=POST>\n";
		print "<input type=hidden name=fid value=$Class>\n";
		print "<input type=hidden name=func value=domsgdel>\n";
	}
	
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	
	if (@keys > 0) {
		print "<tr bgcolor=$FCmsgheadhilight>";
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Delete &nbsp;Attachment$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Date$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Topic$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Title$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;User&nbsp;ID$ImgIndent";
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;File Name$ImgIndent";
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;File&nbsp;Size$ImgIndent";
		print "</td>\n";
		print "</tr>\n\n";
	
		print "<tr><td colspan=13 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
	}
	
	if (@keys > 0 && $date eq "REC") {
		$dir = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DIR_FORUMUPLOADS . "/";
		$limit = $C_UploadDiskSpace * 1024 * 1024;
		for ($i=0; $i < @keys; $i++) {
			if ($space > $limit) {
				@show[$i] = 1;
				$file = $dir . @ids[$i];
				$space = $space - (-s $file);
			} else {
				@show[$i] = 0;
			}
		}
	}
	
	$U_PermsOrig = $U_Perms;
	
	for ($i=0; $i < @keys; $i++) {
		if ($date eq "REC" && @show[$i] == 0) {
			next;
		}
	
		($msgid, $subject, $title, $poster, $posterperm, $upload) = split(/\t/, @values[$i]);
		$pdate = &formatDate(@keys[$i]);
		
		if ($i % 2) {
			$bg = " bgcolor=$FCmsghilight";
		} else {
			$bg = "";
		}
		
		$allowdel = 1;
		if (! &IS_ADMIN($U_PermsOrig)) {
			if (&IS_FAC($U_PermsOrig) && ($C_ModDeleteAll eq "0" || $C_ModDeleteAll eq "")) {
				# Have to check to see if this moderator can delete this post
				&lookupUser($poster);
				
				if ($U_C_Sect =~ /\:/) {
					($junk, $snum) = split(/\:/, $U_C_Sect);
				} else {
					$snum = $U_C_Sect;
				}
				if ($C_Sects{$snum}{"fac"} eq $CGIEnvUser) {
					$allowdel = 1;
				} else {
					$allowdel = 0;
				}
				
				if ($poster eq "Guest" || $poster eq "Anonymous") {
					$allowdel = 0;
				}
			}
		}
		
		print "<tr", $bg, ">";
		print "<td align=center", $bg, ">", $FontFace, $FontSize;
		if ($allowdel) {
			print "<input type=checkbox name=delmsg value=\"$msgid\">";
		} else {
			print "&nbsp;";
		}
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, " nowrap>", $FontFace, $FontSize;
		print "&nbsp;", $pdate, $ImgIndent;
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, " nowrap>", $FontFace, $FontSize;
		print "&nbsp;<b>";
		print &printPretty(&unEscapeTopic($subject));
		print $ImgIndent;
		print "</b></td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, " nowrap>", $FontFace, $FontSize;
		print "&nbsp;";
		print "<a href=\"javascript:openwin('";
		print $CGI_ForumViewMsgThread, "?fid=$Class\&tid=$subject";
		print "\&mid=$msgid\#$msgid','600','400','msgview')\">";
		print $title, "</a>", $ImgIndent;
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, ">", $FontFace, $FontSize;
		print "&nbsp;", $poster, $ImgIndent;
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, ">", $FontFace, $FontSize;
		print "&nbsp;", unescape(@filenames[$i]), $ImgIndent;
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, ">", $FontFace, $FontSize;
		print "&nbsp;";
		if (@filesizes[$i] < 1024) {
			print @filesizes[$i], " B";
		} elsif (@filesizes[$i] < 1024 * 1024) {
			print sprintf("%d", @filesizes[$i] / 1024), " K";
		} elsif (@filesizes[$i] < 1024 * 1024 * 1024) {
			print sprintf("%.1f", @filesizes[$i] / (1024 * 1024)), "M";
		} else {
			print sprintf("%.2f", @filesizes[$i] / (1024 * 1024 * 1024)), "G";
		}
		
		print $ImgIndent;
		print "</td>\n";
		
		print "</tr>\n\n";
		
	}
	
	if (@keys == 0) {
		print "<tr><td colspan=13>";
		print "$ImgIndent</td></tr>\n\n";
	
		print "<tr><td colspan=13>", $FontFace, $FontSize;
		print "No attachments found in the selected range.</td></tr>\n\n";
	} elsif (@keys > 1) {
		print "<tr><td colspan=13 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
		
		print "<tr><td>", $FontFace, $FontSize;
		print "&nbsp;<a href=javascript:selectAll('delmsg')>Select&nbsp;All</a>$ImgIndent";
		print "<br>&nbsp;<a href=javascript:deselectAll('delmsg')>Deselect&nbsp;All</a>";
		print "<br>&nbsp;<a href=javascript:selectInverse('delmsg')>Select&nbsp;Inverse</a>";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td colspan=11>";
		print "$ImgClearDot</td></tr>\n\n";
		
		print "<tr><td colspan=13 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
	} else {
		print "<tr><td colspan=13 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
	}
	
	if (! &IS_ADMIN($U_PermsOrig) && @keys > 0) {
		print "<tr><td colspan=13>", $FontFace, $FontSize;
		print "<br>$FontRed Note:</font>\n";
		print "If there are no checkboxes next to a post, ";
		print "it means you do not have permission to delete that post.\n";
		print "</td></tr>\n";
	}
	
	if (@keys > 0) {
		print "<tr><td colspan=13>", $FontFace, $FontSize;
		if (&IS_ADMIN($U_PermsOrig)) {
			print "<br>";
		}
		print "$FontRed Note:</font>\n";
		print "Click the title to view the post content.\n";
		print "From there you can view the attachment.\n";
		print "<br>&nbsp;</td></tr>\n";
	}
	
	print "</table>\n";
	
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</form>\n";
	print "</body></html>\n";
}

sub doMsgsDel {
	local($i, $j);

	@delmsg = $CGIQuery->param('delmsg');
	
	&showHeaderBackHTML("Deleting Attachments");
	
	# Finally individual messages
	for ($i=0; $i < @delmsg; $i++) {
		$file = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DIR_FORUMUPLOADS . "/" . @delmsg[$i];
		if (unlink($file)) {
			print "Deleted Attachment with ID: ", @delmsg[$i], "<br>\n";
		} else {
			print "Unable to Delete File: ", $file, "!>br>\n";
		}
	}
	
	print "<p>Finished!\n";
	
}
